﻿using System;
using Excel = Microsoft.Office.Interop.Excel ;

namespace ExcelLibrary
{
    public class ExcelSheet
    {
        object misValue = System.Reflection.Missing.Value;

        // une application Excel
        private Excel.Application xlApp;
        // un classeur Excel 
        private Excel.Workbook xlWorkBook;
        // une feuille excel 
        private Excel.Worksheet xlWorkSheet;
        // le chemin vers le fichier
        private String _pathfile = "";
        // le n° de feuille excel
        private int _NumSheet;
        //_DEBUG true to make excel visible
        Boolean _DEBUG = false;

        /// <summary>
        /// la String du chemin d'accès au fichier
        /// </summary>
        public String PathFile
        {
            get { return _pathfile; }
            set { _pathfile = value; }
        }

        public int NumSheet
        {
            get { return _NumSheet; }
            set { _NumSheet = value; }
        }

        // constructeurs de l'application excel

        // constructeur par défaut
        public ExcelSheet()
        {
            xlApp = new Excel.Application();
            xlApp.Visible = false;
            Excel.Workbook xlWorkBook = xlApp.Workbooks.Add();
        }
        // on peut préciser si mode débug ou non
        public ExcelSheet(Boolean debug)
        {
            _DEBUG = debug;
        }

        /// <summary>
        /// pour créer une instance d'une application Excel qui permettra de manipuler la feuille excel
        /// <param name="ExcelFileName"> le chemin vers le fichier</param>
        /// <param name="ReadOnly">vaut true si on ouvre en lecture seule, false en lecture/écriture</param>
        /// <paramref name="NumSheet"/>le n° de la feuille</param>
        /// </summary>
        public ExcelSheet(String ExcelFileName, int NumSheet, Boolean ReadOnly)
        {
            this.NumSheet = NumSheet;
            PathFile = ExcelFileName;
            // constructeur de l'application excel
            xlApp = new Excel.Application();
            xlApp.Visible = _DEBUG;
            // constructeur du classeur excel à partir d'un fichier 
            try
            {
                xlWorkBook = xlApp.Workbooks.Open(PathFile, 0, ReadOnly
                    , 5, "", "", true, Microsoft.Office.Interop.Excel.XlPlatform.xlWindows, "\t", false, false, 0, true, 1, 0);
            }
            catch (System.Runtime.InteropServices.COMException e)
            {
                Console.WriteLine("Problem to Open File " + ExcelFileName + " : exception : " + e.GetType().Name + e.Message);
                xlWorkBook = xlApp.Workbooks.Add();
                Save(PathFile);
                Console.WriteLine("File " + PathFile + " is created .");
            }
            try
            {
                // je récupère une feuille excel du classeur dans  xlWorkSheet
                // NumSheet : est le numéro de feuille 
                xlWorkSheet = (Excel.Worksheet)xlWorkBook.Worksheets.get_Item(NumSheet);
            }
            catch (System.Runtime.InteropServices.COMException e)
            {
                Console.WriteLine("Problem to find sheet number " + NumSheet.ToString() + " : exception : " + e.GetType().Name + e.Message);
                NumSheet = 1;
                xlWorkSheet = (Excel.Worksheet)xlWorkBook.Worksheets.get_Item(NumSheet);
                Console.WriteLine("First Sheet is Open");
            }
        }

        /// <summary>
        /// pour sauver les modifications
        /// </summary>
        public void Save()
        {
            object misValue = null;
            try
            {
                xlWorkBook.SaveAs(PathFile, Excel.XlFileFormat.xlWorkbookNormal, misValue, misValue, misValue, misValue, Excel.XlSaveAsAccessMode.xlExclusive, misValue, misValue, misValue, misValue, misValue);
            }
            catch (System.Runtime.InteropServices.COMException e)
            {
                Console.WriteLine("Problem to save file " + PathFile + " : exception : " + e.GetType().Name + e.Message);
                Console.WriteLine("Do you want to create a new file ? Y/N");
                string answer = Console.ReadLine();
                if (answer != "Y")
                    Console.WriteLine("Your file is not saved");
                else
                {
                    Console.WriteLine("Enter New Name (directory will be C:\\Temp): ");
                    this.PathFile = "C:\\Temp\\" + Console.ReadLine();
                    Save();
                }
            }
        }


        /// <summary>
        /// pour sauver les modifications dans un autre fichier
        /// </summary>
        public void Save(String PathFile)
        {
            this.PathFile = PathFile;
            this.Save();
        }

        /// <summary>
        /// lit la cellule Range
        /// </summary>
        /// <param name="Range"> la cellulle sous la forme B12</param>
        /// <returns>le contenu de la cellulle sous forme de chaine</returns>
        public String ReadCell(String Range)
        {
            // je retourne la valeur de la cellule B2
            // cette valeur est la propriété Value2. ToString() la convertit en chaine de caractères
            // dans le cas d'une cellule de type double, je peux récupérer la valeur avec : double a = xlWorkSheet.get_Range("B2").Value2;
            return (xlWorkSheet.get_Range(Range).Value2.ToString());
        }

        /// <summary>
        /// lit la cellule de ligne line et de colonne column
        /// </summary>
        public String ReadCell(int line, int column)
        {
            // autre notation pour accéder à B2 : Cells[2,2] avec le num de ligne, le num de colonne. Pratique si on veut remplacer ces deux valeurs par des variables
            return (xlWorkSheet.Cells.Cells[line, column].Value2.ToString());
        }

        /// <summary>
        /// écrit value dans la cellulle (line,column)
        /// </summary>
        /// <param name="Value">la valeur à écrire</param>
        /// <param name="line">la ligne</param>
        /// <param name="column">la colonne</param>
        public void WriteCell(String Value, int line, int column)
        {
            xlWorkSheet.Cells[line, column].Formula = Value;
        }

        /// <summary>
        /// écrit value dans la cellulle Range
        /// </summary>
        /// <param name="Value">la valeur à écrire</param>
        /// <param name="Range">la cellulle sous la forme B3</param>
        public void WriteCell(String Value, String Range)
        {
            xlWorkSheet.get_Range(Range).Formula = Value;
        }


        /// <summary>
        /// pour fermer le fichier. indispensable sinon il reste ouvert et plus aucune application ne peut l'ouvrir
        /// </summary>
        public void Close()
        {
            xlWorkSheet = null;
            try
            {
                xlWorkBook.Close(false, Type.Missing, Type.Missing);
            }
            catch (System.Runtime.InteropServices.COMException e)
            {
                Console.WriteLine("Problem to close the WorkBook " + PathFile + " : exception : " + e.GetType().Name + e.Message);
            }
            xlWorkBook = null;
            try
            {
                xlApp.Quit();
            }
            catch (System.Runtime.InteropServices.COMException e)
            {
                Console.WriteLine("Problem to quit the Excel App " + " : exception : " + e.GetType().Name + e.Message);
            }

            xlApp = null;
        }
    }
}
