﻿using System;
using System.Timers;
using System.Collections;
using System.Collections.Generic;
using WComp.Beans;

namespace GenEntree
{

	public class CircularBuffer
	{
		private List<MyEvent> buffer; //type de buffer:tableau
		private int head;//la tête du buffer
		private int tail;//la queue du buffer
		private int length;// la longueur du buffer
		private int bufferSize;//la taille du buffer
		object _lock = new object();//un objet pour controler les threads(pour le cas de l'encapsulation ou la décapsulation)
		
		public CircularBuffer(int bufferSize)
		{
			this.bufferSize = bufferSize;
			this.head = 0;
			this.tail=0;
			this.buffer = new List<MyEvent>(bufferSize);
			
		}

		public List<MyEvent> evtbuffer
		{
			get { return buffer; }
			set	{ buffer = value; }
		}

		public int evtbufferSize
		{
			get	{ return bufferSize; }
			set	{ bufferSize = value; }
		}


		public int evtbufferLength
		{
			get	{
				length=((bufferSize+head)-tail)%bufferSize;
				return length  ;
			}
		}
		
		public bool IsEmpty()
		{
			if (length == 0)
				return true	;
			return false;
		}
		
		public bool IsFull()
		{
			if (length == bufferSize-1)
				return true;
			return false;
		}

		public void Dequeue(MyEvent dequeued)
		{
			lock (_lock)
			{
				if (IsEmpty()) throw new InvalidOperationException("Empty Buffer!!!!!");
				
				//dequeued = buffer[tail];

				buffer.Remove(dequeued);
				tail = NextPosition(tail);
				//length --;
				//tail=tail--;
				//return dequeued;
			}
			
		}

		private int NextPosition(int position)
		{
			return (position + 1) % bufferSize;
		}

		public void Enqueue(MyEvent evtToAdd)
		{
			lock (_lock)
			{
				if (IsFull()) throw new InvalidOperationException("Full Buffer!!!!!");
				buffer.Add(evtToAdd);
				head = NextPosition(head);
			}
		}
	}
}


