# coding=utf-8
# Gatien Chapon & Gregory Robin
#
# Service pour la récupération de la pression atmospherique
#
from pyupnp.event import EventProperty
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
import time 

class BarometerService(Service):
    version = (1, 0)
    serviceType = "urn:schemas-upnp-org:service:BarometerService:1"
    serviceId = "urn:upnp-org:serviceId:BarometerService"
    actions = {
        'GetPressure': [
            ServiceActionArgument('Presure','out','Presure')
        ],
        'GetAltitude': [
            ServiceActionArgument('Altitude','out','Altitude')
        ]
    }
    stateVariables = [
        ServiceStateVariable('Presure', 'string', sendEvents=True),
        ServiceStateVariable('Altitude', 'string', sendEvents=True)

    ]
    presure_value=EventProperty('Presure')
    altitude_value=EventProperty('Altitude')

    def listen_Barometer_change(self,s):
        while True:
			self.presure_value = s.pressure
			self.altitude_value = s.altitude
			time.sleep(0.5)
        return

    @register_action('GetPressure')
    def getPressure(self):
        return {
            'Presure' : str(self.presure_value)
        }
    @register_action('GetAltitude')
    def getAltitude(self):
        return {
            'Altitude' : str(self.altitude_value)
        }

