# coding=utf-8
# Gatien Chapon & Gregory Robin
#
# Service pour la récupération de la température et le l'humidité ambiante
#
from pyupnp.event import EventProperty
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
import time

class HumidityTempService(Service):
    version = (1, 0)
    serviceType = "urn:schemas-upnp-org:service:HumidityTempService:1"
    serviceId = "urn:upnp-org:serviceId:HumidityTempService"
    actions = {
        'GetHumidity': [
            ServiceActionArgument('Humidity','out','Humidity')
        ],
        'GetTemp': [
            ServiceActionArgument('Temp','out','Temp')
        ]
    }
    stateVariables = [
        ServiceStateVariable('Humidity', 'string', sendEvents=True),
        ServiceStateVariable('Temp', 'string', sendEvents=True)

    ]
    humidity_value=EventProperty('Humidity')
    temp_value=EventProperty('Temp')

    def listen_HumidityTemp_change(self,s):
        while True:
			self.humidity_value = s.humidity
			self.temp_value =s.temp
			time.sleep(0.5)
        return

    @register_action('GetHumidity')
    def getHumidity(self):
        return {
            'Humidity' : str(self.humidity_value)
        }
    @register_action('GetTemp')
    def getTemp(self):
        return {
            'Temp' : str(self.temp_value)
        }
