# coding=utf-8
from threading import Thread
from twisted.internet import reactor
from pyupnp.device import Device, DeviceIcon
from pyupnp.ssdp import SSDP
from pyupnp.upnp import UPnP
from smartDryingServices.humidityTemp import HumidityTempService
from smartDryingServices.led import LedManagerService
from smartDryingServices.magnetic import MagneticService
from smartDryingServices.barometer import BarometerService
from smartDryingServices.gps import GPSService
from sensorReader.sensor_value import SensorValue
from sensorReader.ThreadReadSensorValues import ThreadReadSensorValues


# Classe generale permettant dexposer les services rendus par smart drying
# utilisation de la librairie UPNP python PyUPNP disponible à l'adresse suivante :
# https://github.com/fuzeman/PyUPnP
#
class SmartDryingServerDevice(Device):
		deviceType = 'urn:schemas-upnp-org:device:SmartDryingServer:1'
		friendlyName = "Smart Drying"
		
		def __init__(self):
			Device.__init__(self)
			self.sensorValues = SensorValue()
			ThreadReadSensorValues(self.sensorValues).start()
			self.uuid = '0a888692-350c-4c7b-858c-913dedeec347'
			self.ledservice = LedManagerService()
			self.magneticservice = MagneticService()
			self.humidityTempService = HumidityTempService()
			self.barometerService = BarometerService()
			self.gpsService = GPSService()
			self.services = [
				self.ledservice,
				self.magneticservice,
				self.humidityTempService,
				self.barometerService,
				self.gpsService
			]

			print "Démarrage service ! "
			#On demarre le service de detection de linge dans un thread apart
			self.threadMagneticSensor = Thread(target=MagneticService.listen_magnetic_change, args = (self.magneticservice,self.sensorValues))
			self.threadMagneticSensor.start()
			#On demarre le service pour la mise a jour de la température et de l'humidite
			self.threadHumiditySensor = Thread(target=HumidityTempService.listen_HumidityTemp_change, args = (self.humidityTempService,self.sensorValues))
			self.threadHumiditySensor.start()
			#On demarre le service pour le barometre
			self.thredBarometer = Thread(target=BarometerService.listen_Barometer_change, args = (self.barometerService,self.sensorValues))
			self.thredBarometer.start()
			#On demarre le service pour la localisation GPS
			self.thredGPS = Thread(target=GPSService.listen_gps_change, args = (self.gpsService,self.sensorValues))
			self.thredGPS.start()
			self.icons = [DeviceIcon('image/png', 32, 32, 24,'http://172.25.3.103:52323/MediaRenderer_32x32.png')]



if __name__ == '__main__':
	#Logr.configure(logging.DEBUG)
	device = SmartDryingServerDevice()

	upnp = UPnP(device)
	ssdp = SSDP(device)

	upnp.listen()
	ssdp.listen()
	
	reactor.run()