from threading import Thread
import time
from sensor_value import SensorValue
from threading import Lock

class ThreadReadSensorValues(Thread):
	mutex = Lock()
	def __init__(self, sensorValues):
		''' Constructor. '''
		Thread.__init__(self)
		self.sensorValues = sensorValues

	def run(self):
		while True:
			self.mutex.acquire(1)
			self.sensorValues.update_barometer_values()
			self.sensorValues.update_humidity_values()
			self.sensorValues.update_magnetic_value()
			self.sensorValues.update_gps_value()
			self.mutex.release()
			time.sleep(0.5)
			

