import smbus
import RPi.GPIO as GPIO
import time
from lib.grove_i2c_barometic_sensor_BMP180 import BMP085
from grovepi import grovepi

bmp = BMP085(0x77, 1)
sensor_humidity = 3
rev = GPIO.RPI_REVISION
if rev == 2 or rev == 3:
    bus = smbus.SMBus(1)
else:
    bus = smbus.SMBus(0)

magnetic_switch = 5
grovepi.pinMode(magnetic_switch, "INPUT")

class SensorValue():

	def __init__(self): # Notre methode constructeur
		self.pressure = 0
		self.altitude = 0
		self.humidity = 0
		self.temp = 0
		self.gps = ""
		self.magnetic = False #True si l'aimant est detecte, False sinon

	def update_barometer_values(self):
		self.pressure = bmp.readPressure()
		self.altitude = bmp.readAltitude(101560)
	def update_humidity_values(self):
		[self.temp,self.humidity] = grovepi.dht(sensor_humidity,1)
	def update_magnetic_value(self):
		res = grovepi.digitalRead(magnetic_switch)
		if (res == 1):
			self.magnetic = False
		if (res == 0):
			self.magnetic = True
	def update_gps_value(self):
		self.gps="43.615244,7.071806"
	def print_info(self):
		print "Pressure :", self.pressure, "Altitude : ", self.altitude," Humidity : ",self.humidity , "Temperature :", self.temp,"Magnetic : ",self.magnetic,"GPS :",self.gps,""



