# coding=utf-8
# Gatien Chapon & Gregory Robin
#
# Service pour la localisation par GPS
#
from pyupnp.event import EventProperty
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
from sensorReader.sensor_value import SensorValue
import time


class GPSService(Service):
    version = (1, 0)
    serviceType = "urn:schemas-upnp-org:service:GPSService:1"
    serviceId = "urn:upnp-org:serviceId:GPSService"
    actions = {
        'GetLocalisation': [
            ServiceActionArgument('Localisation','out','Localisation')
        ]
    }

    stateVariables = [
        ServiceStateVariable('Localisation', 'string', sendEvents=True)

    ]
    state=EventProperty('Localisation')

    def listen_gps_change(self,s):
        while True:
			self.state = s.gps
			time.sleep(0.5)
        return

    @register_action('GetLocalisation')
    def getLocalisation(self):
        return {
            'Localisation' : self.state
        }
