# coding=utf-8
# Gatien Chapon & Gregory Robin
#
# Service permettant la gestion d'allumage de la led verte et rouge
# Une seule fonction exposé :
# SetLightStatus("ON"|"OFF","RED"|"GREEN") permettant l'allumage et l'extinction des leds

from grovepi import grovepi
from pyupnp.event import EventProperty
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
from sensorReader.ThreadReadSensorValues import ThreadReadSensorValues

led_green = 6
led_red = 4

grovepi.pinMode(led_green,"OUTPUT")
grovepi.pinMode(led_red,"OUTPUT")

def changeStatusRed(status):
    ThreadReadSensorValues.mutex.acquire(1)
    if(status == "ON"):
        grovepi.analogWrite(led_red,255)
    else:
        grovepi.analogWrite(led_red,0)
    ThreadReadSensorValues.mutex.release()

def changeStatusGreen(status):
    ThreadReadSensorValues.mutex.acquire(1)
    if(status == "ON"):
        grovepi.analogWrite(led_green,255)
    else:
        grovepi.analogWrite(led_green,0)
    ThreadReadSensorValues.mutex.release()


def changeColor(color):
    if(color == "GREEN"):
        changeStatusGreen("ON")
        changeStatusRed("OFF")
    else:
        changeStatusGreen("OFF")
        changeStatusRed("ON")


class LedManagerService(Service):
    version = (1, 0)
    serviceType = "urn:schemas-upnp-org:service:Led:1"
    serviceId = "urn:upnp-org:serviceId:Led"
    actions = {
        'SetLightGreenAndRed' : [
            ServiceActionArgument('Color','in','A_ARG_TYPE_Color')
        ],
        'SetLightRed' : [
            ServiceActionArgument('Status','in','A_ARG_TYPE_Status')
        ],
        'SetLightGreen' : [
            ServiceActionArgument('Status','in','A_ARG_TYPE_Status')
        ],
        'GetGreenLightStatus' : [
            ServiceActionArgument('Green_Status','out','Green_Status')
        ],
        'GetRedLightStatus' : [
            ServiceActionArgument('Red_Status','out','Red_Status')
        ]
    }
    stateVariables = [
        ServiceStateVariable('A_ARG_TYPE_Color','string'),
        ServiceStateVariable('A_ARG_TYPE_Status','string'),
        ServiceStateVariable('Green_Status', 'string'),
        ServiceStateVariable('Red_Status', 'string')
    ]
    green_light = 'none'
    red_light = 'none'

    @register_action('SetLightRed')
    def setLightRed(self,status):
        if(status == "ON"):
            changeStatusRed("ON")
            self.red_light = 'ON'
        else:
            changeStatusRed("OFF")
            self.red_light = 'OFF'

    @register_action('SetLightGreen')
    def setLightGreen(self,status):
        if(status == "ON"):
            changeStatusGreen("ON")
            self.green_light = 'ON'
        else:
            changeStatusGreen("OFF")
            self.green_light = 'OFF'

    @register_action('SetLightGreenAndRed')
    def setLightGreenAndRed(self,color):
        if(color == "RED"):
            changeColor(color)
            self.green_light = 'OFF'
            self.red_light ='ON'
        elif(color == "GREEN"):
            changeColor(color)
            self.green_light = 'ON'
            self.red_light ='OFF'

    @register_action('GetGreenLightStatus')
    def getGreenLedStatus(self):
        return {
            'Green_Status' : self.green_light
        }
    @register_action('GetRedLightStatus')
    def getRedLedStatus(self):
        return {
            'Red_Status' : self.red_light
        }


