# coding=utf-8
# Gatien Chapon & Gregory Robin
#
# Service gérant la detection de linge grace au capteur magnetic
#
from pyupnp.event import EventProperty
from pyupnp.services import register_action, Service, ServiceActionArgument, ServiceStateVariable
from sensorReader.sensor_value import SensorValue
import time


class MagneticService(Service):
	version = (1, 0)
	serviceType = "urn:schemas-upnp-org:service:MagneticService:1"
	serviceId = "urn:upnp-org:serviceId:MagneticService"
	actions = {
		'GetHaveClothesState': [
			ServiceActionArgument('HaveClothes','out','HaveClothes')
		]
	}
	
	stateVariables = [
        ServiceStateVariable('HaveClothes', 'boolean', sendEvents=True)
		
	]
	state=EventProperty('HaveClothes')
	
	def listen_magnetic_change(self,s):
		while True:
			self.state = s.magnetic
			time.sleep(0.5)
		return
	
	@register_action('GetHaveClothesState')
	def getState(self):
		return {
			'HaveClothes' : self.state
		}
	