﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: user
 * Date: 17/01/2017
 * Heure: 14:39
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using WComp.Beans;
using WComp.Util;

namespace WComp.Beans
{
	/// <summary>
	/// This is a sample bean, which has an integer evented property and a method.
	/// 
	/// Notes: for beans creating threads, the IThreadCreator interface should be implemented,
	/// 	providing a cleanup method should be implemented and named `Stop()'.
	/// For proxy beans, the IProxyBean interface should  be implemented,
	/// 	providing the IsConnected property, allowing the connection status to be drawn in
	/// 	the AddIn's graphical designer.
	/// 
	/// Several classes can be defined or used by a Bean, but only the class with the
	/// [Bean] attribute will be available in WComp. Its ports will be all public methods,
	/// events and properties definied in that class.
	/// </summary>
	[Bean(Category="SmartDrying")]
	public class MeteoPredict
	{
		/// <summary>
		/// Fill in private attributes here.
		/// </summary>
		private string main;
		private bool humidity;
		private bool haveClothes;
		/// <summary>
		/// This property will appear in bean's property panel and bean's input functions.
		/// </summary>
		public string MyMain {
			get { return main; }
			set {
				main = value;
				isBad(main,humidity,haveClothes);		// event will be fired for every property set.
			}
		}
		
		public bool MyHumidity {
			get { return humidity; }
			set {
				humidity = value;
				isBad(main,humidity,haveClothes);		// event will be fired for every property set.
			}
		}
		public bool MyhaveClothes {
			get { return haveClothes; }
			set {
				haveClothes = value;
				isBad(main,humidity,haveClothes);		// event will be fired for every property set.
			}
		}

		/// <summary>
		/// A method sending an event, which is here simply the argument + 1.
		/// Note that there is no return type to the method, because we use events to send
		/// information in WComp. Return values don't have to be used.
		/// </summary>
		public void isBad(string predict, bool humide, bool clothes) {
			switch (predict){
				case "Clouds":
					if(humide  && clothes){
						FireBoolEvent(true);	
				
					}else if (humide){
						FireLightEvent("RED"); 
						FireBoolEvent(false);
					}else {
						FireLightEvent("GREEN"); 
						FireBoolEvent(false);
					}
					break;
				case "Rain":
					if(clothes){
						FireBoolEvent(true);
						
					}else{
						FireBoolEvent(false);
					}
					FireLightEvent("RED"); 
					break;
				case "Snow" : 
					if(clothes){
							FireBoolEvent(true);
								
					}else{
						FireBoolEvent(false);
					}
					FireLightEvent("RED"); 
					break;
				case "Clear":
					FireBoolEvent(false);
					FireLightEvent("GREEN"); 
					Logger.Info("Le temps est clair j'envoi false");
					break;
				case "Mist":
					if(humide && clothes){
						FireBoolEvent(true);
					}else if(humide){
						FireLightEvent("RED"); 
						FireBoolEvent(false);
					}
					break;
			}
		}

		public delegate void StringLightGreenRed(string light);
		public delegate void IntValueEventHandler(bool val);
		
		public event IntValueEventHandler PropertyChanged;
		public event StringLightGreenRed  greenRedStatus;
		
		private void FireLightEvent(string color){
			if(greenRedStatus != null){
				greenRedStatus(color);
			}
		}
		
		private void FireBoolEvent(bool i) {
			if (PropertyChanged != null)
				PropertyChanged(i);
		}
	}
}
