﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: user
 * Date: 24/01/2017
 * Heure: 10:19
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using DryingTime;
using WComp.Beans;
using System.Threading;

namespace WComp.Beans
{
	/// <summary>
	/// This is a sample bean, which has an integer evented property and a method.
	/// 
	/// Notes: for beans creating threads, the IThreadCreator interface should be implemented,
	/// 	providing a cleanup method should be implemented and named `Stop()'.
	/// For proxy beans, the IProxyBean interface should  be implemented,
	/// 	providing the IsConnected property, allowing the connection status to be drawn in
	/// 	the AddIn's graphical designer.
	/// 
	/// Several classes can be defined or used by a Bean, but only the class with the
	/// [Bean] attribute will be available in WComp. Its ports will be all public methods,
	/// events and properties definied in that class.
	/// </summary>
	[Bean(Category="SmartDrying")]
	public class TimeToDry
	{
		public TimeToDry()
		{
			this.calculTime = new CalculateTimeThread();
			this.calculThread = new Thread(calculTime.DoWork);
			calculThread.Start();
		}
		
		/// <summary>
		/// Fill in private attributes here.
		/// </summary>
		private bool haveClothes;
		private CalculateTimeThread calculTime;
		private Thread calculThread;
		/// <summary>
		/// This property will appear in bean's property panel and bean's input functions.
		/// </summary>
		public bool haveClothesProperty {
			get { return haveClothes; }
			set {
				haveClothes = value;
				FireBoolEvent(haveClothes);		// event will be fired for every property set.
			}
		}

		/// <summary>
		/// A method sending an event, which is here simply the argument + 1.
		/// Note that there is no return type to the method, because we use events to send
		/// information in WComp. Return values don't have to be used.
		/// </summary>
		public void Time(bool arg) {
			if(haveClothes.Equals(false) && arg.Equals(true)){
				calculTime.ResquestStart();
				haveClothes=arg;
				FireBoolEvent(haveClothes);
			}
			if(haveClothes.Equals(true) && arg.Equals(false)){
				TimeSpan duration = calculTime.RequestStop();
			   	FireStringEvent(duration.Hours+"h "+duration.Minutes+"min "+duration.Seconds+"s");
			   	haveClothes=arg;
				FireBoolEvent(haveClothes);
			   }
		}
		public void getInstantTime(){
			DateTime endTime = DateTime.Now;
			DateTime startTime = calculTime.startTime;
			TimeSpan duration = endTime - startTime;
			InstantTime(duration.Hours+"h "+duration.Minutes+"min "+duration.Seconds+"s");
		}

		/// <summary>
		/// Here are the delegate and his event.
		/// A function checking nullity should be used to fire events (like FireIntEvent).
		/// </summary>
		public delegate void BoolValueEventHandler(bool val);
		/// <summary>
		/// the following declaration is the event by itself. Its name, here "PropertyChanged",
		/// is the name of the event as it will be displayed in the bean type's interface.
		/// </summary>
		public event BoolValueEventHandler PropertyChanged;
		public delegate void StringValueEventHandler(string val);
		public event StringValueEventHandler StringChanged,getTime;
		
		private void FireBoolEvent(bool i) {
			if (PropertyChanged != null)
				PropertyChanged(i);
		}
		private void FireStringEvent(String i) {
			if (StringChanged != null)
				StringChanged(i);
		}
		private void InstantTime(String i) {
			if (getTime != null)
				getTime(i);
		} 
	}
}
