﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: user
 * Date: 16/01/2017
 * Heure: 19:47
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using System.Threading; // For the thread demo purposes
using WComp.Beans;
using WComp.Util;


namespace WComp.Beans
{
	/// <summary>
	/// This is a sample bean, using a thread, which has an integer evented property and a method 
        ///     to start the thread.
	/// 
	/// Notes: this bean uses the IThreadCreator interface providing a cleanup method named `Stop()'.
	/// Several classes can be defined or used by a Bean, but only the class with the
	/// [Bean] attribute will be available in WComp. Its ports will be all public methods,
	///     events and properties definied in that class.
	/// </summary>
	[Bean(Category="SmartDrying")]
	public class Tic : IThreadCreator {
		private Thread t;	  // Private attributes of the class
		private volatile bool run = false;
		private volatile int sleepVal = 10000;
		
		public int SleepVal {
			get { return sleepVal; }
			set{sleepVal=value; }
		}
				
		public Tic()
		{
			t = new Thread(new ThreadStart(ThreadLoopMethod));
			t.Start();
		}
		 
		
		 // Loop sample
		 public void ThreadLoopMethod() {
			 while(true) {
				 Thread.Sleep(sleepVal);
				 Logger.Info("Un tour de boucle");
				 // Check if the output is connected
				 if(Output_Sample != null){
					 // call the connected methods sequentially
						Output_Sample();		 	
				 }
				// and so on...
			 }
		 
		}
		
		 public void Start() {  // method starting the thread
			if (!run) {
				run = true;
				t = new Thread(new ThreadStart(ThreadLoopMethod));
				t.Start();
			} 
		}
		public void Stop() {   // IThreadCreator defines the Stop() method
			run = false;
		} 
 
		// --- Start: Input port sample ---
		// an input port is a public method (like below)
		//public void Input_Sample(int intParam) {
		//	eventValue = intParam;
			// No return value is expected in WComp:
			// results are given using events
		//}
		// --- End: Input port sample ---
 
		// --- Start: Output port sample ---
		public delegate void Output_Sample_Signature();
		// The delegate defines the signature of the output method
		public event Output_Sample_Signature Output_Sample;
		// The output port is the event, named here Output_Sample
		// --- End: Output port sample ---
	}
}
