﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: user
 * Date: 10/01/2017
 * Heure: 15:51
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using WComp.Beans;
using WComp.Util;
using System.Net;
using weatherBean;


namespace WComp.Beans
{
	/// <summary>
	/// This is a sample bean, which has an integer evented property and a method.
	/// 
	/// Notes: for beans creating threads, the IThreadCreator interface should be implemented,
	/// 	providing a cleanup method should be implemented and named `Stop()'.
	/// For proxy beans, the IProxyBean interface should  be implemented,
	/// 	providing the IsConnected property, allowing the connection status to be drawn in
	/// 	the AddIn's graphical designer.
	/// 
	/// Several classes can be defined or used by a Bean, but only the class with the
	/// [Bean] attribute will be available in WComp. Its ports will be all public methods,
	/// events and properties definied in that class.
	/// </summary>
	[Bean(Category="SmartDrying")]
	public class WheatherBean
	{
		public string lat="43.615562" ;
		public string lon="7.071926";
		public bool isDay = false; 
		
		public bool IsDay {
			get { return isDay; }
		}
		
		
		
		public string Lon {
			get { return lon; }
			set { lon = value; }
		}
		
		public string Lat {
			get { return lat; }
			set { lat = value; }
		}
		
		public void getCoord(String coord){
		 	string [] currentCoord = coord.Split(',');
		 	lat = currentCoord[0];
		 	lon = currentCoord[1];
		 }
		
		public void getMeteo(){
			Logger.Info(" "+lat+" "+lon);
			//Logger.Info(GetWeatherInfo.getWeather(city));
			FireStringEvent(GetWeatherInfo.getWeather(lat,lon));
		}
		public void isNight(){
			Logger.Info(GetWeatherInfo.getSunset(lat,lon));
			FireStringEventSunset(GetWeatherInfo.getSunset(lat,lon));
		}
		public delegate void StringValueEventHandler(string val);
		public event StringValueEventHandler tpsPredictChanged;
		
		public delegate void BoolValueEventHandler(bool val);
		public event BoolValueEventHandler sunsetChanged;
		
		private void FireStringEvent(string i) {
				tpsPredictChanged(i);
		}
		
		private void FireStringEventSunset(bool i) {
			if(i){
				this.isDay = false;
			}else{
				this.isDay = true; 
			}
				sunsetChanged(i);
		}
	}
}
