﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: Lara Arin
 * Date: 13/02/2017
 * Heure: 21:49
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using WComp.Beans;

namespace WComp.Beans
{
	[Bean(Category="HibooTracker")]
	public class BeanEnableDetection
	{
		private bool onOff;

		public bool OnOff {
			get { return onOff; }
			set {
				onOff = value;
				handleNewEvent(onOff, isNotUploading, takePictureOk);
			}
		}

		private bool isNotUploading = true;

		public bool IsNotUploading
		{
			get { return isNotUploading; }
			set
			{
				isNotUploading = value;
				handleNewEvent(onOff, isNotUploading, takePictureOk);
			}
		}

		private bool takePictureOk = true;

		public bool TakePictureOk
		{
			get { return takePictureOk; }
			set
			{
				takePictureOk = value;
				handleNewEvent(onOff, isNotUploading, takePictureOk);
			}
		}

		public delegate void EnableValueEventHandler(bool val);

		public event EnableValueEventHandler EventHandler;
		
		private void FireEnableDetectionEvent(bool enableDetection) {
			if (EventHandler != null)
				EventHandler(enableDetection);
		}

		private void handleNewEvent(bool _onOff, bool _isNotUploading, bool _takePictureOk)
		{
			bool res = _onOff & _isNotUploading & _takePictureOk;
			FireEnableDetectionEvent(res);
		}
	}
}
