using System;
using WComp.Beans;

namespace WComp.Beans
{
	[Bean(Category="HibooTracker")]
	public class BeanPanorama
	{
		private int position = 0;
		private int MIN = 50;
		//private int MAX = 250;
		private int NB_POS_MAX = 5;
		private int STEP = 50;

		public void nextPosition()
		{
			if (position < NB_POS_MAX)
			{
				FireAngleEvent((MIN + STEP * position).ToString());
				position++;
			}
			else
			{
				position = 0;
				FireEndPanoramaEvent(true);
			}
		}

		public delegate void AngleValueEventHandler(string angle);
		public event AngleValueEventHandler AngleRotation;
		
		private void FireAngleEvent(string angle) {
			if (AngleRotation != null)
				AngleRotation(angle);
		}

		public delegate void EndPanoramaEventHandler(bool OK);
		public event EndPanoramaEventHandler EndPanorama;

		private void FireEndPanoramaEvent(bool OK)
		{
			if (EndPanorama != null)
				EndPanorama(OK);
		}
	}
}
