﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: Yann
 * Date: 05/02/2017
 * Heure: 22:36
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using WComp.Beans;
using System.IO;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Collections.Generic;


namespace WComp.Beans
{
	[Bean(Category="HibooTracker")]
	public class beanPicLoader
	{
		private List<string> paths;
		private string ip;
		private string port;
		private string image64;
		private string fileName;
		private bool enableSync = true;
		
		public string IP {
			get{ return ip;  }
			set{
				ip = value;
			}
		}
		
		public string Port {
			get{ return port; }
			set{
				port = value;
			}
		}
		public bool EnableSync {
			get{ return enableSync; }
			set{
				enableSync = value;
				FireIsNotUploading(enableSync);
			}
		}
		
		public void sync(string pathsList) {
			
			if (enableSync == false)
			{
				return;
			}
			
			var strItems = pathsList.Split(';');
			paths = new List<string>(strItems);			
			
			if(paths != null && paths.Count > 0) {
				fileName = paths[paths.Count - 1];
				FireDownloadImageFromHiboo(fileName);
				 enableSync = false;
				 FireIsNotUploading(false);
			}
		}
		
		public void receivePicture(string image64) {
			this.image64 = image64;
			paths.RemoveAt(paths.Count-1);
			uploadImageToServer(image64);
			FireDeletePictureFromHiboo(fileName);
			if (paths != null && paths.Count > 0)
			{
				fileName = paths[paths.Count - 1];
				FireDownloadImageFromHiboo(fileName);
			}
			else
			{
				enableSync = true;
				FireIsNotUploading(true);
			}
		}
		
		private void uploadImageToServer(string image64) {
			
			byte[] image = Convert.FromBase64String(image64);
			File.WriteAllBytes(fileName, image);

			System.Net.WebClient oWeb = new System.Net.WebClient();
			string destination = "http://" + ip + ":" + port + "/api/";
			var responseBytes = oWeb.UploadFile(destination, fileName);
			if (responseBytes.Equals("done"))
			{
				FirePathPicture(destination + fileName);
				//File.Delete(fileName);
			}
		}
		
		
		
		public delegate void DownloadValueEventHandler(string path);
		public event DownloadValueEventHandler NewPathToDownload;
		
		private void FireDownloadImageFromHiboo(string path) {
			if (NewPathToDownload != null)
				NewPathToDownload(path);
		}

		public delegate void DeleteValueEventHandler(string path);
		public event DeleteValueEventHandler PictureToDelete;

		private void FireDeletePictureFromHiboo(string path)
		{
			if (PictureToDelete != null)
				PictureToDelete(path);
		}
		
		

		public delegate void BooleanValueEventHandler(bool b);
		public event BooleanValueEventHandler emptyPicturesFolder;	   	
		public event BooleanValueEventHandler isNotUploading;	
		
		
		
		
		
		private void FireIsNotUploading(bool b)
		{
			if (isNotUploading != null)
				isNotUploading(b);
		}
		
		
	
		private void FireEmptyFolder(bool path)
		{
			if (emptyPicturesFolder != null)
				emptyPicturesFolder(path);
		}

		public delegate void PathPictureEventHandler(string pathPicture);
		public event PathPictureEventHandler pathPictureUploaded;

		private void FirePathPicture(string path)
		{
			if (pathPictureUploaded != null)
				pathPictureUploaded(path);
		}
	}
}
