﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: Yann
 * Date: 24/01/2017
 * Heure: 16:22
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using WComp.Beans;

namespace WComp.Beans
{
	
	[Bean(Category="HibooTracker")]
	public class CapteursAngle
	{
		/// <summary>
		/// Fill in private attributes here.
		/// </summary>
		private bool inSensor1;
		private bool inSensor2;
		private bool inSensor3;

		private bool detectionEnabled = true;
		private bool isNotUploading = true;
		
		public bool  DetectionEnabled{
			get{ return detectionEnabled; }
			set{
				detectionEnabled = value;
			}
		}
		
		public bool  IsNotUploading{
			get{ return isNotUploading; }
			set{
				isNotUploading = value;
			}
		}
		
		public void setSensor1(bool sensor1) {
				inSensor1 = sensor1;
				motionEventHandler(inSensor1, inSensor2, inSensor3);
		}
		
		
		public void setSensor2(bool sensor2) {
				inSensor2 = sensor2; 
				motionEventHandler(inSensor1, inSensor2, inSensor3);			
		}
		
		public void setSensor3(bool sensor3) {
				inSensor3 = sensor3; 
				motionEventHandler(inSensor1, inSensor2, inSensor3);			
		}

		public void enableDetection()
		{
			detectionEnabled = true;
		}

		public delegate void StringValueEventHandler(string val);		
		public event StringValueEventHandler outAngle;		
		private void FireAngle(string val) {
			if (outAngle != null)
			{
				detectionEnabled = false;
				outAngle(val);
			}
		}
				
		private void motionEventHandler(bool sensor1, bool sensor2, bool sensor3)
		{
			if (!detectionEnabled || !isNotUploading)
				return;
			
			if(sensor1)
			{
				FireAngle("50");
			}
			else if(sensor2)
			{
				FireAngle("250");
			}
			else if(sensor3)
			{
				FireAngle("150");
			}
		}
		
	}
}
