﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using WComp.Beans;
using WComp.Util;

namespace WComp.AADesigner
{
	/// <summary>
	/// Description of ModifyListAdviceRule.
	/// </summary>
	[Bean(Category="AADesigner-dev")]
	public class ModifyListAdviceRule
	{
		private List<AdviceRule> received;
		private List<AdviceRule> added;
		
		public List<AdviceRule> CurrentAssembly {
			get { return this.received; }
			set {
				this.received = value;
				if (this.received != null) {
					FireStringReceivedAdviceRules(ToString(this.received));
					AutoAdaptation(this.received);
				}
			}
		}
		
		/// <summary>
		/// This method should compute new rules to send to the weaver. 
		/// This computation depends on the received assembly (expressed as rules also).
		/// This method should emit as an event (FireAddedRules) the computed result.
		/// </summary>
		private void AutoAdaptation(List<AdviceRule> receivedAssembly)
		{
			this.added = new List<AdviceRule>();
			if (this.added != null)
				FireStringAddedAdviceRules(ToString(this.added));
			FireAddedRules(this.added);
		}
		
		private string ToString(List<AdviceRule> lar)
		{
			StringBuilder builder = new StringBuilder();
			foreach (AdviceRule advice in lar)
			{
				builder.Append(advice.ToHumanString()).Append(Environment.NewLine);
			}
			return builder.ToString();
		}
		
		#region events
		public delegate void ListAdviceRuleEventHandler(List<AdviceRule> lar);
		public event ListAdviceRuleEventHandler AddedRules;
		private void FireAddedRules(List<AdviceRule> lar) {
			if (AddedRules != null)
				AddedRules(lar);
		}
		
		public delegate void StringValueEventHandler(string val);
		public event StringValueEventHandler StringReceivedAdviceRules;
		private void FireStringReceivedAdviceRules(string str) {
			if (StringReceivedAdviceRules != null)
				StringReceivedAdviceRules(str);
		}
		
		public event StringValueEventHandler StringAddedAdviceRules;
		private void FireStringAddedAdviceRules(string str) {
			if (StringAddedAdviceRules != null)
				StringAddedAdviceRules(str);
		}
		#endregion
	}
}
