/*************************************************************************
ALGLIB 3.10.0 (source code generated 2015-08-19)
Copyright (c) Sergey Bochkanov (ALGLIB project).

>>> SOURCE LICENSE >>>
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (www.fsf.org); either version 2 of the 
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

A copy of the GNU General Public License is available at
http://www.fsf.org/licensing/licenses
>>> END OF LICENSE >>>
*************************************************************************/
#pragma warning disable 162
#pragma warning disable 219
using System;

public partial class alglib
{



}
public partial class alglib
{



}
public partial class alglib
{



}
public partial class alglib
{



}
public partial class alglib
{


    /*************************************************************************
    This object stores state of the nonlinear CG optimizer.

    You should use ALGLIB functions to work with this object.
    *************************************************************************/
    public class mincgstate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needf { get { return _innerobj.needf; } set { _innerobj.needf = value; } }
        public bool needfg { get { return _innerobj.needfg; } set { _innerobj.needfg = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] g { get { return _innerobj.g; } }
        public double[] x { get { return _innerobj.x; } }

        public mincgstate()
        {
            _innerobj = new mincg.mincgstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new mincgstate((mincg.mincgstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private mincg.mincgstate _innerobj;
        public mincg.mincgstate innerobj { get { return _innerobj; } }
        public mincgstate(mincg.mincgstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    This structure stores optimization report:
    * IterationsCount           total number of inner iterations
    * NFEV                      number of gradient evaluations
    * TerminationType           termination type (see below)

    TERMINATION CODES

    TerminationType field contains completion code, which can be:
      -8    internal integrity control detected  infinite  or  NAN  values  in
            function/gradient. Abnormal termination signalled.
      -7    gradient verification failed.
            See MinCGSetGradientCheck() for more information.
       1    relative function improvement is no more than EpsF.
       2    relative step is no more than EpsX.
       4    gradient norm is no more than EpsG
       5    MaxIts steps was taken
       7    stopping conditions are too stringent,
            further improvement is impossible,
            X contains best point found so far.
       8    terminated by user who called mincgrequesttermination(). X contains
            point which was "current accepted" when  termination  request  was
            submitted.

    Other fields of this structure are not documented and should not be used!
    *************************************************************************/
    public class mincgreport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int nfev { get { return _innerobj.nfev; } set { _innerobj.nfev = value; } }
        public int varidx { get { return _innerobj.varidx; } set { _innerobj.varidx = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }

        public mincgreport()
        {
            _innerobj = new mincg.mincgreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new mincgreport((mincg.mincgreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private mincg.mincgreport _innerobj;
        public mincg.mincgreport innerobj { get { return _innerobj; } }
        public mincgreport(mincg.mincgreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
            NONLINEAR CONJUGATE GRADIENT METHOD

    DESCRIPTION:
    The subroutine minimizes function F(x) of N arguments by using one of  the
    nonlinear conjugate gradient methods.

    These CG methods are globally convergent (even on non-convex functions) as
    long as grad(f) is Lipschitz continuous in  a  some  neighborhood  of  the
    L = { x : f(x)<=f(x0) }.


    REQUIREMENTS:
    Algorithm will request following information during its operation:
    * function value F and its gradient G (simultaneously) at given point X


    USAGE:
    1. User initializes algorithm state with MinCGCreate() call
    2. User tunes solver parameters with MinCGSetCond(), MinCGSetStpMax() and
       other functions
    3. User calls MinCGOptimize() function which takes algorithm  state   and
       pointer (delegate, etc.) to callback function which calculates F/G.
    4. User calls MinCGResults() to get solution
    5. Optionally, user may call MinCGRestartFrom() to solve another  problem
       with same N but another starting point and/or another function.
       MinCGRestartFrom() allows to reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        X       -   starting point, array[0..N-1].

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

      -- ALGLIB --
         Copyright 25.03.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgcreate(int n, double[] x, out mincgstate state)
    {
        state = new mincgstate();
        mincg.mincgcreate(n, x, state.innerobj);
        return;
    }
    public static void mincgcreate(double[] x, out mincgstate state)
    {
        int n;

        state = new mincgstate();
        n = ap.len(x);
        mincg.mincgcreate(n, x, state.innerobj);

        return;
    }

    /*************************************************************************
    The subroutine is finite difference variant of MinCGCreate(). It uses
    finite differences in order to differentiate target function.

    Description below contains information which is specific to this function
    only. We recommend to read comments on MinCGCreate() in order to get more
    information about creation of CG optimizer.

    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        X       -   starting point, array[0..N-1].
        DiffStep-   differentiation step, >0

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTES:
    1. algorithm uses 4-point central formula for differentiation.
    2. differentiation step along I-th axis is equal to DiffStep*S[I] where
       S[] is scaling vector which can be set by MinCGSetScale() call.
    3. we recommend you to use moderate values of  differentiation  step.  Too
       large step will result in too large truncation  errors, while too small
       step will result in too large numerical  errors.  1.0E-6  can  be  good
       value to start with.
    4. Numerical  differentiation  is   very   inefficient  -   one   gradient
       calculation needs 4*N function evaluations. This function will work for
       any N - either small (1...10), moderate (10...100) or  large  (100...).
       However, performance penalty will be too severe for any N's except  for
       small ones.
       We should also say that code which relies on numerical  differentiation
       is  less  robust  and  precise.  L-BFGS  needs  exact  gradient values.
       Imprecise  gradient may slow down  convergence,  especially  on  highly
       nonlinear problems.
       Thus  we  recommend to use this function for fast prototyping on small-
       dimensional problems only, and to implement analytical gradient as soon
       as possible.

      -- ALGLIB --
         Copyright 16.05.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgcreatef(int n, double[] x, double diffstep, out mincgstate state)
    {
        state = new mincgstate();
        mincg.mincgcreatef(n, x, diffstep, state.innerobj);
        return;
    }
    public static void mincgcreatef(double[] x, double diffstep, out mincgstate state)
    {
        int n;

        state = new mincgstate();
        n = ap.len(x);
        mincg.mincgcreatef(n, x, diffstep, state.innerobj);

        return;
    }

    /*************************************************************************
    This function sets stopping conditions for CG optimization algorithm.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinCGSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes  its work if on k+1-th iteration
                    the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                    is satisfied.
        EpsX    -   >=0
                    The subroutine finishes its work if  on  k+1-th  iteration
                    the condition |v|<=EpsX is fulfilled, where:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - ste pvector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinCGSetScale()
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations is unlimited.

    Passing EpsG=0, EpsF=0, EpsX=0 and MaxIts=0 (simultaneously) will lead to
    automatic stopping criterion selection (small EpsX).

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetcond(mincgstate state, double epsg, double epsf, double epsx, int maxits)
    {

        mincg.mincgsetcond(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients for CG optimizer.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    Scaling is also used by finite difference variant of CG optimizer  -  step
    along I-th axis is equal to DiffStep*S[I].

    In   most   optimizers  (and  in  the  CG  too)  scaling is NOT a form  of
    preconditioning. It just  affects  stopping  conditions.  You  should  set
    preconditioner by separate call to one of the MinCGSetPrec...() functions.

    There  is  special  preconditioning  mode, however,  which  uses   scaling
    coefficients to form diagonal preconditioning matrix. You  can  turn  this
    mode on, if you want.   But  you should understand that scaling is not the
    same thing as preconditioning - these are two different, although  related
    forms of tuning solver.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 14.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetscale(mincgstate state, double[] s)
    {

        mincg.mincgsetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    This function turns on/off reporting.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        NeedXRep-   whether iteration reports are needed or not

    If NeedXRep is True, algorithm will call rep() callback function if  it is
    provided to MinCGOptimize().

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetxrep(mincgstate state, bool needxrep)
    {

        mincg.mincgsetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    This function sets CG algorithm.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        CGType  -   algorithm type:
                    * -1    automatic selection of the best algorithm
                    * 0     DY (Dai and Yuan) algorithm
                    * 1     Hybrid DY-HS algorithm

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetcgtype(mincgstate state, int cgtype)
    {

        mincg.mincgsetcgtype(state.innerobj, cgtype);
        return;
    }

    /*************************************************************************
    This function sets maximum step length

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        StpMax  -   maximum step length, >=0. Set StpMax to 0.0,  if you don't
                    want to limit step length.

    Use this subroutine when you optimize target function which contains exp()
    or  other  fast  growing  functions,  and optimization algorithm makes too
    large  steps  which  leads  to overflow. This function allows us to reject
    steps  that  are  too  large  (and  therefore  expose  us  to the possible
    overflow) without actually calculating function value at the x+stp*d.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetstpmax(mincgstate state, double stpmax)
    {

        mincg.mincgsetstpmax(state.innerobj, stpmax);
        return;
    }

    /*************************************************************************
    This function allows to suggest initial step length to the CG algorithm.

    Suggested  step  length  is used as starting point for the line search. It
    can be useful when you have  badly  scaled  problem,  i.e.  when  ||grad||
    (which is used as initial estimate for the first step) is many  orders  of
    magnitude different from the desired step.

    Line search  may  fail  on  such problems without good estimate of initial
    step length. Imagine, for example, problem with ||grad||=10^50 and desired
    step equal to 0.1 Line  search function will use 10^50  as  initial  step,
    then  it  will  decrease step length by 2 (up to 20 attempts) and will get
    10^44, which is still too large.

    This function allows us to tell than line search should  be  started  from
    some moderate step length, like 1.0, so algorithm will be able  to  detect
    desired step length in a several searches.

    Default behavior (when no step is suggested) is to use preconditioner,  if
    it is available, to generate initial estimate of step length.

    This function influences only first iteration of algorithm. It  should  be
    called between MinCGCreate/MinCGRestartFrom() call and MinCGOptimize call.
    Suggested step is ignored if you have preconditioner.

    INPUT PARAMETERS:
        State   -   structure used to store algorithm state.
        Stp     -   initial estimate of the step length.
                    Can be zero (no estimate).

      -- ALGLIB --
         Copyright 30.07.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsuggeststep(mincgstate state, double stp)
    {

        mincg.mincgsuggeststep(state.innerobj, stp);
        return;
    }

    /*************************************************************************
    Modification of the preconditioner: preconditioning is turned off.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
    iterations.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetprecdefault(mincgstate state)
    {

        mincg.mincgsetprecdefault(state.innerobj);
        return;
    }

    /*************************************************************************
    Modification  of  the  preconditioner:  diagonal of approximate Hessian is
    used.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        D       -   diagonal of the approximate Hessian, array[0..N-1],
                    (if larger, only leading N elements are used).

    NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
    iterations.

    NOTE 2: D[i] should be positive. Exception will be thrown otherwise.

    NOTE 3: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetprecdiag(mincgstate state, double[] d)
    {

        mincg.mincgsetprecdiag(state.innerobj, d);
        return;
    }

    /*************************************************************************
    Modification of the preconditioner: scale-based diagonal preconditioning.

    This preconditioning mode can be useful when you  don't  have  approximate
    diagonal of Hessian, but you know that your  variables  are  badly  scaled
    (for  example,  one  variable is in [1,10], and another in [1000,100000]),
    and most part of the ill-conditioning comes from different scales of vars.

    In this case simple  scale-based  preconditioner,  with H[i] = 1/(s[i]^2),
    can greatly improve convergence.

    IMPRTANT: you should set scale of your variables with MinCGSetScale() call
    (before or after MinCGSetPrecScale() call). Without knowledge of the scale
    of your variables scale-based preconditioner will be just unit matrix.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
    iterations.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetprecscale(mincgstate state)
    {

        mincg.mincgsetprecscale(state.innerobj);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool mincgiteration(mincgstate state)
    {

        bool result = mincg.mincgiteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        func    -   callback which calculates function (or merit function)
                    value func at given point x
        grad    -   callback which calculates function (or merit function)
                    value func and gradient grad at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null

    NOTES:

    1. This function has two different implementations: one which  uses  exact
       (analytical) user-supplied  gradient, and one which uses function value
       only  and  numerically  differentiates  function  in  order  to  obtain
       gradient.

       Depending  on  the  specific  function  used to create optimizer object
       (either MinCGCreate()  for analytical gradient  or  MinCGCreateF()  for
       numerical differentiation) you should  choose  appropriate  variant  of
       MinCGOptimize() - one which accepts function AND gradient or one  which
       accepts function ONLY.

       Be careful to choose variant of MinCGOptimize()  which  corresponds  to
       your optimization scheme! Table below lists different  combinations  of
       callback (function/gradient) passed  to  MinCGOptimize()  and  specific
       function used to create optimizer.


                      |         USER PASSED TO MinCGOptimize()
       CREATED WITH   |  function only   |  function and gradient
       ------------------------------------------------------------
       MinCGCreateF() |     work                FAIL
       MinCGCreate()  |     FAIL                work

       Here "FAIL" denotes inappropriate combinations  of  optimizer  creation
       function and MinCGOptimize() version. Attemps to use  such  combination
       (for  example,  to create optimizer with  MinCGCreateF()  and  to  pass
       gradient information to MinCGOptimize()) will lead to  exception  being
       thrown. Either  you  did  not  pass  gradient when it WAS needed or you
       passed gradient when it was NOT needed.

      -- ALGLIB --
         Copyright 20.04.2009 by Bochkanov Sergey

    *************************************************************************/
    public static void mincgoptimize(mincgstate state, ndimensional_func func, ndimensional_rep rep, object obj)
    {
        if( func==null )
            throw new alglibexception("ALGLIB: error in 'mincgoptimize()' (func is null)");
        while( alglib.mincgiteration(state) )
        {
            if( state.needf )
            {
                func(state.x, ref state.innerobj.f, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'mincgoptimize' (some derivatives were not provided?)");
        }
    }


    public static void mincgoptimize(mincgstate state, ndimensional_grad grad, ndimensional_rep rep, object obj)
    {
        if( grad==null )
            throw new alglibexception("ALGLIB: error in 'mincgoptimize()' (grad is null)");
        while( alglib.mincgiteration(state) )
        {
            if( state.needfg )
            {
                grad(state.x, ref state.innerobj.f, state.innerobj.g, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'mincgoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    Conjugate gradient results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution
        Rep     -   optimization report:
                    * Rep.TerminationType completetion code:
                        * -8    internal integrity control  detected  infinite
                                or NAN values in  function/gradient.  Abnormal
                                termination signalled.
                        * -7    gradient verification failed.
                                See MinCGSetGradientCheck() for more information.
                        *  1    relative function improvement is no more than
                                EpsF.
                        *  2    relative step is no more than EpsX.
                        *  4    gradient norm is no more than EpsG
                        *  5    MaxIts steps was taken
                        *  7    stopping conditions are too stringent,
                                further improvement is impossible,
                                we return best X found so far
                        *  8    terminated by user
                    * Rep.IterationsCount contains iterations count
                    * NFEV countains number of function calculations

      -- ALGLIB --
         Copyright 20.04.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgresults(mincgstate state, out double[] x, out mincgreport rep)
    {
        x = new double[0];
        rep = new mincgreport();
        mincg.mincgresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    Conjugate gradient results

    Buffered implementation of MinCGResults(), which uses pre-allocated buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 20.04.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgresultsbuf(mincgstate state, ref double[] x, mincgreport rep)
    {

        mincg.mincgresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    This  subroutine  restarts  CG  algorithm from new point. All optimization
    parameters are left unchanged.

    This  function  allows  to  solve multiple  optimization  problems  (which
    must have same number of dimensions) without object reallocation penalty.

    INPUT PARAMETERS:
        State   -   structure used to store algorithm state.
        X       -   new starting point.

      -- ALGLIB --
         Copyright 30.07.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgrestartfrom(mincgstate state, double[] x)
    {

        mincg.mincgrestartfrom(state.innerobj, x);
        return;
    }

    /*************************************************************************
    This subroutine submits request for termination of running  optimizer.  It
    should be called from user-supplied callback when user decides that it  is
    time to "smoothly" terminate optimization process.  As  result,  optimizer
    stops at point which was "current accepted" when termination  request  was
    submitted and returns error code 8 (successful termination).

    INPUT PARAMETERS:
        State   -   optimizer structure

    NOTE: after  request  for  termination  optimizer  may   perform   several
          additional calls to user-supplied callbacks. It does  NOT  guarantee
          to stop immediately - it just guarantees that these additional calls
          will be discarded later.

    NOTE: calling this function on optimizer which is NOT running will have no
          effect.

    NOTE: multiple calls to this function are possible. First call is counted,
          subsequent calls are silently ignored.

      -- ALGLIB --
         Copyright 08.10.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgrequesttermination(mincgstate state)
    {

        mincg.mincgrequesttermination(state.innerobj);
        return;
    }

    /*************************************************************************

    This  subroutine  turns  on  verification  of  the  user-supplied analytic
    gradient:
    * user calls this subroutine before optimization begins
    * MinCGOptimize() is called
    * prior to  actual  optimization, for each component  of  parameters being
      optimized X[i] algorithm performs following steps:
      * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
        where X[i] is i-th component of the initial point and S[i] is a  scale
        of i-th parameter
      * F(X) is evaluated at these trial points
      * we perform one more evaluation in the middle point of the interval
      * we  build  cubic  model using function values and derivatives at trial
        points and we compare its prediction with actual value in  the  middle
        point
      * in case difference between prediction and actual value is higher  than
        some predetermined threshold, algorithm stops with completion code -7;
        Rep.VarIdx is set to index of the parameter with incorrect derivative.
    * after verification is over, algorithm proceeds to the actual optimization.

    NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
            is very costly and you should use  it  only  for  low  dimensional
            problems,  when  you  want  to  be  sure  that  you've   correctly
            calculated  analytic  derivatives.  You  should  not use it in the
            production code (unless you want to check derivatives provided  by
            some third party).

    NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
            (so large that function behaviour is significantly non-cubic) will
            lead to false alarms. You may use  different  step  for  different
            parameters by means of setting scale with MinCGSetScale().

    NOTE 3: this function may lead to false positives. In case it reports that
            I-th  derivative was calculated incorrectly, you may decrease test
            step  and  try  one  more  time  - maybe your function changes too
            sharply  and  your  step  is  too  large for such rapidly chanding
            function.

    INPUT PARAMETERS:
        State       -   structure used to store algorithm state
        TestStep    -   verification step:
                        * TestStep=0 turns verification off
                        * TestStep>0 activates verification

      -- ALGLIB --
         Copyright 31.05.2012 by Bochkanov Sergey
    *************************************************************************/
    public static void mincgsetgradientcheck(mincgstate state, double teststep)
    {

        mincg.mincgsetgradientcheck(state.innerobj, teststep);
        return;
    }

}
public partial class alglib
{


    /*************************************************************************
    This object stores nonlinear optimizer state.
    You should use functions provided by MinBLEIC subpackage to work with this
    object
    *************************************************************************/
    public class minbleicstate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needf { get { return _innerobj.needf; } set { _innerobj.needf = value; } }
        public bool needfg { get { return _innerobj.needfg; } set { _innerobj.needfg = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] g { get { return _innerobj.g; } }
        public double[] x { get { return _innerobj.x; } }

        public minbleicstate()
        {
            _innerobj = new minbleic.minbleicstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minbleicstate((minbleic.minbleicstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minbleic.minbleicstate _innerobj;
        public minbleic.minbleicstate innerobj { get { return _innerobj; } }
        public minbleicstate(minbleic.minbleicstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    This structure stores optimization report:
    * IterationsCount           number of iterations
    * NFEV                      number of gradient evaluations
    * TerminationType           termination type (see below)

    TERMINATION CODES

    TerminationType field contains completion code, which can be:
      -8    internal integrity control detected  infinite  or  NAN  values  in
            function/gradient. Abnormal termination signalled.
      -7    gradient verification failed.
            See MinBLEICSetGradientCheck() for more information.
      -3    inconsistent constraints. Feasible point is
            either nonexistent or too hard to find. Try to
            restart optimizer with better initial approximation
       1    relative function improvement is no more than EpsF.
       2    relative step is no more than EpsX.
       4    gradient norm is no more than EpsG
       5    MaxIts steps was taken
       7    stopping conditions are too stringent,
            further improvement is impossible,
            X contains best point found so far.
       8    terminated by user who called minbleicrequesttermination(). X contains
            point which was "current accepted" when  termination  request  was
            submitted.

    ADDITIONAL FIELDS

    There are additional fields which can be used for debugging:
    * DebugEqErr                error in the equality constraints (2-norm)
    * DebugFS                   f, calculated at projection of initial point
                                to the feasible set
    * DebugFF                   f, calculated at the final point
    * DebugDX                   |X_start-X_final|
    *************************************************************************/
    public class minbleicreport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int nfev { get { return _innerobj.nfev; } set { _innerobj.nfev = value; } }
        public int varidx { get { return _innerobj.varidx; } set { _innerobj.varidx = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }
        public double debugeqerr { get { return _innerobj.debugeqerr; } set { _innerobj.debugeqerr = value; } }
        public double debugfs { get { return _innerobj.debugfs; } set { _innerobj.debugfs = value; } }
        public double debugff { get { return _innerobj.debugff; } set { _innerobj.debugff = value; } }
        public double debugdx { get { return _innerobj.debugdx; } set { _innerobj.debugdx = value; } }
        public int debugfeasqpits { get { return _innerobj.debugfeasqpits; } set { _innerobj.debugfeasqpits = value; } }
        public int debugfeasgpaits { get { return _innerobj.debugfeasgpaits; } set { _innerobj.debugfeasgpaits = value; } }
        public int inneriterationscount { get { return _innerobj.inneriterationscount; } set { _innerobj.inneriterationscount = value; } }
        public int outeriterationscount { get { return _innerobj.outeriterationscount; } set { _innerobj.outeriterationscount = value; } }

        public minbleicreport()
        {
            _innerobj = new minbleic.minbleicreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minbleicreport((minbleic.minbleicreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minbleic.minbleicreport _innerobj;
        public minbleic.minbleicreport innerobj { get { return _innerobj; } }
        public minbleicreport(minbleic.minbleicreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
                         BOUND CONSTRAINED OPTIMIZATION
           WITH ADDITIONAL LINEAR EQUALITY AND INEQUALITY CONSTRAINTS

    DESCRIPTION:
    The  subroutine  minimizes  function   F(x)  of N arguments subject to any
    combination of:
    * bound constraints
    * linear inequality constraints
    * linear equality constraints

    REQUIREMENTS:
    * user must provide function value and gradient
    * starting point X0 must be feasible or
      not too far away from the feasible set
    * grad(f) must be Lipschitz continuous on a level set:
      L = { x : f(x)<=f(x0) }
    * function must be defined everywhere on the feasible set F

    USAGE:

    Constrained optimization if far more complex than the unconstrained one.
    Here we give very brief outline of the BLEIC optimizer. We strongly recommend
    you to read examples in the ALGLIB Reference Manual and to read ALGLIB User Guide
    on optimization, which is available at http://www.alglib.net/optimization/

    1. User initializes algorithm state with MinBLEICCreate() call

    2. USer adds boundary and/or linear constraints by calling
       MinBLEICSetBC() and MinBLEICSetLC() functions.

    3. User sets stopping conditions with MinBLEICSetCond().

    4. User calls MinBLEICOptimize() function which takes algorithm  state and
       pointer (delegate, etc.) to callback function which calculates F/G.

    5. User calls MinBLEICResults() to get solution

    6. Optionally user may call MinBLEICRestartFrom() to solve another problem
       with same N but another starting point.
       MinBLEICRestartFrom() allows to reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size ofX
        X       -   starting point, array[N]:
                    * it is better to set X to a feasible point
                    * but X can be infeasible, in which case algorithm will try
                      to find feasible point first, using X as initial
                      approximation.

    OUTPUT PARAMETERS:
        State   -   structure stores algorithm state

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleiccreate(int n, double[] x, out minbleicstate state)
    {
        state = new minbleicstate();
        minbleic.minbleiccreate(n, x, state.innerobj);
        return;
    }
    public static void minbleiccreate(double[] x, out minbleicstate state)
    {
        int n;

        state = new minbleicstate();
        n = ap.len(x);
        minbleic.minbleiccreate(n, x, state.innerobj);

        return;
    }

    /*************************************************************************
    The subroutine is finite difference variant of MinBLEICCreate().  It  uses
    finite differences in order to differentiate target function.

    Description below contains information which is specific to  this function
    only. We recommend to read comments on MinBLEICCreate() in  order  to  get
    more information about creation of BLEIC optimizer.

    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        X       -   starting point, array[0..N-1].
        DiffStep-   differentiation step, >0

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTES:
    1. algorithm uses 4-point central formula for differentiation.
    2. differentiation step along I-th axis is equal to DiffStep*S[I] where
       S[] is scaling vector which can be set by MinBLEICSetScale() call.
    3. we recommend you to use moderate values of  differentiation  step.  Too
       large step will result in too large truncation  errors, while too small
       step will result in too large numerical  errors.  1.0E-6  can  be  good
       value to start with.
    4. Numerical  differentiation  is   very   inefficient  -   one   gradient
       calculation needs 4*N function evaluations. This function will work for
       any N - either small (1...10), moderate (10...100) or  large  (100...).
       However, performance penalty will be too severe for any N's except  for
       small ones.
       We should also say that code which relies on numerical  differentiation
       is  less  robust and precise. CG needs exact gradient values. Imprecise
       gradient may slow  down  convergence, especially  on  highly  nonlinear
       problems.
       Thus  we  recommend to use this function for fast prototyping on small-
       dimensional problems only, and to implement analytical gradient as soon
       as possible.

      -- ALGLIB --
         Copyright 16.05.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleiccreatef(int n, double[] x, double diffstep, out minbleicstate state)
    {
        state = new minbleicstate();
        minbleic.minbleiccreatef(n, x, diffstep, state.innerobj);
        return;
    }
    public static void minbleiccreatef(double[] x, double diffstep, out minbleicstate state)
    {
        int n;

        state = new minbleicstate();
        n = ap.len(x);
        minbleic.minbleiccreatef(n, x, diffstep, state.innerobj);

        return;
    }

    /*************************************************************************
    This function sets boundary constraints for BLEIC optimizer.

    Boundary constraints are inactive by default (after initial creation).
    They are preserved after algorithm restart with MinBLEICRestartFrom().

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        BndL    -   lower bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very small number or -INF.
        BndU    -   upper bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very large number or +INF.

    NOTE 1: it is possible to specify BndL[i]=BndU[i]. In this case I-th
    variable will be "frozen" at X[i]=BndL[i]=BndU[i].

    NOTE 2: this solver has following useful properties:
    * bound constraints are always satisfied exactly
    * function is evaluated only INSIDE area specified by  bound  constraints,
      even  when  numerical  differentiation is used (algorithm adjusts  nodes
      according to boundary constraints)

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetbc(minbleicstate state, double[] bndl, double[] bndu)
    {

        minbleic.minbleicsetbc(state.innerobj, bndl, bndu);
        return;
    }

    /*************************************************************************
    This function sets linear constraints for BLEIC optimizer.

    Linear constraints are inactive by default (after initial creation).
    They are preserved after algorithm restart with MinBLEICRestartFrom().

    INPUT PARAMETERS:
        State   -   structure previously allocated with MinBLEICCreate call.
        C       -   linear constraints, array[K,N+1].
                    Each row of C represents one constraint, either equality
                    or inequality (see below):
                    * first N elements correspond to coefficients,
                    * last element corresponds to the right part.
                    All elements of C (including right part) must be finite.
        CT      -   type of constraints, array[K]:
                    * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                    * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                    * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
        K       -   number of equality/inequality constraints, K>=0:
                    * if given, only leading K elements of C/CT are used
                    * if not given, automatically determined from sizes of C/CT

    NOTE 1: linear (non-bound) constraints are satisfied only approximately:
    * there always exists some minor violation (about Epsilon in magnitude)
      due to rounding errors
    * numerical differentiation, if used, may  lead  to  function  evaluations
      outside  of the feasible  area,   because   algorithm  does  NOT  change
      numerical differentiation formula according to linear constraints.
    If you want constraints to be  satisfied  exactly, try to reformulate your
    problem  in  such  manner  that  all constraints will become boundary ones
    (this kind of constraints is always satisfied exactly, both in  the  final
    solution and in all intermediate points).

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetlc(minbleicstate state, double[,] c, int[] ct, int k)
    {

        minbleic.minbleicsetlc(state.innerobj, c, ct, k);
        return;
    }
    public static void minbleicsetlc(minbleicstate state, double[,] c, int[] ct)
    {
        int k;
        if( (ap.rows(c)!=ap.len(ct)))
            throw new alglibexception("Error while calling 'minbleicsetlc': looks like one of arguments has wrong size");

        k = ap.rows(c);
        minbleic.minbleicsetlc(state.innerobj, c, ct, k);

        return;
    }

    /*************************************************************************
    This function sets stopping conditions for the optimizer.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinBLEICSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes  its work if on k+1-th iteration
                    the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                    is satisfied.
        EpsX    -   >=0
                    The subroutine finishes its work if  on  k+1-th  iteration
                    the condition |v|<=EpsX is fulfilled, where:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - step vector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinBLEICSetScale()
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations is unlimited.

    Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
    to automatic stopping criterion selection.

    NOTE: when SetCond() called with non-zero MaxIts, BLEIC solver may perform
          slightly more than MaxIts iterations. I.e., MaxIts  sets  non-strict
          limit on iterations count.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetcond(minbleicstate state, double epsg, double epsf, double epsx, int maxits)
    {

        minbleic.minbleicsetcond(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients for BLEIC optimizer.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    Scaling is also used by finite difference variant of the optimizer  - step
    along I-th axis is equal to DiffStep*S[I].

    In  most  optimizers  (and  in  the  BLEIC  too)  scaling is NOT a form of
    preconditioning. It just  affects  stopping  conditions.  You  should  set
    preconditioner  by  separate  call  to  one  of  the  MinBLEICSetPrec...()
    functions.

    There is a special  preconditioning  mode, however,  which  uses   scaling
    coefficients to form diagonal preconditioning matrix. You  can  turn  this
    mode on, if you want.   But  you should understand that scaling is not the
    same thing as preconditioning - these are two different, although  related
    forms of tuning solver.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 14.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetscale(minbleicstate state, double[] s)
    {

        minbleic.minbleicsetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    Modification of the preconditioner: preconditioning is turned off.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetprecdefault(minbleicstate state)
    {

        minbleic.minbleicsetprecdefault(state.innerobj);
        return;
    }

    /*************************************************************************
    Modification  of  the  preconditioner:  diagonal of approximate Hessian is
    used.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        D       -   diagonal of the approximate Hessian, array[0..N-1],
                    (if larger, only leading N elements are used).

    NOTE 1: D[i] should be positive. Exception will be thrown otherwise.

    NOTE 2: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetprecdiag(minbleicstate state, double[] d)
    {

        minbleic.minbleicsetprecdiag(state.innerobj, d);
        return;
    }

    /*************************************************************************
    Modification of the preconditioner: scale-based diagonal preconditioning.

    This preconditioning mode can be useful when you  don't  have  approximate
    diagonal of Hessian, but you know that your  variables  are  badly  scaled
    (for  example,  one  variable is in [1,10], and another in [1000,100000]),
    and most part of the ill-conditioning comes from different scales of vars.

    In this case simple  scale-based  preconditioner,  with H[i] = 1/(s[i]^2),
    can greatly improve convergence.

    IMPRTANT: you should set scale of your variables  with  MinBLEICSetScale()
    call  (before  or after MinBLEICSetPrecScale() call). Without knowledge of
    the scale of your variables scale-based preconditioner will be  just  unit
    matrix.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetprecscale(minbleicstate state)
    {

        minbleic.minbleicsetprecscale(state.innerobj);
        return;
    }

    /*************************************************************************
    This function turns on/off reporting.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        NeedXRep-   whether iteration reports are needed or not

    If NeedXRep is True, algorithm will call rep() callback function if  it is
    provided to MinBLEICOptimize().

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetxrep(minbleicstate state, bool needxrep)
    {

        minbleic.minbleicsetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    This function sets maximum step length

    IMPORTANT: this feature is hard to combine with preconditioning. You can't
    set upper limit on step length, when you solve optimization  problem  with
    linear (non-boundary) constraints AND preconditioner turned on.

    When  non-boundary  constraints  are  present,  you  have to either a) use
    preconditioner, or b) use upper limit on step length.  YOU CAN'T USE BOTH!
    In this case algorithm will terminate with appropriate error code.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        StpMax  -   maximum step length, >=0. Set StpMax to 0.0,  if you don't
                    want to limit step length.

    Use this subroutine when you optimize target function which contains exp()
    or  other  fast  growing  functions,  and optimization algorithm makes too
    large  steps  which  lead   to overflow. This function allows us to reject
    steps  that  are  too  large  (and  therefore  expose  us  to the possible
    overflow) without actually calculating function value at the x+stp*d.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetstpmax(minbleicstate state, double stpmax)
    {

        minbleic.minbleicsetstpmax(state.innerobj, stpmax);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool minbleiciteration(minbleicstate state)
    {

        bool result = minbleic.minbleiciteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        func    -   callback which calculates function (or merit function)
                    value func at given point x
        grad    -   callback which calculates function (or merit function)
                    value func and gradient grad at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null

    NOTES:

    1. This function has two different implementations: one which  uses  exact
       (analytical) user-supplied gradient,  and one which uses function value
       only  and  numerically  differentiates  function  in  order  to  obtain
       gradient.

       Depending  on  the  specific  function  used to create optimizer object
       (either  MinBLEICCreate() for analytical gradient or  MinBLEICCreateF()
       for numerical differentiation) you should choose appropriate variant of
       MinBLEICOptimize() - one  which  accepts  function  AND gradient or one
       which accepts function ONLY.

       Be careful to choose variant of MinBLEICOptimize() which corresponds to
       your optimization scheme! Table below lists different  combinations  of
       callback (function/gradient) passed to MinBLEICOptimize()  and specific
       function used to create optimizer.


                         |         USER PASSED TO MinBLEICOptimize()
       CREATED WITH      |  function only   |  function and gradient
       ------------------------------------------------------------
       MinBLEICCreateF() |     work                FAIL
       MinBLEICCreate()  |     FAIL                work

       Here "FAIL" denotes inappropriate combinations  of  optimizer  creation
       function  and  MinBLEICOptimize()  version.   Attemps   to   use   such
       combination (for  example,  to  create optimizer with MinBLEICCreateF()
       and  to  pass  gradient  information  to  MinCGOptimize()) will lead to
       exception being thrown. Either  you  did  not pass gradient when it WAS
       needed or you passed gradient when it was NOT needed.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey

    *************************************************************************/
    public static void minbleicoptimize(minbleicstate state, ndimensional_func func, ndimensional_rep rep, object obj)
    {
        if( func==null )
            throw new alglibexception("ALGLIB: error in 'minbleicoptimize()' (func is null)");
        while( alglib.minbleiciteration(state) )
        {
            if( state.needf )
            {
                func(state.x, ref state.innerobj.f, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minbleicoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minbleicoptimize(minbleicstate state, ndimensional_grad grad, ndimensional_rep rep, object obj)
    {
        if( grad==null )
            throw new alglibexception("ALGLIB: error in 'minbleicoptimize()' (grad is null)");
        while( alglib.minbleiciteration(state) )
        {
            if( state.needfg )
            {
                grad(state.x, ref state.innerobj.f, state.innerobj.g, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minbleicoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    BLEIC results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution
        Rep     -   optimization report. You should check Rep.TerminationType
                    in  order  to  distinguish  successful  termination  from
                    unsuccessful one:
                    * -8    internal integrity control  detected  infinite or
                            NAN   values   in   function/gradient.   Abnormal
                            termination signalled.
                    * -7   gradient verification failed.
                           See MinBLEICSetGradientCheck() for more information.
                    * -3   inconsistent constraints. Feasible point is
                           either nonexistent or too hard to find. Try to
                           restart optimizer with better initial approximation
                    *  1   relative function improvement is no more than EpsF.
                    *  2   scaled step is no more than EpsX.
                    *  4   scaled gradient norm is no more than EpsG.
                    *  5   MaxIts steps was taken
                    *  8   terminated by user who called minbleicrequesttermination().
                           X contains point which was "current accepted"  when
                           termination request was submitted.
                    More information about fields of this  structure  can  be
                    found in the comments on MinBLEICReport datatype.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicresults(minbleicstate state, out double[] x, out minbleicreport rep)
    {
        x = new double[0];
        rep = new minbleicreport();
        minbleic.minbleicresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    BLEIC results

    Buffered implementation of MinBLEICResults() which uses pre-allocated buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicresultsbuf(minbleicstate state, ref double[] x, minbleicreport rep)
    {

        minbleic.minbleicresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    This subroutine restarts algorithm from new point.
    All optimization parameters (including constraints) are left unchanged.

    This  function  allows  to  solve multiple  optimization  problems  (which
    must have  same number of dimensions) without object reallocation penalty.

    INPUT PARAMETERS:
        State   -   structure previously allocated with MinBLEICCreate call.
        X       -   new starting point.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicrestartfrom(minbleicstate state, double[] x)
    {

        minbleic.minbleicrestartfrom(state.innerobj, x);
        return;
    }

    /*************************************************************************
    This subroutine submits request for termination of running  optimizer.  It
    should be called from user-supplied callback when user decides that it  is
    time to "smoothly" terminate optimization process.  As  result,  optimizer
    stops at point which was "current accepted" when termination  request  was
    submitted and returns error code 8 (successful termination).

    INPUT PARAMETERS:
        State   -   optimizer structure

    NOTE: after  request  for  termination  optimizer  may   perform   several
          additional calls to user-supplied callbacks. It does  NOT  guarantee
          to stop immediately - it just guarantees that these additional calls
          will be discarded later.

    NOTE: calling this function on optimizer which is NOT running will have no
          effect.

    NOTE: multiple calls to this function are possible. First call is counted,
          subsequent calls are silently ignored.

      -- ALGLIB --
         Copyright 08.10.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicrequesttermination(minbleicstate state)
    {

        minbleic.minbleicrequesttermination(state.innerobj);
        return;
    }

    /*************************************************************************
    This  subroutine  turns  on  verification  of  the  user-supplied analytic
    gradient:
    * user calls this subroutine before optimization begins
    * MinBLEICOptimize() is called
    * prior to  actual  optimization, for each component  of  parameters being
      optimized X[i] algorithm performs following steps:
      * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
        where X[i] is i-th component of the initial point and S[i] is a  scale
        of i-th parameter
      * if needed, steps are bounded with respect to constraints on X[]
      * F(X) is evaluated at these trial points
      * we perform one more evaluation in the middle point of the interval
      * we  build  cubic  model using function values and derivatives at trial
        points and we compare its prediction with actual value in  the  middle
        point
      * in case difference between prediction and actual value is higher  than
        some predetermined threshold, algorithm stops with completion code -7;
        Rep.VarIdx is set to index of the parameter with incorrect derivative.
    * after verification is over, algorithm proceeds to the actual optimization.

    NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
            is very costly and you should use  it  only  for  low  dimensional
            problems,  when  you  want  to  be  sure  that  you've   correctly
            calculated  analytic  derivatives.  You  should  not use it in the
            production code (unless you want to check derivatives provided  by
            some third party).

    NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
            (so large that function behaviour is significantly non-cubic) will
            lead to false alarms. You may use  different  step  for  different
            parameters by means of setting scale with MinBLEICSetScale().

    NOTE 3: this function may lead to false positives. In case it reports that
            I-th  derivative was calculated incorrectly, you may decrease test
            step  and  try  one  more  time  - maybe your function changes too
            sharply  and  your  step  is  too  large for such rapidly chanding
            function.

    INPUT PARAMETERS:
        State       -   structure used to store algorithm state
        TestStep    -   verification step:
                        * TestStep=0 turns verification off
                        * TestStep>0 activates verification

      -- ALGLIB --
         Copyright 15.06.2012 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetgradientcheck(minbleicstate state, double teststep)
    {

        minbleic.minbleicsetgradientcheck(state.innerobj, teststep);
        return;
    }

}
public partial class alglib
{


    /*************************************************************************

    *************************************************************************/
    public class minlbfgsstate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needf { get { return _innerobj.needf; } set { _innerobj.needf = value; } }
        public bool needfg { get { return _innerobj.needfg; } set { _innerobj.needfg = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] g { get { return _innerobj.g; } }
        public double[] x { get { return _innerobj.x; } }

        public minlbfgsstate()
        {
            _innerobj = new minlbfgs.minlbfgsstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minlbfgsstate((minlbfgs.minlbfgsstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minlbfgs.minlbfgsstate _innerobj;
        public minlbfgs.minlbfgsstate innerobj { get { return _innerobj; } }
        public minlbfgsstate(minlbfgs.minlbfgsstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    This structure stores optimization report:
    * IterationsCount           total number of inner iterations
    * NFEV                      number of gradient evaluations
    * TerminationType           termination type (see below)

    TERMINATION CODES

    TerminationType field contains completion code, which can be:
      -8    internal integrity control detected  infinite  or  NAN  values  in
            function/gradient. Abnormal termination signalled.
      -7    gradient verification failed.
            See MinLBFGSSetGradientCheck() for more information.
       1    relative function improvement is no more than EpsF.
       2    relative step is no more than EpsX.
       4    gradient norm is no more than EpsG
       5    MaxIts steps was taken
       7    stopping conditions are too stringent,
            further improvement is impossible,
            X contains best point found so far.
       8    terminated    by  user  who  called  minlbfgsrequesttermination().
            X contains point which was   "current accepted"  when  termination
            request was submitted.

    Other fields of this structure are not documented and should not be used!
    *************************************************************************/
    public class minlbfgsreport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int nfev { get { return _innerobj.nfev; } set { _innerobj.nfev = value; } }
        public int varidx { get { return _innerobj.varidx; } set { _innerobj.varidx = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }

        public minlbfgsreport()
        {
            _innerobj = new minlbfgs.minlbfgsreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minlbfgsreport((minlbfgs.minlbfgsreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minlbfgs.minlbfgsreport _innerobj;
        public minlbfgs.minlbfgsreport innerobj { get { return _innerobj; } }
        public minlbfgsreport(minlbfgs.minlbfgsreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
            LIMITED MEMORY BFGS METHOD FOR LARGE SCALE OPTIMIZATION

    DESCRIPTION:
    The subroutine minimizes function F(x) of N arguments by  using  a  quasi-
    Newton method (LBFGS scheme) which is optimized to use  a  minimum  amount
    of memory.
    The subroutine generates the approximation of an inverse Hessian matrix by
    using information about the last M steps of the algorithm  (instead of N).
    It lessens a required amount of memory from a value  of  order  N^2  to  a
    value of order 2*N*M.


    REQUIREMENTS:
    Algorithm will request following information during its operation:
    * function value F and its gradient G (simultaneously) at given point X


    USAGE:
    1. User initializes algorithm state with MinLBFGSCreate() call
    2. User tunes solver parameters with MinLBFGSSetCond() MinLBFGSSetStpMax()
       and other functions
    3. User calls MinLBFGSOptimize() function which takes algorithm  state and
       pointer (delegate, etc.) to callback function which calculates F/G.
    4. User calls MinLBFGSResults() to get solution
    5. Optionally user may call MinLBFGSRestartFrom() to solve another problem
       with same N/M but another starting point and/or another function.
       MinLBFGSRestartFrom() allows to reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   problem dimension. N>0
        M       -   number of corrections in the BFGS scheme of Hessian
                    approximation update. Recommended value:  3<=M<=7. The smaller
                    value causes worse convergence, the bigger will  not  cause  a
                    considerably better convergence, but will cause a fall in  the
                    performance. M<=N.
        X       -   initial solution approximation, array[0..N-1].


    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state


    NOTES:
    1. you may tune stopping conditions with MinLBFGSSetCond() function
    2. if target function contains exp() or other fast growing functions,  and
       optimization algorithm makes too large steps which leads  to  overflow,
       use MinLBFGSSetStpMax() function to bound algorithm's  steps.  However,
       L-BFGS rarely needs such a tuning.


      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgscreate(int n, int m, double[] x, out minlbfgsstate state)
    {
        state = new minlbfgsstate();
        minlbfgs.minlbfgscreate(n, m, x, state.innerobj);
        return;
    }
    public static void minlbfgscreate(int m, double[] x, out minlbfgsstate state)
    {
        int n;

        state = new minlbfgsstate();
        n = ap.len(x);
        minlbfgs.minlbfgscreate(n, m, x, state.innerobj);

        return;
    }

    /*************************************************************************
    The subroutine is finite difference variant of MinLBFGSCreate().  It  uses
    finite differences in order to differentiate target function.

    Description below contains information which is specific to  this function
    only. We recommend to read comments on MinLBFGSCreate() in  order  to  get
    more information about creation of LBFGS optimizer.

    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        M       -   number of corrections in the BFGS scheme of Hessian
                    approximation update. Recommended value:  3<=M<=7. The smaller
                    value causes worse convergence, the bigger will  not  cause  a
                    considerably better convergence, but will cause a fall in  the
                    performance. M<=N.
        X       -   starting point, array[0..N-1].
        DiffStep-   differentiation step, >0

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTES:
    1. algorithm uses 4-point central formula for differentiation.
    2. differentiation step along I-th axis is equal to DiffStep*S[I] where
       S[] is scaling vector which can be set by MinLBFGSSetScale() call.
    3. we recommend you to use moderate values of  differentiation  step.  Too
       large step will result in too large truncation  errors, while too small
       step will result in too large numerical  errors.  1.0E-6  can  be  good
       value to start with.
    4. Numerical  differentiation  is   very   inefficient  -   one   gradient
       calculation needs 4*N function evaluations. This function will work for
       any N - either small (1...10), moderate (10...100) or  large  (100...).
       However, performance penalty will be too severe for any N's except  for
       small ones.
       We should also say that code which relies on numerical  differentiation
       is   less  robust  and  precise.  LBFGS  needs  exact  gradient values.
       Imprecise gradient may slow  down  convergence,  especially  on  highly
       nonlinear problems.
       Thus  we  recommend to use this function for fast prototyping on small-
       dimensional problems only, and to implement analytical gradient as soon
       as possible.

      -- ALGLIB --
         Copyright 16.05.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgscreatef(int n, int m, double[] x, double diffstep, out minlbfgsstate state)
    {
        state = new minlbfgsstate();
        minlbfgs.minlbfgscreatef(n, m, x, diffstep, state.innerobj);
        return;
    }
    public static void minlbfgscreatef(int m, double[] x, double diffstep, out minlbfgsstate state)
    {
        int n;

        state = new minlbfgsstate();
        n = ap.len(x);
        minlbfgs.minlbfgscreatef(n, m, x, diffstep, state.innerobj);

        return;
    }

    /*************************************************************************
    This function sets stopping conditions for L-BFGS optimization algorithm.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinLBFGSSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes  its work if on k+1-th iteration
                    the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                    is satisfied.
        EpsX    -   >=0
                    The subroutine finishes its work if  on  k+1-th  iteration
                    the condition |v|<=EpsX is fulfilled, where:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - ste pvector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinLBFGSSetScale()
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations is unlimited.

    Passing EpsG=0, EpsF=0, EpsX=0 and MaxIts=0 (simultaneously) will lead to
    automatic stopping criterion selection (small EpsX).

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetcond(minlbfgsstate state, double epsg, double epsf, double epsx, int maxits)
    {

        minlbfgs.minlbfgssetcond(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function turns on/off reporting.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        NeedXRep-   whether iteration reports are needed or not

    If NeedXRep is True, algorithm will call rep() callback function if  it is
    provided to MinLBFGSOptimize().


      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetxrep(minlbfgsstate state, bool needxrep)
    {

        minlbfgs.minlbfgssetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    This function sets maximum step length

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        StpMax  -   maximum step length, >=0. Set StpMax to 0.0 (default),  if
                    you don't want to limit step length.

    Use this subroutine when you optimize target function which contains exp()
    or  other  fast  growing  functions,  and optimization algorithm makes too
    large  steps  which  leads  to overflow. This function allows us to reject
    steps  that  are  too  large  (and  therefore  expose  us  to the possible
    overflow) without actually calculating function value at the x+stp*d.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetstpmax(minlbfgsstate state, double stpmax)
    {

        minlbfgs.minlbfgssetstpmax(state.innerobj, stpmax);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients for LBFGS optimizer.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    Scaling is also used by finite difference variant of the optimizer  - step
    along I-th axis is equal to DiffStep*S[I].

    In  most  optimizers  (and  in  the  LBFGS  too)  scaling is NOT a form of
    preconditioning. It just  affects  stopping  conditions.  You  should  set
    preconditioner  by  separate  call  to  one  of  the  MinLBFGSSetPrec...()
    functions.

    There  is  special  preconditioning  mode, however,  which  uses   scaling
    coefficients to form diagonal preconditioning matrix. You  can  turn  this
    mode on, if you want.   But  you should understand that scaling is not the
    same thing as preconditioning - these are two different, although  related
    forms of tuning solver.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 14.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetscale(minlbfgsstate state, double[] s)
    {

        minlbfgs.minlbfgssetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    Modification  of  the  preconditioner:  default  preconditioner    (simple
    scaling, same for all elements of X) is used.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
    iterations.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetprecdefault(minlbfgsstate state)
    {

        minlbfgs.minlbfgssetprecdefault(state.innerobj);
        return;
    }

    /*************************************************************************
    Modification of the preconditioner: Cholesky factorization of  approximate
    Hessian is used.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        P       -   triangular preconditioner, Cholesky factorization of
                    the approximate Hessian. array[0..N-1,0..N-1],
                    (if larger, only leading N elements are used).
        IsUpper -   whether upper or lower triangle of P is given
                    (other triangle is not referenced)

    After call to this function preconditioner is changed to P  (P  is  copied
    into the internal buffer).

    NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
    iterations.

    NOTE 2:  P  should  be nonsingular. Exception will be thrown otherwise.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetpreccholesky(minlbfgsstate state, double[,] p, bool isupper)
    {

        minlbfgs.minlbfgssetpreccholesky(state.innerobj, p, isupper);
        return;
    }

    /*************************************************************************
    Modification  of  the  preconditioner:  diagonal of approximate Hessian is
    used.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        D       -   diagonal of the approximate Hessian, array[0..N-1],
                    (if larger, only leading N elements are used).

    NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
    iterations.

    NOTE 2: D[i] should be positive. Exception will be thrown otherwise.

    NOTE 3: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetprecdiag(minlbfgsstate state, double[] d)
    {

        minlbfgs.minlbfgssetprecdiag(state.innerobj, d);
        return;
    }

    /*************************************************************************
    Modification of the preconditioner: scale-based diagonal preconditioning.

    This preconditioning mode can be useful when you  don't  have  approximate
    diagonal of Hessian, but you know that your  variables  are  badly  scaled
    (for  example,  one  variable is in [1,10], and another in [1000,100000]),
    and most part of the ill-conditioning comes from different scales of vars.

    In this case simple  scale-based  preconditioner,  with H[i] = 1/(s[i]^2),
    can greatly improve convergence.

    IMPRTANT: you should set scale of your variables  with  MinLBFGSSetScale()
    call  (before  or after MinLBFGSSetPrecScale() call). Without knowledge of
    the scale of your variables scale-based preconditioner will be  just  unit
    matrix.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetprecscale(minlbfgsstate state)
    {

        minlbfgs.minlbfgssetprecscale(state.innerobj);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool minlbfgsiteration(minlbfgsstate state)
    {

        bool result = minlbfgs.minlbfgsiteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        func    -   callback which calculates function (or merit function)
                    value func at given point x
        grad    -   callback which calculates function (or merit function)
                    value func and gradient grad at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null

    NOTES:

    1. This function has two different implementations: one which  uses  exact
       (analytical) user-supplied gradient,  and one which uses function value
       only  and  numerically  differentiates  function  in  order  to  obtain
       gradient.

       Depending  on  the  specific  function  used to create optimizer object
       (either MinLBFGSCreate() for analytical gradient  or  MinLBFGSCreateF()
       for numerical differentiation) you should choose appropriate variant of
       MinLBFGSOptimize() - one  which  accepts  function  AND gradient or one
       which accepts function ONLY.

       Be careful to choose variant of MinLBFGSOptimize() which corresponds to
       your optimization scheme! Table below lists different  combinations  of
       callback (function/gradient) passed to MinLBFGSOptimize()  and specific
       function used to create optimizer.


                         |         USER PASSED TO MinLBFGSOptimize()
       CREATED WITH      |  function only   |  function and gradient
       ------------------------------------------------------------
       MinLBFGSCreateF() |     work                FAIL
       MinLBFGSCreate()  |     FAIL                work

       Here "FAIL" denotes inappropriate combinations  of  optimizer  creation
       function  and  MinLBFGSOptimize()  version.   Attemps   to   use   such
       combination (for example, to create optimizer with MinLBFGSCreateF() and
       to pass gradient information to MinCGOptimize()) will lead to exception
       being thrown. Either  you  did  not pass gradient when it WAS needed or
       you passed gradient when it was NOT needed.

      -- ALGLIB --
         Copyright 20.03.2009 by Bochkanov Sergey

    *************************************************************************/
    public static void minlbfgsoptimize(minlbfgsstate state, ndimensional_func func, ndimensional_rep rep, object obj)
    {
        if( func==null )
            throw new alglibexception("ALGLIB: error in 'minlbfgsoptimize()' (func is null)");
        while( alglib.minlbfgsiteration(state) )
        {
            if( state.needf )
            {
                func(state.x, ref state.innerobj.f, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlbfgsoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minlbfgsoptimize(minlbfgsstate state, ndimensional_grad grad, ndimensional_rep rep, object obj)
    {
        if( grad==null )
            throw new alglibexception("ALGLIB: error in 'minlbfgsoptimize()' (grad is null)");
        while( alglib.minlbfgsiteration(state) )
        {
            if( state.needfg )
            {
                grad(state.x, ref state.innerobj.f, state.innerobj.g, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlbfgsoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    L-BFGS algorithm results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution
        Rep     -   optimization report:
                    * Rep.TerminationType completetion code:
                        * -8    internal integrity control  detected  infinite
                                or NAN values in  function/gradient.  Abnormal
                                termination signalled.
                        * -7    gradient verification failed.
                                See MinLBFGSSetGradientCheck() for more information.
                        * -2    rounding errors prevent further improvement.
                                X contains best point found.
                        * -1    incorrect parameters were specified
                        *  1    relative function improvement is no more than
                                EpsF.
                        *  2    relative step is no more than EpsX.
                        *  4    gradient norm is no more than EpsG
                        *  5    MaxIts steps was taken
                        *  7    stopping conditions are too stringent,
                                further improvement is impossible
                        *  8    terminated by user who called minlbfgsrequesttermination().
                                X contains point which was "current accepted" when
                                termination request was submitted.
                    * Rep.IterationsCount contains iterations count
                    * NFEV countains number of function calculations

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgsresults(minlbfgsstate state, out double[] x, out minlbfgsreport rep)
    {
        x = new double[0];
        rep = new minlbfgsreport();
        minlbfgs.minlbfgsresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    L-BFGS algorithm results

    Buffered implementation of MinLBFGSResults which uses pre-allocated buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 20.08.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgsresultsbuf(minlbfgsstate state, ref double[] x, minlbfgsreport rep)
    {

        minlbfgs.minlbfgsresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    This  subroutine restarts LBFGS algorithm from new point. All optimization
    parameters are left unchanged.

    This  function  allows  to  solve multiple  optimization  problems  (which
    must have same number of dimensions) without object reallocation penalty.

    INPUT PARAMETERS:
        State   -   structure used to store algorithm state
        X       -   new starting point.

      -- ALGLIB --
         Copyright 30.07.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgsrestartfrom(minlbfgsstate state, double[] x)
    {

        minlbfgs.minlbfgsrestartfrom(state.innerobj, x);
        return;
    }

    /*************************************************************************
    This subroutine submits request for termination of running  optimizer.  It
    should be called from user-supplied callback when user decides that it  is
    time to "smoothly" terminate optimization process.  As  result,  optimizer
    stops at point which was "current accepted" when termination  request  was
    submitted and returns error code 8 (successful termination).

    INPUT PARAMETERS:
        State   -   optimizer structure

    NOTE: after  request  for  termination  optimizer  may   perform   several
          additional calls to user-supplied callbacks. It does  NOT  guarantee
          to stop immediately - it just guarantees that these additional calls
          will be discarded later.

    NOTE: calling this function on optimizer which is NOT running will have no
          effect.

    NOTE: multiple calls to this function are possible. First call is counted,
          subsequent calls are silently ignored.

      -- ALGLIB --
         Copyright 08.10.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgsrequesttermination(minlbfgsstate state)
    {

        minlbfgs.minlbfgsrequesttermination(state.innerobj);
        return;
    }

    /*************************************************************************
    This  subroutine  turns  on  verification  of  the  user-supplied analytic
    gradient:
    * user calls this subroutine before optimization begins
    * MinLBFGSOptimize() is called
    * prior to  actual  optimization, for each component  of  parameters being
      optimized X[i] algorithm performs following steps:
      * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
        where X[i] is i-th component of the initial point and S[i] is a  scale
        of i-th parameter
      * if needed, steps are bounded with respect to constraints on X[]
      * F(X) is evaluated at these trial points
      * we perform one more evaluation in the middle point of the interval
      * we  build  cubic  model using function values and derivatives at trial
        points and we compare its prediction with actual value in  the  middle
        point
      * in case difference between prediction and actual value is higher  than
        some predetermined threshold, algorithm stops with completion code -7;
        Rep.VarIdx is set to index of the parameter with incorrect derivative.
    * after verification is over, algorithm proceeds to the actual optimization.

    NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
            is very costly and you should use  it  only  for  low  dimensional
            problems,  when  you  want  to  be  sure  that  you've   correctly
            calculated  analytic  derivatives.  You  should  not use it in the
            production code (unless you want to check derivatives provided  by
            some third party).

    NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
            (so large that function behaviour is significantly non-cubic) will
            lead to false alarms. You may use  different  step  for  different
            parameters by means of setting scale with MinLBFGSSetScale().

    NOTE 3: this function may lead to false positives. In case it reports that
            I-th  derivative was calculated incorrectly, you may decrease test
            step  and  try  one  more  time  - maybe your function changes too
            sharply  and  your  step  is  too  large for such rapidly chanding
            function.

    INPUT PARAMETERS:
        State       -   structure used to store algorithm state
        TestStep    -   verification step:
                        * TestStep=0 turns verification off
                        * TestStep>0 activates verification

      -- ALGLIB --
         Copyright 24.05.2012 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetgradientcheck(minlbfgsstate state, double teststep)
    {

        minlbfgs.minlbfgssetgradientcheck(state.innerobj, teststep);
        return;
    }

}
public partial class alglib
{



}
public partial class alglib
{



}
public partial class alglib
{



}
public partial class alglib
{


    /*************************************************************************
    This object stores nonlinear optimizer state.
    You should use functions provided by MinQP subpackage to work with this
    object
    *************************************************************************/
    public class minqpstate : alglibobject
    {
        //
        // Public declarations
        //

        public minqpstate()
        {
            _innerobj = new minqp.minqpstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minqpstate((minqp.minqpstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minqp.minqpstate _innerobj;
        public minqp.minqpstate innerobj { get { return _innerobj; } }
        public minqpstate(minqp.minqpstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    This structure stores optimization report:
    * InnerIterationsCount      number of inner iterations
    * OuterIterationsCount      number of outer iterations
    * NCholesky                 number of Cholesky decomposition
    * NMV                       number of matrix-vector products
                                (only products calculated as part of iterative
                                process are counted)
    * TerminationType           completion code (see below)

    Completion codes:
    * -5    inappropriate solver was used:
            * QuickQP solver for problem with general linear constraints
            * Cholesky solver for semidefinite or indefinite problems
            * Cholesky solver for problems with non-boundary constraints
    * -4    BLEIC-QP or QuickQP solver found unconstrained direction
            of negative curvature (function is unbounded from
            below  even  under  constraints),  no  meaningful
            minimum can be found.
    * -3    inconsistent constraints (or, maybe, feasible point is
            too hard to find). If you are sure that constraints are feasible,
            try to restart optimizer with better initial approximation.
    * -1    solver error
    *  1..4 successful completion
    *  5    MaxIts steps was taken
    *  7    stopping conditions are too stringent,
            further improvement is impossible,
            X contains best point found so far.
    *************************************************************************/
    public class minqpreport : alglibobject
    {
        //
        // Public declarations
        //
        public int inneriterationscount { get { return _innerobj.inneriterationscount; } set { _innerobj.inneriterationscount = value; } }
        public int outeriterationscount { get { return _innerobj.outeriterationscount; } set { _innerobj.outeriterationscount = value; } }
        public int nmv { get { return _innerobj.nmv; } set { _innerobj.nmv = value; } }
        public int ncholesky { get { return _innerobj.ncholesky; } set { _innerobj.ncholesky = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }

        public minqpreport()
        {
            _innerobj = new minqp.minqpreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minqpreport((minqp.minqpreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minqp.minqpreport _innerobj;
        public minqp.minqpreport innerobj { get { return _innerobj; } }
        public minqpreport(minqp.minqpreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
                        CONSTRAINED QUADRATIC PROGRAMMING

    The subroutine creates QP optimizer. After initial creation,  it  contains
    default optimization problem with zero quadratic and linear terms  and  no
    constraints. You should set quadratic/linear terms with calls to functions
    provided by MinQP subpackage.

    You should also choose appropriate QP solver and set it  and  its stopping
    criteria by means of MinQPSetAlgo??????() function. Then, you should start
    solution process by means of MinQPOptimize() call. Solution itself can  be
    obtained with MinQPResults() function.

    INPUT PARAMETERS:
        N       -   problem size

    OUTPUT PARAMETERS:
        State   -   optimizer with zero quadratic/linear terms
                    and no constraints

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpcreate(int n, out minqpstate state)
    {
        state = new minqpstate();
        minqp.minqpcreate(n, state.innerobj);
        return;
    }

    /*************************************************************************
    This function sets linear term for QP solver.

    By default, linear term is zero.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        B       -   linear term, array[N].

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetlinearterm(minqpstate state, double[] b)
    {

        minqp.minqpsetlinearterm(state.innerobj, b);
        return;
    }

    /*************************************************************************
    This  function  sets  dense  quadratic  term  for  QP solver. By  default,
    quadratic term is zero.

    SUPPORT BY ALGLIB QP ALGORITHMS:

    Dense quadratic term can be handled by any of the QP algorithms  supported
    by ALGLIB QP Solver.

    IMPORTANT:

    This solver minimizes following  function:
        f(x) = 0.5*x'*A*x + b'*x.
    Note that quadratic term has 0.5 before it. So if  you  want  to  minimize
        f(x) = x^2 + x
    you should rewrite your problem as follows:
        f(x) = 0.5*(2*x^2) + x
    and your matrix A will be equal to [[2.0]], not to [[1.0]]

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        A       -   matrix, array[N,N]
        IsUpper -   (optional) storage type:
                    * if True, symmetric matrix  A  is  given  by  its  upper
                      triangle, and the lower triangle isnt used
                    * if False, symmetric matrix  A  is  given  by  its lower
                      triangle, and the upper triangle isnt used
                    * if not given, both lower and upper  triangles  must  be
                      filled.

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetquadraticterm(minqpstate state, double[,] a, bool isupper)
    {

        minqp.minqpsetquadraticterm(state.innerobj, a, isupper);
        return;
    }
    public static void minqpsetquadraticterm(minqpstate state, double[,] a)
    {
        bool isupper;
        if( !alglib.ap.issymmetric(a) )
            throw new alglibexception("'a' parameter is not symmetric matrix");

        isupper = false;
        minqp.minqpsetquadraticterm(state.innerobj, a, isupper);

        return;
    }

    /*************************************************************************
    This  function  sets  sparse  quadratic  term  for  QP solver. By default,
    quadratic term is zero.

    IMPORTANT:

    This solver minimizes following  function:
        f(x) = 0.5*x'*A*x + b'*x.
    Note that quadratic term has 0.5 before it. So if  you  want  to  minimize
        f(x) = x^2 + x
    you should rewrite your problem as follows:
        f(x) = 0.5*(2*x^2) + x
    and your matrix A will be equal to [[2.0]], not to [[1.0]]

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        A       -   matrix, array[N,N]
        IsUpper -   (optional) storage type:
                    * if True, symmetric matrix  A  is  given  by  its  upper
                      triangle, and the lower triangle isnt used
                    * if False, symmetric matrix  A  is  given  by  its lower
                      triangle, and the upper triangle isnt used
                    * if not given, both lower and upper  triangles  must  be
                      filled.

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetquadratictermsparse(minqpstate state, sparsematrix a, bool isupper)
    {

        minqp.minqpsetquadratictermsparse(state.innerobj, a.innerobj, isupper);
        return;
    }

    /*************************************************************************
    This function sets starting point for QP solver. It is useful to have
    good initial approximation to the solution, because it will increase
    speed of convergence and identification of active constraints.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        X       -   starting point, array[N].

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetstartingpoint(minqpstate state, double[] x)
    {

        minqp.minqpsetstartingpoint(state.innerobj, x);
        return;
    }

    /*************************************************************************
    This  function sets origin for QP solver. By default, following QP program
    is solved:

        min(0.5*x'*A*x+b'*x)

    This function allows to solve different problem:

        min(0.5*(x-x_origin)'*A*(x-x_origin)+b'*(x-x_origin))

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        XOrigin -   origin, array[N].

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetorigin(minqpstate state, double[] xorigin)
    {

        minqp.minqpsetorigin(state.innerobj, xorigin);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    BLEIC-based QP solver uses scale for two purposes:
    * to evaluate stopping conditions
    * for preconditioning of the underlying BLEIC solver

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 14.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetscale(minqpstate state, double[] s)
    {

        minqp.minqpsetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    This function tells solver to use Cholesky-based algorithm. This algorithm
    was deprecated in ALGLIB 3.9.0 because its performance is inferior to that
    of BLEIC-QP or  QuickQP  on  high-dimensional  problems.  Furthermore,  it
    supports only dense convex QP problems.

    This solver is no longer active by default.

    We recommend you to switch to BLEIC-QP or QuickQP solver.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetalgocholesky(minqpstate state)
    {

        minqp.minqpsetalgocholesky(state.innerobj);
        return;
    }

    /*************************************************************************
    This function tells solver to use BLEIC-based algorithm and sets  stopping
    criteria for the algorithm.

    ALGORITHM FEATURES:

    * supports dense and sparse QP problems
    * supports boundary and general linear equality/inequality constraints
    * can solve all types of problems  (convex,  semidefinite,  nonconvex)  as
      long as they are bounded from below under constraints.
      Say, it is possible to solve "min{-x^2} subject to -1<=x<=+1".
      Of course, global  minimum  is found only  for  positive  definite   and
      semidefinite  problems.  As  for indefinite ones - only local minimum is
      found.

    ALGORITHM OUTLINE:

    * BLEIC-QP solver is just a driver function for MinBLEIC solver; it solves
      quadratic  programming   problem   as   general   linearly   constrained
      optimization problem, which is solved by means of BLEIC solver  (part of
      ALGLIB, active set method).

    ALGORITHM LIMITATIONS:

    * unlike QuickQP solver, this algorithm does not perform Newton steps  and
      does not use Level 3 BLAS. Being general-purpose active set  method,  it
      can activate constraints only one-by-one. Thus, its performance is lower
      than that of QuickQP.
    * its precision is also a bit  inferior  to  that  of   QuickQP.  BLEIC-QP
      performs only LBFGS steps (no Newton steps), which are good at detecting
      neighborhood of the solution, buy need many iterations to find  solution
      with more than 6 digits of precision.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled constrained gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinQPSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes its work if exploratory steepest
                    descent  step  on  k+1-th iteration  satisfies   following
                    condition:  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
        EpsX    -   >=0
                    The  subroutine  finishes its work if exploratory steepest
                    descent  step  on  k+1-th iteration  satisfies   following
                    condition:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - step vector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinQPSetScale()
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations is unlimited. NOTE: this  algorithm uses  LBFGS
                    iterations,  which  are  relatively  cheap,  but   improve
                    function value only a bit. So you will need many iterations
                    to converge - from 0.1*N to 10*N, depending  on  problem's
                    condition number.

    IT IS VERY IMPORTANT TO CALL MinQPSetScale() WHEN YOU USE THIS  ALGORITHM
    BECAUSE ITS STOPPING CRITERIA ARE SCALE-DEPENDENT!

    Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
    to automatic stopping criterion selection (presently it is  small    step
    length, but it may change in the future versions of ALGLIB).

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetalgobleic(minqpstate state, double epsg, double epsf, double epsx, int maxits)
    {

        minqp.minqpsetalgobleic(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function tells solver to use QuickQP  algorithm:  special  extra-fast
    algorithm   for   problems  with  boundary-only constrants. It  may  solve
    non-convex  problems  as  long  as  they  are  bounded  from  below  under
    constraints.

    ALGORITHM FEATURES:
    * many times (from 5x to 50x!) faster than BLEIC-based QP solver; utilizes
      accelerated methods for activation of constraints.
    * supports dense and sparse QP problems
    * supports ONLY boundary constraints; general linear constraints  are  NOT
      supported by this solver
    * can solve all types of problems  (convex,  semidefinite,  nonconvex)  as
      long as they are bounded from below under constraints.
      Say, it is possible to solve "min{-x^2} subject to -1<=x<=+1".
      In convex/semidefinite case global minimum  is  returned,  in  nonconvex
      case - algorithm returns one of the local minimums.

    ALGORITHM OUTLINE:

    * algorithm  performs  two kinds of iterations: constrained CG  iterations
      and constrained Newton iterations
    * initially it performs small number of constrained CG  iterations,  which
      can efficiently activate/deactivate multiple constraints
    * after CG phase algorithm tries to calculate Cholesky  decomposition  and
      to perform several constrained Newton steps. If  Cholesky  decomposition
      failed (matrix is indefinite even under constraints),  we  perform  more
      CG iterations until we converge to such set of constraints  that  system
      matrix becomes  positive  definite.  Constrained  Newton  steps  greatly
      increase convergence speed and precision.
    * algorithm interleaves CG and Newton iterations which  allows  to  handle
      indefinite matrices (CG phase) and quickly converge after final  set  of
      constraints is found (Newton phase). Combination of CG and Newton phases
      is called "outer iteration".
    * it is possible to turn off Newton  phase  (beneficial  for  semidefinite
      problems - Cholesky decomposition will fail too often)

    ALGORITHM LIMITATIONS:

    * algorithm does not support general  linear  constraints;  only  boundary
      ones are supported
    * Cholesky decomposition for sparse problems  is  performed  with  Skyline
      Cholesky solver, which is intended for low-profile matrices. No profile-
      reducing reordering of variables is performed in this version of ALGLIB.
    * problems with near-zero negative eigenvalues (or exacty zero  ones)  may
      experience about 2-3x performance penalty. The reason is  that  Cholesky
      decomposition can not be performed until we identify directions of  zero
      and negative curvature and activate corresponding boundary constraints -
      but we need a lot of trial and errors because these directions  are hard
      to notice in the matrix spectrum.
      In this case you may turn off Newton phase of algorithm.
      Large negative eigenvalues  are  not  an  issue,  so  highly  non-convex
      problems can be solved very efficiently.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled constrained gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinQPSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes its work if exploratory steepest
                    descent  step  on  k+1-th iteration  satisfies   following
                    condition:  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
        EpsX    -   >=0
                    The  subroutine  finishes its work if exploratory steepest
                    descent  step  on  k+1-th iteration  satisfies   following
                    condition:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - step vector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinQPSetScale()
        MaxOuterIts-maximum number of OUTER iterations.  One  outer  iteration
                    includes some amount of CG iterations (from 5 to  ~N)  and
                    one or several (usually small amount) Newton steps.  Thus,
                    one outer iteration has high cost, but can greatly  reduce
                    funcation value.
        UseNewton-  use Newton phase or not:
                    * Newton phase improves performance of  positive  definite
                      dense problems (about 2 times improvement can be observed)
                    * can result in some performance penalty  on  semidefinite
                      or slightly negative definite  problems  -  each  Newton
                      phase will bring no improvement (Cholesky failure),  but
                      still will require computational time.
                    * if you doubt, you can turn off this  phase  -  optimizer
                      will retain its most of its high speed.

    IT IS VERY IMPORTANT TO CALL MinQPSetScale() WHEN YOU USE THIS  ALGORITHM
    BECAUSE ITS STOPPING CRITERIA ARE SCALE-DEPENDENT!

    Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
    to automatic stopping criterion selection (presently it is  small    step
    length, but it may change in the future versions of ALGLIB).

      -- ALGLIB --
         Copyright 22.05.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetalgoquickqp(minqpstate state, double epsg, double epsf, double epsx, int maxouterits, bool usenewton)
    {

        minqp.minqpsetalgoquickqp(state.innerobj, epsg, epsf, epsx, maxouterits, usenewton);
        return;
    }

    /*************************************************************************
    This function sets boundary constraints for QP solver

    Boundary constraints are inactive by default (after initial creation).
    After  being  set,  they  are  preserved  until explicitly turned off with
    another SetBC() call.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        BndL    -   lower bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very small number or -INF (latter is recommended because
                    it will allow solver to use better algorithm).
        BndU    -   upper bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very large number or +INF (latter is recommended because
                    it will allow solver to use better algorithm).

    NOTE: it is possible to specify BndL[i]=BndU[i]. In this case I-th
    variable will be "frozen" at X[i]=BndL[i]=BndU[i].

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetbc(minqpstate state, double[] bndl, double[] bndu)
    {

        minqp.minqpsetbc(state.innerobj, bndl, bndu);
        return;
    }

    /*************************************************************************
    This function sets linear constraints for QP optimizer.

    Linear constraints are inactive by default (after initial creation).

    INPUT PARAMETERS:
        State   -   structure previously allocated with MinQPCreate call.
        C       -   linear constraints, array[K,N+1].
                    Each row of C represents one constraint, either equality
                    or inequality (see below):
                    * first N elements correspond to coefficients,
                    * last element corresponds to the right part.
                    All elements of C (including right part) must be finite.
        CT      -   type of constraints, array[K]:
                    * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                    * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                    * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
        K       -   number of equality/inequality constraints, K>=0:
                    * if given, only leading K elements of C/CT are used
                    * if not given, automatically determined from sizes of C/CT

    NOTE 1: linear (non-bound) constraints are satisfied only approximately  -
            there always exists some minor violation (about 10^-10...10^-13)
            due to numerical errors.

      -- ALGLIB --
         Copyright 19.06.2012 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpsetlc(minqpstate state, double[,] c, int[] ct, int k)
    {

        minqp.minqpsetlc(state.innerobj, c, ct, k);
        return;
    }
    public static void minqpsetlc(minqpstate state, double[,] c, int[] ct)
    {
        int k;
        if( (ap.rows(c)!=ap.len(ct)))
            throw new alglibexception("Error while calling 'minqpsetlc': looks like one of arguments has wrong size");

        k = ap.rows(c);
        minqp.minqpsetlc(state.innerobj, c, ct, k);

        return;
    }

    /*************************************************************************
    This function solves quadratic programming problem.

    Prior to calling this function you should choose solver by means of one of
    the following functions:

    * MinQPSetAlgoQuickQP() - for QuickQP solver
    * MinQPSetAlgoBLEIC() - for BLEIC-QP solver

    These functions also allow you to control stopping criteria of the solver.
    If you did not set solver,  MinQP  subpackage  will  automatically  select
    solver for your problem and will run it with default stopping criteria.

    However, it is better to set explicitly solver and its stopping criteria.

    INPUT PARAMETERS:
        State   -   algorithm state

    You should use MinQPResults() function to access results after calls
    to this function.

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey.
         Special thanks to Elvira Illarionova  for  important  suggestions  on
         the linearly constrained QP algorithm.
    *************************************************************************/
    public static void minqpoptimize(minqpstate state)
    {

        minqp.minqpoptimize(state.innerobj);
        return;
    }

    /*************************************************************************
    QP solver results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution.
                    This array is allocated and initialized only when
                    Rep.TerminationType parameter is positive (success).
        Rep     -   optimization report. You should check Rep.TerminationType,
                    which contains completion code, and you may check  another
                    fields which contain another information  about  algorithm
                    functioning.

                    Failure codes returned by algorithm are:
                    * -5    inappropriate solver was used:
                            * Cholesky solver for (semi)indefinite problems
                            * Cholesky solver for problems with sparse matrix
                            * QuickQP solver for problem with  general  linear
                              constraints
                    * -4    BLEIC-QP/QuickQP   solver    found   unconstrained
                            direction  of   negative  curvature  (function  is
                            unbounded from below even under constraints),   no
                            meaningful minimum can be found.
                    * -3    inconsistent constraints (or maybe  feasible point
                            is too  hard  to  find).  If  you  are  sure  that
                            constraints are feasible, try to restart optimizer
                            with better initial approximation.

                    Completion codes specific for Cholesky algorithm:
                    *  4   successful completion

                    Completion codes specific for BLEIC/QuickQP algorithms:
                    *  1   relative function improvement is no more than EpsF.
                    *  2   scaled step is no more than EpsX.
                    *  4   scaled gradient norm is no more than EpsG.
                    *  5   MaxIts steps was taken

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpresults(minqpstate state, out double[] x, out minqpreport rep)
    {
        x = new double[0];
        rep = new minqpreport();
        minqp.minqpresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    QP results

    Buffered implementation of MinQPResults() which uses pre-allocated  buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 11.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minqpresultsbuf(minqpstate state, ref double[] x, minqpreport rep)
    {

        minqp.minqpresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

}
public partial class alglib
{


    /*************************************************************************
    Levenberg-Marquardt optimizer.

    This structure should be created using one of the MinLMCreate???()
    functions. You should not access its fields directly; use ALGLIB functions
    to work with it.
    *************************************************************************/
    public class minlmstate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needf { get { return _innerobj.needf; } set { _innerobj.needf = value; } }
        public bool needfg { get { return _innerobj.needfg; } set { _innerobj.needfg = value; } }
        public bool needfgh { get { return _innerobj.needfgh; } set { _innerobj.needfgh = value; } }
        public bool needfi { get { return _innerobj.needfi; } set { _innerobj.needfi = value; } }
        public bool needfij { get { return _innerobj.needfij; } set { _innerobj.needfij = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] fi { get { return _innerobj.fi; } }
        public double[] g { get { return _innerobj.g; } }
        public double[,] h { get { return _innerobj.h; } }
        public double[,] j { get { return _innerobj.j; } }
        public double[] x { get { return _innerobj.x; } }

        public minlmstate()
        {
            _innerobj = new minlm.minlmstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minlmstate((minlm.minlmstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minlm.minlmstate _innerobj;
        public minlm.minlmstate innerobj { get { return _innerobj; } }
        public minlmstate(minlm.minlmstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    Optimization report, filled by MinLMResults() function

    FIELDS:
    * TerminationType, completetion code:
        * -7    derivative correctness check failed;
                see rep.funcidx, rep.varidx for
                more information.
        * -3    constraints are inconsistent
        *  1    relative function improvement is no more than
                EpsF.
        *  2    relative step is no more than EpsX.
        *  4    gradient is no more than EpsG.
        *  5    MaxIts steps was taken
        *  7    stopping conditions are too stringent,
                further improvement is impossible
        *  8    terminated   by  user  who  called  MinLMRequestTermination().
                X contains point which was "current accepted" when termination
                request was submitted.
    * IterationsCount, contains iterations count
    * NFunc, number of function calculations
    * NJac, number of Jacobi matrix calculations
    * NGrad, number of gradient calculations
    * NHess, number of Hessian calculations
    * NCholesky, number of Cholesky decomposition calculations
    *************************************************************************/
    public class minlmreport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }
        public int funcidx { get { return _innerobj.funcidx; } set { _innerobj.funcidx = value; } }
        public int varidx { get { return _innerobj.varidx; } set { _innerobj.varidx = value; } }
        public int nfunc { get { return _innerobj.nfunc; } set { _innerobj.nfunc = value; } }
        public int njac { get { return _innerobj.njac; } set { _innerobj.njac = value; } }
        public int ngrad { get { return _innerobj.ngrad; } set { _innerobj.ngrad = value; } }
        public int nhess { get { return _innerobj.nhess; } set { _innerobj.nhess = value; } }
        public int ncholesky { get { return _innerobj.ncholesky; } set { _innerobj.ncholesky = value; } }

        public minlmreport()
        {
            _innerobj = new minlm.minlmreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minlmreport((minlm.minlmreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minlm.minlmreport _innerobj;
        public minlm.minlmreport innerobj { get { return _innerobj; } }
        public minlmreport(minlm.minlmreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
                    IMPROVED LEVENBERG-MARQUARDT METHOD FOR
                     NON-LINEAR LEAST SQUARES OPTIMIZATION

    DESCRIPTION:
    This function is used to find minimum of function which is represented  as
    sum of squares:
        F(x) = f[0]^2(x[0],...,x[n-1]) + ... + f[m-1]^2(x[0],...,x[n-1])
    using value of function vector f[] and Jacobian of f[].


    REQUIREMENTS:
    This algorithm will request following information during its operation:

    * function vector f[] at given point X
    * function vector f[] and Jacobian of f[] (simultaneously) at given point

    There are several overloaded versions of  MinLMOptimize()  function  which
    correspond  to  different LM-like optimization algorithms provided by this
    unit. You should choose version which accepts fvec()  and jac() callbacks.
    First  one  is used to calculate f[] at given point, second one calculates
    f[] and Jacobian df[i]/dx[j].

    You can try to initialize MinLMState structure with VJ  function and  then
    use incorrect version  of  MinLMOptimize()  (for  example,  version  which
    works  with  general  form function and does not provide Jacobian), but it
    will  lead  to  exception  being  thrown  after first attempt to calculate
    Jacobian.


    USAGE:
    1. User initializes algorithm state with MinLMCreateVJ() call
    2. User tunes solver parameters with MinLMSetCond(),  MinLMSetStpMax() and
       other functions
    3. User calls MinLMOptimize() function which  takes algorithm  state   and
       callback functions.
    4. User calls MinLMResults() to get solution
    5. Optionally, user may call MinLMRestartFrom() to solve  another  problem
       with same N/M but another starting point and/or another function.
       MinLMRestartFrom() allows to reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   dimension, N>1
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        M       -   number of functions f[i]
        X       -   initial solution, array[0..N-1]

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTES:
    1. you may tune stopping conditions with MinLMSetCond() function
    2. if target function contains exp() or other fast growing functions,  and
       optimization algorithm makes too large steps which leads  to  overflow,
       use MinLMSetStpMax() function to bound algorithm's steps.

      -- ALGLIB --
         Copyright 30.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmcreatevj(int n, int m, double[] x, out minlmstate state)
    {
        state = new minlmstate();
        minlm.minlmcreatevj(n, m, x, state.innerobj);
        return;
    }
    public static void minlmcreatevj(int m, double[] x, out minlmstate state)
    {
        int n;

        state = new minlmstate();
        n = ap.len(x);
        minlm.minlmcreatevj(n, m, x, state.innerobj);

        return;
    }

    /*************************************************************************
                    IMPROVED LEVENBERG-MARQUARDT METHOD FOR
                     NON-LINEAR LEAST SQUARES OPTIMIZATION

    DESCRIPTION:
    This function is used to find minimum of function which is represented  as
    sum of squares:
        F(x) = f[0]^2(x[0],...,x[n-1]) + ... + f[m-1]^2(x[0],...,x[n-1])
    using value of function vector f[] only. Finite differences  are  used  to
    calculate Jacobian.


    REQUIREMENTS:
    This algorithm will request following information during its operation:
    * function vector f[] at given point X

    There are several overloaded versions of  MinLMOptimize()  function  which
    correspond  to  different LM-like optimization algorithms provided by this
    unit. You should choose version which accepts fvec() callback.

    You can try to initialize MinLMState structure with VJ  function and  then
    use incorrect version  of  MinLMOptimize()  (for  example,  version  which
    works with general form function and does not accept function vector), but
    it will  lead  to  exception being thrown after first attempt to calculate
    Jacobian.


    USAGE:
    1. User initializes algorithm state with MinLMCreateV() call
    2. User tunes solver parameters with MinLMSetCond(),  MinLMSetStpMax() and
       other functions
    3. User calls MinLMOptimize() function which  takes algorithm  state   and
       callback functions.
    4. User calls MinLMResults() to get solution
    5. Optionally, user may call MinLMRestartFrom() to solve  another  problem
       with same N/M but another starting point and/or another function.
       MinLMRestartFrom() allows to reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   dimension, N>1
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        M       -   number of functions f[i]
        X       -   initial solution, array[0..N-1]
        DiffStep-   differentiation step, >0

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

    See also MinLMIteration, MinLMResults.

    NOTES:
    1. you may tune stopping conditions with MinLMSetCond() function
    2. if target function contains exp() or other fast growing functions,  and
       optimization algorithm makes too large steps which leads  to  overflow,
       use MinLMSetStpMax() function to bound algorithm's steps.

      -- ALGLIB --
         Copyright 30.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmcreatev(int n, int m, double[] x, double diffstep, out minlmstate state)
    {
        state = new minlmstate();
        minlm.minlmcreatev(n, m, x, diffstep, state.innerobj);
        return;
    }
    public static void minlmcreatev(int m, double[] x, double diffstep, out minlmstate state)
    {
        int n;

        state = new minlmstate();
        n = ap.len(x);
        minlm.minlmcreatev(n, m, x, diffstep, state.innerobj);

        return;
    }

    /*************************************************************************
        LEVENBERG-MARQUARDT-LIKE METHOD FOR NON-LINEAR OPTIMIZATION

    DESCRIPTION:
    This  function  is  used  to  find  minimum  of general form (not "sum-of-
    -squares") function
        F = F(x[0], ..., x[n-1])
    using  its  gradient  and  Hessian.  Levenberg-Marquardt modification with
    L-BFGS pre-optimization and internal pre-conditioned  L-BFGS  optimization
    after each Levenberg-Marquardt step is used.


    REQUIREMENTS:
    This algorithm will request following information during its operation:

    * function value F at given point X
    * F and gradient G (simultaneously) at given point X
    * F, G and Hessian H (simultaneously) at given point X

    There are several overloaded versions of  MinLMOptimize()  function  which
    correspond  to  different LM-like optimization algorithms provided by this
    unit. You should choose version which accepts func(),  grad()  and  hess()
    function pointers. First pointer is used to calculate F  at  given  point,
    second  one  calculates  F(x)  and  grad F(x),  third one calculates F(x),
    grad F(x), hess F(x).

    You can try to initialize MinLMState structure with FGH-function and  then
    use incorrect version of MinLMOptimize() (for example, version which  does
    not provide Hessian matrix), but it will lead to  exception  being  thrown
    after first attempt to calculate Hessian.


    USAGE:
    1. User initializes algorithm state with MinLMCreateFGH() call
    2. User tunes solver parameters with MinLMSetCond(),  MinLMSetStpMax() and
       other functions
    3. User calls MinLMOptimize() function which  takes algorithm  state   and
       pointers (delegates, etc.) to callback functions.
    4. User calls MinLMResults() to get solution
    5. Optionally, user may call MinLMRestartFrom() to solve  another  problem
       with same N but another starting point and/or another function.
       MinLMRestartFrom() allows to reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   dimension, N>1
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        X       -   initial solution, array[0..N-1]

    OUTPUT PARAMETERS:
        State   -   structure which stores algorithm state

    NOTES:
    1. you may tune stopping conditions with MinLMSetCond() function
    2. if target function contains exp() or other fast growing functions,  and
       optimization algorithm makes too large steps which leads  to  overflow,
       use MinLMSetStpMax() function to bound algorithm's steps.

      -- ALGLIB --
         Copyright 30.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmcreatefgh(int n, double[] x, out minlmstate state)
    {
        state = new minlmstate();
        minlm.minlmcreatefgh(n, x, state.innerobj);
        return;
    }
    public static void minlmcreatefgh(double[] x, out minlmstate state)
    {
        int n;

        state = new minlmstate();
        n = ap.len(x);
        minlm.minlmcreatefgh(n, x, state.innerobj);

        return;
    }

    /*************************************************************************
    This function sets stopping conditions for Levenberg-Marquardt optimization
    algorithm.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinLMSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes  its work if on k+1-th iteration
                    the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                    is satisfied.
        EpsX    -   >=0
                    The subroutine finishes its work if  on  k+1-th  iteration
                    the condition |v|<=EpsX is fulfilled, where:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - ste pvector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinLMSetScale()
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations   is    unlimited.   Only   Levenberg-Marquardt
                    iterations  are  counted  (L-BFGS/CG  iterations  are  NOT
                    counted because their cost is very low compared to that of
                    LM).

    Passing EpsG=0, EpsF=0, EpsX=0 and MaxIts=0 (simultaneously) will lead to
    automatic stopping criterion selection (small EpsX).

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetcond(minlmstate state, double epsg, double epsf, double epsx, int maxits)
    {

        minlm.minlmsetcond(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function turns on/off reporting.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        NeedXRep-   whether iteration reports are needed or not

    If NeedXRep is True, algorithm will call rep() callback function if  it is
    provided to MinLMOptimize(). Both Levenberg-Marquardt and internal  L-BFGS
    iterations are reported.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetxrep(minlmstate state, bool needxrep)
    {

        minlm.minlmsetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    This function sets maximum step length

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        StpMax  -   maximum step length, >=0. Set StpMax to 0.0,  if you don't
                    want to limit step length.

    Use this subroutine when you optimize target function which contains exp()
    or  other  fast  growing  functions,  and optimization algorithm makes too
    large  steps  which  leads  to overflow. This function allows us to reject
    steps  that  are  too  large  (and  therefore  expose  us  to the possible
    overflow) without actually calculating function value at the x+stp*d.

    NOTE: non-zero StpMax leads to moderate  performance  degradation  because
    intermediate  step  of  preconditioned L-BFGS optimization is incompatible
    with limits on step size.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetstpmax(minlmstate state, double stpmax)
    {

        minlm.minlmsetstpmax(state.innerobj, stpmax);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients for LM optimizer.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    Generally, scale is NOT considered to be a form of preconditioner.  But LM
    optimizer is unique in that it uses scaling matrix both  in  the  stopping
    condition tests and as Marquardt damping factor.

    Proper scaling is very important for the algorithm performance. It is less
    important for the quality of results, but still has some influence (it  is
    easier  to  converge  when  variables  are  properly  scaled, so premature
    stopping is possible when very badly scalled variables are  combined  with
    relaxed stopping conditions).

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 14.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetscale(minlmstate state, double[] s)
    {

        minlm.minlmsetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    This function sets boundary constraints for LM optimizer

    Boundary constraints are inactive by default (after initial creation).
    They are preserved until explicitly turned off with another SetBC() call.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        BndL    -   lower bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very small number or -INF (latter is recommended because
                    it will allow solver to use better algorithm).
        BndU    -   upper bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very large number or +INF (latter is recommended because
                    it will allow solver to use better algorithm).

    NOTE 1: it is possible to specify BndL[i]=BndU[i]. In this case I-th
    variable will be "frozen" at X[i]=BndL[i]=BndU[i].

    NOTE 2: this solver has following useful properties:
    * bound constraints are always satisfied exactly
    * function is evaluated only INSIDE area specified by bound constraints
      or at its boundary

      -- ALGLIB --
         Copyright 14.01.2011 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetbc(minlmstate state, double[] bndl, double[] bndu)
    {

        minlm.minlmsetbc(state.innerobj, bndl, bndu);
        return;
    }

    /*************************************************************************
    This function is used to change acceleration settings

    You can choose between three acceleration strategies:
    * AccType=0, no acceleration.
    * AccType=1, secant updates are used to update quadratic model after  each
      iteration. After fixed number of iterations (or after  model  breakdown)
      we  recalculate  quadratic  model  using  analytic  Jacobian  or  finite
      differences. Number of secant-based iterations depends  on  optimization
      settings: about 3 iterations - when we have analytic Jacobian, up to 2*N
      iterations - when we use finite differences to calculate Jacobian.

    AccType=1 is recommended when Jacobian  calculation  cost  is  prohibitive
    high (several Mx1 function vector calculations  followed  by  several  NxN
    Cholesky factorizations are faster than calculation of one M*N  Jacobian).
    It should also be used when we have no Jacobian, because finite difference
    approximation takes too much time to compute.

    Table below list  optimization  protocols  (XYZ  protocol  corresponds  to
    MinLMCreateXYZ) and acceleration types they support (and use by  default).

    ACCELERATION TYPES SUPPORTED BY OPTIMIZATION PROTOCOLS:

    protocol    0   1   comment
    V           +   +
    VJ          +   +
    FGH         +

    DAFAULT VALUES:

    protocol    0   1   comment
    V               x   without acceleration it is so slooooooooow
    VJ          x
    FGH         x

    NOTE: this  function should be called before optimization. Attempt to call
    it during algorithm iterations may result in unexpected behavior.

    NOTE: attempt to call this function with unsupported protocol/acceleration
    combination will result in exception being thrown.

      -- ALGLIB --
         Copyright 14.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetacctype(minlmstate state, int acctype)
    {

        minlm.minlmsetacctype(state.innerobj, acctype);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool minlmiteration(minlmstate state)
    {

        bool result = minlm.minlmiteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        func    -   callback which calculates function (or merit function)
                    value func at given point x
        grad    -   callback which calculates function (or merit function)
                    value func and gradient grad at given point x
        hess    -   callback which calculates function (or merit function)
                    value func, gradient grad and Hessian hess at given point x
        fvec    -   callback which calculates function vector fi[]
                    at given point x
        jac     -   callback which calculates function vector fi[]
                    and Jacobian jac at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null

    NOTES:

    1. Depending on function used to create state  structure,  this  algorithm
       may accept Jacobian and/or Hessian and/or gradient.  According  to  the
       said above, there ase several versions of this function,  which  accept
       different sets of callbacks.

       This flexibility opens way to subtle errors - you may create state with
       MinLMCreateFGH() (optimization using Hessian), but call function  which
       does not accept Hessian. So when algorithm will request Hessian,  there
       will be no callback to call. In this case exception will be thrown.

       Be careful to avoid such errors because there is no way to find them at
       compile time - you can see them at runtime only.

      -- ALGLIB --
         Copyright 10.03.2009 by Bochkanov Sergey

    *************************************************************************/
    public static void minlmoptimize(minlmstate state, ndimensional_fvec  fvec, ndimensional_rep rep, object obj)
    {
        if( fvec==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (fvec is null)");
        while( alglib.minlmiteration(state) )
        {
            if( state.needfi )
            {
                fvec(state.x, state.innerobj.fi, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minlmoptimize(minlmstate state, ndimensional_fvec  fvec, ndimensional_jac  jac, ndimensional_rep rep, object obj)
    {
        if( fvec==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (fvec is null)");
        if( jac==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (jac is null)");
        while( alglib.minlmiteration(state) )
        {
            if( state.needfi )
            {
                fvec(state.x, state.innerobj.fi, obj);
                continue;
            }
            if( state.needfij )
            {
                jac(state.x, state.innerobj.fi, state.innerobj.j, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minlmoptimize(minlmstate state, ndimensional_func func, ndimensional_grad grad, ndimensional_hess hess, ndimensional_rep rep, object obj)
    {
        if( func==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (func is null)");
        if( grad==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (grad is null)");
        if( hess==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (hess is null)");
        while( alglib.minlmiteration(state) )
        {
            if( state.needf )
            {
                func(state.x, ref state.innerobj.f, obj);
                continue;
            }
            if( state.needfg )
            {
                grad(state.x, ref state.innerobj.f, state.innerobj.g, obj);
                continue;
            }
            if( state.needfgh )
            {
                hess(state.x, ref state.innerobj.f, state.innerobj.g, state.innerobj.h, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minlmoptimize(minlmstate state, ndimensional_func func, ndimensional_jac  jac, ndimensional_rep rep, object obj)
    {
        if( func==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (func is null)");
        if( jac==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (jac is null)");
        while( alglib.minlmiteration(state) )
        {
            if( state.needf )
            {
                func(state.x, ref state.innerobj.f, obj);
                continue;
            }
            if( state.needfij )
            {
                jac(state.x, state.innerobj.fi, state.innerobj.j, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minlmoptimize(minlmstate state, ndimensional_func func, ndimensional_grad grad, ndimensional_jac  jac, ndimensional_rep rep, object obj)
    {
        if( func==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (func is null)");
        if( grad==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (grad is null)");
        if( jac==null )
            throw new alglibexception("ALGLIB: error in 'minlmoptimize()' (jac is null)");
        while( alglib.minlmiteration(state) )
        {
            if( state.needf )
            {
                func(state.x, ref state.innerobj.f, obj);
                continue;
            }
            if( state.needfg )
            {
                grad(state.x, ref state.innerobj.f, state.innerobj.g, obj);
                continue;
            }
            if( state.needfij )
            {
                jac(state.x, state.innerobj.fi, state.innerobj.j, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minlmoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    Levenberg-Marquardt algorithm results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution
        Rep     -   optimization  report;  includes  termination   codes   and
                    additional information. Termination codes are listed below,
                    see comments for this structure for more info.
                    Termination code is stored in rep.terminationtype field:
                    * -7    derivative correctness check failed;
                            see rep.funcidx, rep.varidx for
                            more information.
                    * -3    constraints are inconsistent
                    *  1    relative function improvement is no more than
                            EpsF.
                    *  2    relative step is no more than EpsX.
                    *  4    gradient is no more than EpsG.
                    *  5    MaxIts steps was taken
                    *  7    stopping conditions are too stringent,
                            further improvement is impossible
                    *  8    terminated by user who called minlmrequesttermination().
                            X contains point which was "current accepted" when
                            termination request was submitted.

      -- ALGLIB --
         Copyright 10.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmresults(minlmstate state, out double[] x, out minlmreport rep)
    {
        x = new double[0];
        rep = new minlmreport();
        minlm.minlmresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    Levenberg-Marquardt algorithm results

    Buffered implementation of MinLMResults(), which uses pre-allocated buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 10.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmresultsbuf(minlmstate state, ref double[] x, minlmreport rep)
    {

        minlm.minlmresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    This  subroutine  restarts  LM  algorithm from new point. All optimization
    parameters are left unchanged.

    This  function  allows  to  solve multiple  optimization  problems  (which
    must have same number of dimensions) without object reallocation penalty.

    INPUT PARAMETERS:
        State   -   structure used for reverse communication previously
                    allocated with MinLMCreateXXX call.
        X       -   new starting point.

      -- ALGLIB --
         Copyright 30.07.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmrestartfrom(minlmstate state, double[] x)
    {

        minlm.minlmrestartfrom(state.innerobj, x);
        return;
    }

    /*************************************************************************
    This subroutine submits request for termination of running  optimizer.  It
    should be called from user-supplied callback when user decides that it  is
    time to "smoothly" terminate optimization process.  As  result,  optimizer
    stops at point which was "current accepted" when termination  request  was
    submitted and returns error code 8 (successful termination).

    INPUT PARAMETERS:
        State   -   optimizer structure

    NOTE: after  request  for  termination  optimizer  may   perform   several
          additional calls to user-supplied callbacks. It does  NOT  guarantee
          to stop immediately - it just guarantees that these additional calls
          will be discarded later.

    NOTE: calling this function on optimizer which is NOT running will have no
          effect.

    NOTE: multiple calls to this function are possible. First call is counted,
          subsequent calls are silently ignored.

      -- ALGLIB --
         Copyright 08.10.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmrequesttermination(minlmstate state)
    {

        minlm.minlmrequesttermination(state.innerobj);
        return;
    }

    /*************************************************************************
    This is obsolete function.

    Since ALGLIB 3.3 it is equivalent to MinLMCreateVJ().

      -- ALGLIB --
         Copyright 30.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmcreatevgj(int n, int m, double[] x, out minlmstate state)
    {
        state = new minlmstate();
        minlm.minlmcreatevgj(n, m, x, state.innerobj);
        return;
    }
    public static void minlmcreatevgj(int m, double[] x, out minlmstate state)
    {
        int n;

        state = new minlmstate();
        n = ap.len(x);
        minlm.minlmcreatevgj(n, m, x, state.innerobj);

        return;
    }

    /*************************************************************************
    This is obsolete function.

    Since ALGLIB 3.3 it is equivalent to MinLMCreateFJ().

      -- ALGLIB --
         Copyright 30.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmcreatefgj(int n, int m, double[] x, out minlmstate state)
    {
        state = new minlmstate();
        minlm.minlmcreatefgj(n, m, x, state.innerobj);
        return;
    }
    public static void minlmcreatefgj(int m, double[] x, out minlmstate state)
    {
        int n;

        state = new minlmstate();
        n = ap.len(x);
        minlm.minlmcreatefgj(n, m, x, state.innerobj);

        return;
    }

    /*************************************************************************
    This function is considered obsolete since ALGLIB 3.1.0 and is present for
    backward  compatibility  only.  We  recommend  to use MinLMCreateVJ, which
    provides similar, but more consistent and feature-rich interface.

      -- ALGLIB --
         Copyright 30.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmcreatefj(int n, int m, double[] x, out minlmstate state)
    {
        state = new minlmstate();
        minlm.minlmcreatefj(n, m, x, state.innerobj);
        return;
    }
    public static void minlmcreatefj(int m, double[] x, out minlmstate state)
    {
        int n;

        state = new minlmstate();
        n = ap.len(x);
        minlm.minlmcreatefj(n, m, x, state.innerobj);

        return;
    }

    /*************************************************************************
    This  subroutine  turns  on  verification  of  the  user-supplied analytic
    gradient:
    * user calls this subroutine before optimization begins
    * MinLMOptimize() is called
    * prior to actual optimization, for  each  function Fi and each  component
      of parameters  being  optimized X[j] algorithm performs following steps:
      * two trial steps are made to X[j]-TestStep*S[j] and X[j]+TestStep*S[j],
        where X[j] is j-th parameter and S[j] is a scale of j-th parameter
      * if needed, steps are bounded with respect to constraints on X[]
      * Fi(X) is evaluated at these trial points
      * we perform one more evaluation in the middle point of the interval
      * we  build  cubic  model using function values and derivatives at trial
        points and we compare its prediction with actual value in  the  middle
        point
      * in case difference between prediction and actual value is higher  than
        some predetermined threshold, algorithm stops with completion code -7;
        Rep.VarIdx is set to index of the parameter with incorrect derivative,
        Rep.FuncIdx is set to index of the function.
    * after verification is over, algorithm proceeds to the actual optimization.

    NOTE 1: verification  needs  N (parameters count) Jacobian evaluations. It
            is  very  costly  and  you  should use it only for low dimensional
            problems,  when  you  want  to  be  sure  that  you've   correctly
            calculated  analytic  derivatives.  You should not  use  it in the
            production code  (unless  you  want  to check derivatives provided
            by some third party).

    NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
            (so large that function behaviour is significantly non-cubic) will
            lead to false alarms. You may use  different  step  for  different
            parameters by means of setting scale with MinLMSetScale().

    NOTE 3: this function may lead to false positives. In case it reports that
            I-th  derivative was calculated incorrectly, you may decrease test
            step  and  try  one  more  time  - maybe your function changes too
            sharply  and  your  step  is  too  large for such rapidly chanding
            function.

    INPUT PARAMETERS:
        State       -   structure used to store algorithm state
        TestStep    -   verification step:
                        * TestStep=0 turns verification off
                        * TestStep>0 activates verification

      -- ALGLIB --
         Copyright 15.06.2012 by Bochkanov Sergey
    *************************************************************************/
    public static void minlmsetgradientcheck(minlmstate state, double teststep)
    {

        minlm.minlmsetgradientcheck(state.innerobj, teststep);
        return;
    }

}
public partial class alglib
{


    /*************************************************************************

    *************************************************************************/
    public class minasastate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needfg { get { return _innerobj.needfg; } set { _innerobj.needfg = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] g { get { return _innerobj.g; } }
        public double[] x { get { return _innerobj.x; } }

        public minasastate()
        {
            _innerobj = new mincomp.minasastate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minasastate((mincomp.minasastate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private mincomp.minasastate _innerobj;
        public mincomp.minasastate innerobj { get { return _innerobj; } }
        public minasastate(mincomp.minasastate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************

    *************************************************************************/
    public class minasareport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int nfev { get { return _innerobj.nfev; } set { _innerobj.nfev = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }
        public int activeconstraints { get { return _innerobj.activeconstraints; } set { _innerobj.activeconstraints = value; } }

        public minasareport()
        {
            _innerobj = new mincomp.minasareport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minasareport((mincomp.minasareport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private mincomp.minasareport _innerobj;
        public mincomp.minasareport innerobj { get { return _innerobj; } }
        public minasareport(mincomp.minasareport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
    Obsolete function, use MinLBFGSSetPrecDefault() instead.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetdefaultpreconditioner(minlbfgsstate state)
    {

        mincomp.minlbfgssetdefaultpreconditioner(state.innerobj);
        return;
    }

    /*************************************************************************
    Obsolete function, use MinLBFGSSetCholeskyPreconditioner() instead.

      -- ALGLIB --
         Copyright 13.10.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minlbfgssetcholeskypreconditioner(minlbfgsstate state, double[,] p, bool isupper)
    {

        mincomp.minlbfgssetcholeskypreconditioner(state.innerobj, p, isupper);
        return;
    }

    /*************************************************************************
    This is obsolete function which was used by previous version of the  BLEIC
    optimizer. It does nothing in the current version of BLEIC.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetbarrierwidth(minbleicstate state, double mu)
    {

        mincomp.minbleicsetbarrierwidth(state.innerobj, mu);
        return;
    }

    /*************************************************************************
    This is obsolete function which was used by previous version of the  BLEIC
    optimizer. It does nothing in the current version of BLEIC.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minbleicsetbarrierdecay(minbleicstate state, double mudecay)
    {

        mincomp.minbleicsetbarrierdecay(state.innerobj, mudecay);
        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 25.03.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minasacreate(int n, double[] x, double[] bndl, double[] bndu, out minasastate state)
    {
        state = new minasastate();
        mincomp.minasacreate(n, x, bndl, bndu, state.innerobj);
        return;
    }
    public static void minasacreate(double[] x, double[] bndl, double[] bndu, out minasastate state)
    {
        int n;
        if( (ap.len(x)!=ap.len(bndl)) || (ap.len(x)!=ap.len(bndu)))
            throw new alglibexception("Error while calling 'minasacreate': looks like one of arguments has wrong size");
        state = new minasastate();
        n = ap.len(x);
        mincomp.minasacreate(n, x, bndl, bndu, state.innerobj);

        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minasasetcond(minasastate state, double epsg, double epsf, double epsx, int maxits)
    {

        mincomp.minasasetcond(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minasasetxrep(minasastate state, bool needxrep)
    {

        mincomp.minasasetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minasasetalgorithm(minasastate state, int algotype)
    {

        mincomp.minasasetalgorithm(state.innerobj, algotype);
        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 02.04.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minasasetstpmax(minasastate state, double stpmax)
    {

        mincomp.minasasetstpmax(state.innerobj, stpmax);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool minasaiteration(minasastate state)
    {

        bool result = mincomp.minasaiteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        grad    -   callback which calculates function (or merit function)
                    value func and gradient grad at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null


      -- ALGLIB --
         Copyright 20.03.2009 by Bochkanov Sergey

    *************************************************************************/
    public static void minasaoptimize(minasastate state, ndimensional_grad grad, ndimensional_rep rep, object obj)
    {
        if( grad==null )
            throw new alglibexception("ALGLIB: error in 'minasaoptimize()' (grad is null)");
        while( alglib.minasaiteration(state) )
        {
            if( state.needfg )
            {
                grad(state.x, ref state.innerobj.f, state.innerobj.g, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minasaoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 20.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minasaresults(minasastate state, out double[] x, out minasareport rep)
    {
        x = new double[0];
        rep = new minasareport();
        mincomp.minasaresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 20.03.2009 by Bochkanov Sergey
    *************************************************************************/
    public static void minasaresultsbuf(minasastate state, ref double[] x, minasareport rep)
    {

        mincomp.minasaresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    Obsolete optimization algorithm.
    Was replaced by MinBLEIC subpackage.

      -- ALGLIB --
         Copyright 30.07.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minasarestartfrom(minasastate state, double[] x, double[] bndl, double[] bndu)
    {

        mincomp.minasarestartfrom(state.innerobj, x, bndl, bndu);
        return;
    }

}
public partial class alglib
{


    /*************************************************************************
    This object stores nonlinear optimizer state.
    You should use functions provided by MinNLC subpackage to work  with  this
    object
    *************************************************************************/
    public class minnlcstate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needfi { get { return _innerobj.needfi; } set { _innerobj.needfi = value; } }
        public bool needfij { get { return _innerobj.needfij; } set { _innerobj.needfij = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] fi { get { return _innerobj.fi; } }
        public double[,] j { get { return _innerobj.j; } }
        public double[] x { get { return _innerobj.x; } }

        public minnlcstate()
        {
            _innerobj = new minnlc.minnlcstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minnlcstate((minnlc.minnlcstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minnlc.minnlcstate _innerobj;
        public minnlc.minnlcstate innerobj { get { return _innerobj; } }
        public minnlcstate(minnlc.minnlcstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    This structure stores optimization report:
    * IterationsCount           total number of inner iterations
    * NFEV                      number of gradient evaluations
    * TerminationType           termination type (see below)

    TERMINATION CODES

    TerminationType field contains completion code, which can be:
      -8    internal integrity control detected  infinite  or  NAN  values  in
            function/gradient. Abnormal termination signalled.
      -7    gradient verification failed.
            See MinNLCSetGradientCheck() for more information.
       1    relative function improvement is no more than EpsF.
       2    relative step is no more than EpsX.
       4    gradient norm is no more than EpsG
       5    MaxIts steps was taken
       7    stopping conditions are too stringent,
            further improvement is impossible,
            X contains best point found so far.

    Other fields of this structure are not documented and should not be used!
    *************************************************************************/
    public class minnlcreport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int nfev { get { return _innerobj.nfev; } set { _innerobj.nfev = value; } }
        public int varidx { get { return _innerobj.varidx; } set { _innerobj.varidx = value; } }
        public int funcidx { get { return _innerobj.funcidx; } set { _innerobj.funcidx = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }
        public int dbgphase0its { get { return _innerobj.dbgphase0its; } set { _innerobj.dbgphase0its = value; } }

        public minnlcreport()
        {
            _innerobj = new minnlc.minnlcreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minnlcreport((minnlc.minnlcreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minnlc.minnlcreport _innerobj;
        public minnlc.minnlcreport innerobj { get { return _innerobj; } }
        public minnlcreport(minnlc.minnlcreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
                      NONLINEARLY  CONSTRAINED  OPTIMIZATION
                WITH PRECONDITIONED AUGMENTED LAGRANGIAN ALGORITHM

    DESCRIPTION:
    The  subroutine  minimizes  function   F(x)  of N arguments subject to any
    combination of:
    * bound constraints
    * linear inequality constraints
    * linear equality constraints
    * nonlinear equality constraints Gi(x)=0
    * nonlinear inequality constraints Hi(x)<=0

    REQUIREMENTS:
    * user must provide function value and gradient for F(), H(), G()
    * starting point X0 must be feasible or not too far away from the feasible
      set
    * F(), G(), H() are twice continuously differentiable on the feasible  set
      and its neighborhood
    * nonlinear constraints G() and H() must have non-zero gradient at  G(x)=0
      and at H(x)=0. Say, constraint like x^2>=1 is supported, but x^2>=0   is
      NOT supported.

    USAGE:

    Constrained optimization if far more complex than the  unconstrained  one.
    Nonlinearly constrained optimization is one of the most esoteric numerical
    procedures.

    Here we give very brief outline  of  the  MinNLC  optimizer.  We  strongly
    recommend you to study examples in the ALGLIB Reference Manual and to read
    ALGLIB User Guide on optimization, which is available at
    http://www.alglib.net/optimization/

    1. User initializes algorithm state with MinNLCCreate() call  and  chooses
       what NLC solver to use. There is some solver which is used by  default,
       with default settings, but you should NOT rely on  default  choice.  It
       may change in future releases of ALGLIB without notice, and no one  can
       guarantee that new solver will be  able  to  solve  your  problem  with
       default settings.

       From the other side, if you choose solver explicitly, you can be pretty
       sure that it will work with new ALGLIB releases.

       In the current release following solvers can be used:
       * AUL solver (activated with MinNLCSetAlgoAUL() function)

    2. User adds boundary and/or linear and/or nonlinear constraints by  means
       of calling one of the following functions:
       a) MinNLCSetBC() for boundary constraints
       b) MinNLCSetLC() for linear constraints
       c) MinNLCSetNLC() for nonlinear constraints
       You may combine (a), (b) and (c) in one optimization problem.

    3. User sets scale of the variables with MinNLCSetScale() function. It  is
       VERY important to set  scale  of  the  variables,  because  nonlinearly
       constrained problems are hard to solve when variables are badly scaled.

    4. User sets  stopping  conditions  with  MinNLCSetCond(). If  NLC  solver
       uses  inner/outer  iteration  layout,  this  function   sets   stopping
       conditions for INNER iterations.

    5. User chooses one of the  preconditioning  methods.  Preconditioning  is
       very  important  for  efficient  handling  of boundary/linear/nonlinear
       constraints. Without preconditioning algorithm would require  thousands
       of iterations even for simple problems.  Two  preconditioners  can   be
       used:
       * approximate LBFGS-based  preconditioner  which  should  be  used  for
         problems with almost orthogonal  constraints  (activated  by  calling
         MinNLCSetPrecInexact)
       * exact low-rank preconditiner (activated by MinNLCSetPrecExactLowRank)
         which should be used for problems with moderate number of constraints
         which do not have to be orthogonal.

    6. Finally, user calls MinNLCOptimize()  function  which  takes  algorithm
       state and pointer (delegate, etc.) to callback function which calculates
       F/G/H.

    7. User calls MinNLCResults() to get solution

    8. Optionally user may call MinNLCRestartFrom() to solve  another  problem
       with same N but another starting point. MinNLCRestartFrom()  allows  to
       reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size ofX
        X       -   starting point, array[N]:
                    * it is better to set X to a feasible point
                    * but X can be infeasible, in which case algorithm will try
                      to find feasible point first, using X as initial
                      approximation.

    OUTPUT PARAMETERS:
        State   -   structure stores algorithm state

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlccreate(int n, double[] x, out minnlcstate state)
    {
        state = new minnlcstate();
        minnlc.minnlccreate(n, x, state.innerobj);
        return;
    }
    public static void minnlccreate(double[] x, out minnlcstate state)
    {
        int n;

        state = new minnlcstate();
        n = ap.len(x);
        minnlc.minnlccreate(n, x, state.innerobj);

        return;
    }

    /*************************************************************************
    This subroutine is a finite  difference variant of MinNLCCreate(). It uses
    finite differences in order to differentiate target function.

    Description below contains information which is specific to this  function
    only. We recommend to read comments on MinNLCCreate() in order to get more
    information about creation of NLC optimizer.

    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size ofX
        X       -   starting point, array[N]:
                    * it is better to set X to a feasible point
                    * but X can be infeasible, in which case algorithm will try
                      to find feasible point first, using X as initial
                      approximation.
        DiffStep-   differentiation step, >0

    OUTPUT PARAMETERS:
        State   -   structure stores algorithm state

    NOTES:
    1. algorithm uses 4-point central formula for differentiation.
    2. differentiation step along I-th axis is equal to DiffStep*S[I] where
       S[] is scaling vector which can be set by MinNLCSetScale() call.
    3. we recommend you to use moderate values of  differentiation  step.  Too
       large step will result in too large TRUNCATION  errors, while too small
       step will result in too large NUMERICAL  errors.  1.0E-4  can  be  good
       value to start from.
    4. Numerical  differentiation  is   very   inefficient  -   one   gradient
       calculation needs 4*N function evaluations. This function will work for
       any N - either small (1...10), moderate (10...100) or  large  (100...).
       However, performance penalty will be too severe for any N's except  for
       small ones.
       We should also say that code which relies on numerical  differentiation
       is  less   robust   and  precise.  Imprecise  gradient  may  slow  down
       convergence, especially on highly nonlinear problems.
       Thus  we  recommend to use this function for fast prototyping on small-
       dimensional problems only, and to implement analytical gradient as soon
       as possible.

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlccreatef(int n, double[] x, double diffstep, out minnlcstate state)
    {
        state = new minnlcstate();
        minnlc.minnlccreatef(n, x, diffstep, state.innerobj);
        return;
    }
    public static void minnlccreatef(double[] x, double diffstep, out minnlcstate state)
    {
        int n;

        state = new minnlcstate();
        n = ap.len(x);
        minnlc.minnlccreatef(n, x, diffstep, state.innerobj);

        return;
    }

    /*************************************************************************
    This function sets boundary constraints for NLC optimizer.

    Boundary constraints are inactive by  default  (after  initial  creation).
    They are preserved after algorithm restart with  MinNLCRestartFrom().

    You may combine boundary constraints with  general  linear ones - and with
    nonlinear ones! Boundary constraints are  handled  more  efficiently  than
    other types.  Thus,  if  your  problem  has  mixed  constraints,  you  may
    explicitly specify some of them as boundary and save some time/space.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        BndL    -   lower bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very small number or -INF.
        BndU    -   upper bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very large number or +INF.

    NOTE 1:  it is possible to specify  BndL[i]=BndU[i].  In  this  case  I-th
    variable will be "frozen" at X[i]=BndL[i]=BndU[i].

    NOTE 2:  when you solve your problem  with  augmented  Lagrangian  solver,
             boundary constraints are  satisfied  only  approximately!  It  is
             possible   that  algorithm  will  evaluate  function  outside  of
             feasible area!

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetbc(minnlcstate state, double[] bndl, double[] bndu)
    {

        minnlc.minnlcsetbc(state.innerobj, bndl, bndu);
        return;
    }

    /*************************************************************************
    This function sets linear constraints for MinNLC optimizer.

    Linear constraints are inactive by default (after initial creation).  They
    are preserved after algorithm restart with MinNLCRestartFrom().

    You may combine linear constraints with boundary ones - and with nonlinear
    ones! If your problem has mixed constraints, you  may  explicitly  specify
    some of them as linear. It  may  help  optimizer   to   handle  them  more
    efficiently.

    INPUT PARAMETERS:
        State   -   structure previously allocated with MinNLCCreate call.
        C       -   linear constraints, array[K,N+1].
                    Each row of C represents one constraint, either equality
                    or inequality (see below):
                    * first N elements correspond to coefficients,
                    * last element corresponds to the right part.
                    All elements of C (including right part) must be finite.
        CT      -   type of constraints, array[K]:
                    * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                    * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                    * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
        K       -   number of equality/inequality constraints, K>=0:
                    * if given, only leading K elements of C/CT are used
                    * if not given, automatically determined from sizes of C/CT

    NOTE 1: when you solve your problem  with  augmented  Lagrangian   solver,
            linear constraints are  satisfied  only   approximately!   It   is
            possible   that  algorithm  will  evaluate  function  outside   of
            feasible area!

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetlc(minnlcstate state, double[,] c, int[] ct, int k)
    {

        minnlc.minnlcsetlc(state.innerobj, c, ct, k);
        return;
    }
    public static void minnlcsetlc(minnlcstate state, double[,] c, int[] ct)
    {
        int k;
        if( (ap.rows(c)!=ap.len(ct)))
            throw new alglibexception("Error while calling 'minnlcsetlc': looks like one of arguments has wrong size");

        k = ap.rows(c);
        minnlc.minnlcsetlc(state.innerobj, c, ct, k);

        return;
    }

    /*************************************************************************
    This function sets nonlinear constraints for MinNLC optimizer.

    In fact, this function sets NUMBER of nonlinear  constraints.  Constraints
    itself (constraint functions) are passed to MinNLCOptimize() method.  This
    method requires user-defined vector function F[]  and  its  Jacobian  J[],
    where:
    * first component of F[] and first row  of  Jacobian  J[]  corresponds  to
      function being minimized
    * next NLEC components of F[] (and rows  of  J)  correspond  to  nonlinear
      equality constraints G_i(x)=0
    * next NLIC components of F[] (and rows  of  J)  correspond  to  nonlinear
      inequality constraints H_i(x)<=0

    NOTE: you may combine nonlinear constraints with linear/boundary ones.  If
          your problem has mixed constraints, you  may explicitly specify some
          of them as linear ones. It may help optimizer to  handle  them  more
          efficiently.

    INPUT PARAMETERS:
        State   -   structure previously allocated with MinNLCCreate call.
        NLEC    -   number of Non-Linear Equality Constraints (NLEC), >=0
        NLIC    -   number of Non-Linear Inquality Constraints (NLIC), >=0

    NOTE 1: when you solve your problem  with  augmented  Lagrangian   solver,
            nonlinear constraints are satisfied only  approximately!   It   is
            possible   that  algorithm  will  evaluate  function  outside   of
            feasible area!

    NOTE 2: algorithm scales variables  according  to   scale   specified   by
            MinNLCSetScale()  function,  so  it can handle problems with badly
            scaled variables (as long as we KNOW their scales).

            However,  there  is  no  way  to  automatically  scale   nonlinear
            constraints Gi(x) and Hi(x). Inappropriate scaling  of  Gi/Hi  may
            ruin convergence. Solving problem with  constraint  "1000*G0(x)=0"
            is NOT same as solving it with constraint "0.001*G0(x)=0".

            It  means  that  YOU  are  the  one who is responsible for correct
            scaling of nonlinear constraints Gi(x) and Hi(x). We recommend you
            to scale nonlinear constraints in such way that I-th component  of
            dG/dX (or dH/dx) has approximately unit  magnitude  (for  problems
            with unit scale)  or  has  magnitude approximately equal to 1/S[i]
            (where S is a scale set by MinNLCSetScale() function).


      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetnlc(minnlcstate state, int nlec, int nlic)
    {

        minnlc.minnlcsetnlc(state.innerobj, nlec, nlic);
        return;
    }

    /*************************************************************************
    This function sets stopping conditions for inner iterations of  optimizer.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsG    -   >=0
                    The  subroutine  finishes  its  work   if   the  condition
                    |v|<EpsG is satisfied, where:
                    * |.| means Euclidian norm
                    * v - scaled gradient vector, v[i]=g[i]*s[i]
                    * g - gradient
                    * s - scaling coefficients set by MinNLCSetScale()
        EpsF    -   >=0
                    The  subroutine  finishes  its work if on k+1-th iteration
                    the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                    is satisfied.
        EpsX    -   >=0
                    The subroutine finishes its work if  on  k+1-th  iteration
                    the condition |v|<=EpsX is fulfilled, where:
                    * |.| means Euclidian norm
                    * v - scaled step vector, v[i]=dx[i]/s[i]
                    * dx - step vector, dx=X(k+1)-X(k)
                    * s - scaling coefficients set by MinNLCSetScale()
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations is unlimited.

    Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
    to automatic stopping criterion selection.

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetcond(minnlcstate state, double epsg, double epsf, double epsx, int maxits)
    {

        minnlc.minnlcsetcond(state.innerobj, epsg, epsf, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients for NLC optimizer.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    Scaling is also used by finite difference variant of the optimizer  - step
    along I-th axis is equal to DiffStep*S[I].

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetscale(minnlcstate state, double[] s)
    {

        minnlc.minnlcsetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    This function sets preconditioner to "inexact LBFGS-based" mode.

    Preconditioning is very important for convergence of  Augmented Lagrangian
    algorithm because presence of penalty term makes problem  ill-conditioned.
    Difference between  performance  of  preconditioned  and  unpreconditioned
    methods can be as large as 100x!

    MinNLC optimizer may  utilize  two  preconditioners,  each  with  its  own
    benefits and drawbacks: a) inexact LBFGS-based, and b) exact low rank one.
    It also provides special unpreconditioned mode of operation which  can  be
    used for test purposes. Comments below discuss LBFGS-based preconditioner.

    Inexact  LBFGS-based  preconditioner  uses L-BFGS  formula  combined  with
    orthogonality assumption to perform very fast updates. For a N-dimensional
    problem with K general linear or nonlinear constraints (boundary ones  are
    not counted) it has O(N*K) cost per iteration.  This   preconditioner  has
    best  quality  (less  iterations)  when   general   linear  and  nonlinear
    constraints are orthogonal to each other (orthogonality  with  respect  to
    boundary constraints is not required). Number of iterations increases when
    constraints  are  non-orthogonal, because algorithm assumes orthogonality,
    but still it is better than no preconditioner at all.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state

      -- ALGLIB --
         Copyright 26.09.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetprecinexact(minnlcstate state)
    {

        minnlc.minnlcsetprecinexact(state.innerobj);
        return;
    }

    /*************************************************************************
    This function sets preconditioner to "exact low rank" mode.

    Preconditioning is very important for convergence of  Augmented Lagrangian
    algorithm because presence of penalty term makes problem  ill-conditioned.
    Difference between  performance  of  preconditioned  and  unpreconditioned
    methods can be as large as 100x!

    MinNLC optimizer may  utilize  two  preconditioners,  each  with  its  own
    benefits and drawbacks: a) inexact LBFGS-based, and b) exact low rank one.
    It also provides special unpreconditioned mode of operation which  can  be
    used for test purposes. Comments below discuss low rank preconditioner.

    Exact low-rank preconditioner  uses  Woodbury  matrix  identity  to  build
    quadratic model of the penalized function. It has no  special  assumptions
    about orthogonality, so it is quite general. However, for a  N-dimensional
    problem with K general linear or nonlinear constraints (boundary ones  are
    not counted) it has O(N*K^2) cost per iteration (for  comparison:  inexact
    LBFGS-based preconditioner has O(N*K) cost).

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        UpdateFreq- update frequency. Preconditioner is  rebuilt  after  every
                    UpdateFreq iterations. Recommended value: 10 or higher.
                    Zero value means that good default value will be used.

      -- ALGLIB --
         Copyright 26.09.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetprecexactlowrank(minnlcstate state, int updatefreq)
    {

        minnlc.minnlcsetprecexactlowrank(state.innerobj, updatefreq);
        return;
    }

    /*************************************************************************
    This function sets preconditioner to "turned off" mode.

    Preconditioning is very important for convergence of  Augmented Lagrangian
    algorithm because presence of penalty term makes problem  ill-conditioned.
    Difference between  performance  of  preconditioned  and  unpreconditioned
    methods can be as large as 100x!

    MinNLC optimizer may  utilize  two  preconditioners,  each  with  its  own
    benefits and drawbacks: a) inexact LBFGS-based, and b) exact low rank one.
    It also provides special unpreconditioned mode of operation which  can  be
    used for test purposes.

    This function activates this test mode. Do not use it in  production  code
    to solve real-life problems.

    INPUT PARAMETERS:
        State   -   structure stores algorithm state

      -- ALGLIB --
         Copyright 26.09.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetprecnone(minnlcstate state)
    {

        minnlc.minnlcsetprecnone(state.innerobj);
        return;
    }

    /*************************************************************************
    This  function  tells MinNLC unit to use  Augmented  Lagrangian  algorithm
    for nonlinearly constrained  optimization.  This  algorithm  is  a  slight
    modification of one described in "A Modified Barrier-Augmented  Lagrangian
    Method for  Constrained  Minimization  (1999)"  by  D.GOLDFARB,  R.POLYAK,
    K. SCHEINBERG, I.YUZEFOVICH.

    Augmented Lagrangian algorithm works by converting problem  of  minimizing
    F(x) subject to equality/inequality constraints   to unconstrained problem
    of the form

        min[ f(x) +
            + Rho*PENALTY_EQ(x)   + SHIFT_EQ(x,Nu1) +
            + Rho*PENALTY_INEQ(x) + SHIFT_INEQ(x,Nu2) ]

    where:
    * Rho is a fixed penalization coefficient
    * PENALTY_EQ(x) is a penalty term, which is used to APPROXIMATELY  enforce
      equality constraints
    * SHIFT_EQ(x) is a special "shift"  term  which  is  used  to  "fine-tune"
      equality constraints, greatly increasing precision
    * PENALTY_INEQ(x) is a penalty term which is used to approximately enforce
      inequality constraints
    * SHIFT_INEQ(x) is a special "shift"  term  which  is  used to "fine-tune"
      inequality constraints, greatly increasing precision
    * Nu1/Nu2 are vectors of Lagrange coefficients which are fine-tuned during
      outer iterations of algorithm

    This  version  of  AUL  algorithm  uses   preconditioner,  which   greatly
    accelerates convergence. Because this  algorithm  is  similar  to  penalty
    methods,  it  may  perform  steps  into  infeasible  area.  All  kinds  of
    constraints (boundary, linear and nonlinear ones) may   be   violated   in
    intermediate points - and in the solution.  However,  properly  configured
    AUL method is significantly better at handling  constraints  than  barrier
    and/or penalty methods.

    The very basic outline of algorithm is given below:
    1) first outer iteration is performed with "default"  values  of  Lagrange
       multipliers Nu1/Nu2. Solution quality is low (candidate  point  can  be
       too  far  away  from  true  solution; large violation of constraints is
       possible) and is comparable with that of penalty methods.
    2) subsequent outer iterations  refine  Lagrange  multipliers  and improve
       quality of the solution.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        Rho     -   penalty coefficient, Rho>0:
                    * large enough  that  algorithm  converges  with   desired
                      precision. Minimum value is 10*max(S'*diag(H)*S),  where
                      S is a scale matrix (set by MinNLCSetScale) and H  is  a
                      Hessian of the function being minimized. If you can  not
                      easily estimate Hessian norm,  see  our  recommendations
                      below.
                    * not TOO large to prevent ill-conditioning
                    * for unit-scale problems (variables and Hessian have unit
                      magnitude), Rho=100 or Rho=1000 can be used.
                    * it is important to note that Rho is internally multiplied
                      by scaling matrix, i.e. optimum value of Rho depends  on
                      scale of variables specified  by  MinNLCSetScale().
        ItsCnt  -   number of outer iterations:
                    * ItsCnt=0 means that small number of outer iterations  is
                      automatically chosen (10 iterations in current version).
                    * ItsCnt=1 means that AUL algorithm performs just as usual
                      barrier method.
                    * ItsCnt>1 means that  AUL  algorithm  performs  specified
                      number of outer iterations

    HOW TO CHOOSE PARAMETERS

    Nonlinear optimization is a tricky area and Augmented Lagrangian algorithm
    is sometimes hard to tune. Good values of  Rho  and  ItsCnt  are  problem-
    specific.  In  order  to  help  you   we   prepared   following   set   of
    recommendations:

    * for  unit-scale  problems  (variables  and Hessian have unit magnitude),
      Rho=100 or Rho=1000 can be used.

    * start from  some  small  value of Rho and solve problem  with  just  one
      outer iteration (ItcCnt=1). In this case algorithm behaves like  penalty
      method. Increase Rho in 2x or 10x steps until you  see  that  one  outer
      iteration returns point which is "rough approximation to solution".

      It is very important to have Rho so  large  that  penalty  term  becomes
      constraining i.e. modified function becomes highly convex in constrained
      directions.

      From the other side, too large Rho may prevent you  from  converging  to
      the solution. You can diagnose it by studying number of inner iterations
      performed by algorithm: too few (5-10 on  1000-dimensional  problem)  or
      too many (orders of magnitude more than  dimensionality)  usually  means
      that Rho is too large.

    * with just one outer iteration you  usually  have  low-quality  solution.
      Some constraints can be violated with very  large  margin,  while  other
      ones (which are NOT violated in the true solution) can push final  point
      too far in the inner area of the feasible set.

      For example, if you have constraint x0>=0 and true solution  x0=1,  then
      merely a presence of "x0>=0" will introduce a bias towards larger values
      of x0. Say, algorithm may stop at x0=1.5 instead of 1.0.

    * after you found good Rho, you may increase number of  outer  iterations.
      ItsCnt=10 is a good value. Subsequent outer iteration will refine values
      of  Lagrange  multipliers.  Constraints  which  were  violated  will  be
      enforced, inactive constraints will be dropped (corresponding multipliers
      will be decreased). Ideally, you  should  see  10-1000x  improvement  in
      constraint handling (constraint violation is reduced).

    * if  you  see  that  algorithm  converges  to  vicinity  of solution, but
      additional outer iterations do not refine solution,  it  may  mean  that
      algorithm is unstable - it wanders around true  solution,  but  can  not
      approach it. Sometimes algorithm may be stabilized by increasing Rho one
      more time, making it 5x or 10x larger.

    SCALING OF CONSTRAINTS [IMPORTANT]

    AUL optimizer scales   variables   according   to   scale   specified   by
    MinNLCSetScale() function, so it can handle  problems  with  badly  scaled
    variables (as long as we KNOW their scales).   However,  because  function
    being optimized is a mix  of  original  function and  constraint-dependent
    penalty  functions, it  is   important  to   rescale  both  variables  AND
    constraints.

    Say,  if  you  minimize f(x)=x^2 subject to 1000000*x>=0,  then  you  have
    constraint whose scale is different from that of target  function (another
    example is 0.000001*x>=0). It is also possible to have constraints   whose
    scales  are   misaligned:   1000000*x0>=0, 0.000001*x1<=0.   Inappropriate
    scaling may ruin convergence because minimizing x^2 subject to x>=0 is NOT
    same as minimizing it subject to 1000000*x>=0.

    Because we  know  coefficients  of  boundary/linear  constraints,  we  can
    automatically rescale and normalize them. However,  there  is  no  way  to
    automatically rescale nonlinear constraints Gi(x) and  Hi(x)  -  they  are
    black boxes.

    It means that YOU are the one who is  responsible  for  correct scaling of
    nonlinear constraints  Gi(x)  and  Hi(x).  We  recommend  you  to  rescale
    nonlinear constraints in such way that I-th component of dG/dX (or  dH/dx)
    has magnitude approximately equal to 1/S[i] (where S  is  a  scale  set by
    MinNLCSetScale() function).

    WHAT IF IT DOES NOT CONVERGE?

    It is possible that AUL algorithm fails to converge to precise  values  of
    Lagrange multipliers. It stops somewhere around true solution, but candidate
    point is still too far from solution, and some constraints  are  violated.
    Such kind of failure is specific for Lagrangian algorithms -  technically,
    they stop at some point, but this point is not constrained solution.

    There are exist several reasons why algorithm may fail to converge:
    a) too loose stopping criteria for inner iteration
    b) degenerate, redundant constraints
    c) target function has unconstrained extremum exactly at the  boundary  of
       some constraint
    d) numerical noise in the target function

    In all these cases algorithm is unstable - each outer iteration results in
    large and almost random step which improves handling of some  constraints,
    but violates other ones (ideally  outer iterations should form a  sequence
    of progressively decreasing steps towards solution).

    First reason possible is  that  too  loose  stopping  criteria  for  inner
    iteration were specified. Augmented Lagrangian algorithm solves a sequence
    of intermediate problems, and requries each of them to be solved with high
    precision. Insufficient precision results in incorrect update of  Lagrange
    multipliers.

    Another reason is that you may have specified degenerate constraints: say,
    some constraint was repeated twice. In most cases AUL algorithm gracefully
    handles such situations, but sometimes it may spend too much time figuring
    out subtle degeneracies in constraint matrix.

    Third reason is tricky and hard to diagnose. Consider situation  when  you
    minimize  f=x^2  subject to constraint x>=0.  Unconstrained   extremum  is
    located  exactly  at  the  boundary  of  constrained  area.  In  this case
    algorithm will tend to oscillate between negative  and  positive  x.  Each
    time it stops at x<0 it "reinforces" constraint x>=0, and each time it  is
    bounced to x>0 it "relaxes" constraint (and is  attracted  to  x<0).

    Such situation  sometimes  happens  in  problems  with  hidden  symetries.
    Algorithm  is  got  caught  in  a  loop with  Lagrange  multipliers  being
    continuously increased/decreased. Luckily, such loop forms after at  least
    three iterations, so this problem can be solved by  DECREASING  number  of
    outer iterations down to 1-2 and increasing  penalty  coefficient  Rho  as
    much as possible.

    Final reason is numerical noise. AUL algorithm is robust against  moderate
    noise (more robust than, say, active set methods),  but  large  noise  may
    destabilize algorithm.

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetalgoaul(minnlcstate state, double rho, int itscnt)
    {

        minnlc.minnlcsetalgoaul(state.innerobj, rho, itscnt);
        return;
    }

    /*************************************************************************
    This function turns on/off reporting.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        NeedXRep-   whether iteration reports are needed or not

    If NeedXRep is True, algorithm will call rep() callback function if  it is
    provided to MinNLCOptimize().

    NOTE: algorithm passes two parameters to rep() callback  -  current  point
          and penalized function value at current point. Important -  function
          value which is returned is NOT function being minimized. It  is  sum
          of the value of the function being minimized - and penalty term.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetxrep(minnlcstate state, bool needxrep)
    {

        minnlc.minnlcsetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool minnlciteration(minnlcstate state)
    {

        bool result = minnlc.minnlciteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        fvec    -   callback which calculates function vector fi[]
                    at given point x
        jac     -   callback which calculates function vector fi[]
                    and Jacobian jac at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null


    NOTES:

    1. This function has two different implementations: one which  uses  exact
       (analytical) user-supplied Jacobian, and one which uses  only  function
       vector and numerically  differentiates  function  in  order  to  obtain
       gradient.

       Depending  on  the  specific  function  used to create optimizer object
       you should choose appropriate variant of MinNLCOptimize() -  one  which
       accepts function AND Jacobian or one which accepts ONLY function.

       Be careful to choose variant of MinNLCOptimize()  which  corresponds to
       your optimization scheme! Table below lists different  combinations  of
       callback (function/gradient) passed to MinNLCOptimize()   and  specific
       function used to create optimizer.


                         |         USER PASSED TO MinNLCOptimize()
       CREATED WITH      |  function only   |  function and gradient
       ------------------------------------------------------------
       MinNLCCreateF()   |     works               FAILS
       MinNLCCreate()    |     FAILS               works

       Here "FAILS" denotes inappropriate combinations  of  optimizer creation
       function  and  MinNLCOptimize()  version.   Attemps   to    use    such
       combination will lead to exception. Either  you  did  not pass gradient
       when it WAS needed or you passed gradient when it was NOT needed.

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey

    *************************************************************************/
    public static void minnlcoptimize(minnlcstate state, ndimensional_fvec  fvec, ndimensional_rep rep, object obj)
    {
        if( fvec==null )
            throw new alglibexception("ALGLIB: error in 'minnlcoptimize()' (fvec is null)");
        while( alglib.minnlciteration(state) )
        {
            if( state.needfi )
            {
                fvec(state.x, state.innerobj.fi, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minnlcoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minnlcoptimize(minnlcstate state, ndimensional_jac  jac, ndimensional_rep rep, object obj)
    {
        if( jac==null )
            throw new alglibexception("ALGLIB: error in 'minnlcoptimize()' (jac is null)");
        while( alglib.minnlciteration(state) )
        {
            if( state.needfij )
            {
                jac(state.x, state.innerobj.fi, state.innerobj.j, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minnlcoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    MinNLC results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution
        Rep     -   optimization report. You should check Rep.TerminationType
                    in  order  to  distinguish  successful  termination  from
                    unsuccessful one:
                    * -8    internal integrity control  detected  infinite or
                            NAN   values   in   function/gradient.   Abnormal
                            termination signalled.
                    * -7   gradient verification failed.
                           See MinNLCSetGradientCheck() for more information.
                    *  1   relative function improvement is no more than EpsF.
                    *  2   scaled step is no more than EpsX.
                    *  4   scaled gradient norm is no more than EpsG.
                    *  5   MaxIts steps was taken
                    More information about fields of this  structure  can  be
                    found in the comments on MinNLCReport datatype.

      -- ALGLIB --
         Copyright 06.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcresults(minnlcstate state, out double[] x, out minnlcreport rep)
    {
        x = new double[0];
        rep = new minnlcreport();
        minnlc.minnlcresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    NLC results

    Buffered implementation of MinNLCResults() which uses pre-allocated buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcresultsbuf(minnlcstate state, ref double[] x, minnlcreport rep)
    {

        minnlc.minnlcresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    This subroutine restarts algorithm from new point.
    All optimization parameters (including constraints) are left unchanged.

    This  function  allows  to  solve multiple  optimization  problems  (which
    must have  same number of dimensions) without object reallocation penalty.

    INPUT PARAMETERS:
        State   -   structure previously allocated with MinNLCCreate call.
        X       -   new starting point.

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcrestartfrom(minnlcstate state, double[] x)
    {

        minnlc.minnlcrestartfrom(state.innerobj, x);
        return;
    }

    /*************************************************************************
    This  subroutine  turns  on  verification  of  the  user-supplied analytic
    gradient:
    * user calls this subroutine before optimization begins
    * MinNLCOptimize() is called
    * prior to  actual  optimization, for each component  of  parameters being
      optimized X[i] algorithm performs following steps:
      * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
        where X[i] is i-th component of the initial point and S[i] is a  scale
        of i-th parameter
      * F(X) is evaluated at these trial points
      * we perform one more evaluation in the middle point of the interval
      * we  build  cubic  model using function values and derivatives at trial
        points and we compare its prediction with actual value in  the  middle
        point
      * in case difference between prediction and actual value is higher  than
        some predetermined threshold, algorithm stops with completion code -7;
        Rep.VarIdx is set to index of the parameter with incorrect derivative,
        and Rep.FuncIdx is set to index of the function.
    * after verification is over, algorithm proceeds to the actual optimization.

    NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
            is very costly and you should use  it  only  for  low  dimensional
            problems,  when  you  want  to  be  sure  that  you've   correctly
            calculated  analytic  derivatives.  You  should  not use it in the
            production code (unless you want to check derivatives provided  by
            some third party).

    NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
            (so large that function behaviour is significantly non-cubic) will
            lead to false alarms. You may use  different  step  for  different
            parameters by means of setting scale with MinNLCSetScale().

    NOTE 3: this function may lead to false positives. In case it reports that
            I-th  derivative was calculated incorrectly, you may decrease test
            step  and  try  one  more  time  - maybe your function changes too
            sharply  and  your  step  is  too  large for such rapidly chanding
            function.

    INPUT PARAMETERS:
        State       -   structure used to store algorithm state
        TestStep    -   verification step:
                        * TestStep=0 turns verification off
                        * TestStep>0 activates verification

      -- ALGLIB --
         Copyright 15.06.2014 by Bochkanov Sergey
    *************************************************************************/
    public static void minnlcsetgradientcheck(minnlcstate state, double teststep)
    {

        minnlc.minnlcsetgradientcheck(state.innerobj, teststep);
        return;
    }

}
public partial class alglib
{


    /*************************************************************************
    This object stores nonlinear optimizer state.
    You should use functions provided by MinNS subpackage to work  with  this
    object
    *************************************************************************/
    public class minnsstate : alglibobject
    {
        //
        // Public declarations
        //
        public bool needfi { get { return _innerobj.needfi; } set { _innerobj.needfi = value; } }
        public bool needfij { get { return _innerobj.needfij; } set { _innerobj.needfij = value; } }
        public bool xupdated { get { return _innerobj.xupdated; } set { _innerobj.xupdated = value; } }
        public double f { get { return _innerobj.f; } set { _innerobj.f = value; } }
        public double[] fi { get { return _innerobj.fi; } }
        public double[,] j { get { return _innerobj.j; } }
        public double[] x { get { return _innerobj.x; } }

        public minnsstate()
        {
            _innerobj = new minns.minnsstate();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minnsstate((minns.minnsstate)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minns.minnsstate _innerobj;
        public minns.minnsstate innerobj { get { return _innerobj; } }
        public minnsstate(minns.minnsstate obj)
        {
            _innerobj = obj;
        }
    }


    /*************************************************************************
    This structure stores optimization report:
    * IterationsCount           total number of inner iterations
    * NFEV                      number of gradient evaluations
    * TerminationType           termination type (see below)
    * CErr                      maximum violation of all types of constraints
    * LCErr                     maximum violation of linear constraints
    * NLCErr                    maximum violation of nonlinear constraints

    TERMINATION CODES

    TerminationType field contains completion code, which can be:
      -8    internal integrity control detected  infinite  or  NAN  values  in
            function/gradient. Abnormal termination signalled.
      -3    box constraints are inconsistent
      -1    inconsistent parameters were passed:
            * penalty parameter for minnssetalgoags() is zero,
              but we have nonlinear constraints set by minnssetnlc()
       2    sampling radius decreased below epsx
       5    MaxIts steps was taken
       7    stopping conditions are too stringent,
            further improvement is impossible,
            X contains best point found so far.
       8    User requested termination via MinNSRequestTermination()

    Other fields of this structure are not documented and should not be used!
    *************************************************************************/
    public class minnsreport : alglibobject
    {
        //
        // Public declarations
        //
        public int iterationscount { get { return _innerobj.iterationscount; } set { _innerobj.iterationscount = value; } }
        public int nfev { get { return _innerobj.nfev; } set { _innerobj.nfev = value; } }
        public double cerr { get { return _innerobj.cerr; } set { _innerobj.cerr = value; } }
        public double lcerr { get { return _innerobj.lcerr; } set { _innerobj.lcerr = value; } }
        public double nlcerr { get { return _innerobj.nlcerr; } set { _innerobj.nlcerr = value; } }
        public int terminationtype { get { return _innerobj.terminationtype; } set { _innerobj.terminationtype = value; } }
        public int varidx { get { return _innerobj.varidx; } set { _innerobj.varidx = value; } }
        public int funcidx { get { return _innerobj.funcidx; } set { _innerobj.funcidx = value; } }

        public minnsreport()
        {
            _innerobj = new minns.minnsreport();
        }
        
        public override alglib.alglibobject make_copy()
        {
            return new minnsreport((minns.minnsreport)_innerobj.make_copy());
        }

        //
        // Although some of declarations below are public, you should not use them
        // They are intended for internal use only
        //
        private minns.minnsreport _innerobj;
        public minns.minnsreport innerobj { get { return _innerobj; } }
        public minnsreport(minns.minnsreport obj)
        {
            _innerobj = obj;
        }
    }

    /*************************************************************************
                      NONSMOOTH NONCONVEX OPTIMIZATION
                SUBJECT TO BOX/LINEAR/NONLINEAR-NONSMOOTH CONSTRAINTS

    DESCRIPTION:

    The  subroutine  minimizes  function   F(x)  of N arguments subject to any
    combination of:
    * bound constraints
    * linear inequality constraints
    * linear equality constraints
    * nonlinear equality constraints Gi(x)=0
    * nonlinear inequality constraints Hi(x)<=0

    IMPORTANT: see MinNSSetAlgoAGS for important  information  on  performance
               restrictions of AGS solver.

    REQUIREMENTS:
    * starting point X0 must be feasible or not too far away from the feasible
      set
    * F(), G(), H() are continuous, locally Lipschitz  and  continuously  (but
      not necessarily twice) differentiable in an open dense  subset  of  R^N.
      Functions F(), G() and H() may be nonsmooth and non-convex.
      Informally speaking, it means  that  functions  are  composed  of  large
      differentiable "patches" with nonsmoothness having  place  only  at  the
      boundaries between these "patches".
      Most real-life nonsmooth  functions  satisfy  these  requirements.  Say,
      anything which involves finite number of abs(), min() and max() is  very
      likely to pass the test.
      Say, it is possible to optimize anything of the following:
      * f=abs(x0)+2*abs(x1)
      * f=max(x0,x1)
      * f=sin(max(x0,x1)+abs(x2))
    * for nonlinearly constrained problems: F()  must  be  bounded from  below
      without nonlinear constraints (this requirement is due to the fact that,
      contrary to box and linear constraints, nonlinear ones  require  special
      handling).
    * user must provide function value and gradient for F(), H(), G()  at  all
      points where function/gradient can be calculated. If optimizer  requires
      value exactly at the boundary between "patches" (say, at x=0 for f=abs(x)),
      where gradient is not defined, user may resolve tie arbitrarily (in  our
      case - return +1 or -1 at its discretion).
    * NS solver supports numerical differentiation, i.e. it may  differentiate
      your function for you,  but  it  results  in  2N  increase  of  function
      evaluations. Not recommended unless you solve really small problems. See
      minnscreatef() for more information on this functionality.

    USAGE:

    1. User initializes algorithm state with MinNSCreate() call  and   chooses
       what NLC solver to use. There is some solver which is used by  default,
       with default settings, but you should NOT rely on  default  choice.  It
       may change in future releases of ALGLIB without notice, and no one  can
       guarantee that new solver will be  able  to  solve  your  problem  with
       default settings.

       From the other side, if you choose solver explicitly, you can be pretty
       sure that it will work with new ALGLIB releases.

       In the current release following solvers can be used:
       * AGS solver (activated with MinNSSetAlgoAGS() function)

    2. User adds boundary and/or linear and/or nonlinear constraints by  means
       of calling one of the following functions:
       a) MinNSSetBC() for boundary constraints
       b) MinNSSetLC() for linear constraints
       c) MinNSSetNLC() for nonlinear constraints
       You may combine (a), (b) and (c) in one optimization problem.

    3. User sets scale of the variables with MinNSSetScale() function. It   is
       VERY important to set  scale  of  the  variables,  because  nonlinearly
       constrained problems are hard to solve when variables are badly scaled.

    4. User sets stopping conditions with MinNSSetCond().

    5. Finally, user calls MinNSOptimize()  function  which  takes   algorithm
       state and pointer (delegate, etc) to callback function which calculates
       F/G/H.

    7. User calls MinNSResults() to get solution

    8. Optionally user may call MinNSRestartFrom() to solve   another  problem
       with same N but another starting point. MinNSRestartFrom()  allows   to
       reuse already initialized structure.


    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        X       -   starting point, array[N]:
                    * it is better to set X to a feasible point
                    * but X can be infeasible, in which case algorithm will try
                      to find feasible point first, using X as initial
                      approximation.

    OUTPUT PARAMETERS:
        State   -   structure stores algorithm state

    NOTE: minnscreatef() function may be used if  you  do  not  have  analytic
          gradient.   This   function  creates  solver  which  uses  numerical
          differentiation with user-specified step.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnscreate(int n, double[] x, out minnsstate state)
    {
        state = new minnsstate();
        minns.minnscreate(n, x, state.innerobj);
        return;
    }
    public static void minnscreate(double[] x, out minnsstate state)
    {
        int n;

        state = new minnsstate();
        n = ap.len(x);
        minns.minnscreate(n, x, state.innerobj);

        return;
    }

    /*************************************************************************
    Version of minnscreatef() which uses numerical differentiation. I.e.,  you
    do not have to calculate derivatives yourself. However, this version needs
    2N times more function evaluations.

    2-point differentiation formula is  used,  because  more  precise  4-point
    formula is unstable when used on non-smooth functions.

    INPUT PARAMETERS:
        N       -   problem dimension, N>0:
                    * if given, only leading N elements of X are used
                    * if not given, automatically determined from size of X
        X       -   starting point, array[N]:
                    * it is better to set X to a feasible point
                    * but X can be infeasible, in which case algorithm will try
                      to find feasible point first, using X as initial
                      approximation.
        DiffStep-   differentiation  step,  DiffStep>0.   Algorithm   performs
                    numerical differentiation  with  step  for  I-th  variable
                    being equal to DiffStep*S[I] (here S[] is a  scale vector,
                    set by minnssetscale() function).
                    Do not use  too  small  steps,  because  it  may  lead  to
                    catastrophic cancellation during intermediate calculations.

    OUTPUT PARAMETERS:
        State   -   structure stores algorithm state

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnscreatef(int n, double[] x, double diffstep, out minnsstate state)
    {
        state = new minnsstate();
        minns.minnscreatef(n, x, diffstep, state.innerobj);
        return;
    }
    public static void minnscreatef(double[] x, double diffstep, out minnsstate state)
    {
        int n;

        state = new minnsstate();
        n = ap.len(x);
        minns.minnscreatef(n, x, diffstep, state.innerobj);

        return;
    }

    /*************************************************************************
    This function sets boundary constraints.

    Boundary constraints are inactive by default (after initial creation).
    They are preserved after algorithm restart with minnsrestartfrom().

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        BndL    -   lower bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very small number or -INF.
        BndU    -   upper bounds, array[N].
                    If some (all) variables are unbounded, you may specify
                    very large number or +INF.

    NOTE 1: it is possible to specify BndL[i]=BndU[i]. In this case I-th
    variable will be "frozen" at X[i]=BndL[i]=BndU[i].

    NOTE 2: AGS solver has following useful properties:
    * bound constraints are always satisfied exactly
    * function is evaluated only INSIDE area specified by  bound  constraints,
      even  when  numerical  differentiation is used (algorithm adjusts  nodes
      according to boundary constraints)

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetbc(minnsstate state, double[] bndl, double[] bndu)
    {

        minns.minnssetbc(state.innerobj, bndl, bndu);
        return;
    }

    /*************************************************************************
    This function sets linear constraints.

    Linear constraints are inactive by default (after initial creation).
    They are preserved after algorithm restart with minnsrestartfrom().

    INPUT PARAMETERS:
        State   -   structure previously allocated with minnscreate() call.
        C       -   linear constraints, array[K,N+1].
                    Each row of C represents one constraint, either equality
                    or inequality (see below):
                    * first N elements correspond to coefficients,
                    * last element corresponds to the right part.
                    All elements of C (including right part) must be finite.
        CT      -   type of constraints, array[K]:
                    * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                    * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                    * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
        K       -   number of equality/inequality constraints, K>=0:
                    * if given, only leading K elements of C/CT are used
                    * if not given, automatically determined from sizes of C/CT

    NOTE: linear (non-bound) constraints are satisfied only approximately:

    * there always exists some minor violation (about current sampling  radius
      in magnitude during optimization, about EpsX in the solution) due to use
      of penalty method to handle constraints.
    * numerical differentiation, if used, may  lead  to  function  evaluations
      outside  of the feasible  area,   because   algorithm  does  NOT  change
      numerical differentiation formula according to linear constraints.

    If you want constraints to be  satisfied  exactly, try to reformulate your
    problem  in  such  manner  that  all constraints will become boundary ones
    (this kind of constraints is always satisfied exactly, both in  the  final
    solution and in all intermediate points).

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetlc(minnsstate state, double[,] c, int[] ct, int k)
    {

        minns.minnssetlc(state.innerobj, c, ct, k);
        return;
    }
    public static void minnssetlc(minnsstate state, double[,] c, int[] ct)
    {
        int k;
        if( (ap.rows(c)!=ap.len(ct)))
            throw new alglibexception("Error while calling 'minnssetlc': looks like one of arguments has wrong size");

        k = ap.rows(c);
        minns.minnssetlc(state.innerobj, c, ct, k);

        return;
    }

    /*************************************************************************
    This function sets nonlinear constraints.

    In fact, this function sets NUMBER of nonlinear  constraints.  Constraints
    itself (constraint functions) are passed to minnsoptimize() method.   This
    method requires user-defined vector function F[]  and  its  Jacobian  J[],
    where:
    * first component of F[] and first row  of  Jacobian  J[]  correspond   to
      function being minimized
    * next NLEC components of F[] (and rows  of  J)  correspond  to  nonlinear
      equality constraints G_i(x)=0
    * next NLIC components of F[] (and rows  of  J)  correspond  to  nonlinear
      inequality constraints H_i(x)<=0

    NOTE: you may combine nonlinear constraints with linear/boundary ones.  If
          your problem has mixed constraints, you  may explicitly specify some
          of them as linear ones. It may help optimizer to  handle  them  more
          efficiently.

    INPUT PARAMETERS:
        State   -   structure previously allocated with minnscreate() call.
        NLEC    -   number of Non-Linear Equality Constraints (NLEC), >=0
        NLIC    -   number of Non-Linear Inquality Constraints (NLIC), >=0

    NOTE 1: nonlinear constraints are satisfied only  approximately!   It   is
            possible   that  algorithm  will  evaluate  function  outside   of
            the feasible area!

    NOTE 2: algorithm scales variables  according  to   scale   specified   by
            minnssetscale()  function,  so  it can handle problems with  badly
            scaled variables (as long as we KNOW their scales).

            However,  there  is  no  way  to  automatically  scale   nonlinear
            constraints Gi(x) and Hi(x). Inappropriate scaling  of  Gi/Hi  may
            ruin convergence. Solving problem with  constraint  "1000*G0(x)=0"
            is NOT same as solving it with constraint "0.001*G0(x)=0".

            It  means  that  YOU  are  the  one who is responsible for correct
            scaling of nonlinear constraints Gi(x) and Hi(x). We recommend you
            to scale nonlinear constraints in such way that I-th component  of
            dG/dX (or dH/dx) has approximately unit  magnitude  (for  problems
            with unit scale)  or  has  magnitude approximately equal to 1/S[i]
            (where S is a scale set by minnssetscale() function).

    NOTE 3: nonlinear constraints are always hard to handle,  no  matter  what
            algorithm you try to use. Even basic box/linear constraints modify
            function  curvature   by  adding   valleys  and  ridges.  However,
            nonlinear constraints add valleys which are very  hard  to  follow
            due to their "curved" nature.

            It means that optimization with single nonlinear constraint may be
            significantly slower than optimization with multiple linear  ones.
            It is normal situation, and we recommend you to  carefully  choose
            Rho parameter of minnssetalgoags(), because too  large  value  may
            slow down convergence.


      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetnlc(minnsstate state, int nlec, int nlic)
    {

        minns.minnssetnlc(state.innerobj, nlec, nlic);
        return;
    }

    /*************************************************************************
    This function sets stopping conditions for iterations of optimizer.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        EpsX    -   >=0
                    The AGS solver finishes its work if  on  k+1-th  iteration
                    sampling radius decreases below EpsX.
        MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                    iterations is unlimited.

    Passing EpsX=0  and  MaxIts=0  (simultaneously)  will  lead  to  automatic
    stopping criterion selection. We do not recommend you to rely  on  default
    choice in production code.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetcond(minnsstate state, double epsx, int maxits)
    {

        minns.minnssetcond(state.innerobj, epsx, maxits);
        return;
    }

    /*************************************************************************
    This function sets scaling coefficients for NLC optimizer.

    ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
    size and gradient are scaled before comparison with tolerances).  Scale of
    the I-th variable is a translation invariant measure of:
    a) "how large" the variable is
    b) how large the step should be to make significant changes in the function

    Scaling is also used by finite difference variant of the optimizer  - step
    along I-th axis is equal to DiffStep*S[I].

    INPUT PARAMETERS:
        State   -   structure stores algorithm state
        S       -   array[N], non-zero scaling coefficients
                    S[i] may be negative, sign doesn't matter.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetscale(minnsstate state, double[] s)
    {

        minns.minnssetscale(state.innerobj, s);
        return;
    }

    /*************************************************************************
    This function tells MinNS unit to use  AGS  (adaptive  gradient  sampling)
    algorithm for nonsmooth constrained  optimization.  This  algorithm  is  a
    slight modification of one described in  "An  Adaptive  Gradient  Sampling
    Algorithm for Nonsmooth Optimization" by Frank E. Curtisy and Xiaocun Quez.

    This optimizer has following benefits and drawbacks:
    + robustness; it can be used with nonsmooth and nonconvex functions.
    + relatively easy tuning; most of the metaparameters are easy to select.
    - it has convergence of steepest descent, slower than CG/LBFGS.
    - each iteration involves evaluation of ~2N gradient values  and  solution
      of 2Nx2N quadratic programming problem, which  limits  applicability  of
      algorithm by small-scale problems (up to 50-100).

    IMPORTANT: this  algorithm  has  convergence  guarantees,   i.e.  it  will
               steadily move towards some stationary point of the function.

               However, "stationary point" does not  always  mean  "solution".
               Nonsmooth problems often have "flat spots",  i.e.  areas  where
               function do not change at all. Such "flat spots" are stationary
               points by definition, and algorithm may be caught here.

               Nonsmooth CONVEX tasks are not prone to  this  problem. Say, if
               your function has form f()=MAX(f0,f1,...), and f_i are  convex,
               then f() is convex too and you have guaranteed  convergence  to
               solution.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        Radius  -   initial sampling radius, >=0.

                    Internally multiplied  by  vector of  per-variable  scales
                    specified by minnssetscale()).

                    You should select relatively large sampling radius, roughly
                    proportional to scaled length of the first  steps  of  the
                    algorithm. Something close to 0.1 in magnitude  should  be
                    good for most problems.

                    AGS solver can automatically decrease radius, so too large
                    radius is  not a problem (assuming that you  won't  choose
                    so large radius that algorithm  will  sample  function  in
                    too far away points, where gradient value is irrelevant).

                    Too small radius won't cause algorithm to fail, but it may
                    slow down algorithm (it may  have  to  perform  too  short
                    steps).
        Penalty -   penalty coefficient for nonlinear constraints:
                    * for problem with nonlinear constraints  should  be  some
                      problem-specific  positive   value,  large  enough  that
                      penalty term changes shape of the function.
                      Starting  from  some  problem-specific   value   penalty
                      coefficient becomes  large  enough  to  exactly  enforce
                      nonlinear constraints;  larger  values  do  not  improve
                      precision.
                      Increasing it too much may slow down convergence, so you
                      should choose it carefully.
                    * can be zero for problems WITHOUT  nonlinear  constraints
                      (i.e. for unconstrained ones or ones with  just  box  or
                      linear constraints)
                    * if you specify zero value for problem with at least  one
                      nonlinear  constraint,  algorithm  will  terminate  with
                      error code -1.

    ALGORITHM OUTLINE

    The very basic outline of unconstrained AGS algorithm is given below:

    0. If sampling radius is below EpsX  or  we  performed  more  then  MaxIts
       iterations - STOP.
    1. sample O(N) gradient values at random locations  around  current point;
       informally speaking, this sample is an implicit piecewise  linear model
       of the function, although algorithm formulation does  not  mention that
       explicitly
    2. solve quadratic programming problem in order to find descent direction
    3. if QP solver tells us that we  are  near  solution,  decrease  sampling
       radius and move to (0)
    4. perform backtracking line search
    5. after moving to new point, goto (0)

    As for the constraints:
    * box constraints are handled exactly  by  modification  of  the  function
      being minimized
    * linear/nonlinear constraints are handled by adding L1  penalty.  Because
      our solver can handle nonsmoothness, we can  use  L1  penalty  function,
      which is an exact one  (i.e.  exact  solution  is  returned  under  such
      penalty).
    * penalty coefficient for  linear  constraints  is  chosen  automatically;
      however, penalty coefficient for nonlinear constraints must be specified
      by user.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetalgoags(minnsstate state, double radius, double penalty)
    {

        minns.minnssetalgoags(state.innerobj, radius, penalty);
        return;
    }

    /*************************************************************************
    This function turns on/off reporting.

    INPUT PARAMETERS:
        State   -   structure which stores algorithm state
        NeedXRep-   whether iteration reports are needed or not

    If NeedXRep is True, algorithm will call rep() callback function if  it is
    provided to minnsoptimize().

      -- ALGLIB --
         Copyright 28.11.2010 by Bochkanov Sergey
    *************************************************************************/
    public static void minnssetxrep(minnsstate state, bool needxrep)
    {

        minns.minnssetxrep(state.innerobj, needxrep);
        return;
    }

    /*************************************************************************
    This subroutine submits request for termination of running  optimizer.  It
    should be called from user-supplied callback when user decides that it  is
    time to "smoothly" terminate optimization process.  As  result,  optimizer
    stops at point which was "current accepted" when termination  request  was
    submitted and returns error code 8 (successful termination).

    INPUT PARAMETERS:
        State   -   optimizer structure

    NOTE: after  request  for  termination  optimizer  may   perform   several
          additional calls to user-supplied callbacks. It does  NOT  guarantee
          to stop immediately - it just guarantees that these additional calls
          will be discarded later.

    NOTE: calling this function on optimizer which is NOT running will have no
          effect.

    NOTE: multiple calls to this function are possible. First call is counted,
          subsequent calls are silently ignored.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnsrequesttermination(minnsstate state)
    {

        minns.minnsrequesttermination(state.innerobj);
        return;
    }

    /*************************************************************************
    This function provides reverse communication interface
    Reverse communication interface is not documented or recommended to use.
    See below for functions which provide better documented API
    *************************************************************************/
    public static bool minnsiteration(minnsstate state)
    {

        bool result = minns.minnsiteration(state.innerobj);
        return result;
    }
    /*************************************************************************
    This family of functions is used to launcn iterations of nonlinear optimizer

    These functions accept following parameters:
        fvec    -   callback which calculates function vector fi[]
                    at given point x
        jac     -   callback which calculates function vector fi[]
                    and Jacobian jac at given point x
        rep     -   optional callback which is called after each iteration
                    can be null
        obj     -   optional object which is passed to func/grad/hess/jac/rep
                    can be null


    NOTES:

    1. This function has two different implementations: one which  uses  exact
       (analytical) user-supplied Jacobian, and one which uses  only  function
       vector and numerically  differentiates  function  in  order  to  obtain
       gradient.

       Depending  on  the  specific  function  used to create optimizer object
       you should choose appropriate variant of  minnsoptimize() -  one  which
       accepts function AND Jacobian or one which accepts ONLY function.

       Be careful to choose variant of minnsoptimize()  which  corresponds  to
       your optimization scheme! Table below lists different  combinations  of
       callback (function/gradient) passed to minnsoptimize()    and  specific
       function used to create optimizer.


                         |         USER PASSED TO minnsoptimize()
       CREATED WITH      |  function only   |  function and gradient
       ------------------------------------------------------------
       minnscreatef()    |     works               FAILS
       minnscreate()     |     FAILS               works

       Here "FAILS" denotes inappropriate combinations  of  optimizer creation
       function  and  minnsoptimize()  version.   Attemps   to    use     such
       combination will lead to exception. Either  you  did  not pass gradient
       when it WAS needed or you passed gradient when it was NOT needed.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey

    *************************************************************************/
    public static void minnsoptimize(minnsstate state, ndimensional_fvec  fvec, ndimensional_rep rep, object obj)
    {
        if( fvec==null )
            throw new alglibexception("ALGLIB: error in 'minnsoptimize()' (fvec is null)");
        while( alglib.minnsiteration(state) )
        {
            if( state.needfi )
            {
                fvec(state.x, state.innerobj.fi, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minnsoptimize' (some derivatives were not provided?)");
        }
    }


    public static void minnsoptimize(minnsstate state, ndimensional_jac  jac, ndimensional_rep rep, object obj)
    {
        if( jac==null )
            throw new alglibexception("ALGLIB: error in 'minnsoptimize()' (jac is null)");
        while( alglib.minnsiteration(state) )
        {
            if( state.needfij )
            {
                jac(state.x, state.innerobj.fi, state.innerobj.j, obj);
                continue;
            }
            if( state.innerobj.xupdated )
            {
                if( rep!=null )
                    rep(state.innerobj.x, state.innerobj.f, obj);
                continue;
            }
            throw new alglibexception("ALGLIB: error in 'minnsoptimize' (some derivatives were not provided?)");
        }
    }



    /*************************************************************************
    MinNS results

    INPUT PARAMETERS:
        State   -   algorithm state

    OUTPUT PARAMETERS:
        X       -   array[0..N-1], solution
        Rep     -   optimization report. You should check Rep.TerminationType
                    in  order  to  distinguish  successful  termination  from
                    unsuccessful one:
                    * -8   internal integrity control  detected  infinite  or
                           NAN   values   in   function/gradient.    Abnormal
                           termination signalled.
                    * -3   box constraints are inconsistent
                    * -1   inconsistent parameters were passed:
                           * penalty parameter for minnssetalgoags() is zero,
                             but we have nonlinear constraints set by minnssetnlc()
                    *  2   sampling radius decreased below epsx
                    *  7    stopping conditions are too stringent,
                            further improvement is impossible,
                            X contains best point found so far.
                    *  8    User requested termination via minnsrequesttermination()

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnsresults(minnsstate state, out double[] x, out minnsreport rep)
    {
        x = new double[0];
        rep = new minnsreport();
        minns.minnsresults(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************

    Buffered implementation of minnsresults() which uses pre-allocated  buffer
    to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
    intended to be used in the inner cycles of performance critical algorithms
    where array reallocation penalty is too large to be ignored.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnsresultsbuf(minnsstate state, ref double[] x, minnsreport rep)
    {

        minns.minnsresultsbuf(state.innerobj, ref x, rep.innerobj);
        return;
    }

    /*************************************************************************
    This subroutine restarts algorithm from new point.
    All optimization parameters (including constraints) are left unchanged.

    This  function  allows  to  solve multiple  optimization  problems  (which
    must have  same number of dimensions) without object reallocation penalty.

    INPUT PARAMETERS:
        State   -   structure previously allocated with minnscreate() call.
        X       -   new starting point.

      -- ALGLIB --
         Copyright 18.05.2015 by Bochkanov Sergey
    *************************************************************************/
    public static void minnsrestartfrom(minnsstate state, double[] x)
    {

        minns.minnsrestartfrom(state.innerobj, x);
        return;
    }

}
public partial class alglib
{
    public class optserv
    {
        /*************************************************************************
        This structure is used to store temporary buffers for L-BFGS-based preconditioner.

          -- ALGLIB --
             Copyright 01.07.2014 by Bochkanov Sergey
        *************************************************************************/
        public class precbuflbfgs : apobject
        {
            public double[] norms;
            public double[] alpha;
            public double[] rho;
            public double[,] yk;
            public int[] idx;
            public double[] bufa;
            public int[] bufb;
            public precbuflbfgs()
            {
                init();
            }
            public override void init()
            {
                norms = new double[0];
                alpha = new double[0];
                rho = new double[0];
                yk = new double[0,0];
                idx = new int[0];
                bufa = new double[0];
                bufb = new int[0];
            }
            public override alglib.apobject make_copy()
            {
                precbuflbfgs _result = new precbuflbfgs();
                _result.norms = (double[])norms.Clone();
                _result.alpha = (double[])alpha.Clone();
                _result.rho = (double[])rho.Clone();
                _result.yk = (double[,])yk.Clone();
                _result.idx = (int[])idx.Clone();
                _result.bufa = (double[])bufa.Clone();
                _result.bufb = (int[])bufb.Clone();
                return _result;
            }
        };


        /*************************************************************************
        This structure is used to store temporary buffers for LowRank preconditioner.

          -- ALGLIB --
             Copyright 21.08.2014 by Bochkanov Sergey
        *************************************************************************/
        public class precbuflowrank : apobject
        {
            public int n;
            public int k;
            public double[] d;
            public double[,] v;
            public double[] bufc;
            public double[,] bufz;
            public double[,] bufw;
            public double[] tmp;
            public precbuflowrank()
            {
                init();
            }
            public override void init()
            {
                d = new double[0];
                v = new double[0,0];
                bufc = new double[0];
                bufz = new double[0,0];
                bufw = new double[0,0];
                tmp = new double[0];
            }
            public override alglib.apobject make_copy()
            {
                precbuflowrank _result = new precbuflowrank();
                _result.n = n;
                _result.k = k;
                _result.d = (double[])d.Clone();
                _result.v = (double[,])v.Clone();
                _result.bufc = (double[])bufc.Clone();
                _result.bufz = (double[,])bufz.Clone();
                _result.bufw = (double[,])bufw.Clone();
                _result.tmp = (double[])tmp.Clone();
                return _result;
            }
        };




        /*************************************************************************
        This subroutine is used to prepare threshold value which will be used for
        trimming of the target function (see comments on TrimFunction() for more
        information).

        This function accepts only one parameter: function value at the starting
        point. It returns threshold which will be used for trimming.

          -- ALGLIB --
             Copyright 10.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void trimprepare(double f,
            ref double threshold)
        {
            threshold = 0;

            threshold = 10*(Math.Abs(f)+1);
        }


        /*************************************************************************
        This subroutine is used to "trim" target function, i.e. to do following
        transformation:

                           { {F,G}          if F<Threshold
            {F_tr, G_tr} = {
                           { {Threshold, 0} if F>=Threshold
                           
        Such transformation allows us to  solve  problems  with  singularities  by
        redefining function in such way that it becomes bounded from above.

          -- ALGLIB --
             Copyright 10.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void trimfunction(ref double f,
            ref double[] g,
            int n,
            double threshold)
        {
            int i = 0;

            if( (double)(f)>=(double)(threshold) )
            {
                f = threshold;
                for(i=0; i<=n-1; i++)
                {
                    g[i] = 0.0;
                }
            }
        }


        /*************************************************************************
        This function enforces boundary constraints in the X.

        This function correctly (although a bit inefficient) handles BL[i] which
        are -INF and BU[i] which are +INF.

        We have NMain+NSlack  dimensional  X,  with first NMain components bounded
        by BL/BU, and next NSlack ones bounded by non-negativity constraints.

        INPUT PARAMETERS
            X       -   array[NMain+NSlack], point
            BL      -   array[NMain], lower bounds
                        (may contain -INF, when bound is not present)
            HaveBL  -   array[NMain], if HaveBL[i] is False,
                        then i-th bound is not present
            BU      -   array[NMain], upper bounds
                        (may contain +INF, when bound is not present)
            HaveBU  -   array[NMain], if HaveBU[i] is False,
                        then i-th bound is not present

        OUTPUT PARAMETERS
            X       -   X with all constraints being enforced

        It returns True when constraints are consistent,
        False - when constraints are inconsistent.

          -- ALGLIB --
             Copyright 10.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static bool enforceboundaryconstraints(double[] x,
            double[] bl,
            bool[] havebl,
            double[] bu,
            bool[] havebu,
            int nmain,
            int nslack)
        {
            bool result = new bool();
            int i = 0;

            result = false;
            for(i=0; i<=nmain-1; i++)
            {
                if( (havebl[i] && havebu[i]) && (double)(bl[i])>(double)(bu[i]) )
                {
                    return result;
                }
                if( havebl[i] && (double)(x[i])<(double)(bl[i]) )
                {
                    x[i] = bl[i];
                }
                if( havebu[i] && (double)(x[i])>(double)(bu[i]) )
                {
                    x[i] = bu[i];
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                if( (double)(x[nmain+i])<(double)(0) )
                {
                    x[nmain+i] = 0;
                }
            }
            result = true;
            return result;
        }


        /*************************************************************************
        This function projects gradient into feasible area of boundary constrained
        optimization  problem.  X  can  be  infeasible  with  respect  to boundary
        constraints.  We  have  NMain+NSlack  dimensional  X,   with  first  NMain 
        components bounded by BL/BU, and next NSlack ones bounded by non-negativity
        constraints.

        INPUT PARAMETERS
            X       -   array[NMain+NSlack], point
            G       -   array[NMain+NSlack], gradient
            BL      -   lower bounds (may contain -INF, when bound is not present)
            HaveBL  -   if HaveBL[i] is False, then i-th bound is not present
            BU      -   upper bounds (may contain +INF, when bound is not present)
            HaveBU  -   if HaveBU[i] is False, then i-th bound is not present

        OUTPUT PARAMETERS
            G       -   projection of G. Components of G which satisfy one of the
                        following
                            (1) (X[I]<=BndL[I]) and (G[I]>0), OR
                            (2) (X[I]>=BndU[I]) and (G[I]<0)
                        are replaced by zeros.

        NOTE 1: this function assumes that constraints are feasible. It throws
        exception otherwise.

        NOTE 2: in fact, projection of ANTI-gradient is calculated,  because  this
        function trims components of -G which points outside of the feasible area.
        However, working with -G is considered confusing, because all optimization
        source work with G.

          -- ALGLIB --
             Copyright 10.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void projectgradientintobc(double[] x,
            ref double[] g,
            double[] bl,
            bool[] havebl,
            double[] bu,
            bool[] havebu,
            int nmain,
            int nslack)
        {
            int i = 0;

            for(i=0; i<=nmain-1; i++)
            {
                alglib.ap.assert((!havebl[i] || !havebu[i]) || (double)(bl[i])<=(double)(bu[i]), "ProjectGradientIntoBC: internal error (infeasible constraints)");
                if( (havebl[i] && (double)(x[i])<=(double)(bl[i])) && (double)(g[i])>(double)(0) )
                {
                    g[i] = 0;
                }
                if( (havebu[i] && (double)(x[i])>=(double)(bu[i])) && (double)(g[i])<(double)(0) )
                {
                    g[i] = 0;
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                if( (double)(x[nmain+i])<=(double)(0) && (double)(g[nmain+i])>(double)(0) )
                {
                    g[nmain+i] = 0;
                }
            }
        }


        /*************************************************************************
        Given
            a) initial point X0[NMain+NSlack]
               (feasible with respect to bound constraints)
            b) step vector alpha*D[NMain+NSlack]
            c) boundary constraints BndL[NMain], BndU[NMain]
            d) implicit non-negativity constraints for slack variables
        this  function  calculates  bound  on  the step length subject to boundary
        constraints.

        It returns:
            *  MaxStepLen - such step length that X0+MaxStepLen*alpha*D is exactly
               at the boundary given by constraints
            *  VariableToFreeze - index of the constraint to be activated,
               0 <= VariableToFreeze < NMain+NSlack
            *  ValueToFreeze - value of the corresponding constraint.

        Notes:
            * it is possible that several constraints can be activated by the step
              at once. In such cases only one constraint is returned. It is caller
              responsibility to check other constraints. This function makes  sure
              that we activate at least one constraint, and everything else is the
              responsibility of the caller.
            * steps smaller than MaxStepLen still can activate constraints due  to
              numerical errors. Thus purpose of this  function  is  not  to  guard 
              against accidental activation of the constraints - quite the reverse, 
              its purpose is to activate at least constraint upon performing  step
              which is too long.
            * in case there is no constraints to activate, we return negative
              VariableToFreeze and zero MaxStepLen and ValueToFreeze.
            * this function assumes that constraints are consistent; it throws
              exception otherwise.

        INPUT PARAMETERS
            X           -   array[NMain+NSlack], point. Must be feasible with respect 
                            to bound constraints (exception will be thrown otherwise)
            D           -   array[NMain+NSlack], step direction
            alpha       -   scalar multiplier before D, alpha<>0
            BndL        -   lower bounds, array[NMain]
                            (may contain -INF, when bound is not present)
            HaveBndL    -   array[NMain], if HaveBndL[i] is False,
                            then i-th bound is not present
            BndU        -   array[NMain], upper bounds
                            (may contain +INF, when bound is not present)
            HaveBndU    -   array[NMain], if HaveBndU[i] is False,
                            then i-th bound is not present
            NMain       -   number of main variables
            NSlack      -   number of slack variables
            
        OUTPUT PARAMETERS
            VariableToFreeze:
                            * negative value     = step is unbounded, ValueToFreeze=0,
                                                   MaxStepLen=0.
                            * non-negative value = at least one constraint, given by
                                                   this parameter, will  be  activated
                                                   upon performing maximum step.
            ValueToFreeze-  value of the variable which will be constrained
            MaxStepLen  -   maximum length of the step. Can be zero when step vector
                            looks outside of the feasible area.

          -- ALGLIB --
             Copyright 10.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void calculatestepbound(double[] x,
            double[] d,
            double alpha,
            double[] bndl,
            bool[] havebndl,
            double[] bndu,
            bool[] havebndu,
            int nmain,
            int nslack,
            ref int variabletofreeze,
            ref double valuetofreeze,
            ref double maxsteplen)
        {
            int i = 0;
            double prevmax = 0;
            double initval = 0;

            variabletofreeze = 0;
            valuetofreeze = 0;
            maxsteplen = 0;

            alglib.ap.assert((double)(alpha)!=(double)(0), "CalculateStepBound: zero alpha");
            variabletofreeze = -1;
            initval = math.maxrealnumber;
            maxsteplen = initval;
            for(i=0; i<=nmain-1; i++)
            {
                if( havebndl[i] && (double)(alpha*d[i])<(double)(0) )
                {
                    alglib.ap.assert((double)(x[i])>=(double)(bndl[i]), "CalculateStepBound: infeasible X");
                    prevmax = maxsteplen;
                    maxsteplen = apserv.safeminposrv(x[i]-bndl[i], -(alpha*d[i]), maxsteplen);
                    if( (double)(maxsteplen)<(double)(prevmax) )
                    {
                        variabletofreeze = i;
                        valuetofreeze = bndl[i];
                    }
                }
                if( havebndu[i] && (double)(alpha*d[i])>(double)(0) )
                {
                    alglib.ap.assert((double)(x[i])<=(double)(bndu[i]), "CalculateStepBound: infeasible X");
                    prevmax = maxsteplen;
                    maxsteplen = apserv.safeminposrv(bndu[i]-x[i], alpha*d[i], maxsteplen);
                    if( (double)(maxsteplen)<(double)(prevmax) )
                    {
                        variabletofreeze = i;
                        valuetofreeze = bndu[i];
                    }
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                if( (double)(alpha*d[nmain+i])<(double)(0) )
                {
                    alglib.ap.assert((double)(x[nmain+i])>=(double)(0), "CalculateStepBound: infeasible X");
                    prevmax = maxsteplen;
                    maxsteplen = apserv.safeminposrv(x[nmain+i], -(alpha*d[nmain+i]), maxsteplen);
                    if( (double)(maxsteplen)<(double)(prevmax) )
                    {
                        variabletofreeze = nmain+i;
                        valuetofreeze = 0;
                    }
                }
            }
            if( (double)(maxsteplen)==(double)(initval) )
            {
                valuetofreeze = 0;
                maxsteplen = 0;
            }
        }


        /*************************************************************************
        This function postprocesses bounded step by:
        * analysing step length (whether it is equal to MaxStepLen) and activating 
          constraint given by VariableToFreeze if needed
        * checking for additional bound constraints to activate

        This function uses final point of the step, quantities calculated  by  the
        CalculateStepBound()  function.  As  result,  it  returns  point  which is 
        exactly feasible with respect to boundary constraints.

        NOTE 1: this function does NOT handle and check linear equality constraints
        NOTE 2: when StepTaken=MaxStepLen we always activate at least one constraint

        INPUT PARAMETERS
            X           -   array[NMain+NSlack], final point to postprocess
            XPrev       -   array[NMain+NSlack], initial point
            BndL        -   lower bounds, array[NMain]
                            (may contain -INF, when bound is not present)
            HaveBndL    -   array[NMain], if HaveBndL[i] is False,
                            then i-th bound is not present
            BndU        -   array[NMain], upper bounds
                            (may contain +INF, when bound is not present)
            HaveBndU    -   array[NMain], if HaveBndU[i] is False,
                            then i-th bound is not present
            NMain       -   number of main variables
            NSlack      -   number of slack variables
            VariableToFreeze-result of CalculateStepBound()
            ValueToFreeze-  result of CalculateStepBound()
            StepTaken   -   actual step length (actual step is equal to the possibly 
                            non-unit step direction vector times this parameter).
                            StepTaken<=MaxStepLen.
            MaxStepLen  -   result of CalculateStepBound()
            
        OUTPUT PARAMETERS
            X           -   point bounded with respect to constraints.
                            components corresponding to active constraints are exactly
                            equal to the boundary values.
                            
        RESULT:
            number of constraints activated in addition to previously active ones.
            Constraints which were DEACTIVATED are ignored (do not influence
            function value).

          -- ALGLIB --
             Copyright 10.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static int postprocessboundedstep(ref double[] x,
            double[] xprev,
            double[] bndl,
            bool[] havebndl,
            double[] bndu,
            bool[] havebndu,
            int nmain,
            int nslack,
            int variabletofreeze,
            double valuetofreeze,
            double steptaken,
            double maxsteplen)
        {
            int result = 0;
            int i = 0;
            bool wasactivated = new bool();

            alglib.ap.assert(variabletofreeze<0 || (double)(steptaken)<=(double)(maxsteplen));
            
            //
            // Activate constraints
            //
            if( variabletofreeze>=0 && (double)(steptaken)==(double)(maxsteplen) )
            {
                x[variabletofreeze] = valuetofreeze;
            }
            for(i=0; i<=nmain-1; i++)
            {
                if( havebndl[i] && (double)(x[i])<(double)(bndl[i]) )
                {
                    x[i] = bndl[i];
                }
                if( havebndu[i] && (double)(x[i])>(double)(bndu[i]) )
                {
                    x[i] = bndu[i];
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                if( (double)(x[nmain+i])<=(double)(0) )
                {
                    x[nmain+i] = 0;
                }
            }
            
            //
            // Calculate number of constraints being activated
            //
            result = 0;
            for(i=0; i<=nmain-1; i++)
            {
                wasactivated = (double)(x[i])!=(double)(xprev[i]) && ((havebndl[i] && (double)(x[i])==(double)(bndl[i])) || (havebndu[i] && (double)(x[i])==(double)(bndu[i])));
                wasactivated = wasactivated || variabletofreeze==i;
                if( wasactivated )
                {
                    result = result+1;
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                wasactivated = (double)(x[nmain+i])!=(double)(xprev[nmain+i]) && (double)(x[nmain+i])==(double)(0.0);
                wasactivated = wasactivated || variabletofreeze==nmain+i;
                if( wasactivated )
                {
                    result = result+1;
                }
            }
            return result;
        }


        /*************************************************************************
        The  purpose  of  this  function is to prevent algorithm from "unsticking" 
        from  the  active  bound  constraints  because  of  numerical noise in the
        gradient or Hessian.

        It is done by zeroing some components of the search direction D.  D[i]  is
        zeroed when both (a) and (b) are true:
        a) corresponding X[i] is exactly at the boundary
        b) |D[i]*S[i]| <= DropTol*Sqrt(SUM(D[i]^2*S[I]^2))

        D  can  be  step  direction , antigradient, gradient, or anything similar. 
        Sign of D does not matter, nor matters step length.

        NOTE 1: boundary constraints are expected to be consistent, as well as X
                is expected to be feasible. Exception will be thrown otherwise.

        INPUT PARAMETERS
            D           -   array[NMain+NSlack], direction
            X           -   array[NMain+NSlack], current point
            BndL        -   lower bounds, array[NMain]
                            (may contain -INF, when bound is not present)
            HaveBndL    -   array[NMain], if HaveBndL[i] is False,
                            then i-th bound is not present
            BndU        -   array[NMain], upper bounds
                            (may contain +INF, when bound is not present)
            HaveBndU    -   array[NMain], if HaveBndU[i] is False,
                            then i-th bound is not present
            S           -   array[NMain+NSlack], scaling of the variables
            NMain       -   number of main variables
            NSlack      -   number of slack variables
            DropTol     -   drop tolerance, >=0
            
        OUTPUT PARAMETERS
            X           -   point bounded with respect to constraints.
                            components corresponding to active constraints are exactly
                            equal to the boundary values.

          -- ALGLIB --
             Copyright 10.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void filterdirection(ref double[] d,
            double[] x,
            double[] bndl,
            bool[] havebndl,
            double[] bndu,
            bool[] havebndu,
            double[] s,
            int nmain,
            int nslack,
            double droptol)
        {
            int i = 0;
            double scalednorm = 0;
            bool isactive = new bool();

            scalednorm = 0.0;
            for(i=0; i<=nmain+nslack-1; i++)
            {
                scalednorm = scalednorm+math.sqr(d[i]*s[i]);
            }
            scalednorm = Math.Sqrt(scalednorm);
            for(i=0; i<=nmain-1; i++)
            {
                alglib.ap.assert(!havebndl[i] || (double)(x[i])>=(double)(bndl[i]), "FilterDirection: infeasible point");
                alglib.ap.assert(!havebndu[i] || (double)(x[i])<=(double)(bndu[i]), "FilterDirection: infeasible point");
                isactive = (havebndl[i] && (double)(x[i])==(double)(bndl[i])) || (havebndu[i] && (double)(x[i])==(double)(bndu[i]));
                if( isactive && (double)(Math.Abs(d[i]*s[i]))<=(double)(droptol*scalednorm) )
                {
                    d[i] = 0.0;
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                alglib.ap.assert((double)(x[nmain+i])>=(double)(0), "FilterDirection: infeasible point");
                if( (double)(x[nmain+i])==(double)(0) && (double)(Math.Abs(d[nmain+i]*s[nmain+i]))<=(double)(droptol*scalednorm) )
                {
                    d[nmain+i] = 0.0;
                }
            }
        }


        /*************************************************************************
        This function returns number of bound constraints whose state was  changed
        (either activated or deactivated) when making step from XPrev to X.

        Constraints are considered:
        * active - when we are exactly at the boundary
        * inactive - when we are not at the boundary

        You should note that antigradient direction is NOT taken into account when
        we make decions on the constraint status.

        INPUT PARAMETERS
            X           -   array[NMain+NSlack], final point.
                            Must be feasible with respect to bound constraints.
            XPrev       -   array[NMain+NSlack], initial point.
                            Must be feasible with respect to bound constraints.
            BndL        -   lower bounds, array[NMain]
                            (may contain -INF, when bound is not present)
            HaveBndL    -   array[NMain], if HaveBndL[i] is False,
                            then i-th bound is not present
            BndU        -   array[NMain], upper bounds
                            (may contain +INF, when bound is not present)
            HaveBndU    -   array[NMain], if HaveBndU[i] is False,
                            then i-th bound is not present
            NMain       -   number of main variables
            NSlack      -   number of slack variables
            
        RESULT:
            number of constraints whose state was changed.

          -- ALGLIB --
             Copyright 10.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static int numberofchangedconstraints(double[] x,
            double[] xprev,
            double[] bndl,
            bool[] havebndl,
            double[] bndu,
            bool[] havebndu,
            int nmain,
            int nslack)
        {
            int result = 0;
            int i = 0;
            bool statuschanged = new bool();

            result = 0;
            for(i=0; i<=nmain-1; i++)
            {
                if( (double)(x[i])!=(double)(xprev[i]) )
                {
                    statuschanged = false;
                    if( havebndl[i] && ((double)(x[i])==(double)(bndl[i]) || (double)(xprev[i])==(double)(bndl[i])) )
                    {
                        statuschanged = true;
                    }
                    if( havebndu[i] && ((double)(x[i])==(double)(bndu[i]) || (double)(xprev[i])==(double)(bndu[i])) )
                    {
                        statuschanged = true;
                    }
                    if( statuschanged )
                    {
                        result = result+1;
                    }
                }
            }
            for(i=0; i<=nslack-1; i++)
            {
                if( (double)(x[nmain+i])!=(double)(xprev[nmain+i]) && ((double)(x[nmain+i])==(double)(0) || (double)(xprev[nmain+i])==(double)(0)) )
                {
                    result = result+1;
                }
            }
            return result;
        }


        /*************************************************************************
        This function finds feasible point of  (NMain+NSlack)-dimensional  problem
        subject to NMain explicit boundary constraints (some  constraints  can  be
        omitted), NSlack implicit non-negativity constraints,  K  linear  equality
        constraints.

        INPUT PARAMETERS
            X           -   array[NMain+NSlack], initial point.
            BndL        -   lower bounds, array[NMain]
                            (may contain -INF, when bound is not present)
            HaveBndL    -   array[NMain], if HaveBndL[i] is False,
                            then i-th bound is not present
            BndU        -   array[NMain], upper bounds
                            (may contain +INF, when bound is not present)
            HaveBndU    -   array[NMain], if HaveBndU[i] is False,
                            then i-th bound is not present
            NMain       -   number of main variables
            NSlack      -   number of slack variables
            CE          -   array[K,NMain+NSlack+1], equality  constraints CE*x=b.
                            Rows contain constraints, first  NMain+NSlack  columns
                            contain coefficients before X[], last  column  contain
                            right part.
            K           -   number of linear constraints
            EpsI        -   infeasibility (error in the right part) allowed in the
                            solution

        OUTPUT PARAMETERS:
            X           -   feasible point or best infeasible point found before
                            algorithm termination
            QPIts       -   number of QP iterations (for debug purposes)
            GPAIts      -   number of GPA iterations (for debug purposes)
            
        RESULT:
            True in case X is feasible, False - if it is infeasible.

          -- ALGLIB --
             Copyright 20.01.2012 by Bochkanov Sergey
        *************************************************************************/
        public static bool findfeasiblepoint(ref double[] x,
            double[] bndl,
            bool[] havebndl,
            double[] bndu,
            bool[] havebndu,
            int nmain,
            int nslack,
            double[,] ce,
            int k,
            double epsi,
            ref int qpits,
            ref int gpaits)
        {
            bool result = new bool();
            int i = 0;
            int j = 0;
            int idx0 = 0;
            int idx1 = 0;
            double[] permx = new double[0];
            double[] xn = new double[0];
            double[] xa = new double[0];
            double[] newtonstep = new double[0];
            double[] g = new double[0];
            double[] pg = new double[0];
            double[,] a = new double[0,0];
            double armijostep = 0;
            double armijobeststep = 0;
            double armijobestfeas = 0;
            double v = 0;
            double mx = 0;
            double feaserr = 0;
            double feaserr0 = 0;
            double feaserr1 = 0;
            double feasold = 0;
            double feasnew = 0;
            double pgnorm = 0;
            double vn = 0;
            double vd = 0;
            double stp = 0;
            int vartofreeze = 0;
            double valtofreeze = 0;
            double maxsteplen = 0;
            bool werechangesinconstraints = new bool();
            bool stage1isover = new bool();
            bool converged = new bool();
            double[] activeconstraints = new double[0];
            double[] tmpk = new double[0];
            double[] colnorms = new double[0];
            int nactive = 0;
            int nfree = 0;
            int nsvd = 0;
            int[] p1 = new int[0];
            int[] p2 = new int[0];
            apserv.apbuffers buf = new apserv.apbuffers();
            double[] w = new double[0];
            double[] s = new double[0];
            double[,] u = new double[0,0];
            double[,] vt = new double[0,0];
            int itscount = 0;
            int itswithintolerance = 0;
            int maxitswithintolerance = 0;
            int badits = 0;
            int maxbadits = 0;
            int gparuns = 0;
            int maxarmijoruns = 0;
            int i_ = 0;

            ce = (double[,])ce.Clone();
            qpits = 0;
            gpaits = 0;

            maxitswithintolerance = 3;
            maxbadits = 3;
            maxarmijoruns = 5;
            qpits = 0;
            gpaits = 0;
            
            //
            // Initial enforcement of the feasibility with respect to boundary constraints
            // NOTE: after this block we assume that boundary constraints are consistent.
            //
            if( !enforceboundaryconstraints(x, bndl, havebndl, bndu, havebndu, nmain, nslack) )
            {
                result = false;
                return result;
            }
            if( k==0 )
            {
                
                //
                // No linear constraints, we can exit right now
                //
                result = true;
                return result;
            }
            
            //
            // Scale rows of CE in such way that max(CE[i,0..nmain+nslack-1])=1 for any i=0..k-1
            //
            for(i=0; i<=k-1; i++)
            {
                v = 0.0;
                for(j=0; j<=nmain+nslack-1; j++)
                {
                    v = Math.Max(v, Math.Abs(ce[i,j]));
                }
                if( (double)(v)!=(double)(0) )
                {
                    v = 1/v;
                    for(i_=0; i_<=nmain+nslack;i_++)
                    {
                        ce[i,i_] = v*ce[i,i_];
                    }
                }
            }
            
            //
            // Allocate temporaries
            //
            xn = new double[nmain+nslack];
            xa = new double[nmain+nslack];
            permx = new double[nmain+nslack];
            g = new double[nmain+nslack];
            pg = new double[nmain+nslack];
            tmpk = new double[k];
            a = new double[k, nmain+nslack];
            activeconstraints = new double[nmain+nslack];
            newtonstep = new double[nmain+nslack];
            s = new double[nmain+nslack];
            colnorms = new double[nmain+nslack];
            for(i=0; i<=nmain+nslack-1; i++)
            {
                s[i] = 1.0;
                colnorms[i] = 0.0;
                for(j=0; j<=k-1; j++)
                {
                    colnorms[i] = colnorms[i]+math.sqr(ce[j,i]);
                }
            }
            
            //
            // K>0, we have linear equality constraints combined with bound constraints.
            //
            // Try to find feasible point as minimizer of the quadratic function
            //     F(x) = 0.5*||CE*x-b||^2 = 0.5*x'*(CE'*CE)*x - (b'*CE)*x + 0.5*b'*b
            // subject to boundary constraints given by BL, BU and non-negativity of
            // the slack variables. BTW, we drop constant term because it does not
            // actually influences on the solution.
            //
            // Below we will assume that K>0.
            //
            itswithintolerance = 0;
            badits = 0;
            itscount = 0;
            while( true )
            {
                
                //
                // Stage 0: check for exact convergence
                //
                converged = true;
                feaserr = 0;
                for(i=0; i<=k-1; i++)
                {
                    
                    //
                    // Calculate:
                    // * V - error in the right part
                    // * MX - maximum term in the left part
                    //
                    // Terminate if error in the right part is not greater than 100*Eps*MX.
                    //
                    // IMPORTANT: we must perform check for non-strict inequality, i.e. to use <= instead of <.
                    //            it will allow us to easily handle situations with zero rows of CE.
                    //
                    mx = 0;
                    v = -ce[i,nmain+nslack];
                    for(j=0; j<=nmain+nslack-1; j++)
                    {
                        mx = Math.Max(mx, Math.Abs(ce[i,j]*x[j]));
                        v = v+ce[i,j]*x[j];
                    }
                    feaserr = feaserr+math.sqr(v);
                    converged = converged && (double)(Math.Abs(v))<=(double)(100*math.machineepsilon*mx);
                }
                feaserr = Math.Sqrt(feaserr);
                feaserr0 = feaserr;
                if( converged )
                {
                    result = (double)(feaserr)<=(double)(epsi);
                    return result;
                }
                
                //
                // Stage 1: equality constrained quadratic programming
                //
                // * treat active bound constraints as equality ones (constraint is considered 
                //   active when we are at the boundary, independently of the antigradient direction)
                // * calculate unrestricted Newton step to point XM (which may be infeasible)
                //   calculate MaxStepLen = largest step in direction of XM which retains feasibility.
                // * perform bounded step from X to XN:
                //   a) XN=XM                  (if XM is feasible)
                //   b) XN=X-MaxStepLen*(XM-X) (otherwise)
                // * X := XN
                // * if XM (Newton step subject to currently active constraints) was feasible, goto Stage 2
                // * repeat Stage 1
                //
                // NOTE 1: in order to solve constrained qudratic subproblem we will have to reorder
                //         variables in such way that ones corresponding to inactive constraints will
                //         be first, and active ones will be last in the list. CE and X are now
                //                                                       [ xi ]
                //         separated into two parts: CE = [CEi CEa], x = [    ], where CEi/Xi correspond
                //                                                       [ xa ]
                //         to INACTIVE constraints, and CEa/Xa correspond to the ACTIVE ones.
                //
                //         Now, instead of F=0.5*x'*(CE'*CE)*x - (b'*CE)*x + 0.5*b'*b, we have
                //         F(xi) = 0.5*(CEi*xi,CEi*xi) + (CEa*xa-b,CEi*xi) + (0.5*CEa*xa-b,CEa*xa).
                //         Here xa is considered constant, i.e. we optimize with respect to xi, leaving xa fixed.
                //
                //         We can solve it by performing SVD of CEi and calculating pseudoinverse of the
                //         Hessian matrix. Of course, we do NOT calculate pseudoinverse explicitly - we
                //         just use singular vectors to perform implicit multiplication by it.
                //
                //
                while( true )
                {
                    
                    //
                    // Calculate G - gradient subject to equality constraints,
                    // multiply it by inverse of the Hessian diagonal to obtain initial
                    // step vector.
                    //
                    // Bound step subject to constraints which can be activated,
                    // run Armijo search with increasing step size.
                    // Search is terminated when feasibility error stops to decrease.
                    //
                    // NOTE: it is important to test for "stops to decrease" instead
                    // of "starts to increase" in order to correctly handle cases with
                    // zero CE.
                    //
                    armijobeststep = 0.0;
                    armijobestfeas = 0.0;
                    for(i=0; i<=nmain+nslack-1; i++)
                    {
                        g[i] = 0;
                    }
                    for(i=0; i<=k-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            v += ce[i,i_]*x[i_];
                        }
                        v = v-ce[i,nmain+nslack];
                        armijobestfeas = armijobestfeas+math.sqr(v);
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            g[i_] = g[i_] + v*ce[i,i_];
                        }
                    }
                    armijobestfeas = Math.Sqrt(armijobestfeas);
                    for(i=0; i<=nmain-1; i++)
                    {
                        if( havebndl[i] && (double)(x[i])==(double)(bndl[i]) )
                        {
                            g[i] = 0.0;
                        }
                        if( havebndu[i] && (double)(x[i])==(double)(bndu[i]) )
                        {
                            g[i] = 0.0;
                        }
                    }
                    for(i=0; i<=nslack-1; i++)
                    {
                        if( (double)(x[nmain+i])==(double)(0.0) )
                        {
                            g[nmain+i] = 0.0;
                        }
                    }
                    v = 0.0;
                    for(i=0; i<=nmain+nslack-1; i++)
                    {
                        if( (double)(math.sqr(colnorms[i]))!=(double)(0) )
                        {
                            newtonstep[i] = -(g[i]/math.sqr(colnorms[i]));
                        }
                        else
                        {
                            newtonstep[i] = 0.0;
                        }
                        v = v+math.sqr(newtonstep[i]);
                    }
                    if( (double)(v)==(double)(0) )
                    {
                        
                        //
                        // Constrained gradient is zero, QP iterations are over
                        //
                        break;
                    }
                    calculatestepbound(x, newtonstep, 1.0, bndl, havebndl, bndu, havebndu, nmain, nslack, ref vartofreeze, ref valtofreeze, ref maxsteplen);
                    if( vartofreeze>=0 && (double)(maxsteplen)==(double)(0) )
                    {
                        
                        //
                        // Can not perform step, QP iterations are over
                        //
                        break;
                    }
                    if( vartofreeze>=0 )
                    {
                        armijostep = Math.Min(1.0, maxsteplen);
                    }
                    else
                    {
                        armijostep = 1;
                    }
                    while( true )
                    {
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            xa[i_] = x[i_];
                        }
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            xa[i_] = xa[i_] + armijostep*newtonstep[i_];
                        }
                        enforceboundaryconstraints(xa, bndl, havebndl, bndu, havebndu, nmain, nslack);
                        feaserr = 0.0;
                        for(i=0; i<=k-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=nmain+nslack-1;i_++)
                            {
                                v += ce[i,i_]*xa[i_];
                            }
                            v = v-ce[i,nmain+nslack];
                            feaserr = feaserr+math.sqr(v);
                        }
                        feaserr = Math.Sqrt(feaserr);
                        if( (double)(feaserr)>=(double)(armijobestfeas) )
                        {
                            break;
                        }
                        armijobestfeas = feaserr;
                        armijobeststep = armijostep;
                        armijostep = 2.0*armijostep;
                    }
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        x[i_] = x[i_] + armijobeststep*newtonstep[i_];
                    }
                    enforceboundaryconstraints(x, bndl, havebndl, bndu, havebndu, nmain, nslack);
                    
                    //
                    // Determine number of active and free constraints
                    //
                    nactive = 0;
                    for(i=0; i<=nmain-1; i++)
                    {
                        activeconstraints[i] = 0;
                        if( havebndl[i] && (double)(x[i])==(double)(bndl[i]) )
                        {
                            activeconstraints[i] = 1;
                        }
                        if( havebndu[i] && (double)(x[i])==(double)(bndu[i]) )
                        {
                            activeconstraints[i] = 1;
                        }
                        if( (double)(activeconstraints[i])>(double)(0) )
                        {
                            nactive = nactive+1;
                        }
                    }
                    for(i=0; i<=nslack-1; i++)
                    {
                        activeconstraints[nmain+i] = 0;
                        if( (double)(x[nmain+i])==(double)(0.0) )
                        {
                            activeconstraints[nmain+i] = 1;
                        }
                        if( (double)(activeconstraints[nmain+i])>(double)(0) )
                        {
                            nactive = nactive+1;
                        }
                    }
                    nfree = nmain+nslack-nactive;
                    if( nfree==0 )
                    {
                        break;
                    }
                    qpits = qpits+1;
                    
                    //
                    // Reorder variables
                    //
                    tsort.tagsortbuf(ref activeconstraints, nmain+nslack, ref p1, ref p2, buf);
                    for(i=0; i<=k-1; i++)
                    {
                        for(j=0; j<=nmain+nslack-1; j++)
                        {
                            a[i,j] = ce[i,j];
                        }
                    }
                    for(j=0; j<=nmain+nslack-1; j++)
                    {
                        permx[j] = x[j];
                    }
                    for(j=0; j<=nmain+nslack-1; j++)
                    {
                        if( p2[j]!=j )
                        {
                            idx0 = p2[j];
                            idx1 = j;
                            for(i=0; i<=k-1; i++)
                            {
                                v = a[i,idx0];
                                a[i,idx0] = a[i,idx1];
                                a[i,idx1] = v;
                            }
                            v = permx[idx0];
                            permx[idx0] = permx[idx1];
                            permx[idx1] = v;
                        }
                    }
                    
                    //
                    // Calculate (unprojected) gradient:
                    // G(xi) = CEi'*(CEi*xi + CEa*xa - b)
                    //
                    for(i=0; i<=nfree-1; i++)
                    {
                        g[i] = 0;
                    }
                    for(i=0; i<=k-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            v += a[i,i_]*permx[i_];
                        }
                        tmpk[i] = v-ce[i,nmain+nslack];
                    }
                    for(i=0; i<=k-1; i++)
                    {
                        v = tmpk[i];
                        for(i_=0; i_<=nfree-1;i_++)
                        {
                            g[i_] = g[i_] + v*a[i,i_];
                        }
                    }
                    
                    //
                    // Calculate Newton step using SVD of CEi:
                    //     F(xi)  = 0.5*xi'*H*xi + g'*xi    (Taylor decomposition)
                    //     XN     = -H^(-1)*g               (new point, solution of the QP subproblem)
                    //     H      = CEi'*CEi                
                    //     CEi    = U*W*V'                  (SVD of CEi)
                    //     H      = V*W^2*V'                 
                    //     H^(-1) = V*W^(-2)*V'
                    //     step     = -V*W^(-2)*V'*g          (it is better to perform multiplication from right to left)
                    //
                    // NOTE 1: we do NOT need left singular vectors to perform Newton step.
                    //
                    nsvd = Math.Min(k, nfree);
                    if( !svd.rmatrixsvd(a, k, nfree, 0, 1, 2, ref w, ref u, ref vt) )
                    {
                        result = false;
                        return result;
                    }
                    for(i=0; i<=nsvd-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=nfree-1;i_++)
                        {
                            v += vt[i,i_]*g[i_];
                        }
                        tmpk[i] = v;
                    }
                    for(i=0; i<=nsvd-1; i++)
                    {
                        
                        //
                        // It is important to have strict ">" in order to correctly 
                        // handle zero singular values.
                        //
                        if( (double)(math.sqr(w[i]))>(double)(math.sqr(w[0])*(nmain+nslack)*math.machineepsilon) )
                        {
                            tmpk[i] = tmpk[i]/math.sqr(w[i]);
                        }
                        else
                        {
                            tmpk[i] = 0;
                        }
                    }
                    for(i=0; i<=nmain+nslack-1; i++)
                    {
                        newtonstep[i] = 0;
                    }
                    for(i=0; i<=nsvd-1; i++)
                    {
                        v = tmpk[i];
                        for(i_=0; i_<=nfree-1;i_++)
                        {
                            newtonstep[i_] = newtonstep[i_] - v*vt[i,i_];
                        }
                    }
                    for(j=nmain+nslack-1; j>=0; j--)
                    {
                        if( p2[j]!=j )
                        {
                            idx0 = p2[j];
                            idx1 = j;
                            v = newtonstep[idx0];
                            newtonstep[idx0] = newtonstep[idx1];
                            newtonstep[idx1] = v;
                        }
                    }
                    
                    //
                    // NewtonStep contains Newton step subject to active bound constraints.
                    //
                    // Such step leads us to the minimizer of the equality constrained F,
                    // but such minimizer may be infeasible because some constraints which
                    // are inactive at the initial point can be violated at the solution.
                    //
                    // Thus, we perform optimization in two stages:
                    // a) perform bounded Newton step, i.e. step in the Newton direction
                    //    until activation of the first constraint
                    // b) in case (MaxStepLen>0)and(MaxStepLen<1), perform additional iteration
                    //    of the Armijo line search in the rest of the Newton direction.
                    //
                    calculatestepbound(x, newtonstep, 1.0, bndl, havebndl, bndu, havebndu, nmain, nslack, ref vartofreeze, ref valtofreeze, ref maxsteplen);
                    if( vartofreeze>=0 && (double)(maxsteplen)==(double)(0) )
                    {
                        
                        //
                        // Activation of the constraints prevent us from performing step,
                        // QP iterations are over
                        //
                        break;
                    }
                    if( vartofreeze>=0 )
                    {
                        v = Math.Min(1.0, maxsteplen);
                    }
                    else
                    {
                        v = 1.0;
                    }
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        xn[i_] = v*newtonstep[i_];
                    }
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        xn[i_] = xn[i_] + x[i_];
                    }
                    postprocessboundedstep(ref xn, x, bndl, havebndl, bndu, havebndu, nmain, nslack, vartofreeze, valtofreeze, v, maxsteplen);
                    if( (double)(maxsteplen)>(double)(0) && (double)(maxsteplen)<(double)(1) )
                    {
                        
                        //
                        // Newton step was restricted by activation of the constraints,
                        // perform Armijo iteration.
                        //
                        // Initial estimate for best step is zero step. We try different
                        // step sizes, from the 1-MaxStepLen (residual of the full Newton
                        // step) to progressively smaller and smaller steps.
                        //
                        armijobeststep = 0.0;
                        armijobestfeas = 0.0;
                        for(i=0; i<=k-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=nmain+nslack-1;i_++)
                            {
                                v += ce[i,i_]*xn[i_];
                            }
                            v = v-ce[i,nmain+nslack];
                            armijobestfeas = armijobestfeas+math.sqr(v);
                        }
                        armijobestfeas = Math.Sqrt(armijobestfeas);
                        armijostep = 1-maxsteplen;
                        for(j=0; j<=maxarmijoruns-1; j++)
                        {
                            for(i_=0; i_<=nmain+nslack-1;i_++)
                            {
                                xa[i_] = xn[i_];
                            }
                            for(i_=0; i_<=nmain+nslack-1;i_++)
                            {
                                xa[i_] = xa[i_] + armijostep*newtonstep[i_];
                            }
                            enforceboundaryconstraints(xa, bndl, havebndl, bndu, havebndu, nmain, nslack);
                            feaserr = 0.0;
                            for(i=0; i<=k-1; i++)
                            {
                                v = 0.0;
                                for(i_=0; i_<=nmain+nslack-1;i_++)
                                {
                                    v += ce[i,i_]*xa[i_];
                                }
                                v = v-ce[i,nmain+nslack];
                                feaserr = feaserr+math.sqr(v);
                            }
                            feaserr = Math.Sqrt(feaserr);
                            if( (double)(feaserr)<(double)(armijobestfeas) )
                            {
                                armijobestfeas = feaserr;
                                armijobeststep = armijostep;
                            }
                            armijostep = 0.5*armijostep;
                        }
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            xa[i_] = xn[i_];
                        }
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            xa[i_] = xa[i_] + armijobeststep*newtonstep[i_];
                        }
                        enforceboundaryconstraints(xa, bndl, havebndl, bndu, havebndu, nmain, nslack);
                    }
                    else
                    {
                        
                        //
                        // Armijo iteration is not performed
                        //
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            xa[i_] = xn[i_];
                        }
                    }
                    stage1isover = (double)(maxsteplen)>=(double)(1) || (double)(maxsteplen)==(double)(0);
                    
                    //
                    // Calculate feasibility errors for old and new X.
                    // These quantinies are used for debugging purposes only.
                    // However, we can leave them in release code because performance impact is insignificant.
                    //
                    // Update X. Exit if needed.
                    //
                    feasold = 0;
                    feasnew = 0;
                    for(i=0; i<=k-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            v += ce[i,i_]*x[i_];
                        }
                        feasold = feasold+math.sqr(v-ce[i,nmain+nslack]);
                        v = 0.0;
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            v += ce[i,i_]*xa[i_];
                        }
                        feasnew = feasnew+math.sqr(v-ce[i,nmain+nslack]);
                    }
                    feasold = Math.Sqrt(feasold);
                    feasnew = Math.Sqrt(feasnew);
                    if( (double)(feasnew)>=(double)(feasold) )
                    {
                        break;
                    }
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        x[i_] = xa[i_];
                    }
                    if( stage1isover )
                    {
                        break;
                    }
                }
                
                //
                // Stage 2: gradient projection algorithm (GPA)
                //
                // * calculate feasibility error (with respect to linear equality constraints)
                // * calculate gradient G of F, project it into feasible area (G => PG)
                // * exit if norm(PG) is exactly zero or feasibility error is smaller than EpsC
                // * let XM be exact minimum of F along -PG (XM may be infeasible).
                //   calculate MaxStepLen = largest step in direction of -PG which retains feasibility.
                // * perform bounded step from X to XN:
                //   a) XN=XM              (if XM is feasible)
                //   b) XN=X-MaxStepLen*PG (otherwise)
                // * X := XN
                // * stop after specified number of iterations or when no new constraints was activated
                //
                // NOTES:
                // * grad(F) = (CE'*CE)*x - (b'*CE)^T
                // * CE[i] denotes I-th row of CE
                // * XM = X+stp*(-PG) where stp=(grad(F(X)),PG)/(CE*PG,CE*PG).
                //   Here PG is a projected gradient, but in fact it can be arbitrary non-zero 
                //   direction vector - formula for minimum of F along PG still will be correct.
                //
                werechangesinconstraints = false;
                for(gparuns=1; gparuns<=k; gparuns++)
                {
                    
                    //
                    // calculate feasibility error and G
                    //
                    feaserr = 0;
                    for(i=0; i<=nmain+nslack-1; i++)
                    {
                        g[i] = 0;
                    }
                    for(i=0; i<=k-1; i++)
                    {
                        
                        //
                        // G += CE[i]^T * (CE[i]*x-b[i])
                        //
                        v = 0.0;
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            v += ce[i,i_]*x[i_];
                        }
                        v = v-ce[i,nmain+nslack];
                        feaserr = feaserr+math.sqr(v);
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            g[i_] = g[i_] + v*ce[i,i_];
                        }
                    }
                    
                    //
                    // project G, filter it (strip numerical noise)
                    //
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        pg[i_] = g[i_];
                    }
                    projectgradientintobc(x, ref pg, bndl, havebndl, bndu, havebndu, nmain, nslack);
                    filterdirection(ref pg, x, bndl, havebndl, bndu, havebndu, s, nmain, nslack, 1.0E-9);
                    for(i=0; i<=nmain+nslack-1; i++)
                    {
                        if( (double)(math.sqr(colnorms[i]))!=(double)(0) )
                        {
                            pg[i] = pg[i]/math.sqr(colnorms[i]);
                        }
                        else
                        {
                            pg[i] = 0.0;
                        }
                    }
                    
                    //
                    // Check GNorm and feasibility.
                    // Exit when GNorm is exactly zero.
                    //
                    pgnorm = 0.0;
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        pgnorm += pg[i_]*pg[i_];
                    }
                    feaserr = Math.Sqrt(feaserr);
                    pgnorm = Math.Sqrt(pgnorm);
                    if( (double)(pgnorm)==(double)(0) )
                    {
                        result = (double)(feaserr)<=(double)(epsi);
                        return result;
                    }
                    
                    //
                    // calculate planned step length
                    //
                    vn = 0.0;
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        vn += g[i_]*pg[i_];
                    }
                    vd = 0;
                    for(i=0; i<=k-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=nmain+nslack-1;i_++)
                        {
                            v += ce[i,i_]*pg[i_];
                        }
                        vd = vd+math.sqr(v);
                    }
                    stp = vn/vd;
                    
                    //
                    // Calculate step bound.
                    // Perform bounded step and post-process it
                    //
                    calculatestepbound(x, pg, -1.0, bndl, havebndl, bndu, havebndu, nmain, nslack, ref vartofreeze, ref valtofreeze, ref maxsteplen);
                    if( vartofreeze>=0 && (double)(maxsteplen)==(double)(0) )
                    {
                        result = false;
                        return result;
                    }
                    if( vartofreeze>=0 )
                    {
                        v = Math.Min(stp, maxsteplen);
                    }
                    else
                    {
                        v = stp;
                    }
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        xn[i_] = x[i_];
                    }
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        xn[i_] = xn[i_] - v*pg[i_];
                    }
                    postprocessboundedstep(ref xn, x, bndl, havebndl, bndu, havebndu, nmain, nslack, vartofreeze, valtofreeze, v, maxsteplen);
                    
                    //
                    // update X
                    // check stopping criteria
                    //
                    werechangesinconstraints = werechangesinconstraints || numberofchangedconstraints(xn, x, bndl, havebndl, bndu, havebndu, nmain, nslack)>0;
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        x[i_] = xn[i_];
                    }
                    gpaits = gpaits+1;
                    if( !werechangesinconstraints )
                    {
                        break;
                    }
                }
                
                //
                // Stage 3: decide to stop algorithm or not to stop
                //
                // 1. we can stop when last GPA run did NOT changed constraints status.
                //    It means that we've found final set of the active constraints even
                //    before GPA made its run. And it means that Newton step moved us to
                //    the minimum subject to the present constraints.
                //    Depending on feasibility error, True or False is returned.
                //
                feaserr = 0;
                for(i=0; i<=k-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=nmain+nslack-1;i_++)
                    {
                        v += ce[i,i_]*x[i_];
                    }
                    v = v-ce[i,nmain+nslack];
                    feaserr = feaserr+math.sqr(v);
                }
                feaserr = Math.Sqrt(feaserr);
                feaserr1 = feaserr;
                if( (double)(feaserr1)>=(double)(feaserr0*(1-1000*math.machineepsilon)) )
                {
                    apserv.inc(ref badits);
                }
                else
                {
                    badits = 0;
                }
                if( (double)(feaserr)<=(double)(epsi) )
                {
                    apserv.inc(ref itswithintolerance);
                }
                else
                {
                    itswithintolerance = 0;
                }
                if( (!werechangesinconstraints || itswithintolerance>=maxitswithintolerance) || badits>=maxbadits )
                {
                    result = (double)(feaserr)<=(double)(epsi);
                    return result;
                }
                itscount = itscount+1;
            }
            return result;
        }


        /*************************************************************************
            This function checks that input derivatives are right. First it scales
        parameters DF0 and DF1 from segment [A;B] to [0;1]. Then it builds Hermite
        spline and derivative of it in 0.5. Search scale as Max(DF0,DF1, |F0-F1|).
        Right derivative has to satisfy condition:
            |H-F|/S<=0,01, |H'-F'|/S<=0,01.
            
        INPUT PARAMETERS:
            F0  -   function's value in X-TestStep point;
            DF0 -   derivative's value in X-TestStep point;
            F1  -   function's value in X+TestStep point;
            DF1 -   derivative's value in X+TestStep point;
            F   -   testing function's value;
            DF  -   testing derivative's value;
           Width-   width of verification segment.

        RESULT:
            If input derivatives is right then function returns true, else 
            function returns false.
            
          -- ALGLIB --
             Copyright 29.05.2012 by Bochkanov Sergey
        *************************************************************************/
        public static bool derivativecheck(double f0,
            double df0,
            double f1,
            double df1,
            double f,
            double df,
            double width)
        {
            bool result = new bool();
            double s = 0;
            double h = 0;
            double dh = 0;

            df = width*df;
            df0 = width*df0;
            df1 = width*df1;
            s = Math.Max(Math.Max(Math.Abs(df0), Math.Abs(df1)), Math.Abs(f1-f0));
            h = 0.5*f0+0.125*df0+0.5*f1-0.125*df1;
            dh = -(1.5*f0)-0.25*df0+1.5*f1-0.25*df1;
            if( (double)(s)!=(double)(0) )
            {
                if( (double)(Math.Abs(h-f)/s)>(double)(0.001) || (double)(Math.Abs(dh-df)/s)>(double)(0.001) )
                {
                    result = false;
                    return result;
                }
            }
            else
            {
                if( (double)(h-f)!=(double)(0.0) || (double)(dh-df)!=(double)(0.0) )
                {
                    result = false;
                    return result;
                }
            }
            result = true;
            return result;
        }


        /*************************************************************************
        Having quadratic target function

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        and its parabolic model along direction D

            F(x0+alpha*D) = D2*alpha^2 + D1*alpha
            
        this function estimates numerical errors in the coefficients of the model.
            
        It is important that this  function  does  NOT calculate D1/D2  -  it only
        estimates numerical errors introduced during evaluation and compares their
        magnitudes against magnitudes of numerical errors. As result, one of three
        outcomes is returned for each coefficient:
            * "true" coefficient is almost surely positive
            * "true" coefficient is almost surely negative
            * numerical errors in coefficient are so large that it can not be
              reliably distinguished from zero

        INPUT PARAMETERS:
            AbsASum -   SUM(|A[i,j]|)
            AbsASum2-   SUM(A[i,j]^2)
            MB      -   max(|B|)
            MX      -   max(|X|)
            MD      -   max(|D|)
            D1      -   linear coefficient
            D2      -   quadratic coefficient

        OUTPUT PARAMETERS:
            D1Est   -   estimate of D1 sign,  accounting  for  possible  numerical
                        errors:
                        * >0    means "almost surely positive" (D1>0 and large)
                        * <0    means "almost surely negative" (D1<0 and large)
                        * =0    means "pessimistic estimate  of  numerical  errors
                                in D1 is larger than magnitude of D1 itself; it is
                                impossible to reliably distinguish D1 from zero".
            D2Est   -   estimate of D2 sign,  accounting  for  possible  numerical
                        errors:
                        * >0    means "almost surely positive" (D2>0 and large)
                        * <0    means "almost surely negative" (D2<0 and large)
                        * =0    means "pessimistic estimate  of  numerical  errors
                                in D2 is larger than magnitude of D2 itself; it is
                                impossible to reliably distinguish D2 from zero".
                    
          -- ALGLIB --
             Copyright 14.05.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void estimateparabolicmodel(double absasum,
            double absasum2,
            double mx,
            double mb,
            double md,
            double d1,
            double d2,
            ref int d1est,
            ref int d2est)
        {
            double d1esterror = 0;
            double d2esterror = 0;
            double eps = 0;
            double e1 = 0;
            double e2 = 0;

            d1est = 0;
            d2est = 0;

            
            //
            // Error estimates:
            //
            // * error in D1=d'*(A*x+b) is estimated as
            //   ED1 = eps*MAX_ABS(D)*(MAX_ABS(X)*ENORM(A)+MAX_ABS(B))
            // * error in D2=0.5*d'*A*d is estimated as
            //   ED2 = eps*MAX_ABS(D)^2*ENORM(A)
            //
            // Here ENORM(A) is some pseudo-norm which reflects the way numerical
            // error accumulates during addition. Two ways of accumulation are
            // possible - worst case (errors always increase) and mean-case (errors
            // may cancel each other). We calculate geometrical average of both:
            // * ENORM_WORST(A) = SUM(|A[i,j]|)         error in N-term sum grows as O(N)
            // * ENORM_MEAN(A)  = SQRT(SUM(A[i,j]^2))   error in N-term sum grows as O(sqrt(N))
            // * ENORM(A)       = SQRT(ENORM_WORST(A),ENORM_MEAN(A))
            //
            eps = 4*math.machineepsilon;
            e1 = eps*md*(mx*absasum+mb);
            e2 = eps*md*(mx*Math.Sqrt(absasum2)+mb);
            d1esterror = Math.Sqrt(e1*e2);
            if( (double)(Math.Abs(d1))<=(double)(d1esterror) )
            {
                d1est = 0;
            }
            else
            {
                d1est = Math.Sign(d1);
            }
            e1 = eps*md*md*absasum;
            e2 = eps*md*md*Math.Sqrt(absasum2);
            d2esterror = Math.Sqrt(e1*e2);
            if( (double)(Math.Abs(d2))<=(double)(d2esterror) )
            {
                d2est = 0;
            }
            else
            {
                d2est = Math.Sign(d2);
            }
        }


        /*************************************************************************
        This function calculates inexact rank-K preconditioner for Hessian  matrix
        H=D+W'*C*W, where:
        * H is a Hessian matrix, which is approximated by D/W/C
        * D is a diagonal matrix with positive entries
        * W is a rank-K correction
        * C is a diagonal factor of rank-K correction

        This preconditioner is inexact but fast - it requires O(N*K)  time  to  be
        applied. Its main purpose - to be  used  in  barrier/penalty/AUL  methods,
        where ill-conditioning is created by combination of two factors:
        * simple bounds on variables => ill-conditioned D
        * general barrier/penalty => correction W  with large coefficient C (makes
          problem ill-conditioned) but W itself is well conditioned.

        Preconditioner P is calculated by artificially constructing a set of  BFGS
        updates which tries to reproduce behavior of H:
        * Sk = Wk (k-th row of W)
        * Yk = (D+Wk'*Ck*Wk)*Sk
        * Yk/Sk are reordered by ascending of C[k]*norm(Wk)^2

        Here we assume that rows of Wk are orthogonal or nearly orthogonal,  which
        allows us to have O(N*K+K^2) update instead of O(N*K^2) one. Reordering of
        updates is essential for having good performance on non-orthogonal problems
        (updates which do not add much of curvature are added first,  and  updates
        which add very large eigenvalues are added last and override effect of the
        first updates).

        On input this function takes direction S and components of H.
        On output it returns inv(H)*S

          -- ALGLIB --
             Copyright 30.06.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void inexactlbfgspreconditioner(double[] s,
            int n,
            double[] d,
            double[] c,
            double[,] w,
            int k,
            precbuflbfgs buf)
        {
            int idx = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            double v0 = 0;
            double v1 = 0;
            double vx = 0;
            double vy = 0;
            int i_ = 0;

            apserv.rvectorsetlengthatleast(ref buf.norms, k);
            apserv.rvectorsetlengthatleast(ref buf.alpha, k);
            apserv.rvectorsetlengthatleast(ref buf.rho, k);
            apserv.rmatrixsetlengthatleast(ref buf.yk, k, n);
            apserv.ivectorsetlengthatleast(ref buf.idx, k);
            
            //
            // Check inputs
            //
            for(i=0; i<=n-1; i++)
            {
                alglib.ap.assert((double)(d[i])>(double)(0), "InexactLBFGSPreconditioner: D[]<=0");
            }
            for(i=0; i<=k-1; i++)
            {
                alglib.ap.assert((double)(c[i])>=(double)(0), "InexactLBFGSPreconditioner: C[]<0");
            }
            
            //
            // Reorder linear terms according to increase of second derivative.
            // Fill Norms[] array.
            //
            for(idx=0; idx<=k-1; idx++)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += w[idx,i_]*w[idx,i_];
                }
                buf.norms[idx] = v*c[idx];
                buf.idx[idx] = idx;
            }
            tsort.tagsortfasti(ref buf.norms, ref buf.idx, ref buf.bufa, ref buf.bufb, k);
            
            //
            // Apply updates
            //
            for(idx=0; idx<=k-1; idx++)
            {
                
                //
                // Select update to perform (ordered by ascending of second derivative)
                //
                i = buf.idx[idx];
                
                //
                // Calculate YK and Rho
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += w[i,i_]*w[i,i_];
                }
                v = v*c[i];
                for(j=0; j<=n-1; j++)
                {
                    buf.yk[i,j] = (d[j]+v)*w[i,j];
                }
                v = 0.0;
                v0 = 0.0;
                v1 = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    vx = w[i,j];
                    vy = buf.yk[i,j];
                    v = v+vx*vy;
                    v0 = v0+vx*vx;
                    v1 = v1+vy*vy;
                }
                if( ((double)(v)>(double)(0) && (double)(v0*v1)>(double)(0)) && (double)(v/Math.Sqrt(v0*v1))>(double)(n*10*math.machineepsilon) )
                {
                    buf.rho[i] = 1/v;
                }
                else
                {
                    buf.rho[i] = 0.0;
                }
            }
            for(idx=k-1; idx>=0; idx--)
            {
                
                //
                // Select update to perform (ordered by ascending of second derivative)
                //
                i = buf.idx[idx];
                
                //
                // Calculate Alpha[] according to L-BFGS algorithm
                // and update S[]
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += w[i,i_]*s[i_];
                }
                v = buf.rho[i]*v;
                buf.alpha[i] = v;
                for(i_=0; i_<=n-1;i_++)
                {
                    s[i_] = s[i_] - v*buf.yk[i,i_];
                }
            }
            for(j=0; j<=n-1; j++)
            {
                s[j] = s[j]/d[j];
            }
            for(idx=0; idx<=k-1; idx++)
            {
                
                //
                // Select update to perform (ordered by ascending of second derivative)
                //
                i = buf.idx[idx];
                
                //
                // Calculate Beta according to L-BFGS algorithm
                // and update S[]
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += buf.yk[i,i_]*s[i_];
                }
                v = buf.alpha[i]-buf.rho[i]*v;
                for(i_=0; i_<=n-1;i_++)
                {
                    s[i_] = s[i_] + v*w[i,i_];
                }
            }
        }


        /*************************************************************************
        This function prepares exact low-rank preconditioner  for  Hessian  matrix
        H=D+W'*C*W, where:
        * H is a Hessian matrix, which is approximated by D/W/C
        * D is a diagonal matrix with positive entries
        * W is a rank-K correction
        * C is a diagonal factor of rank-K correction, positive semidefinite

        This preconditioner is exact but relatively slow -  it  requires  O(N*K^2)
        time to be prepared and O(N*K) time to be applied. It is  calculated  with
        the help of Woodbury matrix identity.

        It should be used as follows:
        * PrepareLowRankPreconditioner() call PREPARES data structure
        * subsequent calls to ApplyLowRankPreconditioner() APPLY preconditioner to
          user-specified search direction.

          -- ALGLIB --
             Copyright 30.06.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void preparelowrankpreconditioner(double[] d,
            double[] c,
            double[,] w,
            int n,
            int k,
            precbuflowrank buf)
        {
            int i = 0;
            int j = 0;
            double v = 0;
            bool b = new bool();

            
            //
            // Check inputs
            //
            alglib.ap.assert(n>0, "PrepareLowRankPreconditioner: N<=0");
            alglib.ap.assert(k>=0, "PrepareLowRankPreconditioner: N<=0");
            for(i=0; i<=n-1; i++)
            {
                alglib.ap.assert((double)(d[i])>(double)(0), "PrepareLowRankPreconditioner: D[]<=0");
            }
            for(i=0; i<=k-1; i++)
            {
                alglib.ap.assert((double)(c[i])>=(double)(0), "PrepareLowRankPreconditioner: C[]<0");
            }
            
            //
            // Prepare buffer structure; skip zero entries of update.
            //
            apserv.rvectorsetlengthatleast(ref buf.d, n);
            apserv.rmatrixsetlengthatleast(ref buf.v, k, n);
            apserv.rvectorsetlengthatleast(ref buf.bufc, k);
            apserv.rmatrixsetlengthatleast(ref buf.bufw, k+1, n);
            buf.n = n;
            buf.k = 0;
            for(i=0; i<=k-1; i++)
            {
                
                //
                // Estimate magnitude of update row; skip zero rows (either W or C are zero)
                //
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+w[i,j]*w[i,j];
                }
                v = v*c[i];
                if( (double)(v)==(double)(0) )
                {
                    continue;
                }
                alglib.ap.assert((double)(v)>(double)(0), "PrepareLowRankPreconditioner: internal error");
                
                //
                // Copy non-zero update to buffer
                //
                buf.bufc[buf.k] = c[i];
                for(j=0; j<=n-1; j++)
                {
                    buf.v[buf.k,j] = w[i,j];
                    buf.bufw[buf.k,j] = w[i,j];
                }
                apserv.inc(ref buf.k);
            }
            
            //
            // Reset K (for convenience)
            //
            k = buf.k;
            
            //
            // Prepare diagonal factor; quick exit for K=0
            //
            for(i=0; i<=n-1; i++)
            {
                buf.d[i] = 1/d[i];
            }
            if( k==0 )
            {
                return;
            }
            
            //
            // Use Woodbury matrix identity
            //
            apserv.rmatrixsetlengthatleast(ref buf.bufz, k, k);
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    buf.bufz[i,j] = 0.0;
                }
            }
            for(i=0; i<=k-1; i++)
            {
                buf.bufz[i,i] = 1/buf.bufc[i];
            }
            for(j=0; j<=n-1; j++)
            {
                buf.bufw[k,j] = 1/Math.Sqrt(d[j]);
            }
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    buf.bufw[i,j] = buf.bufw[i,j]*buf.bufw[k,j];
                }
            }
            ablas.rmatrixgemm(k, k, n, 1.0, buf.bufw, 0, 0, 0, buf.bufw, 0, 0, 1, 1.0, buf.bufz, 0, 0);
            b = trfac.spdmatrixcholeskyrec(ref buf.bufz, 0, k, true, ref buf.tmp);
            alglib.ap.assert(b, "PrepareLowRankPreconditioner: internal error (Cholesky failure)");
            ablas.rmatrixlefttrsm(k, n, buf.bufz, 0, 0, true, false, 1, buf.v, 0, 0);
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    buf.v[i,j] = buf.v[i,j]*buf.d[j];
                }
            }
        }


        /*************************************************************************
        This function apply exact low-rank preconditioner prepared by
        PrepareLowRankPreconditioner function (see its comments for more information).

          -- ALGLIB --
             Copyright 30.06.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void applylowrankpreconditioner(double[] s,
            precbuflowrank buf)
        {
            int n = 0;
            int k = 0;
            int i = 0;
            int j = 0;
            double v = 0;

            n = buf.n;
            k = buf.k;
            apserv.rvectorsetlengthatleast(ref buf.tmp, n);
            for(j=0; j<=n-1; j++)
            {
                buf.tmp[j] = buf.d[j]*s[j];
            }
            for(i=0; i<=k-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+buf.v[i,j]*s[j];
                }
                for(j=0; j<=n-1; j++)
                {
                    buf.tmp[j] = buf.tmp[j]-v*buf.v[i,j];
                }
            }
            for(i=0; i<=n-1; i++)
            {
                s[i] = buf.tmp[i];
            }
        }


    }
    public class cqmodels
    {
        /*************************************************************************
        This structure describes convex quadratic model of the form:
            f(x) = 0.5*(Alpha*x'*A*x + Tau*x'*D*x) + 0.5*Theta*(Q*x-r)'*(Q*x-r) + b'*x
        where:
            * Alpha>=0, Tau>=0, Theta>=0, Alpha+Tau>0.
            * A is NxN matrix, Q is NxK matrix (N>=1, K>=0), b is Nx1 vector,
              D is NxN diagonal matrix.
            * "main" quadratic term Alpha*A+Lambda*D is symmetric
              positive definite
        Structure may contain optional equality constraints of the form x[i]=x0[i],
        in this case functions provided by this unit calculate Newton step subject
        to these equality constraints.
        *************************************************************************/
        public class convexquadraticmodel : apobject
        {
            public int n;
            public int k;
            public double alpha;
            public double tau;
            public double theta;
            public double[,] a;
            public double[,] q;
            public double[] b;
            public double[] r;
            public double[] xc;
            public double[] d;
            public bool[] activeset;
            public double[,] tq2dense;
            public double[,] tk2;
            public double[] tq2diag;
            public double[] tq1;
            public double[] tk1;
            public double tq0;
            public double tk0;
            public double[] txc;
            public double[] tb;
            public int nfree;
            public int ecakind;
            public double[,] ecadense;
            public double[,] eq;
            public double[,] eccm;
            public double[] ecadiag;
            public double[] eb;
            public double ec;
            public double[] tmp0;
            public double[] tmp1;
            public double[] tmpg;
            public double[,] tmp2;
            public bool ismaintermchanged;
            public bool issecondarytermchanged;
            public bool islineartermchanged;
            public bool isactivesetchanged;
            public convexquadraticmodel()
            {
                init();
            }
            public override void init()
            {
                a = new double[0,0];
                q = new double[0,0];
                b = new double[0];
                r = new double[0];
                xc = new double[0];
                d = new double[0];
                activeset = new bool[0];
                tq2dense = new double[0,0];
                tk2 = new double[0,0];
                tq2diag = new double[0];
                tq1 = new double[0];
                tk1 = new double[0];
                txc = new double[0];
                tb = new double[0];
                ecadense = new double[0,0];
                eq = new double[0,0];
                eccm = new double[0,0];
                ecadiag = new double[0];
                eb = new double[0];
                tmp0 = new double[0];
                tmp1 = new double[0];
                tmpg = new double[0];
                tmp2 = new double[0,0];
            }
            public override alglib.apobject make_copy()
            {
                convexquadraticmodel _result = new convexquadraticmodel();
                _result.n = n;
                _result.k = k;
                _result.alpha = alpha;
                _result.tau = tau;
                _result.theta = theta;
                _result.a = (double[,])a.Clone();
                _result.q = (double[,])q.Clone();
                _result.b = (double[])b.Clone();
                _result.r = (double[])r.Clone();
                _result.xc = (double[])xc.Clone();
                _result.d = (double[])d.Clone();
                _result.activeset = (bool[])activeset.Clone();
                _result.tq2dense = (double[,])tq2dense.Clone();
                _result.tk2 = (double[,])tk2.Clone();
                _result.tq2diag = (double[])tq2diag.Clone();
                _result.tq1 = (double[])tq1.Clone();
                _result.tk1 = (double[])tk1.Clone();
                _result.tq0 = tq0;
                _result.tk0 = tk0;
                _result.txc = (double[])txc.Clone();
                _result.tb = (double[])tb.Clone();
                _result.nfree = nfree;
                _result.ecakind = ecakind;
                _result.ecadense = (double[,])ecadense.Clone();
                _result.eq = (double[,])eq.Clone();
                _result.eccm = (double[,])eccm.Clone();
                _result.ecadiag = (double[])ecadiag.Clone();
                _result.eb = (double[])eb.Clone();
                _result.ec = ec;
                _result.tmp0 = (double[])tmp0.Clone();
                _result.tmp1 = (double[])tmp1.Clone();
                _result.tmpg = (double[])tmpg.Clone();
                _result.tmp2 = (double[,])tmp2.Clone();
                _result.ismaintermchanged = ismaintermchanged;
                _result.issecondarytermchanged = issecondarytermchanged;
                _result.islineartermchanged = islineartermchanged;
                _result.isactivesetchanged = isactivesetchanged;
                return _result;
            }
        };




        public const int newtonrefinementits = 3;


        /*************************************************************************
        This subroutine is used to initialize CQM. By default, empty NxN model  is
        generated, with Alpha=Lambda=Theta=0.0 and zero b.

        Previously allocated buffer variables are reused as much as possible.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqminit(int n,
            convexquadraticmodel s)
        {
            int i = 0;

            s.n = n;
            s.k = 0;
            s.nfree = n;
            s.ecakind = -1;
            s.alpha = 0.0;
            s.tau = 0.0;
            s.theta = 0.0;
            s.ismaintermchanged = true;
            s.issecondarytermchanged = true;
            s.islineartermchanged = true;
            s.isactivesetchanged = true;
            apserv.bvectorsetlengthatleast(ref s.activeset, n);
            apserv.rvectorsetlengthatleast(ref s.xc, n);
            apserv.rvectorsetlengthatleast(ref s.eb, n);
            apserv.rvectorsetlengthatleast(ref s.tq1, n);
            apserv.rvectorsetlengthatleast(ref s.txc, n);
            apserv.rvectorsetlengthatleast(ref s.tb, n);
            apserv.rvectorsetlengthatleast(ref s.b, s.n);
            apserv.rvectorsetlengthatleast(ref s.tk1, s.n);
            for(i=0; i<=n-1; i++)
            {
                s.activeset[i] = false;
                s.xc[i] = 0.0;
                s.b[i] = 0.0;
            }
        }


        /*************************************************************************
        This subroutine changes main quadratic term of the model.

        INPUT PARAMETERS:
            S       -   model
            A       -   NxN matrix, only upper or lower triangle is referenced
            IsUpper -   True, when matrix is stored in upper triangle
            Alpha   -   multiplier; when Alpha=0, A is not referenced at all

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmseta(convexquadraticmodel s,
            double[,] a,
            bool isupper,
            double alpha)
        {
            int i = 0;
            int j = 0;
            double v = 0;

            alglib.ap.assert(math.isfinite(alpha) && (double)(alpha)>=(double)(0), "CQMSetA: Alpha<0 or is not finite number");
            alglib.ap.assert((double)(alpha)==(double)(0) || apserv.isfinitertrmatrix(a, s.n, isupper), "CQMSetA: A is not finite NxN matrix");
            s.alpha = alpha;
            if( (double)(alpha)>(double)(0) )
            {
                apserv.rmatrixsetlengthatleast(ref s.a, s.n, s.n);
                apserv.rmatrixsetlengthatleast(ref s.ecadense, s.n, s.n);
                apserv.rmatrixsetlengthatleast(ref s.tq2dense, s.n, s.n);
                for(i=0; i<=s.n-1; i++)
                {
                    for(j=i; j<=s.n-1; j++)
                    {
                        if( isupper )
                        {
                            v = a[i,j];
                        }
                        else
                        {
                            v = a[j,i];
                        }
                        s.a[i,j] = v;
                        s.a[j,i] = v;
                    }
                }
            }
            s.ismaintermchanged = true;
        }


        /*************************************************************************
        This subroutine changes main quadratic term of the model.

        INPUT PARAMETERS:
            S       -   model
            A       -   possibly preallocated buffer
            
        OUTPUT PARAMETERS:
            A       -   NxN matrix, full matrix is returned.
                        Zero matrix is returned if model is empty.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmgeta(convexquadraticmodel s,
            ref double[,] a)
        {
            int i = 0;
            int j = 0;
            double v = 0;
            int n = 0;

            n = s.n;
            apserv.rmatrixsetlengthatleast(ref a, n, n);
            if( (double)(s.alpha)>(double)(0) )
            {
                v = s.alpha;
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a[i,j] = v*s.a[i,j];
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a[i,j] = 0.0;
                    }
                }
            }
        }


        /*************************************************************************
        This subroutine rewrites diagonal of the main quadratic term of the  model
        (dense  A)  by  vector  Z/Alpha (current value of the Alpha coefficient is
        used).

        IMPORTANT: in  case  model  has  no  dense  quadratic  term, this function
                   allocates N*N dense matrix of zeros, and fills its diagonal  by
                   non-zero values.

        INPUT PARAMETERS:
            S       -   model
            Z       -   new diagonal, array[N]

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmrewritedensediagonal(convexquadraticmodel s,
            double[] z)
        {
            int n = 0;
            int i = 0;
            int j = 0;

            n = s.n;
            if( (double)(s.alpha)==(double)(0) )
            {
                apserv.rmatrixsetlengthatleast(ref s.a, s.n, s.n);
                apserv.rmatrixsetlengthatleast(ref s.ecadense, s.n, s.n);
                apserv.rmatrixsetlengthatleast(ref s.tq2dense, s.n, s.n);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        s.a[i,j] = 0.0;
                    }
                }
                s.alpha = 1.0;
            }
            for(i=0; i<=s.n-1; i++)
            {
                s.a[i,i] = z[i]/s.alpha;
            }
            s.ismaintermchanged = true;
        }


        /*************************************************************************
        This subroutine changes diagonal quadratic term of the model.

        INPUT PARAMETERS:
            S       -   model
            D       -   array[N], semidefinite diagonal matrix
            Tau     -   multiplier; when Tau=0, D is not referenced at all

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmsetd(convexquadraticmodel s,
            double[] d,
            double tau)
        {
            int i = 0;

            alglib.ap.assert(math.isfinite(tau) && (double)(tau)>=(double)(0), "CQMSetD: Tau<0 or is not finite number");
            alglib.ap.assert((double)(tau)==(double)(0) || apserv.isfinitevector(d, s.n), "CQMSetD: D is not finite Nx1 vector");
            s.tau = tau;
            if( (double)(tau)>(double)(0) )
            {
                apserv.rvectorsetlengthatleast(ref s.d, s.n);
                apserv.rvectorsetlengthatleast(ref s.ecadiag, s.n);
                apserv.rvectorsetlengthatleast(ref s.tq2diag, s.n);
                for(i=0; i<=s.n-1; i++)
                {
                    alglib.ap.assert((double)(d[i])>=(double)(0), "CQMSetD: D[i]<0");
                    s.d[i] = d[i];
                }
            }
            s.ismaintermchanged = true;
        }


        /*************************************************************************
        This subroutine drops main quadratic term A from the model. It is same  as
        call  to  CQMSetA()  with  zero  A,   but gives better performance because
        algorithm  knows  that  matrix  is  zero  and  can  optimize    subsequent
        calculations.

        INPUT PARAMETERS:
            S       -   model

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmdropa(convexquadraticmodel s)
        {
            s.alpha = 0.0;
            s.ismaintermchanged = true;
        }


        /*************************************************************************
        This subroutine changes linear term of the model

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmsetb(convexquadraticmodel s,
            double[] b)
        {
            int i = 0;

            alglib.ap.assert(apserv.isfinitevector(b, s.n), "CQMSetB: B is not finite vector");
            apserv.rvectorsetlengthatleast(ref s.b, s.n);
            for(i=0; i<=s.n-1; i++)
            {
                s.b[i] = b[i];
            }
            s.islineartermchanged = true;
        }


        /*************************************************************************
        This subroutine changes linear term of the model

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmsetq(convexquadraticmodel s,
            double[,] q,
            double[] r,
            int k,
            double theta)
        {
            int i = 0;
            int j = 0;

            alglib.ap.assert(k>=0, "CQMSetQ: K<0");
            alglib.ap.assert((k==0 || (double)(theta)==(double)(0)) || apserv.apservisfinitematrix(q, k, s.n), "CQMSetQ: Q is not finite matrix");
            alglib.ap.assert((k==0 || (double)(theta)==(double)(0)) || apserv.isfinitevector(r, k), "CQMSetQ: R is not finite vector");
            alglib.ap.assert(math.isfinite(theta) && (double)(theta)>=(double)(0), "CQMSetQ: Theta<0 or is not finite number");
            
            //
            // degenerate case: K=0 or Theta=0
            //
            if( k==0 || (double)(theta)==(double)(0) )
            {
                s.k = 0;
                s.theta = 0;
                s.issecondarytermchanged = true;
                return;
            }
            
            //
            // General case: both Theta>0 and K>0
            //
            s.k = k;
            s.theta = theta;
            apserv.rmatrixsetlengthatleast(ref s.q, s.k, s.n);
            apserv.rvectorsetlengthatleast(ref s.r, s.k);
            apserv.rmatrixsetlengthatleast(ref s.eq, s.k, s.n);
            apserv.rmatrixsetlengthatleast(ref s.eccm, s.k, s.k);
            apserv.rmatrixsetlengthatleast(ref s.tk2, s.k, s.n);
            for(i=0; i<=s.k-1; i++)
            {
                for(j=0; j<=s.n-1; j++)
                {
                    s.q[i,j] = q[i,j];
                }
                s.r[i] = r[i];
            }
            s.issecondarytermchanged = true;
        }


        /*************************************************************************
        This subroutine changes active set

        INPUT PARAMETERS
            S       -   model
            X       -   array[N], constraint values
            ActiveSet-  array[N], active set. If ActiveSet[I]=True, then I-th
                        variables is constrained to X[I].

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmsetactiveset(convexquadraticmodel s,
            double[] x,
            bool[] activeset)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(x)>=s.n, "CQMSetActiveSet: Length(X)<N");
            alglib.ap.assert(alglib.ap.len(activeset)>=s.n, "CQMSetActiveSet: Length(ActiveSet)<N");
            for(i=0; i<=s.n-1; i++)
            {
                s.isactivesetchanged = s.isactivesetchanged || (s.activeset[i] && !activeset[i]);
                s.isactivesetchanged = s.isactivesetchanged || (activeset[i] && !s.activeset[i]);
                s.activeset[i] = activeset[i];
                if( activeset[i] )
                {
                    alglib.ap.assert(math.isfinite(x[i]), "CQMSetActiveSet: X[] contains infinite constraints");
                    s.isactivesetchanged = s.isactivesetchanged || (double)(s.xc[i])!=(double)(x[i]);
                    s.xc[i] = x[i];
                }
            }
        }


        /*************************************************************************
        This subroutine evaluates model at X. Active constraints are ignored.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static double cqmeval(convexquadraticmodel s,
            double[] x)
        {
            double result = 0;
            int n = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMEval: X is not finite vector");
            result = 0.0;
            
            //
            // main quadratic term
            //
            if( (double)(s.alpha)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        result = result+s.alpha*0.5*x[i]*s.a[i,j]*x[j];
                    }
                }
            }
            if( (double)(s.tau)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    result = result+0.5*math.sqr(x[i])*s.tau*s.d[i];
                }
            }
            
            //
            // secondary quadratic term
            //
            if( (double)(s.theta)>(double)(0) )
            {
                for(i=0; i<=s.k-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += s.q[i,i_]*x[i_];
                    }
                    result = result+0.5*s.theta*math.sqr(v-s.r[i]);
                }
            }
            
            //
            // linear term
            //
            for(i=0; i<=s.n-1; i++)
            {
                result = result+x[i]*s.b[i];
            }
            return result;
        }


        /*************************************************************************
        This subroutine evaluates model at X. Active constraints are ignored.
        It returns:
            R   -   model value
            Noise-  estimate of the numerical noise in data

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmevalx(convexquadraticmodel s,
            double[] x,
            ref double r,
            ref double noise)
        {
            int n = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            double v2 = 0;
            double mxq = 0;
            double eps = 0;

            r = 0;
            noise = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMEval: X is not finite vector");
            r = 0.0;
            noise = 0.0;
            eps = 2*math.machineepsilon;
            mxq = 0.0;
            
            //
            // Main quadratic term.
            //
            // Noise from the main quadratic term is equal to the
            // maximum summand in the term.
            //
            if( (double)(s.alpha)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        v = s.alpha*0.5*x[i]*s.a[i,j]*x[j];
                        r = r+v;
                        noise = Math.Max(noise, eps*Math.Abs(v));
                    }
                }
            }
            if( (double)(s.tau)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    v = 0.5*math.sqr(x[i])*s.tau*s.d[i];
                    r = r+v;
                    noise = Math.Max(noise, eps*Math.Abs(v));
                }
            }
            
            //
            // secondary quadratic term
            //
            // Noise from the secondary quadratic term is estimated as follows:
            // * noise in qi*x-r[i] is estimated as
            //   Eps*MXQ = Eps*max(|r[i]|, |q[i,j]*x[j]|)
            // * noise in (qi*x-r[i])^2 is estimated as
            //   NOISE = (|qi*x-r[i]|+Eps*MXQ)^2-(|qi*x-r[i]|)^2
            //         = Eps*MXQ*(2*|qi*x-r[i]|+Eps*MXQ)
            //
            if( (double)(s.theta)>(double)(0) )
            {
                for(i=0; i<=s.k-1; i++)
                {
                    v = 0.0;
                    mxq = Math.Abs(s.r[i]);
                    for(j=0; j<=n-1; j++)
                    {
                        v2 = s.q[i,j]*x[j];
                        v = v+v2;
                        mxq = Math.Max(mxq, Math.Abs(v2));
                    }
                    r = r+0.5*s.theta*math.sqr(v-s.r[i]);
                    noise = Math.Max(noise, eps*mxq*(2*Math.Abs(v-s.r[i])+eps*mxq));
                }
            }
            
            //
            // linear term
            //
            for(i=0; i<=s.n-1; i++)
            {
                r = r+x[i]*s.b[i];
                noise = Math.Max(noise, eps*Math.Abs(x[i]*s.b[i]));
            }
            
            //
            // Final update of the noise
            //
            noise = n*noise;
        }


        /*************************************************************************
        This  subroutine  evaluates  gradient of the model; active constraints are
        ignored.

        INPUT PARAMETERS:
            S       -   convex model
            X       -   point, array[N]
            G       -   possibly preallocated buffer; resized, if too small

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmgradunconstrained(convexquadraticmodel s,
            double[] x,
            ref double[] g)
        {
            int n = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMEvalGradUnconstrained: X is not finite vector");
            apserv.rvectorsetlengthatleast(ref g, n);
            for(i=0; i<=n-1; i++)
            {
                g[i] = 0;
            }
            
            //
            // main quadratic term
            //
            if( (double)(s.alpha)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    v = 0.0;
                    for(j=0; j<=n-1; j++)
                    {
                        v = v+s.alpha*s.a[i,j]*x[j];
                    }
                    g[i] = g[i]+v;
                }
            }
            if( (double)(s.tau)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    g[i] = g[i]+x[i]*s.tau*s.d[i];
                }
            }
            
            //
            // secondary quadratic term
            //
            if( (double)(s.theta)>(double)(0) )
            {
                for(i=0; i<=s.k-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += s.q[i,i_]*x[i_];
                    }
                    v = s.theta*(v-s.r[i]);
                    for(i_=0; i_<=n-1;i_++)
                    {
                        g[i_] = g[i_] + v*s.q[i,i_];
                    }
                }
            }
            
            //
            // linear term
            //
            for(i=0; i<=n-1; i++)
            {
                g[i] = g[i]+s.b[i];
            }
        }


        /*************************************************************************
        This subroutine evaluates x'*(0.5*alpha*A+tau*D)*x

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static double cqmxtadx2(convexquadraticmodel s,
            double[] x)
        {
            double result = 0;
            int n = 0;
            int i = 0;
            int j = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMEval: X is not finite vector");
            result = 0.0;
            
            //
            // main quadratic term
            //
            if( (double)(s.alpha)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        result = result+s.alpha*0.5*x[i]*s.a[i,j]*x[j];
                    }
                }
            }
            if( (double)(s.tau)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    result = result+0.5*math.sqr(x[i])*s.tau*s.d[i];
                }
            }
            return result;
        }


        /*************************************************************************
        This subroutine evaluates (0.5*alpha*A+tau*D)*x

        Y is automatically resized if needed

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmadx(convexquadraticmodel s,
            double[] x,
            ref double[] y)
        {
            int n = 0;
            int i = 0;
            double v = 0;
            int i_ = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMEval: X is not finite vector");
            apserv.rvectorsetlengthatleast(ref y, n);
            
            //
            // main quadratic term
            //
            for(i=0; i<=n-1; i++)
            {
                y[i] = 0;
            }
            if( (double)(s.alpha)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += s.a[i,i_]*x[i_];
                    }
                    y[i] = y[i]+s.alpha*v;
                }
            }
            if( (double)(s.tau)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    y[i] = y[i]+x[i]*s.tau*s.d[i];
                }
            }
        }


        /*************************************************************************
        This subroutine finds optimum of the model. It returns  False  on  failure
        (indefinite/semidefinite matrix).  Optimum  is  found  subject  to  active
        constraints.

        INPUT PARAMETERS
            S       -   model
            X       -   possibly preallocated buffer; automatically resized, if
                        too small enough.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static bool cqmconstrainedoptimum(convexquadraticmodel s,
            ref double[] x)
        {
            bool result = new bool();
            int n = 0;
            int nfree = 0;
            int k = 0;
            int i = 0;
            double v = 0;
            int cidx0 = 0;
            int itidx = 0;
            int i_ = 0;

            
            //
            // Rebuild internal structures
            //
            if( !cqmrebuild(s) )
            {
                result = false;
                return result;
            }
            n = s.n;
            k = s.k;
            nfree = s.nfree;
            result = true;
            
            //
            // Calculate initial point for the iterative refinement:
            // * free components are set to zero
            // * constrained components are set to their constrained values
            //
            apserv.rvectorsetlengthatleast(ref x, n);
            for(i=0; i<=n-1; i++)
            {
                if( s.activeset[i] )
                {
                    x[i] = s.xc[i];
                }
                else
                {
                    x[i] = 0;
                }
            }
            
            //
            // Iterative refinement.
            //
            // In an ideal world without numerical errors it would be enough
            // to make just one Newton step from initial point:
            //   x_new = -H^(-1)*grad(x=0)
            // However, roundoff errors can significantly deteriorate quality
            // of the solution. So we have to recalculate gradient and to
            // perform Newton steps several times.
            //
            // Below we perform fixed number of Newton iterations.
            //
            for(itidx=0; itidx<=newtonrefinementits-1; itidx++)
            {
                
                //
                // Calculate gradient at the current point.
                // Move free components of the gradient in the beginning.
                //
                cqmgradunconstrained(s, x, ref s.tmpg);
                cidx0 = 0;
                for(i=0; i<=n-1; i++)
                {
                    if( !s.activeset[i] )
                    {
                        s.tmpg[cidx0] = s.tmpg[i];
                        cidx0 = cidx0+1;
                    }
                }
                
                //
                // Free components of the extrema are calculated in the first NFree elements of TXC.
                //
                // First, we have to calculate original Newton step, without rank-K perturbations
                //
                for(i_=0; i_<=nfree-1;i_++)
                {
                    s.txc[i_] = -s.tmpg[i_];
                }
                cqmsolveea(s, ref s.txc, ref s.tmp0);
                
                //
                // Then, we account for rank-K correction.
                // Woodbury matrix identity is used.
                //
                if( s.k>0 && (double)(s.theta)>(double)(0) )
                {
                    apserv.rvectorsetlengthatleast(ref s.tmp0, Math.Max(nfree, k));
                    apserv.rvectorsetlengthatleast(ref s.tmp1, Math.Max(nfree, k));
                    for(i_=0; i_<=nfree-1;i_++)
                    {
                        s.tmp1[i_] = -s.tmpg[i_];
                    }
                    cqmsolveea(s, ref s.tmp1, ref s.tmp0);
                    for(i=0; i<=k-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=nfree-1;i_++)
                        {
                            v += s.eq[i,i_]*s.tmp1[i_];
                        }
                        s.tmp0[i] = v;
                    }
                    fbls.fblscholeskysolve(s.eccm, 1.0, k, true, s.tmp0, ref s.tmp1);
                    for(i=0; i<=nfree-1; i++)
                    {
                        s.tmp1[i] = 0.0;
                    }
                    for(i=0; i<=k-1; i++)
                    {
                        v = s.tmp0[i];
                        for(i_=0; i_<=nfree-1;i_++)
                        {
                            s.tmp1[i_] = s.tmp1[i_] + v*s.eq[i,i_];
                        }
                    }
                    cqmsolveea(s, ref s.tmp1, ref s.tmp0);
                    for(i_=0; i_<=nfree-1;i_++)
                    {
                        s.txc[i_] = s.txc[i_] - s.tmp1[i_];
                    }
                }
                
                //
                // Unpack components from TXC into X. We pass through all
                // free components of X and add our step.
                //
                cidx0 = 0;
                for(i=0; i<=n-1; i++)
                {
                    if( !s.activeset[i] )
                    {
                        x[i] = x[i]+s.txc[cidx0];
                        cidx0 = cidx0+1;
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        This function scales vector  by  multiplying it by inverse of the diagonal
        of the Hessian matrix. It should be used to  accelerate  steepest  descent
        phase of the QP solver.

        Although  it  is  called  "scale-grad",  it  can be called for any vector,
        whether it is gradient, anti-gradient, or just some vector.

        This function does NOT takes into account current set of  constraints,  it
        just performs matrix-vector multiplication  without  taking  into  account
        constraints.

        INPUT PARAMETERS:
            S       -   model
            X       -   vector to scale

        OUTPUT PARAMETERS:
            X       -   scaled vector
            
        NOTE:
            when called for non-SPD matrices, it silently skips components of X
            which correspond to zero or negative diagonal elements.
            
        NOTE:
            this function uses diagonals of A and D; it ignores Q - rank-K term of
            the quadratic model.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void cqmscalevector(convexquadraticmodel s,
            ref double[] x)
        {
            int n = 0;
            int i = 0;
            double v = 0;

            n = s.n;
            for(i=0; i<=n-1; i++)
            {
                v = 0.0;
                if( (double)(s.alpha)>(double)(0) )
                {
                    v = v+s.a[i,i];
                }
                if( (double)(s.tau)>(double)(0) )
                {
                    v = v+s.d[i];
                }
                if( (double)(v)>(double)(0) )
                {
                    x[i] = x[i]/v;
                }
            }
        }


        /*************************************************************************
        This subroutine calls CQMRebuild() and evaluates model at X subject to
        active constraints.

        It  is  intended  for  debug  purposes only, because it evaluates model by
        means of temporaries, which were calculated  by  CQMRebuild().  The   only
        purpose of this function  is  to  check  correctness  of  CQMRebuild()  by
        comparing results of this function with ones obtained by CQMEval(),  which
        is  used  as  reference  point. The  idea is that significant deviation in
        results  of  these  two  functions  is  evidence  of  some  error  in  the
        CQMRebuild().

        NOTE: suffix T denotes that temporaries marked by T-prefix are used. There
              is one more variant of this function, which uses  "effective"  model
              built by CQMRebuild().

        NOTE2: in case CQMRebuild() fails (due to model non-convexity), this
              function returns NAN.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static double cqmdebugconstrainedevalt(convexquadraticmodel s,
            double[] x)
        {
            double result = 0;
            int n = 0;
            int nfree = 0;
            int i = 0;
            int j = 0;
            double v = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMDebugConstrainedEvalT: X is not finite vector");
            if( !cqmrebuild(s) )
            {
                result = Double.NaN;
                return result;
            }
            result = 0.0;
            nfree = s.nfree;
            
            //
            // Reorder variables
            //
            j = 0;
            for(i=0; i<=n-1; i++)
            {
                if( !s.activeset[i] )
                {
                    alglib.ap.assert(j<nfree, "CQMDebugConstrainedEvalT: internal error");
                    s.txc[j] = x[i];
                    j = j+1;
                }
            }
            
            //
            // TQ2, TQ1, TQ0
            //
            //
            if( (double)(s.alpha)>(double)(0) )
            {
                
                //
                // Dense TQ2
                //
                for(i=0; i<=nfree-1; i++)
                {
                    for(j=0; j<=nfree-1; j++)
                    {
                        result = result+0.5*s.txc[i]*s.tq2dense[i,j]*s.txc[j];
                    }
                }
            }
            else
            {
                
                //
                // Diagonal TQ2
                //
                for(i=0; i<=nfree-1; i++)
                {
                    result = result+0.5*s.tq2diag[i]*math.sqr(s.txc[i]);
                }
            }
            for(i=0; i<=nfree-1; i++)
            {
                result = result+s.tq1[i]*s.txc[i];
            }
            result = result+s.tq0;
            
            //
            // TK2, TK1, TK0
            //
            if( s.k>0 && (double)(s.theta)>(double)(0) )
            {
                for(i=0; i<=s.k-1; i++)
                {
                    v = 0;
                    for(j=0; j<=nfree-1; j++)
                    {
                        v = v+s.tk2[i,j]*s.txc[j];
                    }
                    result = result+0.5*math.sqr(v);
                }
                for(i=0; i<=nfree-1; i++)
                {
                    result = result+s.tk1[i]*s.txc[i];
                }
                result = result+s.tk0;
            }
            
            //
            // TB (Bf and Bc parts)
            //
            for(i=0; i<=n-1; i++)
            {
                result = result+s.tb[i]*s.txc[i];
            }
            return result;
        }


        /*************************************************************************
        This subroutine calls CQMRebuild() and evaluates model at X subject to
        active constraints.

        It  is  intended  for  debug  purposes only, because it evaluates model by
        means of "effective" matrices built by CQMRebuild(). The only  purpose  of
        this function is to check correctness of CQMRebuild() by comparing results
        of this function with  ones  obtained  by  CQMEval(),  which  is  used  as
        reference  point.  The  idea  is  that significant deviation in results of
        these two functions is evidence of some error in the CQMRebuild().

        NOTE: suffix E denotes that effective matrices. There is one more  variant
              of this function, which uses temporary matrices built by
              CQMRebuild().

        NOTE2: in case CQMRebuild() fails (due to model non-convexity), this
              function returns NAN.

          -- ALGLIB --
             Copyright 12.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static double cqmdebugconstrainedevale(convexquadraticmodel s,
            double[] x)
        {
            double result = 0;
            int n = 0;
            int nfree = 0;
            int i = 0;
            int j = 0;
            double v = 0;

            n = s.n;
            alglib.ap.assert(apserv.isfinitevector(x, n), "CQMDebugConstrainedEvalE: X is not finite vector");
            if( !cqmrebuild(s) )
            {
                result = Double.NaN;
                return result;
            }
            result = 0.0;
            nfree = s.nfree;
            
            //
            // Reorder variables
            //
            j = 0;
            for(i=0; i<=n-1; i++)
            {
                if( !s.activeset[i] )
                {
                    alglib.ap.assert(j<nfree, "CQMDebugConstrainedEvalE: internal error");
                    s.txc[j] = x[i];
                    j = j+1;
                }
            }
            
            //
            // ECA
            //
            alglib.ap.assert((s.ecakind==0 || s.ecakind==1) || (s.ecakind==-1 && nfree==0), "CQMDebugConstrainedEvalE: unexpected ECAKind");
            if( s.ecakind==0 )
            {
                
                //
                // Dense ECA
                //
                for(i=0; i<=nfree-1; i++)
                {
                    v = 0.0;
                    for(j=i; j<=nfree-1; j++)
                    {
                        v = v+s.ecadense[i,j]*s.txc[j];
                    }
                    result = result+0.5*math.sqr(v);
                }
            }
            if( s.ecakind==1 )
            {
                
                //
                // Diagonal ECA
                //
                for(i=0; i<=nfree-1; i++)
                {
                    result = result+0.5*math.sqr(s.ecadiag[i]*s.txc[i]);
                }
            }
            
            //
            // EQ
            //
            for(i=0; i<=s.k-1; i++)
            {
                v = 0.0;
                for(j=0; j<=nfree-1; j++)
                {
                    v = v+s.eq[i,j]*s.txc[j];
                }
                result = result+0.5*math.sqr(v);
            }
            
            //
            // EB
            //
            for(i=0; i<=nfree-1; i++)
            {
                result = result+s.eb[i]*s.txc[i];
            }
            
            //
            // EC
            //
            result = result+s.ec;
            return result;
        }


        /*************************************************************************
        Internal function, rebuilds "effective" model subject to constraints.
        Returns False on failure (non-SPD main quadratic term)

          -- ALGLIB --
             Copyright 10.05.2011 by Bochkanov Sergey
        *************************************************************************/
        private static bool cqmrebuild(convexquadraticmodel s)
        {
            bool result = new bool();
            int n = 0;
            int nfree = 0;
            int k = 0;
            int i = 0;
            int j = 0;
            int ridx0 = 0;
            int ridx1 = 0;
            int cidx0 = 0;
            int cidx1 = 0;
            double v = 0;
            int i_ = 0;

            if( (double)(s.alpha)==(double)(0) && (double)(s.tau)==(double)(0) )
            {
                
                //
                // Non-SPD model, quick exit
                //
                result = false;
                return result;
            }
            result = true;
            n = s.n;
            k = s.k;
            
            //
            // Determine number of free variables.
            // Fill TXC - array whose last N-NFree elements store constraints.
            //
            if( s.isactivesetchanged )
            {
                s.nfree = 0;
                for(i=0; i<=n-1; i++)
                {
                    if( !s.activeset[i] )
                    {
                        s.nfree = s.nfree+1;
                    }
                }
                j = s.nfree;
                for(i=0; i<=n-1; i++)
                {
                    if( s.activeset[i] )
                    {
                        s.txc[j] = s.xc[i];
                        j = j+1;
                    }
                }
            }
            nfree = s.nfree;
            
            //
            // Re-evaluate TQ2/TQ1/TQ0, if needed
            //
            if( s.isactivesetchanged || s.ismaintermchanged )
            {
                
                //
                // Handle cases Alpha>0 and Alpha=0 separately:
                // * in the first case we have dense matrix
                // * in the second one we have diagonal matrix, which can be
                //   handled more efficiently
                //
                if( (double)(s.alpha)>(double)(0) )
                {
                    
                    //
                    // Alpha>0, dense QP
                    //
                    // Split variables into two groups - free (F) and constrained (C). Reorder
                    // variables in such way that free vars come first, constrained are last:
                    // x = [xf, xc].
                    // 
                    // Main quadratic term x'*(alpha*A+tau*D)*x now splits into quadratic part,
                    // linear part and constant part:
                    //                   ( alpha*Aff+tau*Df  alpha*Afc        ) ( xf )              
                    //   0.5*( xf' xc' )*(                                    )*(    ) =
                    //                   ( alpha*Acf         alpha*Acc+tau*Dc ) ( xc )
                    //
                    //   = 0.5*xf'*(alpha*Aff+tau*Df)*xf + (alpha*Afc*xc)'*xf + 0.5*xc'(alpha*Acc+tau*Dc)*xc
                    //                    
                    // We store these parts into temporary variables:
                    // * alpha*Aff+tau*Df, alpha*Afc, alpha*Acc+tau*Dc are stored into upper
                    //   triangle of TQ2
                    // * alpha*Afc*xc is stored into TQ1
                    // * 0.5*xc'(alpha*Acc+tau*Dc)*xc is stored into TQ0
                    //
                    // Below comes first part of the work - generation of TQ2:
                    // * we pass through rows of A and copy I-th row into upper block (Aff/Afc) or
                    //   lower one (Acf/Acc) of TQ2, depending on presence of X[i] in the active set.
                    //   RIdx0 variable contains current position for insertion into upper block,
                    //   RIdx1 contains current position for insertion into lower one.
                    // * within each row, we copy J-th element into left half (Aff/Acf) or right
                    //   one (Afc/Acc), depending on presence of X[j] in the active set. CIdx0
                    //   contains current position for insertion into left block, CIdx1 contains
                    //   position for insertion into right one.
                    // * during copying, we multiply elements by alpha and add diagonal matrix D.
                    //
                    ridx0 = 0;
                    ridx1 = s.nfree;
                    for(i=0; i<=n-1; i++)
                    {
                        cidx0 = 0;
                        cidx1 = s.nfree;
                        for(j=0; j<=n-1; j++)
                        {
                            if( !s.activeset[i] && !s.activeset[j] )
                            {
                                
                                //
                                // Element belongs to Aff
                                //
                                v = s.alpha*s.a[i,j];
                                if( i==j && (double)(s.tau)>(double)(0) )
                                {
                                    v = v+s.tau*s.d[i];
                                }
                                s.tq2dense[ridx0,cidx0] = v;
                            }
                            if( !s.activeset[i] && s.activeset[j] )
                            {
                                
                                //
                                // Element belongs to Afc
                                //
                                s.tq2dense[ridx0,cidx1] = s.alpha*s.a[i,j];
                            }
                            if( s.activeset[i] && !s.activeset[j] )
                            {
                                
                                //
                                // Element belongs to Acf
                                //
                                s.tq2dense[ridx1,cidx0] = s.alpha*s.a[i,j];
                            }
                            if( s.activeset[i] && s.activeset[j] )
                            {
                                
                                //
                                // Element belongs to Acc
                                //
                                v = s.alpha*s.a[i,j];
                                if( i==j && (double)(s.tau)>(double)(0) )
                                {
                                    v = v+s.tau*s.d[i];
                                }
                                s.tq2dense[ridx1,cidx1] = v;
                            }
                            if( s.activeset[j] )
                            {
                                cidx1 = cidx1+1;
                            }
                            else
                            {
                                cidx0 = cidx0+1;
                            }
                        }
                        if( s.activeset[i] )
                        {
                            ridx1 = ridx1+1;
                        }
                        else
                        {
                            ridx0 = ridx0+1;
                        }
                    }
                    
                    //
                    // Now we have TQ2, and we can evaluate TQ1.
                    // In the special case when we have Alpha=0, NFree=0 or NFree=N,
                    // TQ1 is filled by zeros.
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        s.tq1[i] = 0.0;
                    }
                    if( s.nfree>0 && s.nfree<n )
                    {
                        ablas.rmatrixmv(s.nfree, n-s.nfree, s.tq2dense, 0, s.nfree, 0, s.txc, s.nfree, ref s.tq1, 0);
                    }
                    
                    //
                    // And finally, we evaluate TQ0.
                    //
                    v = 0.0;
                    for(i=s.nfree; i<=n-1; i++)
                    {
                        for(j=s.nfree; j<=n-1; j++)
                        {
                            v = v+0.5*s.txc[i]*s.tq2dense[i,j]*s.txc[j];
                        }
                    }
                    s.tq0 = v;
                }
                else
                {
                    
                    //
                    // Alpha=0, diagonal QP
                    //
                    // Split variables into two groups - free (F) and constrained (C). Reorder
                    // variables in such way that free vars come first, constrained are last:
                    // x = [xf, xc].
                    // 
                    // Main quadratic term x'*(tau*D)*x now splits into quadratic and constant
                    // parts:
                    //                   ( tau*Df        ) ( xf )              
                    //   0.5*( xf' xc' )*(               )*(    ) =
                    //                   (        tau*Dc ) ( xc )
                    //
                    //   = 0.5*xf'*(tau*Df)*xf + 0.5*xc'(tau*Dc)*xc
                    //                    
                    // We store these parts into temporary variables:
                    // * tau*Df is stored in TQ2Diag
                    // * 0.5*xc'(tau*Dc)*xc is stored into TQ0
                    //
                    s.tq0 = 0.0;
                    ridx0 = 0;
                    for(i=0; i<=n-1; i++)
                    {
                        if( !s.activeset[i] )
                        {
                            s.tq2diag[ridx0] = s.tau*s.d[i];
                            ridx0 = ridx0+1;
                        }
                        else
                        {
                            s.tq0 = s.tq0+0.5*s.tau*s.d[i]*math.sqr(s.xc[i]);
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        s.tq1[i] = 0.0;
                    }
                }
            }
            
            //
            // Re-evaluate TK2/TK1/TK0, if needed
            //
            if( s.isactivesetchanged || s.issecondarytermchanged )
            {
                
                //
                // Split variables into two groups - free (F) and constrained (C). Reorder
                // variables in such way that free vars come first, constrained are last:
                // x = [xf, xc].
                // 
                // Secondary term theta*(Q*x-r)'*(Q*x-r) now splits into quadratic part,
                // linear part and constant part:
                //             (          ( xf )     )'  (          ( xf )     )
                //   0.5*theta*( (Qf Qc)'*(    ) - r ) * ( (Qf Qc)'*(    ) - r ) =
                //             (          ( xc )     )   (          ( xc )     )
                //
                //   = 0.5*theta*xf'*(Qf'*Qf)*xf + theta*((Qc*xc-r)'*Qf)*xf + 
                //     + theta*(-r'*(Qc*xc-r)-0.5*r'*r+0.5*xc'*Qc'*Qc*xc)
                //                    
                // We store these parts into temporary variables:
                // * sqrt(theta)*Qf is stored into TK2
                // * theta*((Qc*xc-r)'*Qf) is stored into TK1
                // * theta*(-r'*(Qc*xc-r)-0.5*r'*r+0.5*xc'*Qc'*Qc*xc) is stored into TK0
                //
                // We use several other temporaries to store intermediate results:
                // * Tmp0 - to store Qc*xc-r
                // * Tmp1 - to store Qc*xc
                //
                // Generation of TK2/TK1/TK0 is performed as follows:
                // * we fill TK2/TK1/TK0 (to handle K=0 or Theta=0)
                // * other steps are performed only for K>0 and Theta>0
                // * we pass through columns of Q and copy I-th column into left block (Qf) or
                //   right one (Qc) of TK2, depending on presence of X[i] in the active set.
                //   CIdx0 variable contains current position for insertion into upper block,
                //   CIdx1 contains current position for insertion into lower one.
                // * we calculate Qc*xc-r and store it into Tmp0
                // * we calculate TK0 and TK1
                // * we multiply leading part of TK2 which stores Qf by sqrt(theta)
                //   it is important to perform this step AFTER calculation of TK0 and TK1,
                //   because we need original (non-modified) Qf to calculate TK0 and TK1.
                //
                for(j=0; j<=n-1; j++)
                {
                    for(i=0; i<=k-1; i++)
                    {
                        s.tk2[i,j] = 0.0;
                    }
                    s.tk1[j] = 0.0;
                }
                s.tk0 = 0.0;
                if( s.k>0 && (double)(s.theta)>(double)(0) )
                {
                    
                    //
                    // Split Q into Qf and Qc
                    // Calculate Qc*xc-r, store in Tmp0
                    //
                    apserv.rvectorsetlengthatleast(ref s.tmp0, k);
                    apserv.rvectorsetlengthatleast(ref s.tmp1, k);
                    cidx0 = 0;
                    cidx1 = nfree;
                    for(i=0; i<=k-1; i++)
                    {
                        s.tmp1[i] = 0.0;
                    }
                    for(j=0; j<=n-1; j++)
                    {
                        if( s.activeset[j] )
                        {
                            for(i=0; i<=k-1; i++)
                            {
                                s.tk2[i,cidx1] = s.q[i,j];
                                s.tmp1[i] = s.tmp1[i]+s.q[i,j]*s.txc[cidx1];
                            }
                            cidx1 = cidx1+1;
                        }
                        else
                        {
                            for(i=0; i<=k-1; i++)
                            {
                                s.tk2[i,cidx0] = s.q[i,j];
                            }
                            cidx0 = cidx0+1;
                        }
                    }
                    for(i=0; i<=k-1; i++)
                    {
                        s.tmp0[i] = s.tmp1[i]-s.r[i];
                    }
                    
                    //
                    // Calculate TK0
                    //
                    v = 0.0;
                    for(i=0; i<=k-1; i++)
                    {
                        v = v+s.theta*(0.5*math.sqr(s.tmp1[i])-s.r[i]*s.tmp0[i]-0.5*math.sqr(s.r[i]));
                    }
                    s.tk0 = v;
                    
                    //
                    // Calculate TK1
                    //
                    if( nfree>0 )
                    {
                        for(i=0; i<=k-1; i++)
                        {
                            v = s.theta*s.tmp0[i];
                            for(i_=0; i_<=nfree-1;i_++)
                            {
                                s.tk1[i_] = s.tk1[i_] + v*s.tk2[i,i_];
                            }
                        }
                    }
                    
                    //
                    // Calculate TK2
                    //
                    if( nfree>0 )
                    {
                        v = Math.Sqrt(s.theta);
                        for(i=0; i<=k-1; i++)
                        {
                            for(i_=0; i_<=nfree-1;i_++)
                            {
                                s.tk2[i,i_] = v*s.tk2[i,i_];
                            }
                        }
                    }
                }
            }
            
            //
            // Re-evaluate TB
            //
            if( s.isactivesetchanged || s.islineartermchanged )
            {
                ridx0 = 0;
                ridx1 = nfree;
                for(i=0; i<=n-1; i++)
                {
                    if( s.activeset[i] )
                    {
                        s.tb[ridx1] = s.b[i];
                        ridx1 = ridx1+1;
                    }
                    else
                    {
                        s.tb[ridx0] = s.b[i];
                        ridx0 = ridx0+1;
                    }
                }
            }
            
            //
            // Compose ECA: either dense ECA or diagonal ECA
            //
            if( (s.isactivesetchanged || s.ismaintermchanged) && nfree>0 )
            {
                if( (double)(s.alpha)>(double)(0) )
                {
                    
                    //
                    // Dense ECA
                    //
                    s.ecakind = 0;
                    for(i=0; i<=nfree-1; i++)
                    {
                        for(j=i; j<=nfree-1; j++)
                        {
                            s.ecadense[i,j] = s.tq2dense[i,j];
                        }
                    }
                    if( !trfac.spdmatrixcholeskyrec(ref s.ecadense, 0, nfree, true, ref s.tmp0) )
                    {
                        result = false;
                        return result;
                    }
                }
                else
                {
                    
                    //
                    // Diagonal ECA
                    //
                    s.ecakind = 1;
                    for(i=0; i<=nfree-1; i++)
                    {
                        if( (double)(s.tq2diag[i])<(double)(0) )
                        {
                            result = false;
                            return result;
                        }
                        s.ecadiag[i] = Math.Sqrt(s.tq2diag[i]);
                    }
                }
            }
            
            //
            // Compose EQ
            //
            if( s.isactivesetchanged || s.issecondarytermchanged )
            {
                for(i=0; i<=k-1; i++)
                {
                    for(j=0; j<=nfree-1; j++)
                    {
                        s.eq[i,j] = s.tk2[i,j];
                    }
                }
            }
            
            //
            // Calculate ECCM
            //
            if( ((((s.isactivesetchanged || s.ismaintermchanged) || s.issecondarytermchanged) && s.k>0) && (double)(s.theta)>(double)(0)) && nfree>0 )
            {
                
                //
                // Calculate ECCM - Cholesky factor of the "effective" capacitance
                // matrix CM = I + EQ*inv(EffectiveA)*EQ'.
                //
                // We calculate CM as follows:
                //   CM = I + EQ*inv(EffectiveA)*EQ'
                //      = I + EQ*ECA^(-1)*ECA^(-T)*EQ'
                //      = I + (EQ*ECA^(-1))*(EQ*ECA^(-1))'
                //
                // Then we perform Cholesky decomposition of CM.
                //
                apserv.rmatrixsetlengthatleast(ref s.tmp2, k, n);
                ablas.rmatrixcopy(k, nfree, s.eq, 0, 0, ref s.tmp2, 0, 0);
                alglib.ap.assert(s.ecakind==0 || s.ecakind==1, "CQMRebuild: unexpected ECAKind");
                if( s.ecakind==0 )
                {
                    ablas.rmatrixrighttrsm(k, nfree, s.ecadense, 0, 0, true, false, 0, s.tmp2, 0, 0);
                }
                if( s.ecakind==1 )
                {
                    for(i=0; i<=k-1; i++)
                    {
                        for(j=0; j<=nfree-1; j++)
                        {
                            s.tmp2[i,j] = s.tmp2[i,j]/s.ecadiag[j];
                        }
                    }
                }
                for(i=0; i<=k-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        s.eccm[i,j] = 0.0;
                    }
                    s.eccm[i,i] = 1.0;
                }
                ablas.rmatrixsyrk(k, nfree, 1.0, s.tmp2, 0, 0, 0, 1.0, s.eccm, 0, 0, true);
                if( !trfac.spdmatrixcholeskyrec(ref s.eccm, 0, k, true, ref s.tmp0) )
                {
                    result = false;
                    return result;
                }
            }
            
            //
            // Compose EB and EC
            //
            // NOTE: because these quantities are cheap to compute, we do not
            // use caching here.
            //
            for(i=0; i<=nfree-1; i++)
            {
                s.eb[i] = s.tq1[i]+s.tk1[i]+s.tb[i];
            }
            s.ec = s.tq0+s.tk0;
            for(i=nfree; i<=n-1; i++)
            {
                s.ec = s.ec+s.tb[i]*s.txc[i];
            }
            
            //
            // Change cache status - everything is cached 
            //
            s.ismaintermchanged = false;
            s.issecondarytermchanged = false;
            s.islineartermchanged = false;
            s.isactivesetchanged = false;
            return result;
        }


        /*************************************************************************
        Internal function, solves system Effective_A*x = b.
        It should be called after successful completion of CQMRebuild().

        INPUT PARAMETERS:
            S       -   quadratic model, after call to CQMRebuild()
            X       -   right part B, array[S.NFree]
            Tmp     -   temporary array, automatically reallocated if needed

        OUTPUT PARAMETERS:
            X       -   solution, array[S.NFree]
            
        NOTE: when called with zero S.NFree, returns silently
        NOTE: this function assumes that EA is non-degenerate

          -- ALGLIB --
             Copyright 10.05.2011 by Bochkanov Sergey
        *************************************************************************/
        private static void cqmsolveea(convexquadraticmodel s,
            ref double[] x,
            ref double[] tmp)
        {
            int i = 0;

            alglib.ap.assert((s.ecakind==0 || s.ecakind==1) || (s.ecakind==-1 && s.nfree==0), "CQMSolveEA: unexpected ECAKind");
            if( s.ecakind==0 )
            {
                
                //
                // Dense ECA, use FBLSCholeskySolve() dense solver.
                //
                fbls.fblscholeskysolve(s.ecadense, 1.0, s.nfree, true, x, ref tmp);
            }
            if( s.ecakind==1 )
            {
                
                //
                // Diagonal ECA
                //
                for(i=0; i<=s.nfree-1; i++)
                {
                    x[i] = x[i]/math.sqr(s.ecadiag[i]);
                }
            }
        }


    }
    public class snnls
    {
        /*************************************************************************
        This structure is a SNNLS (Specialized Non-Negative Least Squares) solver.

        It solves problems of the form |A*x-b|^2 => min subject to  non-negativity
        constraints on SOME components of x, with structured A (first  NS  columns
        are just unit matrix, next ND columns store dense part).

        This solver is suited for solution of many sequential NNLS  subproblems  -
        it keeps track of previously allocated memory and reuses  it  as  much  as
        possible.
        *************************************************************************/
        public class snnlssolver : apobject
        {
            public int ns;
            public int nd;
            public int nr;
            public double[,] densea;
            public double[] b;
            public bool[] nnc;
            public double debugflops;
            public int debugmaxinnerits;
            public double[] xn;
            public double[] xp;
            public double[,] tmpz;
            public double[,] tmpca;
            public double[,] tmplq;
            public double[,] trda;
            public double[] trdd;
            public double[] crb;
            public double[] g;
            public double[] d;
            public double[] dx;
            public double[] diagaa;
            public double[] cb;
            public double[] cx;
            public double[] cborg;
            public double[] tmpcholesky;
            public double[] r;
            public double[] regdiag;
            public double[] tmp0;
            public double[] tmp1;
            public double[] tmp2;
            public int[] rdtmprowmap;
            public snnlssolver()
            {
                init();
            }
            public override void init()
            {
                densea = new double[0,0];
                b = new double[0];
                nnc = new bool[0];
                xn = new double[0];
                xp = new double[0];
                tmpz = new double[0,0];
                tmpca = new double[0,0];
                tmplq = new double[0,0];
                trda = new double[0,0];
                trdd = new double[0];
                crb = new double[0];
                g = new double[0];
                d = new double[0];
                dx = new double[0];
                diagaa = new double[0];
                cb = new double[0];
                cx = new double[0];
                cborg = new double[0];
                tmpcholesky = new double[0];
                r = new double[0];
                regdiag = new double[0];
                tmp0 = new double[0];
                tmp1 = new double[0];
                tmp2 = new double[0];
                rdtmprowmap = new int[0];
            }
            public override alglib.apobject make_copy()
            {
                snnlssolver _result = new snnlssolver();
                _result.ns = ns;
                _result.nd = nd;
                _result.nr = nr;
                _result.densea = (double[,])densea.Clone();
                _result.b = (double[])b.Clone();
                _result.nnc = (bool[])nnc.Clone();
                _result.debugflops = debugflops;
                _result.debugmaxinnerits = debugmaxinnerits;
                _result.xn = (double[])xn.Clone();
                _result.xp = (double[])xp.Clone();
                _result.tmpz = (double[,])tmpz.Clone();
                _result.tmpca = (double[,])tmpca.Clone();
                _result.tmplq = (double[,])tmplq.Clone();
                _result.trda = (double[,])trda.Clone();
                _result.trdd = (double[])trdd.Clone();
                _result.crb = (double[])crb.Clone();
                _result.g = (double[])g.Clone();
                _result.d = (double[])d.Clone();
                _result.dx = (double[])dx.Clone();
                _result.diagaa = (double[])diagaa.Clone();
                _result.cb = (double[])cb.Clone();
                _result.cx = (double[])cx.Clone();
                _result.cborg = (double[])cborg.Clone();
                _result.tmpcholesky = (double[])tmpcholesky.Clone();
                _result.r = (double[])r.Clone();
                _result.regdiag = (double[])regdiag.Clone();
                _result.tmp0 = (double[])tmp0.Clone();
                _result.tmp1 = (double[])tmp1.Clone();
                _result.tmp2 = (double[])tmp2.Clone();
                _result.rdtmprowmap = (int[])rdtmprowmap.Clone();
                return _result;
            }
        };




        /*************************************************************************
        This subroutine is used to initialize SNNLS solver.

        By default, empty NNLS problem is produced, but we allocated enough  space
        to store problems with NSMax+NDMax columns and  NRMax  rows.  It  is  good
        place to provide algorithm with initial estimate of the space requirements,
        although you may underestimate problem size or even pass zero estimates  -
        in this case buffer variables will be resized automatically  when  you set
        NNLS problem.

        Previously allocated buffer variables are reused as much as possible. This
        function does not clear structure completely, it tries to preserve as much
        dynamically allocated memory as possible.

          -- ALGLIB --
             Copyright 10.10.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void snnlsinit(int nsmax,
            int ndmax,
            int nrmax,
            snnlssolver s)
        {
            s.ns = 0;
            s.nd = 0;
            s.nr = 0;
            apserv.rmatrixsetlengthatleast(ref s.densea, nrmax, ndmax);
            apserv.rmatrixsetlengthatleast(ref s.tmpca, nrmax, ndmax);
            apserv.rmatrixsetlengthatleast(ref s.tmpz, ndmax, ndmax);
            apserv.rvectorsetlengthatleast(ref s.b, nrmax);
            apserv.bvectorsetlengthatleast(ref s.nnc, nsmax+ndmax);
            s.debugflops = 0.0;
            s.debugmaxinnerits = 0;
        }


        /*************************************************************************
        This subroutine is used to set NNLS problem:

                ( [ 1     |      ]   [   ]   [   ] )^2
                ( [   1   |      ]   [   ]   [   ] )
            min ( [     1 |  Ad  ] * [ x ] - [ b ] )    s.t. x>=0
                ( [       |      ]   [   ]   [   ] )
                ( [       |      ]   [   ]   [   ] )

        where:
        * identity matrix has NS*NS size (NS<=NR, NS can be zero)
        * dense matrix Ad has NR*ND size
        * b is NR*1 vector
        * x is (NS+ND)*1 vector
        * all elements of x are non-negative (this constraint can be removed later
          by calling SNNLSDropNNC() function)

        Previously allocated buffer variables are reused as much as possible.
        After you set problem, you can solve it with SNNLSSolve().

        INPUT PARAMETERS:
            S   -   SNNLS solver, must be initialized with SNNLSInit() call
            A   -   array[NR,ND], dense part of the system
            B   -   array[NR], right part
            NS  -   size of the sparse part of the system, 0<=NS<=NR
            ND  -   size of the dense part of the system, ND>=0
            NR  -   rows count, NR>0

        NOTE:
            1. You can have NS+ND=0, solver will correctly accept such combination
               and return empty array as problem solution.
            
          -- ALGLIB --
             Copyright 10.10.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void snnlssetproblem(snnlssolver s,
            double[,] a,
            double[] b,
            int ns,
            int nd,
            int nr)
        {
            int i = 0;
            int i_ = 0;

            alglib.ap.assert(nd>=0, "SNNLSSetProblem: ND<0");
            alglib.ap.assert(ns>=0, "SNNLSSetProblem: NS<0");
            alglib.ap.assert(nr>0, "SNNLSSetProblem: NR<=0");
            alglib.ap.assert(ns<=nr, "SNNLSSetProblem: NS>NR");
            alglib.ap.assert(alglib.ap.rows(a)>=nr || nd==0, "SNNLSSetProblem: rows(A)<NR");
            alglib.ap.assert(alglib.ap.cols(a)>=nd, "SNNLSSetProblem: cols(A)<ND");
            alglib.ap.assert(alglib.ap.len(b)>=nr, "SNNLSSetProblem: length(B)<NR");
            alglib.ap.assert(apserv.apservisfinitematrix(a, nr, nd), "SNNLSSetProblem: A contains INF/NAN");
            alglib.ap.assert(apserv.isfinitevector(b, nr), "SNNLSSetProblem: B contains INF/NAN");
            
            //
            // Copy problem
            //
            s.ns = ns;
            s.nd = nd;
            s.nr = nr;
            if( nd>0 )
            {
                apserv.rmatrixsetlengthatleast(ref s.densea, nr, nd);
                for(i=0; i<=nr-1; i++)
                {
                    for(i_=0; i_<=nd-1;i_++)
                    {
                        s.densea[i,i_] = a[i,i_];
                    }
                }
            }
            apserv.rvectorsetlengthatleast(ref s.b, nr);
            for(i_=0; i_<=nr-1;i_++)
            {
                s.b[i_] = b[i_];
            }
            apserv.bvectorsetlengthatleast(ref s.nnc, ns+nd);
            for(i=0; i<=ns+nd-1; i++)
            {
                s.nnc[i] = true;
            }
        }


        /*************************************************************************
        This subroutine drops non-negativity constraint from the  problem  set  by
        SNNLSSetProblem() call. This function must be called AFTER problem is set,
        because each SetProblem() call resets constraints to their  default  state
        (all constraints are present).

        INPUT PARAMETERS:
            S   -   SNNLS solver, must be initialized with SNNLSInit() call,
                    problem must be set with SNNLSSetProblem() call.
            Idx -   constraint index, 0<=IDX<NS+ND
            
          -- ALGLIB --
             Copyright 10.10.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void snnlsdropnnc(snnlssolver s,
            int idx)
        {
            alglib.ap.assert(idx>=0, "SNNLSDropNNC: Idx<0");
            alglib.ap.assert(idx<s.ns+s.nd, "SNNLSDropNNC: Idx>=NS+ND");
            s.nnc[idx] = false;
        }


        /*************************************************************************
        This subroutine is used to solve NNLS problem.

        INPUT PARAMETERS:
            S   -   SNNLS solver, must be initialized with SNNLSInit() call and
                    problem must be set up with SNNLSSetProblem() call.
            X   -   possibly preallocated buffer, automatically resized if needed

        OUTPUT PARAMETERS:
            X   -   array[NS+ND], solution
            
        NOTE:
            1. You can have NS+ND=0, solver will correctly accept such combination
               and return empty array as problem solution.
            
            2. Internal field S.DebugFLOPS contains rough estimate of  FLOPs  used
               to solve problem. It can be used for debugging purposes. This field
               is real-valued.
            
          -- ALGLIB --
             Copyright 10.10.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void snnlssolve(snnlssolver s,
            ref double[] x)
        {
            int i = 0;
            int ns = 0;
            int nd = 0;
            int nr = 0;
            bool wasactivation = new bool();
            double lambdav = 0;
            double v0 = 0;
            double v1 = 0;
            double v = 0;
            int outerits = 0;
            int innerits = 0;
            int maxouterits = 0;
            double xtol = 0;
            double kicklength = 0;
            bool kickneeded = new bool();
            double f0 = 0;
            double f1 = 0;
            double dnrm = 0;
            int actidx = 0;
            double stp = 0;
            double stpmax = 0;

            
            //
            // Prepare
            //
            ns = s.ns;
            nd = s.nd;
            nr = s.nr;
            s.debugflops = 0.0;
            
            //
            // Handle special cases:
            // * NS+ND=0
            // * ND=0
            //
            if( ns+nd==0 )
            {
                return;
            }
            if( nd==0 )
            {
                apserv.rvectorsetlengthatleast(ref x, ns);
                for(i=0; i<=ns-1; i++)
                {
                    x[i] = s.b[i];
                    if( s.nnc[i] )
                    {
                        x[i] = Math.Max(x[i], 0.0);
                    }
                }
                return;
            }
            
            //
            // Main cycle of BLEIC-SNNLS algorithm.
            // Below we assume that ND>0.
            //
            apserv.rvectorsetlengthatleast(ref x, ns+nd);
            apserv.rvectorsetlengthatleast(ref s.xn, ns+nd);
            apserv.rvectorsetlengthatleast(ref s.xp, ns+nd);
            apserv.rvectorsetlengthatleast(ref s.g, ns+nd);
            apserv.rvectorsetlengthatleast(ref s.d, ns+nd);
            apserv.rvectorsetlengthatleast(ref s.r, nr);
            apserv.rvectorsetlengthatleast(ref s.diagaa, nd);
            apserv.rvectorsetlengthatleast(ref s.regdiag, ns+nd);
            apserv.rvectorsetlengthatleast(ref s.dx, ns+nd);
            for(i=0; i<=ns+nd-1; i++)
            {
                x[i] = 0.0;
                s.regdiag[i] = 1.0;
            }
            lambdav = 1.0E6*math.machineepsilon;
            maxouterits = 10;
            outerits = 0;
            innerits = 0;
            xtol = 1.0E3*math.machineepsilon;
            kicklength = Math.Sqrt(math.minrealnumber);
            while( true )
            {
                
                //
                // Initial check for correctness of X
                //
                for(i=0; i<=ns+nd-1; i++)
                {
                    alglib.ap.assert(!s.nnc[i] || (double)(x[i])>=(double)(0), "SNNLS: integrity check failed");
                }
                
                //
                // Calculate gradient G and constrained descent direction D
                //
                funcgradu(s, x, s.r, s.g, ref f0);
                for(i=0; i<=ns+nd-1; i++)
                {
                    if( (s.nnc[i] && (double)(x[i])==(double)(0)) && (double)(s.g[i])>(double)(0) )
                    {
                        s.d[i] = 0.0;
                    }
                    else
                    {
                        s.d[i] = -s.g[i];
                    }
                }
                
                //
                // Decide whether we need "kick" stage: special stage
                // that moves us away from boundary constraints which are
                // not strictly active (i.e. such constraints that x[i]=0.0 and d[i]>0).
                //
                // If we need kick stage, we make a kick - and restart iteration.
                // If not, after this block we can rely on the fact that
                // for all x[i]=0.0 we have d[i]=0.0
                //
                // NOTE: we do not increase outer iterations counter here
                //
                kickneeded = false;
                for(i=0; i<=ns+nd-1; i++)
                {
                    if( (s.nnc[i] && (double)(x[i])==(double)(0.0)) && (double)(s.d[i])>(double)(0.0) )
                    {
                        kickneeded = true;
                    }
                }
                if( kickneeded )
                {
                    
                    //
                    // Perform kick.
                    // Restart.
                    // Do not increase iterations counter.
                    //
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        if( (double)(x[i])==(double)(0.0) && (double)(s.d[i])>(double)(0.0) )
                        {
                            x[i] = x[i]+kicklength;
                        }
                    }
                    continue;
                }
                
                //
                // Newton phase
                // Reduce problem to constrained triangular form and perform Newton
                // steps with quick activation of constrants  (triangular  form  is
                // updated in order to handle changed constraints).
                //
                for(i=0; i<=ns+nd-1; i++)
                {
                    s.xp[i] = x[i];
                }
                trdprepare(s, x, s.regdiag, lambdav, ref s.trdd, ref s.trda, ref s.tmp0, ref s.tmp1, ref s.tmp2, ref s.tmplq);
                while( true )
                {
                    
                    //
                    // Skip if debug limit on inner iterations count is turned on.
                    //
                    if( s.debugmaxinnerits>0 && innerits>=s.debugmaxinnerits )
                    {
                        break;
                    }
                    
                    //
                    // Prepare step vector.
                    //
                    funcgradu(s, x, s.r, s.g, ref f0);
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        s.d[i] = -s.g[i];
                        if( s.nnc[i] && (double)(x[i])==(double)(0.0) )
                        {
                            s.d[i] = 0.0;
                        }
                    }
                    trdsolve(s.trdd, s.trda, ns, nd, s.d);
                    
                    //
                    // Perform unconstrained trial step and compare function values.
                    //
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        s.xn[i] = x[i]+s.d[i];
                    }
                    func(s, s.xn, ref f1);
                    if( (double)(f1)>=(double)(f0) )
                    {
                        break;
                    }
                    
                    //
                    // Calculate length of D, maximum step and component which is
                    // activated by this step. Break if D is exactly zero.
                    //
                    dnrm = 0.0;
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        dnrm = dnrm+math.sqr(s.d[i]);
                    }
                    dnrm = Math.Sqrt(dnrm);
                    actidx = -1;
                    stpmax = 1.0E50;
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        if( s.nnc[i] && (double)(s.d[i])<(double)(0.0) )
                        {
                            v = stpmax;
                            stpmax = apserv.safeminposrv(x[i], -s.d[i], stpmax);
                            if( (double)(stpmax)<(double)(v) )
                            {
                                actidx = i;
                            }
                        }
                    }
                    if( (double)(dnrm)==(double)(0.0) )
                    {
                        break;
                    }
                    
                    //
                    // Perform constrained step and update X
                    // and triangular model.
                    //
                    stp = Math.Min(1.0, stpmax);
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        v = x[i]+stp*s.d[i];
                        if( s.nnc[i] )
                        {
                            v = Math.Max(v, 0.0);
                        }
                        s.xn[i] = v;
                    }
                    if( (double)(stp)==(double)(stpmax) && actidx>=0 )
                    {
                        s.xn[actidx] = 0.0;
                    }
                    wasactivation = false;
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        if( (double)(s.xn[i])==(double)(0.0) && (double)(x[i])!=(double)(0.0) )
                        {
                            wasactivation = true;
                            trdfixvariable(s.trdd, s.trda, ns, nd, i, ref s.tmpcholesky);
                        }
                    }
                    for(i=0; i<=ns+nd-1; i++)
                    {
                        x[i] = s.xn[i];
                    }
                    
                    //
                    // Increment iterations counter.
                    // Terminate if no constraint was activated.
                    //
                    apserv.inc(ref innerits);
                    if( !wasactivation )
                    {
                        break;
                    }
                }
                
                //
                // Update outer iterations counter.
                //
                // Break if necessary:
                // * maximum number of outer iterations performed
                // * relative change in X is small enough
                //
                apserv.inc(ref outerits);
                if( outerits>=maxouterits )
                {
                    break;
                }
                v = 0;
                for(i=0; i<=ns+nd-1; i++)
                {
                    v0 = Math.Abs(s.xp[i]);
                    v1 = Math.Abs(x[i]);
                    if( (double)(v0)!=(double)(0) || (double)(v1)!=(double)(0) )
                    {
                        v = Math.Max(v, Math.Abs(x[i]-s.xp[i])/Math.Max(v0, v1));
                    }
                }
                if( (double)(v)<=(double)(xtol) )
                {
                    break;
                }
            }
        }


        /*************************************************************************
        This function calculates:
        * residual vector R = A*x-b
        * unconstrained gradient vector G
        * function value F = 0.5*|R|^2

        R and G must have at least N elements.

          -- ALGLIB --
             Copyright 15.07.2015 by Bochkanov Sergey
        *************************************************************************/
        private static void funcgradu(snnlssolver s,
            double[] x,
            double[] r,
            double[] g,
            ref double f)
        {
            int i = 0;
            int nr = 0;
            int nd = 0;
            int ns = 0;
            double v = 0;
            int i_ = 0;
            int i1_ = 0;

            f = 0;

            nr = s.nr;
            nd = s.nd;
            ns = s.ns;
            f = 0.0;
            for(i=0; i<=nr-1; i++)
            {
                i1_ = (ns)-(0);
                v = 0.0;
                for(i_=0; i_<=nd-1;i_++)
                {
                    v += s.densea[i,i_]*x[i_+i1_];
                }
                if( i<ns )
                {
                    v = v+x[i];
                }
                v = v-s.b[i];
                r[i] = v;
                f = f+0.5*v*v;
            }
            for(i=0; i<=ns-1; i++)
            {
                g[i] = r[i];
            }
            for(i=ns; i<=ns+nd-1; i++)
            {
                g[i] = 0.0;
            }
            for(i=0; i<=nr-1; i++)
            {
                v = r[i];
                i1_ = (0) - (ns);
                for(i_=ns; i_<=ns+nd-1;i_++)
                {
                    g[i_] = g[i_] + v*s.densea[i,i_+i1_];
                }
            }
        }


        /*************************************************************************
        This function calculates function value F = 0.5*|R|^2 at X.

          -- ALGLIB --
             Copyright 15.07.2015 by Bochkanov Sergey
        *************************************************************************/
        private static void func(snnlssolver s,
            double[] x,
            ref double f)
        {
            int i = 0;
            int nr = 0;
            int nd = 0;
            int ns = 0;
            double v = 0;
            int i_ = 0;
            int i1_ = 0;

            f = 0;

            nr = s.nr;
            nd = s.nd;
            ns = s.ns;
            f = 0.0;
            for(i=0; i<=nr-1; i++)
            {
                i1_ = (ns)-(0);
                v = 0.0;
                for(i_=0; i_<=nd-1;i_++)
                {
                    v += s.densea[i,i_]*x[i_+i1_];
                }
                if( i<ns )
                {
                    v = v+x[i];
                }
                v = v-s.b[i];
                f = f+0.5*v*v;
            }
        }


        private static void trdprepare(snnlssolver s,
            double[] x,
            double[] diag,
            double lambdav,
            ref double[] trdd,
            ref double[,] trda,
            ref double[] tmp0,
            ref double[] tmp1,
            ref double[] tmp2,
            ref double[,] tmplq)
        {
            int i = 0;
            int j = 0;
            int ns = 0;
            int nd = 0;
            int nr = 0;
            double v = 0;
            double cs = 0;
            double sn = 0;
            double r = 0;

            
            //
            // Prepare
            //
            ns = s.ns;
            nd = s.nd;
            nr = s.nr;
            
            //
            // Triangular reduction
            //
            apserv.rvectorsetlengthatleast(ref trdd, ns);
            apserv.rmatrixsetlengthatleast(ref trda, ns+nd, nd);
            apserv.rmatrixsetlengthatleast(ref tmplq, nd, nr+nd);
            for(i=0; i<=ns-1; i++)
            {
                
                //
                // Apply rotation to I-th row and corresponding row of
                // regularizer. Here V is diagonal element of I-th row,
                // which is set to 1.0 or 0.0 depending on variable
                // status (constrained or not).
                //
                v = 1.0;
                if( s.nnc[i] && (double)(x[i])==(double)(0.0) )
                {
                    v = 0.0;
                }
                rotations.generaterotation(v, lambdav, ref cs, ref sn, ref r);
                trdd[i] = cs*v+sn*lambdav;
                for(j=0; j<=nd-1; j++)
                {
                    v = s.densea[i,j];
                    trda[i,j] = cs*v;
                    tmplq[j,i] = -(sn*v);
                }
            }
            for(j=0; j<=nd-1; j++)
            {
                for(i=ns; i<=nr-1; i++)
                {
                    tmplq[j,i] = s.densea[i,j];
                }
            }
            for(j=0; j<=nd-1; j++)
            {
                if( s.nnc[ns+j] && (double)(x[ns+j])==(double)(0.0) )
                {
                    
                    //
                    // Variable is constrained, entire row is set to zero.
                    //
                    for(i=0; i<=nr-1; i++)
                    {
                        tmplq[j,i] = 0.0;
                    }
                    for(i=0; i<=ns-1; i++)
                    {
                        trda[i,j] = 0.0;
                    }
                }
            }
            for(i=0; i<=nd-1; i++)
            {
                for(j=0; j<=nd-1; j++)
                {
                    tmplq[j,nr+i] = 0.0;
                }
                tmplq[i,nr+i] = lambdav*diag[i];
            }
            apserv.rvectorsetlengthatleast(ref tmp0, nr+nd+1);
            apserv.rvectorsetlengthatleast(ref tmp1, nr+nd+1);
            apserv.rvectorsetlengthatleast(ref tmp2, nr+nd+1);
            ortfac.rmatrixlqbasecase(ref tmplq, nd, nr+nd, ref tmp0, ref tmp1, ref tmp2);
            for(i=0; i<=nd-1; i++)
            {
                if( (double)(tmplq[i,i])<(double)(0.0) )
                {
                    for(j=i; j<=nd-1; j++)
                    {
                        tmplq[j,i] = -tmplq[j,i];
                    }
                }
            }
            for(i=0; i<=nd-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    trda[ns+j,i] = tmplq[i,j];
                }
            }
        }


        private static void trdsolve(double[] trdd,
            double[,] trda,
            int ns,
            int nd,
            double[] d)
        {
            int i = 0;
            int j = 0;
            double v = 0;

            
            //
            // Solve U'*y=d first.
            //
            // This section includes two parts:
            // * solve diagonal part of U'
            // * solve dense part of U'
            //
            for(i=0; i<=ns-1; i++)
            {
                d[i] = d[i]/trdd[i];
                v = d[i];
                for(j=0; j<=nd-1; j++)
                {
                    d[ns+j] = d[ns+j]-v*trda[i,j];
                }
            }
            for(i=0; i<=nd-1; i++)
            {
                d[ns+i] = d[ns+i]/trda[ns+i,i];
                v = d[ns+i];
                for(j=i+1; j<=nd-1; j++)
                {
                    d[ns+j] = d[ns+j]-v*trda[ns+i,j];
                }
            }
            
            //
            // Solve U*x=y then.
            //
            // This section includes two parts:
            // * solve trailing triangular part of U
            // * solve combination of diagonal and dense parts of U
            //
            for(i=nd-1; i>=0; i--)
            {
                v = 0.0;
                for(j=i+1; j<=nd-1; j++)
                {
                    v = v+trda[ns+i,j]*d[ns+j];
                }
                d[ns+i] = (d[ns+i]-v)/trda[ns+i,i];
            }
            for(i=ns-1; i>=0; i--)
            {
                v = 0.0;
                for(j=0; j<=nd-1; j++)
                {
                    v = v+trda[i,j]*d[ns+j];
                }
                d[i] = (d[i]-v)/trdd[i];
            }
        }


        private static void trdfixvariable(double[] trdd,
            double[,] trda,
            int ns,
            int nd,
            int idx,
            ref double[] tmp)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            double cs = 0;
            double sn = 0;
            double r = 0;
            double v = 0;
            double vv = 0;

            alglib.ap.assert(ns>=0, "TRDFixVariable: integrity error");
            alglib.ap.assert(nd>=0, "TRDFixVariable: integrity error");
            alglib.ap.assert(ns+nd>0, "TRDFixVariable: integrity error");
            alglib.ap.assert(idx>=0, "TRDFixVariable: integrity error");
            alglib.ap.assert(idx<ns+nd, "TRDFixVariable: integrity error");
            apserv.rvectorsetlengthatleast(ref tmp, nd);
            
            //
            // Depending on variable index, two situations are possible
            //
            if( idx<ns )
            {
                
                //
                // We fix variable in the diagonal part of the model. It means
                // that prior to fixing we have:
                //
                //     (     |     )
                //     (  D  |     )
                //     (     |     )
                //     (-----|  A  )
                //     (     |0    )
                //     (     |00   )
                //     (     |000  )
                //     (     |0000 )
                //     (     |00000)
                //
                // then we replace idx-th column by zeros:
                //
                //     (D 0  |     )
                //     (  0  |     )
                //     (  0 D|     )
                //     (-----|  A  )
                //     (     |     )
                //     (     |     )
                //     (     |     )
                //
                // and append row with unit element to bottom, in order to
                // regularize problem
                //
                //     (D 0  |     )
                //     (  0  |     )
                //     (  0 D|     )
                //     (-----|  A  )
                //     (     |     )
                //     (     |     )
                //     (     |     )
                //     (00100|00000) <- appended
                //
                // and then we nullify this row by applying rotations:
                //
                //     (D 0  |     )
                //     (  0  |     ) <- first rotation is applied here
                //     (  0 D|     )
                //     (-----|  A  ) <- subsequent rotations are applied to this row and rows below
                //     (     |     )
                //     (     |     )
                //     (     |     )
                //     (  0  |  0  ) <- as result, row becomes zero
                //
                // and triangular structure is preserved
                //
                if( nd==0 )
                {
                    
                    //
                    // Quick exit for empty dense part
                    //
                    trdd[idx] = 1.0;
                    return;
                }
                for(j=0; j<=nd-1; j++)
                {
                    
                    //
                    // Apply first rotation
                    //
                    tmp[j] = trda[idx,j];
                    trda[idx,j] = 0.0;
                }
                trdd[idx] = 1.0;
                for(i=0; i<=nd-1; i++)
                {
                    if( (double)(tmp[i])!=(double)(0) )
                    {
                        
                        //
                        // Apply subsequent rotations with bottom triangular part of A
                        //
                        rotations.generaterotation(trda[ns+i,i], tmp[i], ref cs, ref sn, ref r);
                        for(j=i; j<=nd-1; j++)
                        {
                            v = trda[ns+i,j];
                            vv = tmp[j];
                            trda[ns+i,j] = v*cs+vv*sn;
                            tmp[j] = vv*cs-v*sn;
                        }
                    }
                }
            }
            else
            {
                
                //
                // We fix variable in the dense part of the model. It means
                // that prior to fixing we have:
                //
                //     (     |     )
                //     (  D  |     )
                //     (     |     )
                //     (-----|  A  )
                //     (     |0    )
                //     (     |00   )
                //     (     |000  )
                //     (     |0000 )
                //     (     |00000)
                //
                // then we replace idx-th column by zeros:
                //
                //     (     |  0  )
                //     (  D  |  0  )
                //     (     |  0  )
                //     (-----|A 0 A)
                //     (     |  0  )
                //     (     |  0  )
                //     (     |  0  )
                //
                // and append row with unit element to bottom, in order to
                // regularize problem
                //
                //     (     |  0  )
                //     (  D  |  0  )
                //     (     |  0  )
                //     (-----|A 0 A)
                //     (     |  0  )
                //     (     |  0  )
                //     (     |  0  )
                //     (00000|00100) <- appended
                //
                // and then we nullify this row by applying rotations:
                //
                //     (D 0  |     )
                //     (  0  |     )
                //     (  0 D|     )
                //     (-----|  A  )
                //     (     |     )
                //     (     |     ) <- first rotation is applied here
                //     (     |     ) <- subsequent rotations are applied to rows below
                //     (  0  |  0  ) <- as result, row becomes zero
                //
                // and triangular structure is preserved.
                //
                k = idx-ns;
                for(i=0; i<=ns+nd-1; i++)
                {
                    trda[i,k] = 0.0;
                }
                for(j=k+1; j<=nd-1; j++)
                {
                    
                    //
                    // Apply first rotation
                    //
                    tmp[j] = trda[idx,j];
                    trda[idx,j] = 0.0;
                }
                trda[idx,k] = 1.0;
                for(i=k+1; i<=nd-1; i++)
                {
                    if( (double)(tmp[i])!=(double)(0) )
                    {
                        
                        //
                        // Apply subsequent rotations with bottom triangular part of A
                        //
                        rotations.generaterotation(trda[ns+i,i], tmp[i], ref cs, ref sn, ref r);
                        for(j=i; j<=nd-1; j++)
                        {
                            v = trda[ns+i,j];
                            vv = tmp[j];
                            trda[ns+i,j] = v*cs+vv*sn;
                            tmp[j] = vv*cs-v*sn;
                        }
                    }
                }
            }
        }


    }
    public class sactivesets
    {
        /*************************************************************************
        This structure describes set of linear constraints (boundary  and  general
        ones) which can be active and inactive. It also has functionality to  work
        with current point and current  gradient  (determine  active  constraints,
        move current point, project gradient into  constrained  subspace,  perform
        constrained preconditioning and so on.

        This  structure  is  intended  to  be  used  by constrained optimizers for
        management of all constraint-related functionality.

        External code may access following internal fields of the structure:
            XC          -   stores current point, array[N].
                            can be accessed only in optimization mode
            ActiveSet   -   active set, array[N+NEC+NIC]:
                            * ActiveSet[I]>0    I-th constraint is in the active set
                            * ActiveSet[I]=0    I-th constraint is at the boundary, but inactive
                            * ActiveSet[I]<0    I-th constraint is far from the boundary (and inactive)
                            * elements from 0 to N-1 correspond to boundary constraints
                            * elements from N to N+NEC+NIC-1 correspond to linear constraints
                            * elements from N to N+NEC-1 are always +1
            PBasis,
            IBasis,
            SBasis      -   after call to SASRebuildBasis() these  matrices  store
                            active constraints, reorthogonalized with  respect  to
                            some inner product:
                            a) for PBasis - one  given  by  preconditioner  matrix
                               (inverse Hessian)
                            b) for SBasis - one given by square of the scale matrix
                            c) for IBasis - traditional dot product
                            
                            array[BasisSize,N+1], where BasisSize is a  number  of
                            positive elements in  ActiveSet[N:N+NEC+NIC-1].  First
                            N columns store linear term, last column stores  right
                            part. All  three  matrices  are linearly equivalent to
                            each other, span(PBasis)=span(IBasis)=span(SBasis).
                            
                            IMPORTANT: you have to call  SASRebuildBasis()  before
                                       accessing these arrays  in  order  to  make
                                       sure that they are up to date.
            BasisSize   -   basis size (PBasis/SBasis/IBasis)
        *************************************************************************/
        public class sactiveset : apobject
        {
            public int n;
            public int algostate;
            public double[] xc;
            public bool hasxc;
            public double[] s;
            public double[] h;
            public int[] activeset;
            public bool basisisready;
            public double[,] sbasis;
            public double[,] pbasis;
            public double[,] ibasis;
            public int basissize;
            public bool constraintschanged;
            public bool[] hasbndl;
            public bool[] hasbndu;
            public double[] bndl;
            public double[] bndu;
            public double[,] cleic;
            public int nec;
            public int nic;
            public double[] mtx;
            public int[] mtas;
            public double[] cdtmp;
            public double[] corrtmp;
            public double[] unitdiagonal;
            public snnls.snnlssolver solver;
            public double[] scntmp;
            public double[] tmp0;
            public double[] tmpfeas;
            public double[,] tmpm0;
            public double[] rctmps;
            public double[] rctmpg;
            public double[] rctmprightpart;
            public double[,] rctmpdense0;
            public double[,] rctmpdense1;
            public bool[] rctmpisequality;
            public int[] rctmpconstraintidx;
            public double[] rctmplambdas;
            public double[,] tmpbasis;
            public sactiveset()
            {
                init();
            }
            public override void init()
            {
                xc = new double[0];
                s = new double[0];
                h = new double[0];
                activeset = new int[0];
                sbasis = new double[0,0];
                pbasis = new double[0,0];
                ibasis = new double[0,0];
                hasbndl = new bool[0];
                hasbndu = new bool[0];
                bndl = new double[0];
                bndu = new double[0];
                cleic = new double[0,0];
                mtx = new double[0];
                mtas = new int[0];
                cdtmp = new double[0];
                corrtmp = new double[0];
                unitdiagonal = new double[0];
                solver = new snnls.snnlssolver();
                scntmp = new double[0];
                tmp0 = new double[0];
                tmpfeas = new double[0];
                tmpm0 = new double[0,0];
                rctmps = new double[0];
                rctmpg = new double[0];
                rctmprightpart = new double[0];
                rctmpdense0 = new double[0,0];
                rctmpdense1 = new double[0,0];
                rctmpisequality = new bool[0];
                rctmpconstraintidx = new int[0];
                rctmplambdas = new double[0];
                tmpbasis = new double[0,0];
            }
            public override alglib.apobject make_copy()
            {
                sactiveset _result = new sactiveset();
                _result.n = n;
                _result.algostate = algostate;
                _result.xc = (double[])xc.Clone();
                _result.hasxc = hasxc;
                _result.s = (double[])s.Clone();
                _result.h = (double[])h.Clone();
                _result.activeset = (int[])activeset.Clone();
                _result.basisisready = basisisready;
                _result.sbasis = (double[,])sbasis.Clone();
                _result.pbasis = (double[,])pbasis.Clone();
                _result.ibasis = (double[,])ibasis.Clone();
                _result.basissize = basissize;
                _result.constraintschanged = constraintschanged;
                _result.hasbndl = (bool[])hasbndl.Clone();
                _result.hasbndu = (bool[])hasbndu.Clone();
                _result.bndl = (double[])bndl.Clone();
                _result.bndu = (double[])bndu.Clone();
                _result.cleic = (double[,])cleic.Clone();
                _result.nec = nec;
                _result.nic = nic;
                _result.mtx = (double[])mtx.Clone();
                _result.mtas = (int[])mtas.Clone();
                _result.cdtmp = (double[])cdtmp.Clone();
                _result.corrtmp = (double[])corrtmp.Clone();
                _result.unitdiagonal = (double[])unitdiagonal.Clone();
                _result.solver = (snnls.snnlssolver)solver.make_copy();
                _result.scntmp = (double[])scntmp.Clone();
                _result.tmp0 = (double[])tmp0.Clone();
                _result.tmpfeas = (double[])tmpfeas.Clone();
                _result.tmpm0 = (double[,])tmpm0.Clone();
                _result.rctmps = (double[])rctmps.Clone();
                _result.rctmpg = (double[])rctmpg.Clone();
                _result.rctmprightpart = (double[])rctmprightpart.Clone();
                _result.rctmpdense0 = (double[,])rctmpdense0.Clone();
                _result.rctmpdense1 = (double[,])rctmpdense1.Clone();
                _result.rctmpisequality = (bool[])rctmpisequality.Clone();
                _result.rctmpconstraintidx = (int[])rctmpconstraintidx.Clone();
                _result.rctmplambdas = (double[])rctmplambdas.Clone();
                _result.tmpbasis = (double[,])tmpbasis.Clone();
                return _result;
            }
        };




        /*************************************************************************
        This   subroutine   is   used  to initialize active set. By default, empty
        N-variable model with no constraints is  generated.  Previously  allocated
        buffer variables are reused as much as possible.

        Two use cases for this object are described below.

        CASE 1 - STEEPEST DESCENT:

            SASInit()
            repeat:
                SASReactivateConstraints()
                SASDescentDirection()
                SASExploreDirection()
                SASMoveTo()
            until convergence

        CASE 1 - PRECONDITIONED STEEPEST DESCENT:

            SASInit()
            repeat:
                SASReactivateConstraintsPrec()
                SASDescentDirectionPrec()
                SASExploreDirection()
                SASMoveTo()
            until convergence

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasinit(int n,
            sactiveset s)
        {
            int i = 0;

            s.n = n;
            s.algostate = 0;
            
            //
            // Constraints
            //
            s.constraintschanged = true;
            s.nec = 0;
            s.nic = 0;
            apserv.rvectorsetlengthatleast(ref s.bndl, n);
            apserv.bvectorsetlengthatleast(ref s.hasbndl, n);
            apserv.rvectorsetlengthatleast(ref s.bndu, n);
            apserv.bvectorsetlengthatleast(ref s.hasbndu, n);
            for(i=0; i<=n-1; i++)
            {
                s.bndl[i] = Double.NegativeInfinity;
                s.bndu[i] = Double.PositiveInfinity;
                s.hasbndl[i] = false;
                s.hasbndu[i] = false;
            }
            
            //
            // current point, scale
            //
            s.hasxc = false;
            apserv.rvectorsetlengthatleast(ref s.xc, n);
            apserv.rvectorsetlengthatleast(ref s.s, n);
            apserv.rvectorsetlengthatleast(ref s.h, n);
            for(i=0; i<=n-1; i++)
            {
                s.xc[i] = 0.0;
                s.s[i] = 1.0;
                s.h[i] = 1.0;
            }
            
            //
            // Other
            //
            apserv.rvectorsetlengthatleast(ref s.unitdiagonal, n);
            for(i=0; i<=n-1; i++)
            {
                s.unitdiagonal[i] = 1.0;
            }
        }


        /*************************************************************************
        This function sets scaling coefficients for SAS object.

        ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
        size and gradient are scaled before comparison with tolerances).  Scale of
        the I-th variable is a translation invariant measure of:
        a) "how large" the variable is
        b) how large the step should be to make significant changes in the function

        During orthogonalization phase, scale is used to calculate drop tolerances
        (whether vector is significantly non-zero or not).

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            S       -   array[N], non-zero scaling coefficients
                        S[i] may be negative, sign doesn't matter.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sassetscale(sactiveset state,
            double[] s)
        {
            int i = 0;

            alglib.ap.assert(state.algostate==0, "SASSetScale: you may change scale only in modification mode");
            alglib.ap.assert(alglib.ap.len(s)>=state.n, "SASSetScale: Length(S)<N");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(s[i]), "SASSetScale: S contains infinite or NAN elements");
                alglib.ap.assert((double)(s[i])!=(double)(0), "SASSetScale: S contains zero elements");
            }
            for(i=0; i<=state.n-1; i++)
            {
                state.s[i] = Math.Abs(s[i]);
            }
        }


        /*************************************************************************
        Modification  of  the  preconditioner:  diagonal of approximate Hessian is
        used.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            D       -   diagonal of the approximate Hessian, array[0..N-1],
                        (if larger, only leading N elements are used).

        NOTE 1: D[i] should be positive. Exception will be thrown otherwise.

        NOTE 2: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sassetprecdiag(sactiveset state,
            double[] d)
        {
            int i = 0;

            alglib.ap.assert(state.algostate==0, "SASSetPrecDiag: you may change preconditioner only in modification mode");
            alglib.ap.assert(alglib.ap.len(d)>=state.n, "SASSetPrecDiag: D is too short");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(d[i]), "SASSetPrecDiag: D contains infinite or NAN elements");
                alglib.ap.assert((double)(d[i])>(double)(0), "SASSetPrecDiag: D contains non-positive elements");
            }
            for(i=0; i<=state.n-1; i++)
            {
                state.h[i] = d[i];
            }
        }


        /*************************************************************************
        This function sets/changes boundary constraints.

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            BndL    -   lower bounds, array[N].
                        If some (all) variables are unbounded, you may specify
                        very small number or -INF.
            BndU    -   upper bounds, array[N].
                        If some (all) variables are unbounded, you may specify
                        very large number or +INF.

        NOTE 1: it is possible to specify BndL[i]=BndU[i]. In this case I-th
        variable will be "frozen" at X[i]=BndL[i]=BndU[i].

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sassetbc(sactiveset state,
            double[] bndl,
            double[] bndu)
        {
            int i = 0;
            int n = 0;

            alglib.ap.assert(state.algostate==0, "SASSetBC: you may change constraints only in modification mode");
            n = state.n;
            alglib.ap.assert(alglib.ap.len(bndl)>=n, "SASSetBC: Length(BndL)<N");
            alglib.ap.assert(alglib.ap.len(bndu)>=n, "SASSetBC: Length(BndU)<N");
            for(i=0; i<=n-1; i++)
            {
                alglib.ap.assert(math.isfinite(bndl[i]) || Double.IsNegativeInfinity(bndl[i]), "SASSetBC: BndL contains NAN or +INF");
                alglib.ap.assert(math.isfinite(bndu[i]) || Double.IsPositiveInfinity(bndu[i]), "SASSetBC: BndL contains NAN or -INF");
                state.bndl[i] = bndl[i];
                state.hasbndl[i] = math.isfinite(bndl[i]);
                state.bndu[i] = bndu[i];
                state.hasbndu[i] = math.isfinite(bndu[i]);
            }
            state.constraintschanged = true;
        }


        /*************************************************************************
        This function sets linear constraints for SAS object.

        Linear constraints are inactive by default (after initial creation).

        INPUT PARAMETERS:
            State   -   SAS structure
            C       -   linear constraints, array[K,N+1].
                        Each row of C represents one constraint, either equality
                        or inequality (see below):
                        * first N elements correspond to coefficients,
                        * last element corresponds to the right part.
                        All elements of C (including right part) must be finite.
            CT      -   type of constraints, array[K]:
                        * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                        * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                        * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
            K       -   number of equality/inequality constraints, K>=0

        NOTE 1: linear (non-bound) constraints are satisfied only approximately:
        * there always exists some minor violation (about Epsilon in magnitude)
          due to rounding errors
        * numerical differentiation, if used, may  lead  to  function  evaluations
          outside  of the feasible  area,   because   algorithm  does  NOT  change
          numerical differentiation formula according to linear constraints.
        If you want constraints to be  satisfied  exactly, try to reformulate your
        problem  in  such  manner  that  all constraints will become boundary ones
        (this kind of constraints is always satisfied exactly, both in  the  final
        solution and in all intermediate points).

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void sassetlc(sactiveset state,
            double[,] c,
            int[] ct,
            int k)
        {
            int n = 0;
            int i = 0;
            int i_ = 0;

            alglib.ap.assert(state.algostate==0, "SASSetLC: you may change constraints only in modification mode");
            n = state.n;
            
            //
            // First, check for errors in the inputs
            //
            alglib.ap.assert(k>=0, "SASSetLC: K<0");
            alglib.ap.assert(alglib.ap.cols(c)>=n+1 || k==0, "SASSetLC: Cols(C)<N+1");
            alglib.ap.assert(alglib.ap.rows(c)>=k, "SASSetLC: Rows(C)<K");
            alglib.ap.assert(alglib.ap.len(ct)>=k, "SASSetLC: Length(CT)<K");
            alglib.ap.assert(apserv.apservisfinitematrix(c, k, n+1), "SASSetLC: C contains infinite or NaN values!");
            
            //
            // Handle zero K
            //
            if( k==0 )
            {
                state.nec = 0;
                state.nic = 0;
                state.constraintschanged = true;
                return;
            }
            
            //
            // Equality constraints are stored first, in the upper
            // NEC rows of State.CLEIC matrix. Inequality constraints
            // are stored in the next NIC rows.
            //
            // NOTE: we convert inequality constraints to the form
            // A*x<=b before copying them.
            //
            apserv.rmatrixsetlengthatleast(ref state.cleic, k, n+1);
            state.nec = 0;
            state.nic = 0;
            for(i=0; i<=k-1; i++)
            {
                if( ct[i]==0 )
                {
                    for(i_=0; i_<=n;i_++)
                    {
                        state.cleic[state.nec,i_] = c[i,i_];
                    }
                    state.nec = state.nec+1;
                }
            }
            for(i=0; i<=k-1; i++)
            {
                if( ct[i]!=0 )
                {
                    if( ct[i]>0 )
                    {
                        for(i_=0; i_<=n;i_++)
                        {
                            state.cleic[state.nec+state.nic,i_] = -c[i,i_];
                        }
                    }
                    else
                    {
                        for(i_=0; i_<=n;i_++)
                        {
                            state.cleic[state.nec+state.nic,i_] = c[i,i_];
                        }
                    }
                    state.nic = state.nic+1;
                }
            }
            
            //
            // Mark state as changed
            //
            state.constraintschanged = true;
        }


        /*************************************************************************
        Another variation of SASSetLC(), which accepts  linear  constraints  using
        another representation.

        Linear constraints are inactive by default (after initial creation).

        INPUT PARAMETERS:
            State   -   SAS structure
            CLEIC   -   linear constraints, array[NEC+NIC,N+1].
                        Each row of C represents one constraint:
                        * first N elements correspond to coefficients,
                        * last element corresponds to the right part.
                        First NEC rows store equality constraints, next NIC -  are
                        inequality ones.
                        All elements of C (including right part) must be finite.
            NEC     -   number of equality constraints, NEC>=0
            NIC     -   number of inequality constraints, NIC>=0

        NOTE 1: linear (non-bound) constraints are satisfied only approximately:
        * there always exists some minor violation (about Epsilon in magnitude)
          due to rounding errors
        * numerical differentiation, if used, may  lead  to  function  evaluations
          outside  of the feasible  area,   because   algorithm  does  NOT  change
          numerical differentiation formula according to linear constraints.
        If you want constraints to be  satisfied  exactly, try to reformulate your
        problem  in  such  manner  that  all constraints will become boundary ones
        (this kind of constraints is always satisfied exactly, both in  the  final
        solution and in all intermediate points).

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void sassetlcx(sactiveset state,
            double[,] cleic,
            int nec,
            int nic)
        {
            int n = 0;
            int i = 0;
            int j = 0;

            alglib.ap.assert(state.algostate==0, "SASSetLCX: you may change constraints only in modification mode");
            n = state.n;
            
            //
            // First, check for errors in the inputs
            //
            alglib.ap.assert(nec>=0, "SASSetLCX: NEC<0");
            alglib.ap.assert(nic>=0, "SASSetLCX: NIC<0");
            alglib.ap.assert(alglib.ap.cols(cleic)>=n+1 || nec+nic==0, "SASSetLCX: Cols(CLEIC)<N+1");
            alglib.ap.assert(alglib.ap.rows(cleic)>=nec+nic, "SASSetLCX: Rows(CLEIC)<NEC+NIC");
            alglib.ap.assert(apserv.apservisfinitematrix(cleic, nec+nic, n+1), "SASSetLCX: CLEIC contains infinite or NaN values!");
            
            //
            // Store constraints
            //
            apserv.rmatrixsetlengthatleast(ref state.cleic, nec+nic, n+1);
            state.nec = nec;
            state.nic = nic;
            for(i=0; i<=nec+nic-1; i++)
            {
                for(j=0; j<=n; j++)
                {
                    state.cleic[i,j] = cleic[i,j];
                }
            }
            
            //
            // Mark state as changed
            //
            state.constraintschanged = true;
        }


        /*************************************************************************
        This subroutine turns on optimization mode:
        1. feasibility in X is enforced  (in case X=S.XC and constraints  have not
           changed, algorithm just uses X without any modifications at all)
        2. constraints are marked as "candidate" or "inactive"

        INPUT PARAMETERS:
            S   -   active set object
            X   -   initial point (candidate), array[N]. It is expected that X
                    contains only finite values (we do not check it).
            
        OUTPUT PARAMETERS:
            S   -   state is changed
            X   -   initial point can be changed to enforce feasibility
            
        RESULT:
            True in case feasible point was found (mode was changed to "optimization")
            False in case no feasible point was found (mode was not changed)

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static bool sasstartoptimization(sactiveset state,
            double[] x)
        {
            bool result = new bool();
            int n = 0;
            int nec = 0;
            int nic = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            alglib.ap.assert(state.algostate==0, "SASStartOptimization: already in optimization mode");
            result = false;
            n = state.n;
            nec = state.nec;
            nic = state.nic;
            
            //
            // Enforce feasibility and calculate set of "candidate"/"active" constraints.
            // Always active equality constraints are marked as "active", all other constraints
            // are marked as "candidate".
            //
            apserv.ivectorsetlengthatleast(ref state.activeset, n+nec+nic);
            for(i=0; i<=n-1; i++)
            {
                if( state.hasbndl[i] && state.hasbndu[i] )
                {
                    if( (double)(state.bndl[i])>(double)(state.bndu[i]) )
                    {
                        return result;
                    }
                }
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.xc[i_] = x[i_];
            }
            if( state.nec+state.nic>0 )
            {
                
                //
                // General linear constraints are present; general code is used.
                //
                apserv.rvectorsetlengthatleast(ref state.tmp0, n);
                apserv.rvectorsetlengthatleast(ref state.tmpfeas, n+state.nic);
                apserv.rmatrixsetlengthatleast(ref state.tmpm0, state.nec+state.nic, n+state.nic+1);
                for(i=0; i<=state.nec+state.nic-1; i++)
                {
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.tmpm0[i,i_] = state.cleic[i,i_];
                    }
                    for(j=n; j<=n+state.nic-1; j++)
                    {
                        state.tmpm0[i,j] = 0;
                    }
                    if( i>=state.nec )
                    {
                        state.tmpm0[i,n+i-state.nec] = 1.0;
                    }
                    state.tmpm0[i,n+state.nic] = state.cleic[i,n];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    state.tmpfeas[i_] = state.xc[i_];
                }
                for(i=0; i<=state.nic-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += state.cleic[i+state.nec,i_]*state.xc[i_];
                    }
                    state.tmpfeas[i+n] = Math.Max(state.cleic[i+state.nec,n]-v, 0.0);
                }
                if( !optserv.findfeasiblepoint(ref state.tmpfeas, state.bndl, state.hasbndl, state.bndu, state.hasbndu, n, state.nic, state.tmpm0, state.nec+state.nic, 1.0E-6, ref i, ref j) )
                {
                    return result;
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    state.xc[i_] = state.tmpfeas[i_];
                }
                for(i=0; i<=n-1; i++)
                {
                    if( (state.hasbndl[i] && state.hasbndu[i]) && (double)(state.bndl[i])==(double)(state.bndu[i]) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                    if( (state.hasbndl[i] && (double)(state.xc[i])==(double)(state.bndl[i])) || (state.hasbndu[i] && (double)(state.xc[i])==(double)(state.bndu[i])) )
                    {
                        state.activeset[i] = 0;
                        continue;
                    }
                    state.activeset[i] = -1;
                }
                for(i=0; i<=state.nec-1; i++)
                {
                    state.activeset[n+i] = 1;
                }
                for(i=0; i<=state.nic-1; i++)
                {
                    if( (double)(state.tmpfeas[n+i])==(double)(0) )
                    {
                        state.activeset[n+state.nec+i] = 0;
                    }
                    else
                    {
                        state.activeset[n+state.nec+i] = -1;
                    }
                }
            }
            else
            {
                
                //
                // Only bound constraints are present, quick code can be used
                //
                for(i=0; i<=n-1; i++)
                {
                    state.activeset[i] = -1;
                    if( (state.hasbndl[i] && state.hasbndu[i]) && (double)(state.bndl[i])==(double)(state.bndu[i]) )
                    {
                        state.activeset[i] = 1;
                        state.xc[i] = state.bndl[i];
                        continue;
                    }
                    if( state.hasbndl[i] && (double)(state.xc[i])<=(double)(state.bndl[i]) )
                    {
                        state.xc[i] = state.bndl[i];
                        state.activeset[i] = 0;
                        continue;
                    }
                    if( state.hasbndu[i] && (double)(state.xc[i])>=(double)(state.bndu[i]) )
                    {
                        state.xc[i] = state.bndu[i];
                        state.activeset[i] = 0;
                        continue;
                    }
                }
            }
            
            //
            // Change state, allocate temporaries
            //
            result = true;
            state.algostate = 1;
            state.basisisready = false;
            state.hasxc = true;
            apserv.rmatrixsetlengthatleast(ref state.pbasis, Math.Min(nec+nic, n), n+1);
            apserv.rmatrixsetlengthatleast(ref state.ibasis, Math.Min(nec+nic, n), n+1);
            apserv.rmatrixsetlengthatleast(ref state.sbasis, Math.Min(nec+nic, n), n+1);
            return result;
        }


        /*************************************************************************
        This function explores search direction and calculates bound for  step  as
        well as information for activation of constraints.

        INPUT PARAMETERS:
            State       -   SAS structure which stores current point and all other
                            active set related information
            D           -   descent direction to explore

        OUTPUT PARAMETERS:
            StpMax      -   upper  limit  on  step  length imposed by yet inactive
                            constraints. Can be  zero  in  case  some  constraints
                            can be activated by zero step.  Equal  to  some  large
                            value in case step is unlimited.
            CIdx        -   -1 for unlimited step, in [0,N+NEC+NIC) in case of
                            limited step.
            VVal        -   value which is assigned to X[CIdx] during activation.
                            For CIdx<0 or CIdx>=N some dummy value is assigned to
                            this parameter.
        *************************************************************************/
        public static void sasexploredirection(sactiveset state,
            double[] d,
            ref double stpmax,
            ref int cidx,
            ref double vval)
        {
            int n = 0;
            int nec = 0;
            int nic = 0;
            int i = 0;
            double prevmax = 0;
            double vc = 0;
            double vd = 0;
            int i_ = 0;

            stpmax = 0;
            cidx = 0;
            vval = 0;

            alglib.ap.assert(state.algostate==1, "SASExploreDirection: is not in optimization mode");
            n = state.n;
            nec = state.nec;
            nic = state.nic;
            cidx = -1;
            vval = 0;
            stpmax = 1.0E50;
            for(i=0; i<=n-1; i++)
            {
                if( state.activeset[i]<=0 )
                {
                    alglib.ap.assert(!state.hasbndl[i] || (double)(state.xc[i])>=(double)(state.bndl[i]), "SASExploreDirection: internal error - infeasible X");
                    alglib.ap.assert(!state.hasbndu[i] || (double)(state.xc[i])<=(double)(state.bndu[i]), "SASExploreDirection: internal error - infeasible X");
                    if( state.hasbndl[i] && (double)(d[i])<(double)(0) )
                    {
                        prevmax = stpmax;
                        stpmax = apserv.safeminposrv(state.xc[i]-state.bndl[i], -d[i], stpmax);
                        if( (double)(stpmax)<(double)(prevmax) )
                        {
                            cidx = i;
                            vval = state.bndl[i];
                        }
                    }
                    if( state.hasbndu[i] && (double)(d[i])>(double)(0) )
                    {
                        prevmax = stpmax;
                        stpmax = apserv.safeminposrv(state.bndu[i]-state.xc[i], d[i], stpmax);
                        if( (double)(stpmax)<(double)(prevmax) )
                        {
                            cidx = i;
                            vval = state.bndu[i];
                        }
                    }
                }
            }
            for(i=nec; i<=nec+nic-1; i++)
            {
                if( state.activeset[n+i]<=0 )
                {
                    vc = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        vc += state.cleic[i,i_]*state.xc[i_];
                    }
                    vc = vc-state.cleic[i,n];
                    vd = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        vd += state.cleic[i,i_]*d[i_];
                    }
                    if( (double)(vd)<=(double)(0) )
                    {
                        continue;
                    }
                    if( (double)(vc)<(double)(0) )
                    {
                        
                        //
                        // XC is strictly feasible with respect to I-th constraint,
                        // we can perform non-zero step because there is non-zero distance
                        // between XC and bound.
                        //
                        prevmax = stpmax;
                        stpmax = apserv.safeminposrv(-vc, vd, stpmax);
                        if( (double)(stpmax)<(double)(prevmax) )
                        {
                            cidx = n+i;
                        }
                    }
                    else
                    {
                        
                        //
                        // XC is at the boundary (or slightly beyond it), and step vector
                        // points beyond the boundary.
                        //
                        // The only thing we can do is to perform zero step and activate
                        // I-th constraint.
                        //
                        stpmax = 0;
                        cidx = n+i;
                    }
                }
            }
        }


        /*************************************************************************
        This subroutine moves current point to XN, which can be:
        a) point in the direction previously explored  with  SASExploreDirection()
           function (in this case NeedAct/CIdx/CVal are used)
        b) point in arbitrary direction, not necessarily previously  checked  with
           SASExploreDirection() function.

        Step may activate one constraint. It is assumed than XN  is  approximately
        feasible (small error as  large  as several  ulps  is  possible).   Strict
        feasibility  with  respect  to  bound  constraints  is  enforced    during
        activation, feasibility with respect to general linear constraints is  not
        enforced.

        This function activates boundary constraints, such that both is True:
        1) XC[I] is not at the boundary
        2) XN[I] is at the boundary or beyond it

        INPUT PARAMETERS:
            S       -   active set object
            XN      -   new point.
            NeedAct -   True in case one constraint needs activation
            CIdx    -   index of constraint, in [0,N+NEC+NIC).
                        Ignored if NeedAct is false.
                        This value is calculated by SASExploreDirection().
            CVal    -   for CIdx in [0,N) this field stores value which is
                        assigned to XC[CIdx] during activation. CVal is ignored in
                        other cases.
                        This value is calculated by SASExploreDirection().
            
        OUTPUT PARAMETERS:
            S       -   current point and list of active constraints are changed.

        RESULT:
            >0, in case at least one inactive non-candidate constraint was activated
            =0, in case only "candidate" constraints were activated
            <0, in case no constraints were activated by the step

        NOTE: in general case State.XC<>XN because activation of  constraints  may
              slightly change current point (to enforce feasibility).

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static int sasmoveto(sactiveset state,
            double[] xn,
            bool needact,
            int cidx,
            double cval)
        {
            int result = 0;
            int n = 0;
            int nec = 0;
            int nic = 0;
            int i = 0;
            bool wasactivation = new bool();

            alglib.ap.assert(state.algostate==1, "SASMoveTo: is not in optimization mode");
            n = state.n;
            nec = state.nec;
            nic = state.nic;
            
            //
            // Save previous state, update current point
            //
            apserv.rvectorsetlengthatleast(ref state.mtx, n);
            apserv.ivectorsetlengthatleast(ref state.mtas, n+nec+nic);
            for(i=0; i<=n-1; i++)
            {
                state.mtx[i] = state.xc[i];
                state.xc[i] = xn[i];
            }
            for(i=0; i<=n+nec+nic-1; i++)
            {
                state.mtas[i] = state.activeset[i];
            }
            
            //
            // Activate constraints
            //
            wasactivation = false;
            if( needact )
            {
                
                //
                // Activation
                //
                alglib.ap.assert(cidx>=0 && cidx<n+nec+nic, "SASMoveTo: incorrect CIdx");
                if( cidx<n )
                {
                    
                    //
                    // CIdx in [0,N-1] means that bound constraint was activated.
                    // We activate it explicitly to avoid situation when roundoff-error
                    // prevents us from moving EXACTLY to x=CVal.
                    //
                    state.xc[cidx] = cval;
                }
                state.activeset[cidx] = 1;
                wasactivation = true;
            }
            for(i=0; i<=n-1; i++)
            {
                
                //
                // Post-check (some constraints may be activated because of numerical errors)
                //
                if( (state.hasbndl[i] && (double)(state.xc[i])<=(double)(state.bndl[i])) && (double)(state.xc[i])!=(double)(state.mtx[i]) )
                {
                    state.xc[i] = state.bndl[i];
                    state.activeset[i] = 1;
                    wasactivation = true;
                }
                if( (state.hasbndu[i] && (double)(state.xc[i])>=(double)(state.bndu[i])) && (double)(state.xc[i])!=(double)(state.mtx[i]) )
                {
                    state.xc[i] = state.bndu[i];
                    state.activeset[i] = 1;
                    wasactivation = true;
                }
            }
            
            //
            // Determine return status:
            // * -1 in case no constraints were activated
            // *  0 in case only "candidate" constraints were activated
            // * +1 in case at least one "non-candidate" constraint was activated
            //
            if( wasactivation )
            {
                
                //
                // Step activated one/several constraints, but sometimes it is spurious
                // activation - RecalculateConstraints() tells us that constraint is
                // inactive (negative Largrange multiplier), but step activates it
                // because of numerical noise.
                //
                // This block of code checks whether step activated truly new constraints
                // (ones which were not in the active set at the solution):
                //
                // * for non-boundary constraint it is enough to check that previous value
                //   of ActiveSet[i] is negative (=far from boundary), and new one is
                //   positive (=we are at the boundary, constraint is activated).
                //
                // * for boundary constraints previous criterion won't work. Each variable
                //   has two constraints, and simply checking their status is not enough -
                //   we have to correctly identify cases when we leave one boundary
                //   (PrevActiveSet[i]=0) and move to another boundary (ActiveSet[i]>0).
                //   Such cases can be identified if we compare previous X with new X.
                //
                // In case only "candidate" constraints were activated, result variable
                // is set to 0. In case at least one new constraint was activated, result
                // is set to 1.
                //
                result = 0;
                for(i=0; i<=n-1; i++)
                {
                    if( state.activeset[i]>0 && (double)(state.xc[i])!=(double)(state.mtx[i]) )
                    {
                        result = 1;
                    }
                }
                for(i=n; i<=n+state.nec+state.nic-1; i++)
                {
                    if( state.mtas[i]<0 && state.activeset[i]>0 )
                    {
                        result = 1;
                    }
                }
            }
            else
            {
                
                //
                // No activation, return -1
                //
                result = -1;
            }
            
            //
            // Invalidate basis
            //
            state.basisisready = false;
            return result;
        }


        /*************************************************************************
        This subroutine performs immediate activation of one constraint:
        * "immediate" means that we do not have to move to activate it
        * in case boundary constraint is activated, we enforce current point to be
          exactly at the boundary

        INPUT PARAMETERS:
            S       -   active set object
            CIdx    -   index of constraint, in [0,N+NEC+NIC).
                        This value is calculated by SASExploreDirection().
            CVal    -   for CIdx in [0,N) this field stores value which is
                        assigned to XC[CIdx] during activation. CVal is ignored in
                        other cases.
                        This value is calculated by SASExploreDirection().

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasimmediateactivation(sactiveset state,
            int cidx,
            double cval)
        {
            alglib.ap.assert(state.algostate==1, "SASMoveTo: is not in optimization mode");
            if( cidx<state.n )
            {
                state.xc[cidx] = cval;
            }
            state.activeset[cidx] = 1;
            state.basisisready = false;
        }


        /*************************************************************************
        This subroutine calculates descent direction subject to current active set.

        INPUT PARAMETERS:
            S       -   active set object
            G       -   array[N], gradient
            D       -   possibly prealocated buffer;
                        automatically resized if needed.
            
        OUTPUT PARAMETERS:
            D       -   descent direction projected onto current active set.
                        Components of D which correspond to active boundary
                        constraints are forced to be exactly zero.
                        In case D is non-zero, it is normalized to have unit norm.
                        
        NOTE: in  case active set has N  active  constraints  (or  more),  descent
              direction is forced to be exactly zero.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasconstraineddescent(sactiveset state,
            double[] g,
            ref double[] d)
        {
            alglib.ap.assert(state.algostate==1, "SASConstrainedDescent: is not in optimization mode");
            sasrebuildbasis(state);
            constraineddescent(state, g, state.unitdiagonal, state.ibasis, true, ref d);
        }


        /*************************************************************************
        This  subroutine  calculates  preconditioned  descent direction subject to
        current active set.

        INPUT PARAMETERS:
            S       -   active set object
            G       -   array[N], gradient
            D       -   possibly prealocated buffer;
                        automatically resized if needed.
            
        OUTPUT PARAMETERS:
            D       -   descent direction projected onto current active set.
                        Components of D which correspond to active boundary
                        constraints are forced to be exactly zero.
                        In case D is non-zero, it is normalized to have unit norm.
                        
        NOTE: in  case active set has N  active  constraints  (or  more),  descent
              direction is forced to be exactly zero.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasconstraineddescentprec(sactiveset state,
            double[] g,
            ref double[] d)
        {
            alglib.ap.assert(state.algostate==1, "SASConstrainedDescentPrec: is not in optimization mode");
            sasrebuildbasis(state);
            constraineddescent(state, g, state.h, state.pbasis, true, ref d);
        }


        /*************************************************************************
        This subroutine calculates projection   of  direction  vector  to  current
        active set.

        INPUT PARAMETERS:
            S       -   active set object
            D       -   array[N], direction
            
        OUTPUT PARAMETERS:
            D       -   direction projected onto current active set.
                        Components of D which correspond to active boundary
                        constraints are forced to be exactly zero.
                        
        NOTE: in  case active set has N  active  constraints  (or  more),  descent
              direction is forced to be exactly zero.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasconstraineddirection(sactiveset state,
            ref double[] d)
        {
            int i = 0;

            alglib.ap.assert(state.algostate==1, "SASConstrainedAntigradientPrec: is not in optimization mode");
            sasrebuildbasis(state);
            constraineddescent(state, d, state.unitdiagonal, state.ibasis, false, ref state.cdtmp);
            for(i=0; i<=state.n-1; i++)
            {
                d[i] = -state.cdtmp[i];
            }
        }


        /*************************************************************************
        This subroutine calculates product of direction vector and  preconditioner
        multiplied subject to current active set.

        INPUT PARAMETERS:
            S       -   active set object
            D       -   array[N], direction
            
        OUTPUT PARAMETERS:
            D       -   preconditioned direction projected onto current active set.
                        Components of D which correspond to active boundary
                        constraints are forced to be exactly zero.
                        
        NOTE: in  case active set has N  active  constraints  (or  more),  descent
              direction is forced to be exactly zero.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasconstraineddirectionprec(sactiveset state,
            ref double[] d)
        {
            int i = 0;

            alglib.ap.assert(state.algostate==1, "SASConstrainedAntigradientPrec: is not in optimization mode");
            sasrebuildbasis(state);
            constraineddescent(state, d, state.h, state.pbasis, false, ref state.cdtmp);
            for(i=0; i<=state.n-1; i++)
            {
                d[i] = -state.cdtmp[i];
            }
        }


        /*************************************************************************
        This  subroutine  performs  correction of some (possibly infeasible) point
        with respect to a) current active set, b) all boundary  constraints,  both
        active and inactive:

        0) we calculate L1 penalty term for violation of active linear constraints
           (one which is returned by SASActiveLCPenalty1() function).
        1) first, it performs projection (orthogonal with respect to scale  matrix
           S) of X into current active set: X -> X1.
        2) next, we perform projection with respect to  ALL  boundary  constraints
           which are violated at X1: X1 -> X2.
        3) X is replaced by X2.

        The idea is that this function can preserve and enforce feasibility during
        optimization, and additional penalty parameter can be used to prevent algo
        from leaving feasible set because of rounding errors.

        INPUT PARAMETERS:
            S       -   active set object
            X       -   array[N], candidate point
            
        OUTPUT PARAMETERS:
            X       -   "improved" candidate point:
                        a) feasible with respect to all boundary constraints
                        b) feasibility with respect to active set is retained at
                           good level.
            Penalty -   penalty term, which can be added to function value if user
                        wants to penalize violation of constraints (recommended).
                        
        NOTE: this function is not intended to find exact  projection  (i.e.  best
              approximation) of X into feasible set. It just improves situation  a
              bit.
              Regular  use  of   this function will help you to retain feasibility
              - if you already have something to start  with  and  constrain  your
              steps is such way that the only source of infeasibility are roundoff
              errors.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sascorrection(sactiveset state,
            double[] x,
            ref double penalty)
        {
            int i = 0;
            int j = 0;
            int n = 0;
            double v = 0;
            int i_ = 0;

            penalty = 0;

            alglib.ap.assert(state.algostate==1, "SASCorrection: is not in optimization mode");
            sasrebuildbasis(state);
            n = state.n;
            apserv.rvectorsetlengthatleast(ref state.corrtmp, n);
            
            //
            // Calculate penalty term.
            //
            penalty = sasactivelcpenalty1(state, x);
            
            //
            // Perform projection 1.
            //
            // This projecton is given by:
            //
            //     x_proj = x - S*S*As'*(As*x-b)
            //
            // where x is original x before projection, S is a scale matrix,
            // As is a matrix of equality constraints (active set) which were
            // orthogonalized with respect to inner product given by S (i.e. we
            // have As*S*S'*As'=I), b is a right part of the orthogonalized
            // constraints.
            //
            // NOTE: you can verify that x_proj is strictly feasible w.r.t.
            //       active set by multiplying it by As - you will get
            //       As*x_proj = As*x - As*x + b = b.
            //
            //       This formula for projection can be obtained by solving
            //       following minimization problem.
            //
            //           min ||inv(S)*(x_proj-x)||^2 s.t. As*x_proj=b
            //       
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.corrtmp[i_] = x[i_];
            }
            for(i=0; i<=state.basissize-1; i++)
            {
                v = -state.sbasis[i,n];
                for(j=0; j<=n-1; j++)
                {
                    v = v+state.sbasis[i,j]*state.corrtmp[j];
                }
                for(j=0; j<=n-1; j++)
                {
                    state.corrtmp[j] = state.corrtmp[j]-v*state.sbasis[i,j]*math.sqr(state.s[j]);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                if( state.activeset[i]>0 )
                {
                    state.corrtmp[i] = state.xc[i];
                }
            }
            
            //
            // Perform projection 2
            //
            for(i=0; i<=n-1; i++)
            {
                x[i] = state.corrtmp[i];
                if( state.hasbndl[i] && (double)(x[i])<(double)(state.bndl[i]) )
                {
                    x[i] = state.bndl[i];
                }
                if( state.hasbndu[i] && (double)(x[i])>(double)(state.bndu[i]) )
                {
                    x[i] = state.bndu[i];
                }
            }
        }


        /*************************************************************************
        This  subroutine returns L1 penalty for violation of active general linear
        constraints (violation of boundary or inactive linear constraints  is  not
        added to penalty).

        Penalty term is equal to:
            
            Penalty = SUM( Abs((C_i*x-R_i)/Alpha_i) )
            
        Here:
        * summation is performed for I=0...NEC+NIC-1, ActiveSet[N+I]>0
          (only for rows of CLEIC which are in active set)
        * C_i is I-th row of CLEIC
        * R_i is corresponding right part
        * S is a scale matrix
        * Alpha_i = ||S*C_i|| - is a scaling coefficient which "normalizes"
          I-th summation term according to its scale.

        INPUT PARAMETERS:
            S       -   active set object
            X       -   array[N], candidate point

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static double sasactivelcpenalty1(sactiveset state,
            double[] x)
        {
            double result = 0;
            int i = 0;
            int j = 0;
            int n = 0;
            int nec = 0;
            int nic = 0;
            double v = 0;
            double alpha = 0;
            double p = 0;

            alglib.ap.assert(state.algostate==1, "SASActiveLCPenalty1: is not in optimization mode");
            sasrebuildbasis(state);
            n = state.n;
            nec = state.nec;
            nic = state.nic;
            
            //
            // Calculate penalty term.
            //
            result = 0;
            for(i=0; i<=nec+nic-1; i++)
            {
                if( state.activeset[n+i]>0 )
                {
                    alpha = 0;
                    p = -state.cleic[i,n];
                    for(j=0; j<=n-1; j++)
                    {
                        v = state.cleic[i,j];
                        p = p+v*x[j];
                        alpha = alpha+math.sqr(v*state.s[j]);
                    }
                    alpha = Math.Sqrt(alpha);
                    if( (double)(alpha)!=(double)(0) )
                    {
                        result = result+Math.Abs(p/alpha);
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        This subroutine calculates scaled norm of  vector  after  projection  onto
        subspace of active constraints. Most often this function is used  to  test
        stopping conditions.

        INPUT PARAMETERS:
            S       -   active set object
            D       -   vector whose norm is calculated
            
        RESULT:
            Vector norm (after projection and scaling)
            
        NOTE: projection is performed first, scaling is performed after projection
                        
        NOTE: if we have N active constraints, zero value (exact zero) is returned

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static double sasscaledconstrainednorm(sactiveset state,
            double[] d)
        {
            double result = 0;
            int i = 0;
            int n = 0;
            double v = 0;
            int nactive = 0;
            int i_ = 0;

            alglib.ap.assert(state.algostate==1, "SASMoveTo: is not in optimization mode");
            n = state.n;
            apserv.rvectorsetlengthatleast(ref state.scntmp, n);
            
            //
            // Prepare basis (if needed)
            //
            sasrebuildbasis(state);
            
            //
            // Calculate descent direction
            //
            nactive = 0;
            for(i=0; i<=n-1; i++)
            {
                if( state.activeset[i]>0 )
                {
                    state.scntmp[i] = 0;
                    nactive = nactive+1;
                }
                else
                {
                    state.scntmp[i] = d[i];
                }
            }
            if( nactive+state.basissize>=n )
            {
                
                //
                // Quick exit if number of active constraints is N or larger
                //
                result = 0.0;
                return result;
            }
            for(i=0; i<=state.basissize-1; i++)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.ibasis[i,i_]*state.scntmp[i_];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    state.scntmp[i_] = state.scntmp[i_] - v*state.ibasis[i,i_];
                }
            }
            v = 0.0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.s[i]*state.scntmp[i]);
            }
            result = Math.Sqrt(v);
            return result;
        }


        /*************************************************************************
        This subroutine turns off optimization mode.

        INPUT PARAMETERS:
            S   -   active set object
            
        OUTPUT PARAMETERS:
            S   -   state is changed

        NOTE: this function can be called many times for optimizer which was
              already stopped.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasstopoptimization(sactiveset state)
        {
            state.algostate = 0;
        }


        /*************************************************************************
        This function recalculates constraints - activates  and  deactivates  them
        according to gradient value at current point. Algorithm  assumes  that  we
        want to make steepest descent step from  current  point;  constraints  are
        activated and deactivated in such way that we won't violate any constraint
        by steepest descent step.

        After call to this function active set is ready to  try  steepest  descent
        step (SASDescentDirection-SASExploreDirection-SASMoveTo).

        Only already "active" and "candidate" elements of ActiveSet are  examined;
        constraints which are not active are not examined.

        INPUT PARAMETERS:
            State       -   active set object
            GC          -   array[N], gradient at XC
            
        OUTPUT PARAMETERS:
            State       -   active set object, with new set of constraint

          -- ALGLIB --
             Copyright 26.09.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasreactivateconstraints(sactiveset state,
            double[] gc)
        {
            alglib.ap.assert(state.algostate==1, "SASReactivateConstraints: must be in optimization mode");
            reactivateconstraints(state, gc, state.unitdiagonal);
        }


        /*************************************************************************
        This function recalculates constraints - activates  and  deactivates  them
        according to gradient value at current point.

        Algorithm  assumes  that  we  want  to make Quasi-Newton step from current
        point with diagonal Quasi-Newton matrix H. Constraints are  activated  and
        deactivated in such way that we won't violate any constraint by step.

        After call to  this  function  active set is ready to  try  preconditioned
        steepest descent step (SASDescentDirection-SASExploreDirection-SASMoveTo).

        Only already "active" and "candidate" elements of ActiveSet are  examined;
        constraints which are not active are not examined.

        INPUT PARAMETERS:
            State       -   active set object
            GC          -   array[N], gradient at XC
            
        OUTPUT PARAMETERS:
            State       -   active set object, with new set of constraint

          -- ALGLIB --
             Copyright 26.09.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasreactivateconstraintsprec(sactiveset state,
            double[] gc)
        {
            alglib.ap.assert(state.algostate==1, "SASReactivateConstraintsPrec: must be in optimization mode");
            reactivateconstraints(state, gc, state.h);
        }


        /*************************************************************************
        This function builds three orthonormal basises for current active set:
        * P-orthogonal one, which is orthogonalized with inner product
          (x,y) = x'*P*y, where P=inv(H) is current preconditioner
        * S-orthogonal one, which is orthogonalized with inner product
          (x,y) = x'*S'*S*y, where S is diagonal scaling matrix
        * I-orthogonal one, which is orthogonalized with standard dot product

        NOTE: all sets of orthogonal vectors are guaranteed  to  have  same  size.
              P-orthogonal basis is built first, I/S-orthogonal basises are forced
              to have same number of vectors as P-orthogonal one (padded  by  zero
              vectors if needed).
              
        NOTE: this function tracks changes in active set; first call  will  result
              in reorthogonalization

        INPUT PARAMETERS:
            State   -   active set object
            H       -   diagonal preconditioner, H[i]>0

        OUTPUT PARAMETERS:
            State   -   active set object with new basis
            
          -- ALGLIB --
             Copyright 20.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void sasrebuildbasis(sactiveset state)
        {
            int n = 0;
            int nec = 0;
            int nic = 0;
            int i = 0;
            int j = 0;
            int t = 0;
            int nactivelin = 0;
            int nactivebnd = 0;
            double v = 0;
            double vmax = 0;
            int kmax = 0;
            int i_ = 0;

            if( state.basisisready )
            {
                return;
            }
            n = state.n;
            nec = state.nec;
            nic = state.nic;
            apserv.rmatrixsetlengthatleast(ref state.tmpbasis, nec+nic, n+1);
            state.basissize = 0;
            state.basisisready = true;
            
            //
            // Determine number of active boundary and non-boundary
            // constraints, move them to TmpBasis. Quick exit if no
            // non-boundary constraints were detected.
            //
            nactivelin = 0;
            nactivebnd = 0;
            for(i=0; i<=nec+nic-1; i++)
            {
                if( state.activeset[n+i]>0 )
                {
                    nactivelin = nactivelin+1;
                }
            }
            for(j=0; j<=n-1; j++)
            {
                if( state.activeset[j]>0 )
                {
                    nactivebnd = nactivebnd+1;
                }
            }
            if( nactivelin==0 )
            {
                return;
            }
            
            //
            // Orthogonalize linear constraints (inner product is given by preconditioner)
            // with respect to each other and boundary ones:
            // * normalize all constraints
            // * orthogonalize with respect to boundary ones
            // * repeat:
            //   * if basisSize+nactivebnd=n - TERMINATE
            //   * choose largest row from TmpBasis
            //   * if row norm is too small  - TERMINATE
            //   * add row to basis, normalize
            //   * remove from TmpBasis, orthogonalize other constraints with respect to this one
            //
            nactivelin = 0;
            for(i=0; i<=nec+nic-1; i++)
            {
                if( state.activeset[n+i]>0 )
                {
                    for(i_=0; i_<=n;i_++)
                    {
                        state.tmpbasis[nactivelin,i_] = state.cleic[i,i_];
                    }
                    nactivelin = nactivelin+1;
                }
            }
            for(i=0; i<=nactivelin-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+math.sqr(state.tmpbasis[i,j])/state.h[j];
                }
                if( (double)(v)>(double)(0) )
                {
                    v = 1/Math.Sqrt(v);
                    for(j=0; j<=n; j++)
                    {
                        state.tmpbasis[i,j] = state.tmpbasis[i,j]*v;
                    }
                }
            }
            for(j=0; j<=n-1; j++)
            {
                if( state.activeset[j]>0 )
                {
                    for(i=0; i<=nactivelin-1; i++)
                    {
                        state.tmpbasis[i,n] = state.tmpbasis[i,n]-state.tmpbasis[i,j]*state.xc[j];
                        state.tmpbasis[i,j] = 0.0;
                    }
                }
            }
            while( state.basissize+nactivebnd<n )
            {
                
                //
                // Find largest vector, add to basis
                //
                vmax = -1;
                kmax = -1;
                for(i=0; i<=nactivelin-1; i++)
                {
                    v = 0.0;
                    for(j=0; j<=n-1; j++)
                    {
                        v = v+math.sqr(state.tmpbasis[i,j])/state.h[j];
                    }
                    v = Math.Sqrt(v);
                    if( (double)(v)>(double)(vmax) )
                    {
                        vmax = v;
                        kmax = i;
                    }
                }
                if( (double)(vmax)<(double)(1.0E4*math.machineepsilon) )
                {
                    break;
                }
                v = 1/vmax;
                for(i_=0; i_<=n;i_++)
                {
                    state.pbasis[state.basissize,i_] = v*state.tmpbasis[kmax,i_];
                }
                state.basissize = state.basissize+1;
                
                //
                // Reorthogonalize other vectors with respect to chosen one.
                // Remove it from the array.
                //
                for(i=0; i<=nactivelin-1; i++)
                {
                    if( i!=kmax )
                    {
                        v = 0;
                        for(j=0; j<=n-1; j++)
                        {
                            v = v+state.pbasis[state.basissize-1,j]*state.tmpbasis[i,j]/state.h[j];
                        }
                        for(i_=0; i_<=n;i_++)
                        {
                            state.tmpbasis[i,i_] = state.tmpbasis[i,i_] - v*state.pbasis[state.basissize-1,i_];
                        }
                    }
                }
                for(j=0; j<=n; j++)
                {
                    state.tmpbasis[kmax,j] = 0;
                }
            }
            
            //
            // Orthogonalize linear constraints using traditional dot product
            // with respect to each other and boundary ones.
            //
            // NOTE: we force basis size to be equal to one which was computed
            //       at the previous step, with preconditioner-based inner product.
            //
            nactivelin = 0;
            for(i=0; i<=nec+nic-1; i++)
            {
                if( state.activeset[n+i]>0 )
                {
                    for(i_=0; i_<=n;i_++)
                    {
                        state.tmpbasis[nactivelin,i_] = state.cleic[i,i_];
                    }
                    nactivelin = nactivelin+1;
                }
            }
            for(i=0; i<=nactivelin-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+math.sqr(state.tmpbasis[i,j]);
                }
                if( (double)(v)>(double)(0) )
                {
                    v = 1/Math.Sqrt(v);
                    for(j=0; j<=n; j++)
                    {
                        state.tmpbasis[i,j] = state.tmpbasis[i,j]*v;
                    }
                }
            }
            for(j=0; j<=n-1; j++)
            {
                if( state.activeset[j]>0 )
                {
                    for(i=0; i<=nactivelin-1; i++)
                    {
                        state.tmpbasis[i,n] = state.tmpbasis[i,n]-state.tmpbasis[i,j]*state.xc[j];
                        state.tmpbasis[i,j] = 0.0;
                    }
                }
            }
            for(t=0; t<=state.basissize-1; t++)
            {
                
                //
                // Find largest vector, add to basis.
                //
                vmax = -1;
                kmax = -1;
                for(i=0; i<=nactivelin-1; i++)
                {
                    v = 0.0;
                    for(j=0; j<=n-1; j++)
                    {
                        v = v+math.sqr(state.tmpbasis[i,j]);
                    }
                    v = Math.Sqrt(v);
                    if( (double)(v)>(double)(vmax) )
                    {
                        vmax = v;
                        kmax = i;
                    }
                }
                if( (double)(vmax)==(double)(0) )
                {
                    for(j=0; j<=n; j++)
                    {
                        state.ibasis[t,j] = 0.0;
                    }
                    continue;
                }
                v = 1/vmax;
                for(i_=0; i_<=n;i_++)
                {
                    state.ibasis[t,i_] = v*state.tmpbasis[kmax,i_];
                }
                
                //
                // Reorthogonalize other vectors with respect to chosen one.
                // Remove it from the array.
                //
                for(i=0; i<=nactivelin-1; i++)
                {
                    if( i!=kmax )
                    {
                        v = 0;
                        for(j=0; j<=n-1; j++)
                        {
                            v = v+state.ibasis[t,j]*state.tmpbasis[i,j];
                        }
                        for(i_=0; i_<=n;i_++)
                        {
                            state.tmpbasis[i,i_] = state.tmpbasis[i,i_] - v*state.ibasis[t,i_];
                        }
                    }
                }
                for(j=0; j<=n; j++)
                {
                    state.tmpbasis[kmax,j] = 0;
                }
            }
            
            //
            // Orthogonalize linear constraints using inner product given by
            // scale matrix.
            //
            // NOTE: we force basis size to be equal to one which was computed
            //       with preconditioner-based inner product.
            //
            nactivelin = 0;
            for(i=0; i<=nec+nic-1; i++)
            {
                if( state.activeset[n+i]>0 )
                {
                    for(i_=0; i_<=n;i_++)
                    {
                        state.tmpbasis[nactivelin,i_] = state.cleic[i,i_];
                    }
                    nactivelin = nactivelin+1;
                }
            }
            for(i=0; i<=nactivelin-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+math.sqr(state.tmpbasis[i,j]*state.s[j]);
                }
                if( (double)(v)>(double)(0) )
                {
                    v = 1/Math.Sqrt(v);
                    for(j=0; j<=n; j++)
                    {
                        state.tmpbasis[i,j] = state.tmpbasis[i,j]*v;
                    }
                }
            }
            for(j=0; j<=n-1; j++)
            {
                if( state.activeset[j]>0 )
                {
                    for(i=0; i<=nactivelin-1; i++)
                    {
                        state.tmpbasis[i,n] = state.tmpbasis[i,n]-state.tmpbasis[i,j]*state.xc[j];
                        state.tmpbasis[i,j] = 0.0;
                    }
                }
            }
            for(t=0; t<=state.basissize-1; t++)
            {
                
                //
                // Find largest vector, add to basis.
                //
                vmax = -1;
                kmax = -1;
                for(i=0; i<=nactivelin-1; i++)
                {
                    v = 0.0;
                    for(j=0; j<=n-1; j++)
                    {
                        v = v+math.sqr(state.tmpbasis[i,j]*state.s[j]);
                    }
                    v = Math.Sqrt(v);
                    if( (double)(v)>(double)(vmax) )
                    {
                        vmax = v;
                        kmax = i;
                    }
                }
                if( (double)(vmax)==(double)(0) )
                {
                    for(j=0; j<=n; j++)
                    {
                        state.sbasis[t,j] = 0.0;
                    }
                    continue;
                }
                v = 1/vmax;
                for(i_=0; i_<=n;i_++)
                {
                    state.sbasis[t,i_] = v*state.tmpbasis[kmax,i_];
                }
                
                //
                // Reorthogonalize other vectors with respect to chosen one.
                // Remove it from the array.
                //
                for(i=0; i<=nactivelin-1; i++)
                {
                    if( i!=kmax )
                    {
                        v = 0;
                        for(j=0; j<=n-1; j++)
                        {
                            v = v+state.sbasis[t,j]*state.tmpbasis[i,j]*math.sqr(state.s[j]);
                        }
                        for(i_=0; i_<=n;i_++)
                        {
                            state.tmpbasis[i,i_] = state.tmpbasis[i,i_] - v*state.sbasis[t,i_];
                        }
                    }
                }
                for(j=0; j<=n; j++)
                {
                    state.tmpbasis[kmax,j] = 0;
                }
            }
        }


        /*************************************************************************
        This  subroutine  calculates  preconditioned  descent direction subject to
        current active set.

        INPUT PARAMETERS:
            State   -   active set object
            G       -   array[N], gradient
            H       -   array[N], Hessian matrix
            HA      -   active constraints orthogonalized in such way
                        that HA*inv(H)*HA'= I.
            Normalize-  whether we need normalized descent or not
            D       -   possibly preallocated buffer; automatically resized.
            
        OUTPUT PARAMETERS:
            D       -   descent direction projected onto current active set.
                        Components of D which correspond to active boundary
                        constraints are forced to be exactly zero.
                        In case D is non-zero and Normalize is True, it is
                        normalized to have unit norm.
                        
        NOTE: if we have N active constraints, D is explicitly set to zero.

          -- ALGLIB --
             Copyright 21.12.2012 by Bochkanov Sergey
        *************************************************************************/
        private static void constraineddescent(sactiveset state,
            double[] g,
            double[] h,
            double[,] ha,
            bool normalize,
            ref double[] d)
        {
            int i = 0;
            int j = 0;
            int n = 0;
            double v = 0;
            int nactive = 0;
            int i_ = 0;

            alglib.ap.assert(state.algostate==1, "SAS: internal error in ConstrainedDescent() - not in optimization mode");
            alglib.ap.assert(state.basisisready, "SAS: internal error in ConstrainedDescent() - no basis");
            n = state.n;
            apserv.rvectorsetlengthatleast(ref d, n);
            
            //
            // Calculate preconditioned constrained descent direction:
            //
            //     d := -inv(H)*( g - HA'*(HA*inv(H)*g) )
            //
            // Formula above always gives direction which is orthogonal to rows of HA.
            // You can verify it by multiplication of both sides by HA[i] (I-th row),
            // taking into account that HA*inv(H)*HA'= I (by definition of HA - it is
            // orthogonal basis with inner product given by inv(H)).
            //
            nactive = 0;
            for(i=0; i<=n-1; i++)
            {
                if( state.activeset[i]>0 )
                {
                    d[i] = 0;
                    nactive = nactive+1;
                }
                else
                {
                    d[i] = g[i];
                }
            }
            for(i=0; i<=state.basissize-1; i++)
            {
                v = 0.0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+ha[i,j]*d[j]/h[j];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    d[i_] = d[i_] - v*ha[i,i_];
                }
                nactive = nactive+1;
            }
            v = 0.0;
            for(i=0; i<=n-1; i++)
            {
                if( state.activeset[i]>0 )
                {
                    d[i] = 0;
                }
                else
                {
                    d[i] = -(d[i]/h[i]);
                    v = v+math.sqr(d[i]);
                }
            }
            v = Math.Sqrt(v);
            if( nactive>=n )
            {
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    d[i] = 0;
                }
            }
            if( normalize && (double)(v)>(double)(0) )
            {
                for(i=0; i<=n-1; i++)
                {
                    d[i] = d[i]/v;
                }
            }
        }


        /*************************************************************************
        This function recalculates constraints - activates  and  deactivates  them
        according to gradient value at current point.

        Algorithm  assumes  that  we  want  to make Quasi-Newton step from current
        point with diagonal Quasi-Newton matrix H. Constraints are  activated  and
        deactivated in such way that we won't violate any constraint by step.

        Only already "active" and "candidate" elements of ActiveSet are  examined;
        constraints which are not active are not examined.

        INPUT PARAMETERS:
            State       -   active set object
            GC          -   array[N], gradient at XC
            H           -   array[N], Hessian matrix
            
        OUTPUT PARAMETERS:
            State       -   active set object, with new set of constraint

          -- ALGLIB --
             Copyright 26.09.2012 by Bochkanov Sergey
        *************************************************************************/
        private static void reactivateconstraints(sactiveset state,
            double[] gc,
            double[] h)
        {
            int n = 0;
            int nec = 0;
            int nic = 0;
            int i = 0;
            int j = 0;
            int idx0 = 0;
            int idx1 = 0;
            double v = 0;
            int nactivebnd = 0;
            int nactivelin = 0;
            int nactiveconstraints = 0;
            double rowscale = 0;
            int i_ = 0;

            alglib.ap.assert(state.algostate==1, "SASReactivateConstraintsPrec: must be in optimization mode");
            
            //
            // Prepare
            //
            n = state.n;
            nec = state.nec;
            nic = state.nic;
            state.basisisready = false;
            
            //
            // Handle important special case - no linear constraints,
            // only boundary constraints are present
            //
            if( nec+nic==0 )
            {
                for(i=0; i<=n-1; i++)
                {
                    if( (state.hasbndl[i] && state.hasbndu[i]) && (double)(state.bndl[i])==(double)(state.bndu[i]) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                    if( (state.hasbndl[i] && (double)(state.xc[i])==(double)(state.bndl[i])) && (double)(gc[i])>=(double)(0) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                    if( (state.hasbndu[i] && (double)(state.xc[i])==(double)(state.bndu[i])) && (double)(gc[i])<=(double)(0) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                    state.activeset[i] = -1;
                }
                return;
            }
            
            //
            // General case.
            // Allocate temporaries.
            //
            apserv.rvectorsetlengthatleast(ref state.rctmpg, n);
            apserv.rvectorsetlengthatleast(ref state.rctmprightpart, n);
            apserv.rvectorsetlengthatleast(ref state.rctmps, n);
            apserv.rmatrixsetlengthatleast(ref state.rctmpdense0, n, nec+nic);
            apserv.rmatrixsetlengthatleast(ref state.rctmpdense1, n, nec+nic);
            apserv.bvectorsetlengthatleast(ref state.rctmpisequality, n+nec+nic);
            apserv.ivectorsetlengthatleast(ref state.rctmpconstraintidx, n+nec+nic);
            
            //
            // Calculate descent direction
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.rctmpg[i_] = -gc[i_];
            }
            
            //
            // Determine candidates to the active set.
            //
            // After this block constraints become either "inactive" (ActiveSet[i]<0)
            // or "candidates" (ActiveSet[i]=0). Previously active constraints always
            // become "candidates".
            //
            for(i=0; i<=n+nec+nic-1; i++)
            {
                if( state.activeset[i]>0 )
                {
                    state.activeset[i] = 0;
                }
                else
                {
                    state.activeset[i] = -1;
                }
            }
            nactiveconstraints = 0;
            nactivebnd = 0;
            nactivelin = 0;
            for(i=0; i<=n-1; i++)
            {
                
                //
                // Activate boundary constraints:
                // * copy constraint index to RCTmpConstraintIdx
                // * set corresponding element of ActiveSet[] to "candidate"
                // * fill RCTmpS by either +1 (lower bound) or -1 (upper bound)
                // * set RCTmpIsEquality to False (BndL<BndU) or True (BndL=BndU)
                // * increase counters
                //
                if( (state.hasbndl[i] && state.hasbndu[i]) && (double)(state.bndl[i])==(double)(state.bndu[i]) )
                {
                    
                    //
                    // Equality constraint is activated
                    //
                    state.rctmpconstraintidx[nactiveconstraints] = i;
                    state.activeset[i] = 0;
                    state.rctmps[i] = 1.0;
                    state.rctmpisequality[nactiveconstraints] = true;
                    nactiveconstraints = nactiveconstraints+1;
                    nactivebnd = nactivebnd+1;
                    continue;
                }
                if( state.hasbndl[i] && (double)(state.xc[i])==(double)(state.bndl[i]) )
                {
                    
                    //
                    // Lower bound is activated
                    //
                    state.rctmpconstraintidx[nactiveconstraints] = i;
                    state.activeset[i] = 0;
                    state.rctmps[i] = -1.0;
                    state.rctmpisequality[nactiveconstraints] = false;
                    nactiveconstraints = nactiveconstraints+1;
                    nactivebnd = nactivebnd+1;
                    continue;
                }
                if( state.hasbndu[i] && (double)(state.xc[i])==(double)(state.bndu[i]) )
                {
                    
                    //
                    // Upper bound is activated
                    //
                    state.rctmpconstraintidx[nactiveconstraints] = i;
                    state.activeset[i] = 0;
                    state.rctmps[i] = 1.0;
                    state.rctmpisequality[nactiveconstraints] = false;
                    nactiveconstraints = nactiveconstraints+1;
                    nactivebnd = nactivebnd+1;
                    continue;
                }
            }
            for(i=0; i<=nec+nic-1; i++)
            {
                if( i>=nec && state.activeset[n+i]<0 )
                {
                    
                    //
                    // Inequality constraints are skipped if both (a) constraint was
                    // not active, and (b) we are too far away from the boundary.
                    //
                    rowscale = 0.0;
                    v = -state.cleic[i,n];
                    for(j=0; j<=n-1; j++)
                    {
                        v = v+state.cleic[i,j]*state.xc[j];
                        rowscale = Math.Max(rowscale, Math.Abs(state.cleic[i,j]*state.s[j]));
                    }
                    if( (double)(v)<=(double)(-(1.0E5*math.machineepsilon*rowscale)) )
                    {
                        
                        //
                        // NOTE: it is important to check for non-strict inequality
                        //       because we have to correctly handle zero constraint
                        //       0*x<=0
                        //
                        continue;
                    }
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    state.rctmpdense0[i_,nactivelin] = state.cleic[i,i_];
                }
                state.rctmpconstraintidx[nactiveconstraints] = n+i;
                state.activeset[n+i] = 0;
                state.rctmpisequality[nactiveconstraints] = i<nec;
                nactiveconstraints = nactiveconstraints+1;
                nactivelin = nactivelin+1;
            }
            
            //
            // Skip if no "candidate" constraints was found
            //
            if( nactiveconstraints==0 )
            {
                for(i=0; i<=n-1; i++)
                {
                    if( (state.hasbndl[i] && state.hasbndu[i]) && (double)(state.bndl[i])==(double)(state.bndu[i]) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                    if( (state.hasbndl[i] && (double)(state.xc[i])==(double)(state.bndl[i])) && (double)(gc[i])>=(double)(0) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                    if( (state.hasbndu[i] && (double)(state.xc[i])==(double)(state.bndu[i])) && (double)(gc[i])<=(double)(0) )
                    {
                        state.activeset[i] = 1;
                        continue;
                    }
                }
                return;
            }
            
            //
            // General case.
            //
            // APPROACH TO CONSTRAINTS ACTIVATION/DEACTIVATION
            //
            // We have NActiveConstraints "candidates": NActiveBnd boundary candidates,
            // NActiveLin linear candidates. Indexes of boundary constraints are stored
            // in RCTmpConstraintIdx[0:NActiveBnd-1], indexes of linear ones are stored
            // in RCTmpConstraintIdx[NActiveBnd:NActiveBnd+NActiveLin-1]. Some of the
            // constraints are equality ones, some are inequality - as specified by 
            // RCTmpIsEquality[i].
            //
            // Now we have to determine active subset of "candidates" set. In order to
            // do so we solve following constrained minimization problem:
            //         (                         )^2
            //     min ( SUM(lambda[i]*A[i]) + G )
            //         (                         )
            // Here:
            // * G is a gradient (column vector)
            // * A[i] is a column vector, linear (left) part of I-th constraint.
            //   I=0..NActiveConstraints-1, first NActiveBnd elements of A are just
            //   subset of identity matrix (boundary constraints), next NActiveLin
            //   elements are subset of rows of the matrix of general linear constraints.
            // * lambda[i] is a Lagrange multiplier corresponding to I-th constraint
            //
            // NOTE: for preconditioned setting A is replaced by A*H^(-0.5), G is
            //       replaced by G*H^(-0.5). We apply this scaling at the last stage,
            //       before passing data to NNLS solver.
            //
            // Minimization is performed subject to non-negativity constraints on
            // lambda[i] corresponding to inequality constraints. Inequality constraints
            // which correspond to non-zero lambda are activated, equality constraints
            // are always considered active.
            //
            // Informally speaking, we "decompose" descent direction -G and represent
            // it as sum of constraint vectors and "residual" part (which is equal to
            // the actual descent direction subject to constraints).
            //
            // SOLUTION OF THE NNLS PROBLEM
            //
            // We solve this optimization problem with Non-Negative Least Squares solver,
            // which can efficiently solve least squares problems of the form
            //
            //         ( [ I | AU ]     )^2
            //     min ( [   |    ]*x-b )   s.t. non-negativity constraints on some x[i]
            //         ( [ 0 | AL ]     )
            //
            // In order to use this solver we have to rearrange rows of A[] and G in
            // such way that first NActiveBnd columns of A store identity matrix (before
            // sorting non-zero elements are randomly distributed in the first NActiveBnd
            // columns of A, during sorting we move them to first NActiveBnd rows).
            //
            // Then we create instance of NNLS solver (we reuse instance left from the
            // previous run of the optimization problem) and solve NNLS problem.
            //
            idx0 = 0;
            idx1 = nactivebnd;
            for(i=0; i<=n-1; i++)
            {
                if( state.activeset[i]>=0 )
                {
                    v = 1/Math.Sqrt(h[i]);
                    for(j=0; j<=nactivelin-1; j++)
                    {
                        state.rctmpdense1[idx0,j] = state.rctmpdense0[i,j]/state.rctmps[i]*v;
                    }
                    state.rctmprightpart[idx0] = state.rctmpg[i]/state.rctmps[i]*v;
                    idx0 = idx0+1;
                }
                else
                {
                    v = 1/Math.Sqrt(h[i]);
                    for(j=0; j<=nactivelin-1; j++)
                    {
                        state.rctmpdense1[idx1,j] = state.rctmpdense0[i,j]*v;
                    }
                    state.rctmprightpart[idx1] = state.rctmpg[i]*v;
                    idx1 = idx1+1;
                }
            }
            snnls.snnlsinit(n, nec+nic, n, state.solver);
            snnls.snnlssetproblem(state.solver, state.rctmpdense1, state.rctmprightpart, nactivebnd, nactiveconstraints-nactivebnd, n);
            for(i=0; i<=nactiveconstraints-1; i++)
            {
                if( state.rctmpisequality[i] )
                {
                    snnls.snnlsdropnnc(state.solver, i);
                }
            }
            snnls.snnlssolve(state.solver, ref state.rctmplambdas);
            
            //
            // After solution of the problem we activate equality constraints (always active)
            // and inequality constraints with non-zero Lagrange multipliers. Then we reorthogonalize
            // active constraints.
            //
            for(i=0; i<=n+nec+nic-1; i++)
            {
                state.activeset[i] = -1;
            }
            for(i=0; i<=nactiveconstraints-1; i++)
            {
                if( state.rctmpisequality[i] || (double)(state.rctmplambdas[i])>(double)(0) )
                {
                    state.activeset[state.rctmpconstraintidx[i]] = 1;
                }
                else
                {
                    state.activeset[state.rctmpconstraintidx[i]] = 0;
                }
            }
            sasrebuildbasis(state);
        }


    }
    public class mincg
    {
        /*************************************************************************
        This object stores state of the nonlinear CG optimizer.

        You should use ALGLIB functions to work with this object.
        *************************************************************************/
        public class mincgstate : apobject
        {
            public int n;
            public double epsg;
            public double epsf;
            public double epsx;
            public int maxits;
            public double stpmax;
            public double suggestedstep;
            public bool xrep;
            public bool drep;
            public int cgtype;
            public int prectype;
            public double[] diagh;
            public double[] diaghl2;
            public double[,] vcorr;
            public int vcnt;
            public double[] s;
            public double diffstep;
            public int nfev;
            public int mcstage;
            public int k;
            public double[] xk;
            public double[] dk;
            public double[] xn;
            public double[] dn;
            public double[] d;
            public double fold;
            public double stp;
            public double curstpmax;
            public double[] yk;
            public double lastgoodstep;
            public double lastscaledstep;
            public int mcinfo;
            public bool innerresetneeded;
            public bool terminationneeded;
            public double trimthreshold;
            public int rstimer;
            public double[] x;
            public double f;
            public double[] g;
            public bool needf;
            public bool needfg;
            public bool xupdated;
            public bool algpowerup;
            public bool lsstart;
            public bool lsend;
            public bool userterminationneeded;
            public double teststep;
            public rcommstate rstate;
            public int repiterationscount;
            public int repnfev;
            public int repvaridx;
            public int repterminationtype;
            public int debugrestartscount;
            public linmin.linminstate lstate;
            public double fbase;
            public double fm2;
            public double fm1;
            public double fp1;
            public double fp2;
            public double betahs;
            public double betady;
            public double[] work0;
            public double[] work1;
            public mincgstate()
            {
                init();
            }
            public override void init()
            {
                diagh = new double[0];
                diaghl2 = new double[0];
                vcorr = new double[0,0];
                s = new double[0];
                xk = new double[0];
                dk = new double[0];
                xn = new double[0];
                dn = new double[0];
                d = new double[0];
                yk = new double[0];
                x = new double[0];
                g = new double[0];
                rstate = new rcommstate();
                lstate = new linmin.linminstate();
                work0 = new double[0];
                work1 = new double[0];
            }
            public override alglib.apobject make_copy()
            {
                mincgstate _result = new mincgstate();
                _result.n = n;
                _result.epsg = epsg;
                _result.epsf = epsf;
                _result.epsx = epsx;
                _result.maxits = maxits;
                _result.stpmax = stpmax;
                _result.suggestedstep = suggestedstep;
                _result.xrep = xrep;
                _result.drep = drep;
                _result.cgtype = cgtype;
                _result.prectype = prectype;
                _result.diagh = (double[])diagh.Clone();
                _result.diaghl2 = (double[])diaghl2.Clone();
                _result.vcorr = (double[,])vcorr.Clone();
                _result.vcnt = vcnt;
                _result.s = (double[])s.Clone();
                _result.diffstep = diffstep;
                _result.nfev = nfev;
                _result.mcstage = mcstage;
                _result.k = k;
                _result.xk = (double[])xk.Clone();
                _result.dk = (double[])dk.Clone();
                _result.xn = (double[])xn.Clone();
                _result.dn = (double[])dn.Clone();
                _result.d = (double[])d.Clone();
                _result.fold = fold;
                _result.stp = stp;
                _result.curstpmax = curstpmax;
                _result.yk = (double[])yk.Clone();
                _result.lastgoodstep = lastgoodstep;
                _result.lastscaledstep = lastscaledstep;
                _result.mcinfo = mcinfo;
                _result.innerresetneeded = innerresetneeded;
                _result.terminationneeded = terminationneeded;
                _result.trimthreshold = trimthreshold;
                _result.rstimer = rstimer;
                _result.x = (double[])x.Clone();
                _result.f = f;
                _result.g = (double[])g.Clone();
                _result.needf = needf;
                _result.needfg = needfg;
                _result.xupdated = xupdated;
                _result.algpowerup = algpowerup;
                _result.lsstart = lsstart;
                _result.lsend = lsend;
                _result.userterminationneeded = userterminationneeded;
                _result.teststep = teststep;
                _result.rstate = (rcommstate)rstate.make_copy();
                _result.repiterationscount = repiterationscount;
                _result.repnfev = repnfev;
                _result.repvaridx = repvaridx;
                _result.repterminationtype = repterminationtype;
                _result.debugrestartscount = debugrestartscount;
                _result.lstate = (linmin.linminstate)lstate.make_copy();
                _result.fbase = fbase;
                _result.fm2 = fm2;
                _result.fm1 = fm1;
                _result.fp1 = fp1;
                _result.fp2 = fp2;
                _result.betahs = betahs;
                _result.betady = betady;
                _result.work0 = (double[])work0.Clone();
                _result.work1 = (double[])work1.Clone();
                return _result;
            }
        };


        /*************************************************************************
        This structure stores optimization report:
        * IterationsCount           total number of inner iterations
        * NFEV                      number of gradient evaluations
        * TerminationType           termination type (see below)

        TERMINATION CODES

        TerminationType field contains completion code, which can be:
          -8    internal integrity control detected  infinite  or  NAN  values  in
                function/gradient. Abnormal termination signalled.
          -7    gradient verification failed.
                See MinCGSetGradientCheck() for more information.
           1    relative function improvement is no more than EpsF.
           2    relative step is no more than EpsX.
           4    gradient norm is no more than EpsG
           5    MaxIts steps was taken
           7    stopping conditions are too stringent,
                further improvement is impossible,
                X contains best point found so far.
           8    terminated by user who called mincgrequesttermination(). X contains
                point which was "current accepted" when  termination  request  was
                submitted.
                
        Other fields of this structure are not documented and should not be used!
        *************************************************************************/
        public class mincgreport : apobject
        {
            public int iterationscount;
            public int nfev;
            public int varidx;
            public int terminationtype;
            public mincgreport()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                mincgreport _result = new mincgreport();
                _result.iterationscount = iterationscount;
                _result.nfev = nfev;
                _result.varidx = varidx;
                _result.terminationtype = terminationtype;
                return _result;
            }
        };




        public const int rscountdownlen = 10;
        public const double gtol = 0.3;


        /*************************************************************************
                NONLINEAR CONJUGATE GRADIENT METHOD

        DESCRIPTION:
        The subroutine minimizes function F(x) of N arguments by using one of  the
        nonlinear conjugate gradient methods.

        These CG methods are globally convergent (even on non-convex functions) as
        long as grad(f) is Lipschitz continuous in  a  some  neighborhood  of  the
        L = { x : f(x)<=f(x0) }.


        REQUIREMENTS:
        Algorithm will request following information during its operation:
        * function value F and its gradient G (simultaneously) at given point X


        USAGE:
        1. User initializes algorithm state with MinCGCreate() call
        2. User tunes solver parameters with MinCGSetCond(), MinCGSetStpMax() and
           other functions
        3. User calls MinCGOptimize() function which takes algorithm  state   and
           pointer (delegate, etc.) to callback function which calculates F/G.
        4. User calls MinCGResults() to get solution
        5. Optionally, user may call MinCGRestartFrom() to solve another  problem
           with same N but another starting point and/or another function.
           MinCGRestartFrom() allows to reuse already initialized structure.


        INPUT PARAMETERS:
            N       -   problem dimension, N>0:
                        * if given, only leading N elements of X are used
                        * if not given, automatically determined from size of X
            X       -   starting point, array[0..N-1].

        OUTPUT PARAMETERS:
            State   -   structure which stores algorithm state

          -- ALGLIB --
             Copyright 25.03.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgcreate(int n,
            double[] x,
            mincgstate state)
        {
            alglib.ap.assert(n>=1, "MinCGCreate: N too small!");
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinCGCreate: Length(X)<N!");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinCGCreate: X contains infinite or NaN values!");
            mincginitinternal(n, 0.0, state);
            mincgrestartfrom(state, x);
        }


        /*************************************************************************
        The subroutine is finite difference variant of MinCGCreate(). It uses
        finite differences in order to differentiate target function.

        Description below contains information which is specific to this function
        only. We recommend to read comments on MinCGCreate() in order to get more
        information about creation of CG optimizer.

        INPUT PARAMETERS:
            N       -   problem dimension, N>0:
                        * if given, only leading N elements of X are used
                        * if not given, automatically determined from size of X
            X       -   starting point, array[0..N-1].
            DiffStep-   differentiation step, >0

        OUTPUT PARAMETERS:
            State   -   structure which stores algorithm state

        NOTES:
        1. algorithm uses 4-point central formula for differentiation.
        2. differentiation step along I-th axis is equal to DiffStep*S[I] where
           S[] is scaling vector which can be set by MinCGSetScale() call.
        3. we recommend you to use moderate values of  differentiation  step.  Too
           large step will result in too large truncation  errors, while too small
           step will result in too large numerical  errors.  1.0E-6  can  be  good
           value to start with.
        4. Numerical  differentiation  is   very   inefficient  -   one   gradient
           calculation needs 4*N function evaluations. This function will work for
           any N - either small (1...10), moderate (10...100) or  large  (100...).
           However, performance penalty will be too severe for any N's except  for
           small ones.
           We should also say that code which relies on numerical  differentiation
           is  less  robust  and  precise.  L-BFGS  needs  exact  gradient values.
           Imprecise  gradient may slow down  convergence,  especially  on  highly
           nonlinear problems.
           Thus  we  recommend to use this function for fast prototyping on small-
           dimensional problems only, and to implement analytical gradient as soon
           as possible.

          -- ALGLIB --
             Copyright 16.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgcreatef(int n,
            double[] x,
            double diffstep,
            mincgstate state)
        {
            alglib.ap.assert(n>=1, "MinCGCreateF: N too small!");
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinCGCreateF: Length(X)<N!");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinCGCreateF: X contains infinite or NaN values!");
            alglib.ap.assert(math.isfinite(diffstep), "MinCGCreateF: DiffStep is infinite or NaN!");
            alglib.ap.assert((double)(diffstep)>(double)(0), "MinCGCreateF: DiffStep is non-positive!");
            mincginitinternal(n, diffstep, state);
            mincgrestartfrom(state, x);
        }


        /*************************************************************************
        This function sets stopping conditions for CG optimization algorithm.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            EpsG    -   >=0
                        The  subroutine  finishes  its  work   if   the  condition
                        |v|<EpsG is satisfied, where:
                        * |.| means Euclidian norm
                        * v - scaled gradient vector, v[i]=g[i]*s[i]
                        * g - gradient
                        * s - scaling coefficients set by MinCGSetScale()
            EpsF    -   >=0
                        The  subroutine  finishes  its work if on k+1-th iteration
                        the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                        is satisfied.
            EpsX    -   >=0
                        The subroutine finishes its work if  on  k+1-th  iteration
                        the condition |v|<=EpsX is fulfilled, where:
                        * |.| means Euclidian norm
                        * v - scaled step vector, v[i]=dx[i]/s[i]
                        * dx - ste pvector, dx=X(k+1)-X(k)
                        * s - scaling coefficients set by MinCGSetScale()
            MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                        iterations is unlimited.

        Passing EpsG=0, EpsF=0, EpsX=0 and MaxIts=0 (simultaneously) will lead to
        automatic stopping criterion selection (small EpsX).

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetcond(mincgstate state,
            double epsg,
            double epsf,
            double epsx,
            int maxits)
        {
            alglib.ap.assert(math.isfinite(epsg), "MinCGSetCond: EpsG is not finite number!");
            alglib.ap.assert((double)(epsg)>=(double)(0), "MinCGSetCond: negative EpsG!");
            alglib.ap.assert(math.isfinite(epsf), "MinCGSetCond: EpsF is not finite number!");
            alglib.ap.assert((double)(epsf)>=(double)(0), "MinCGSetCond: negative EpsF!");
            alglib.ap.assert(math.isfinite(epsx), "MinCGSetCond: EpsX is not finite number!");
            alglib.ap.assert((double)(epsx)>=(double)(0), "MinCGSetCond: negative EpsX!");
            alglib.ap.assert(maxits>=0, "MinCGSetCond: negative MaxIts!");
            if( (((double)(epsg)==(double)(0) && (double)(epsf)==(double)(0)) && (double)(epsx)==(double)(0)) && maxits==0 )
            {
                epsx = 1.0E-6;
            }
            state.epsg = epsg;
            state.epsf = epsf;
            state.epsx = epsx;
            state.maxits = maxits;
        }


        /*************************************************************************
        This function sets scaling coefficients for CG optimizer.

        ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
        size and gradient are scaled before comparison with tolerances).  Scale of
        the I-th variable is a translation invariant measure of:
        a) "how large" the variable is
        b) how large the step should be to make significant changes in the function

        Scaling is also used by finite difference variant of CG optimizer  -  step
        along I-th axis is equal to DiffStep*S[I].

        In   most   optimizers  (and  in  the  CG  too)  scaling is NOT a form  of
        preconditioning. It just  affects  stopping  conditions.  You  should  set
        preconditioner by separate call to one of the MinCGSetPrec...() functions.

        There  is  special  preconditioning  mode, however,  which  uses   scaling
        coefficients to form diagonal preconditioning matrix. You  can  turn  this
        mode on, if you want.   But  you should understand that scaling is not the
        same thing as preconditioning - these are two different, although  related
        forms of tuning solver.

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            S       -   array[N], non-zero scaling coefficients
                        S[i] may be negative, sign doesn't matter.

          -- ALGLIB --
             Copyright 14.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetscale(mincgstate state,
            double[] s)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(s)>=state.n, "MinCGSetScale: Length(S)<N");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(s[i]), "MinCGSetScale: S contains infinite or NAN elements");
                alglib.ap.assert((double)(s[i])!=(double)(0), "MinCGSetScale: S contains zero elements");
                state.s[i] = Math.Abs(s[i]);
            }
        }


        /*************************************************************************
        This function turns on/off reporting.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            NeedXRep-   whether iteration reports are needed or not

        If NeedXRep is True, algorithm will call rep() callback function if  it is
        provided to MinCGOptimize().

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetxrep(mincgstate state,
            bool needxrep)
        {
            state.xrep = needxrep;
        }


        /*************************************************************************
        This function turns on/off line search reports.
        These reports are described in more details in developer-only  comments on
        MinCGState object.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            NeedDRep-   whether line search reports are needed or not

        This function is intended for private use only. Turning it on artificially
        may cause program failure.

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetdrep(mincgstate state,
            bool needdrep)
        {
            state.drep = needdrep;
        }


        /*************************************************************************
        This function sets CG algorithm.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            CGType  -   algorithm type:
                        * -1    automatic selection of the best algorithm
                        * 0     DY (Dai and Yuan) algorithm
                        * 1     Hybrid DY-HS algorithm

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetcgtype(mincgstate state,
            int cgtype)
        {
            alglib.ap.assert(cgtype>=-1 && cgtype<=1, "MinCGSetCGType: incorrect CGType!");
            if( cgtype==-1 )
            {
                cgtype = 1;
            }
            state.cgtype = cgtype;
        }


        /*************************************************************************
        This function sets maximum step length

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            StpMax  -   maximum step length, >=0. Set StpMax to 0.0,  if you don't
                        want to limit step length.

        Use this subroutine when you optimize target function which contains exp()
        or  other  fast  growing  functions,  and optimization algorithm makes too
        large  steps  which  leads  to overflow. This function allows us to reject
        steps  that  are  too  large  (and  therefore  expose  us  to the possible
        overflow) without actually calculating function value at the x+stp*d.

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetstpmax(mincgstate state,
            double stpmax)
        {
            alglib.ap.assert(math.isfinite(stpmax), "MinCGSetStpMax: StpMax is not finite!");
            alglib.ap.assert((double)(stpmax)>=(double)(0), "MinCGSetStpMax: StpMax<0!");
            state.stpmax = stpmax;
        }


        /*************************************************************************
        This function allows to suggest initial step length to the CG algorithm.

        Suggested  step  length  is used as starting point for the line search. It
        can be useful when you have  badly  scaled  problem,  i.e.  when  ||grad||
        (which is used as initial estimate for the first step) is many  orders  of
        magnitude different from the desired step.

        Line search  may  fail  on  such problems without good estimate of initial
        step length. Imagine, for example, problem with ||grad||=10^50 and desired
        step equal to 0.1 Line  search function will use 10^50  as  initial  step,
        then  it  will  decrease step length by 2 (up to 20 attempts) and will get
        10^44, which is still too large.

        This function allows us to tell than line search should  be  started  from
        some moderate step length, like 1.0, so algorithm will be able  to  detect
        desired step length in a several searches.

        Default behavior (when no step is suggested) is to use preconditioner,  if
        it is available, to generate initial estimate of step length.

        This function influences only first iteration of algorithm. It  should  be
        called between MinCGCreate/MinCGRestartFrom() call and MinCGOptimize call.
        Suggested step is ignored if you have preconditioner.

        INPUT PARAMETERS:
            State   -   structure used to store algorithm state.
            Stp     -   initial estimate of the step length.
                        Can be zero (no estimate).

          -- ALGLIB --
             Copyright 30.07.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsuggeststep(mincgstate state,
            double stp)
        {
            alglib.ap.assert(math.isfinite(stp), "MinCGSuggestStep: Stp is infinite or NAN");
            alglib.ap.assert((double)(stp)>=(double)(0), "MinCGSuggestStep: Stp<0");
            state.suggestedstep = stp;
        }


        /*************************************************************************
        This developer-only function allows to retrieve  unscaled  (!)  length  of
        last good step (i.e. step which resulted in sufficient decrease of  target
        function).

        It can be used in for solution  of  sequential  optimization  subproblems,
        where MinCGSuggestStep()  is  called  with  length  of  previous  step  as
        parameter.

        INPUT PARAMETERS:
            State   -   structure used to store algorithm state.
            
        RESULT:
            length of last good step being accepted
            
        NOTE:
            result of this function is undefined if you called it before

          -- ALGLIB --
             Copyright 30.07.2010 by Bochkanov Sergey
        *************************************************************************/
        public static double mincglastgoodstep(mincgstate state)
        {
            double result = 0;

            result = state.lastgoodstep;
            return result;
        }


        /*************************************************************************
        Modification of the preconditioner: preconditioning is turned off.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

        NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
        iterations.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetprecdefault(mincgstate state)
        {
            state.prectype = 0;
            state.innerresetneeded = true;
        }


        /*************************************************************************
        Modification  of  the  preconditioner:  diagonal of approximate Hessian is
        used.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            D       -   diagonal of the approximate Hessian, array[0..N-1],
                        (if larger, only leading N elements are used).

        NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
        iterations.

        NOTE 2: D[i] should be positive. Exception will be thrown otherwise.

        NOTE 3: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetprecdiag(mincgstate state,
            double[] d)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(d)>=state.n, "MinCGSetPrecDiag: D is too short");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(d[i]), "MinCGSetPrecDiag: D contains infinite or NAN elements");
                alglib.ap.assert((double)(d[i])>(double)(0), "MinCGSetPrecDiag: D contains non-positive elements");
            }
            mincgsetprecdiagfast(state, d);
        }


        /*************************************************************************
        Modification of the preconditioner: scale-based diagonal preconditioning.

        This preconditioning mode can be useful when you  don't  have  approximate
        diagonal of Hessian, but you know that your  variables  are  badly  scaled
        (for  example,  one  variable is in [1,10], and another in [1000,100000]),
        and most part of the ill-conditioning comes from different scales of vars.

        In this case simple  scale-based  preconditioner,  with H[i] = 1/(s[i]^2),
        can greatly improve convergence.

        IMPRTANT: you should set scale of your variables with MinCGSetScale() call
        (before or after MinCGSetPrecScale() call). Without knowledge of the scale
        of your variables scale-based preconditioner will be just unit matrix.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

        NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
        iterations.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetprecscale(mincgstate state)
        {
            state.prectype = 3;
            state.innerresetneeded = true;
        }


        /*************************************************************************
        NOTES:

        1. This function has two different implementations: one which  uses  exact
           (analytical) user-supplied  gradient, and one which uses function value
           only  and  numerically  differentiates  function  in  order  to  obtain
           gradient.
           
           Depending  on  the  specific  function  used to create optimizer object
           (either MinCGCreate()  for analytical gradient  or  MinCGCreateF()  for
           numerical differentiation) you should  choose  appropriate  variant  of
           MinCGOptimize() - one which accepts function AND gradient or one  which
           accepts function ONLY.

           Be careful to choose variant of MinCGOptimize()  which  corresponds  to
           your optimization scheme! Table below lists different  combinations  of
           callback (function/gradient) passed  to  MinCGOptimize()  and  specific
           function used to create optimizer.
           

                          |         USER PASSED TO MinCGOptimize()
           CREATED WITH   |  function only   |  function and gradient
           ------------------------------------------------------------
           MinCGCreateF() |     work                FAIL
           MinCGCreate()  |     FAIL                work

           Here "FAIL" denotes inappropriate combinations  of  optimizer  creation
           function and MinCGOptimize() version. Attemps to use  such  combination
           (for  example,  to create optimizer with  MinCGCreateF()  and  to  pass
           gradient information to MinCGOptimize()) will lead to  exception  being
           thrown. Either  you  did  not  pass  gradient when it WAS needed or you
           passed gradient when it was NOT needed.

          -- ALGLIB --
             Copyright 20.04.2009 by Bochkanov Sergey
        *************************************************************************/
        public static bool mincgiteration(mincgstate state)
        {
            bool result = new bool();
            int n = 0;
            int i = 0;
            double betak = 0;
            double v = 0;
            double vv = 0;
            int i_ = 0;

            
            //
            // Reverse communication preparations
            // I know it looks ugly, but it works the same way
            // anywhere from C++ to Python.
            //
            // This code initializes locals by:
            // * random values determined during code
            //   generation - on first subroutine call
            // * values from previous call - on subsequent calls
            //
            if( state.rstate.stage>=0 )
            {
                n = state.rstate.ia[0];
                i = state.rstate.ia[1];
                betak = state.rstate.ra[0];
                v = state.rstate.ra[1];
                vv = state.rstate.ra[2];
            }
            else
            {
                n = -983;
                i = -989;
                betak = -834;
                v = 900;
                vv = -287;
            }
            if( state.rstate.stage==0 )
            {
                goto lbl_0;
            }
            if( state.rstate.stage==1 )
            {
                goto lbl_1;
            }
            if( state.rstate.stage==2 )
            {
                goto lbl_2;
            }
            if( state.rstate.stage==3 )
            {
                goto lbl_3;
            }
            if( state.rstate.stage==4 )
            {
                goto lbl_4;
            }
            if( state.rstate.stage==5 )
            {
                goto lbl_5;
            }
            if( state.rstate.stage==6 )
            {
                goto lbl_6;
            }
            if( state.rstate.stage==7 )
            {
                goto lbl_7;
            }
            if( state.rstate.stage==8 )
            {
                goto lbl_8;
            }
            if( state.rstate.stage==9 )
            {
                goto lbl_9;
            }
            if( state.rstate.stage==10 )
            {
                goto lbl_10;
            }
            if( state.rstate.stage==11 )
            {
                goto lbl_11;
            }
            if( state.rstate.stage==12 )
            {
                goto lbl_12;
            }
            if( state.rstate.stage==13 )
            {
                goto lbl_13;
            }
            if( state.rstate.stage==14 )
            {
                goto lbl_14;
            }
            if( state.rstate.stage==15 )
            {
                goto lbl_15;
            }
            if( state.rstate.stage==16 )
            {
                goto lbl_16;
            }
            if( state.rstate.stage==17 )
            {
                goto lbl_17;
            }
            if( state.rstate.stage==18 )
            {
                goto lbl_18;
            }
            if( state.rstate.stage==19 )
            {
                goto lbl_19;
            }
            
            //
            // Routine body
            //
            
            //
            // Prepare
            //
            n = state.n;
            state.terminationneeded = false;
            state.userterminationneeded = false;
            state.repterminationtype = 0;
            state.repiterationscount = 0;
            state.repvaridx = -1;
            state.repnfev = 0;
            state.debugrestartscount = 0;
            
            //
            //  Check, that transferred derivative value is right
            //
            clearrequestfields(state);
            if( !((double)(state.diffstep)==(double)(0) && (double)(state.teststep)>(double)(0)) )
            {
                goto lbl_20;
            }
            state.needfg = true;
            i = 0;
        lbl_22:
            if( i>n-1 )
            {
                goto lbl_24;
            }
            v = state.x[i];
            state.x[i] = v-state.teststep*state.s[i];
            state.rstate.stage = 0;
            goto lbl_rcomm;
        lbl_0:
            state.fm1 = state.f;
            state.fp1 = state.g[i];
            state.x[i] = v+state.teststep*state.s[i];
            state.rstate.stage = 1;
            goto lbl_rcomm;
        lbl_1:
            state.fm2 = state.f;
            state.fp2 = state.g[i];
            state.x[i] = v;
            state.rstate.stage = 2;
            goto lbl_rcomm;
        lbl_2:
            
            //
            // 2*State.TestStep   -   scale parameter
            // width of segment [Xi-TestStep;Xi+TestStep]
            //
            if( !optserv.derivativecheck(state.fm1, state.fp1, state.fm2, state.fp2, state.f, state.g[i], 2*state.teststep) )
            {
                state.repvaridx = i;
                state.repterminationtype = -7;
                result = false;
                return result;
            }
            i = i+1;
            goto lbl_22;
        lbl_24:
            state.needfg = false;
        lbl_20:
            
            //
            // Preparations continue:
            // * set XK
            // * calculate F/G
            // * set DK to -G
            // * powerup algo (it may change preconditioner)
            // * apply preconditioner to DK
            // * report update of X
            // * check stopping conditions for G
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.xk[i_] = state.x[i_];
            }
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_25;
            }
            state.needfg = true;
            state.rstate.stage = 3;
            goto lbl_rcomm;
        lbl_3:
            state.needfg = false;
            goto lbl_26;
        lbl_25:
            state.needf = true;
            state.rstate.stage = 4;
            goto lbl_rcomm;
        lbl_4:
            state.fbase = state.f;
            i = 0;
        lbl_27:
            if( i>n-1 )
            {
                goto lbl_29;
            }
            v = state.x[i];
            state.x[i] = v-state.diffstep*state.s[i];
            state.rstate.stage = 5;
            goto lbl_rcomm;
        lbl_5:
            state.fm2 = state.f;
            state.x[i] = v-0.5*state.diffstep*state.s[i];
            state.rstate.stage = 6;
            goto lbl_rcomm;
        lbl_6:
            state.fm1 = state.f;
            state.x[i] = v+0.5*state.diffstep*state.s[i];
            state.rstate.stage = 7;
            goto lbl_rcomm;
        lbl_7:
            state.fp1 = state.f;
            state.x[i] = v+state.diffstep*state.s[i];
            state.rstate.stage = 8;
            goto lbl_rcomm;
        lbl_8:
            state.fp2 = state.f;
            state.x[i] = v;
            state.g[i] = (8*(state.fp1-state.fm1)-(state.fp2-state.fm2))/(6*state.diffstep*state.s[i]);
            i = i+1;
            goto lbl_27;
        lbl_29:
            state.f = state.fbase;
            state.needf = false;
        lbl_26:
            if( !state.drep )
            {
                goto lbl_30;
            }
            
            //
            // Report algorithm powerup (if needed)
            //
            clearrequestfields(state);
            state.algpowerup = true;
            state.rstate.stage = 9;
            goto lbl_rcomm;
        lbl_9:
            state.algpowerup = false;
        lbl_30:
            optserv.trimprepare(state.f, ref state.trimthreshold);
            for(i_=0; i_<=n-1;i_++)
            {
                state.dk[i_] = -state.g[i_];
            }
            preconditionedmultiply(state, ref state.dk, ref state.work0, ref state.work1);
            if( !state.xrep )
            {
                goto lbl_32;
            }
            clearrequestfields(state);
            state.xupdated = true;
            state.rstate.stage = 10;
            goto lbl_rcomm;
        lbl_10:
            state.xupdated = false;
        lbl_32:
            if( state.terminationneeded || state.userterminationneeded )
            {
                
                //
                // Combined termination point for "internal" termination by TerminationNeeded flag
                // and for "user" termination by MinCGRequestTermination() (UserTerminationNeeded flag).
                // In this location rules for both of methods are same, thus only one exit point is needed.
                //
                for(i_=0; i_<=n-1;i_++)
                {
                    state.xn[i_] = state.xk[i_];
                }
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            v = 0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.g[i]*state.s[i]);
            }
            if( (double)(Math.Sqrt(v))<=(double)(state.epsg) )
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    state.xn[i_] = state.xk[i_];
                }
                state.repterminationtype = 4;
                result = false;
                return result;
            }
            state.repnfev = 1;
            state.k = 0;
            state.fold = state.f;
            
            //
            // Choose initial step.
            // Apply preconditioner, if we have something other than default.
            //
            if( state.prectype==2 || state.prectype==3 )
            {
                
                //
                // because we use preconditioner, step length must be equal
                // to the norm of DK
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.dk[i_]*state.dk[i_];
                }
                state.lastgoodstep = Math.Sqrt(v);
            }
            else
            {
                
                //
                // No preconditioner is used, we try to use suggested step
                //
                if( (double)(state.suggestedstep)>(double)(0) )
                {
                    state.lastgoodstep = state.suggestedstep;
                }
                else
                {
                    state.lastgoodstep = 1.0;
                }
            }
            
            //
            // Main cycle
            //
            state.rstimer = rscountdownlen;
        lbl_34:
            if( false )
            {
                goto lbl_35;
            }
            
            //
            // * clear reset flag
            // * clear termination flag
            // * store G[k] for later calculation of Y[k]
            // * prepare starting point and direction and step length for line search
            //
            state.innerresetneeded = false;
            state.terminationneeded = false;
            for(i_=0; i_<=n-1;i_++)
            {
                state.yk[i_] = -state.g[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.d[i_] = state.dk[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.xk[i_];
            }
            state.mcstage = 0;
            state.stp = 1.0;
            linmin.linminnormalized(ref state.d, ref state.stp, n);
            if( (double)(state.lastgoodstep)!=(double)(0) )
            {
                state.stp = state.lastgoodstep;
            }
            state.curstpmax = state.stpmax;
            
            //
            // Report beginning of line search (if needed)
            // Terminate algorithm, if user request was detected
            //
            if( !state.drep )
            {
                goto lbl_36;
            }
            clearrequestfields(state);
            state.lsstart = true;
            state.rstate.stage = 11;
            goto lbl_rcomm;
        lbl_11:
            state.lsstart = false;
        lbl_36:
            if( state.terminationneeded )
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    state.xn[i_] = state.x[i_];
                }
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            
            //
            // Minimization along D
            //
            linmin.mcsrch(n, ref state.x, ref state.f, ref state.g, state.d, ref state.stp, state.curstpmax, gtol, ref state.mcinfo, ref state.nfev, ref state.work0, state.lstate, ref state.mcstage);
        lbl_38:
            if( state.mcstage==0 )
            {
                goto lbl_39;
            }
            
            //
            // Calculate function/gradient using either
            // analytical gradient supplied by user
            // or finite difference approximation.
            //
            // "Trim" function in order to handle near-singularity points.
            //
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_40;
            }
            state.needfg = true;
            state.rstate.stage = 12;
            goto lbl_rcomm;
        lbl_12:
            state.needfg = false;
            goto lbl_41;
        lbl_40:
            state.needf = true;
            state.rstate.stage = 13;
            goto lbl_rcomm;
        lbl_13:
            state.fbase = state.f;
            i = 0;
        lbl_42:
            if( i>n-1 )
            {
                goto lbl_44;
            }
            v = state.x[i];
            state.x[i] = v-state.diffstep*state.s[i];
            state.rstate.stage = 14;
            goto lbl_rcomm;
        lbl_14:
            state.fm2 = state.f;
            state.x[i] = v-0.5*state.diffstep*state.s[i];
            state.rstate.stage = 15;
            goto lbl_rcomm;
        lbl_15:
            state.fm1 = state.f;
            state.x[i] = v+0.5*state.diffstep*state.s[i];
            state.rstate.stage = 16;
            goto lbl_rcomm;
        lbl_16:
            state.fp1 = state.f;
            state.x[i] = v+state.diffstep*state.s[i];
            state.rstate.stage = 17;
            goto lbl_rcomm;
        lbl_17:
            state.fp2 = state.f;
            state.x[i] = v;
            state.g[i] = (8*(state.fp1-state.fm1)-(state.fp2-state.fm2))/(6*state.diffstep*state.s[i]);
            i = i+1;
            goto lbl_42;
        lbl_44:
            state.f = state.fbase;
            state.needf = false;
        lbl_41:
            optserv.trimfunction(ref state.f, ref state.g, n, state.trimthreshold);
            
            //
            // Call MCSRCH again
            //
            linmin.mcsrch(n, ref state.x, ref state.f, ref state.g, state.d, ref state.stp, state.curstpmax, gtol, ref state.mcinfo, ref state.nfev, ref state.work0, state.lstate, ref state.mcstage);
            goto lbl_38;
        lbl_39:
            
            //
            // * terminate algorithm if "user" request for detected
            // * report end of line search
            // * store current point to XN
            // * report iteration
            // * terminate algorithm if "internal" request was detected
            //
            if( state.userterminationneeded )
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    state.xn[i_] = state.xk[i_];
                }
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            if( !state.drep )
            {
                goto lbl_45;
            }
            
            //
            // Report end of line search (if needed)
            //
            clearrequestfields(state);
            state.lsend = true;
            state.rstate.stage = 18;
            goto lbl_rcomm;
        lbl_18:
            state.lsend = false;
        lbl_45:
            for(i_=0; i_<=n-1;i_++)
            {
                state.xn[i_] = state.x[i_];
            }
            if( !state.xrep )
            {
                goto lbl_47;
            }
            clearrequestfields(state);
            state.xupdated = true;
            state.rstate.stage = 19;
            goto lbl_rcomm;
        lbl_19:
            state.xupdated = false;
        lbl_47:
            if( state.terminationneeded )
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    state.xn[i_] = state.x[i_];
                }
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            
            //
            // Line search is finished.
            // * calculate BetaK
            // * calculate DN
            // * update timers
            // * calculate step length:
            //   * LastScaledStep is ALWAYS calculated because it is used in the stopping criteria
            //   * LastGoodStep is updated only when MCINFO is equal to 1 (Wolfe conditions hold).
            //     See below for more explanation.
            //
            if( state.mcinfo==1 && !state.innerresetneeded )
            {
                
                //
                // Standard Wolfe conditions hold
                // Calculate Y[K] and D[K]'*Y[K]
                //
                for(i_=0; i_<=n-1;i_++)
                {
                    state.yk[i_] = state.yk[i_] + state.g[i_];
                }
                vv = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    vv += state.yk[i_]*state.dk[i_];
                }
                
                //
                // Calculate BetaK according to DY formula
                //
                v = preconditionedmultiply2(state, ref state.g, ref state.g, ref state.work0, ref state.work1);
                state.betady = v/vv;
                
                //
                // Calculate BetaK according to HS formula
                //
                v = preconditionedmultiply2(state, ref state.g, ref state.yk, ref state.work0, ref state.work1);
                state.betahs = v/vv;
                
                //
                // Choose BetaK
                //
                if( state.cgtype==0 )
                {
                    betak = state.betady;
                }
                if( state.cgtype==1 )
                {
                    betak = Math.Max(0, Math.Min(state.betady, state.betahs));
                }
            }
            else
            {
                
                //
                // Something is wrong (may be function is too wild or too flat)
                // or we just have to restart algo.
                //
                // We'll set BetaK=0, which will restart CG algorithm.
                // We can stop later (during normal checks) if stopping conditions are met.
                //
                betak = 0;
                state.debugrestartscount = state.debugrestartscount+1;
            }
            if( state.repiterationscount>0 && state.repiterationscount%(3+n)==0 )
            {
                
                //
                // clear Beta every N iterations
                //
                betak = 0;
            }
            if( state.mcinfo==1 || state.mcinfo==5 )
            {
                state.rstimer = rscountdownlen;
            }
            else
            {
                state.rstimer = state.rstimer-1;
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.dn[i_] = -state.g[i_];
            }
            preconditionedmultiply(state, ref state.dn, ref state.work0, ref state.work1);
            for(i_=0; i_<=n-1;i_++)
            {
                state.dn[i_] = state.dn[i_] + betak*state.dk[i_];
            }
            state.lastscaledstep = 0.0;
            for(i=0; i<=n-1; i++)
            {
                state.lastscaledstep = state.lastscaledstep+math.sqr(state.d[i]/state.s[i]);
            }
            state.lastscaledstep = state.stp*Math.Sqrt(state.lastscaledstep);
            if( state.mcinfo==1 )
            {
                
                //
                // Step is good (Wolfe conditions hold), update LastGoodStep.
                //
                // This check for MCINFO=1 is essential because sometimes in the
                // constrained optimization setting we may take very short steps
                // (like 1E-15) because we were very close to boundary of the
                // feasible area. Such short step does not mean that we've converged
                // to the solution - it was so short because we were close to the
                // boundary and there was a limit on step length.
                //
                // So having such short step is quite normal situation. However, we
                // should NOT start next iteration from step whose initial length is
                // estimated as 1E-15 because it may lead to the failure of the
                // linear minimizer (step is too short, function does not changes,
                // line search stagnates).
                //
                state.lastgoodstep = 0;
                for(i=0; i<=n-1; i++)
                {
                    state.lastgoodstep = state.lastgoodstep+math.sqr(state.d[i]);
                }
                state.lastgoodstep = state.stp*Math.Sqrt(state.lastgoodstep);
            }
            
            //
            // Update information.
            // Check stopping conditions.
            //
            v = 0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.g[i]*state.s[i]);
            }
            if( !math.isfinite(v) || !math.isfinite(state.f) )
            {
                
                //
                // Abnormal termination - infinities in function/gradient
                //
                state.repterminationtype = -8;
                result = false;
                return result;
            }
            state.repnfev = state.repnfev+state.nfev;
            state.repiterationscount = state.repiterationscount+1;
            if( state.repiterationscount>=state.maxits && state.maxits>0 )
            {
                
                //
                // Too many iterations
                //
                state.repterminationtype = 5;
                result = false;
                return result;
            }
            if( (double)(Math.Sqrt(v))<=(double)(state.epsg) )
            {
                
                //
                // Gradient is small enough
                //
                state.repterminationtype = 4;
                result = false;
                return result;
            }
            if( !state.innerresetneeded )
            {
                
                //
                // These conditions are checked only when no inner reset was requested by user
                //
                if( (double)(state.fold-state.f)<=(double)(state.epsf*Math.Max(Math.Abs(state.fold), Math.Max(Math.Abs(state.f), 1.0))) )
                {
                    
                    //
                    // F(k+1)-F(k) is small enough
                    //
                    state.repterminationtype = 1;
                    result = false;
                    return result;
                }
                if( (double)(state.lastscaledstep)<=(double)(state.epsx) )
                {
                    
                    //
                    // X(k+1)-X(k) is small enough
                    //
                    state.repterminationtype = 2;
                    result = false;
                    return result;
                }
            }
            if( state.rstimer<=0 )
            {
                
                //
                // Too many subsequent restarts
                //
                state.repterminationtype = 7;
                result = false;
                return result;
            }
            
            //
            // Shift Xk/Dk, update other information
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.xk[i_] = state.xn[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.dk[i_] = state.dn[i_];
            }
            state.fold = state.f;
            state.k = state.k+1;
            goto lbl_34;
        lbl_35:
            result = false;
            return result;
            
            //
            // Saving state
            //
        lbl_rcomm:
            result = true;
            state.rstate.ia[0] = n;
            state.rstate.ia[1] = i;
            state.rstate.ra[0] = betak;
            state.rstate.ra[1] = v;
            state.rstate.ra[2] = vv;
            return result;
        }


        /*************************************************************************
        Conjugate gradient results

        INPUT PARAMETERS:
            State   -   algorithm state

        OUTPUT PARAMETERS:
            X       -   array[0..N-1], solution
            Rep     -   optimization report:
                        * Rep.TerminationType completetion code:
                            * -8    internal integrity control  detected  infinite
                                    or NAN values in  function/gradient.  Abnormal
                                    termination signalled.
                            * -7    gradient verification failed.
                                    See MinCGSetGradientCheck() for more information.
                            *  1    relative function improvement is no more than
                                    EpsF.
                            *  2    relative step is no more than EpsX.
                            *  4    gradient norm is no more than EpsG
                            *  5    MaxIts steps was taken
                            *  7    stopping conditions are too stringent,
                                    further improvement is impossible,
                                    we return best X found so far
                            *  8    terminated by user
                        * Rep.IterationsCount contains iterations count
                        * NFEV countains number of function calculations

          -- ALGLIB --
             Copyright 20.04.2009 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgresults(mincgstate state,
            ref double[] x,
            mincgreport rep)
        {
            x = new double[0];

            mincgresultsbuf(state, ref x, rep);
        }


        /*************************************************************************
        Conjugate gradient results

        Buffered implementation of MinCGResults(), which uses pre-allocated buffer
        to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
        intended to be used in the inner cycles of performance critical algorithms
        where array reallocation penalty is too large to be ignored.

          -- ALGLIB --
             Copyright 20.04.2009 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgresultsbuf(mincgstate state,
            ref double[] x,
            mincgreport rep)
        {
            int i_ = 0;

            if( alglib.ap.len(x)<state.n )
            {
                x = new double[state.n];
            }
            for(i_=0; i_<=state.n-1;i_++)
            {
                x[i_] = state.xn[i_];
            }
            rep.iterationscount = state.repiterationscount;
            rep.nfev = state.repnfev;
            rep.varidx = state.repvaridx;
            rep.terminationtype = state.repterminationtype;
        }


        /*************************************************************************
        This  subroutine  restarts  CG  algorithm from new point. All optimization
        parameters are left unchanged.

        This  function  allows  to  solve multiple  optimization  problems  (which
        must have same number of dimensions) without object reallocation penalty.

        INPUT PARAMETERS:
            State   -   structure used to store algorithm state.
            X       -   new starting point.

          -- ALGLIB --
             Copyright 30.07.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgrestartfrom(mincgstate state,
            double[] x)
        {
            int i_ = 0;

            alglib.ap.assert(alglib.ap.len(x)>=state.n, "MinCGRestartFrom: Length(X)<N!");
            alglib.ap.assert(apserv.isfinitevector(x, state.n), "MinCGCreate: X contains infinite or NaN values!");
            for(i_=0; i_<=state.n-1;i_++)
            {
                state.x[i_] = x[i_];
            }
            mincgsuggeststep(state, 0.0);
            state.rstate.ia = new int[1+1];
            state.rstate.ra = new double[2+1];
            state.rstate.stage = -1;
            clearrequestfields(state);
        }


        /*************************************************************************
        This subroutine submits request for termination of running  optimizer.  It
        should be called from user-supplied callback when user decides that it  is
        time to "smoothly" terminate optimization process.  As  result,  optimizer
        stops at point which was "current accepted" when termination  request  was
        submitted and returns error code 8 (successful termination).

        INPUT PARAMETERS:
            State   -   optimizer structure

        NOTE: after  request  for  termination  optimizer  may   perform   several
              additional calls to user-supplied callbacks. It does  NOT  guarantee
              to stop immediately - it just guarantees that these additional calls
              will be discarded later.

        NOTE: calling this function on optimizer which is NOT running will have no
              effect.
              
        NOTE: multiple calls to this function are possible. First call is counted,
              subsequent calls are silently ignored.

          -- ALGLIB --
             Copyright 08.10.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgrequesttermination(mincgstate state)
        {
            state.userterminationneeded = true;
        }


        /*************************************************************************
        Faster version of MinCGSetPrecDiag(), for time-critical parts of code,
        without safety checks.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetprecdiagfast(mincgstate state,
            double[] d)
        {
            int i = 0;

            apserv.rvectorsetlengthatleast(ref state.diagh, state.n);
            apserv.rvectorsetlengthatleast(ref state.diaghl2, state.n);
            state.prectype = 2;
            state.vcnt = 0;
            state.innerresetneeded = true;
            for(i=0; i<=state.n-1; i++)
            {
                state.diagh[i] = d[i];
                state.diaghl2[i] = 0.0;
            }
        }


        /*************************************************************************
        This function sets low-rank preconditioner for Hessian matrix  H=D+V'*C*V,
        where:
        * H is a Hessian matrix, which is approximated by D/V/C
        * D=D1+D2 is a diagonal matrix, which includes two positive definite terms:
          * constant term D1 (is not updated or infrequently updated)
          * variable term D2 (can be cheaply updated from iteration to iteration)
        * V is a low-rank correction
        * C is a diagonal factor of low-rank correction

        Preconditioner P is calculated using approximate Woodburry formula:
            P  = D^(-1) - D^(-1)*V'*(C^(-1)+V*D1^(-1)*V')^(-1)*V*D^(-1)
               = D^(-1) - D^(-1)*VC'*VC*D^(-1),
        where
            VC = sqrt(B)*V
            B  = (C^(-1)+V*D1^(-1)*V')^(-1)
            
        Note that B is calculated using constant term (D1) only,  which  allows us
        to update D2 without recalculation of B or   VC.  Such  preconditioner  is
        exact when D2 is zero. When D2 is non-zero, it is only approximation,  but
        very good and cheap one.

        This function accepts D1, V, C.
        D2 is set to zero by default.

        Cost of this update is O(N*VCnt*VCnt), but D2 can be updated in just O(N)
        by MinCGSetPrecVarPart.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetpreclowrankfast(mincgstate state,
            double[] d1,
            double[] c,
            double[,] v,
            int vcnt)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            int n = 0;
            double t = 0;
            double[,] b = new double[0,0];
            int i_ = 0;

            if( vcnt==0 )
            {
                mincgsetprecdiagfast(state, d1);
                return;
            }
            n = state.n;
            b = new double[vcnt, vcnt];
            apserv.rvectorsetlengthatleast(ref state.diagh, n);
            apserv.rvectorsetlengthatleast(ref state.diaghl2, n);
            apserv.rmatrixsetlengthatleast(ref state.vcorr, vcnt, n);
            state.prectype = 2;
            state.vcnt = vcnt;
            state.innerresetneeded = true;
            for(i=0; i<=n-1; i++)
            {
                state.diagh[i] = d1[i];
                state.diaghl2[i] = 0.0;
            }
            for(i=0; i<=vcnt-1; i++)
            {
                for(j=i; j<=vcnt-1; j++)
                {
                    t = 0;
                    for(k=0; k<=n-1; k++)
                    {
                        t = t+v[i,k]*v[j,k]/d1[k];
                    }
                    b[i,j] = t;
                }
                b[i,i] = b[i,i]+1.0/c[i];
            }
            if( !trfac.spdmatrixcholeskyrec(ref b, 0, vcnt, true, ref state.work0) )
            {
                state.vcnt = 0;
                return;
            }
            for(i=0; i<=vcnt-1; i++)
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    state.vcorr[i,i_] = v[i,i_];
                }
                for(j=0; j<=i-1; j++)
                {
                    t = b[j,i];
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.vcorr[i,i_] = state.vcorr[i,i_] - t*state.vcorr[j,i_];
                    }
                }
                t = 1/b[i,i];
                for(i_=0; i_<=n-1;i_++)
                {
                    state.vcorr[i,i_] = t*state.vcorr[i,i_];
                }
            }
        }


        /*************************************************************************
        This function updates variable part (diagonal matrix D2)
        of low-rank preconditioner.

        This update is very cheap and takes just O(N) time.

        It has no effect with default preconditioner.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetprecvarpart(mincgstate state,
            double[] d2)
        {
            int i = 0;
            int n = 0;

            n = state.n;
            for(i=0; i<=n-1; i++)
            {
                state.diaghl2[i] = d2[i];
            }
        }


        /*************************************************************************

        This  subroutine  turns  on  verification  of  the  user-supplied analytic
        gradient:
        * user calls this subroutine before optimization begins
        * MinCGOptimize() is called
        * prior to  actual  optimization, for each component  of  parameters being
          optimized X[i] algorithm performs following steps:
          * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
            where X[i] is i-th component of the initial point and S[i] is a  scale
            of i-th parameter
          * F(X) is evaluated at these trial points
          * we perform one more evaluation in the middle point of the interval
          * we  build  cubic  model using function values and derivatives at trial
            points and we compare its prediction with actual value in  the  middle
            point
          * in case difference between prediction and actual value is higher  than
            some predetermined threshold, algorithm stops with completion code -7;
            Rep.VarIdx is set to index of the parameter with incorrect derivative.
        * after verification is over, algorithm proceeds to the actual optimization.

        NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
                is very costly and you should use  it  only  for  low  dimensional
                problems,  when  you  want  to  be  sure  that  you've   correctly
                calculated  analytic  derivatives.  You  should  not use it in the
                production code (unless you want to check derivatives provided  by
                some third party).

        NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
                (so large that function behaviour is significantly non-cubic) will
                lead to false alarms. You may use  different  step  for  different
                parameters by means of setting scale with MinCGSetScale().

        NOTE 3: this function may lead to false positives. In case it reports that
                I-th  derivative was calculated incorrectly, you may decrease test
                step  and  try  one  more  time  - maybe your function changes too
                sharply  and  your  step  is  too  large for such rapidly chanding
                function.

        INPUT PARAMETERS:
            State       -   structure used to store algorithm state
            TestStep    -   verification step:
                            * TestStep=0 turns verification off
                            * TestStep>0 activates verification

          -- ALGLIB --
             Copyright 31.05.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void mincgsetgradientcheck(mincgstate state,
            double teststep)
        {
            alglib.ap.assert(math.isfinite(teststep), "MinCGSetGradientCheck: TestStep contains NaN or Infinite");
            alglib.ap.assert((double)(teststep)>=(double)(0), "MinCGSetGradientCheck: invalid argument TestStep(TestStep<0)");
            state.teststep = teststep;
        }


        /*************************************************************************
        Clears request fileds (to be sure that we don't forgot to clear something)
        *************************************************************************/
        private static void clearrequestfields(mincgstate state)
        {
            state.needf = false;
            state.needfg = false;
            state.xupdated = false;
            state.lsstart = false;
            state.lsend = false;
            state.algpowerup = false;
        }


        /*************************************************************************
        This function calculates preconditioned product H^(-1)*x and stores result
        back into X. Work0[] and Work1[] are used as temporaries (size must be at
        least N; this function doesn't allocate arrays).

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        private static void preconditionedmultiply(mincgstate state,
            ref double[] x,
            ref double[] work0,
            ref double[] work1)
        {
            int i = 0;
            int n = 0;
            int vcnt = 0;
            double v = 0;
            int i_ = 0;

            n = state.n;
            vcnt = state.vcnt;
            if( state.prectype==0 )
            {
                return;
            }
            if( state.prectype==3 )
            {
                for(i=0; i<=n-1; i++)
                {
                    x[i] = x[i]*state.s[i]*state.s[i];
                }
                return;
            }
            alglib.ap.assert(state.prectype==2, "MinCG: internal error (unexpected PrecType)");
            
            //
            // handle part common for VCnt=0 and VCnt<>0
            //
            for(i=0; i<=n-1; i++)
            {
                x[i] = x[i]/(state.diagh[i]+state.diaghl2[i]);
            }
            
            //
            // if VCnt>0
            //
            if( vcnt>0 )
            {
                for(i=0; i<=vcnt-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += state.vcorr[i,i_]*x[i_];
                    }
                    work0[i] = v;
                }
                for(i=0; i<=n-1; i++)
                {
                    work1[i] = 0;
                }
                for(i=0; i<=vcnt-1; i++)
                {
                    v = work0[i];
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.work1[i_] = state.work1[i_] + v*state.vcorr[i,i_];
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    x[i] = x[i]-state.work1[i]/(state.diagh[i]+state.diaghl2[i]);
                }
            }
        }


        /*************************************************************************
        This function calculates preconditioned product x'*H^(-1)*y. Work0[] and
        Work1[] are used as temporaries (size must be at least N; this function
        doesn't allocate arrays).

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        private static double preconditionedmultiply2(mincgstate state,
            ref double[] x,
            ref double[] y,
            ref double[] work0,
            ref double[] work1)
        {
            double result = 0;
            int i = 0;
            int n = 0;
            int vcnt = 0;
            double v0 = 0;
            double v1 = 0;
            int i_ = 0;

            n = state.n;
            vcnt = state.vcnt;
            
            //
            // no preconditioning
            //
            if( state.prectype==0 )
            {
                v0 = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v0 += x[i_]*y[i_];
                }
                result = v0;
                return result;
            }
            if( state.prectype==3 )
            {
                result = 0;
                for(i=0; i<=n-1; i++)
                {
                    result = result+x[i]*state.s[i]*state.s[i]*y[i];
                }
                return result;
            }
            alglib.ap.assert(state.prectype==2, "MinCG: internal error (unexpected PrecType)");
            
            //
            // low rank preconditioning
            //
            result = 0.0;
            for(i=0; i<=n-1; i++)
            {
                result = result+x[i]*y[i]/(state.diagh[i]+state.diaghl2[i]);
            }
            if( vcnt>0 )
            {
                for(i=0; i<=n-1; i++)
                {
                    work0[i] = x[i]/(state.diagh[i]+state.diaghl2[i]);
                    work1[i] = y[i]/(state.diagh[i]+state.diaghl2[i]);
                }
                for(i=0; i<=vcnt-1; i++)
                {
                    v0 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v0 += work0[i_]*state.vcorr[i,i_];
                    }
                    v1 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v1 += work1[i_]*state.vcorr[i,i_];
                    }
                    result = result-v0*v1;
                }
            }
            return result;
        }


        /*************************************************************************
        Internal initialization subroutine

          -- ALGLIB --
             Copyright 16.05.2011 by Bochkanov Sergey
        *************************************************************************/
        private static void mincginitinternal(int n,
            double diffstep,
            mincgstate state)
        {
            int i = 0;

            
            //
            // Initialize
            //
            state.teststep = 0;
            state.n = n;
            state.diffstep = diffstep;
            state.lastgoodstep = 0;
            mincgsetcond(state, 0, 0, 0, 0);
            mincgsetxrep(state, false);
            mincgsetdrep(state, false);
            mincgsetstpmax(state, 0);
            mincgsetcgtype(state, -1);
            mincgsetprecdefault(state);
            state.xk = new double[n];
            state.dk = new double[n];
            state.xn = new double[n];
            state.dn = new double[n];
            state.x = new double[n];
            state.d = new double[n];
            state.g = new double[n];
            state.work0 = new double[n];
            state.work1 = new double[n];
            state.yk = new double[n];
            state.s = new double[n];
            for(i=0; i<=n-1; i++)
            {
                state.s[i] = 1.0;
            }
        }


    }
    public class minbleic
    {
        /*************************************************************************
        This object stores nonlinear optimizer state.
        You should use functions provided by MinBLEIC subpackage to work with this
        object
        *************************************************************************/
        public class minbleicstate : apobject
        {
            public int nmain;
            public int nslack;
            public double epsg;
            public double epsf;
            public double epsx;
            public int maxits;
            public bool xrep;
            public bool drep;
            public double stpmax;
            public double diffstep;
            public sactivesets.sactiveset sas;
            public double[] s;
            public int prectype;
            public double[] diagh;
            public double[] x;
            public double f;
            public double[] g;
            public bool needf;
            public bool needfg;
            public bool xupdated;
            public bool lsstart;
            public bool steepestdescentstep;
            public bool boundedstep;
            public bool userterminationneeded;
            public double teststep;
            public rcommstate rstate;
            public double[] ugc;
            public double[] cgc;
            public double[] xn;
            public double[] ugn;
            public double[] cgn;
            public double[] xp;
            public double fc;
            public double fn;
            public double fp;
            public double[] d;
            public double[,] cleic;
            public int nec;
            public int nic;
            public double lastgoodstep;
            public double lastscaledgoodstep;
            public double maxscaledgrad;
            public bool[] hasbndl;
            public bool[] hasbndu;
            public double[] bndl;
            public double[] bndu;
            public int repinneriterationscount;
            public int repouteriterationscount;
            public int repnfev;
            public int repvaridx;
            public int repterminationtype;
            public double repdebugeqerr;
            public double repdebugfs;
            public double repdebugff;
            public double repdebugdx;
            public int repdebugfeasqpits;
            public int repdebugfeasgpaits;
            public double[] xstart;
            public snnls.snnlssolver solver;
            public double fbase;
            public double fm2;
            public double fm1;
            public double fp1;
            public double fp2;
            public double xm1;
            public double xp1;
            public double gm1;
            public double gp1;
            public int cidx;
            public double cval;
            public double[] tmpprec;
            public double[] tmp0;
            public int nfev;
            public int mcstage;
            public double stp;
            public double curstpmax;
            public double activationstep;
            public double[] work;
            public linmin.linminstate lstate;
            public double trimthreshold;
            public int nonmonotoniccnt;
            public double[,] bufyk;
            public double[,] bufsk;
            public double[] bufrho;
            public double[] buftheta;
            public int bufsize;
            public minbleicstate()
            {
                init();
            }
            public override void init()
            {
                sas = new sactivesets.sactiveset();
                s = new double[0];
                diagh = new double[0];
                x = new double[0];
                g = new double[0];
                rstate = new rcommstate();
                ugc = new double[0];
                cgc = new double[0];
                xn = new double[0];
                ugn = new double[0];
                cgn = new double[0];
                xp = new double[0];
                d = new double[0];
                cleic = new double[0,0];
                hasbndl = new bool[0];
                hasbndu = new bool[0];
                bndl = new double[0];
                bndu = new double[0];
                xstart = new double[0];
                solver = new snnls.snnlssolver();
                tmpprec = new double[0];
                tmp0 = new double[0];
                work = new double[0];
                lstate = new linmin.linminstate();
                bufyk = new double[0,0];
                bufsk = new double[0,0];
                bufrho = new double[0];
                buftheta = new double[0];
            }
            public override alglib.apobject make_copy()
            {
                minbleicstate _result = new minbleicstate();
                _result.nmain = nmain;
                _result.nslack = nslack;
                _result.epsg = epsg;
                _result.epsf = epsf;
                _result.epsx = epsx;
                _result.maxits = maxits;
                _result.xrep = xrep;
                _result.drep = drep;
                _result.stpmax = stpmax;
                _result.diffstep = diffstep;
                _result.sas = (sactivesets.sactiveset)sas.make_copy();
                _result.s = (double[])s.Clone();
                _result.prectype = prectype;
                _result.diagh = (double[])diagh.Clone();
                _result.x = (double[])x.Clone();
                _result.f = f;
                _result.g = (double[])g.Clone();
                _result.needf = needf;
                _result.needfg = needfg;
                _result.xupdated = xupdated;
                _result.lsstart = lsstart;
                _result.steepestdescentstep = steepestdescentstep;
                _result.boundedstep = boundedstep;
                _result.userterminationneeded = userterminationneeded;
                _result.teststep = teststep;
                _result.rstate = (rcommstate)rstate.make_copy();
                _result.ugc = (double[])ugc.Clone();
                _result.cgc = (double[])cgc.Clone();
                _result.xn = (double[])xn.Clone();
                _result.ugn = (double[])ugn.Clone();
                _result.cgn = (double[])cgn.Clone();
                _result.xp = (double[])xp.Clone();
                _result.fc = fc;
                _result.fn = fn;
                _result.fp = fp;
                _result.d = (double[])d.Clone();
                _result.cleic = (double[,])cleic.Clone();
                _result.nec = nec;
                _result.nic = nic;
                _result.lastgoodstep = lastgoodstep;
                _result.lastscaledgoodstep = lastscaledgoodstep;
                _result.maxscaledgrad = maxscaledgrad;
                _result.hasbndl = (bool[])hasbndl.Clone();
                _result.hasbndu = (bool[])hasbndu.Clone();
                _result.bndl = (double[])bndl.Clone();
                _result.bndu = (double[])bndu.Clone();
                _result.repinneriterationscount = repinneriterationscount;
                _result.repouteriterationscount = repouteriterationscount;
                _result.repnfev = repnfev;
                _result.repvaridx = repvaridx;
                _result.repterminationtype = repterminationtype;
                _result.repdebugeqerr = repdebugeqerr;
                _result.repdebugfs = repdebugfs;
                _result.repdebugff = repdebugff;
                _result.repdebugdx = repdebugdx;
                _result.repdebugfeasqpits = repdebugfeasqpits;
                _result.repdebugfeasgpaits = repdebugfeasgpaits;
                _result.xstart = (double[])xstart.Clone();
                _result.solver = (snnls.snnlssolver)solver.make_copy();
                _result.fbase = fbase;
                _result.fm2 = fm2;
                _result.fm1 = fm1;
                _result.fp1 = fp1;
                _result.fp2 = fp2;
                _result.xm1 = xm1;
                _result.xp1 = xp1;
                _result.gm1 = gm1;
                _result.gp1 = gp1;
                _result.cidx = cidx;
                _result.cval = cval;
                _result.tmpprec = (double[])tmpprec.Clone();
                _result.tmp0 = (double[])tmp0.Clone();
                _result.nfev = nfev;
                _result.mcstage = mcstage;
                _result.stp = stp;
                _result.curstpmax = curstpmax;
                _result.activationstep = activationstep;
                _result.work = (double[])work.Clone();
                _result.lstate = (linmin.linminstate)lstate.make_copy();
                _result.trimthreshold = trimthreshold;
                _result.nonmonotoniccnt = nonmonotoniccnt;
                _result.bufyk = (double[,])bufyk.Clone();
                _result.bufsk = (double[,])bufsk.Clone();
                _result.bufrho = (double[])bufrho.Clone();
                _result.buftheta = (double[])buftheta.Clone();
                _result.bufsize = bufsize;
                return _result;
            }
        };


        /*************************************************************************
        This structure stores optimization report:
        * IterationsCount           number of iterations
        * NFEV                      number of gradient evaluations
        * TerminationType           termination type (see below)

        TERMINATION CODES

        TerminationType field contains completion code, which can be:
          -8    internal integrity control detected  infinite  or  NAN  values  in
                function/gradient. Abnormal termination signalled.
          -7    gradient verification failed.
                See MinBLEICSetGradientCheck() for more information.
          -3    inconsistent constraints. Feasible point is
                either nonexistent or too hard to find. Try to
                restart optimizer with better initial approximation
           1    relative function improvement is no more than EpsF.
           2    relative step is no more than EpsX.
           4    gradient norm is no more than EpsG
           5    MaxIts steps was taken
           7    stopping conditions are too stringent,
                further improvement is impossible,
                X contains best point found so far.
           8    terminated by user who called minbleicrequesttermination(). X contains
                point which was "current accepted" when  termination  request  was
                submitted.

        ADDITIONAL FIELDS

        There are additional fields which can be used for debugging:
        * DebugEqErr                error in the equality constraints (2-norm)
        * DebugFS                   f, calculated at projection of initial point
                                    to the feasible set
        * DebugFF                   f, calculated at the final point
        * DebugDX                   |X_start-X_final|
        *************************************************************************/
        public class minbleicreport : apobject
        {
            public int iterationscount;
            public int nfev;
            public int varidx;
            public int terminationtype;
            public double debugeqerr;
            public double debugfs;
            public double debugff;
            public double debugdx;
            public int debugfeasqpits;
            public int debugfeasgpaits;
            public int inneriterationscount;
            public int outeriterationscount;
            public minbleicreport()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                minbleicreport _result = new minbleicreport();
                _result.iterationscount = iterationscount;
                _result.nfev = nfev;
                _result.varidx = varidx;
                _result.terminationtype = terminationtype;
                _result.debugeqerr = debugeqerr;
                _result.debugfs = debugfs;
                _result.debugff = debugff;
                _result.debugdx = debugdx;
                _result.debugfeasqpits = debugfeasqpits;
                _result.debugfeasgpaits = debugfeasgpaits;
                _result.inneriterationscount = inneriterationscount;
                _result.outeriterationscount = outeriterationscount;
                return _result;
            }
        };




        public const double gtol = 0.4;
        public const double maxnonmonotoniclen = 1.0E-5;
        public const double initialdecay = 0.5;
        public const double mindecay = 0.1;
        public const double decaycorrection = 0.8;
        public const double penaltyfactor = 100;


        /*************************************************************************
                             BOUND CONSTRAINED OPTIMIZATION
               WITH ADDITIONAL LINEAR EQUALITY AND INEQUALITY CONSTRAINTS

        DESCRIPTION:
        The  subroutine  minimizes  function   F(x)  of N arguments subject to any
        combination of:
        * bound constraints
        * linear inequality constraints
        * linear equality constraints

        REQUIREMENTS:
        * user must provide function value and gradient
        * starting point X0 must be feasible or
          not too far away from the feasible set
        * grad(f) must be Lipschitz continuous on a level set:
          L = { x : f(x)<=f(x0) }
        * function must be defined everywhere on the feasible set F

        USAGE:

        Constrained optimization if far more complex than the unconstrained one.
        Here we give very brief outline of the BLEIC optimizer. We strongly recommend
        you to read examples in the ALGLIB Reference Manual and to read ALGLIB User Guide
        on optimization, which is available at http://www.alglib.net/optimization/

        1. User initializes algorithm state with MinBLEICCreate() call

        2. USer adds boundary and/or linear constraints by calling
           MinBLEICSetBC() and MinBLEICSetLC() functions.

        3. User sets stopping conditions with MinBLEICSetCond().

        4. User calls MinBLEICOptimize() function which takes algorithm  state and
           pointer (delegate, etc.) to callback function which calculates F/G.

        5. User calls MinBLEICResults() to get solution

        6. Optionally user may call MinBLEICRestartFrom() to solve another problem
           with same N but another starting point.
           MinBLEICRestartFrom() allows to reuse already initialized structure.


        INPUT PARAMETERS:
            N       -   problem dimension, N>0:
                        * if given, only leading N elements of X are used
                        * if not given, automatically determined from size ofX
            X       -   starting point, array[N]:
                        * it is better to set X to a feasible point
                        * but X can be infeasible, in which case algorithm will try
                          to find feasible point first, using X as initial
                          approximation.

        OUTPUT PARAMETERS:
            State   -   structure stores algorithm state

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleiccreate(int n,
            double[] x,
            minbleicstate state)
        {
            double[,] c = new double[0,0];
            int[] ct = new int[0];

            alglib.ap.assert(n>=1, "MinBLEICCreate: N<1");
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinBLEICCreate: Length(X)<N");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinBLEICCreate: X contains infinite or NaN values!");
            minbleicinitinternal(n, x, 0.0, state);
        }


        /*************************************************************************
        The subroutine is finite difference variant of MinBLEICCreate().  It  uses
        finite differences in order to differentiate target function.

        Description below contains information which is specific to  this function
        only. We recommend to read comments on MinBLEICCreate() in  order  to  get
        more information about creation of BLEIC optimizer.

        INPUT PARAMETERS:
            N       -   problem dimension, N>0:
                        * if given, only leading N elements of X are used
                        * if not given, automatically determined from size of X
            X       -   starting point, array[0..N-1].
            DiffStep-   differentiation step, >0

        OUTPUT PARAMETERS:
            State   -   structure which stores algorithm state

        NOTES:
        1. algorithm uses 4-point central formula for differentiation.
        2. differentiation step along I-th axis is equal to DiffStep*S[I] where
           S[] is scaling vector which can be set by MinBLEICSetScale() call.
        3. we recommend you to use moderate values of  differentiation  step.  Too
           large step will result in too large truncation  errors, while too small
           step will result in too large numerical  errors.  1.0E-6  can  be  good
           value to start with.
        4. Numerical  differentiation  is   very   inefficient  -   one   gradient
           calculation needs 4*N function evaluations. This function will work for
           any N - either small (1...10), moderate (10...100) or  large  (100...).
           However, performance penalty will be too severe for any N's except  for
           small ones.
           We should also say that code which relies on numerical  differentiation
           is  less  robust and precise. CG needs exact gradient values. Imprecise
           gradient may slow  down  convergence, especially  on  highly  nonlinear
           problems.
           Thus  we  recommend to use this function for fast prototyping on small-
           dimensional problems only, and to implement analytical gradient as soon
           as possible.

          -- ALGLIB --
             Copyright 16.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleiccreatef(int n,
            double[] x,
            double diffstep,
            minbleicstate state)
        {
            double[,] c = new double[0,0];
            int[] ct = new int[0];

            alglib.ap.assert(n>=1, "MinBLEICCreateF: N<1");
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinBLEICCreateF: Length(X)<N");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinBLEICCreateF: X contains infinite or NaN values!");
            alglib.ap.assert(math.isfinite(diffstep), "MinBLEICCreateF: DiffStep is infinite or NaN!");
            alglib.ap.assert((double)(diffstep)>(double)(0), "MinBLEICCreateF: DiffStep is non-positive!");
            minbleicinitinternal(n, x, diffstep, state);
        }


        /*************************************************************************
        This function sets boundary constraints for BLEIC optimizer.

        Boundary constraints are inactive by default (after initial creation).
        They are preserved after algorithm restart with MinBLEICRestartFrom().

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            BndL    -   lower bounds, array[N].
                        If some (all) variables are unbounded, you may specify
                        very small number or -INF.
            BndU    -   upper bounds, array[N].
                        If some (all) variables are unbounded, you may specify
                        very large number or +INF.

        NOTE 1: it is possible to specify BndL[i]=BndU[i]. In this case I-th
        variable will be "frozen" at X[i]=BndL[i]=BndU[i].

        NOTE 2: this solver has following useful properties:
        * bound constraints are always satisfied exactly
        * function is evaluated only INSIDE area specified by  bound  constraints,
          even  when  numerical  differentiation is used (algorithm adjusts  nodes
          according to boundary constraints)

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetbc(minbleicstate state,
            double[] bndl,
            double[] bndu)
        {
            int i = 0;
            int n = 0;

            n = state.nmain;
            alglib.ap.assert(alglib.ap.len(bndl)>=n, "MinBLEICSetBC: Length(BndL)<N");
            alglib.ap.assert(alglib.ap.len(bndu)>=n, "MinBLEICSetBC: Length(BndU)<N");
            for(i=0; i<=n-1; i++)
            {
                alglib.ap.assert(math.isfinite(bndl[i]) || Double.IsNegativeInfinity(bndl[i]), "MinBLEICSetBC: BndL contains NAN or +INF");
                alglib.ap.assert(math.isfinite(bndu[i]) || Double.IsPositiveInfinity(bndu[i]), "MinBLEICSetBC: BndL contains NAN or -INF");
                state.bndl[i] = bndl[i];
                state.hasbndl[i] = math.isfinite(bndl[i]);
                state.bndu[i] = bndu[i];
                state.hasbndu[i] = math.isfinite(bndu[i]);
            }
            sactivesets.sassetbc(state.sas, bndl, bndu);
        }


        /*************************************************************************
        This function sets linear constraints for BLEIC optimizer.

        Linear constraints are inactive by default (after initial creation).
        They are preserved after algorithm restart with MinBLEICRestartFrom().

        INPUT PARAMETERS:
            State   -   structure previously allocated with MinBLEICCreate call.
            C       -   linear constraints, array[K,N+1].
                        Each row of C represents one constraint, either equality
                        or inequality (see below):
                        * first N elements correspond to coefficients,
                        * last element corresponds to the right part.
                        All elements of C (including right part) must be finite.
            CT      -   type of constraints, array[K]:
                        * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                        * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                        * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
            K       -   number of equality/inequality constraints, K>=0:
                        * if given, only leading K elements of C/CT are used
                        * if not given, automatically determined from sizes of C/CT

        NOTE 1: linear (non-bound) constraints are satisfied only approximately:
        * there always exists some minor violation (about Epsilon in magnitude)
          due to rounding errors
        * numerical differentiation, if used, may  lead  to  function  evaluations
          outside  of the feasible  area,   because   algorithm  does  NOT  change
          numerical differentiation formula according to linear constraints.
        If you want constraints to be  satisfied  exactly, try to reformulate your
        problem  in  such  manner  that  all constraints will become boundary ones
        (this kind of constraints is always satisfied exactly, both in  the  final
        solution and in all intermediate points).

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetlc(minbleicstate state,
            double[,] c,
            int[] ct,
            int k)
        {
            int n = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            n = state.nmain;
            
            //
            // First, check for errors in the inputs
            //
            alglib.ap.assert(k>=0, "MinBLEICSetLC: K<0");
            alglib.ap.assert(alglib.ap.cols(c)>=n+1 || k==0, "MinBLEICSetLC: Cols(C)<N+1");
            alglib.ap.assert(alglib.ap.rows(c)>=k, "MinBLEICSetLC: Rows(C)<K");
            alglib.ap.assert(alglib.ap.len(ct)>=k, "MinBLEICSetLC: Length(CT)<K");
            alglib.ap.assert(apserv.apservisfinitematrix(c, k, n+1), "MinBLEICSetLC: C contains infinite or NaN values!");
            
            //
            // Handle zero K
            //
            if( k==0 )
            {
                state.nec = 0;
                state.nic = 0;
                return;
            }
            
            //
            // Equality constraints are stored first, in the upper
            // NEC rows of State.CLEIC matrix. Inequality constraints
            // are stored in the next NIC rows.
            //
            // NOTE: we convert inequality constraints to the form
            // A*x<=b before copying them.
            //
            apserv.rmatrixsetlengthatleast(ref state.cleic, k, n+1);
            state.nec = 0;
            state.nic = 0;
            for(i=0; i<=k-1; i++)
            {
                if( ct[i]==0 )
                {
                    for(i_=0; i_<=n;i_++)
                    {
                        state.cleic[state.nec,i_] = c[i,i_];
                    }
                    state.nec = state.nec+1;
                }
            }
            for(i=0; i<=k-1; i++)
            {
                if( ct[i]!=0 )
                {
                    if( ct[i]>0 )
                    {
                        for(i_=0; i_<=n;i_++)
                        {
                            state.cleic[state.nec+state.nic,i_] = -c[i,i_];
                        }
                    }
                    else
                    {
                        for(i_=0; i_<=n;i_++)
                        {
                            state.cleic[state.nec+state.nic,i_] = c[i,i_];
                        }
                    }
                    state.nic = state.nic+1;
                }
            }
            
            //
            // Normalize rows of State.CLEIC: each row must have unit norm.
            // Norm is calculated using first N elements (i.e. right part is
            // not counted when we calculate norm).
            //
            for(i=0; i<=k-1; i++)
            {
                v = 0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+math.sqr(state.cleic[i,j]);
                }
                if( (double)(v)==(double)(0) )
                {
                    continue;
                }
                v = 1/Math.Sqrt(v);
                for(i_=0; i_<=n;i_++)
                {
                    state.cleic[i,i_] = v*state.cleic[i,i_];
                }
            }
            sactivesets.sassetlc(state.sas, c, ct, k);
        }


        /*************************************************************************
        This function sets stopping conditions for the optimizer.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            EpsG    -   >=0
                        The  subroutine  finishes  its  work   if   the  condition
                        |v|<EpsG is satisfied, where:
                        * |.| means Euclidian norm
                        * v - scaled gradient vector, v[i]=g[i]*s[i]
                        * g - gradient
                        * s - scaling coefficients set by MinBLEICSetScale()
            EpsF    -   >=0
                        The  subroutine  finishes  its work if on k+1-th iteration
                        the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                        is satisfied.
            EpsX    -   >=0
                        The subroutine finishes its work if  on  k+1-th  iteration
                        the condition |v|<=EpsX is fulfilled, where:
                        * |.| means Euclidian norm
                        * v - scaled step vector, v[i]=dx[i]/s[i]
                        * dx - step vector, dx=X(k+1)-X(k)
                        * s - scaling coefficients set by MinBLEICSetScale()
            MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                        iterations is unlimited.

        Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
        to automatic stopping criterion selection.

        NOTE: when SetCond() called with non-zero MaxIts, BLEIC solver may perform
              slightly more than MaxIts iterations. I.e., MaxIts  sets  non-strict
              limit on iterations count.

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetcond(minbleicstate state,
            double epsg,
            double epsf,
            double epsx,
            int maxits)
        {
            alglib.ap.assert(math.isfinite(epsg), "MinBLEICSetCond: EpsG is not finite number");
            alglib.ap.assert((double)(epsg)>=(double)(0), "MinBLEICSetCond: negative EpsG");
            alglib.ap.assert(math.isfinite(epsf), "MinBLEICSetCond: EpsF is not finite number");
            alglib.ap.assert((double)(epsf)>=(double)(0), "MinBLEICSetCond: negative EpsF");
            alglib.ap.assert(math.isfinite(epsx), "MinBLEICSetCond: EpsX is not finite number");
            alglib.ap.assert((double)(epsx)>=(double)(0), "MinBLEICSetCond: negative EpsX");
            alglib.ap.assert(maxits>=0, "MinBLEICSetCond: negative MaxIts!");
            if( (((double)(epsg)==(double)(0) && (double)(epsf)==(double)(0)) && (double)(epsx)==(double)(0)) && maxits==0 )
            {
                epsx = 1.0E-6;
            }
            state.epsg = epsg;
            state.epsf = epsf;
            state.epsx = epsx;
            state.maxits = maxits;
        }


        /*************************************************************************
        This function sets scaling coefficients for BLEIC optimizer.

        ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
        size and gradient are scaled before comparison with tolerances).  Scale of
        the I-th variable is a translation invariant measure of:
        a) "how large" the variable is
        b) how large the step should be to make significant changes in the function

        Scaling is also used by finite difference variant of the optimizer  - step
        along I-th axis is equal to DiffStep*S[I].

        In  most  optimizers  (and  in  the  BLEIC  too)  scaling is NOT a form of
        preconditioning. It just  affects  stopping  conditions.  You  should  set
        preconditioner  by  separate  call  to  one  of  the  MinBLEICSetPrec...()
        functions.

        There is a special  preconditioning  mode, however,  which  uses   scaling
        coefficients to form diagonal preconditioning matrix. You  can  turn  this
        mode on, if you want.   But  you should understand that scaling is not the
        same thing as preconditioning - these are two different, although  related
        forms of tuning solver.

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            S       -   array[N], non-zero scaling coefficients
                        S[i] may be negative, sign doesn't matter.

          -- ALGLIB --
             Copyright 14.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetscale(minbleicstate state,
            double[] s)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(s)>=state.nmain, "MinBLEICSetScale: Length(S)<N");
            for(i=0; i<=state.nmain-1; i++)
            {
                alglib.ap.assert(math.isfinite(s[i]), "MinBLEICSetScale: S contains infinite or NAN elements");
                alglib.ap.assert((double)(s[i])!=(double)(0), "MinBLEICSetScale: S contains zero elements");
                state.s[i] = Math.Abs(s[i]);
            }
            sactivesets.sassetscale(state.sas, s);
        }


        /*************************************************************************
        Modification of the preconditioner: preconditioning is turned off.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetprecdefault(minbleicstate state)
        {
            state.prectype = 0;
        }


        /*************************************************************************
        Modification  of  the  preconditioner:  diagonal of approximate Hessian is
        used.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            D       -   diagonal of the approximate Hessian, array[0..N-1],
                        (if larger, only leading N elements are used).

        NOTE 1: D[i] should be positive. Exception will be thrown otherwise.

        NOTE 2: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetprecdiag(minbleicstate state,
            double[] d)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(d)>=state.nmain, "MinBLEICSetPrecDiag: D is too short");
            for(i=0; i<=state.nmain-1; i++)
            {
                alglib.ap.assert(math.isfinite(d[i]), "MinBLEICSetPrecDiag: D contains infinite or NAN elements");
                alglib.ap.assert((double)(d[i])>(double)(0), "MinBLEICSetPrecDiag: D contains non-positive elements");
            }
            apserv.rvectorsetlengthatleast(ref state.diagh, state.nmain);
            state.prectype = 2;
            for(i=0; i<=state.nmain-1; i++)
            {
                state.diagh[i] = d[i];
            }
        }


        /*************************************************************************
        Modification of the preconditioner: scale-based diagonal preconditioning.

        This preconditioning mode can be useful when you  don't  have  approximate
        diagonal of Hessian, but you know that your  variables  are  badly  scaled
        (for  example,  one  variable is in [1,10], and another in [1000,100000]),
        and most part of the ill-conditioning comes from different scales of vars.

        In this case simple  scale-based  preconditioner,  with H[i] = 1/(s[i]^2),
        can greatly improve convergence.

        IMPRTANT: you should set scale of your variables  with  MinBLEICSetScale()
        call  (before  or after MinBLEICSetPrecScale() call). Without knowledge of
        the scale of your variables scale-based preconditioner will be  just  unit
        matrix.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetprecscale(minbleicstate state)
        {
            state.prectype = 3;
        }


        /*************************************************************************
        This function turns on/off reporting.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            NeedXRep-   whether iteration reports are needed or not

        If NeedXRep is True, algorithm will call rep() callback function if  it is
        provided to MinBLEICOptimize().

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetxrep(minbleicstate state,
            bool needxrep)
        {
            state.xrep = needxrep;
        }


        /*************************************************************************
        This function turns on/off line search reports.
        These reports are described in more details in developer-only  comments on
        MinBLEICState object.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            NeedDRep-   whether line search reports are needed or not

        This function is intended for private use only. Turning it on artificially
        may cause program failure.

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetdrep(minbleicstate state,
            bool needdrep)
        {
            state.drep = needdrep;
        }


        /*************************************************************************
        This function sets maximum step length

        IMPORTANT: this feature is hard to combine with preconditioning. You can't
        set upper limit on step length, when you solve optimization  problem  with
        linear (non-boundary) constraints AND preconditioner turned on.

        When  non-boundary  constraints  are  present,  you  have to either a) use
        preconditioner, or b) use upper limit on step length.  YOU CAN'T USE BOTH!
        In this case algorithm will terminate with appropriate error code.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            StpMax  -   maximum step length, >=0. Set StpMax to 0.0,  if you don't
                        want to limit step length.

        Use this subroutine when you optimize target function which contains exp()
        or  other  fast  growing  functions,  and optimization algorithm makes too
        large  steps  which  lead   to overflow. This function allows us to reject
        steps  that  are  too  large  (and  therefore  expose  us  to the possible
        overflow) without actually calculating function value at the x+stp*d.

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetstpmax(minbleicstate state,
            double stpmax)
        {
            alglib.ap.assert(math.isfinite(stpmax), "MinBLEICSetStpMax: StpMax is not finite!");
            alglib.ap.assert((double)(stpmax)>=(double)(0), "MinBLEICSetStpMax: StpMax<0!");
            state.stpmax = stpmax;
        }


        /*************************************************************************
        NOTES:

        1. This function has two different implementations: one which  uses  exact
           (analytical) user-supplied gradient,  and one which uses function value
           only  and  numerically  differentiates  function  in  order  to  obtain
           gradient.

           Depending  on  the  specific  function  used to create optimizer object
           (either  MinBLEICCreate() for analytical gradient or  MinBLEICCreateF()
           for numerical differentiation) you should choose appropriate variant of
           MinBLEICOptimize() - one  which  accepts  function  AND gradient or one
           which accepts function ONLY.

           Be careful to choose variant of MinBLEICOptimize() which corresponds to
           your optimization scheme! Table below lists different  combinations  of
           callback (function/gradient) passed to MinBLEICOptimize()  and specific
           function used to create optimizer.


                             |         USER PASSED TO MinBLEICOptimize()
           CREATED WITH      |  function only   |  function and gradient
           ------------------------------------------------------------
           MinBLEICCreateF() |     work                FAIL
           MinBLEICCreate()  |     FAIL                work

           Here "FAIL" denotes inappropriate combinations  of  optimizer  creation
           function  and  MinBLEICOptimize()  version.   Attemps   to   use   such
           combination (for  example,  to  create optimizer with MinBLEICCreateF()
           and  to  pass  gradient  information  to  MinCGOptimize()) will lead to
           exception being thrown. Either  you  did  not pass gradient when it WAS
           needed or you passed gradient when it was NOT needed.

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static bool minbleiciteration(minbleicstate state)
        {
            bool result = new bool();
            int n = 0;
            int m = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            double vv = 0;
            double v0 = 0;
            bool b = new bool();
            int mcinfo = 0;
            int actstatus = 0;
            int itidx = 0;
            double penalty = 0;
            double ginit = 0;
            double gdecay = 0;
            int i_ = 0;

            
            //
            // Reverse communication preparations
            // I know it looks ugly, but it works the same way
            // anywhere from C++ to Python.
            //
            // This code initializes locals by:
            // * random values determined during code
            //   generation - on first subroutine call
            // * values from previous call - on subsequent calls
            //
            if( state.rstate.stage>=0 )
            {
                n = state.rstate.ia[0];
                m = state.rstate.ia[1];
                i = state.rstate.ia[2];
                j = state.rstate.ia[3];
                mcinfo = state.rstate.ia[4];
                actstatus = state.rstate.ia[5];
                itidx = state.rstate.ia[6];
                b = state.rstate.ba[0];
                v = state.rstate.ra[0];
                vv = state.rstate.ra[1];
                v0 = state.rstate.ra[2];
                penalty = state.rstate.ra[3];
                ginit = state.rstate.ra[4];
                gdecay = state.rstate.ra[5];
            }
            else
            {
                n = -983;
                m = -989;
                i = -834;
                j = 900;
                mcinfo = -287;
                actstatus = 364;
                itidx = 214;
                b = false;
                v = -686;
                vv = 912;
                v0 = 585;
                penalty = 497;
                ginit = -271;
                gdecay = -581;
            }
            if( state.rstate.stage==0 )
            {
                goto lbl_0;
            }
            if( state.rstate.stage==1 )
            {
                goto lbl_1;
            }
            if( state.rstate.stage==2 )
            {
                goto lbl_2;
            }
            if( state.rstate.stage==3 )
            {
                goto lbl_3;
            }
            if( state.rstate.stage==4 )
            {
                goto lbl_4;
            }
            if( state.rstate.stage==5 )
            {
                goto lbl_5;
            }
            if( state.rstate.stage==6 )
            {
                goto lbl_6;
            }
            if( state.rstate.stage==7 )
            {
                goto lbl_7;
            }
            if( state.rstate.stage==8 )
            {
                goto lbl_8;
            }
            if( state.rstate.stage==9 )
            {
                goto lbl_9;
            }
            if( state.rstate.stage==10 )
            {
                goto lbl_10;
            }
            if( state.rstate.stage==11 )
            {
                goto lbl_11;
            }
            if( state.rstate.stage==12 )
            {
                goto lbl_12;
            }
            if( state.rstate.stage==13 )
            {
                goto lbl_13;
            }
            if( state.rstate.stage==14 )
            {
                goto lbl_14;
            }
            if( state.rstate.stage==15 )
            {
                goto lbl_15;
            }
            if( state.rstate.stage==16 )
            {
                goto lbl_16;
            }
            if( state.rstate.stage==17 )
            {
                goto lbl_17;
            }
            if( state.rstate.stage==18 )
            {
                goto lbl_18;
            }
            if( state.rstate.stage==19 )
            {
                goto lbl_19;
            }
            if( state.rstate.stage==20 )
            {
                goto lbl_20;
            }
            if( state.rstate.stage==21 )
            {
                goto lbl_21;
            }
            if( state.rstate.stage==22 )
            {
                goto lbl_22;
            }
            if( state.rstate.stage==23 )
            {
                goto lbl_23;
            }
            
            //
            // Routine body
            //
            
            //
            // Algorithm parameters:
            // * M          number of L-BFGS corrections.
            //              This coefficient remains fixed during iterations.
            // * GDecay     desired decrease of constrained gradient during L-BFGS iterations.
            //              This coefficient is decreased after each L-BFGS round until
            //              it reaches minimum decay.
            //
            m = Math.Min(5, state.nmain);
            gdecay = initialdecay;
            
            //
            // Init
            //
            n = state.nmain;
            state.steepestdescentstep = false;
            state.userterminationneeded = false;
            state.repterminationtype = 0;
            state.repinneriterationscount = 0;
            state.repouteriterationscount = 0;
            state.repnfev = 0;
            state.repvaridx = -1;
            state.repdebugeqerr = 0.0;
            state.repdebugfs = Double.NaN;
            state.repdebugff = Double.NaN;
            state.repdebugdx = Double.NaN;
            if( (double)(state.stpmax)!=(double)(0) && state.prectype!=0 )
            {
                state.repterminationtype = -10;
                result = false;
                return result;
            }
            apserv.rmatrixsetlengthatleast(ref state.bufyk, m+1, n);
            apserv.rmatrixsetlengthatleast(ref state.bufsk, m+1, n);
            apserv.rvectorsetlengthatleast(ref state.bufrho, m);
            apserv.rvectorsetlengthatleast(ref state.buftheta, m);
            apserv.rvectorsetlengthatleast(ref state.tmp0, n);
            
            //
            // Fill TmpPrec with current preconditioner
            //
            apserv.rvectorsetlengthatleast(ref state.tmpprec, n);
            for(i=0; i<=n-1; i++)
            {
                if( state.prectype==2 )
                {
                    state.tmpprec[i] = state.diagh[i];
                    continue;
                }
                if( state.prectype==3 )
                {
                    state.tmpprec[i] = 1/math.sqr(state.s[i]);
                    continue;
                }
                state.tmpprec[i] = 1;
            }
            sactivesets.sassetprecdiag(state.sas, state.tmpprec);
            
            //
            // Start optimization
            //
            if( !sactivesets.sasstartoptimization(state.sas, state.xstart) )
            {
                state.repterminationtype = -3;
                result = false;
                return result;
            }
            
            //
            //  Check correctness of user-supplied gradient
            //
            if( !((double)(state.diffstep)==(double)(0) && (double)(state.teststep)>(double)(0)) )
            {
                goto lbl_24;
            }
            clearrequestfields(state);
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.sas.xc[i_];
            }
            state.needfg = true;
            i = 0;
        lbl_26:
            if( i>n-1 )
            {
                goto lbl_28;
            }
            alglib.ap.assert(!state.hasbndl[i] || (double)(state.sas.xc[i])>=(double)(state.bndl[i]), "MinBLEICIteration: internal error(State.X is out of bounds)");
            alglib.ap.assert(!state.hasbndu[i] || (double)(state.sas.xc[i])<=(double)(state.bndu[i]), "MinBLEICIteration: internal error(State.X is out of bounds)");
            v = state.x[i];
            state.x[i] = v-state.teststep*state.s[i];
            if( state.hasbndl[i] )
            {
                state.x[i] = Math.Max(state.x[i], state.bndl[i]);
            }
            state.xm1 = state.x[i];
            state.rstate.stage = 0;
            goto lbl_rcomm;
        lbl_0:
            state.fm1 = state.f;
            state.gm1 = state.g[i];
            state.x[i] = v+state.teststep*state.s[i];
            if( state.hasbndu[i] )
            {
                state.x[i] = Math.Min(state.x[i], state.bndu[i]);
            }
            state.xp1 = state.x[i];
            state.rstate.stage = 1;
            goto lbl_rcomm;
        lbl_1:
            state.fp1 = state.f;
            state.gp1 = state.g[i];
            state.x[i] = (state.xm1+state.xp1)/2;
            if( state.hasbndl[i] )
            {
                state.x[i] = Math.Max(state.x[i], state.bndl[i]);
            }
            if( state.hasbndu[i] )
            {
                state.x[i] = Math.Min(state.x[i], state.bndu[i]);
            }
            state.rstate.stage = 2;
            goto lbl_rcomm;
        lbl_2:
            state.x[i] = v;
            if( !optserv.derivativecheck(state.fm1, state.gm1, state.fp1, state.gp1, state.f, state.g[i], state.xp1-state.xm1) )
            {
                state.repvaridx = i;
                state.repterminationtype = -7;
                sactivesets.sasstopoptimization(state.sas);
                result = false;
                return result;
            }
            i = i+1;
            goto lbl_26;
        lbl_28:
            state.needfg = false;
        lbl_24:
            
            //
            // Main cycle of BLEIC-PG algorithm
            //
            state.repterminationtype = 0;
            state.lastgoodstep = 0;
            state.lastscaledgoodstep = 0;
            state.maxscaledgrad = 0;
            state.nonmonotoniccnt = (int)Math.Round(1.5*(n+state.nic))+5;
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.sas.xc[i_];
            }
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_29;
            }
            state.needfg = true;
            state.rstate.stage = 3;
            goto lbl_rcomm;
        lbl_3:
            state.needfg = false;
            goto lbl_30;
        lbl_29:
            state.needf = true;
            state.rstate.stage = 4;
            goto lbl_rcomm;
        lbl_4:
            state.needf = false;
        lbl_30:
            state.fc = state.f;
            optserv.trimprepare(state.f, ref state.trimthreshold);
            state.repnfev = state.repnfev+1;
            if( !state.xrep )
            {
                goto lbl_31;
            }
            
            //
            // Report current point
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.sas.xc[i_];
            }
            state.f = state.fc;
            state.xupdated = true;
            state.rstate.stage = 5;
            goto lbl_rcomm;
        lbl_5:
            state.xupdated = false;
        lbl_31:
            if( state.userterminationneeded )
            {
                
                //
                // User requested termination
                //
                sactivesets.sasstopoptimization(state.sas);
                state.repterminationtype = 8;
                result = false;
                return result;
            }
        lbl_33:
            if( false )
            {
                goto lbl_34;
            }
            
            //
            // Preparations
            //
            // (a) calculate unconstrained gradient
            // (b) determine initial active set
            // (c) update MaxScaledGrad
            // (d) check F/G for NAN/INF, abnormally terminate algorithm if needed
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.sas.xc[i_];
            }
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_35;
            }
            
            //
            // Analytic gradient
            //
            state.needfg = true;
            state.rstate.stage = 6;
            goto lbl_rcomm;
        lbl_6:
            state.needfg = false;
            goto lbl_36;
        lbl_35:
            
            //
            // Numerical differentiation
            //
            state.needf = true;
            state.rstate.stage = 7;
            goto lbl_rcomm;
        lbl_7:
            state.fbase = state.f;
            i = 0;
        lbl_37:
            if( i>n-1 )
            {
                goto lbl_39;
            }
            v = state.x[i];
            b = false;
            if( state.hasbndl[i] )
            {
                b = b || (double)(v-state.diffstep*state.s[i])<(double)(state.bndl[i]);
            }
            if( state.hasbndu[i] )
            {
                b = b || (double)(v+state.diffstep*state.s[i])>(double)(state.bndu[i]);
            }
            if( b )
            {
                goto lbl_40;
            }
            state.x[i] = v-state.diffstep*state.s[i];
            state.rstate.stage = 8;
            goto lbl_rcomm;
        lbl_8:
            state.fm2 = state.f;
            state.x[i] = v-0.5*state.diffstep*state.s[i];
            state.rstate.stage = 9;
            goto lbl_rcomm;
        lbl_9:
            state.fm1 = state.f;
            state.x[i] = v+0.5*state.diffstep*state.s[i];
            state.rstate.stage = 10;
            goto lbl_rcomm;
        lbl_10:
            state.fp1 = state.f;
            state.x[i] = v+state.diffstep*state.s[i];
            state.rstate.stage = 11;
            goto lbl_rcomm;
        lbl_11:
            state.fp2 = state.f;
            state.g[i] = (8*(state.fp1-state.fm1)-(state.fp2-state.fm2))/(6*state.diffstep*state.s[i]);
            goto lbl_41;
        lbl_40:
            state.xm1 = v-state.diffstep*state.s[i];
            state.xp1 = v+state.diffstep*state.s[i];
            if( state.hasbndl[i] && (double)(state.xm1)<(double)(state.bndl[i]) )
            {
                state.xm1 = state.bndl[i];
            }
            if( state.hasbndu[i] && (double)(state.xp1)>(double)(state.bndu[i]) )
            {
                state.xp1 = state.bndu[i];
            }
            state.x[i] = state.xm1;
            state.rstate.stage = 12;
            goto lbl_rcomm;
        lbl_12:
            state.fm1 = state.f;
            state.x[i] = state.xp1;
            state.rstate.stage = 13;
            goto lbl_rcomm;
        lbl_13:
            state.fp1 = state.f;
            if( (double)(state.xm1)!=(double)(state.xp1) )
            {
                state.g[i] = (state.fp1-state.fm1)/(state.xp1-state.xm1);
            }
            else
            {
                state.g[i] = 0;
            }
        lbl_41:
            state.x[i] = v;
            i = i+1;
            goto lbl_37;
        lbl_39:
            state.f = state.fbase;
            state.needf = false;
        lbl_36:
            state.fc = state.f;
            for(i_=0; i_<=n-1;i_++)
            {
                state.ugc[i_] = state.g[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.cgc[i_] = state.g[i_];
            }
            sactivesets.sasreactivateconstraintsprec(state.sas, state.ugc);
            sactivesets.sasconstraineddirection(state.sas, ref state.cgc);
            ginit = 0.0;
            for(i=0; i<=n-1; i++)
            {
                ginit = ginit+math.sqr(state.cgc[i]*state.s[i]);
            }
            ginit = Math.Sqrt(ginit);
            state.maxscaledgrad = Math.Max(state.maxscaledgrad, ginit);
            if( !math.isfinite(ginit) || !math.isfinite(state.fc) )
            {
                
                //
                // Abnormal termination - infinities in function/gradient
                //
                sactivesets.sasstopoptimization(state.sas);
                state.repterminationtype = -8;
                result = false;
                return result;
            }
            if( state.userterminationneeded )
            {
                
                //
                // User requested termination
                //
                sactivesets.sasstopoptimization(state.sas);
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            
            //
            // LBFGS stage:
            // * during LBFGS iterations we activate new constraints, but never
            //   deactivate already active ones.
            // * we perform at most N iterations of LBFGS before re-evaluating
            //   active set and restarting LBFGS.
            // * first iteration of LBFGS is a special - it is performed with
            //   minimum set of active constraints, algorithm termination can
            //   be performed only at this state. We call this iteration
            //  "steepest descent step".
            //
            // About termination:
            // * LBFGS iterations can be terminated because of two reasons:
            //   * "termination" - non-zero termination code in RepTerminationType,
            //     which means that optimization is done
            //   * "restart" - zero RepTerminationType, which means that we
            //     have to re-evaluate active set and resume LBFGS stage.
            // * one more option is "refresh" - to continue LBFGS iterations,
            //   but with all BFGS updates (Sk/Yk pairs) being dropped;
            //   it happens after changes in active set
            //
            state.bufsize = 0;
            state.steepestdescentstep = true;
            itidx = 0;
        lbl_42:
            if( itidx>n-1 )
            {
                goto lbl_44;
            }
            
            //
            // At the beginning of each iteration:
            // * SAS.XC stores current point
            // * FC stores current function value
            // * UGC stores current unconstrained gradient
            // * CGC stores current constrained gradient
            // * D stores constrained step direction (calculated at this block)
            //
            //
            // Check gradient-based stopping criteria
            //
            // This stopping condition is tested only for step which is the
            // first step of LBFGS (subsequent steps may accumulate active
            // constraints thus they should NOT be used for stopping - gradient
            // may be small when constrained, but these constraints may be
            // deactivated by the subsequent steps)
            //
            if( state.steepestdescentstep && (double)(sactivesets.sasscaledconstrainednorm(state.sas, state.ugc))<=(double)(state.epsg) )
            {
                
                //
                // Gradient is small enough.
                // Optimization is terminated
                //
                state.repterminationtype = 4;
                goto lbl_44;
            }
            
            //
            // 1. Calculate search direction D according to L-BFGS algorithm
            //    using constrained preconditioner to perform inner multiplication.
            // 2. Evaluate scaled length of direction D; restart LBFGS if D is zero
            //    (it may be possible that we found minimum, but it is also possible
            //    that some constraints need deactivation)
            // 3. If D is non-zero, try to use previous scaled step length as initial estimate for new step.
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.work[i_] = state.cgc[i_];
            }
            for(i=state.bufsize-1; i>=0; i--)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.bufsk[i,i_]*state.work[i_];
                }
                state.buftheta[i] = v;
                vv = v*state.bufrho[i];
                for(i_=0; i_<=n-1;i_++)
                {
                    state.work[i_] = state.work[i_] - vv*state.bufyk[i,i_];
                }
            }
            sactivesets.sasconstraineddirectionprec(state.sas, ref state.work);
            for(i=0; i<=state.bufsize-1; i++)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.bufyk[i,i_]*state.work[i_];
                }
                vv = state.bufrho[i]*(-v+state.buftheta[i]);
                for(i_=0; i_<=n-1;i_++)
                {
                    state.work[i_] = state.work[i_] + vv*state.bufsk[i,i_];
                }
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.d[i_] = -state.work[i_];
            }
            v = 0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.d[i]/state.s[i]);
            }
            v = Math.Sqrt(v);
            if( (double)(v)==(double)(0) )
            {
                
                //
                // Search direction is zero.
                // If we perform "steepest descent step", algorithm is terminated.
                // Otherwise we just restart LBFGS.
                //
                if( state.steepestdescentstep )
                {
                    state.repterminationtype = 4;
                }
                goto lbl_44;
            }
            alglib.ap.assert((double)(v)>(double)(0), "MinBLEIC: internal error");
            if( (double)(state.lastscaledgoodstep)>(double)(0) && (double)(v)>(double)(0) )
            {
                state.stp = state.lastscaledgoodstep/v;
            }
            else
            {
                state.stp = 1.0/v;
            }
            
            //
            // Calculate bound on step length.
            // Step direction is stored
            //
            sactivesets.sasexploredirection(state.sas, state.d, ref state.curstpmax, ref state.cidx, ref state.cval);
            state.activationstep = state.curstpmax;
            if( state.cidx>=0 && (double)(state.activationstep)==(double)(0) )
            {
                
                //
                // We are exactly at the boundary, immediate activation
                // of constraint is required. LBFGS stage is continued
                // with "refreshed" model.
                //
                // ! IMPORTANT: we do not clear SteepestDescent flag here,
                // !            it is very important for correct stopping
                // !            of algorithm.
                //
                sactivesets.sasimmediateactivation(state.sas, state.cidx, state.cval);
                state.bufsize = 0;
                goto lbl_43;
            }
            if( (double)(state.stpmax)>(double)(0) )
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.d[i_]*state.d[i_];
                }
                v = Math.Sqrt(v);
                if( (double)(v)>(double)(0) )
                {
                    state.curstpmax = Math.Min(state.curstpmax, state.stpmax/v);
                }
            }
            
            //
            // Report beginning of line search (if requested by caller).
            // See description of the MinBLEICState for more information
            // about fields accessible to caller.
            //
            // Caller may do following:
            // * change State.Stp and load better initial estimate of
            //   the step length.
            // Caller may not terminate algorithm.
            //
            if( !state.drep )
            {
                goto lbl_45;
            }
            clearrequestfields(state);
            state.lsstart = true;
            state.boundedstep = state.cidx>=0;
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.sas.xc[i_];
            }
            state.rstate.stage = 14;
            goto lbl_rcomm;
        lbl_14:
            state.lsstart = false;
        lbl_45:
            
            //
            // Minimize F(x+alpha*d)
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.xn[i_] = state.sas.xc[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.cgn[i_] = state.cgc[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.ugn[i_] = state.ugc[i_];
            }
            state.fn = state.fc;
            state.mcstage = 0;
            linmin.mcsrch(n, ref state.xn, ref state.fn, ref state.cgn, state.d, ref state.stp, state.curstpmax, gtol, ref mcinfo, ref state.nfev, ref state.work, state.lstate, ref state.mcstage);
        lbl_47:
            if( state.mcstage==0 )
            {
                goto lbl_48;
            }
            
            //
            // Perform correction (constraints are enforced)
            // Copy XN to X
            //
            sactivesets.sascorrection(state.sas, state.xn, ref penalty);
            for(i=0; i<=n-1; i++)
            {
                state.x[i] = state.xn[i];
            }
            
            //
            // Gradient, either user-provided or numerical differentiation
            //
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_49;
            }
            
            //
            // Analytic gradient
            //
            state.needfg = true;
            state.rstate.stage = 15;
            goto lbl_rcomm;
        lbl_15:
            state.needfg = false;
            state.repnfev = state.repnfev+1;
            goto lbl_50;
        lbl_49:
            
            //
            // Numerical differentiation
            //
            state.needf = true;
            state.rstate.stage = 16;
            goto lbl_rcomm;
        lbl_16:
            state.fbase = state.f;
            i = 0;
        lbl_51:
            if( i>n-1 )
            {
                goto lbl_53;
            }
            v = state.x[i];
            b = false;
            if( state.hasbndl[i] )
            {
                b = b || (double)(v-state.diffstep*state.s[i])<(double)(state.bndl[i]);
            }
            if( state.hasbndu[i] )
            {
                b = b || (double)(v+state.diffstep*state.s[i])>(double)(state.bndu[i]);
            }
            if( b )
            {
                goto lbl_54;
            }
            state.x[i] = v-state.diffstep*state.s[i];
            state.rstate.stage = 17;
            goto lbl_rcomm;
        lbl_17:
            state.fm2 = state.f;
            state.x[i] = v-0.5*state.diffstep*state.s[i];
            state.rstate.stage = 18;
            goto lbl_rcomm;
        lbl_18:
            state.fm1 = state.f;
            state.x[i] = v+0.5*state.diffstep*state.s[i];
            state.rstate.stage = 19;
            goto lbl_rcomm;
        lbl_19:
            state.fp1 = state.f;
            state.x[i] = v+state.diffstep*state.s[i];
            state.rstate.stage = 20;
            goto lbl_rcomm;
        lbl_20:
            state.fp2 = state.f;
            state.g[i] = (8*(state.fp1-state.fm1)-(state.fp2-state.fm2))/(6*state.diffstep*state.s[i]);
            state.repnfev = state.repnfev+4;
            goto lbl_55;
        lbl_54:
            state.xm1 = v-state.diffstep*state.s[i];
            state.xp1 = v+state.diffstep*state.s[i];
            if( state.hasbndl[i] && (double)(state.xm1)<(double)(state.bndl[i]) )
            {
                state.xm1 = state.bndl[i];
            }
            if( state.hasbndu[i] && (double)(state.xp1)>(double)(state.bndu[i]) )
            {
                state.xp1 = state.bndu[i];
            }
            state.x[i] = state.xm1;
            state.rstate.stage = 21;
            goto lbl_rcomm;
        lbl_21:
            state.fm1 = state.f;
            state.x[i] = state.xp1;
            state.rstate.stage = 22;
            goto lbl_rcomm;
        lbl_22:
            state.fp1 = state.f;
            if( (double)(state.xm1)!=(double)(state.xp1) )
            {
                state.g[i] = (state.fp1-state.fm1)/(state.xp1-state.xm1);
            }
            else
            {
                state.g[i] = 0;
            }
            state.repnfev = state.repnfev+2;
        lbl_55:
            state.x[i] = v;
            i = i+1;
            goto lbl_51;
        lbl_53:
            state.f = state.fbase;
            state.needf = false;
        lbl_50:
            
            //
            // Back to MCSRCH
            //
            // NOTE: penalty term from correction is added to FN in order
            //       to penalize increase in infeasibility.
            //
            state.fn = state.f+penaltyfactor*state.maxscaledgrad*penalty;
            for(i_=0; i_<=n-1;i_++)
            {
                state.cgn[i_] = state.g[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.ugn[i_] = state.g[i_];
            }
            sactivesets.sasconstraineddirection(state.sas, ref state.cgn);
            optserv.trimfunction(ref state.fn, ref state.cgn, n, state.trimthreshold);
            linmin.mcsrch(n, ref state.xn, ref state.fn, ref state.cgn, state.d, ref state.stp, state.curstpmax, gtol, ref mcinfo, ref state.nfev, ref state.work, state.lstate, ref state.mcstage);
            goto lbl_47;
        lbl_48:
            for(i_=0; i_<=n-1;i_++)
            {
                state.bufsk[state.bufsize,i_] = -state.sas.xc[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.bufyk[state.bufsize,i_] = -state.cgc[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.bufsk[state.bufsize,i_] = state.bufsk[state.bufsize,i_] + state.xn[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.bufyk[state.bufsize,i_] = state.bufyk[state.bufsize,i_] + state.cgn[i_];
            }
            
            //
            // Check for presence of NAN/INF in function/gradient
            //
            v = state.fn;
            for(i=0; i<=n-1; i++)
            {
                v = 0.1*v+state.ugn[i];
            }
            if( !math.isfinite(v) )
            {
                
                //
                // Abnormal termination - infinities in function/gradient
                //
                state.repterminationtype = -8;
                goto lbl_44;
            }
            
            //
            // Handle possible failure of the line search or request for termination
            //
            if( mcinfo!=1 && mcinfo!=5 )
            {
                
                //
                // We can not find step which decreases function value. We have
                // two possibilities:
                // (a) numerical properties of the function do not allow us to
                //     find good step.
                // (b) we are close to activation of some constraint, and it is
                //     so close that step which activates it leads to change in
                //     target function which is smaller than numerical noise.
                //
                // Optimization algorithm must be able to handle case (b), because
                // inability to handle it will cause failure when algorithm
                // started very close to boundary of the feasible area.
                //
                // In order to correctly handle such cases we allow limited amount
                // of small steps which increase function value.
                //
                v = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.sqr(state.d[i]*state.curstpmax/state.s[i]);
                }
                v = Math.Sqrt(v);
                if( (state.cidx>=0 && (double)(v)<=(double)(maxnonmonotoniclen)) && state.nonmonotoniccnt>0 )
                {
                    
                    //
                    // We enforce non-monotonic step:
                    // * Stp    := CurStpMax
                    // * MCINFO := 5
                    // * XN     := XC+CurStpMax*D
                    // * non-monotonic counter is decreased
                    //
                    // NOTE: UGN/CGN are not updated because step is so short that we assume that
                    //       GN is approximately equal to GC.
                    //
                    state.stp = state.curstpmax;
                    mcinfo = 5;
                    v = state.curstpmax;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.xn[i_] = state.sas.xc[i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.xn[i_] = state.xn[i_] + v*state.d[i_];
                    }
                    state.nonmonotoniccnt = state.nonmonotoniccnt-1;
                }
                else
                {
                    
                    //
                    // Numerical properties of the function does not allow
                    // us to solve problem. Here we have two possibilities:
                    // * if it is "steepest descent" step, we can terminate
                    //   algorithm because we are close to minimum
                    // * if it is NOT "steepest descent" step, we should restart
                    //   LBFGS iterations.
                    //
                    if( state.steepestdescentstep )
                    {
                        
                        //
                        // Algorithm is terminated
                        //
                        state.repterminationtype = 7;
                        goto lbl_44;
                    }
                    else
                    {
                        
                        //
                        // Re-evaluate active set and restart LBFGS
                        //
                        goto lbl_44;
                    }
                }
            }
            if( state.userterminationneeded )
            {
                goto lbl_44;
            }
            
            //
            // Current point is updated:
            // * move XC/FC/GC to XP/FP/GP
            // * change current point remembered by SAS structure
            // * move XN/FN/GN to XC/FC/GC
            // * report current point and update iterations counter
            // * if MCINFO=1, push new pair SK/YK to LBFGS buffer
            //
            state.fp = state.fc;
            for(i_=0; i_<=n-1;i_++)
            {
                state.xp[i_] = state.sas.xc[i_];
            }
            state.fc = state.fn;
            for(i_=0; i_<=n-1;i_++)
            {
                state.cgc[i_] = state.cgn[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.ugc[i_] = state.ugn[i_];
            }
            actstatus = sactivesets.sasmoveto(state.sas, state.xn, state.cidx>=0 && (double)(state.stp)>=(double)(state.activationstep), state.cidx, state.cval);
            if( !state.xrep )
            {
                goto lbl_56;
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.x[i_] = state.sas.xc[i_];
            }
            clearrequestfields(state);
            state.xupdated = true;
            state.rstate.stage = 23;
            goto lbl_rcomm;
        lbl_23:
            state.xupdated = false;
        lbl_56:
            state.repinneriterationscount = state.repinneriterationscount+1;
            if( mcinfo==1 )
            {
                
                //
                // Accept new LBFGS update given by Sk,Yk
                //
                if( state.bufsize==m )
                {
                    
                    //
                    // Buffer is full, shift contents by one row
                    //
                    for(i=0; i<=state.bufsize-1; i++)
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            state.bufsk[i,i_] = state.bufsk[i+1,i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            state.bufyk[i,i_] = state.bufyk[i+1,i_];
                        }
                    }
                    for(i=0; i<=state.bufsize-2; i++)
                    {
                        state.bufrho[i] = state.bufrho[i+1];
                        state.buftheta[i] = state.buftheta[i+1];
                    }
                }
                else
                {
                    
                    //
                    // Buffer is not full, increase buffer size by 1
                    //
                    state.bufsize = state.bufsize+1;
                }
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.bufyk[state.bufsize-1,i_]*state.bufsk[state.bufsize-1,i_];
                }
                vv = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    vv += state.bufyk[state.bufsize-1,i_]*state.bufyk[state.bufsize-1,i_];
                }
                if( (double)(v)==(double)(0) || (double)(vv)==(double)(0) )
                {
                    
                    //
                    // Strange internal error in LBFGS - either YK=0
                    // (which should not have been) or (SK,YK)=0 (again,
                    // unexpected). It should not take place because
                    // MCINFO=1, which signals "good" step. But just
                    // to be sure we have special branch of code which
                    // restarts LBFGS
                    //
                    goto lbl_44;
                }
                state.bufrho[state.bufsize-1] = 1/v;
                alglib.ap.assert(state.bufsize<=m, "MinBLEIC: internal error");
                
                //
                // Update length of the good step
                //
                v = 0;
                vv = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.sqr((state.sas.xc[i]-state.xp[i])/state.s[i]);
                    vv = vv+math.sqr(state.sas.xc[i]-state.xp[i]);
                }
                state.lastgoodstep = Math.Sqrt(vv);
                updateestimateofgoodstep(ref state.lastscaledgoodstep, Math.Sqrt(v));
            }
            
            //
            // Check stopping criteria
            //
            // Step size and function-based stopping criteria are tested only
            // for step which satisfies Wolfe conditions and is the first step of
            // LBFGS (subsequent steps may accumulate active constraints thus
            // they should NOT be used for stopping; step size or function change
            // may be small when constrained, but these constraints may be
            // deactivated by the subsequent steps).
            //
            // MaxIts-based stopping condition is checked for all kinds of steps.
            //
            if( mcinfo==1 && state.steepestdescentstep )
            {
                
                //
                // Step is small enough
                //
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.sqr((state.sas.xc[i]-state.xp[i])/state.s[i]);
                }
                v = Math.Sqrt(v);
                if( (double)(v)<=(double)(state.epsx) )
                {
                    state.repterminationtype = 2;
                    goto lbl_44;
                }
                
                //
                // Function change is small enough
                //
                if( (double)(Math.Abs(state.fp-state.fc))<=(double)(state.epsf*Math.Max(Math.Abs(state.fc), Math.Max(Math.Abs(state.fp), 1.0))) )
                {
                    state.repterminationtype = 1;
                    goto lbl_44;
                }
            }
            if( state.maxits>0 && state.repinneriterationscount>=state.maxits )
            {
                state.repterminationtype = 5;
                goto lbl_44;
            }
            
            //
            // Clear "steepest descent" flag.
            //
            state.steepestdescentstep = false;
            
            //
            // Smooth reset (LBFGS memory model is refreshed) or hard restart:
            // * LBFGS model is refreshed, if line search was performed with activation of constraints
            // * algorithm is restarted if scaled gradient decreased below GDecay
            //
            if( actstatus>=0 )
            {
                state.bufsize = 0;
                goto lbl_43;
            }
            v = 0.0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.cgc[i]*state.s[i]);
            }
            if( (double)(Math.Sqrt(v))<(double)(gdecay*ginit) )
            {
                goto lbl_44;
            }
        lbl_43:
            itidx = itidx+1;
            goto lbl_42;
        lbl_44:
            if( state.userterminationneeded )
            {
                
                //
                // User requested termination
                //
                state.repterminationtype = 8;
                goto lbl_34;
            }
            if( state.repterminationtype!=0 )
            {
                
                //
                // Algorithm terminated
                //
                goto lbl_34;
            }
            
            //
            // Decrease decay coefficient. Subsequent L-BFGS stages will
            // have more stringent stopping criteria.
            //
            gdecay = Math.Max(gdecay*decaycorrection, mindecay);
            goto lbl_33;
        lbl_34:
            sactivesets.sasstopoptimization(state.sas);
            state.repouteriterationscount = 1;
            result = false;
            return result;
            
            //
            // Saving state
            //
        lbl_rcomm:
            result = true;
            state.rstate.ia[0] = n;
            state.rstate.ia[1] = m;
            state.rstate.ia[2] = i;
            state.rstate.ia[3] = j;
            state.rstate.ia[4] = mcinfo;
            state.rstate.ia[5] = actstatus;
            state.rstate.ia[6] = itidx;
            state.rstate.ba[0] = b;
            state.rstate.ra[0] = v;
            state.rstate.ra[1] = vv;
            state.rstate.ra[2] = v0;
            state.rstate.ra[3] = penalty;
            state.rstate.ra[4] = ginit;
            state.rstate.ra[5] = gdecay;
            return result;
        }


        /*************************************************************************
        BLEIC results

        INPUT PARAMETERS:
            State   -   algorithm state

        OUTPUT PARAMETERS:
            X       -   array[0..N-1], solution
            Rep     -   optimization report. You should check Rep.TerminationType
                        in  order  to  distinguish  successful  termination  from
                        unsuccessful one:
                        * -8    internal integrity control  detected  infinite or
                                NAN   values   in   function/gradient.   Abnormal
                                termination signalled.
                        * -7   gradient verification failed.
                               See MinBLEICSetGradientCheck() for more information.
                        * -3   inconsistent constraints. Feasible point is
                               either nonexistent or too hard to find. Try to
                               restart optimizer with better initial approximation
                        *  1   relative function improvement is no more than EpsF.
                        *  2   scaled step is no more than EpsX.
                        *  4   scaled gradient norm is no more than EpsG.
                        *  5   MaxIts steps was taken
                        *  8   terminated by user who called minbleicrequesttermination().
                               X contains point which was "current accepted"  when
                               termination request was submitted.
                        More information about fields of this  structure  can  be
                        found in the comments on MinBLEICReport datatype.
           
          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicresults(minbleicstate state,
            ref double[] x,
            minbleicreport rep)
        {
            x = new double[0];

            minbleicresultsbuf(state, ref x, rep);
        }


        /*************************************************************************
        BLEIC results

        Buffered implementation of MinBLEICResults() which uses pre-allocated buffer
        to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
        intended to be used in the inner cycles of performance critical algorithms
        where array reallocation penalty is too large to be ignored.

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicresultsbuf(minbleicstate state,
            ref double[] x,
            minbleicreport rep)
        {
            int i = 0;
            int i_ = 0;

            if( alglib.ap.len(x)<state.nmain )
            {
                x = new double[state.nmain];
            }
            rep.iterationscount = state.repinneriterationscount;
            rep.inneriterationscount = state.repinneriterationscount;
            rep.outeriterationscount = state.repouteriterationscount;
            rep.nfev = state.repnfev;
            rep.varidx = state.repvaridx;
            rep.terminationtype = state.repterminationtype;
            if( state.repterminationtype>0 )
            {
                for(i_=0; i_<=state.nmain-1;i_++)
                {
                    x[i_] = state.sas.xc[i_];
                }
            }
            else
            {
                for(i=0; i<=state.nmain-1; i++)
                {
                    x[i] = Double.NaN;
                }
            }
            rep.debugeqerr = state.repdebugeqerr;
            rep.debugfs = state.repdebugfs;
            rep.debugff = state.repdebugff;
            rep.debugdx = state.repdebugdx;
            rep.debugfeasqpits = state.repdebugfeasqpits;
            rep.debugfeasgpaits = state.repdebugfeasgpaits;
        }


        /*************************************************************************
        This subroutine restarts algorithm from new point.
        All optimization parameters (including constraints) are left unchanged.

        This  function  allows  to  solve multiple  optimization  problems  (which
        must have  same number of dimensions) without object reallocation penalty.

        INPUT PARAMETERS:
            State   -   structure previously allocated with MinBLEICCreate call.
            X       -   new starting point.

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicrestartfrom(minbleicstate state,
            double[] x)
        {
            int n = 0;
            int i_ = 0;

            n = state.nmain;
            
            //
            // First, check for errors in the inputs
            //
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinBLEICRestartFrom: Length(X)<N");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinBLEICRestartFrom: X contains infinite or NaN values!");
            
            //
            // Set XC
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.xstart[i_] = x[i_];
            }
            
            //
            // prepare RComm facilities
            //
            state.rstate.ia = new int[6+1];
            state.rstate.ba = new bool[0+1];
            state.rstate.ra = new double[5+1];
            state.rstate.stage = -1;
            clearrequestfields(state);
            sactivesets.sasstopoptimization(state.sas);
        }


        /*************************************************************************
        This subroutine submits request for termination of running  optimizer.  It
        should be called from user-supplied callback when user decides that it  is
        time to "smoothly" terminate optimization process.  As  result,  optimizer
        stops at point which was "current accepted" when termination  request  was
        submitted and returns error code 8 (successful termination).

        INPUT PARAMETERS:
            State   -   optimizer structure

        NOTE: after  request  for  termination  optimizer  may   perform   several
              additional calls to user-supplied callbacks. It does  NOT  guarantee
              to stop immediately - it just guarantees that these additional calls
              will be discarded later.

        NOTE: calling this function on optimizer which is NOT running will have no
              effect.
              
        NOTE: multiple calls to this function are possible. First call is counted,
              subsequent calls are silently ignored.

          -- ALGLIB --
             Copyright 08.10.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicrequesttermination(minbleicstate state)
        {
            state.userterminationneeded = true;
        }


        /*************************************************************************
        This subroutine finalizes internal structures after emergency  termination
        from State.LSStart report (see comments on MinBLEICState for more information).

        INPUT PARAMETERS:
            State   -   structure after exit from LSStart report

          -- ALGLIB --
             Copyright 28.11.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicemergencytermination(minbleicstate state)
        {
            sactivesets.sasstopoptimization(state.sas);
        }


        /*************************************************************************
        This  subroutine  turns  on  verification  of  the  user-supplied analytic
        gradient:
        * user calls this subroutine before optimization begins
        * MinBLEICOptimize() is called
        * prior to  actual  optimization, for each component  of  parameters being
          optimized X[i] algorithm performs following steps:
          * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
            where X[i] is i-th component of the initial point and S[i] is a  scale
            of i-th parameter
          * if needed, steps are bounded with respect to constraints on X[]
          * F(X) is evaluated at these trial points
          * we perform one more evaluation in the middle point of the interval
          * we  build  cubic  model using function values and derivatives at trial
            points and we compare its prediction with actual value in  the  middle
            point
          * in case difference between prediction and actual value is higher  than
            some predetermined threshold, algorithm stops with completion code -7;
            Rep.VarIdx is set to index of the parameter with incorrect derivative.
        * after verification is over, algorithm proceeds to the actual optimization.

        NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
                is very costly and you should use  it  only  for  low  dimensional
                problems,  when  you  want  to  be  sure  that  you've   correctly
                calculated  analytic  derivatives.  You  should  not use it in the
                production code (unless you want to check derivatives provided  by
                some third party).

        NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
                (so large that function behaviour is significantly non-cubic) will
                lead to false alarms. You may use  different  step  for  different
                parameters by means of setting scale with MinBLEICSetScale().

        NOTE 3: this function may lead to false positives. In case it reports that
                I-th  derivative was calculated incorrectly, you may decrease test
                step  and  try  one  more  time  - maybe your function changes too
                sharply  and  your  step  is  too  large for such rapidly chanding
                function.

        INPUT PARAMETERS:
            State       -   structure used to store algorithm state
            TestStep    -   verification step:
                            * TestStep=0 turns verification off
                            * TestStep>0 activates verification

          -- ALGLIB --
             Copyright 15.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void minbleicsetgradientcheck(minbleicstate state,
            double teststep)
        {
            alglib.ap.assert(math.isfinite(teststep), "MinBLEICSetGradientCheck: TestStep contains NaN or Infinite");
            alglib.ap.assert((double)(teststep)>=(double)(0), "MinBLEICSetGradientCheck: invalid argument TestStep(TestStep<0)");
            state.teststep = teststep;
        }


        /*************************************************************************
        Clears request fileds (to be sure that we don't forget to clear something)
        *************************************************************************/
        private static void clearrequestfields(minbleicstate state)
        {
            state.needf = false;
            state.needfg = false;
            state.xupdated = false;
            state.lsstart = false;
        }


        /*************************************************************************
        Internal initialization subroutine
        *************************************************************************/
        private static void minbleicinitinternal(int n,
            double[] x,
            double diffstep,
            minbleicstate state)
        {
            int i = 0;
            double[,] c = new double[0,0];
            int[] ct = new int[0];

            
            //
            // Initialize
            //
            state.teststep = 0;
            state.nmain = n;
            state.diffstep = diffstep;
            sactivesets.sasinit(n, state.sas);
            state.bndl = new double[n];
            state.hasbndl = new bool[n];
            state.bndu = new double[n];
            state.hasbndu = new bool[n];
            state.xstart = new double[n];
            state.cgc = new double[n];
            state.ugc = new double[n];
            state.xn = new double[n];
            state.cgn = new double[n];
            state.ugn = new double[n];
            state.xp = new double[n];
            state.d = new double[n];
            state.s = new double[n];
            state.x = new double[n];
            state.g = new double[n];
            state.work = new double[n];
            for(i=0; i<=n-1; i++)
            {
                state.bndl[i] = Double.NegativeInfinity;
                state.hasbndl[i] = false;
                state.bndu[i] = Double.PositiveInfinity;
                state.hasbndu[i] = false;
                state.s[i] = 1.0;
            }
            minbleicsetlc(state, c, ct, 0);
            minbleicsetcond(state, 0.0, 0.0, 0.0, 0);
            minbleicsetxrep(state, false);
            minbleicsetdrep(state, false);
            minbleicsetstpmax(state, 0.0);
            minbleicsetprecdefault(state);
            minbleicrestartfrom(state, x);
        }


        /*************************************************************************
        This subroutine updates estimate of the good step length given:
        1) previous estimate
        2) new length of the good step

        It makes sure that estimate does not change too rapidly - ratio of new and
        old estimates will be at least 0.01, at most 100.0

        In case previous estimate of good step is zero (no estimate), new estimate
        is used unconditionally.

          -- ALGLIB --
             Copyright 16.01.2013 by Bochkanov Sergey
        *************************************************************************/
        private static void updateestimateofgoodstep(ref double estimate,
            double newstep)
        {
            if( (double)(estimate)==(double)(0) )
            {
                estimate = newstep;
                return;
            }
            if( (double)(newstep)<(double)(estimate*0.01) )
            {
                estimate = estimate*0.01;
                return;
            }
            if( (double)(newstep)>(double)(estimate*100) )
            {
                estimate = estimate*100;
                return;
            }
            estimate = newstep;
        }


    }
    public class minlbfgs
    {
        public class minlbfgsstate : apobject
        {
            public int n;
            public int m;
            public double epsg;
            public double epsf;
            public double epsx;
            public int maxits;
            public bool xrep;
            public double stpmax;
            public double[] s;
            public double diffstep;
            public int nfev;
            public int mcstage;
            public int k;
            public int q;
            public int p;
            public double[] rho;
            public double[,] yk;
            public double[,] sk;
            public double[] xp;
            public double[] theta;
            public double[] d;
            public double stp;
            public double[] work;
            public double fold;
            public double trimthreshold;
            public int prectype;
            public double gammak;
            public double[,] denseh;
            public double[] diagh;
            public double[] precc;
            public double[] precd;
            public double[,] precw;
            public int preck;
            public optserv.precbuflbfgs precbuf;
            public optserv.precbuflowrank lowrankbuf;
            public double fbase;
            public double fm2;
            public double fm1;
            public double fp1;
            public double fp2;
            public double[] autobuf;
            public double[] x;
            public double f;
            public double[] g;
            public bool needf;
            public bool needfg;
            public bool xupdated;
            public bool userterminationneeded;
            public double teststep;
            public rcommstate rstate;
            public int repiterationscount;
            public int repnfev;
            public int repvaridx;
            public int repterminationtype;
            public linmin.linminstate lstate;
            public minlbfgsstate()
            {
                init();
            }
            public override void init()
            {
                s = new double[0];
                rho = new double[0];
                yk = new double[0,0];
                sk = new double[0,0];
                xp = new double[0];
                theta = new double[0];
                d = new double[0];
                work = new double[0];
                denseh = new double[0,0];
                diagh = new double[0];
                precc = new double[0];
                precd = new double[0];
                precw = new double[0,0];
                precbuf = new optserv.precbuflbfgs();
                lowrankbuf = new optserv.precbuflowrank();
                autobuf = new double[0];
                x = new double[0];
                g = new double[0];
                rstate = new rcommstate();
                lstate = new linmin.linminstate();
            }
            public override alglib.apobject make_copy()
            {
                minlbfgsstate _result = new minlbfgsstate();
                _result.n = n;
                _result.m = m;
                _result.epsg = epsg;
                _result.epsf = epsf;
                _result.epsx = epsx;
                _result.maxits = maxits;
                _result.xrep = xrep;
                _result.stpmax = stpmax;
                _result.s = (double[])s.Clone();
                _result.diffstep = diffstep;
                _result.nfev = nfev;
                _result.mcstage = mcstage;
                _result.k = k;
                _result.q = q;
                _result.p = p;
                _result.rho = (double[])rho.Clone();
                _result.yk = (double[,])yk.Clone();
                _result.sk = (double[,])sk.Clone();
                _result.xp = (double[])xp.Clone();
                _result.theta = (double[])theta.Clone();
                _result.d = (double[])d.Clone();
                _result.stp = stp;
                _result.work = (double[])work.Clone();
                _result.fold = fold;
                _result.trimthreshold = trimthreshold;
                _result.prectype = prectype;
                _result.gammak = gammak;
                _result.denseh = (double[,])denseh.Clone();
                _result.diagh = (double[])diagh.Clone();
                _result.precc = (double[])precc.Clone();
                _result.precd = (double[])precd.Clone();
                _result.precw = (double[,])precw.Clone();
                _result.preck = preck;
                _result.precbuf = (optserv.precbuflbfgs)precbuf.make_copy();
                _result.lowrankbuf = (optserv.precbuflowrank)lowrankbuf.make_copy();
                _result.fbase = fbase;
                _result.fm2 = fm2;
                _result.fm1 = fm1;
                _result.fp1 = fp1;
                _result.fp2 = fp2;
                _result.autobuf = (double[])autobuf.Clone();
                _result.x = (double[])x.Clone();
                _result.f = f;
                _result.g = (double[])g.Clone();
                _result.needf = needf;
                _result.needfg = needfg;
                _result.xupdated = xupdated;
                _result.userterminationneeded = userterminationneeded;
                _result.teststep = teststep;
                _result.rstate = (rcommstate)rstate.make_copy();
                _result.repiterationscount = repiterationscount;
                _result.repnfev = repnfev;
                _result.repvaridx = repvaridx;
                _result.repterminationtype = repterminationtype;
                _result.lstate = (linmin.linminstate)lstate.make_copy();
                return _result;
            }
        };


        /*************************************************************************
        This structure stores optimization report:
        * IterationsCount           total number of inner iterations
        * NFEV                      number of gradient evaluations
        * TerminationType           termination type (see below)

        TERMINATION CODES

        TerminationType field contains completion code, which can be:
          -8    internal integrity control detected  infinite  or  NAN  values  in
                function/gradient. Abnormal termination signalled.
          -7    gradient verification failed.
                See MinLBFGSSetGradientCheck() for more information.
           1    relative function improvement is no more than EpsF.
           2    relative step is no more than EpsX.
           4    gradient norm is no more than EpsG
           5    MaxIts steps was taken
           7    stopping conditions are too stringent,
                further improvement is impossible,
                X contains best point found so far.
           8    terminated    by  user  who  called  minlbfgsrequesttermination().
                X contains point which was   "current accepted"  when  termination
                request was submitted.
                
        Other fields of this structure are not documented and should not be used!
        *************************************************************************/
        public class minlbfgsreport : apobject
        {
            public int iterationscount;
            public int nfev;
            public int varidx;
            public int terminationtype;
            public minlbfgsreport()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                minlbfgsreport _result = new minlbfgsreport();
                _result.iterationscount = iterationscount;
                _result.nfev = nfev;
                _result.varidx = varidx;
                _result.terminationtype = terminationtype;
                return _result;
            }
        };




        public const double gtol = 0.4;


        /*************************************************************************
                LIMITED MEMORY BFGS METHOD FOR LARGE SCALE OPTIMIZATION

        DESCRIPTION:
        The subroutine minimizes function F(x) of N arguments by  using  a  quasi-
        Newton method (LBFGS scheme) which is optimized to use  a  minimum  amount
        of memory.
        The subroutine generates the approximation of an inverse Hessian matrix by
        using information about the last M steps of the algorithm  (instead of N).
        It lessens a required amount of memory from a value  of  order  N^2  to  a
        value of order 2*N*M.


        REQUIREMENTS:
        Algorithm will request following information during its operation:
        * function value F and its gradient G (simultaneously) at given point X


        USAGE:
        1. User initializes algorithm state with MinLBFGSCreate() call
        2. User tunes solver parameters with MinLBFGSSetCond() MinLBFGSSetStpMax()
           and other functions
        3. User calls MinLBFGSOptimize() function which takes algorithm  state and
           pointer (delegate, etc.) to callback function which calculates F/G.
        4. User calls MinLBFGSResults() to get solution
        5. Optionally user may call MinLBFGSRestartFrom() to solve another problem
           with same N/M but another starting point and/or another function.
           MinLBFGSRestartFrom() allows to reuse already initialized structure.


        INPUT PARAMETERS:
            N       -   problem dimension. N>0
            M       -   number of corrections in the BFGS scheme of Hessian
                        approximation update. Recommended value:  3<=M<=7. The smaller
                        value causes worse convergence, the bigger will  not  cause  a
                        considerably better convergence, but will cause a fall in  the
                        performance. M<=N.
            X       -   initial solution approximation, array[0..N-1].


        OUTPUT PARAMETERS:
            State   -   structure which stores algorithm state
            

        NOTES:
        1. you may tune stopping conditions with MinLBFGSSetCond() function
        2. if target function contains exp() or other fast growing functions,  and
           optimization algorithm makes too large steps which leads  to  overflow,
           use MinLBFGSSetStpMax() function to bound algorithm's  steps.  However,
           L-BFGS rarely needs such a tuning.


          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgscreate(int n,
            int m,
            double[] x,
            minlbfgsstate state)
        {
            alglib.ap.assert(n>=1, "MinLBFGSCreate: N<1!");
            alglib.ap.assert(m>=1, "MinLBFGSCreate: M<1");
            alglib.ap.assert(m<=n, "MinLBFGSCreate: M>N");
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinLBFGSCreate: Length(X)<N!");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinLBFGSCreate: X contains infinite or NaN values!");
            minlbfgscreatex(n, m, x, 0, 0.0, state);
        }


        /*************************************************************************
        The subroutine is finite difference variant of MinLBFGSCreate().  It  uses
        finite differences in order to differentiate target function.

        Description below contains information which is specific to  this function
        only. We recommend to read comments on MinLBFGSCreate() in  order  to  get
        more information about creation of LBFGS optimizer.

        INPUT PARAMETERS:
            N       -   problem dimension, N>0:
                        * if given, only leading N elements of X are used
                        * if not given, automatically determined from size of X
            M       -   number of corrections in the BFGS scheme of Hessian
                        approximation update. Recommended value:  3<=M<=7. The smaller
                        value causes worse convergence, the bigger will  not  cause  a
                        considerably better convergence, but will cause a fall in  the
                        performance. M<=N.
            X       -   starting point, array[0..N-1].
            DiffStep-   differentiation step, >0

        OUTPUT PARAMETERS:
            State   -   structure which stores algorithm state

        NOTES:
        1. algorithm uses 4-point central formula for differentiation.
        2. differentiation step along I-th axis is equal to DiffStep*S[I] where
           S[] is scaling vector which can be set by MinLBFGSSetScale() call.
        3. we recommend you to use moderate values of  differentiation  step.  Too
           large step will result in too large truncation  errors, while too small
           step will result in too large numerical  errors.  1.0E-6  can  be  good
           value to start with.
        4. Numerical  differentiation  is   very   inefficient  -   one   gradient
           calculation needs 4*N function evaluations. This function will work for
           any N - either small (1...10), moderate (10...100) or  large  (100...).
           However, performance penalty will be too severe for any N's except  for
           small ones.
           We should also say that code which relies on numerical  differentiation
           is   less  robust  and  precise.  LBFGS  needs  exact  gradient values.
           Imprecise gradient may slow  down  convergence,  especially  on  highly
           nonlinear problems.
           Thus  we  recommend to use this function for fast prototyping on small-
           dimensional problems only, and to implement analytical gradient as soon
           as possible.

          -- ALGLIB --
             Copyright 16.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgscreatef(int n,
            int m,
            double[] x,
            double diffstep,
            minlbfgsstate state)
        {
            alglib.ap.assert(n>=1, "MinLBFGSCreateF: N too small!");
            alglib.ap.assert(m>=1, "MinLBFGSCreateF: M<1");
            alglib.ap.assert(m<=n, "MinLBFGSCreateF: M>N");
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinLBFGSCreateF: Length(X)<N!");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinLBFGSCreateF: X contains infinite or NaN values!");
            alglib.ap.assert(math.isfinite(diffstep), "MinLBFGSCreateF: DiffStep is infinite or NaN!");
            alglib.ap.assert((double)(diffstep)>(double)(0), "MinLBFGSCreateF: DiffStep is non-positive!");
            minlbfgscreatex(n, m, x, 0, diffstep, state);
        }


        /*************************************************************************
        This function sets stopping conditions for L-BFGS optimization algorithm.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            EpsG    -   >=0
                        The  subroutine  finishes  its  work   if   the  condition
                        |v|<EpsG is satisfied, where:
                        * |.| means Euclidian norm
                        * v - scaled gradient vector, v[i]=g[i]*s[i]
                        * g - gradient
                        * s - scaling coefficients set by MinLBFGSSetScale()
            EpsF    -   >=0
                        The  subroutine  finishes  its work if on k+1-th iteration
                        the  condition  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
                        is satisfied.
            EpsX    -   >=0
                        The subroutine finishes its work if  on  k+1-th  iteration
                        the condition |v|<=EpsX is fulfilled, where:
                        * |.| means Euclidian norm
                        * v - scaled step vector, v[i]=dx[i]/s[i]
                        * dx - ste pvector, dx=X(k+1)-X(k)
                        * s - scaling coefficients set by MinLBFGSSetScale()
            MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                        iterations is unlimited.

        Passing EpsG=0, EpsF=0, EpsX=0 and MaxIts=0 (simultaneously) will lead to
        automatic stopping criterion selection (small EpsX).

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetcond(minlbfgsstate state,
            double epsg,
            double epsf,
            double epsx,
            int maxits)
        {
            alglib.ap.assert(math.isfinite(epsg), "MinLBFGSSetCond: EpsG is not finite number!");
            alglib.ap.assert((double)(epsg)>=(double)(0), "MinLBFGSSetCond: negative EpsG!");
            alglib.ap.assert(math.isfinite(epsf), "MinLBFGSSetCond: EpsF is not finite number!");
            alglib.ap.assert((double)(epsf)>=(double)(0), "MinLBFGSSetCond: negative EpsF!");
            alglib.ap.assert(math.isfinite(epsx), "MinLBFGSSetCond: EpsX is not finite number!");
            alglib.ap.assert((double)(epsx)>=(double)(0), "MinLBFGSSetCond: negative EpsX!");
            alglib.ap.assert(maxits>=0, "MinLBFGSSetCond: negative MaxIts!");
            if( (((double)(epsg)==(double)(0) && (double)(epsf)==(double)(0)) && (double)(epsx)==(double)(0)) && maxits==0 )
            {
                epsx = 1.0E-6;
            }
            state.epsg = epsg;
            state.epsf = epsf;
            state.epsx = epsx;
            state.maxits = maxits;
        }


        /*************************************************************************
        This function turns on/off reporting.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            NeedXRep-   whether iteration reports are needed or not

        If NeedXRep is True, algorithm will call rep() callback function if  it is
        provided to MinLBFGSOptimize().


          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetxrep(minlbfgsstate state,
            bool needxrep)
        {
            state.xrep = needxrep;
        }


        /*************************************************************************
        This function sets maximum step length

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            StpMax  -   maximum step length, >=0. Set StpMax to 0.0 (default),  if
                        you don't want to limit step length.

        Use this subroutine when you optimize target function which contains exp()
        or  other  fast  growing  functions,  and optimization algorithm makes too
        large  steps  which  leads  to overflow. This function allows us to reject
        steps  that  are  too  large  (and  therefore  expose  us  to the possible
        overflow) without actually calculating function value at the x+stp*d.

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetstpmax(minlbfgsstate state,
            double stpmax)
        {
            alglib.ap.assert(math.isfinite(stpmax), "MinLBFGSSetStpMax: StpMax is not finite!");
            alglib.ap.assert((double)(stpmax)>=(double)(0), "MinLBFGSSetStpMax: StpMax<0!");
            state.stpmax = stpmax;
        }


        /*************************************************************************
        This function sets scaling coefficients for LBFGS optimizer.

        ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
        size and gradient are scaled before comparison with tolerances).  Scale of
        the I-th variable is a translation invariant measure of:
        a) "how large" the variable is
        b) how large the step should be to make significant changes in the function

        Scaling is also used by finite difference variant of the optimizer  - step
        along I-th axis is equal to DiffStep*S[I].

        In  most  optimizers  (and  in  the  LBFGS  too)  scaling is NOT a form of
        preconditioning. It just  affects  stopping  conditions.  You  should  set
        preconditioner  by  separate  call  to  one  of  the  MinLBFGSSetPrec...()
        functions.

        There  is  special  preconditioning  mode, however,  which  uses   scaling
        coefficients to form diagonal preconditioning matrix. You  can  turn  this
        mode on, if you want.   But  you should understand that scaling is not the
        same thing as preconditioning - these are two different, although  related
        forms of tuning solver.

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            S       -   array[N], non-zero scaling coefficients
                        S[i] may be negative, sign doesn't matter.

          -- ALGLIB --
             Copyright 14.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetscale(minlbfgsstate state,
            double[] s)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(s)>=state.n, "MinLBFGSSetScale: Length(S)<N");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(s[i]), "MinLBFGSSetScale: S contains infinite or NAN elements");
                alglib.ap.assert((double)(s[i])!=(double)(0), "MinLBFGSSetScale: S contains zero elements");
                state.s[i] = Math.Abs(s[i]);
            }
        }


        /*************************************************************************
        Extended subroutine for internal use only.

        Accepts additional parameters:

            Flags - additional settings:
                    * Flags = 0     means no additional settings
                    * Flags = 1     "do not allocate memory". used when solving
                                    a many subsequent tasks with  same N/M  values.
                                    First  call MUST  be without this flag bit set,
                                    subsequent  calls   of   MinLBFGS   with   same
                                    MinLBFGSState structure can set Flags to 1.
            DiffStep - numerical differentiation step

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgscreatex(int n,
            int m,
            double[] x,
            int flags,
            double diffstep,
            minlbfgsstate state)
        {
            bool allocatemem = new bool();
            int i = 0;

            alglib.ap.assert(n>=1, "MinLBFGS: N too small!");
            alglib.ap.assert(m>=1, "MinLBFGS: M too small!");
            alglib.ap.assert(m<=n, "MinLBFGS: M too large!");
            
            //
            // Initialize
            //
            state.teststep = 0;
            state.diffstep = diffstep;
            state.n = n;
            state.m = m;
            allocatemem = flags%2==0;
            flags = flags/2;
            if( allocatemem )
            {
                state.rho = new double[m];
                state.theta = new double[m];
                state.yk = new double[m, n];
                state.sk = new double[m, n];
                state.d = new double[n];
                state.xp = new double[n];
                state.x = new double[n];
                state.s = new double[n];
                state.g = new double[n];
                state.work = new double[n];
            }
            minlbfgssetcond(state, 0, 0, 0, 0);
            minlbfgssetxrep(state, false);
            minlbfgssetstpmax(state, 0);
            minlbfgsrestartfrom(state, x);
            for(i=0; i<=n-1; i++)
            {
                state.s[i] = 1.0;
            }
            state.prectype = 0;
        }


        /*************************************************************************
        Modification  of  the  preconditioner:  default  preconditioner    (simple
        scaling, same for all elements of X) is used.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

        NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
        iterations.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetprecdefault(minlbfgsstate state)
        {
            state.prectype = 0;
        }


        /*************************************************************************
        Modification of the preconditioner: Cholesky factorization of  approximate
        Hessian is used.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            P       -   triangular preconditioner, Cholesky factorization of
                        the approximate Hessian. array[0..N-1,0..N-1],
                        (if larger, only leading N elements are used).
            IsUpper -   whether upper or lower triangle of P is given
                        (other triangle is not referenced)

        After call to this function preconditioner is changed to P  (P  is  copied
        into the internal buffer).

        NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
        iterations.

        NOTE 2:  P  should  be nonsingular. Exception will be thrown otherwise.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetpreccholesky(minlbfgsstate state,
            double[,] p,
            bool isupper)
        {
            int i = 0;
            double mx = 0;

            alglib.ap.assert(apserv.isfinitertrmatrix(p, state.n, isupper), "MinLBFGSSetPrecCholesky: P contains infinite or NAN values!");
            mx = 0;
            for(i=0; i<=state.n-1; i++)
            {
                mx = Math.Max(mx, Math.Abs(p[i,i]));
            }
            alglib.ap.assert((double)(mx)>(double)(0), "MinLBFGSSetPrecCholesky: P is strictly singular!");
            if( alglib.ap.rows(state.denseh)<state.n || alglib.ap.cols(state.denseh)<state.n )
            {
                state.denseh = new double[state.n, state.n];
            }
            state.prectype = 1;
            if( isupper )
            {
                ablas.rmatrixcopy(state.n, state.n, p, 0, 0, ref state.denseh, 0, 0);
            }
            else
            {
                ablas.rmatrixtranspose(state.n, state.n, p, 0, 0, state.denseh, 0, 0);
            }
        }


        /*************************************************************************
        Modification  of  the  preconditioner:  diagonal of approximate Hessian is
        used.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            D       -   diagonal of the approximate Hessian, array[0..N-1],
                        (if larger, only leading N elements are used).

        NOTE:  you  can  change  preconditioner  "on  the  fly",  during algorithm
        iterations.

        NOTE 2: D[i] should be positive. Exception will be thrown otherwise.

        NOTE 3: you should pass diagonal of approximate Hessian - NOT ITS INVERSE.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetprecdiag(minlbfgsstate state,
            double[] d)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(d)>=state.n, "MinLBFGSSetPrecDiag: D is too short");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(d[i]), "MinLBFGSSetPrecDiag: D contains infinite or NAN elements");
                alglib.ap.assert((double)(d[i])>(double)(0), "MinLBFGSSetPrecDiag: D contains non-positive elements");
            }
            apserv.rvectorsetlengthatleast(ref state.diagh, state.n);
            state.prectype = 2;
            for(i=0; i<=state.n-1; i++)
            {
                state.diagh[i] = d[i];
            }
        }


        /*************************************************************************
        Modification of the preconditioner: scale-based diagonal preconditioning.

        This preconditioning mode can be useful when you  don't  have  approximate
        diagonal of Hessian, but you know that your  variables  are  badly  scaled
        (for  example,  one  variable is in [1,10], and another in [1000,100000]),
        and most part of the ill-conditioning comes from different scales of vars.

        In this case simple  scale-based  preconditioner,  with H[i] = 1/(s[i]^2),
        can greatly improve convergence.

        IMPRTANT: you should set scale of your variables  with  MinLBFGSSetScale()
        call  (before  or after MinLBFGSSetPrecScale() call). Without knowledge of
        the scale of your variables scale-based preconditioner will be  just  unit
        matrix.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetprecscale(minlbfgsstate state)
        {
            state.prectype = 3;
        }


        /*************************************************************************
        This function sets low-rank preconditioner for Hessian matrix  H=D+W'*C*W,
        where:
        * H is a Hessian matrix, which is approximated by D/W/C
        * D is a NxN diagonal positive definite matrix
        * W is a KxN low-rank correction
        * C is a KxK positive definite diagonal factor of low-rank correction

        This preconditioner is inexact but fast - it requires O(N*K)  time  to  be
        applied. Preconditioner P is calculated by artificially constructing a set
        of BFGS updates which tries to reproduce behavior of H:
        * Sk = Wk (k-th row of W)
        * Yk = (D+Wk'*Ck*Wk)*Sk
        * Yk/Sk are reordered by ascending of C[k]*norm(Wk)^2

        Here we assume that rows of Wk are orthogonal or nearly orthogonal,  which
        allows us to have O(N*K+K^2) update instead of O(N*K^2) one. Reordering of
        updates is essential for having good performance on non-orthogonal problems
        (updates which do not add much of curvature are added first,  and  updates
        which add very large eigenvalues are added last and override effect of the
        first updates).

        In practice, this preconditioner is perfect when ortogonal  correction  is
        applied; on non-orthogonal problems sometimes  it  allows  to  achieve  5x
        speedup (when compared to non-preconditioned solver).

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetprecrankklbfgsfast(minlbfgsstate state,
            double[] d,
            double[] c,
            double[,] w,
            int cnt)
        {
            int i = 0;
            int j = 0;
            int n = 0;

            n = state.n;
            state.prectype = 4;
            state.preck = cnt;
            apserv.rvectorsetlengthatleast(ref state.precc, cnt);
            apserv.rvectorsetlengthatleast(ref state.precd, n);
            apserv.rmatrixsetlengthatleast(ref state.precw, cnt, n);
            for(i=0; i<=n-1; i++)
            {
                state.precd[i] = d[i];
            }
            for(i=0; i<=cnt-1; i++)
            {
                state.precc[i] = c[i];
                for(j=0; j<=n-1; j++)
                {
                    state.precw[i,j] = w[i,j];
                }
            }
        }


        /*************************************************************************
        This function  sets  exact  low-rank  preconditioner  for  Hessian  matrix
        H=D+W'*C*W, where:
        * H is a Hessian matrix, which is approximated by D/W/C
        * D is a NxN diagonal positive definite matrix
        * W is a KxN low-rank correction
        * C is a KxK semidefinite diagonal factor of low-rank correction

        This preconditioner is exact but slow - it requires O(N*K^2)  time  to  be
        built and O(N*K) time to be applied. Woodbury matrix identity is  used  to
        build inverse matrix.

          -- ALGLIB --
             Copyright 13.10.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetpreclowrankexact(minlbfgsstate state,
            double[] d,
            double[] c,
            double[,] w,
            int cnt)
        {
            state.prectype = 5;
            optserv.preparelowrankpreconditioner(d, c, w, state.n, cnt, state.lowrankbuf);
        }


        /*************************************************************************
        NOTES:

        1. This function has two different implementations: one which  uses  exact
           (analytical) user-supplied gradient,  and one which uses function value
           only  and  numerically  differentiates  function  in  order  to  obtain
           gradient.

           Depending  on  the  specific  function  used to create optimizer object
           (either MinLBFGSCreate() for analytical gradient  or  MinLBFGSCreateF()
           for numerical differentiation) you should choose appropriate variant of
           MinLBFGSOptimize() - one  which  accepts  function  AND gradient or one
           which accepts function ONLY.

           Be careful to choose variant of MinLBFGSOptimize() which corresponds to
           your optimization scheme! Table below lists different  combinations  of
           callback (function/gradient) passed to MinLBFGSOptimize()  and specific
           function used to create optimizer.


                             |         USER PASSED TO MinLBFGSOptimize()
           CREATED WITH      |  function only   |  function and gradient
           ------------------------------------------------------------
           MinLBFGSCreateF() |     work                FAIL
           MinLBFGSCreate()  |     FAIL                work

           Here "FAIL" denotes inappropriate combinations  of  optimizer  creation
           function  and  MinLBFGSOptimize()  version.   Attemps   to   use   such
           combination (for example, to create optimizer with MinLBFGSCreateF() and
           to pass gradient information to MinCGOptimize()) will lead to exception
           being thrown. Either  you  did  not pass gradient when it WAS needed or
           you passed gradient when it was NOT needed.

          -- ALGLIB --
             Copyright 20.03.2009 by Bochkanov Sergey
        *************************************************************************/
        public static bool minlbfgsiteration(minlbfgsstate state)
        {
            bool result = new bool();
            int n = 0;
            int m = 0;
            int i = 0;
            int j = 0;
            int ic = 0;
            int mcinfo = 0;
            double v = 0;
            double vv = 0;
            int i_ = 0;

            
            //
            // Reverse communication preparations
            // I know it looks ugly, but it works the same way
            // anywhere from C++ to Python.
            //
            // This code initializes locals by:
            // * random values determined during code
            //   generation - on first subroutine call
            // * values from previous call - on subsequent calls
            //
            if( state.rstate.stage>=0 )
            {
                n = state.rstate.ia[0];
                m = state.rstate.ia[1];
                i = state.rstate.ia[2];
                j = state.rstate.ia[3];
                ic = state.rstate.ia[4];
                mcinfo = state.rstate.ia[5];
                v = state.rstate.ra[0];
                vv = state.rstate.ra[1];
            }
            else
            {
                n = -983;
                m = -989;
                i = -834;
                j = 900;
                ic = -287;
                mcinfo = 364;
                v = 214;
                vv = -338;
            }
            if( state.rstate.stage==0 )
            {
                goto lbl_0;
            }
            if( state.rstate.stage==1 )
            {
                goto lbl_1;
            }
            if( state.rstate.stage==2 )
            {
                goto lbl_2;
            }
            if( state.rstate.stage==3 )
            {
                goto lbl_3;
            }
            if( state.rstate.stage==4 )
            {
                goto lbl_4;
            }
            if( state.rstate.stage==5 )
            {
                goto lbl_5;
            }
            if( state.rstate.stage==6 )
            {
                goto lbl_6;
            }
            if( state.rstate.stage==7 )
            {
                goto lbl_7;
            }
            if( state.rstate.stage==8 )
            {
                goto lbl_8;
            }
            if( state.rstate.stage==9 )
            {
                goto lbl_9;
            }
            if( state.rstate.stage==10 )
            {
                goto lbl_10;
            }
            if( state.rstate.stage==11 )
            {
                goto lbl_11;
            }
            if( state.rstate.stage==12 )
            {
                goto lbl_12;
            }
            if( state.rstate.stage==13 )
            {
                goto lbl_13;
            }
            if( state.rstate.stage==14 )
            {
                goto lbl_14;
            }
            if( state.rstate.stage==15 )
            {
                goto lbl_15;
            }
            if( state.rstate.stage==16 )
            {
                goto lbl_16;
            }
            
            //
            // Routine body
            //
            
            //
            // Unload frequently used variables from State structure
            // (just for typing convinience)
            //
            n = state.n;
            m = state.m;
            state.userterminationneeded = false;
            state.repterminationtype = 0;
            state.repiterationscount = 0;
            state.repvaridx = -1;
            state.repnfev = 0;
            
            //
            //  Check, that transferred derivative value is right
            //
            clearrequestfields(state);
            if( !((double)(state.diffstep)==(double)(0) && (double)(state.teststep)>(double)(0)) )
            {
                goto lbl_17;
            }
            state.needfg = true;
            i = 0;
        lbl_19:
            if( i>n-1 )
            {
                goto lbl_21;
            }
            v = state.x[i];
            state.x[i] = v-state.teststep*state.s[i];
            state.rstate.stage = 0;
            goto lbl_rcomm;
        lbl_0:
            state.fm1 = state.f;
            state.fp1 = state.g[i];
            state.x[i] = v+state.teststep*state.s[i];
            state.rstate.stage = 1;
            goto lbl_rcomm;
        lbl_1:
            state.fm2 = state.f;
            state.fp2 = state.g[i];
            state.x[i] = v;
            state.rstate.stage = 2;
            goto lbl_rcomm;
        lbl_2:
            
            //
            // 2*State.TestStep   -   scale parameter
            // width of segment [Xi-TestStep;Xi+TestStep]
            //
            if( !optserv.derivativecheck(state.fm1, state.fp1, state.fm2, state.fp2, state.f, state.g[i], 2*state.teststep) )
            {
                state.repvaridx = i;
                state.repterminationtype = -7;
                result = false;
                return result;
            }
            i = i+1;
            goto lbl_19;
        lbl_21:
            state.needfg = false;
        lbl_17:
            
            //
            // Calculate F/G at the initial point
            //
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_22;
            }
            state.needfg = true;
            state.rstate.stage = 3;
            goto lbl_rcomm;
        lbl_3:
            state.needfg = false;
            goto lbl_23;
        lbl_22:
            state.needf = true;
            state.rstate.stage = 4;
            goto lbl_rcomm;
        lbl_4:
            state.fbase = state.f;
            i = 0;
        lbl_24:
            if( i>n-1 )
            {
                goto lbl_26;
            }
            v = state.x[i];
            state.x[i] = v-state.diffstep*state.s[i];
            state.rstate.stage = 5;
            goto lbl_rcomm;
        lbl_5:
            state.fm2 = state.f;
            state.x[i] = v-0.5*state.diffstep*state.s[i];
            state.rstate.stage = 6;
            goto lbl_rcomm;
        lbl_6:
            state.fm1 = state.f;
            state.x[i] = v+0.5*state.diffstep*state.s[i];
            state.rstate.stage = 7;
            goto lbl_rcomm;
        lbl_7:
            state.fp1 = state.f;
            state.x[i] = v+state.diffstep*state.s[i];
            state.rstate.stage = 8;
            goto lbl_rcomm;
        lbl_8:
            state.fp2 = state.f;
            state.x[i] = v;
            state.g[i] = (8*(state.fp1-state.fm1)-(state.fp2-state.fm2))/(6*state.diffstep*state.s[i]);
            i = i+1;
            goto lbl_24;
        lbl_26:
            state.f = state.fbase;
            state.needf = false;
        lbl_23:
            optserv.trimprepare(state.f, ref state.trimthreshold);
            if( !state.xrep )
            {
                goto lbl_27;
            }
            clearrequestfields(state);
            state.xupdated = true;
            state.rstate.stage = 9;
            goto lbl_rcomm;
        lbl_9:
            state.xupdated = false;
        lbl_27:
            if( state.userterminationneeded )
            {
                
                //
                // User requested termination
                //
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            state.repnfev = 1;
            state.fold = state.f;
            v = 0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.g[i]*state.s[i]);
            }
            if( (double)(Math.Sqrt(v))<=(double)(state.epsg) )
            {
                state.repterminationtype = 4;
                result = false;
                return result;
            }
            
            //
            // Choose initial step and direction.
            // Apply preconditioner, if we have something other than default.
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.d[i_] = -state.g[i_];
            }
            if( state.prectype==0 )
            {
                
                //
                // Default preconditioner is used, but we can't use it before iterations will start
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.g[i_]*state.g[i_];
                }
                v = Math.Sqrt(v);
                if( (double)(state.stpmax)==(double)(0) )
                {
                    state.stp = Math.Min(1.0/v, 1);
                }
                else
                {
                    state.stp = Math.Min(1.0/v, state.stpmax);
                }
            }
            if( state.prectype==1 )
            {
                
                //
                // Cholesky preconditioner is used
                //
                fbls.fblscholeskysolve(state.denseh, 1.0, n, true, state.d, ref state.autobuf);
                state.stp = 1;
            }
            if( state.prectype==2 )
            {
                
                //
                // diagonal approximation is used
                //
                for(i=0; i<=n-1; i++)
                {
                    state.d[i] = state.d[i]/state.diagh[i];
                }
                state.stp = 1;
            }
            if( state.prectype==3 )
            {
                
                //
                // scale-based preconditioner is used
                //
                for(i=0; i<=n-1; i++)
                {
                    state.d[i] = state.d[i]*state.s[i]*state.s[i];
                }
                state.stp = 1;
            }
            if( state.prectype==4 )
            {
                
                //
                // rank-k BFGS-based preconditioner is used
                //
                optserv.inexactlbfgspreconditioner(state.d, n, state.precd, state.precc, state.precw, state.preck, state.precbuf);
                state.stp = 1;
            }
            if( state.prectype==5 )
            {
                
                //
                // exact low-rank preconditioner is used
                //
                optserv.applylowrankpreconditioner(state.d, state.lowrankbuf);
                state.stp = 1;
            }
            
            //
            // Main cycle
            //
            state.k = 0;
        lbl_29:
            if( false )
            {
                goto lbl_30;
            }
            
            //
            // Main cycle: prepare to 1-D line search
            //
            state.p = state.k%m;
            state.q = Math.Min(state.k, m-1);
            
            //
            // Store X[k], G[k]
            //
            for(i_=0; i_<=n-1;i_++)
            {
                state.xp[i_] = state.x[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.sk[state.p,i_] = -state.x[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.yk[state.p,i_] = -state.g[i_];
            }
            
            //
            // Minimize F(x+alpha*d)
            // Calculate S[k], Y[k]
            //
            state.mcstage = 0;
            if( state.k!=0 )
            {
                state.stp = 1.0;
            }
            linmin.linminnormalized(ref state.d, ref state.stp, n);
            linmin.mcsrch(n, ref state.x, ref state.f, ref state.g, state.d, ref state.stp, state.stpmax, gtol, ref mcinfo, ref state.nfev, ref state.work, state.lstate, ref state.mcstage);
        lbl_31:
            if( state.mcstage==0 )
            {
                goto lbl_32;
            }
            clearrequestfields(state);
            if( (double)(state.diffstep)!=(double)(0) )
            {
                goto lbl_33;
            }
            state.needfg = true;
            state.rstate.stage = 10;
            goto lbl_rcomm;
        lbl_10:
            state.needfg = false;
            goto lbl_34;
        lbl_33:
            state.needf = true;
            state.rstate.stage = 11;
            goto lbl_rcomm;
        lbl_11:
            state.fbase = state.f;
            i = 0;
        lbl_35:
            if( i>n-1 )
            {
                goto lbl_37;
            }
            v = state.x[i];
            state.x[i] = v-state.diffstep*state.s[i];
            state.rstate.stage = 12;
            goto lbl_rcomm;
        lbl_12:
            state.fm2 = state.f;
            state.x[i] = v-0.5*state.diffstep*state.s[i];
            state.rstate.stage = 13;
            goto lbl_rcomm;
        lbl_13:
            state.fm1 = state.f;
            state.x[i] = v+0.5*state.diffstep*state.s[i];
            state.rstate.stage = 14;
            goto lbl_rcomm;
        lbl_14:
            state.fp1 = state.f;
            state.x[i] = v+state.diffstep*state.s[i];
            state.rstate.stage = 15;
            goto lbl_rcomm;
        lbl_15:
            state.fp2 = state.f;
            state.x[i] = v;
            state.g[i] = (8*(state.fp1-state.fm1)-(state.fp2-state.fm2))/(6*state.diffstep*state.s[i]);
            i = i+1;
            goto lbl_35;
        lbl_37:
            state.f = state.fbase;
            state.needf = false;
        lbl_34:
            optserv.trimfunction(ref state.f, ref state.g, n, state.trimthreshold);
            linmin.mcsrch(n, ref state.x, ref state.f, ref state.g, state.d, ref state.stp, state.stpmax, gtol, ref mcinfo, ref state.nfev, ref state.work, state.lstate, ref state.mcstage);
            goto lbl_31;
        lbl_32:
            if( state.userterminationneeded )
            {
                
                //
                // User requested termination.
                // Restore previous point and return.
                //
                for(i_=0; i_<=n-1;i_++)
                {
                    state.x[i_] = state.xp[i_];
                }
                state.repterminationtype = 8;
                result = false;
                return result;
            }
            if( !state.xrep )
            {
                goto lbl_38;
            }
            
            //
            // report
            //
            clearrequestfields(state);
            state.xupdated = true;
            state.rstate.stage = 16;
            goto lbl_rcomm;
        lbl_16:
            state.xupdated = false;
        lbl_38:
            state.repnfev = state.repnfev+state.nfev;
            state.repiterationscount = state.repiterationscount+1;
            for(i_=0; i_<=n-1;i_++)
            {
                state.sk[state.p,i_] = state.sk[state.p,i_] + state.x[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                state.yk[state.p,i_] = state.yk[state.p,i_] + state.g[i_];
            }
            
            //
            // Stopping conditions
            //
            v = 0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.g[i]*state.s[i]);
            }
            if( !math.isfinite(v) || !math.isfinite(state.f) )
            {
                
                //
                // Abnormal termination - infinities in function/gradient
                //
                state.repterminationtype = -8;
                result = false;
                return result;
            }
            if( state.repiterationscount>=state.maxits && state.maxits>0 )
            {
                
                //
                // Too many iterations
                //
                state.repterminationtype = 5;
                result = false;
                return result;
            }
            if( (double)(Math.Sqrt(v))<=(double)(state.epsg) )
            {
                
                //
                // Gradient is small enough
                //
                state.repterminationtype = 4;
                result = false;
                return result;
            }
            if( (double)(state.fold-state.f)<=(double)(state.epsf*Math.Max(Math.Abs(state.fold), Math.Max(Math.Abs(state.f), 1.0))) )
            {
                
                //
                // F(k+1)-F(k) is small enough
                //
                state.repterminationtype = 1;
                result = false;
                return result;
            }
            v = 0;
            for(i=0; i<=n-1; i++)
            {
                v = v+math.sqr(state.sk[state.p,i]/state.s[i]);
            }
            if( (double)(Math.Sqrt(v))<=(double)(state.epsx) )
            {
                
                //
                // X(k+1)-X(k) is small enough
                //
                state.repterminationtype = 2;
                result = false;
                return result;
            }
            
            //
            // If Wolfe conditions are satisfied, we can update
            // limited memory model.
            //
            // However, if conditions are not satisfied (NFEV limit is met,
            // function is too wild, ...), we'll skip L-BFGS update
            //
            if( mcinfo!=1 )
            {
                
                //
                // Skip update.
                //
                // In such cases we'll initialize search direction by
                // antigradient vector, because it  leads to more
                // transparent code with less number of special cases
                //
                state.fold = state.f;
                for(i_=0; i_<=n-1;i_++)
                {
                    state.d[i_] = -state.g[i_];
                }
            }
            else
            {
                
                //
                // Calculate Rho[k], GammaK
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += state.yk[state.p,i_]*state.sk[state.p,i_];
                }
                vv = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    vv += state.yk[state.p,i_]*state.yk[state.p,i_];
                }
                if( (double)(v)==(double)(0) || (double)(vv)==(double)(0) )
                {
                    
                    //
                    // Rounding errors make further iterations impossible.
                    //
                    state.repterminationtype = -2;
                    result = false;
                    return result;
                }
                state.rho[state.p] = 1/v;
                state.gammak = v/vv;
                
                //
                //  Calculate d(k+1) = -H(k+1)*g(k+1)
                //
                //  for I:=K downto K-Q do
                //      V = s(i)^T * work(iteration:I)
                //      theta(i) = V
                //      work(iteration:I+1) = work(iteration:I) - V*Rho(i)*y(i)
                //  work(last iteration) = H0*work(last iteration) - preconditioner
                //  for I:=K-Q to K do
                //      V = y(i)^T*work(iteration:I)
                //      work(iteration:I+1) = work(iteration:I) +(-V+theta(i))*Rho(i)*s(i)
                //
                //  NOW WORK CONTAINS d(k+1)
                //
                for(i_=0; i_<=n-1;i_++)
                {
                    state.work[i_] = state.g[i_];
                }
                for(i=state.k; i>=state.k-state.q; i--)
                {
                    ic = i%m;
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += state.sk[ic,i_]*state.work[i_];
                    }
                    state.theta[ic] = v;
                    vv = v*state.rho[ic];
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.work[i_] = state.work[i_] - vv*state.yk[ic,i_];
                    }
                }
                if( state.prectype==0 )
                {
                    
                    //
                    // Simple preconditioner is used
                    //
                    v = state.gammak;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.work[i_] = v*state.work[i_];
                    }
                }
                if( state.prectype==1 )
                {
                    
                    //
                    // Cholesky preconditioner is used
                    //
                    fbls.fblscholeskysolve(state.denseh, 1, n, true, state.work, ref state.autobuf);
                }
                if( state.prectype==2 )
                {
                    
                    //
                    // diagonal approximation is used
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        state.work[i] = state.work[i]/state.diagh[i];
                    }
                }
                if( state.prectype==3 )
                {
                    
                    //
                    // scale-based preconditioner is used
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        state.work[i] = state.work[i]*state.s[i]*state.s[i];
                    }
                }
                if( state.prectype==4 )
                {
                    
                    //
                    // Rank-K BFGS-based preconditioner is used
                    //
                    optserv.inexactlbfgspreconditioner(state.work, n, state.precd, state.precc, state.precw, state.preck, state.precbuf);
                }
                if( state.prectype==5 )
                {
                    
                    //
                    // Exact low-rank preconditioner is used
                    //
                    optserv.applylowrankpreconditioner(state.work, state.lowrankbuf);
                }
                for(i=state.k-state.q; i<=state.k; i++)
                {
                    ic = i%m;
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += state.yk[ic,i_]*state.work[i_];
                    }
                    vv = state.rho[ic]*(-v+state.theta[ic]);
                    for(i_=0; i_<=n-1;i_++)
                    {
                        state.work[i_] = state.work[i_] + vv*state.sk[ic,i_];
                    }
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    state.d[i_] = -state.work[i_];
                }
                
                //
                // Next step
                //
                state.fold = state.f;
                state.k = state.k+1;
            }
            goto lbl_29;
        lbl_30:
            result = false;
            return result;
            
            //
            // Saving state
            //
        lbl_rcomm:
            result = true;
            state.rstate.ia[0] = n;
            state.rstate.ia[1] = m;
            state.rstate.ia[2] = i;
            state.rstate.ia[3] = j;
            state.rstate.ia[4] = ic;
            state.rstate.ia[5] = mcinfo;
            state.rstate.ra[0] = v;
            state.rstate.ra[1] = vv;
            return result;
        }


        /*************************************************************************
        L-BFGS algorithm results

        INPUT PARAMETERS:
            State   -   algorithm state

        OUTPUT PARAMETERS:
            X       -   array[0..N-1], solution
            Rep     -   optimization report:
                        * Rep.TerminationType completetion code:
                            * -8    internal integrity control  detected  infinite
                                    or NAN values in  function/gradient.  Abnormal
                                    termination signalled.
                            * -7    gradient verification failed.
                                    See MinLBFGSSetGradientCheck() for more information.
                            * -2    rounding errors prevent further improvement.
                                    X contains best point found.
                            * -1    incorrect parameters were specified
                            *  1    relative function improvement is no more than
                                    EpsF.
                            *  2    relative step is no more than EpsX.
                            *  4    gradient norm is no more than EpsG
                            *  5    MaxIts steps was taken
                            *  7    stopping conditions are too stringent,
                                    further improvement is impossible
                            *  8    terminated by user who called minlbfgsrequesttermination().
                                    X contains point which was "current accepted" when
                                    termination request was submitted.
                        * Rep.IterationsCount contains iterations count
                        * NFEV countains number of function calculations

          -- ALGLIB --
             Copyright 02.04.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgsresults(minlbfgsstate state,
            ref double[] x,
            minlbfgsreport rep)
        {
            x = new double[0];

            minlbfgsresultsbuf(state, ref x, rep);
        }


        /*************************************************************************
        L-BFGS algorithm results

        Buffered implementation of MinLBFGSResults which uses pre-allocated buffer
        to store X[]. If buffer size is  too  small,  it  resizes  buffer.  It  is
        intended to be used in the inner cycles of performance critical algorithms
        where array reallocation penalty is too large to be ignored.

          -- ALGLIB --
             Copyright 20.08.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgsresultsbuf(minlbfgsstate state,
            ref double[] x,
            minlbfgsreport rep)
        {
            int i_ = 0;

            if( alglib.ap.len(x)<state.n )
            {
                x = new double[state.n];
            }
            for(i_=0; i_<=state.n-1;i_++)
            {
                x[i_] = state.x[i_];
            }
            rep.iterationscount = state.repiterationscount;
            rep.nfev = state.repnfev;
            rep.varidx = state.repvaridx;
            rep.terminationtype = state.repterminationtype;
        }


        /*************************************************************************
        This  subroutine restarts LBFGS algorithm from new point. All optimization
        parameters are left unchanged.

        This  function  allows  to  solve multiple  optimization  problems  (which
        must have same number of dimensions) without object reallocation penalty.

        INPUT PARAMETERS:
            State   -   structure used to store algorithm state
            X       -   new starting point.

          -- ALGLIB --
             Copyright 30.07.2010 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgsrestartfrom(minlbfgsstate state,
            double[] x)
        {
            int i_ = 0;

            alglib.ap.assert(alglib.ap.len(x)>=state.n, "MinLBFGSRestartFrom: Length(X)<N!");
            alglib.ap.assert(apserv.isfinitevector(x, state.n), "MinLBFGSRestartFrom: X contains infinite or NaN values!");
            for(i_=0; i_<=state.n-1;i_++)
            {
                state.x[i_] = x[i_];
            }
            state.rstate.ia = new int[5+1];
            state.rstate.ra = new double[1+1];
            state.rstate.stage = -1;
            clearrequestfields(state);
        }


        /*************************************************************************
        This subroutine submits request for termination of running  optimizer.  It
        should be called from user-supplied callback when user decides that it  is
        time to "smoothly" terminate optimization process.  As  result,  optimizer
        stops at point which was "current accepted" when termination  request  was
        submitted and returns error code 8 (successful termination).

        INPUT PARAMETERS:
            State   -   optimizer structure

        NOTE: after  request  for  termination  optimizer  may   perform   several
              additional calls to user-supplied callbacks. It does  NOT  guarantee
              to stop immediately - it just guarantees that these additional calls
              will be discarded later.

        NOTE: calling this function on optimizer which is NOT running will have no
              effect.
              
        NOTE: multiple calls to this function are possible. First call is counted,
              subsequent calls are silently ignored.

          -- ALGLIB --
             Copyright 08.10.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgsrequesttermination(minlbfgsstate state)
        {
            state.userterminationneeded = true;
        }


        /*************************************************************************
        This  subroutine  turns  on  verification  of  the  user-supplied analytic
        gradient:
        * user calls this subroutine before optimization begins
        * MinLBFGSOptimize() is called
        * prior to  actual  optimization, for each component  of  parameters being
          optimized X[i] algorithm performs following steps:
          * two trial steps are made to X[i]-TestStep*S[i] and X[i]+TestStep*S[i],
            where X[i] is i-th component of the initial point and S[i] is a  scale
            of i-th parameter
          * if needed, steps are bounded with respect to constraints on X[]
          * F(X) is evaluated at these trial points
          * we perform one more evaluation in the middle point of the interval
          * we  build  cubic  model using function values and derivatives at trial
            points and we compare its prediction with actual value in  the  middle
            point
          * in case difference between prediction and actual value is higher  than
            some predetermined threshold, algorithm stops with completion code -7;
            Rep.VarIdx is set to index of the parameter with incorrect derivative.
        * after verification is over, algorithm proceeds to the actual optimization.

        NOTE 1: verification  needs  N (parameters count) gradient evaluations. It
                is very costly and you should use  it  only  for  low  dimensional
                problems,  when  you  want  to  be  sure  that  you've   correctly
                calculated  analytic  derivatives.  You  should  not use it in the
                production code (unless you want to check derivatives provided  by
                some third party).

        NOTE 2: you  should  carefully  choose  TestStep. Value which is too large
                (so large that function behaviour is significantly non-cubic) will
                lead to false alarms. You may use  different  step  for  different
                parameters by means of setting scale with MinLBFGSSetScale().

        NOTE 3: this function may lead to false positives. In case it reports that
                I-th  derivative was calculated incorrectly, you may decrease test
                step  and  try  one  more  time  - maybe your function changes too
                sharply  and  your  step  is  too  large for such rapidly chanding
                function.

        INPUT PARAMETERS:
            State       -   structure used to store algorithm state
            TestStep    -   verification step:
                            * TestStep=0 turns verification off
                            * TestStep>0 activates verification

          -- ALGLIB --
             Copyright 24.05.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void minlbfgssetgradientcheck(minlbfgsstate state,
            double teststep)
        {
            alglib.ap.assert(math.isfinite(teststep), "MinLBFGSSetGradientCheck: TestStep contains NaN or Infinite");
            alglib.ap.assert((double)(teststep)>=(double)(0), "MinLBFGSSetGradientCheck: invalid argument TestStep(TestStep<0)");
            state.teststep = teststep;
        }


        /*************************************************************************
        Clears request fileds (to be sure that we don't forgot to clear something)
        *************************************************************************/
        private static void clearrequestfields(minlbfgsstate state)
        {
            state.needf = false;
            state.needfg = false;
            state.xupdated = false;
        }


    }
    public class qqpsolver
    {
        /*************************************************************************
        This object stores settings for QQP solver.
        It must be initialized with QQPLoadDefaults().
        After initialization you may change settings.
        *************************************************************************/
        public class qqpsettings : apobject
        {
            public double epsg;
            public double epsf;
            public double epsx;
            public int maxouterits;
            public bool cgphase;
            public bool cnphase;
            public int cgminits;
            public int cgmaxits;
            public int cnmaxupdates;
            public int sparsesolver;
            public qqpsettings()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                qqpsettings _result = new qqpsettings();
                _result.epsg = epsg;
                _result.epsf = epsf;
                _result.epsx = epsx;
                _result.maxouterits = maxouterits;
                _result.cgphase = cgphase;
                _result.cnphase = cnphase;
                _result.cgminits = cgminits;
                _result.cgmaxits = cgmaxits;
                _result.cnmaxupdates = cnmaxupdates;
                _result.sparsesolver = sparsesolver;
                return _result;
            }
        };


        /*************************************************************************
        This object stores temporaries used by QuickQP solver.
        *************************************************************************/
        public class qqpbuffers : apobject
        {
            public int n;
            public int nmain;
            public int nslack;
            public int nec;
            public int nic;
            public int akind;
            public double[,] densea;
            public sparse.sparsematrix sparsea;
            public bool sparseupper;
            public double absamax;
            public double absasum;
            public double absasum2;
            public double[] b;
            public double[] bndl;
            public double[] bndu;
            public bool[] havebndl;
            public bool[] havebndu;
            public double[,] cleic;
            public double[] xs;
            public double[] gc;
            public double[] xp;
            public double[] dc;
            public double[] dp;
            public double[] cgc;
            public double[] cgp;
            public sactivesets.sactiveset sas;
            public bool[] activated;
            public int nfree;
            public int cnmodelage;
            public double[,] densez;
            public sparse.sparsematrix sparsecca;
            public int[] yidx;
            public double[] regdiag;
            public double[] regx0;
            public double[] tmpcn;
            public int[] tmpcni;
            public bool[] tmpcnb;
            public double[] tmp0;
            public double[] stpbuf;
            public sparse.sparsebuffers sbuf;
            public int repinneriterationscount;
            public int repouteriterationscount;
            public int repncholesky;
            public int repncupdates;
            public qqpbuffers()
            {
                init();
            }
            public override void init()
            {
                densea = new double[0,0];
                sparsea = new sparse.sparsematrix();
                b = new double[0];
                bndl = new double[0];
                bndu = new double[0];
                havebndl = new bool[0];
                havebndu = new bool[0];
                cleic = new double[0,0];
                xs = new double[0];
                gc = new double[0];
                xp = new double[0];
                dc = new double[0];
                dp = new double[0];
                cgc = new double[0];
                cgp = new double[0];
                sas = new sactivesets.sactiveset();
                activated = new bool[0];
                densez = new double[0,0];
                sparsecca = new sparse.sparsematrix();
                yidx = new int[0];
                regdiag = new double[0];
                regx0 = new double[0];
                tmpcn = new double[0];
                tmpcni = new int[0];
                tmpcnb = new bool[0];
                tmp0 = new double[0];
                stpbuf = new double[0];
                sbuf = new sparse.sparsebuffers();
            }
            public override alglib.apobject make_copy()
            {
                qqpbuffers _result = new qqpbuffers();
                _result.n = n;
                _result.nmain = nmain;
                _result.nslack = nslack;
                _result.nec = nec;
                _result.nic = nic;
                _result.akind = akind;
                _result.densea = (double[,])densea.Clone();
                _result.sparsea = (sparse.sparsematrix)sparsea.make_copy();
                _result.sparseupper = sparseupper;
                _result.absamax = absamax;
                _result.absasum = absasum;
                _result.absasum2 = absasum2;
                _result.b = (double[])b.Clone();
                _result.bndl = (double[])bndl.Clone();
                _result.bndu = (double[])bndu.Clone();
                _result.havebndl = (bool[])havebndl.Clone();
                _result.havebndu = (bool[])havebndu.Clone();
                _result.cleic = (double[,])cleic.Clone();
                _result.xs = (double[])xs.Clone();
                _result.gc = (double[])gc.Clone();
                _result.xp = (double[])xp.Clone();
                _result.dc = (double[])dc.Clone();
                _result.dp = (double[])dp.Clone();
                _result.cgc = (double[])cgc.Clone();
                _result.cgp = (double[])cgp.Clone();
                _result.sas = (sactivesets.sactiveset)sas.make_copy();
                _result.activated = (bool[])activated.Clone();
                _result.nfree = nfree;
                _result.cnmodelage = cnmodelage;
                _result.densez = (double[,])densez.Clone();
                _result.sparsecca = (sparse.sparsematrix)sparsecca.make_copy();
                _result.yidx = (int[])yidx.Clone();
                _result.regdiag = (double[])regdiag.Clone();
                _result.regx0 = (double[])regx0.Clone();
                _result.tmpcn = (double[])tmpcn.Clone();
                _result.tmpcni = (int[])tmpcni.Clone();
                _result.tmpcnb = (bool[])tmpcnb.Clone();
                _result.tmp0 = (double[])tmp0.Clone();
                _result.stpbuf = (double[])stpbuf.Clone();
                _result.sbuf = (sparse.sparsebuffers)sbuf.make_copy();
                _result.repinneriterationscount = repinneriterationscount;
                _result.repouteriterationscount = repouteriterationscount;
                _result.repncholesky = repncholesky;
                _result.repncupdates = repncupdates;
                return _result;
            }
        };




        public const int quickqprestartcg = 50;
        public const double penaltyfactor = 50.0;
        public const double regz = 1.0E-9;


        /*************************************************************************
        This function initializes QQPSettings structure with default settings.

        Newly created structure MUST be initialized by default settings  -  or  by
        copy of the already initialized structure.

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qqploaddefaults(int nmain,
            qqpsettings s)
        {
            s.epsg = 0.0;
            s.epsf = 0.0;
            s.epsx = 1.0E-6;
            s.maxouterits = 0;
            s.cgphase = true;
            s.cnphase = true;
            s.cgminits = 5;
            s.cgmaxits = Math.Max(s.cgminits, (int)Math.Round(1+0.33*nmain));
            s.sparsesolver = 0;
            s.cnmaxupdates = (int)Math.Round(1+0.1*nmain);
        }


        /*************************************************************************
        This function initializes QQPSettings  structure  with  copy  of  another,
        already initialized structure.

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qqpcopysettings(qqpsettings src,
            qqpsettings dst)
        {
            dst.epsg = src.epsg;
            dst.epsf = src.epsf;
            dst.epsx = src.epsx;
            dst.maxouterits = src.maxouterits;
            dst.cgphase = src.cgphase;
            dst.cnphase = src.cnphase;
            dst.cgminits = src.cgminits;
            dst.cgmaxits = src.cgmaxits;
            dst.sparsesolver = src.sparsesolver;
            dst.cnmaxupdates = src.cnmaxupdates;
        }


        /*************************************************************************
        This function runs QQP solver; it returns after optimization  process  was
        completed. Following QP problem is solved:

            min(0.5*(x-x_origin)'*A*(x-x_origin)+b'*(x-x_origin))
            
        subject to boundary constraints.

        IMPORTANT: UNLIKE MANY OTHER SOLVERS, THIS FUNCTION DOES NOT  REQUIRE  YOU
                   TO INITIALIZE STATE OBJECT. IT CAN BE AUTOMATICALLY INITIALIZED
                   DURING SOLUTION PROCESS.

        INPUT PARAMETERS:
            AC          -   for dense problems (AKind=0) A-term of CQM object
                            contains system matrix. Other terms are unspecified
                            and should not be referenced.
            SparseAC    -   for sparse problems (AKind=1
            AKind       -   sparse matrix format:
                            * 0 for dense matrix
                            * 1 for sparse matrix
            SparseUpper -   which triangle of SparseAC stores matrix  -  upper  or
                            lower one (for dense matrices this  parameter  is  not
                            actual).
            BC          -   linear term, array[NC]
            BndLC       -   lower bound, array[NC]
            BndUC       -   upper bound, array[NC]
            SC          -   scale vector, array[NC]:
                            * I-th element contains scale of I-th variable,
                            * SC[I]>0
            XOriginC    -   origin term, array[NC]. Can be zero.
            NC          -   number of variables in the  original  formulation  (no
                            slack variables).
            CLEICC      -   linear equality/inequality constraints. Present version
                            of this function does NOT provide  publicly  available
                            support for linear constraints. This feature  will  be
                            introduced in the future versions of the function.
            NEC, NIC    -   number of equality/inequality constraints.
                            MUST BE ZERO IN THE CURRENT VERSION!!!
            Settings    -   QQPSettings object initialized by one of the initialization
                            functions.
            SState      -   object which stores temporaries:
                            * uninitialized object is automatically initialized
                            * previously allocated memory is reused as much
                              as possible
            XS          -   initial point, array[NC]
            
            
        OUTPUT PARAMETERS:
            XS          -   last point
            TerminationType-termination type:
                            *
                            *
                            *

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qqpoptimize(cqmodels.convexquadraticmodel ac,
            sparse.sparsematrix sparseac,
            int akind,
            bool sparseupper,
            double[] bc,
            double[] bndlc,
            double[] bnduc,
            double[] sc,
            double[] xoriginc,
            int nc,
            double[,] cleicc,
            int nec,
            int nic,
            qqpsettings settings,
            qqpbuffers sstate,
            double[] xs,
            ref int terminationtype)
        {
            int n = 0;
            int nmain = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            double vv = 0;
            double d2 = 0;
            double d1 = 0;
            int d1est = 0;
            int d2est = 0;
            bool needact = new bool();
            double reststp = 0;
            double fullstp = 0;
            double stpmax = 0;
            double stp = 0;
            int stpcnt = 0;
            int cidx = 0;
            double cval = 0;
            int cgcnt = 0;
            int cgmax = 0;
            int newtcnt = 0;
            int sparsesolver = 0;
            double beta = 0;
            bool b = new bool();
            double fprev = 0;
            double fcur = 0;
            int i_ = 0;

            terminationtype = 0;

            
            //
            // Primary checks
            //
            alglib.ap.assert(akind==0 || akind==1, "QQPOptimize: incorrect AKind");
            sstate.nmain = nc;
            sstate.nslack = nic;
            sstate.n = nc+nic;
            sstate.nec = nec;
            sstate.nic = nic;
            sstate.akind = akind;
            n = sstate.n;
            nmain = sstate.nmain;
            terminationtype = 0;
            sstate.repinneriterationscount = 0;
            sstate.repouteriterationscount = 0;
            sstate.repncholesky = 0;
            sstate.repncupdates = 0;
            
            //
            // Several checks
            // * matrix size
            // * scale vector
            // * consistency of bound constraints
            // * consistency of settings
            //
            if( akind==1 )
            {
                alglib.ap.assert(sparse.sparsegetnrows(sparseac)==nmain, "QQPOptimize: rows(SparseAC)<>NMain");
                alglib.ap.assert(sparse.sparsegetncols(sparseac)==nmain, "QQPOptimize: cols(SparseAC)<>NMain");
            }
            for(i=0; i<=nmain-1; i++)
            {
                alglib.ap.assert(math.isfinite(sc[i]) && (double)(sc[i])>(double)(0), "QQPOptimize: incorrect scale");
            }
            for(i=0; i<=nmain-1; i++)
            {
                if( math.isfinite(bndlc[i]) && math.isfinite(bnduc[i]) )
                {
                    if( (double)(bndlc[i])>(double)(bnduc[i]) )
                    {
                        terminationtype = -3;
                        return;
                    }
                }
            }
            alglib.ap.assert(settings.cgphase || settings.cnphase, "QQPOptimize: both phases (CG and Newton) are inactive");
            
            //
            // Allocate data structures
            //
            apserv.rvectorsetlengthatleast(ref sstate.bndl, n);
            apserv.rvectorsetlengthatleast(ref sstate.bndu, n);
            apserv.bvectorsetlengthatleast(ref sstate.havebndl, n);
            apserv.bvectorsetlengthatleast(ref sstate.havebndu, n);
            apserv.rvectorsetlengthatleast(ref sstate.xs, n);
            apserv.rvectorsetlengthatleast(ref sstate.xp, n);
            apserv.rvectorsetlengthatleast(ref sstate.gc, n);
            apserv.rvectorsetlengthatleast(ref sstate.cgc, n);
            apserv.rvectorsetlengthatleast(ref sstate.cgp, n);
            apserv.rvectorsetlengthatleast(ref sstate.dc, n);
            apserv.rvectorsetlengthatleast(ref sstate.dp, n);
            apserv.rvectorsetlengthatleast(ref sstate.tmp0, n);
            apserv.rvectorsetlengthatleast(ref sstate.stpbuf, 15);
            sactivesets.sasinit(n, sstate.sas);
            
            //
            // Scale/shift problem coefficients:
            //
            //     min { 0.5*(x-x0)'*A*(x-x0) + b'*(x-x0) }
            //
            // becomes (after transformation "x = S*y+x0")
            //
            //     min { 0.5*y'*(S*A*S)*y + (S*b)'*y
            //
            // Modified A_mod=S*A*S and b_mod=S*(b+A*x0) are
            // stored into SState.DenseA and SState.B.
            //
            // NOTE: DenseA/DenseB are arrays whose lengths are
            //       NMain, not N=NMain+NSlack! We store reduced 
            //       matrix and vector because extend parts (last
            //       NSlack rows/columns) are exactly zero.
            //       
            //
            apserv.rvectorsetlengthatleast(ref sstate.b, nmain);
            for(i=0; i<=nmain-1; i++)
            {
                sstate.b[i] = sc[i]*bc[i];
            }
            if( akind==0 )
            {
                
                //
                // Dense QP problem - just copy and scale.
                //
                apserv.rmatrixsetlengthatleast(ref sstate.densea, nmain, nmain);
                cqmodels.cqmgeta(ac, ref sstate.densea);
                sstate.absamax = 0;
                sstate.absasum = 0;
                sstate.absasum2 = 0;
                for(i=0; i<=nmain-1; i++)
                {
                    for(j=0; j<=nmain-1; j++)
                    {
                        v = sc[i]*sstate.densea[i,j]*sc[j];
                        sstate.densea[i,j] = v;
                        sstate.absamax = Math.Max(sstate.absamax, v);
                        sstate.absasum = sstate.absasum+v;
                        sstate.absasum2 = sstate.absasum2+v*v;
                    }
                }
            }
            else
            {
                
                //
                // Sparse QP problem - a bit tricky. Depending on format of the
                // input we use different strategies for copying matrix:
                // * SKS matrices are copied to SKS format
                // * anything else is copied to CRS format
                //
                alglib.ap.assert(akind==1, "QQPOptimize: unexpected AKind (internal error)");
                sparse.sparsecopytosksbuf(sparseac, sstate.sparsea);
                if( sparseupper )
                {
                    sparse.sparsetransposesks(sstate.sparsea);
                }
                sstate.sparseupper = false;
                sstate.absamax = 0;
                sstate.absasum = 0;
                sstate.absasum2 = 0;
                for(i=0; i<=n-1; i++)
                {
                    k = sstate.sparsea.ridx[i];
                    for(j=i-sstate.sparsea.didx[i]; j<=i; j++)
                    {
                        v = sc[i]*sstate.sparsea.vals[k]*sc[j];
                        sstate.sparsea.vals[k] = v;
                        if( i==j )
                        {
                            
                            //
                            // Diagonal terms are counted only once
                            //
                            sstate.absamax = Math.Max(sstate.absamax, v);
                            sstate.absasum = sstate.absasum+v;
                            sstate.absasum2 = sstate.absasum2+v*v;
                        }
                        else
                        {
                            
                            //
                            // Offdiagonal terms are counted twice
                            //
                            sstate.absamax = Math.Max(sstate.absamax, v);
                            sstate.absasum = sstate.absasum+2*v;
                            sstate.absasum2 = sstate.absasum2+2*v*v;
                        }
                        k = k+1;
                    }
                }
            }
            
            //
            // Load box constraints into State structure.
            //
            // We apply transformation to variables: y=(x-x_origin)/s,
            // each of the constraints is appropriately shifted/scaled.
            //
            for(i=0; i<=nmain-1; i++)
            {
                sstate.havebndl[i] = math.isfinite(bndlc[i]);
                if( sstate.havebndl[i] )
                {
                    sstate.bndl[i] = (bndlc[i]-xoriginc[i])/sc[i];
                }
                else
                {
                    alglib.ap.assert(Double.IsNegativeInfinity(bndlc[i]), "QQPOptimize: incorrect lower bound");
                    sstate.bndl[i] = Double.NegativeInfinity;
                }
                sstate.havebndu[i] = math.isfinite(bnduc[i]);
                if( sstate.havebndu[i] )
                {
                    sstate.bndu[i] = (bnduc[i]-xoriginc[i])/sc[i];
                }
                else
                {
                    alglib.ap.assert(Double.IsPositiveInfinity(bnduc[i]), "QQPOptimize: incorrect upper bound");
                    sstate.bndu[i] = Double.PositiveInfinity;
                }
            }
            for(i=nmain; i<=n-1; i++)
            {
                sstate.havebndl[i] = true;
                sstate.bndl[i] = 0.0;
                sstate.havebndu[i] = false;
                sstate.bndu[i] = Double.PositiveInfinity;
            }
            
            //
            // Shift/scale linear constraints with transformation y=(x-x_origin)/s:
            // * constraint "c[i]'*x = b[i]" becomes "(s[i]*c[i])'*x = b[i]-c[i]'*x_origin".
            // * after constraint is loaded into SState.CLEIC, it is additionally normalized
            //
            apserv.rmatrixsetlengthatleast(ref sstate.cleic, nec+nic, n+1);
            for(i=0; i<=nec+nic-1; i++)
            {
                v = 0;
                vv = 0;
                for(j=0; j<=nmain-1; j++)
                {
                    sstate.cleic[i,j] = cleicc[i,j]*sc[j];
                    vv = vv+math.sqr(sstate.cleic[i,j]);
                    v = v+cleicc[i,j]*xoriginc[j];
                }
                vv = Math.Sqrt(vv);
                for(j=nmain; j<=n-1; j++)
                {
                    sstate.cleic[i,j] = 0.0;
                }
                sstate.cleic[i,n] = cleicc[i,nmain]-v;
                if( i>=nec )
                {
                    sstate.cleic[i,nmain+i-nec] = 1.0;
                }
                if( (double)(vv)>(double)(0) )
                {
                    for(j=0; j<=n; j++)
                    {
                        sstate.cleic[i,j] = sstate.cleic[i,j]/vv;
                    }
                }
            }
            
            //
            // Process initial point:
            // * first NMain components are equal to XS-XOriginC
            // * last NIC components are deduced from linear constraints
            // * make sure that boundary constraints are preserved by transformation
            //
            for(i=0; i<=nmain-1; i++)
            {
                sstate.xs[i] = (xs[i]-xoriginc[i])/sc[i];
                if( sstate.havebndl[i] && (double)(sstate.xs[i])<(double)(sstate.bndl[i]) )
                {
                    sstate.xs[i] = sstate.bndl[i];
                }
                if( sstate.havebndu[i] && (double)(sstate.xs[i])>(double)(sstate.bndu[i]) )
                {
                    sstate.xs[i] = sstate.bndu[i];
                }
                if( sstate.havebndl[i] && (double)(xs[i])==(double)(bndlc[i]) )
                {
                    sstate.xs[i] = sstate.bndl[i];
                }
                if( sstate.havebndu[i] && (double)(xs[i])==(double)(bnduc[i]) )
                {
                    sstate.xs[i] = sstate.bndu[i];
                }
            }
            for(i=0; i<=nic-1; i++)
            {
                v = 0.0;
                for(i_=0; i_<=nmain-1;i_++)
                {
                    v += sstate.xs[i_]*sstate.cleic[nec+i,i_];
                }
                sstate.xs[nmain+i] = Math.Max(sstate.cleic[nec+i,n]-v, 0.0);
            }
            
            //
            // Prepare "active set" structure
            //
            sactivesets.sassetbc(sstate.sas, sstate.bndl, sstate.bndu);
            sactivesets.sassetlcx(sstate.sas, sstate.cleic, 0, 0);
            if( !sactivesets.sasstartoptimization(sstate.sas, sstate.xs) )
            {
                terminationtype = -3;
                return;
            }
            
            //
            // Select sparse direct solver
            //
            if( akind==1 )
            {
                sparsesolver = settings.sparsesolver;
                if( sparsesolver==0 )
                {
                    sparsesolver = 1;
                }
                if( sparse.sparseissks(sstate.sparsea) )
                {
                    sparsesolver = 2;
                }
                sparsesolver = 2;
                alglib.ap.assert(sparsesolver==1 || sparsesolver==2, "QQPOptimize: incorrect SparseSolver");
            }
            else
            {
                sparsesolver = 0;
            }
            
            //
            // Main loop.
            //
            // Following variables are used:
            // * GC stores current gradient (unconstrained)
            // * CGC stores current gradient (constrained)
            // * DC stores current search direction
            // * CGP stores constrained gradient at previous point
            //   (zero on initial entry)
            // * DP stores previous search direction
            //   (zero on initial entry)
            //
            cgmax = settings.cgminits;
            sstate.repinneriterationscount = 0;
            sstate.repouteriterationscount = 0;
            while( true )
            {
                if( settings.maxouterits>0 && sstate.repouteriterationscount>=settings.maxouterits )
                {
                    terminationtype = 5;
                    break;
                }
                if( sstate.repouteriterationscount>0 )
                {
                    
                    //
                    // Check EpsF- and EpsX-based stopping criteria.
                    // Because problem was already scaled, we do not scale step before checking its length.
                    // NOTE: these checks are performed only after at least one outer iteration was made.
                    //
                    if( (double)(settings.epsf)>(double)(0) )
                    {
                        
                        //
                        // NOTE 1: here we rely on the fact that ProjectedTargetFunction() ignore D when Stp=0
                        // NOTE 2: code below handles situation when update increases function value instead
                        //         of decreasing it.
                        //
                        fprev = projectedtargetfunction(sstate, sstate.xp, sstate.dc, 0.0, ref sstate.tmp0);
                        fcur = projectedtargetfunction(sstate, sstate.sas.xc, sstate.dc, 0.0, ref sstate.tmp0);
                        if( (double)(fprev-fcur)<=(double)(settings.epsf*Math.Max(Math.Abs(fprev), Math.Max(Math.Abs(fcur), 1.0))) )
                        {
                            terminationtype = 1;
                            break;
                        }
                    }
                    if( (double)(settings.epsx)>(double)(0) )
                    {
                        v = 0.0;
                        for(i=0; i<=n-1; i++)
                        {
                            v = v+math.sqr(sstate.xp[i]-sstate.sas.xc[i]);
                        }
                        if( (double)(Math.Sqrt(v))<=(double)(settings.epsx) )
                        {
                            terminationtype = 2;
                            break;
                        }
                    }
                }
                apserv.inc(ref sstate.repouteriterationscount);
                for(i_=0; i_<=n-1;i_++)
                {
                    sstate.xp[i_] = sstate.sas.xc[i_];
                }
                if( !settings.cgphase )
                {
                    cgmax = 0;
                }
                for(i=0; i<=n-1; i++)
                {
                    sstate.cgp[i] = 0.0;
                    sstate.dp[i] = 0.0;
                }
                for(cgcnt=0; cgcnt<=cgmax-1; cgcnt++)
                {
                    
                    //
                    // Calculate unconstrained gradient GC for "extended" QP problem
                    // Determine active set, current constrained gradient CGC.
                    // Check gradient-based stopping condition.
                    //
                    // NOTE: because problem was scaled, we do not have to apply scaling
                    //       to gradient before checking stopping condition.
                    //
                    targetgradient(sstate, sstate.sas.xc, ref sstate.gc);
                    sactivesets.sasreactivateconstraints(sstate.sas, sstate.gc);
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.cgc[i_] = sstate.gc[i_];
                    }
                    sactivesets.sasconstraineddirection(sstate.sas, ref sstate.cgc);
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += sstate.cgc[i_]*sstate.cgc[i_];
                    }
                    if( (double)(Math.Sqrt(v))<=(double)(settings.epsg) )
                    {
                        terminationtype = 4;
                        break;
                    }
                    
                    //
                    // Prepare search direction DC and explore it.
                    //
                    // We try to use CGP/DP to prepare conjugate gradient step,
                    // but we resort to steepest descent step (Beta=0) in case
                    // we are at I-th boundary, but DP[I]<>0.
                    //
                    // Such approach allows us to ALWAYS have feasible DC, with
                    // guaranteed compatibility with both feasible area and current
                    // active set.
                    //
                    // Automatic CG reset performed every time DP is incompatible
                    // with current active set and/or feasible area. We also
                    // perform reset every QuickQPRestartCG iterations.
                    //
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.dc[i_] = -sstate.cgc[i_];
                    }
                    v = 0.0;
                    vv = 0.0;
                    b = false;
                    for(i=0; i<=n-1; i++)
                    {
                        v = v+sstate.cgc[i]*sstate.cgc[i];
                        vv = vv+sstate.cgp[i]*sstate.cgp[i];
                        b = b || ((sstate.havebndl[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndl[i])) && (double)(sstate.dp[i])!=(double)(0));
                        b = b || ((sstate.havebndu[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndu[i])) && (double)(sstate.dp[i])!=(double)(0));
                    }
                    b = b || (double)(vv)==(double)(0);
                    b = b || cgcnt%quickqprestartcg==0;
                    if( !b )
                    {
                        beta = v/vv;
                    }
                    else
                    {
                        beta = 0.0;
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.dc[i_] = sstate.dc[i_] + beta*sstate.dp[i_];
                    }
                    sactivesets.sasconstraineddirection(sstate.sas, ref sstate.dc);
                    sactivesets.sasexploredirection(sstate.sas, sstate.dc, ref stpmax, ref cidx, ref cval);
                    
                    //
                    // Build quadratic model of F along descent direction:
                    //
                    //     F(xc+alpha*D) = D2*alpha^2 + D1*alpha
                    //
                    // Terminate algorithm if needed.
                    //
                    // NOTE: we do not maintain constant term D0
                    //
                    quadraticmodel(sstate, sstate.sas.xc, sstate.dc, sstate.gc, ref d1, ref d1est, ref d2, ref d2est);
                    if( (double)(d1)==(double)(0) && (double)(d2)==(double)(0) )
                    {
                        
                        //
                        // D1 and D2 are exactly zero, success.
                        // After this if-then we assume that D is non-zero.
                        //
                        terminationtype = 4;
                        break;
                    }
                    if( d1est>=0 )
                    {
                        
                        //
                        // Numerical noise is too large, it means that we are close
                        // to minimum - and that further improvement is impossible.
                        //
                        // After this if-then we assume that D1 is definitely negative
                        // (even under presence of numerical errors).
                        //
                        terminationtype = 7;
                        break;
                    }
                    if( d2est<=0 && cidx<0 )
                    {
                        
                        //
                        // Function is unbounded from below:
                        // * D1<0 (verified by previous block)
                        // * D2Est<=0, which means that either D2<0 - or it can not
                        //   be reliably distinguished from zero.
                        // * step is unconstrained
                        //
                        // If these conditions are true, we abnormally terminate QP
                        // algorithm with return code -4
                        //
                        terminationtype = -4;
                        break;
                    }
                    
                    //
                    // Perform step along DC.
                    //
                    // In this block of code we maintain two step length:
                    // * RestStp -  restricted step, maximum step length along DC which does
                    //              not violate constraints
                    // * FullStp -  step length along DC which minimizes quadratic function
                    //              without taking constraints into account. If problem is
                    //              unbounded from below without constraints, FullStp is
                    //              forced to be RestStp.
                    //
                    // So, if function is convex (D2>0):
                    // * FullStp = -D1/(2*D2)
                    // * RestStp = restricted FullStp
                    // * 0<=RestStp<=FullStp
                    //
                    // If function is non-convex, but bounded from below under constraints:
                    // * RestStp = step length subject to constraints
                    // * FullStp = RestStp
                    //
                    // After RestStp and FullStp are initialized, we generate several trial
                    // steps which are different multiples of RestStp and FullStp.
                    //
                    if( d2est>0 )
                    {
                        alglib.ap.assert((double)(d1)<(double)(0), "QQPOptimize: internal error");
                        fullstp = -(d1/(2*d2));
                        needact = (double)(fullstp)>=(double)(stpmax);
                        if( needact )
                        {
                            alglib.ap.assert(alglib.ap.len(sstate.stpbuf)>=3, "QQPOptimize: StpBuf overflow");
                            reststp = stpmax;
                            stp = reststp;
                            sstate.stpbuf[0] = reststp*4;
                            sstate.stpbuf[1] = fullstp;
                            sstate.stpbuf[2] = fullstp/4;
                            stpcnt = 3;
                        }
                        else
                        {
                            reststp = fullstp;
                            stp = fullstp;
                            stpcnt = 0;
                        }
                    }
                    else
                    {
                        alglib.ap.assert(cidx>=0, "QQPOptimize: internal error");
                        alglib.ap.assert(alglib.ap.len(sstate.stpbuf)>=2, "QQPOptimize: StpBuf overflow");
                        reststp = stpmax;
                        fullstp = stpmax;
                        stp = reststp;
                        needact = true;
                        sstate.stpbuf[0] = 4*reststp;
                        stpcnt = 1;
                    }
                    findbeststepandmove(sstate, sstate.sas, sstate.dc, stp, needact, cidx, cval, sstate.stpbuf, stpcnt, ref sstate.activated, ref sstate.tmp0);
                    
                    //
                    // Update CG information.
                    //
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.dp[i_] = sstate.dc[i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.cgp[i_] = sstate.cgc[i_];
                    }
                    
                    //
                    // Update iterations counter
                    //
                    sstate.repinneriterationscount = sstate.repinneriterationscount+1;
                }
                if( terminationtype!=0 )
                {
                    break;
                }
                cgmax = settings.cgmaxits;
                
                //
                // Generate YIdx - reordering of variables for constrained Newton phase.
                // Free variables come first, fixed are last ones.
                //
                newtcnt = 0;
                while( true )
                {
                    
                    //
                    // Skip iteration if constrained Newton is turned off.
                    //
                    if( !settings.cnphase )
                    {
                        break;
                    }
                    
                    //
                    // At the first iteration   - build Cholesky decomposition of Hessian.
                    // At subsequent iterations - refine Hessian by adding new constraints.
                    //
                    // Loop is terminated in following cases:
                    // * Hessian is not positive definite subject to current constraints
                    //   (termination during initial decomposition)
                    // * there were no new constraints being activated
                    //   (termination during update)
                    // * all constraints were activated during last step
                    //   (termination during update)
                    // * CNMaxUpdates were performed on matrix
                    //   (termination during update)
                    //
                    if( newtcnt==0 )
                    {
                        
                        //
                        // Perform initial Newton step. If Cholesky decomposition fails,
                        // increase number of CG iterations to CGMaxIts - it should help
                        // us to find set of constraints which will make matrix positive
                        // definite.
                        //
                        b = cnewtonbuild(sstate, sparsesolver, ref sstate.repncholesky);
                        if( b )
                        {
                            cgmax = settings.cgminits;
                        }
                    }
                    else
                    {
                        b = cnewtonupdate(sstate, settings, ref sstate.repncupdates);
                    }
                    if( !b )
                    {
                        break;
                    }
                    apserv.inc(ref newtcnt);
                    
                    //
                    // Calculate gradient GC.
                    //
                    targetgradient(sstate, sstate.sas.xc, ref sstate.gc);
                    
                    //
                    // Bound-constrained Newton step
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        sstate.dc[i] = sstate.gc[i];
                    }
                    if( !cnewtonstep(sstate, settings, sstate.dc) )
                    {
                        break;
                    }
                    quadraticmodel(sstate, sstate.sas.xc, sstate.dc, sstate.gc, ref d1, ref d1est, ref d2, ref d2est);
                    if( d1est>=0 || d2est<=0 )
                    {
                        break;
                    }
                    alglib.ap.assert((double)(d1)<(double)(0), "QQPOptimize: internal error");
                    fullstp = -(d1/(2*d2));
                    sactivesets.sasexploredirection(sstate.sas, sstate.dc, ref stpmax, ref cidx, ref cval);
                    needact = (double)(fullstp)>=(double)(stpmax);
                    if( needact )
                    {
                        alglib.ap.assert(alglib.ap.len(sstate.stpbuf)>=3, "QQPOptimize: StpBuf overflow");
                        reststp = stpmax;
                        stp = reststp;
                        sstate.stpbuf[0] = reststp*4;
                        sstate.stpbuf[1] = fullstp;
                        sstate.stpbuf[2] = fullstp/4;
                        stpcnt = 3;
                    }
                    else
                    {
                        reststp = fullstp;
                        stp = fullstp;
                        stpcnt = 0;
                    }
                    findbeststepandmove(sstate, sstate.sas, sstate.dc, stp, needact, cidx, cval, sstate.stpbuf, stpcnt, ref sstate.activated, ref sstate.tmp0);
                }
                if( terminationtype!=0 )
                {
                    break;
                }
            }
            
            //
            // Stop optimization and unpack results.
            //
            // Add XOriginC to XS and make sure that boundary constraints are
            // both (a) satisfied, (b) preserved. Former means that "shifted"
            // point is feasible, while latter means that point which was exactly
            // at the boundary before shift will be exactly at the boundary
            // after shift.
            //
            sactivesets.sasstopoptimization(sstate.sas);
            for(i=0; i<=nmain-1; i++)
            {
                xs[i] = sc[i]*sstate.sas.xc[i]+xoriginc[i];
                if( sstate.havebndl[i] && (double)(xs[i])<(double)(bndlc[i]) )
                {
                    xs[i] = bndlc[i];
                }
                if( sstate.havebndu[i] && (double)(xs[i])>(double)(bnduc[i]) )
                {
                    xs[i] = bnduc[i];
                }
                if( sstate.havebndl[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndl[i]) )
                {
                    xs[i] = bndlc[i];
                }
                if( sstate.havebndu[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndu[i]) )
                {
                    xs[i] = bnduc[i];
                }
            }
        }


        /*************************************************************************
        Target function at point PROJ(X+Stp*D), where PROJ(.) is a projection into
        feasible set.

        NOTE: if Stp=0, D is not referenced at all. Thus,  there  is  no  need  to
              fill it by some meaningful values for Stp=0.

        This subroutine uses temporary buffer Tmp, which is automatically  resized
        if needed.

          -- ALGLIB --
             Copyright 21.12.2013 by Bochkanov Sergey
        *************************************************************************/
        private static double projectedtargetfunction(qqpbuffers sstate,
            double[] x,
            double[] d,
            double stp,
            ref double[] tmp0)
        {
            double result = 0;
            int nec = 0;
            int nic = 0;
            int n = 0;
            int nmain = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            double vv = 0;
            int i_ = 0;

            n = sstate.n;
            nmain = sstate.nmain;
            nec = sstate.nec;
            nic = sstate.nic;
            apserv.rvectorsetlengthatleast(ref tmp0, n);
            
            //
            // Calculate projected point
            //
            for(i=0; i<=n-1; i++)
            {
                if( (double)(stp)!=(double)(0) )
                {
                    v = x[i]+stp*d[i];
                }
                else
                {
                    v = x[i];
                }
                if( sstate.havebndl[i] && (double)(v)<(double)(sstate.bndl[i]) )
                {
                    v = sstate.bndl[i];
                }
                if( sstate.havebndu[i] && (double)(v)>(double)(sstate.bndu[i]) )
                {
                    v = sstate.bndu[i];
                }
                tmp0[i] = v;
            }
            
            //
            // Function value at the Tmp0:
            //
            // f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            //
            result = 0.0;
            for(i=0; i<=nmain-1; i++)
            {
                result = result+sstate.b[i]*tmp0[i];
            }
            if( sstate.akind==0 )
            {
                
                //
                // Dense matrix A
                //
                for(i=0; i<=nmain-1; i++)
                {
                    v = tmp0[i];
                    result = result+0.5*v*v*sstate.densea[i,i];
                    vv = 0.0;
                    for(j=i+1; j<=nmain-1; j++)
                    {
                        vv = vv+sstate.densea[i,j]*tmp0[j];
                    }
                    result = result+v*vv;
                }
            }
            else
            {
                
                //
                // sparse matrix A
                //
                alglib.ap.assert(sstate.akind==1, "QQPOptimize: unexpected AKind in ProjectedTargetFunction");
                result = result+0.5*sparse.sparsevsmv(sstate.sparsea, sstate.sparseupper, tmp0);
            }
            for(i=0; i<=nec+nic-1; i++)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += sstate.cleic[i,i_]*tmp0[i_];
                }
                result = result+0.5*penaltyfactor*math.sqr(v-sstate.cleic[i,n]);
            }
            return result;
        }


        /*************************************************************************
        Gradient of "extended" (N>=NMain variables, original + slack ones)  target
        function:

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        which is equal to

            grad = A*x + b + penaltyfactor*C'*(C*x-b)

        Here:
        * x is array[N] (that's why problem is called extended - N>=NMain)
        * A is array[NMain,NMain]
        * b is array[NMain]
        * C is array[NEC+NIC,N]

        INPUT PARAMETERS:
            SState  -   structure which stores function terms (not modified)
            X       -   location
            G       -   possibly preallocated buffer

        OUTPUT PARAMETERS:
            G       -   array[N], gradient
                    
          -- ALGLIB --
             Copyright 21.12.2013 by Bochkanov Sergey
        *************************************************************************/
        private static void targetgradient(qqpbuffers sstate,
            double[] x,
            ref double[] g)
        {
            int nec = 0;
            int nic = 0;
            int n = 0;
            int nmain = 0;
            int i = 0;
            double v = 0;
            int i_ = 0;

            n = sstate.n;
            nmain = sstate.nmain;
            nec = sstate.nec;
            nic = sstate.nic;
            apserv.rvectorsetlengthatleast(ref g, n);
            if( sstate.akind==0 )
            {
                
                //
                // Dense matrix A
                //
                ablas.rmatrixmv(nmain, nmain, sstate.densea, 0, 0, 0, x, 0, ref g, 0);
            }
            else
            {
                
                //
                // Sparse matrix A
                //
                alglib.ap.assert(sstate.akind==1, "QQPOptimize: unexpected AKind in TargetGradient");
                sparse.sparsesmv(sstate.sparsea, sstate.sparseupper, x, ref g);
            }
            for(i_=0; i_<=nmain-1;i_++)
            {
                g[i_] = g[i_] + sstate.b[i_];
            }
            for(i=nmain; i<=n-1; i++)
            {
                g[i] = 0.0;
            }
            for(i=0; i<=nec+nic-1; i++)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += sstate.cleic[i,i_]*x[i_];
                }
                v = v-sstate.cleic[i,n];
                v = v*penaltyfactor;
                for(i_=0; i_<=n-1;i_++)
                {
                    g[i_] = g[i_] + v*sstate.cleic[i,i_];
                }
            }
        }


        /*************************************************************************
        First and second derivatives  of  the  "extended"  target  function  along
        specified direction. Target  function  is  called  "extended"  because  of
        additional slack variables and has form:

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        with gradient

            grad = A*x + b + penaltyfactor*C'*(C*x-b)
            
        Quadratic model has form

            F(x0+alpha*D) = D2*alpha^2 + D1*alpha

        INPUT PARAMETERS:
            SState  -   structure which is used to obtain quadratic term of the model
            X       -   current point, array[N]
            D       -   direction across which derivatives are calculated, array[N]
            G       -   gradient at current point (pre-calculated by caller), array[N]

        OUTPUT PARAMETERS:
            D1      -   linear coefficient
            D1Est   -   estimate of D1 sign,  accounting  for  possible  numerical
                        errors:
                        * >0    means "almost surely positive"
                        * <0    means "almost surely negative"
                        * =0    means "pessimistic estimate  of  numerical  errors
                                in D1 is larger than magnitude of D1 itself; it is
                                impossible to reliably distinguish D1 from zero".
            D2      -   quadratic coefficient
            D2Est   -   estimate of D2 sign,  accounting  for  possible  numerical
                        errors:
                        * >0    means "almost surely positive"
                        * <0    means "almost surely negative"
                        * =0    means "pessimistic estimate  of  numerical  errors
                                in D2 is larger than magnitude of D2 itself; it is
                                impossible to reliably distinguish D2 from zero".
                    
          -- ALGLIB --
             Copyright 14.05.2014 by Bochkanov Sergey
        *************************************************************************/
        private static void quadraticmodel(qqpbuffers sstate,
            double[] x,
            double[] d,
            double[] g,
            ref double d1,
            ref int d1est,
            ref double d2,
            ref int d2est)
        {
            int nec = 0;
            int nic = 0;
            int n = 0;
            int nmain = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            double vv = 0;
            double mx = 0;
            double mb = 0;
            double md = 0;
            int i_ = 0;

            d1 = 0;
            d1est = 0;
            d2 = 0;
            d2est = 0;

            n = sstate.n;
            nmain = sstate.nmain;
            nec = sstate.nec;
            nic = sstate.nic;
            
            //
            // Maximums
            //
            mx = 0.0;
            md = 0.0;
            mb = 0.0;
            for(i=0; i<=n-1; i++)
            {
                mx = Math.Max(mx, Math.Abs(x[i]));
                md = Math.Max(md, Math.Abs(d[i]));
            }
            for(i=0; i<=nmain-1; i++)
            {
                mb = Math.Max(mb, Math.Abs(sstate.b[i]));
            }
            
            //
            // D2
            //
            if( sstate.akind==0 )
            {
                
                //
                // Dense matrix A
                //
                d2 = 0.0;
                for(i=0; i<=nmain-1; i++)
                {
                    v = d[i];
                    vv = 0.0;
                    d2 = d2+0.5*v*v*sstate.densea[i,i];
                    for(j=i+1; j<=nmain-1; j++)
                    {
                        vv = vv+sstate.densea[i,j]*d[j];
                    }
                    d2 = d2+v*vv;
                }
            }
            else
            {
                
                //
                // Sparse matrix A
                //
                alglib.ap.assert(sstate.akind==1, "QQPOptimize: unexpected AKind in TargetGradient");
                d2 = 0.5*sparse.sparsevsmv(sstate.sparsea, sstate.sparseupper, d);
            }
            for(i=0; i<=nec+nic-1; i++)
            {
                
                //
                // NOTE: there is no "V:=V-CLEIC[I,N]" line, and it is not an error!
                //       We estimate curvature information here, which is not dependent
                //       on right part.
                //
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += sstate.cleic[i,i_]*d[i_];
                }
                d2 = d2+v*v*penaltyfactor*0.5;
            }
            v = 0.0;
            for(i_=0; i_<=n-1;i_++)
            {
                v += d[i_]*g[i_];
            }
            d1 = v;
            
            //
            // Error estimates
            //
            optserv.estimateparabolicmodel(sstate.absasum, sstate.absasum2, mx, mb, md, d1, d2, ref d1est, ref d2est);
        }


        /*************************************************************************
        This function accepts quadratic model of the form

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        and list of possible steps along direction D. It chooses  best  step  (one
        which achieves minimum value of the target  function)  and  moves  current
        point (given by SAS object) to the new location. Step is  bounded  subject
        to boundary constraints.

        Candidate steps are divided into two groups:
        * "default" step, which is always performed when no candidate steps LONGER
          THAN THE DEFAULT  ONE  is  given.  This  candidate  MUST  reduce  target
          function value; it is  responsibility  of  caller  to   provide  default
          candidate which reduces target function.
        * "additional candidates", which may be shorter or longer than the default
          step. Candidates which are shorter that the default  step  are  ignored;
          candidates which are longer than the "default" step are tested.
          
        The idea is that we ALWAYS try "default" step, and it is responsibility of
        the caller to provide us with something which is worth trying.  This  step
        may activate some constraint - that's why we  stopped  at  "default"  step
        size. However, we may also try longer steps which may activate  additional
        constraints and further reduce function value.

        INPUT PARAMETERS:
            SState  -   structure which stores model
            SAS     -   active set structure which stores current point in SAS.XC
            D       -   direction for step
            Stp     -   step length for "default" candidate
            NeedAct -   whether   default  candidate  activates  some  constraint;
                        if NeedAct  is True,  constraint  given  by  CIdc/CVal  is
                        GUARANTEED to be activated in the final point.
            CIdx    -   if NeedAct is True, stores index of the constraint to activate
            CVal    -   if NeedAct is True, stores constrained value;
                        SAS.XC[CIdx] is forced to be equal to CVal.
            AddSteps-   array[AddStepsCnt] of additional steps:
                        * AddSteps[]<=Stp are ignored
                        * AddSteps[]>Stp are tried
            Activated-  possibly preallocated buffer; previously allocated memory
                        will be reused.
            Tmp0    -  possibly preallocated buffer; previously allocated memory
                        will be reused.
            
        OUTPUT PARAMETERS:
            SAS     -   SAS.XC is set to new point;  if  there  was  a  constraint
                        specified  by  NeedAct/CIdx/CVal,  it  will  be  activated
                        (other constraints may be activated too, but this  one  is
                        guaranteed to be active in the final point).
            Activated-  elements of this array are set to True, if I-th constraint
                        as inactive at previous point, but become  active  in  the
                        new one.
                        Situations when we deactivate xi>=0 and activate xi<=1 are
                        considered as activation of previously inactive constraint
                    
          -- ALGLIB --
             Copyright 14.05.2014 by Bochkanov Sergey
        *************************************************************************/
        private static void findbeststepandmove(qqpbuffers sstate,
            sactivesets.sactiveset sas,
            double[] d,
            double stp,
            bool needact,
            int cidx,
            double cval,
            double[] addsteps,
            int addstepscnt,
            ref bool[] activated,
            ref double[] tmp0)
        {
            int n = 0;
            int i = 0;
            int k = 0;
            double v = 0;
            double stpbest = 0;
            double fbest = 0;
            double fcand = 0;

            n = sstate.n;
            apserv.rvectorsetlengthatleast(ref tmp0, n);
            apserv.bvectorsetlengthatleast(ref activated, n);
            
            //
            // Calculate initial step, store to Tmp0
            //
            // NOTE: Tmp0 is guaranteed to be feasible w.r.t. boundary constraints
            //
            for(i=0; i<=n-1; i++)
            {
                v = sas.xc[i]+stp*d[i];
                if( sstate.havebndl[i] && (double)(v)<(double)(sstate.bndl[i]) )
                {
                    v = sstate.bndl[i];
                }
                if( sstate.havebndu[i] && (double)(v)>(double)(sstate.bndu[i]) )
                {
                    v = sstate.bndu[i];
                }
                tmp0[i] = v;
            }
            if( needact )
            {
                tmp0[cidx] = cval;
            }
            
            //
            // Try additional steps, if AddStepsCnt>0
            //
            if( addstepscnt>0 )
            {
                
                //
                // Find best step
                //
                stpbest = stp;
                fbest = projectedtargetfunction(sstate, sas.xc, d, stpbest, ref tmp0);
                for(k=0; k<=addstepscnt-1; k++)
                {
                    if( (double)(addsteps[k])>(double)(stp) )
                    {
                        fcand = projectedtargetfunction(sstate, sas.xc, d, addsteps[k], ref tmp0);
                        if( (double)(fcand)<(double)(fbest) )
                        {
                            fbest = fcand;
                            stpbest = addsteps[k];
                        }
                    }
                }
                
                //
                // Prepare best step
                //
                // NOTE: because only AddSteps[]>Stp were checked,
                //       this step will activate constraint CIdx.
                //
                for(i=0; i<=n-1; i++)
                {
                    v = sas.xc[i]+stpbest*d[i];
                    if( sstate.havebndl[i] && (double)(v)<(double)(sstate.bndl[i]) )
                    {
                        v = sstate.bndl[i];
                    }
                    if( sstate.havebndu[i] && (double)(v)>(double)(sstate.bndu[i]) )
                    {
                        v = sstate.bndu[i];
                    }
                    tmp0[i] = v;
                }
                if( needact )
                {
                    tmp0[cidx] = cval;
                }
            }
            
            //
            // Fill Activated array by information about activated constraints.
            // Perform step
            //
            for(i=0; i<=n-1; i++)
            {
                activated[i] = false;
                v = tmp0[i];
                if( (double)(v)==(double)(sas.xc[i]) )
                {
                    continue;
                }
                if( sstate.havebndl[i] && (double)(v)==(double)(sstate.bndl[i]) )
                {
                    activated[i] = true;
                }
                if( sstate.havebndu[i] && (double)(v)==(double)(sstate.bndu[i]) )
                {
                    activated[i] = true;
                }
            }
            sactivesets.sasmoveto(sas, tmp0, needact, cidx, cval);
        }


        /*************************************************************************
        This function prepares data for  constrained  Newton  step  for  penalized
        quadratic model of the form

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        where A can be dense or sparse, and model is considered subject to equality
        constraints specified by SState.SAS.XC  object.  Constraint  is considered
        active if XC[i] is exactly BndL[i] or BndU[i],  i.e.  we  ignore  internal
        list of constraints monitored by SAS object. Our own  set  of  constraints
        includes all  constraints  stored  by  SAS,  but  also  may  include  some
        constraints which are inactive in SAS.

        "Preparation" means that Cholesky decomposition of  the  effective  system
        matrix is performed, and we can  perform  constrained  Newton  step.

        This function works as black box. It uses fields of SState which are marked
        as "Variables for constrained Newton phase", and only  this  function  and
        its friends know about these variables. Everyone else should use:
        * CNewtonBuild() to prepare initial Cholesky decomposition for step
        * CNewtonStep() to perform constrained Newton step
        * CNewtonUpdate() to update Cholesky matrix  after  point  was  moved  and
          constraints were updated. In some cases it  is  possible to  efficiently
          re-calculate Cholesky decomposition if you know which  constraints  were
          activated. If efficient  re-calculation  is  impossible,  this  function
          returns False.

        INPUT PARAMETERS:
            SState  -   structure which stores model and temporaries for CN phase;
                        in particular, SAS.XC stores current point.
            SparseSolver-which sparse solver to use for sparse model; ignored  for
                        dense QP. Can be:
                        * 2 -   SKS-based Cholesky
            NCholesky-  counter which is incremented after Cholesky (successful or
                        failed one)
            
        OUTPUT PARAMETERS:
            NCholesky-  possibly updated counter
            
        RESULT:
            True, if Cholesky decomposition was successfully performed.
            False, if a) matrix was semi-definite or indefinite, or b)  particular
            combination of matrix type (sparse) and constraints  (general  linear)
            is not supported.
            
        NOTE: this function may routinely return False, for indefinite matrices or
              for sparse problems with general linear constraints. You  should  be
              able to handle such situations.
                    
          -- ALGLIB --
             Copyright 14.05.2014 by Bochkanov Sergey
        *************************************************************************/
        private static bool cnewtonbuild(qqpbuffers sstate,
            int sparsesolver,
            ref int ncholesky)
        {
            bool result = new bool();
            int nec = 0;
            int nic = 0;
            int n = 0;
            int nmain = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            bool b = new bool();
            int ridx0 = 0;
            int ridx1 = 0;
            int nfree = 0;
            int i_ = 0;

            result = false;
            
            //
            // Fetch often used fields
            //
            n = sstate.n;
            nmain = sstate.nmain;
            nec = sstate.nec;
            nic = sstate.nic;
            
            //
            // Check problem properties.
            // Sparse problems with general linear constraints are not supported yet.
            //
            if( sstate.akind==1 && nec+nic>0 )
            {
                return result;
            }
            
            //
            // 1. Set CNModelAge to zero
            // 2. Generate YIdx - reordering of variables such that free variables
            //    come first and are ordered by ascending, fixed are last ones and
            //    have no particular ordering.
            //
            // This step is same for dense and sparse problems.
            //
            sstate.cnmodelage = 0;
            apserv.ivectorsetlengthatleast(ref sstate.yidx, n);
            ridx0 = 0;
            ridx1 = n-1;
            for(i=0; i<=n-1; i++)
            {
                sstate.yidx[i] = -1;
            }
            for(i=0; i<=n-1; i++)
            {
                alglib.ap.assert(!sstate.havebndl[i] || (double)(sstate.sas.xc[i])>=(double)(sstate.bndl[i]), "CNewtonBuild: internal error");
                alglib.ap.assert(!sstate.havebndu[i] || (double)(sstate.sas.xc[i])<=(double)(sstate.bndu[i]), "CNewtonBuild: internal error");
                b = false;
                b = b || (sstate.havebndl[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndl[i]));
                b = b || (sstate.havebndu[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndu[i]));
                if( b )
                {
                    sstate.yidx[ridx1] = i;
                    ridx1 = ridx1-1;
                }
                else
                {
                    sstate.yidx[ridx0] = i;
                    ridx0 = ridx0+1;
                }
            }
            alglib.ap.assert(ridx0==ridx1+1, "CNewtonBuild: internal error");
            nfree = ridx0;
            sstate.nfree = nfree;
            if( nfree==0 )
            {
                return result;
            }
            
            //
            // Constrained Newton matrix: dense version
            //
            if( sstate.akind==0 )
            {
                apserv.rmatrixsetlengthatleast(ref sstate.densez, n, n);
                apserv.rvectorsetlengthatleast(ref sstate.tmpcn, n);
                if( nec+nic>0 )
                {
                    
                    //
                    // Initialize Z with C'*C, add A
                    //
                    ablas.rmatrixsyrk(n, nec+nic, penaltyfactor, sstate.cleic, 0, 0, 2, 0.0, sstate.densez, 0, 0, true);
                    for(i=0; i<=nmain-1; i++)
                    {
                        for(j=i; j<=nmain-1; j++)
                        {
                            sstate.densez[i,j] = sstate.densez[i,j]+sstate.densea[i,j];
                        }
                    }
                }
                else
                {
                    
                    //
                    // No linear constraints, just set Z to A
                    //
                    alglib.ap.assert(n==nmain, "CNewtonBuild: integrity check failed");
                    for(i=0; i<=nmain-1; i++)
                    {
                        for(j=i; j<=nmain-1; j++)
                        {
                            sstate.densez[i,j] = sstate.densea[i,j];
                        }
                    }
                }
                for(i=1; i<=nfree-1; i++)
                {
                    alglib.ap.assert(sstate.yidx[i]>sstate.yidx[i-1], "CNewtonBuild: integrity check failed");
                }
                for(i=0; i<=nfree-1; i++)
                {
                    k = sstate.yidx[i];
                    for(j=i; j<=nfree-1; j++)
                    {
                        sstate.densez[i,j] = sstate.densez[k,sstate.yidx[j]];
                    }
                }
                apserv.rvectorsetlengthatleast(ref sstate.regdiag, n);
                for(i=0; i<=nfree-1; i++)
                {
                    v = 0.0;
                    for(j=0; j<=i-1; j++)
                    {
                        v = v+Math.Abs(sstate.densez[j,i]);
                    }
                    for(j=i; j<=nfree-1; j++)
                    {
                        v = v+Math.Abs(sstate.densez[i,j]);
                    }
                    if( (double)(v)==(double)(0) )
                    {
                        v = 1.0;
                    }
                    sstate.regdiag[i] = regz*v;
                }
                for(i=0; i<=nfree-1; i++)
                {
                    sstate.densez[i,i] = sstate.densez[i,i]+sstate.regdiag[i];
                }
                apserv.inc(ref ncholesky);
                if( !trfac.spdmatrixcholeskyrec(ref sstate.densez, 0, nfree, true, ref sstate.tmpcn) )
                {
                    return result;
                }
                for(i=nfree-1; i>=0; i--)
                {
                    for(i_=i; i_<=nfree-1;i_++)
                    {
                        sstate.tmpcn[i_] = sstate.densez[i,i_];
                    }
                    k = sstate.yidx[i];
                    for(j=k; j<=n-1; j++)
                    {
                        sstate.densez[k,j] = 0;
                    }
                    for(j=i; j<=nfree-1; j++)
                    {
                        sstate.densez[k,sstate.yidx[j]] = sstate.tmpcn[j];
                    }
                }
                for(i=nfree; i<=n-1; i++)
                {
                    k = sstate.yidx[i];
                    sstate.densez[k,k] = 1.0;
                    for(j=k+1; j<=n-1; j++)
                    {
                        sstate.densez[k,j] = 0;
                    }
                }
                result = true;
                return result;
            }
            
            //
            // Constrained Newton matrix: sparse version
            //
            if( sstate.akind==1 )
            {
                alglib.ap.assert(nec+nic==0, "CNewtonBuild: internal error");
                alglib.ap.assert(sparsesolver==2, "CNewtonBuild: internal error");
                
                //
                // Copy sparse A to Z and fill rows/columns corresponding to active
                // constraints by zeros. Diagonal elements corresponding to active
                // constraints are filled by unit values.
                //
                sparse.sparsecopytosksbuf(sstate.sparsea, sstate.sparsecca);
                apserv.rvectorsetlengthatleast(ref sstate.tmpcn, n);
                for(i=0; i<=n-1; i++)
                {
                    sstate.tmpcn[i] = 0;
                }
                for(i=nfree; i<=n-1; i++)
                {
                    sstate.tmpcn[sstate.yidx[i]] = 1;
                }
                for(i=0; i<=n-1; i++)
                {
                    k = sstate.sparsecca.ridx[i];
                    for(j=i-sstate.sparsecca.didx[i]; j<=i; j++)
                    {
                        if( (double)(sstate.tmpcn[i])!=(double)(0) || (double)(sstate.tmpcn[j])!=(double)(0) )
                        {
                            
                            //
                            // I-th or J-th variable is in active set (constrained)
                            //
                            if( i==j )
                            {
                                sstate.sparsecca.vals[k] = 1.0;
                            }
                            else
                            {
                                sstate.sparsecca.vals[k] = 0.0;
                            }
                        }
                        k = k+1;
                    }
                }
                
                //
                // Perform sparse Cholesky
                //
                apserv.inc(ref ncholesky);
                if( !trfac.sparsecholeskyskyline(sstate.sparsecca, nmain, sstate.sparseupper) )
                {
                    return result;
                }
                result = true;
                return result;
            }
            
            //
            // Unexpected :)
            //
            alglib.ap.assert(false, "CNewtonBuild: internal error");
            return result;
        }


        /*************************************************************************
        This   function  updates  equality-constrained   Cholesky   matrix   after
        activation of the  new  equality  constraints.  Matrix  being  updated  is
        quadratic term of the function below

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        where A can be dense or sparse.

        This  function  uses  YIdx[]  array  (set by CNewtonBuild()  function)  to
        distinguish between active and inactive constraints.

        This function works as black box. It uses fields of SState which are marked
        as "Variables for constrained Newton phase", and only  this  function  and
        its friends know about these variables. Everyone else should use:
        * CNewtonBuild() to prepare initial Cholesky decomposition for step
        * CNewtonStep() to perform constrained Newton step
        * CNewtonUpdate() to update Cholesky matrix  after  point  was  moved  and
          constraints were updated. In some cases it  is  possible to  efficiently
          re-calculate Cholesky decomposition if you know which  constraints  were
          activated. If efficient  re-calculation  is  impossible,  this  function
          returns False.

        INPUT PARAMETERS:
            SState  -   structure which stores model and temporaries for CN phase;
                        in particular, SAS.XC stores current point.
            Settings -  QQPSettings object which was  initialized  by  appropriate
                        construction function.
            NCUpdates-  counter which is incremented after each update (one update
                        means one variable being fixed)
            
        OUTPUT PARAMETERS:
            NCUpdates-  possibly updated counter
            
        RESULT:
            True, if Cholesky decomposition was successfully performed.
            False, if a) model age was too high, or b) particular  combination  of
            matrix type (sparse) and constraints (general linear) is not supported
            
        NOTE: this function may routinely return False.
              You should be able to handle such situations.
                    
          -- ALGLIB --
             Copyright 14.05.2014 by Bochkanov Sergey
        *************************************************************************/
        private static bool cnewtonupdate(qqpbuffers sstate,
            qqpsettings settings,
            ref int ncupdates)
        {
            bool result = new bool();
            int n = 0;
            int nfree = 0;
            int ntofix = 0;
            bool b = new bool();
            int ridx0 = 0;
            int ridx1 = 0;
            int i = 0;
            int k = 0;

            result = false;
            
            //
            // Cholesky updates for sparse problems are not supported
            //
            if( sstate.akind==1 )
            {
                return result;
            }
            
            //
            // Fetch often used fields
            //
            n = sstate.n;
            nfree = sstate.nfree;
            
            //
            // Determine variables to fix and move them to YIdx[NFree-NToFix:NFree-1]
            // Exit if CNModelAge increased too much.
            //
            apserv.ivectorsetlengthatleast(ref sstate.tmpcni, n);
            ridx0 = 0;
            ridx1 = nfree-1;
            for(i=0; i<=nfree-1; i++)
            {
                sstate.tmpcni[i] = -1;
            }
            for(k=0; k<=nfree-1; k++)
            {
                i = sstate.yidx[k];
                alglib.ap.assert(!sstate.havebndl[i] || (double)(sstate.sas.xc[i])>=(double)(sstate.bndl[i]), "CNewtonUpdate: internal error");
                alglib.ap.assert(!sstate.havebndu[i] || (double)(sstate.sas.xc[i])<=(double)(sstate.bndu[i]), "CNewtonUpdate: internal error");
                b = false;
                b = b || (sstate.havebndl[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndl[i]));
                b = b || (sstate.havebndu[i] && (double)(sstate.sas.xc[i])==(double)(sstate.bndu[i]));
                if( b )
                {
                    sstate.tmpcni[ridx1] = i;
                    ridx1 = ridx1-1;
                }
                else
                {
                    sstate.tmpcni[ridx0] = i;
                    ridx0 = ridx0+1;
                }
            }
            alglib.ap.assert(ridx0==ridx1+1, "CNewtonUpdate: internal error");
            ntofix = nfree-ridx0;
            if( ntofix==0 || ntofix==nfree )
            {
                return result;
            }
            if( sstate.cnmodelage+ntofix>settings.cnmaxupdates )
            {
                return result;
            }
            for(i=0; i<=nfree-1; i++)
            {
                sstate.yidx[i] = sstate.tmpcni[i];
            }
            
            //
            // Constrained Newton matrix: dense version.
            //
            if( sstate.akind==0 )
            {
                
                //
                // Update Cholesky matrix with SPDMatrixCholeskyUpdateFixBuf()
                //
                apserv.bvectorsetlengthatleast(ref sstate.tmpcnb, n);
                for(i=0; i<=n-1; i++)
                {
                    sstate.tmpcnb[i] = false;
                }
                for(i=nfree-ntofix; i<=nfree-1; i++)
                {
                    sstate.tmpcnb[sstate.yidx[i]] = true;
                }
                trfac.spdmatrixcholeskyupdatefixbuf(sstate.densez, n, true, sstate.tmpcnb, ref sstate.tmpcn);
                
                //
                // Update information stored in State and exit
                //
                sstate.nfree = nfree-ntofix;
                sstate.cnmodelage = sstate.cnmodelage+ntofix;
                ncupdates = ncupdates+ntofix;
                result = true;
                return result;
            }
            
            //
            // Unexpected :)
            //
            alglib.ap.assert(false, "CNewtonUpdate: internal error");
            return result;
        }


        /*************************************************************************
        This   function prepares equality-constrained Newton step using previously
        calculated constrained Cholesky matrix of the problem

            f(x) = 0.5*x'*A*x + b'*x + penaltyfactor*0.5*(C*x-b)'*(C*x-b)
            
        where A can be dense or sparse.

        As  input,  this  function  accepts  gradient  at the current location. As
        output, it returns step vector (replaces gradient).

        This function works as black box. It uses fields of SState which are marked
        as "Variables for constrained Newton phase", and only  this  function  and
        its friends know about these variables. Everyone else should use:
        * CNewtonBuild() to prepare initial Cholesky decomposition for step
        * CNewtonStep() to perform constrained Newton step
        * CNewtonUpdate() to update Cholesky matrix  after  point  was  moved  and
          constraints were updated. In some cases it  is  possible to  efficiently
          re-calculate Cholesky decomposition if you know which  constraints  were
          activated. If efficient  re-calculation  is  impossible,  this  function
          returns False.

        INPUT PARAMETERS:
            SState  -   structure which stores model and temporaries for CN phase;
                        in particular, SAS.XC stores current point.
            Settings -  QQPSettings object which was  initialized  by  appropriate
                        construction function.
            GC       -  array[NMain+NSlack], gradient of the target function
            
        OUTPUT PARAMETERS:
            GC       -  array[NMain+NSlack], step vector (on success)
            
        RESULT:
            True, if step was successfully calculated.
            False, if step calculation failed:
            a) gradient was exactly zero,
            b) gradient norm was smaller than EpsG (stopping condition)
            c) all variables were equality-constrained
            
        NOTE: this function may routinely return False.
              You should be able to handle such situations.
                    
          -- ALGLIB --
             Copyright 14.05.2014 by Bochkanov Sergey
        *************************************************************************/
        private static bool cnewtonstep(qqpbuffers sstate,
            qqpsettings settings,
            double[] gc)
        {
            bool result = new bool();
            int i = 0;
            int n = 0;
            int nfree = 0;
            double v = 0;
            int i_ = 0;

            result = false;
            n = sstate.n;
            nfree = sstate.nfree;
            for(i=nfree; i<=n-1; i++)
            {
                gc[sstate.yidx[i]] = 0.0;
            }
            v = 0.0;
            for(i_=0; i_<=n-1;i_++)
            {
                v += gc[i_]*gc[i_];
            }
            if( (double)(Math.Sqrt(v))<=(double)(settings.epsg) )
            {
                return result;
            }
            for(i=0; i<=n-1; i++)
            {
                gc[i] = -gc[i];
            }
            if( sstate.akind==0 )
            {
                
                //
                // Dense Newton step.
                // Use straightforward Cholesky solver.
                //
                fbls.fblscholeskysolve(sstate.densez, 1.0, n, true, gc, ref sstate.tmpcn);
                result = true;
                return result;
            }
            if( sstate.akind==1 )
            {
                
                //
                // Sparse Newton step.
                //
                // We have T*T' = L*L' = U'*U (depending on specific triangle stored in SparseCCA).
                //
                if( sstate.sparseupper )
                {
                    sparse.sparsetrsv(sstate.sparsecca, sstate.sparseupper, false, 1, gc);
                    sparse.sparsetrsv(sstate.sparsecca, sstate.sparseupper, false, 0, gc);
                }
                else
                {
                    sparse.sparsetrsv(sstate.sparsecca, sstate.sparseupper, false, 0, gc);
                    sparse.sparsetrsv(sstate.sparsecca, sstate.sparseupper, false, 1, gc);
                }
                result = true;
                return result;
            }
            alglib.ap.assert(false, "CNewtonStep: internal error");
            return result;
        }


    }
    public class qpbleicsolver
    {
        /*************************************************************************
        This object stores settings for QPBLEIC solver.
        It must be initialized with QPBLEICLoadDefaults().
        After initialization you may change settings.
        *************************************************************************/
        public class qpbleicsettings : apobject
        {
            public double epsg;
            public double epsf;
            public double epsx;
            public int maxits;
            public qpbleicsettings()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                qpbleicsettings _result = new qpbleicsettings();
                _result.epsg = epsg;
                _result.epsf = epsf;
                _result.epsx = epsx;
                _result.maxits = maxits;
                return _result;
            }
        };


        /*************************************************************************
        This object stores temporaries used by QuickQP solver.
        *************************************************************************/
        public class qpbleicbuffers : apobject
        {
            public minbleic.minbleicstate solver;
            public minbleic.minbleicreport solverrep;
            public double[] tmp0;
            public double[] tmp1;
            public int[] tmpi;
            public int repinneriterationscount;
            public int repouteriterationscount;
            public qpbleicbuffers()
            {
                init();
            }
            public override void init()
            {
                solver = new minbleic.minbleicstate();
                solverrep = new minbleic.minbleicreport();
                tmp0 = new double[0];
                tmp1 = new double[0];
                tmpi = new int[0];
            }
            public override alglib.apobject make_copy()
            {
                qpbleicbuffers _result = new qpbleicbuffers();
                _result.solver = (minbleic.minbleicstate)solver.make_copy();
                _result.solverrep = (minbleic.minbleicreport)solverrep.make_copy();
                _result.tmp0 = (double[])tmp0.Clone();
                _result.tmp1 = (double[])tmp1.Clone();
                _result.tmpi = (int[])tmpi.Clone();
                _result.repinneriterationscount = repinneriterationscount;
                _result.repouteriterationscount = repouteriterationscount;
                return _result;
            }
        };




        /*************************************************************************
        This function initializes QPBLEICSettings structure with default settings.

        Newly created structure MUST be initialized by default settings  -  or  by
        copy of the already initialized structure.

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qpbleicloaddefaults(int nmain,
            qpbleicsettings s)
        {
            s.epsg = 0.0;
            s.epsf = 0.0;
            s.epsx = 1.0E-6;
            s.maxits = 0;
        }


        /*************************************************************************
        This function initializes QPBLEICSettings  structure  with  copy  of  another,
        already initialized structure.

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qpbleiccopysettings(qpbleicsettings src,
            qpbleicsettings dst)
        {
            dst.epsg = src.epsg;
            dst.epsf = src.epsf;
            dst.epsx = src.epsx;
            dst.maxits = src.maxits;
        }


        /*************************************************************************
        This function runs QPBLEIC solver; it returns after optimization   process
        was completed. Following QP problem is solved:

            min(0.5*(x-x_origin)'*A*(x-x_origin)+b'*(x-x_origin))
            
        subject to boundary constraints.

        INPUT PARAMETERS:
            AC          -   for dense problems (AKind=0), A-term of CQM object
                            contains system matrix. Other terms are unspecified
                            and should not be referenced.
            SparseAC    -   for sparse problems (AKind=1
            AKind       -   sparse matrix format:
                            * 0 for dense matrix
                            * 1 for sparse matrix
            SparseUpper -   which triangle of SparseAC stores matrix  -  upper  or
                            lower one (for dense matrices this  parameter  is  not
                            actual).
            AbsASum     -   SUM(|A[i,j]|)
            AbsASum2    -   SUM(A[i,j]^2)
            BC          -   linear term, array[NC]
            BndLC       -   lower bound, array[NC]
            BndUC       -   upper bound, array[NC]
            SC          -   scale vector, array[NC]:
                            * I-th element contains scale of I-th variable,
                            * SC[I]>0
            XOriginC    -   origin term, array[NC]. Can be zero.
            NC          -   number of variables in the  original  formulation  (no
                            slack variables).
            CLEICC      -   linear equality/inequality constraints. Present version
                            of this function does NOT provide  publicly  available
                            support for linear constraints. This feature  will  be
                            introduced in the future versions of the function.
            NEC, NIC    -   number of equality/inequality constraints.
                            MUST BE ZERO IN THE CURRENT VERSION!!!
            Settings    -   QPBLEICSettings object initialized by one of the initialization
                            functions.
            SState      -   object which stores temporaries:
                            * if uninitialized object was passed, FirstCall parameter MUST
                              be set to True; object will be automatically initialized by the
                              function, and FirstCall will be set to False.
                            * if FirstCall=False, it is assumed that this parameter was already
                              initialized by previous call to this function with same
                              problem dimensions (variable count N).
            FirstCall   -   whether it is first call of this function for this specific
                            instance of SState, with this number of variables N specified.
            XS          -   initial point, array[NC]
            
            
        OUTPUT PARAMETERS:
            XS          -   last point
            FirstCall   -   uncondtionally set to False
            TerminationType-termination type:
                            *
                            *
                            *

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qpbleicoptimize(cqmodels.convexquadraticmodel a,
            sparse.sparsematrix sparsea,
            int akind,
            bool sparseaupper,
            double absasum,
            double absasum2,
            double[] b,
            double[] bndl,
            double[] bndu,
            double[] s,
            double[] xorigin,
            int n,
            double[,] cleic,
            int nec,
            int nic,
            qpbleicsettings settings,
            qpbleicbuffers sstate,
            ref bool firstcall,
            ref double[] xs,
            ref int terminationtype)
        {
            int i = 0;
            double d2 = 0;
            double d1 = 0;
            double d0 = 0;
            double v = 0;
            double v0 = 0;
            double v1 = 0;
            double md = 0;
            double mx = 0;
            double mb = 0;
            int d1est = 0;
            int d2est = 0;
            int i_ = 0;

            terminationtype = 0;

            alglib.ap.assert(akind==0 || akind==1, "QPBLEICOptimize: unexpected AKind");
            sstate.repinneriterationscount = 0;
            sstate.repouteriterationscount = 0;
            terminationtype = 0;
            
            //
            // Prepare solver object, if needed
            //
            if( firstcall )
            {
                minbleic.minbleiccreate(n, xs, sstate.solver);
                firstcall = false;
            }
            
            //
            // Prepare max(|B|)
            //
            mb = 0.0;
            for(i=0; i<=n-1; i++)
            {
                mb = Math.Max(mb, Math.Abs(b[i]));
            }
            
            //
            // Temporaries
            //
            apserv.ivectorsetlengthatleast(ref sstate.tmpi, nec+nic);
            apserv.rvectorsetlengthatleast(ref sstate.tmp0, n);
            apserv.rvectorsetlengthatleast(ref sstate.tmp1, n);
            for(i=0; i<=nec-1; i++)
            {
                sstate.tmpi[i] = 0;
            }
            for(i=0; i<=nic-1; i++)
            {
                sstate.tmpi[nec+i] = -1;
            }
            minbleic.minbleicsetlc(sstate.solver, cleic, sstate.tmpi, nec+nic);
            minbleic.minbleicsetbc(sstate.solver, bndl, bndu);
            minbleic.minbleicsetdrep(sstate.solver, true);
            minbleic.minbleicsetcond(sstate.solver, math.minrealnumber, 0.0, 0.0, settings.maxits);
            minbleic.minbleicsetscale(sstate.solver, s);
            minbleic.minbleicsetprecscale(sstate.solver);
            minbleic.minbleicrestartfrom(sstate.solver, xs);
            while( minbleic.minbleiciteration(sstate.solver) )
            {
                
                //
                // Line search started
                //
                if( sstate.solver.lsstart )
                {
                    
                    //
                    // Iteration counters:
                    // * inner iterations count is increased on every line search
                    // * outer iterations count is increased only at steepest descent line search
                    //
                    apserv.inc(ref sstate.repinneriterationscount);
                    if( sstate.solver.steepestdescentstep )
                    {
                        apserv.inc(ref sstate.repouteriterationscount);
                    }
                    
                    //
                    // Build quadratic model of F along descent direction:
                    //
                    //     F(x+alpha*d) = D2*alpha^2 + D1*alpha + D0
                    //
                    // Calculate estimates of linear and quadratic term
                    // (term magnitude is compared with magnitude of numerical errors)
                    //
                    d0 = sstate.solver.f;
                    d1 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        d1 += sstate.solver.d[i_]*sstate.solver.g[i_];
                    }
                    d2 = 0;
                    if( akind==0 )
                    {
                        d2 = cqmodels.cqmxtadx2(a, sstate.solver.d);
                    }
                    if( akind==1 )
                    {
                        sparse.sparsesmv(sparsea, sparseaupper, sstate.solver.d, ref sstate.tmp0);
                        d2 = 0.0;
                        for(i=0; i<=n-1; i++)
                        {
                            d2 = d2+sstate.solver.d[i]*sstate.tmp0[i];
                        }
                        d2 = 0.5*d2;
                    }
                    mx = 0.0;
                    md = 0.0;
                    for(i=0; i<=n-1; i++)
                    {
                        mx = Math.Max(mx, Math.Abs(sstate.solver.x[i]));
                        md = Math.Max(md, Math.Abs(sstate.solver.d[i]));
                    }
                    optserv.estimateparabolicmodel(absasum, absasum2, mx, mb, md, d1, d2, ref d1est, ref d2est);
                    
                    //
                    // Tests for "normal" convergence.
                    //
                    // This line search may be started from steepest descent
                    // stage (stage 2) or from L-BFGS stage (stage 3) of the
                    // BLEIC algorithm. Depending on stage type, different
                    // checks are performed.
                    //
                    // Say, L-BFGS stage is an equality-constrained refinement
                    // stage of BLEIC. This stage refines current iterate
                    // under "frozen" equality constraints. We can terminate
                    // iterations at this stage only when we encounter
                    // unconstrained direction of negative curvature. In all
                    // other cases (say, when constrained gradient is zero)
                    // we should not terminate algorithm because everything may
                    // change after de-activating presently active constraints.
                    //
                    // Tests for convergence are performed only at "steepest descent" stage
                    // of the BLEIC algorithm, and only when function is non-concave
                    // (D2 is positive or approximately zero) along direction D.
                    //
                    // NOTE: we do not test iteration count (MaxIts) here, because
                    //       this stopping condition is tested by BLEIC itself.
                    //
                    if( sstate.solver.steepestdescentstep && d2est>=0 )
                    {
                        if( d1est>=0 )
                        {
                            
                            //
                            // "Emergency" stopping condition: D is non-descent direction.
                            // Sometimes it is possible because of numerical noise in the
                            // target function.
                            //
                            terminationtype = 4;
                            for(i=0; i<=n-1; i++)
                            {
                                xs[i] = sstate.solver.x[i];
                            }
                            break;
                        }
                        if( d2est>0 )
                        {
                            
                            //
                            // Stopping condition #4 - gradient norm is small:
                            //
                            // 1. rescale State.Solver.D and State.Solver.G according to
                            //    current scaling, store results to Tmp0 and Tmp1.
                            // 2. Normalize Tmp0 (scaled direction vector).
                            // 3. compute directional derivative (in scaled variables),
                            //    which is equal to DOTPRODUCT(Tmp0,Tmp1).
                            //
                            v = 0;
                            for(i=0; i<=n-1; i++)
                            {
                                sstate.tmp0[i] = sstate.solver.d[i]/s[i];
                                sstate.tmp1[i] = sstate.solver.g[i]*s[i];
                                v = v+math.sqr(sstate.tmp0[i]);
                            }
                            alglib.ap.assert((double)(v)>(double)(0), "QPBLEICOptimize: inernal errror (scaled direction is zero)");
                            v = 1/Math.Sqrt(v);
                            for(i_=0; i_<=n-1;i_++)
                            {
                                sstate.tmp0[i_] = v*sstate.tmp0[i_];
                            }
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += sstate.tmp0[i_]*sstate.tmp1[i_];
                            }
                            if( (double)(Math.Abs(v))<=(double)(settings.epsg) )
                            {
                                terminationtype = 4;
                                for(i=0; i<=n-1; i++)
                                {
                                    xs[i] = sstate.solver.x[i];
                                }
                                break;
                            }
                            
                            //
                            // Stopping condition #1 - relative function improvement is small:
                            //
                            // 1. calculate steepest descent step:   V = -D1/(2*D2)
                            // 2. calculate function change:         V1= D2*V^2 + D1*V
                            // 3. stop if function change is small enough
                            //
                            v = -(d1/(2*d2));
                            v1 = d2*v*v+d1*v;
                            if( (double)(Math.Abs(v1))<=(double)(settings.epsf*Math.Max(d0, 1.0)) )
                            {
                                terminationtype = 1;
                                for(i=0; i<=n-1; i++)
                                {
                                    xs[i] = sstate.solver.x[i];
                                }
                                break;
                            }
                            
                            //
                            // Stopping condition #2 - scaled step is small:
                            //
                            // 1. calculate step multiplier V0 (step itself is D*V0)
                            // 2. calculate scaled step length V
                            // 3. stop if step is small enough
                            //
                            v0 = -(d1/(2*d2));
                            v = 0;
                            for(i=0; i<=n-1; i++)
                            {
                                v = v+math.sqr(v0*sstate.solver.d[i]/s[i]);
                            }
                            if( (double)(Math.Sqrt(v))<=(double)(settings.epsx) )
                            {
                                terminationtype = 2;
                                for(i=0; i<=n-1; i++)
                                {
                                    xs[i] = sstate.solver.x[i];
                                }
                                break;
                            }
                        }
                    }
                    
                    //
                    // Test for unconstrained direction of negative curvature
                    //
                    if( (d2est<0 || (d2est==0 && d1est<0)) && !sstate.solver.boundedstep )
                    {
                        
                        //
                        // Function is unbounded from below:
                        // * function will decrease along D, i.e. either:
                        //   * D2<0
                        //   * D2=0 and D1<0
                        // * step is unconstrained
                        //
                        // If these conditions are true, we abnormally terminate QP
                        // algorithm with return code -4 (we can do so at any stage
                        // of BLEIC - whether it is L-BFGS or steepest descent one).
                        //
                        terminationtype = -4;
                        for(i=0; i<=n-1; i++)
                        {
                            xs[i] = sstate.solver.x[i];
                        }
                        break;
                    }
                    
                    //
                    // Suggest new step (only if D1 is negative far away from zero,
                    // D2 is positive far away from zero).
                    //
                    if( d1est<0 && d2est>0 )
                    {
                        sstate.solver.stp = apserv.safeminposrv(-d1, 2*d2, sstate.solver.curstpmax);
                    }
                }
                
                //
                // Gradient evaluation
                //
                if( sstate.solver.needfg )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        sstate.tmp0[i] = sstate.solver.x[i]-xorigin[i];
                    }
                    if( akind==0 )
                    {
                        cqmodels.cqmadx(a, sstate.tmp0, ref sstate.tmp1);
                    }
                    if( akind==1 )
                    {
                        sparse.sparsesmv(sparsea, sparseaupper, sstate.tmp0, ref sstate.tmp1);
                    }
                    v0 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v0 += sstate.tmp0[i_]*sstate.tmp1[i_];
                    }
                    v1 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v1 += sstate.tmp0[i_]*b[i_];
                    }
                    sstate.solver.f = 0.5*v0+v1;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.solver.g[i_] = sstate.tmp1[i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.solver.g[i_] = sstate.solver.g[i_] + b[i_];
                    }
                }
            }
            if( terminationtype==0 )
            {
                
                //
                // BLEIC optimizer was terminated by one of its inner stopping
                // conditions. Usually it is iteration counter (if such
                // stopping condition was specified by user).
                //
                minbleic.minbleicresultsbuf(sstate.solver, ref xs, sstate.solverrep);
                terminationtype = sstate.solverrep.terminationtype;
            }
            else
            {
                
                //
                // BLEIC optimizer was terminated in "emergency" mode by QP
                // solver.
                //
                // NOTE: such termination is "emergency" only when viewed from
                //       BLEIC's position. QP solver sees such termination as
                //       routine one, triggered by QP's stopping criteria.
                //
                minbleic.minbleicemergencytermination(sstate.solver);
            }
        }


    }
    public class qpcholeskysolver
    {
        /*************************************************************************
        This object stores settings for QPCholesky solver.
        It must be initialized with QPCholeskyLoadDefaults().
        After initialization you may change settings.
        *************************************************************************/
        public class qpcholeskysettings : apobject
        {
            public double epsg;
            public double epsf;
            public double epsx;
            public int maxits;
            public qpcholeskysettings()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                qpcholeskysettings _result = new qpcholeskysettings();
                _result.epsg = epsg;
                _result.epsf = epsf;
                _result.epsx = epsx;
                _result.maxits = maxits;
                return _result;
            }
        };


        /*************************************************************************
        This object stores temporaries used by QuickQP solver.
        *************************************************************************/
        public class qpcholeskybuffers : apobject
        {
            public sactivesets.sactiveset sas;
            public double[] pg;
            public double[] gc;
            public double[] xs;
            public double[] xn;
            public double[] workbndl;
            public double[] workbndu;
            public bool[] havebndl;
            public bool[] havebndu;
            public double[,] workcleic;
            public double[] rctmpg;
            public double[] tmp0;
            public double[] tmp1;
            public bool[] tmpb;
            public int repinneriterationscount;
            public int repouteriterationscount;
            public int repncholesky;
            public qpcholeskybuffers()
            {
                init();
            }
            public override void init()
            {
                sas = new sactivesets.sactiveset();
                pg = new double[0];
                gc = new double[0];
                xs = new double[0];
                xn = new double[0];
                workbndl = new double[0];
                workbndu = new double[0];
                havebndl = new bool[0];
                havebndu = new bool[0];
                workcleic = new double[0,0];
                rctmpg = new double[0];
                tmp0 = new double[0];
                tmp1 = new double[0];
                tmpb = new bool[0];
            }
            public override alglib.apobject make_copy()
            {
                qpcholeskybuffers _result = new qpcholeskybuffers();
                _result.sas = (sactivesets.sactiveset)sas.make_copy();
                _result.pg = (double[])pg.Clone();
                _result.gc = (double[])gc.Clone();
                _result.xs = (double[])xs.Clone();
                _result.xn = (double[])xn.Clone();
                _result.workbndl = (double[])workbndl.Clone();
                _result.workbndu = (double[])workbndu.Clone();
                _result.havebndl = (bool[])havebndl.Clone();
                _result.havebndu = (bool[])havebndu.Clone();
                _result.workcleic = (double[,])workcleic.Clone();
                _result.rctmpg = (double[])rctmpg.Clone();
                _result.tmp0 = (double[])tmp0.Clone();
                _result.tmp1 = (double[])tmp1.Clone();
                _result.tmpb = (bool[])tmpb.Clone();
                _result.repinneriterationscount = repinneriterationscount;
                _result.repouteriterationscount = repouteriterationscount;
                _result.repncholesky = repncholesky;
                return _result;
            }
        };




        public const int maxlagrangeits = 10;
        public const int maxbadnewtonits = 7;
        public const double penaltyfactor = 100.0;


        /*************************************************************************
        This function initializes QPCholeskySettings structure with default settings.

        Newly created structure MUST be initialized by default settings  -  or  by
        copy of the already initialized structure.

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qpcholeskyloaddefaults(int nmain,
            qpcholeskysettings s)
        {
            s.epsg = 0.0;
            s.epsf = 0.0;
            s.epsx = 1.0E-6;
            s.maxits = 0;
        }


        /*************************************************************************
        This function initializes QPCholeskySettings  structure  with  copy  of  another,
        already initialized structure.

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qpcholeskycopysettings(qpcholeskysettings src,
            qpcholeskysettings dst)
        {
            dst.epsg = src.epsg;
            dst.epsf = src.epsf;
            dst.epsx = src.epsx;
            dst.maxits = src.maxits;
        }


        /*************************************************************************
        This function runs QPCholesky solver; it returns after optimization   process
        was completed. Following QP problem is solved:

            min(0.5*(x-x_origin)'*A*(x-x_origin)+b'*(x-x_origin))
            
        subject to boundary constraints.

        INPUT PARAMETERS:
            AC          -   for dense problems (AKind=0) contains system matrix in
                            the A-term of CQM object.  OTHER  TERMS  ARE  ACTIVELY
                            USED AND MODIFIED BY THE SOLVER!
            SparseAC    -   for sparse problems (AKind=1
            AKind       -   sparse matrix format:
                            * 0 for dense matrix
                            * 1 for sparse matrix
            SparseUpper -   which triangle of SparseAC stores matrix  -  upper  or
                            lower one (for dense matrices this  parameter  is  not
                            actual).
            BC          -   linear term, array[NC]
            BndLC       -   lower bound, array[NC]
            BndUC       -   upper bound, array[NC]
            SC          -   scale vector, array[NC]:
                            * I-th element contains scale of I-th variable,
                            * SC[I]>0
            XOriginC    -   origin term, array[NC]. Can be zero.
            NC          -   number of variables in the  original  formulation  (no
                            slack variables).
            CLEICC      -   linear equality/inequality constraints. Present version
                            of this function does NOT provide  publicly  available
                            support for linear constraints. This feature  will  be
                            introduced in the future versions of the function.
            NEC, NIC    -   number of equality/inequality constraints.
                            MUST BE ZERO IN THE CURRENT VERSION!!!
            Settings    -   QPCholeskySettings object initialized by one of the initialization
                            functions.
            SState      -   object which stores temporaries:
                            * if uninitialized object was passed, FirstCall parameter MUST
                              be set to True; object will be automatically initialized by the
                              function, and FirstCall will be set to False.
                            * if FirstCall=False, it is assumed that this parameter was already
                              initialized by previous call to this function with same
                              problem dimensions (variable count N).
            XS          -   initial point, array[NC]
            
            
        OUTPUT PARAMETERS:
            XS          -   last point
            TerminationType-termination type:
                            *
                            *
                            *

          -- ALGLIB --
             Copyright 14.05.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void qpcholeskyoptimize(cqmodels.convexquadraticmodel a,
            double anorm,
            double[] b,
            double[] bndl,
            double[] bndu,
            double[] s,
            double[] xorigin,
            int n,
            double[,] cleic,
            int nec,
            int nic,
            qpcholeskybuffers sstate,
            ref double[] xsc,
            ref int terminationtype)
        {
            int i = 0;
            double noisetolerance = 0;
            bool havebc = new bool();
            double v = 0;
            int badnewtonits = 0;
            double maxscaledgrad = 0;
            double v0 = 0;
            double v1 = 0;
            int nextaction = 0;
            double fprev = 0;
            double fcur = 0;
            double fcand = 0;
            double noiselevel = 0;
            double d0 = 0;
            double d1 = 0;
            double d2 = 0;
            int actstatus = 0;
            int i_ = 0;

            terminationtype = 0;

            
            //
            // Allocate storage and prepare fields
            //
            apserv.rvectorsetlengthatleast(ref sstate.rctmpg, n);
            apserv.rvectorsetlengthatleast(ref sstate.tmp0, n);
            apserv.rvectorsetlengthatleast(ref sstate.tmp1, n);
            apserv.rvectorsetlengthatleast(ref sstate.gc, n);
            apserv.rvectorsetlengthatleast(ref sstate.pg, n);
            apserv.rvectorsetlengthatleast(ref sstate.xs, n);
            apserv.rvectorsetlengthatleast(ref sstate.xn, n);
            apserv.rvectorsetlengthatleast(ref sstate.workbndl, n);
            apserv.rvectorsetlengthatleast(ref sstate.workbndu, n);
            apserv.bvectorsetlengthatleast(ref sstate.havebndl, n);
            apserv.bvectorsetlengthatleast(ref sstate.havebndu, n);
            sstate.repinneriterationscount = 0;
            sstate.repouteriterationscount = 0;
            sstate.repncholesky = 0;
            noisetolerance = 10;
            
            //
            // Our formulation of quadratic problem includes origin point,
            // i.e. we have F(x-x_origin) which is minimized subject to
            // constraints on x, instead of having simply F(x).
            //
            // Here we make transition from non-zero origin to zero one.
            // In order to make such transition we have to:
            // 1. subtract x_origin from x_start
            // 2. modify constraints
            // 3. solve problem
            // 4. add x_origin to solution
            //
            // There is alternate solution - to modify quadratic function
            // by expansion of multipliers containing (x-x_origin), but
            // we prefer to modify constraints, because it is a) more precise
            // and b) easier to to.
            //
            // Parts (1)-(2) are done here. After this block is over,
            // we have:
            // * XS, which stores shifted XStart (if we don't have XStart,
            //   value of XS will be ignored later)
            // * WorkBndL, WorkBndU, which store modified boundary constraints.
            //
            havebc = false;
            for(i=0; i<=n-1; i++)
            {
                sstate.havebndl[i] = math.isfinite(bndl[i]);
                sstate.havebndu[i] = math.isfinite(bndu[i]);
                havebc = (havebc || sstate.havebndl[i]) || sstate.havebndu[i];
                if( sstate.havebndl[i] )
                {
                    sstate.workbndl[i] = bndl[i]-xorigin[i];
                }
                else
                {
                    sstate.workbndl[i] = Double.NegativeInfinity;
                }
                if( sstate.havebndu[i] )
                {
                    sstate.workbndu[i] = bndu[i]-xorigin[i];
                }
                else
                {
                    sstate.workbndu[i] = Double.PositiveInfinity;
                }
            }
            apserv.rmatrixsetlengthatleast(ref sstate.workcleic, nec+nic, n+1);
            for(i=0; i<=nec+nic-1; i++)
            {
                v = 0.0;
                for(i_=0; i_<=n-1;i_++)
                {
                    v += cleic[i,i_]*xorigin[i_];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    sstate.workcleic[i,i_] = cleic[i,i_];
                }
                sstate.workcleic[i,n] = cleic[i,n]-v;
            }
            
            //
            // We have starting point in StartX, so we just have to shift and bound it
            //
            for(i=0; i<=n-1; i++)
            {
                sstate.xs[i] = xsc[i]-xorigin[i];
                if( sstate.havebndl[i] )
                {
                    if( (double)(sstate.xs[i])<(double)(sstate.workbndl[i]) )
                    {
                        sstate.xs[i] = sstate.workbndl[i];
                    }
                }
                if( sstate.havebndu[i] )
                {
                    if( (double)(sstate.xs[i])>(double)(sstate.workbndu[i]) )
                    {
                        sstate.xs[i] = sstate.workbndu[i];
                    }
                }
            }
            
            //
            // Handle special case - no constraints
            //
            if( !havebc && nec+nic==0 )
            {
                
                //
                // "Simple" unconstrained Cholesky
                //
                apserv.bvectorsetlengthatleast(ref sstate.tmpb, n);
                for(i=0; i<=n-1; i++)
                {
                    sstate.tmpb[i] = false;
                }
                sstate.repncholesky = sstate.repncholesky+1;
                cqmodels.cqmsetb(a, b);
                cqmodels.cqmsetactiveset(a, sstate.xs, sstate.tmpb);
                if( !cqmodels.cqmconstrainedoptimum(a, ref sstate.xn) )
                {
                    terminationtype = -5;
                    return;
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    xsc[i_] = sstate.xn[i_];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    xsc[i_] = xsc[i_] + xorigin[i_];
                }
                sstate.repinneriterationscount = 1;
                sstate.repouteriterationscount = 1;
                terminationtype = 4;
                return;
            }
            
            //
            // Prepare "active set" structure
            //
            sactivesets.sasinit(n, sstate.sas);
            sactivesets.sassetbc(sstate.sas, sstate.workbndl, sstate.workbndu);
            sactivesets.sassetlcx(sstate.sas, sstate.workcleic, nec, nic);
            sactivesets.sassetscale(sstate.sas, s);
            if( !sactivesets.sasstartoptimization(sstate.sas, sstate.xs) )
            {
                terminationtype = -3;
                return;
            }
            
            //
            // Main cycle of CQP algorithm
            //
            terminationtype = 4;
            badnewtonits = 0;
            maxscaledgrad = 0.0;
            while( true )
            {
                
                //
                // Update iterations count
                //
                apserv.inc(ref sstate.repouteriterationscount);
                apserv.inc(ref sstate.repinneriterationscount);
                
                //
                // Phase 1.
                //
                // Determine active set.
                // Update MaxScaledGrad.
                //
                cqmodels.cqmadx(a, sstate.sas.xc, ref sstate.rctmpg);
                for(i_=0; i_<=n-1;i_++)
                {
                    sstate.rctmpg[i_] = sstate.rctmpg[i_] + b[i_];
                }
                sactivesets.sasreactivateconstraints(sstate.sas, sstate.rctmpg);
                v = 0.0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.sqr(sstate.rctmpg[i]*s[i]);
                }
                maxscaledgrad = Math.Max(maxscaledgrad, Math.Sqrt(v));
                
                //
                // Phase 2: perform penalized steepest descent step.
                //
                // NextAction control variable is set on exit from this loop:
                // * NextAction>0 in case we have to proceed to Phase 3 (Newton step)
                // * NextAction<0 in case we have to proceed to Phase 1 (recalculate active set)
                // * NextAction=0 in case we found solution (step along projected gradient is small enough)
                //
                while( true )
                {
                    
                    //
                    // Calculate constrained descent direction, store to PG.
                    // Successful termination if PG is zero.
                    //
                    cqmodels.cqmadx(a, sstate.sas.xc, ref sstate.gc);
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.gc[i_] = sstate.gc[i_] + b[i_];
                    }
                    sactivesets.sasconstraineddescent(sstate.sas, sstate.gc, ref sstate.pg);
                    v0 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v0 += sstate.pg[i_]*sstate.pg[i_];
                    }
                    if( (double)(v0)==(double)(0) )
                    {
                        
                        //
                        // Constrained derivative is zero.
                        // Solution found.
                        //
                        nextaction = 0;
                        break;
                    }
                    
                    //
                    // Build quadratic model of F along descent direction:
                    //     F(xc+alpha*pg) = D2*alpha^2 + D1*alpha + D0
                    // Store noise level in the XC (noise level is used to classify
                    // step as singificant or insignificant).
                    //
                    // In case function curvature is negative or product of descent
                    // direction and gradient is non-negative, iterations are terminated.
                    //
                    // NOTE: D0 is not actually used, but we prefer to maintain it.
                    //
                    fprev = modelvalue(a, b, sstate.sas.xc, n, ref sstate.tmp0);
                    fprev = fprev+penaltyfactor*maxscaledgrad*sactivesets.sasactivelcpenalty1(sstate.sas, sstate.sas.xc);
                    cqmodels.cqmevalx(a, sstate.sas.xc, ref v, ref noiselevel);
                    v0 = cqmodels.cqmxtadx2(a, sstate.pg);
                    d2 = v0;
                    v1 = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v1 += sstate.pg[i_]*sstate.gc[i_];
                    }
                    d1 = v1;
                    d0 = fprev;
                    if( (double)(d2)<=(double)(0) )
                    {
                        
                        //
                        // Second derivative is non-positive, function is non-convex.
                        //
                        terminationtype = -5;
                        nextaction = 0;
                        break;
                    }
                    if( (double)(d1)>=(double)(0) )
                    {
                        
                        //
                        // Second derivative is positive, first derivative is non-negative.
                        // Solution found.
                        //
                        nextaction = 0;
                        break;
                    }
                    
                    //
                    // Modify quadratic model - add penalty for violation of the active
                    // constraints.
                    //
                    // Boundary constraints are always satisfied exactly, so we do not
                    // add penalty term for them. General equality constraint of the
                    // form a'*(xc+alpha*d)=b adds penalty term:
                    //     P(alpha) = (a'*(xc+alpha*d)-b)^2
                    //              = (alpha*(a'*d) + (a'*xc-b))^2
                    //              = alpha^2*(a'*d)^2 + alpha*2*(a'*d)*(a'*xc-b) + (a'*xc-b)^2
                    // Each penalty term is multiplied by 100*Anorm before adding it to
                    // the 1-dimensional quadratic model.
                    //
                    // Penalization of the quadratic model improves behavior of the
                    // algorithm in the presense of the multiple degenerate constraints.
                    // In particular, it prevents algorithm from making large steps in
                    // directions which violate equality constraints.
                    //
                    for(i=0; i<=nec+nic-1; i++)
                    {
                        if( sstate.sas.activeset[n+i]>0 )
                        {
                            v0 = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v0 += sstate.workcleic[i,i_]*sstate.pg[i_];
                            }
                            v1 = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v1 += sstate.workcleic[i,i_]*sstate.sas.xc[i_];
                            }
                            v1 = v1-sstate.workcleic[i,n];
                            v = 100*anorm;
                            d2 = d2+v*math.sqr(v0);
                            d1 = d1+v*2*v0*v1;
                            d0 = d0+v*math.sqr(v1);
                        }
                    }
                    
                    //
                    // Try unbounded step.
                    // In case function change is dominated by noise or function actually increased
                    // instead of decreasing, we terminate iterations.
                    //
                    v = -(d1/(2*d2));
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.xn[i_] = sstate.sas.xc[i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sstate.xn[i_] = sstate.xn[i_] + v*sstate.pg[i_];
                    }
                    fcand = modelvalue(a, b, sstate.xn, n, ref sstate.tmp0);
                    fcand = fcand+penaltyfactor*maxscaledgrad*sactivesets.sasactivelcpenalty1(sstate.sas, sstate.xn);
                    if( (double)(fcand)>=(double)(fprev-noiselevel*noisetolerance) )
                    {
                        nextaction = 0;
                        break;
                    }
                    
                    //
                    // Save active set
                    // Perform bounded step with (possible) activation
                    //
                    actstatus = boundedstepandactivation(sstate.sas, sstate.xn, n, ref sstate.tmp0);
                    fcur = modelvalue(a, b, sstate.sas.xc, n, ref sstate.tmp0);
                    
                    //
                    // Depending on results, decide what to do:
                    // 1. In case step was performed without activation of constraints,
                    //    we proceed to Newton method
                    // 2. In case there was activated at least one constraint with ActiveSet[I]<0,
                    //    we proceed to Phase 1 and re-evaluate active set.
                    // 3. Otherwise (activation of the constraints with ActiveSet[I]=0)
                    //    we try Phase 2 one more time.
                    //
                    if( actstatus<0 )
                    {
                        
                        //
                        // Step without activation, proceed to Newton
                        //
                        nextaction = 1;
                        break;
                    }
                    if( actstatus==0 )
                    {
                        
                        //
                        // No new constraints added during last activation - only
                        // ones which were at the boundary (ActiveSet[I]=0), but
                        // inactive due to numerical noise.
                        //
                        // Now, these constraints are added to the active set, and
                        // we try to perform steepest descent (Phase 2) one more time.
                        //
                        continue;
                    }
                    else
                    {
                        
                        //
                        // Last step activated at least one significantly new
                        // constraint (ActiveSet[I]<0), we have to re-evaluate
                        // active set (Phase 1).
                        //
                        nextaction = -1;
                        break;
                    }
                }
                if( nextaction<0 )
                {
                    continue;
                }
                if( nextaction==0 )
                {
                    break;
                }
                
                //
                // Phase 3: fast equality-constrained solver
                //
                // NOTE: this solver uses Augmented Lagrangian algorithm to solve
                //       equality-constrained subproblems. This algorithm may
                //       perform steps which increase function values instead of
                //       decreasing it (in hard cases, like overconstrained problems).
                //
                //       Such non-monononic steps may create a loop, when Augmented
                //       Lagrangian algorithm performs uphill step, and steepest
                //       descent algorithm (Phase 2) performs downhill step in the
                //       opposite direction.
                //
                //       In order to prevent iterations to continue forever we
                //       count iterations when AL algorithm increased function
                //       value instead of decreasing it. When number of such "bad"
                //       iterations will increase beyong MaxBadNewtonIts, we will
                //       terminate algorithm.
                //
                fprev = modelvalue(a, b, sstate.sas.xc, n, ref sstate.tmp0);
                while( true )
                {
                    
                    //
                    // Calculate optimum subject to presently active constraints
                    //
                    sstate.repncholesky = sstate.repncholesky+1;
                    if( !constrainedoptimum(sstate.sas, a, anorm, b, ref sstate.xn, n, ref sstate.tmp0, ref sstate.tmpb, ref sstate.tmp1) )
                    {
                        terminationtype = -5;
                        sactivesets.sasstopoptimization(sstate.sas);
                        return;
                    }
                    
                    //
                    // Add constraints.
                    // If no constraints was added, accept candidate point XN and move to next phase.
                    //
                    if( boundedstepandactivation(sstate.sas, sstate.xn, n, ref sstate.tmp0)<0 )
                    {
                        break;
                    }
                }
                fcur = modelvalue(a, b, sstate.sas.xc, n, ref sstate.tmp0);
                if( (double)(fcur)>=(double)(fprev) )
                {
                    badnewtonits = badnewtonits+1;
                }
                if( badnewtonits>=maxbadnewtonits )
                {
                    
                    //
                    // Algorithm found solution, but keeps iterating because Newton
                    // algorithm performs uphill steps (noise in the Augmented Lagrangian
                    // algorithm). We terminate algorithm; it is considered normal
                    // termination.
                    //
                    break;
                }
            }
            sactivesets.sasstopoptimization(sstate.sas);
            
            //
            // Post-process: add XOrigin to XC
            //
            for(i=0; i<=n-1; i++)
            {
                if( sstate.havebndl[i] && (double)(sstate.sas.xc[i])==(double)(sstate.workbndl[i]) )
                {
                    xsc[i] = bndl[i];
                    continue;
                }
                if( sstate.havebndu[i] && (double)(sstate.sas.xc[i])==(double)(sstate.workbndu[i]) )
                {
                    xsc[i] = bndu[i];
                    continue;
                }
                xsc[i] = apserv.boundval(sstate.sas.xc[i]+xorigin[i], bndl[i], bndu[i]);
            }
        }


        /*************************************************************************
        Model value: f = 0.5*x'*A*x + b'*x

        INPUT PARAMETERS:
            A       -   convex quadratic model; only main quadratic term is used,
                        other parts of the model (D/Q/linear term) are ignored.
                        This function does not modify model state.
            B       -   right part
            XC      -   evaluation point
            Tmp     -   temporary buffer, automatically resized if needed

          -- ALGLIB --
             Copyright 20.06.2012 by Bochkanov Sergey
        *************************************************************************/
        private static double modelvalue(cqmodels.convexquadraticmodel a,
            double[] b,
            double[] xc,
            int n,
            ref double[] tmp)
        {
            double result = 0;
            double v0 = 0;
            double v1 = 0;
            int i_ = 0;

            apserv.rvectorsetlengthatleast(ref tmp, n);
            cqmodels.cqmadx(a, xc, ref tmp);
            v0 = 0.0;
            for(i_=0; i_<=n-1;i_++)
            {
                v0 += xc[i_]*tmp[i_];
            }
            v1 = 0.0;
            for(i_=0; i_<=n-1;i_++)
            {
                v1 += xc[i_]*b[i_];
            }
            result = 0.5*v0+v1;
            return result;
        }


        /*************************************************************************
        Having feasible current point XC and possibly infeasible candidate   point
        XN,  this  function  performs  longest  step  from  XC to XN which retains
        feasibility. In case XN is found to be infeasible, at least one constraint
        is activated.

        For example, if we have:
          XC=0.5
          XN=1.2
          x>=0, x<=1
        then this function will move us to X=1.0 and activate constraint "x<=1".

        INPUT PARAMETERS:
            State   -   MinQP state.
            XC      -   current point, must be feasible with respect to
                        all constraints
            XN      -   candidate point, can be infeasible with respect to some
                        constraints. Must be located in the subspace of current
                        active set, i.e. it is feasible with respect to already
                        active constraints.
            Buf     -   temporary buffer, automatically resized if needed

        OUTPUT PARAMETERS:
            State   -   this function changes following fields of State:
                        * State.ActiveSet
                        * State.ActiveC     -   active linear constraints
            XC      -   new position

        RESULT:
            >0, in case at least one inactive non-candidate constraint was activated
            =0, in case only "candidate" constraints were activated
            <0, in case no constraints were activated by the step


          -- ALGLIB --
             Copyright 29.02.2012 by Bochkanov Sergey
        *************************************************************************/
        private static int boundedstepandactivation(sactivesets.sactiveset sas,
            double[] xn,
            int n,
            ref double[] buf)
        {
            int result = 0;
            double stpmax = 0;
            int cidx = 0;
            double cval = 0;
            bool needact = new bool();
            double v = 0;
            int i_ = 0;

            apserv.rvectorsetlengthatleast(ref buf, n);
            for(i_=0; i_<=n-1;i_++)
            {
                buf[i_] = xn[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                buf[i_] = buf[i_] - sas.xc[i_];
            }
            sactivesets.sasexploredirection(sas, buf, ref stpmax, ref cidx, ref cval);
            needact = (double)(stpmax)<=(double)(1);
            v = Math.Min(stpmax, 1.0);
            for(i_=0; i_<=n-1;i_++)
            {
                buf[i_] = v*buf[i_];
            }
            for(i_=0; i_<=n-1;i_++)
            {
                buf[i_] = buf[i_] + sas.xc[i_];
            }
            result = sactivesets.sasmoveto(sas, buf, needact, cidx, cval);
            return result;
        }


        /*************************************************************************
        Optimum of A subject to:
        a) active boundary constraints (given by ActiveSet[] and corresponding
           elements of XC)
        b) active linear constraints (given by C, R, LagrangeC)

        INPUT PARAMETERS:
            A       -   main quadratic term of the model;
                        although structure may  store  linear  and  rank-K  terms,
                        these terms are ignored and rewritten  by  this  function.
            ANorm   -   estimate of ||A|| (2-norm is used)
            B       -   array[N], linear term of the model
            XN      -   possibly preallocated buffer
            Tmp     -   temporary buffer (automatically resized)
            Tmp1    -   temporary buffer (automatically resized)

        OUTPUT PARAMETERS:
            A       -   modified quadratic model (this function changes rank-K
                        term and linear term of the model)
            LagrangeC-  current estimate of the Lagrange coefficients
            XN      -   solution

        RESULT:
            True on success, False on failure (non-SPD model)

          -- ALGLIB --
             Copyright 20.06.2012 by Bochkanov Sergey
        *************************************************************************/
        private static bool constrainedoptimum(sactivesets.sactiveset sas,
            cqmodels.convexquadraticmodel a,
            double anorm,
            double[] b,
            ref double[] xn,
            int n,
            ref double[] tmp,
            ref bool[] tmpb,
            ref double[] lagrangec)
        {
            bool result = new bool();
            int itidx = 0;
            int i = 0;
            double v = 0;
            double feaserrold = 0;
            double feaserrnew = 0;
            double theta = 0;
            int i_ = 0;

            
            //
            // Rebuild basis accroding to current active set.
            // We call SASRebuildBasis() to make sure that fields of SAS
            // store up to date values.
            //
            sactivesets.sasrebuildbasis(sas);
            
            //
            // Allocate temporaries.
            //
            apserv.rvectorsetlengthatleast(ref tmp, Math.Max(n, sas.basissize));
            apserv.bvectorsetlengthatleast(ref tmpb, n);
            apserv.rvectorsetlengthatleast(ref lagrangec, sas.basissize);
            
            //
            // Prepare model
            //
            for(i=0; i<=sas.basissize-1; i++)
            {
                tmp[i] = sas.pbasis[i,n];
            }
            theta = 100.0*anorm;
            for(i=0; i<=n-1; i++)
            {
                if( sas.activeset[i]>0 )
                {
                    tmpb[i] = true;
                }
                else
                {
                    tmpb[i] = false;
                }
            }
            cqmodels.cqmsetactiveset(a, sas.xc, tmpb);
            cqmodels.cqmsetq(a, sas.pbasis, tmp, sas.basissize, theta);
            
            //
            // Iterate until optimal values of Lagrange multipliers are found
            //
            for(i=0; i<=sas.basissize-1; i++)
            {
                lagrangec[i] = 0;
            }
            feaserrnew = math.maxrealnumber;
            result = true;
            for(itidx=1; itidx<=maxlagrangeits; itidx++)
            {
                
                //
                // Generate right part B using linear term and current
                // estimate of the Lagrange multipliers.
                //
                for(i_=0; i_<=n-1;i_++)
                {
                    tmp[i_] = b[i_];
                }
                for(i=0; i<=sas.basissize-1; i++)
                {
                    v = lagrangec[i];
                    for(i_=0; i_<=n-1;i_++)
                    {
                        tmp[i_] = tmp[i_] - v*sas.pbasis[i,i_];
                    }
                }
                cqmodels.cqmsetb(a, tmp);
                
                //
                // Solve
                //
                result = cqmodels.cqmconstrainedoptimum(a, ref xn);
                if( !result )
                {
                    return result;
                }
                
                //
                // Compare feasibility errors.
                // Terminate if error decreased too slowly.
                //
                feaserrold = feaserrnew;
                feaserrnew = 0;
                for(i=0; i<=sas.basissize-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += sas.pbasis[i,i_]*xn[i_];
                    }
                    feaserrnew = feaserrnew+math.sqr(v-sas.pbasis[i,n]);
                }
                feaserrnew = Math.Sqrt(feaserrnew);
                if( (double)(feaserrnew)>=(double)(0.2*feaserrold) )
                {
                    break;
                }
                
                //
                // Update Lagrange multipliers
                //
                for(i=0; i<=sas.basissize-1; i++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += sas.pbasis[i,i_]*xn[i_];
                    }
                    lagrangec[i] = lagrangec[i]-theta*(v-sas.pbasis[i,n]);
                }
            }
            return result;
        }


    }
    public class minqp
    {
        /*************************************************************************
        This object stores nonlinear optimizer state.
        You should use functions provided by MinQP subpackage to work with this
        object
        *************************************************************************/
        public class minqpstate : apobject
        {
            public int n;
            public qqpsolver.qqpsettings qqpsettingsuser;
            public qqpsolver.qqpsettings qqpsettingscurrent;
            public qpbleicsolver.qpbleicsettings qpbleicsettingsuser;
            public qpbleicsolver.qpbleicsettings qpbleicsettingscurrent;
            public int algokind;
            public int akind;
            public cqmodels.convexquadraticmodel a;
            public sparse.sparsematrix sparsea;
            public bool sparseaupper;
            public double absamax;
            public double absasum;
            public double absasum2;
            public double[] b;
            public double[] bndl;
            public double[] bndu;
            public double[] s;
            public bool[] havebndl;
            public bool[] havebndu;
            public double[] xorigin;
            public double[] startx;
            public bool havex;
            public double[,] cleic;
            public int nec;
            public int nic;
            public double[] xs;
            public int repinneriterationscount;
            public int repouteriterationscount;
            public int repncholesky;
            public int repnmv;
            public int repterminationtype;
            public double[] tmp0;
            public bool qpbleicfirstcall;
            public qpbleicsolver.qpbleicbuffers qpbleicbuf;
            public qqpsolver.qqpbuffers qqpbuf;
            public qpcholeskysolver.qpcholeskybuffers qpcholeskybuf;
            public normestimator.normestimatorstate estimator;
            public minqpstate()
            {
                init();
            }
            public override void init()
            {
                qqpsettingsuser = new qqpsolver.qqpsettings();
                qqpsettingscurrent = new qqpsolver.qqpsettings();
                qpbleicsettingsuser = new qpbleicsolver.qpbleicsettings();
                qpbleicsettingscurrent = new qpbleicsolver.qpbleicsettings();
                a = new cqmodels.convexquadraticmodel();
                sparsea = new sparse.sparsematrix();
                b = new double[0];
                bndl = new double[0];
                bndu = new double[0];
                s = new double[0];
                havebndl = new bool[0];
                havebndu = new bool[0];
                xorigin = new double[0];
                startx = new double[0];
                cleic = new double[0,0];
                xs = new double[0];
                tmp0 = new double[0];
                qpbleicbuf = new qpbleicsolver.qpbleicbuffers();
                qqpbuf = new qqpsolver.qqpbuffers();
                qpcholeskybuf = new qpcholeskysolver.qpcholeskybuffers();
                estimator = new normestimator.normestimatorstate();
            }
            public override alglib.apobject make_copy()
            {
                minqpstate _result = new minqpstate();
                _result.n = n;
                _result.qqpsettingsuser = (qqpsolver.qqpsettings)qqpsettingsuser.make_copy();
                _result.qqpsettingscurrent = (qqpsolver.qqpsettings)qqpsettingscurrent.make_copy();
                _result.qpbleicsettingsuser = (qpbleicsolver.qpbleicsettings)qpbleicsettingsuser.make_copy();
                _result.qpbleicsettingscurrent = (qpbleicsolver.qpbleicsettings)qpbleicsettingscurrent.make_copy();
                _result.algokind = algokind;
                _result.akind = akind;
                _result.a = (cqmodels.convexquadraticmodel)a.make_copy();
                _result.sparsea = (sparse.sparsematrix)sparsea.make_copy();
                _result.sparseaupper = sparseaupper;
                _result.absamax = absamax;
                _result.absasum = absasum;
                _result.absasum2 = absasum2;
                _result.b = (double[])b.Clone();
                _result.bndl = (double[])bndl.Clone();
                _result.bndu = (double[])bndu.Clone();
                _result.s = (double[])s.Clone();
                _result.havebndl = (bool[])havebndl.Clone();
                _result.havebndu = (bool[])havebndu.Clone();
                _result.xorigin = (double[])xorigin.Clone();
                _result.startx = (double[])startx.Clone();
                _result.havex = havex;
                _result.cleic = (double[,])cleic.Clone();
                _result.nec = nec;
                _result.nic = nic;
                _result.xs = (double[])xs.Clone();
                _result.repinneriterationscount = repinneriterationscount;
                _result.repouteriterationscount = repouteriterationscount;
                _result.repncholesky = repncholesky;
                _result.repnmv = repnmv;
                _result.repterminationtype = repterminationtype;
                _result.tmp0 = (double[])tmp0.Clone();
                _result.qpbleicfirstcall = qpbleicfirstcall;
                _result.qpbleicbuf = (qpbleicsolver.qpbleicbuffers)qpbleicbuf.make_copy();
                _result.qqpbuf = (qqpsolver.qqpbuffers)qqpbuf.make_copy();
                _result.qpcholeskybuf = (qpcholeskysolver.qpcholeskybuffers)qpcholeskybuf.make_copy();
                _result.estimator = (normestimator.normestimatorstate)estimator.make_copy();
                return _result;
            }
        };


        /*************************************************************************
        This structure stores optimization report:
        * InnerIterationsCount      number of inner iterations
        * OuterIterationsCount      number of outer iterations
        * NCholesky                 number of Cholesky decomposition
        * NMV                       number of matrix-vector products
                                    (only products calculated as part of iterative
                                    process are counted)
        * TerminationType           completion code (see below)

        Completion codes:
        * -5    inappropriate solver was used:
                * QuickQP solver for problem with general linear constraints
                * Cholesky solver for semidefinite or indefinite problems
                * Cholesky solver for problems with non-boundary constraints
        * -4    BLEIC-QP or QuickQP solver found unconstrained direction
                of negative curvature (function is unbounded from
                below  even  under  constraints),  no  meaningful
                minimum can be found.
        * -3    inconsistent constraints (or, maybe, feasible point is
                too hard to find). If you are sure that constraints are feasible,
                try to restart optimizer with better initial approximation.
        * -1    solver error
        *  1..4 successful completion
        *  5    MaxIts steps was taken
        *  7    stopping conditions are too stringent,
                further improvement is impossible,
                X contains best point found so far.
        *************************************************************************/
        public class minqpreport : apobject
        {
            public int inneriterationscount;
            public int outeriterationscount;
            public int nmv;
            public int ncholesky;
            public int terminationtype;
            public minqpreport()
            {
                init();
            }
            public override void init()
            {
            }
            public override alglib.apobject make_copy()
            {
                minqpreport _result = new minqpreport();
                _result.inneriterationscount = inneriterationscount;
                _result.outeriterationscount = outeriterationscount;
                _result.nmv = nmv;
                _result.ncholesky = ncholesky;
                _result.terminationtype = terminationtype;
                return _result;
            }
        };




        /*************************************************************************
                            CONSTRAINED QUADRATIC PROGRAMMING

        The subroutine creates QP optimizer. After initial creation,  it  contains
        default optimization problem with zero quadratic and linear terms  and  no
        constraints. You should set quadratic/linear terms with calls to functions
        provided by MinQP subpackage.

        You should also choose appropriate QP solver and set it  and  its stopping
        criteria by means of MinQPSetAlgo??????() function. Then, you should start
        solution process by means of MinQPOptimize() call. Solution itself can  be
        obtained with MinQPResults() function.

        INPUT PARAMETERS:
            N       -   problem size
            
        OUTPUT PARAMETERS:
            State   -   optimizer with zero quadratic/linear terms
                        and no constraints

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpcreate(int n,
            minqpstate state)
        {
            int i = 0;

            alglib.ap.assert(n>=1, "MinQPCreate: N<1");
            
            //
            // initialize QP solver
            //
            state.n = n;
            state.nec = 0;
            state.nic = 0;
            state.repterminationtype = 0;
            state.absamax = 1;
            state.absasum = 1;
            state.absasum2 = 1;
            state.akind = 0;
            state.sparseaupper = false;
            cqmodels.cqminit(n, state.a);
            state.b = new double[n];
            state.bndl = new double[n];
            state.bndu = new double[n];
            state.havebndl = new bool[n];
            state.havebndu = new bool[n];
            state.s = new double[n];
            state.startx = new double[n];
            state.xorigin = new double[n];
            state.xs = new double[n];
            for(i=0; i<=n-1; i++)
            {
                state.bndl[i] = Double.NegativeInfinity;
                state.bndu[i] = Double.PositiveInfinity;
                state.havebndl[i] = false;
                state.havebndu[i] = false;
                state.b[i] = 0.0;
                state.startx[i] = 0.0;
                state.xorigin[i] = 0.0;
                state.s[i] = 1.0;
            }
            state.havex = false;
            minqpsetalgocholesky(state);
            normestimator.normestimatorcreate(n, n, 5, 5, state.estimator);
            qqpsolver.qqploaddefaults(n, state.qqpsettingsuser);
            qpbleicsolver.qpbleicloaddefaults(n, state.qpbleicsettingsuser);
            state.qpbleicfirstcall = true;
        }


        /*************************************************************************
        This function sets linear term for QP solver.

        By default, linear term is zero.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            B       -   linear term, array[N].

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetlinearterm(minqpstate state,
            double[] b)
        {
            int n = 0;

            n = state.n;
            alglib.ap.assert(alglib.ap.len(b)>=n, "MinQPSetLinearTerm: Length(B)<N");
            alglib.ap.assert(apserv.isfinitevector(b, n), "MinQPSetLinearTerm: B contains infinite or NaN elements");
            minqpsetlineartermfast(state, b);
        }


        /*************************************************************************
        This  function  sets  dense  quadratic  term  for  QP solver. By  default,
        quadratic term is zero.

        SUPPORT BY ALGLIB QP ALGORITHMS:

        Dense quadratic term can be handled by any of the QP algorithms  supported
        by ALGLIB QP Solver.

        IMPORTANT:

        This solver minimizes following  function:
            f(x) = 0.5*x'*A*x + b'*x.
        Note that quadratic term has 0.5 before it. So if  you  want  to  minimize
            f(x) = x^2 + x
        you should rewrite your problem as follows:
            f(x) = 0.5*(2*x^2) + x
        and your matrix A will be equal to [[2.0]], not to [[1.0]]

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            A       -   matrix, array[N,N]
            IsUpper -   (optional) storage type:
                        * if True, symmetric matrix  A  is  given  by  its  upper
                          triangle, and the lower triangle isnt used
                        * if False, symmetric matrix  A  is  given  by  its lower
                          triangle, and the upper triangle isnt used
                        * if not given, both lower and upper  triangles  must  be
                          filled.

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetquadraticterm(minqpstate state,
            double[,] a,
            bool isupper)
        {
            int n = 0;

            n = state.n;
            alglib.ap.assert(alglib.ap.rows(a)>=n, "MinQPSetQuadraticTerm: Rows(A)<N");
            alglib.ap.assert(alglib.ap.cols(a)>=n, "MinQPSetQuadraticTerm: Cols(A)<N");
            alglib.ap.assert(apserv.isfinitertrmatrix(a, n, isupper), "MinQPSetQuadraticTerm: A contains infinite or NaN elements");
            minqpsetquadratictermfast(state, a, isupper, 0.0);
        }


        /*************************************************************************
        This  function  sets  sparse  quadratic  term  for  QP solver. By default,
        quadratic term is zero.

        IMPORTANT:

        This solver minimizes following  function:
            f(x) = 0.5*x'*A*x + b'*x.
        Note that quadratic term has 0.5 before it. So if  you  want  to  minimize
            f(x) = x^2 + x
        you should rewrite your problem as follows:
            f(x) = 0.5*(2*x^2) + x
        and your matrix A will be equal to [[2.0]], not to [[1.0]]

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            A       -   matrix, array[N,N]
            IsUpper -   (optional) storage type:
                        * if True, symmetric matrix  A  is  given  by  its  upper
                          triangle, and the lower triangle isnt used
                        * if False, symmetric matrix  A  is  given  by  its lower
                          triangle, and the upper triangle isnt used
                        * if not given, both lower and upper  triangles  must  be
                          filled.

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetquadratictermsparse(minqpstate state,
            sparse.sparsematrix a,
            bool isupper)
        {
            int n = 0;
            int t0 = 0;
            int t1 = 0;
            int i = 0;
            int j = 0;
            double v = 0;

            n = state.n;
            alglib.ap.assert(sparse.sparsegetnrows(a)==n, "MinQPSetQuadraticTermSparse: Rows(A)<>N");
            alglib.ap.assert(sparse.sparsegetncols(a)==n, "MinQPSetQuadraticTermSparse: Cols(A)<>N");
            sparse.sparsecopytocrsbuf(a, state.sparsea);
            state.sparseaupper = isupper;
            state.akind = 1;
            
            //
            // Estimate norm of A
            // (it will be used later in the quadratic penalty function)
            //
            state.absamax = 0;
            state.absasum = 0;
            state.absasum2 = 0;
            t0 = 0;
            t1 = 0;
            while( sparse.sparseenumerate(a, ref t0, ref t1, ref i, ref j, ref v) )
            {
                if( i==j )
                {
                    
                    //
                    // Diagonal terms are counted only once
                    //
                    state.absamax = Math.Max(state.absamax, v);
                    state.absasum = state.absasum+v;
                    state.absasum2 = state.absasum2+v*v;
                }
                if( (j>i && isupper) || (j<i && !isupper) )
                {
                    
                    //
                    // Offdiagonal terms are counted twice
                    //
                    state.absamax = Math.Max(state.absamax, v);
                    state.absasum = state.absasum+2*v;
                    state.absasum2 = state.absasum2+2*v*v;
                }
            }
        }


        /*************************************************************************
        This function sets starting point for QP solver. It is useful to have
        good initial approximation to the solution, because it will increase
        speed of convergence and identification of active constraints.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            X       -   starting point, array[N].

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetstartingpoint(minqpstate state,
            double[] x)
        {
            int n = 0;

            n = state.n;
            alglib.ap.assert(alglib.ap.len(x)>=n, "MinQPSetStartingPoint: Length(B)<N");
            alglib.ap.assert(apserv.isfinitevector(x, n), "MinQPSetStartingPoint: X contains infinite or NaN elements");
            minqpsetstartingpointfast(state, x);
        }


        /*************************************************************************
        This  function sets origin for QP solver. By default, following QP program
        is solved:

            min(0.5*x'*A*x+b'*x)
            
        This function allows to solve different problem:

            min(0.5*(x-x_origin)'*A*(x-x_origin)+b'*(x-x_origin))
            
        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            XOrigin -   origin, array[N].

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetorigin(minqpstate state,
            double[] xorigin)
        {
            int n = 0;

            n = state.n;
            alglib.ap.assert(alglib.ap.len(xorigin)>=n, "MinQPSetOrigin: Length(B)<N");
            alglib.ap.assert(apserv.isfinitevector(xorigin, n), "MinQPSetOrigin: B contains infinite or NaN elements");
            minqpsetoriginfast(state, xorigin);
        }


        /*************************************************************************
        This function sets scaling coefficients.

        ALGLIB optimizers use scaling matrices to test stopping  conditions  (step
        size and gradient are scaled before comparison with tolerances).  Scale of
        the I-th variable is a translation invariant measure of:
        a) "how large" the variable is
        b) how large the step should be to make significant changes in the function

        BLEIC-based QP solver uses scale for two purposes:
        * to evaluate stopping conditions
        * for preconditioning of the underlying BLEIC solver

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            S       -   array[N], non-zero scaling coefficients
                        S[i] may be negative, sign doesn't matter.

          -- ALGLIB --
             Copyright 14.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetscale(minqpstate state,
            double[] s)
        {
            int i = 0;

            alglib.ap.assert(alglib.ap.len(s)>=state.n, "MinQPSetScale: Length(S)<N");
            for(i=0; i<=state.n-1; i++)
            {
                alglib.ap.assert(math.isfinite(s[i]), "MinQPSetScale: S contains infinite or NAN elements");
                alglib.ap.assert((double)(s[i])!=(double)(0), "MinQPSetScale: S contains zero elements");
                state.s[i] = Math.Abs(s[i]);
            }
        }


        /*************************************************************************
        This function tells solver to use Cholesky-based algorithm. This algorithm
        was deprecated in ALGLIB 3.9.0 because its performance is inferior to that
        of BLEIC-QP or  QuickQP  on  high-dimensional  problems.  Furthermore,  it
        supports only dense convex QP problems.

        This solver is no longer active by default.

        We recommend you to switch to BLEIC-QP or QuickQP solver.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetalgocholesky(minqpstate state)
        {
            state.algokind = 1;
        }


        /*************************************************************************
        This function tells solver to use BLEIC-based algorithm and sets  stopping
        criteria for the algorithm.

        ALGORITHM FEATURES:

        * supports dense and sparse QP problems
        * supports boundary and general linear equality/inequality constraints
        * can solve all types of problems  (convex,  semidefinite,  nonconvex)  as
          long as they are bounded from below under constraints.
          Say, it is possible to solve "min{-x^2} subject to -1<=x<=+1".
          Of course, global  minimum  is found only  for  positive  definite   and
          semidefinite  problems.  As  for indefinite ones - only local minimum is
          found.

        ALGORITHM OUTLINE:

        * BLEIC-QP solver is just a driver function for MinBLEIC solver; it solves
          quadratic  programming   problem   as   general   linearly   constrained
          optimization problem, which is solved by means of BLEIC solver  (part of
          ALGLIB, active set method).
          
        ALGORITHM LIMITATIONS:

        * unlike QuickQP solver, this algorithm does not perform Newton steps  and
          does not use Level 3 BLAS. Being general-purpose active set  method,  it
          can activate constraints only one-by-one. Thus, its performance is lower
          than that of QuickQP.
        * its precision is also a bit  inferior  to  that  of   QuickQP.  BLEIC-QP
          performs only LBFGS steps (no Newton steps), which are good at detecting
          neighborhood of the solution, buy need many iterations to find  solution
          with more than 6 digits of precision.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            EpsG    -   >=0
                        The  subroutine  finishes  its  work   if   the  condition
                        |v|<EpsG is satisfied, where:
                        * |.| means Euclidian norm
                        * v - scaled constrained gradient vector, v[i]=g[i]*s[i]
                        * g - gradient
                        * s - scaling coefficients set by MinQPSetScale()
            EpsF    -   >=0
                        The  subroutine  finishes its work if exploratory steepest
                        descent  step  on  k+1-th iteration  satisfies   following
                        condition:  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
            EpsX    -   >=0
                        The  subroutine  finishes its work if exploratory steepest
                        descent  step  on  k+1-th iteration  satisfies   following
                        condition:  
                        * |.| means Euclidian norm
                        * v - scaled step vector, v[i]=dx[i]/s[i]
                        * dx - step vector, dx=X(k+1)-X(k)
                        * s - scaling coefficients set by MinQPSetScale()
            MaxIts  -   maximum number of iterations. If MaxIts=0, the  number  of
                        iterations is unlimited. NOTE: this  algorithm uses  LBFGS
                        iterations,  which  are  relatively  cheap,  but   improve
                        function value only a bit. So you will need many iterations
                        to converge - from 0.1*N to 10*N, depending  on  problem's
                        condition number.

        IT IS VERY IMPORTANT TO CALL MinQPSetScale() WHEN YOU USE THIS  ALGORITHM
        BECAUSE ITS STOPPING CRITERIA ARE SCALE-DEPENDENT!

        Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
        to automatic stopping criterion selection (presently it is  small    step
        length, but it may change in the future versions of ALGLIB).

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetalgobleic(minqpstate state,
            double epsg,
            double epsf,
            double epsx,
            int maxits)
        {
            alglib.ap.assert(math.isfinite(epsg), "MinQPSetAlgoBLEIC: EpsG is not finite number");
            alglib.ap.assert((double)(epsg)>=(double)(0), "MinQPSetAlgoBLEIC: negative EpsG");
            alglib.ap.assert(math.isfinite(epsf), "MinQPSetAlgoBLEIC: EpsF is not finite number");
            alglib.ap.assert((double)(epsf)>=(double)(0), "MinQPSetAlgoBLEIC: negative EpsF");
            alglib.ap.assert(math.isfinite(epsx), "MinQPSetAlgoBLEIC: EpsX is not finite number");
            alglib.ap.assert((double)(epsx)>=(double)(0), "MinQPSetAlgoBLEIC: negative EpsX");
            alglib.ap.assert(maxits>=0, "MinQPSetAlgoBLEIC: negative MaxIts!");
            state.algokind = 2;
            if( (((double)(epsg)==(double)(0) && (double)(epsf)==(double)(0)) && (double)(epsx)==(double)(0)) && maxits==0 )
            {
                epsx = 1.0E-6;
            }
            state.qpbleicsettingsuser.epsg = epsg;
            state.qpbleicsettingsuser.epsf = epsf;
            state.qpbleicsettingsuser.epsx = epsx;
            state.qpbleicsettingsuser.maxits = maxits;
        }


        /*************************************************************************
        This function tells solver to use QuickQP  algorithm:  special  extra-fast
        algorithm   for   problems  with  boundary-only constrants. It  may  solve
        non-convex  problems  as  long  as  they  are  bounded  from  below  under
        constraints.

        ALGORITHM FEATURES:
        * many times (from 5x to 50x!) faster than BLEIC-based QP solver; utilizes
          accelerated methods for activation of constraints.
        * supports dense and sparse QP problems
        * supports ONLY boundary constraints; general linear constraints  are  NOT
          supported by this solver
        * can solve all types of problems  (convex,  semidefinite,  nonconvex)  as
          long as they are bounded from below under constraints.
          Say, it is possible to solve "min{-x^2} subject to -1<=x<=+1".
          In convex/semidefinite case global minimum  is  returned,  in  nonconvex
          case - algorithm returns one of the local minimums.

        ALGORITHM OUTLINE:

        * algorithm  performs  two kinds of iterations: constrained CG  iterations
          and constrained Newton iterations
        * initially it performs small number of constrained CG  iterations,  which
          can efficiently activate/deactivate multiple constraints
        * after CG phase algorithm tries to calculate Cholesky  decomposition  and
          to perform several constrained Newton steps. If  Cholesky  decomposition
          failed (matrix is indefinite even under constraints),  we  perform  more
          CG iterations until we converge to such set of constraints  that  system
          matrix becomes  positive  definite.  Constrained  Newton  steps  greatly
          increase convergence speed and precision.
        * algorithm interleaves CG and Newton iterations which  allows  to  handle
          indefinite matrices (CG phase) and quickly converge after final  set  of
          constraints is found (Newton phase). Combination of CG and Newton phases
          is called "outer iteration".
        * it is possible to turn off Newton  phase  (beneficial  for  semidefinite
          problems - Cholesky decomposition will fail too often)
          
        ALGORITHM LIMITATIONS:

        * algorithm does not support general  linear  constraints;  only  boundary
          ones are supported
        * Cholesky decomposition for sparse problems  is  performed  with  Skyline
          Cholesky solver, which is intended for low-profile matrices. No profile-
          reducing reordering of variables is performed in this version of ALGLIB.
        * problems with near-zero negative eigenvalues (or exacty zero  ones)  may
          experience about 2-3x performance penalty. The reason is  that  Cholesky
          decomposition can not be performed until we identify directions of  zero
          and negative curvature and activate corresponding boundary constraints -
          but we need a lot of trial and errors because these directions  are hard
          to notice in the matrix spectrum.
          In this case you may turn off Newton phase of algorithm.
          Large negative eigenvalues  are  not  an  issue,  so  highly  non-convex
          problems can be solved very efficiently.

        INPUT PARAMETERS:
            State   -   structure which stores algorithm state
            EpsG    -   >=0
                        The  subroutine  finishes  its  work   if   the  condition
                        |v|<EpsG is satisfied, where:
                        * |.| means Euclidian norm
                        * v - scaled constrained gradient vector, v[i]=g[i]*s[i]
                        * g - gradient
                        * s - scaling coefficients set by MinQPSetScale()
            EpsF    -   >=0
                        The  subroutine  finishes its work if exploratory steepest
                        descent  step  on  k+1-th iteration  satisfies   following
                        condition:  |F(k+1)-F(k)|<=EpsF*max{|F(k)|,|F(k+1)|,1}
            EpsX    -   >=0
                        The  subroutine  finishes its work if exploratory steepest
                        descent  step  on  k+1-th iteration  satisfies   following
                        condition:  
                        * |.| means Euclidian norm
                        * v - scaled step vector, v[i]=dx[i]/s[i]
                        * dx - step vector, dx=X(k+1)-X(k)
                        * s - scaling coefficients set by MinQPSetScale()
            MaxOuterIts-maximum number of OUTER iterations.  One  outer  iteration
                        includes some amount of CG iterations (from 5 to  ~N)  and
                        one or several (usually small amount) Newton steps.  Thus,
                        one outer iteration has high cost, but can greatly  reduce
                        funcation value.
            UseNewton-  use Newton phase or not:
                        * Newton phase improves performance of  positive  definite
                          dense problems (about 2 times improvement can be observed)
                        * can result in some performance penalty  on  semidefinite
                          or slightly negative definite  problems  -  each  Newton
                          phase will bring no improvement (Cholesky failure),  but
                          still will require computational time.
                        * if you doubt, you can turn off this  phase  -  optimizer
                          will retain its most of its high speed.

        IT IS VERY IMPORTANT TO CALL MinQPSetScale() WHEN YOU USE THIS  ALGORITHM
        BECAUSE ITS STOPPING CRITERIA ARE SCALE-DEPENDENT!

        Passing EpsG=0, EpsF=0 and EpsX=0 and MaxIts=0 (simultaneously) will lead
        to automatic stopping criterion selection (presently it is  small    step
        length, but it may change in the future versions of ALGLIB).

          -- ALGLIB --
             Copyright 22.05.2014 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetalgoquickqp(minqpstate state,
            double epsg,
            double epsf,
            double epsx,
            int maxouterits,
            bool usenewton)
        {
            alglib.ap.assert(math.isfinite(epsg), "MinQPSetAlgoQuickQP: EpsG is not finite number");
            alglib.ap.assert((double)(epsg)>=(double)(0), "MinQPSetAlgoQuickQP: negative EpsG");
            alglib.ap.assert(math.isfinite(epsf), "MinQPSetAlgoQuickQP: EpsF is not finite number");
            alglib.ap.assert((double)(epsf)>=(double)(0), "MinQPSetAlgoQuickQP: negative EpsF");
            alglib.ap.assert(math.isfinite(epsx), "MinQPSetAlgoQuickQP: EpsX is not finite number");
            alglib.ap.assert((double)(epsx)>=(double)(0), "MinQPSetAlgoQuickQP: negative EpsX");
            alglib.ap.assert(maxouterits>=0, "MinQPSetAlgoQuickQP: negative MaxOuterIts!");
            state.algokind = 3;
            if( (((double)(epsg)==(double)(0) && (double)(epsf)==(double)(0)) && (double)(epsx)==(double)(0)) && maxouterits==0 )
            {
                epsx = 1.0E-6;
            }
            state.qqpsettingsuser.maxouterits = maxouterits;
            state.qqpsettingsuser.epsg = epsg;
            state.qqpsettingsuser.epsf = epsf;
            state.qqpsettingsuser.epsx = epsx;
            state.qqpsettingsuser.cnphase = usenewton;
        }


        /*************************************************************************
        This function sets boundary constraints for QP solver

        Boundary constraints are inactive by default (after initial creation).
        After  being  set,  they  are  preserved  until explicitly turned off with
        another SetBC() call.

        INPUT PARAMETERS:
            State   -   structure stores algorithm state
            BndL    -   lower bounds, array[N].
                        If some (all) variables are unbounded, you may specify
                        very small number or -INF (latter is recommended because
                        it will allow solver to use better algorithm).
            BndU    -   upper bounds, array[N].
                        If some (all) variables are unbounded, you may specify
                        very large number or +INF (latter is recommended because
                        it will allow solver to use better algorithm).
                        
        NOTE: it is possible to specify BndL[i]=BndU[i]. In this case I-th
        variable will be "frozen" at X[i]=BndL[i]=BndU[i].

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetbc(minqpstate state,
            double[] bndl,
            double[] bndu)
        {
            int i = 0;
            int n = 0;

            n = state.n;
            alglib.ap.assert(alglib.ap.len(bndl)>=n, "MinQPSetBC: Length(BndL)<N");
            alglib.ap.assert(alglib.ap.len(bndu)>=n, "MinQPSetBC: Length(BndU)<N");
            for(i=0; i<=n-1; i++)
            {
                alglib.ap.assert(math.isfinite(bndl[i]) || Double.IsNegativeInfinity(bndl[i]), "MinQPSetBC: BndL contains NAN or +INF");
                alglib.ap.assert(math.isfinite(bndu[i]) || Double.IsPositiveInfinity(bndu[i]), "MinQPSetBC: BndU contains NAN or -INF");
                state.bndl[i] = bndl[i];
                state.havebndl[i] = math.isfinite(bndl[i]);
                state.bndu[i] = bndu[i];
                state.havebndu[i] = math.isfinite(bndu[i]);
            }
        }


        /*************************************************************************
        This function sets linear constraints for QP optimizer.

        Linear constraints are inactive by default (after initial creation).

        INPUT PARAMETERS:
            State   -   structure previously allocated with MinQPCreate call.
            C       -   linear constraints, array[K,N+1].
                        Each row of C represents one constraint, either equality
                        or inequality (see below):
                        * first N elements correspond to coefficients,
                        * last element corresponds to the right part.
                        All elements of C (including right part) must be finite.
            CT      -   type of constraints, array[K]:
                        * if CT[i]>0, then I-th constraint is C[i,*]*x >= C[i,n+1]
                        * if CT[i]=0, then I-th constraint is C[i,*]*x  = C[i,n+1]
                        * if CT[i]<0, then I-th constraint is C[i,*]*x <= C[i,n+1]
            K       -   number of equality/inequality constraints, K>=0:
                        * if given, only leading K elements of C/CT are used
                        * if not given, automatically determined from sizes of C/CT

        NOTE 1: linear (non-bound) constraints are satisfied only approximately  -
                there always exists some minor violation (about 10^-10...10^-13)
                due to numerical errors.

          -- ALGLIB --
             Copyright 19.06.2012 by Bochkanov Sergey
        *************************************************************************/
        public static void minqpsetlc(minqpstate state,
            double[,] c,
            int[] ct,
            int k)
        {
            int n = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            n = state.n;
            
            //
            // First, check for errors in the inputs
            //
            alglib.ap.assert(k>=0, "MinQPSetLC: K<0");
            alglib.ap.assert(alglib.ap.cols(c)>=n+1 || k==0, "MinQPSetLC: Cols(C)<N+1");
            alglib.ap.assert(alglib.ap.rows(c)>=k, "MinQPSetLC: Rows(C)<K");
            alglib.ap.assert(alglib.ap.len(ct)>=k, "MinQPSetLC: Length(CT)<K");
            alglib.ap.assert(apserv.apservisfinitematrix(c, k, n+1), "MinQPSetLC: C contains infinite or NaN values!");
            
            //
            // Handle zero K
            //
            if( k==0 )
            {
                state.nec = 0;
                state.nic = 0;
                return;
            }
            
            //
            // Equality constraints are stored first, in the upper
            // NEC rows of State.CLEIC matrix. Inequality constraints
            // are stored in the next NIC rows.
            //
            // NOTE: we convert inequality constraints to the form
            // A*x<=b before copying them.
            //
            apserv.rmatrixsetlengthatleast(ref state.cleic, k, n+1);
            state.nec = 0;
            state.nic = 0;
            for(i=0; i<=k-1; i++)
            {
                if( ct[i]==0 )
                {
                    for(i_=0; i_<=n;i_++)
                    {
                        state.cleic[state.nec,i_] = c[i,i_];
                    }
                    state.nec = state.nec+1;
                }
            }
            for(i=0; i<=k-1; i++)
            {
                if( ct[i]!=0 )
                {
                    if( ct[i]>0 )
                    {
                        for(i_=0; i_<=n;i_++)
                        {
                            state.cleic[state.nec+state.nic,i_] = -c[i,i_];
                        }
                    }
                    else
                    {
                        for(i_=0; i_<=n;i_++)
                        {
                            state.cleic[state.nec+state.nic,i_] = c[i,i_];
                        }
                    }
                    state.nic = state.nic+1;
                }
            }
            
            //
            // Normalize rows of State.CLEIC: each row must have unit norm.
            // Norm is calculated using first N elements (i.e. right part is
            // not counted when we calculate norm).
            //
            for(i=0; i<=k-1; i++)
            {
                v = 0;
                for(j=0; j<=n-1; j++)
                {
                    v = v+math.sqr(state.cleic[i,j]);
                }
                if( (double)(v)==(double)(0) )
                {
                    continue;
                }
                v = 1/Math.Sqrt(v);
                for(i_=0; i_<=n;i_++)
                {
                    state.cleic[i,i_] = v*state.cleic[i,i_];
                }
            }
        }


        /*************************************************************************
        This function solves quadratic programming problem.

        Prior to calling this function you should choose solver by means of one of
        the following functions:

        * MinQPSetAlgoQuickQP() - for QuickQP solver
        * MinQPSetAlgoBLEIC() - for BLEIC-QP solver

        These functions also allow you to control stopping criteria of the solver.
        If you did not set solver,  MinQP  subpackage  will  automatically  select
        solver for your problem and will run it with default stopping criteria.

        However, it is better to set explicitly solver and its stopping criteria.

        INPUT PARAMETERS:
            State   -   algorithm state

        You should use MinQPResults() function to access results after calls
        to this function.

          -- ALGLIB --
             Copyright 11.01.2011 by Bochkanov Sergey.
             Special thanks to Elvira Illarionova  for  important  suggestions  on
             the linearly constrained QP algorithm.
        *************************************************************************/
        public static void minqpoptimize(minqpstate state)
        {
            int n = 0;
            int i = 0;
            int nbc = 0;
            int currentsolver = 0;

            n = state.n;
            state.repterminationtype = -5;
            state.repinneriterationscount = 0;
            state.repouteriterationscount = 0;
            state.repncholesky = 0;
            state.repnmv = 0;
            
            //
            // check correctness of constraints
            //
            for(i=0; i<=n-1; i++)
            {
                if( state.havebndl[i] && state.havebndu[i] )
                {
                    if( (double)(state.bndl[i])>(double)(state.bndu[i]) )
                    {
                        state.repterminationtype = -3;
                        return;
                    }
                }
            }
            
            //
            // count number of bound and linear constraints
            //
            nbc = 0;
            for(i=0; i<=n-1; i++)
            {
                if( state.havebndl[i] )
                {
                    nbc = nbc+1;
                }
                if( state.havebndu[i] )
                {
                    nbc = nbc+1;
                }
            }
            
            //
            // Initial point:
            // * if we have starting point in StartX, we just have to bound it
            // * if we do not have StartX, deduce initial point from boundary constraints
            //
            if( state.havex )
            {
                for(i=0; i<=n-1; i++)
                {
                    state.xs[i] = state.startx[i];
                    if( state.havebndl[i] && (double)(state.xs[i])<(double)(state.bndl[i]) )
                    {
                        state.xs[i] = state.bndl[i];
                    }
                    if( state.havebndu[i] && (double)(state.xs[i])>(double)(state.bndu[i]) )
                    {
                        state.xs[i] = state.bndu[i];
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    if( state.havebndl[i] && state.havebndu[i] )
                    {
                        state.xs[i] = 0.5*(state.bndl[i]+state.bndu[i]);
                        continue;
                    }
                    if( state.havebndl[i] )
                    {
                        state.xs[i] = state.bndl[i];
                        continue;
                    }
                    if( state.havebndu[i] )
                    {
                        state.xs[i] = state.bndu[i];
                        continue;
                    }
                    state.xs[i] = 0;
                }
            }
            
            //
            // Choose solver - user-specified or default one.
            //
            currentsolver = state.algokind;
            if( currentsolver==0 )
            {
                
                //
                // Choose solver automatically
                //
                if( state.nec+state.nic==0 )
                {
                    
                    //
                    // QQP solver is used for problems without linear constraints
                    //
                    currentsolver = 3;
                    qqpsolver.qqploaddefaults(n, state.qqpsettingscurrent);
                }
                else
                {
                    
                    //
                    // QP-BLEIC s