#pragma warning disable 162
#pragma warning disable 219
using System;

public partial class alglib
{
    public class testhqrndunit
    {
        public static bool testhqrnd(bool silent)
        {
            bool result = new bool();
            bool waserrors = new bool();
            int samplesize = 0;
            double sigmathreshold = 0;
            int passcount = 0;
            int n = 0;
            int i = 0;
            int k = 0;
            int pass = 0;
            int s1 = 0;
            int s2 = 0;
            int i1 = 0;
            int i2 = 0;
            double r1 = 0;
            double r2 = 0;
            double[] x = new double[0];
            int[] bins = new int[0];
            double mean = 0;
            double means = 0;
            double stddev = 0;
            double stddevs = 0;
            double lambdav = 0;
            bool seederrors = new bool();
            bool urerrors = new bool();
            double ursigmaerr = 0;
            bool uierrors = new bool();
            double uisigmaerr = 0;
            bool normerrors = new bool();
            double normsigmaerr = 0;
            bool unit2errors = new bool();
            bool experrors = new bool();
            double expsigmaerr = 0;
            bool discreteerr = new bool();
            bool continuouserr = new bool();
            hqrnd.hqrndstate state = new hqrnd.hqrndstate();

            waserrors = false;
            sigmathreshold = 7;
            samplesize = 100000;
            passcount = 50;
            seederrors = false;
            urerrors = false;
            uierrors = false;
            normerrors = false;
            experrors = false;
            unit2errors = false;
            x = new double[samplesize-1+1];
            
            //
            // Test seed errors
            //
            for(pass=1; pass<=passcount; pass++)
            {
                s1 = 1+math.randominteger(32000);
                s2 = 1+math.randominteger(32000);
                unsetstate(state);
                hqrnd.hqrndseed(s1, s2, state);
                i1 = hqrnd.hqrnduniformi(state, 100);
                unsetstate(state);
                hqrnd.hqrndseed(s1, s2, state);
                i2 = hqrnd.hqrnduniformi(state, 100);
                seederrors = seederrors || i1!=i2;
                unsetstate(state);
                hqrnd.hqrndseed(s1, s2, state);
                r1 = hqrnd.hqrnduniformr(state);
                unsetstate(state);
                hqrnd.hqrndseed(s1, s2, state);
                r2 = hqrnd.hqrnduniformr(state);
                seederrors = seederrors || (double)(r1)!=(double)(r2);
            }
            
            //
            // Test HQRNDRandomize() and real uniform generator
            //
            unsetstate(state);
            hqrnd.hqrndrandomize(state);
            ursigmaerr = 0;
            for(i=0; i<=samplesize-1; i++)
            {
                x[i] = hqrnd.hqrnduniformr(state);
            }
            for(i=0; i<=samplesize-1; i++)
            {
                urerrors = (urerrors || (double)(x[i])<=(double)(0)) || (double)(x[i])>=(double)(1);
            }
            calculatemv(x, samplesize, ref mean, ref means, ref stddev, ref stddevs);
            if( (double)(means)!=(double)(0) )
            {
                ursigmaerr = Math.Max(ursigmaerr, Math.Abs((mean-0.5)/means));
            }
            else
            {
                urerrors = true;
            }
            if( (double)(stddevs)!=(double)(0) )
            {
                ursigmaerr = Math.Max(ursigmaerr, Math.Abs((stddev-Math.Sqrt((double)1/(double)12))/stddevs));
            }
            else
            {
                urerrors = true;
            }
            urerrors = urerrors || (double)(ursigmaerr)>(double)(sigmathreshold);
            
            //
            // Test HQRNDRandomize() and integer uniform
            //
            unsetstate(state);
            hqrnd.hqrndrandomize(state);
            uisigmaerr = 0;
            for(n=2; n<=10; n++)
            {
                for(i=0; i<=samplesize-1; i++)
                {
                    x[i] = hqrnd.hqrnduniformi(state, n);
                }
                for(i=0; i<=samplesize-1; i++)
                {
                    uierrors = (uierrors || (double)(x[i])<(double)(0)) || (double)(x[i])>=(double)(n);
                }
                calculatemv(x, samplesize, ref mean, ref means, ref stddev, ref stddevs);
                if( (double)(means)!=(double)(0) )
                {
                    uisigmaerr = Math.Max(uisigmaerr, Math.Abs((mean-0.5*(n-1))/means));
                }
                else
                {
                    uierrors = true;
                }
                if( (double)(stddevs)!=(double)(0) )
                {
                    uisigmaerr = Math.Max(uisigmaerr, Math.Abs((stddev-Math.Sqrt((math.sqr(n)-1)/12))/stddevs));
                }
                else
                {
                    uierrors = true;
                }
            }
            uierrors = uierrors || (double)(uisigmaerr)>(double)(sigmathreshold);
            
            //
            // Special 'close-to-limit' test on uniformity of integers
            // (straightforward implementation like 'RND mod N' will return
            //  non-uniform numbers for N=2/3*LIMIT)
            //
            unsetstate(state);
            hqrnd.hqrndrandomize(state);
            uisigmaerr = 0;
            n = 1431655708;
            for(i=0; i<=samplesize-1; i++)
            {
                x[i] = hqrnd.hqrnduniformi(state, n);
            }
            for(i=0; i<=samplesize-1; i++)
            {
                uierrors = (uierrors || (double)(x[i])<(double)(0)) || (double)(x[i])>=(double)(n);
            }
            calculatemv(x, samplesize, ref mean, ref means, ref stddev, ref stddevs);
            if( (double)(means)!=(double)(0) )
            {
                uisigmaerr = Math.Max(uisigmaerr, Math.Abs((mean-0.5*(n-1))/means));
            }
            else
            {
                uierrors = true;
            }
            if( (double)(stddevs)!=(double)(0) )
            {
                uisigmaerr = Math.Max(uisigmaerr, Math.Abs((stddev-Math.Sqrt((math.sqr(n)-1)/12))/stddevs));
            }
            else
            {
                uierrors = true;
            }
            uierrors = uierrors || (double)(uisigmaerr)>(double)(sigmathreshold);
            
            //
            // Test normal
            //
            unsetstate(state);
            hqrnd.hqrndrandomize(state);
            normsigmaerr = 0;
            i = 0;
            while( i<samplesize )
            {
                hqrnd.hqrndnormal2(state, ref r1, ref r2);
                x[i] = r1;
                if( i+1<samplesize )
                {
                    x[i+1] = r2;
                }
                i = i+2;
            }
            calculatemv(x, samplesize, ref mean, ref means, ref stddev, ref stddevs);
            if( (double)(means)!=(double)(0) )
            {
                normsigmaerr = Math.Max(normsigmaerr, Math.Abs((mean-0)/means));
            }
            else
            {
                normerrors = true;
            }
            if( (double)(stddevs)!=(double)(0) )
            {
                normsigmaerr = Math.Max(normsigmaerr, Math.Abs((stddev-1)/stddevs));
            }
            else
            {
                normerrors = true;
            }
            normerrors = normerrors || (double)(normsigmaerr)>(double)(sigmathreshold);
            
            //
            // Test unit2
            //
            unsetstate(state);
            hqrnd.hqrndrandomize(state);
            n = 1000000;
            bins = new int[10];
            for(i=0; i<=alglib.ap.len(bins)-1; i++)
            {
                bins[i] = 0;
            }
            for(pass=0; pass<=n-1; pass++)
            {
                hqrnd.hqrndunit2(state, ref r1, ref r2);
                apserv.seterrorflag(ref unit2errors, (double)(Math.Abs(r1*r1+r2*r2-1))>(double)(100*math.machineepsilon));
                k = (int)Math.Floor((Math.Atan2(r1, r2)+Math.PI)/(2*Math.PI)*alglib.ap.len(bins));
                if( k<0 )
                {
                    k = 0;
                }
                if( k>=alglib.ap.len(bins) )
                {
                    k = alglib.ap.len(bins)-1;
                }
                bins[k] = bins[k]+1;
            }
            for(i=0; i<=alglib.ap.len(bins)-1; i++)
            {
                apserv.seterrorflag(ref unit2errors, (double)(bins[i])<(double)(0.9*n/alglib.ap.len(bins)) || (double)(bins[i])>(double)(1.1*n/alglib.ap.len(bins)));
            }
            
            //
            // Test exponential
            //
            unsetstate(state);
            hqrnd.hqrndrandomize(state);
            expsigmaerr = 0;
            lambdav = 2+5*math.randomreal();
            for(i=0; i<=samplesize-1; i++)
            {
                x[i] = hqrnd.hqrndexponential(state, lambdav);
            }
            for(i=0; i<=samplesize-1; i++)
            {
                uierrors = uierrors || (double)(x[i])<(double)(0);
            }
            calculatemv(x, samplesize, ref mean, ref means, ref stddev, ref stddevs);
            if( (double)(means)!=(double)(0) )
            {
                expsigmaerr = Math.Max(expsigmaerr, Math.Abs((mean-1.0/lambdav)/means));
            }
            else
            {
                experrors = true;
            }
            if( (double)(stddevs)!=(double)(0) )
            {
                expsigmaerr = Math.Max(expsigmaerr, Math.Abs((stddev-1.0/lambdav)/stddevs));
            }
            else
            {
                experrors = true;
            }
            experrors = experrors || (double)(expsigmaerr)>(double)(sigmathreshold);
            
            //
            //Discrete/Continuous tests
            //
            discreteerr = hqrnddiscretetest(true);
            continuouserr = hqrndcontinuoustest(true);
            
            //
            // Final report
            //
            waserrors = ((((((seederrors || urerrors) || uierrors) || normerrors) || unit2errors) || experrors) || discreteerr) || continuouserr;
            if( !silent )
            {
                System.Console.Write("RNG TEST");
                System.Console.WriteLine();
                System.Console.Write("SEED TEST:                               ");
                if( !seederrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("UNIFORM CONTINUOUS:                      ");
                if( !urerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("UNIFORM INTEGER:                         ");
                if( !uierrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("NORMAL:                                  ");
                if( !normerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("UNIT2:                                   ");
                if( !unit2errors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("EXPONENTIAL:                             ");
                if( !experrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("DISCRETE:                                ");
                if( !discreteerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("CONTINUOUS:                              ");
                if( !continuouserr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST SUMMARY: FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST SUMMARY: PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testhqrnd(bool silent)
        {
            return testhqrnd(silent);
        }


        /*************************************************************************
        Function for test HQRNDContinuous function
        *************************************************************************/
        public static bool hqrndcontinuoustest(bool silent)
        {
            bool result = new bool();
            double[] sample = new double[0];
            int[] bins = new int[0];
            double[] binbounds = new double[0];
            int nb = 0;
            int samplesize = 0;
            hqrnd.hqrndstate state = new hqrnd.hqrndstate();
            int xp = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            double sigma = 0;
            double sigmamax = 0;

            result = false;
            
            //
            // Test for sample size equal to 1
            //
            sample = new double[1];
            sample[0] = math.randomreal();
            hqrnd.hqrndrandomize(state);
            result = result || (double)(hqrnd.hqrndcontinuous(state, sample, 1))!=(double)(sample[0]);
            
            //
            // Test for larger samples
            //
            xp = 100000;
            sigmamax = 10.0;
            for(samplesize=2; samplesize<=5; samplesize++)
            {
                
                //
                // 1. Generate random sample with SampleSize points
                // 2. Generate NB=3*(SampleSize-1) bins, with bounds as prescribed by (BinBounds[I],BinBounds[I+1]).
                //    Bin bounds are generated in such a way that value can fall into any bin with same probability
                // 3. Generate many random values
                // 4. Calculate number of values which fall into each bin
                // 5. Bins[I] should have binomial distribution with mean XP/NB and 
                //    variance XP*(1/NB)*(1-1/NB)
                //
                nb = 3*(samplesize-1);
                sigma = Math.Sqrt(xp*((double)1/(double)nb)*(1-(double)1/(double)nb));
                sample = new double[samplesize];
                sample[0] = 2*math.randomreal()-1;
                for(i=0; i<=samplesize-2; i++)
                {
                    sample[i+1] = sample[i]+0.1+math.randomreal();
                }
                bins = new int[nb];
                binbounds = new double[nb+1];
                for(i=0; i<=samplesize-2; i++)
                {
                    bins[3*i+0] = 0;
                    bins[3*i+1] = 0;
                    bins[3*i+2] = 0;
                    binbounds[3*i+0] = sample[i];
                    binbounds[3*i+1] = sample[i]+(sample[i+1]-sample[i])/3;
                    binbounds[3*i+2] = sample[i]+(sample[i+1]-sample[i])*2/3;
                }
                binbounds[nb] = sample[samplesize-1];
                hqrnd.hqrndrandomize(state);
                for(i=0; i<=xp-1; i++)
                {
                    v = hqrnd.hqrndcontinuous(state, sample, samplesize);
                    for(j=0; j<=nb-1; j++)
                    {
                        if( (double)(v)>(double)(binbounds[j]) && (double)(v)<(double)(binbounds[j+1]) )
                        {
                            bins[j] = bins[j]+1;
                            break;
                        }
                    }
                }
                for(i=0; i<=nb-1; i++)
                {
                    result = result || (double)(Math.Abs(bins[i]-(double)xp/(double)nb))>(double)(sigma*sigmamax);
                }
            }
            return result;
        }


        /*************************************************************************
        Function for test HQRNDContinuous function
        *************************************************************************/
        public static bool hqrnddiscretetest(bool silent)
        {
            bool result = new bool();
            double[] sample = new double[0];
            double sigma = 0;
            double sigmathreshold = 0;
            double tsample = 0;
            double max = 0;
            double min = 0;
            int i = 0;
            int j = 0;
            int s1 = 0;
            int s2 = 0;
            int binscount = 0;
            int xp = 0;
            int[] nn = new int[0];
            hqrnd.hqrndstate state = new hqrnd.hqrndstate();

            
            //
            // We test that all values from discrete sample are generated with same probability.
            // To do this, we generate random values many times, then we calculate actual probabilities
            // and compare them with theoretical ones.
            //
            max = 100;
            min = -100;
            xp = 100000;
            sigmathreshold = 10.0;
            for(binscount=1; binscount<=5; binscount++)
            {
                sigma = Math.Sqrt(xp*((double)1/(double)binscount)*(1-(double)1/(double)binscount));
                nn = new int[binscount];
                for(i=0; i<=binscount-1; i++)
                {
                    nn[i] = 0;
                }
                sample = new double[binscount];
                sample[0] = (max-min)*math.randomreal()+min;
                for(i=1; i<=binscount-1; i++)
                {
                    sample[i] = sample[i-1]+max*math.randomreal()+0.001;
                }
                s1 = 1+math.randominteger(32000);
                s2 = 1+math.randominteger(32000);
                hqrnd.hqrndseed(s1, s2, state);
                for(i=0; i<=xp-1; i++)
                {
                    tsample = hqrnd.hqrnddiscrete(state, sample, binscount);
                    for(j=0; j<=binscount-1; j++)
                    {
                        if( (double)(tsample)==(double)(sample[j]) )
                        {
                            nn[j] = nn[j]+1;
                            break;
                        }
                    }
                }
                for(i=0; i<=binscount-1; i++)
                {
                    if( (double)(nn[i])<(double)((double)xp/(double)binscount-sigmathreshold*sigma) || (double)(nn[i])>(double)((double)xp/(double)binscount+sigmathreshold*sigma) )
                    {
                        if( !silent )
                        {
                            System.Console.Write("HQRNDDiscreteTest::ErrorReport::");
                            System.Console.WriteLine();
                            System.Console.Write("nn[");
                            System.Console.Write("{0,0:d}",i);
                            System.Console.Write("]=");
                            System.Console.Write("{0,0:d}",nn[i]);
                            System.Console.Write(";");
                            System.Console.WriteLine();
                            System.Console.Write("   xp/BinsCount=");
                            System.Console.Write("{0,0:F5}",(double)xp/(double)binscount);
                            System.Console.Write(";");
                            System.Console.WriteLine();
                            System.Console.Write("   C*sigma=");
                            System.Console.Write("{0,0:F5}",sigmathreshold*sigma);
                            System.Console.WriteLine();
                            System.Console.Write("HQRNDDiscreteTest: test is FAILED!");
                            System.Console.WriteLine();
                        }
                        result = true;
                        return result;
                    }
                }
                if( !silent )
                {
                    System.Console.Write("HQRNDDiscreteTest: test is OK.");
                    System.Console.WriteLine();
                }
            }
            result = false;
            return result;
        }


        private static void calculatemv(double[] x,
            int n,
            ref double mean,
            ref double means,
            ref double stddev,
            ref double stddevs)
        {
            int i = 0;
            double v1 = 0;
            double v2 = 0;
            double variance = 0;

            mean = 0;
            means = 0;
            stddev = 0;
            stddevs = 0;

            mean = 0;
            means = 1;
            stddev = 0;
            stddevs = 1;
            variance = 0;
            if( n<=1 )
            {
                return;
            }
            
            //
            // Mean
            //
            for(i=0; i<=n-1; i++)
            {
                mean = mean+x[i];
            }
            mean = mean/n;
            
            //
            // Variance (using corrected two-pass algorithm)
            //
            if( n!=1 )
            {
                v1 = 0;
                for(i=0; i<=n-1; i++)
                {
                    v1 = v1+math.sqr(x[i]-mean);
                }
                v2 = 0;
                for(i=0; i<=n-1; i++)
                {
                    v2 = v2+(x[i]-mean);
                }
                v2 = math.sqr(v2)/n;
                variance = (v1-v2)/(n-1);
                if( (double)(variance)<(double)(0) )
                {
                    variance = 0;
                }
                stddev = Math.Sqrt(variance);
            }
            
            //
            // Errors
            //
            means = stddev/Math.Sqrt(n);
            stddevs = stddev*Math.Sqrt(2)/Math.Sqrt(n-1);
        }


        /*************************************************************************
        Unsets HQRNDState structure
        *************************************************************************/
        private static void unsetstate(hqrnd.hqrndstate state)
        {
            state.s1 = 0;
            state.s2 = 0;
            state.magicv = 0;
        }


    }
    public class testtsortunit
    {
        /*************************************************************************
        Testing tag sort
        *************************************************************************/
        public static bool testtsort(bool silent)
        {
            bool result = new bool();
            bool waserrors = new bool();
            int n = 0;
            int i = 0;
            int m = 0;
            int offs = 0;
            int pass = 0;
            int passcount = 0;
            int maxn = 0;
            double[] a = new double[0];
            double[] a0 = new double[0];
            double[] a1 = new double[0];
            double[] a2 = new double[0];
            double[] a3 = new double[0];
            int[] i1 = new int[0];
            int[] i2 = new int[0];
            int[] i3 = new int[0];
            int[] a4 = new int[0];
            int[] pa4 = new int[0];
            double[] ar = new double[0];
            double[] ar2 = new double[0];
            int[] ai = new int[0];
            int[] p1 = new int[0];
            int[] p2 = new int[0];
            double[] bufr1 = new double[0];
            double[] bufr2 = new double[0];
            int[] bufi1 = new int[0];
            bool distinctvals = new bool();

            waserrors = false;
            maxn = 100;
            passcount = 10;
            
            //
            // Test tagsort
            //
            for(n=1; n<=maxn; n++)
            {
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // Pprobably distinct sort:
                    // * generate array of integer random numbers.
                    //   Because of birthday paradox, random numbers have to be VERY large
                    //   in order to avoid situation when we have distinct values.
                    // * sort A0 using TagSort and test sort results
                    // * now we can use A0 as reference point and test other functions
                    //
                    unset1di(ref p1);
                    unset1di(ref p2);
                    a = new double[n];
                    a0 = new double[n];
                    a1 = new double[n];
                    a2 = new double[n];
                    a3 = new double[n];
                    a4 = new int[n];
                    ar = new double[n];
                    ar2 = new double[n];
                    ai = new int[n];
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = math.randominteger(100000000);
                        a0[i] = a[i];
                        a1[i] = a[i];
                        a2[i] = a[i];
                        a3[i] = a[i];
                        a4[i] = (int)Math.Round(a[i]);
                        ar[i] = i;
                        ar2[i] = i;
                        ai[i] = i;
                    }
                    tsort.tagsort(ref a0, n, ref p1, ref p2);
                    testsortresults(a0, p1, p2, a, n, ref waserrors);
                    distinctvals = true;
                    for(i=1; i<=n-1; i++)
                    {
                        distinctvals = distinctvals && (double)(a0[i])!=(double)(a0[i-1]);
                    }
                    if( distinctvals )
                    {
                        tsort.tagsortfasti(ref a1, ref ai, ref bufr1, ref bufi1, n);
                        for(i=0; i<=n-1; i++)
                        {
                            waserrors = (waserrors || (double)(a1[i])!=(double)(a0[i])) || ai[i]!=p1[i];
                        }
                        tsort.tagsortfastr(ref a2, ref ar, ref bufr1, ref bufr2, n);
                        for(i=0; i<=n-1; i++)
                        {
                            waserrors = (waserrors || (double)(a2[i])!=(double)(a0[i])) || (double)(ar[i])!=(double)(p1[i]);
                        }
                        tsort.tagsortfast(ref a3, ref bufr1, n);
                        for(i=0; i<=n-1; i++)
                        {
                            waserrors = waserrors || (double)(a3[i])!=(double)(a0[i]);
                        }
                        tsort.tagsortmiddleir(ref a4, ref ar2, 0, n);
                        for(i=0; i<=n-1; i++)
                        {
                            waserrors = (waserrors || (double)(a4[i])!=(double)(a0[i])) || (double)(ar2[i])!=(double)(p1[i]);
                        }
                    }
                    
                    //
                    // Non-distinct sort.
                    // We test that keys are correctly reordered, but do NOT test order of values.
                    //
                    unset1di(ref p1);
                    unset1di(ref p2);
                    a = new double[n];
                    a0 = new double[n];
                    a1 = new double[n];
                    a2 = new double[n];
                    a3 = new double[n];
                    a4 = new int[n];
                    ar = new double[n];
                    ar2 = new double[n];
                    ai = new int[n];
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = (n-i)/2;
                        a0[i] = a[i];
                        a1[i] = a[i];
                        a2[i] = a[i];
                        a3[i] = a[i];
                        a4[i] = (int)Math.Round(a[i]);
                        ar[i] = i;
                        ar2[i] = i;
                        ai[i] = i;
                    }
                    tsort.tagsort(ref a0, n, ref p1, ref p2);
                    testsortresults(a0, p1, p2, a, n, ref waserrors);
                    tsort.tagsortfasti(ref a1, ref ai, ref bufr1, ref bufi1, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a1[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortfastr(ref a2, ref ar, ref bufr1, ref bufr2, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a2[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortfast(ref a3, ref bufr1, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a3[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortmiddleir(ref a4, ref ar2, 0, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a4[i])!=(double)(a0[i]);
                    }
                    
                    //
                    // 'All same' sort
                    // We test that keys are correctly reordered, but do NOT test order of values.
                    //
                    unset1di(ref p1);
                    unset1di(ref p2);
                    a = new double[n];
                    a0 = new double[n];
                    a1 = new double[n];
                    a2 = new double[n];
                    a3 = new double[n];
                    a4 = new int[n];
                    ar = new double[n];
                    ar2 = new double[n];
                    ai = new int[n];
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = 0;
                        a0[i] = a[i];
                        a1[i] = a[i];
                        a2[i] = a[i];
                        a3[i] = a[i];
                        a4[i] = (int)Math.Round(a[i]);
                        ar[i] = i;
                        ar2[i] = i;
                        ai[i] = i;
                    }
                    tsort.tagsort(ref a0, n, ref p1, ref p2);
                    testsortresults(a0, p1, p2, a, n, ref waserrors);
                    tsort.tagsortfasti(ref a1, ref ai, ref bufr1, ref bufi1, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a1[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortfastr(ref a2, ref ar, ref bufr1, ref bufr2, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a2[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortfast(ref a3, ref bufr1, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a3[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortmiddleir(ref a4, ref ar2, 0, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a4[i])!=(double)(a0[i]);
                    }
                    
                    //
                    // 0-1 sort
                    // We test that keys are correctly reordered, but do NOT test order of values.
                    //
                    unset1di(ref p1);
                    unset1di(ref p2);
                    a = new double[n];
                    a0 = new double[n];
                    a1 = new double[n];
                    a2 = new double[n];
                    a3 = new double[n];
                    a4 = new int[n];
                    ar = new double[n];
                    ar2 = new double[n];
                    ai = new int[n];
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = math.randominteger(2);
                        a0[i] = a[i];
                        a1[i] = a[i];
                        a2[i] = a[i];
                        a3[i] = a[i];
                        a4[i] = (int)Math.Round(a[i]);
                        ar[i] = i;
                        ar2[i] = i;
                        ai[i] = i;
                    }
                    tsort.tagsort(ref a0, n, ref p1, ref p2);
                    testsortresults(a0, p1, p2, a, n, ref waserrors);
                    tsort.tagsortfasti(ref a1, ref ai, ref bufr1, ref bufi1, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a1[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortfastr(ref a2, ref ar, ref bufr1, ref bufr2, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a2[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortfast(ref a3, ref bufr1, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a3[i])!=(double)(a0[i]);
                    }
                    tsort.tagsortmiddleir(ref a4, ref ar2, 0, n);
                    for(i=0; i<=n-1; i++)
                    {
                        waserrors = waserrors || (double)(a4[i])!=(double)(a0[i]);
                    }
                    
                    //
                    // Special test for TagSortMiddleIR: sorting in the middle gives same results
                    // as sorting in the beginning of the array
                    //
                    m = 3*n;
                    offs = math.randominteger(n);
                    i1 = new int[m];
                    i2 = new int[m];
                    i3 = new int[m];
                    ar = new double[m];
                    ar2 = new double[m];
                    for(i=0; i<=m-1; i++)
                    {
                        i1[i] = math.randominteger(100000000);
                        i2[i] = i1[i];
                        i3[i] = i1[i];
                        ar[i] = i;
                        ar2[i] = i;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        i1[i] = i1[offs+i];
                        ar[i] = ar[offs+i];
                    }
                    tsort.tagsortmiddleir(ref i1, ref ar, 0, n);
                    for(i=1; i<=n-1; i++)
                    {
                        distinctvals = distinctvals && i1[i]!=i1[i-1];
                    }
                    if( distinctvals )
                    {
                        tsort.tagsortmiddleir(ref i2, ref ar2, offs, n);
                        for(i=0; i<=n-1; i++)
                        {
                            waserrors = (waserrors || i2[offs+i]!=i1[i]) || (double)(ar2[offs+i])!=(double)(ar[i]);
                        }
                    }
                }
            }
            
            //
            // report
            //
            if( !silent )
            {
                System.Console.Write("TESTING TAGSORT");
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testtsort(bool silent)
        {
            return testtsort(silent);
        }


        /*************************************************************************
        Unsets 1D array.
        *************************************************************************/
        private static void unset1di(ref int[] a)
        {
            a = new int[0+1];
            a[0] = math.randominteger(3)-1;
        }


        private static void testsortresults(double[] asorted,
            int[] p1,
            int[] p2,
            double[] aoriginal,
            int n,
            ref bool waserrors)
        {
            int i = 0;
            double[] a2 = new double[0];
            double t = 0;
            int[] f = new int[0];

            a2 = new double[n-1+1];
            f = new int[n-1+1];
            
            //
            // is set ordered?
            //
            for(i=0; i<=n-2; i++)
            {
                waserrors = waserrors || (double)(asorted[i])>(double)(asorted[i+1]);
            }
            
            //
            // P1 correctness
            //
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors || (double)(asorted[i])!=(double)(aoriginal[p1[i]]);
            }
            for(i=0; i<=n-1; i++)
            {
                f[i] = 0;
            }
            for(i=0; i<=n-1; i++)
            {
                f[p1[i]] = f[p1[i]]+1;
            }
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors || f[i]!=1;
            }
            
            //
            // P2 correctness
            //
            for(i=0; i<=n-1; i++)
            {
                a2[i] = aoriginal[i];
            }
            for(i=0; i<=n-1; i++)
            {
                if( p2[i]!=i )
                {
                    t = a2[i];
                    a2[i] = a2[p2[i]];
                    a2[p2[i]] = t;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                waserrors = waserrors || (double)(asorted[i])!=(double)(a2[i]);
            }
        }


    }
    public class testnearestneighborunit
    {
        /*************************************************************************
        Testing Nearest Neighbor Search
        *************************************************************************/
        public static bool testnearestneighbor(bool silent)
        {
            bool result = new bool();
            double[,] xy = new double[0,0];
            int i = 0;
            int j = 0;
            double v = 0;
            int normtype = 0;
            int nx = 0;
            int ny = 0;
            int n = 0;
            int smalln = 0;
            int largen = 0;
            int passcount = 0;
            int pass = 0;
            bool waserrors = new bool();
            bool kdterrors = new bool();

            kdterrors = false;
            passcount = 2;
            smalln = 256;
            largen = 2048;
            ny = 3;
            
            //
            //
            //
            testkdtreeserialization(ref kdterrors);
            for(pass=1; pass<=passcount; pass++)
            {
                for(normtype=0; normtype<=2; normtype++)
                {
                    for(nx=1; nx<=3; nx++)
                    {
                        
                        //
                        // Test in hypercube
                        //
                        xy = new double[largen, nx+ny];
                        for(i=0; i<=largen-1; i++)
                        {
                            for(j=0; j<=nx+ny-1; j++)
                            {
                                xy[i,j] = 10*math.randomreal()-5;
                            }
                        }
                        for(n=1; n<=10; n++)
                        {
                            testkdtuniform(xy, n, nx, math.randominteger(ny+1), normtype, ref kdterrors);
                        }
                        testkdtuniform(xy, largen, nx, math.randominteger(ny+1), normtype, ref kdterrors);
                        
                        //
                        // Test clustered (2*N points, pairs of equal points)
                        //
                        xy = new double[2*smalln, nx+ny];
                        for(i=0; i<=smalln-1; i++)
                        {
                            for(j=0; j<=nx+ny-1; j++)
                            {
                                xy[2*i+0,j] = 10*math.randomreal()-5;
                                xy[2*i+1,j] = xy[2*i+0,j];
                            }
                        }
                        testkdtuniform(xy, 2*smalln, nx, math.randominteger(ny+1), normtype, ref kdterrors);
                        
                        //
                        // Test degenerate case: all points are same except for one
                        //
                        xy = new double[smalln, nx+ny];
                        v = math.randomreal();
                        for(i=0; i<=smalln-2; i++)
                        {
                            for(j=0; j<=nx+ny-1; j++)
                            {
                                xy[i,j] = v;
                            }
                        }
                        for(j=0; j<=nx+ny-1; j++)
                        {
                            xy[smalln-1,j] = 10*math.randomreal()-5;
                        }
                        testkdtuniform(xy, smalln, nx, math.randominteger(ny+1), normtype, ref kdterrors);
                    }
                }
            }
            kdterrors = kdterrors || testspecialcases();
            
            //
            // report
            //
            waserrors = kdterrors;
            if( !silent )
            {
                System.Console.Write("TESTING NEAREST NEIGHBOR SEARCH");
                System.Console.WriteLine();
                System.Console.Write("* KD TREES:                              ");
                if( !kdterrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testnearestneighbor(bool silent)
        {
            return testnearestneighbor(silent);
        }


        /*************************************************************************
        Compare results from different queries:
        * X     just X-values
        * XY    X-values and Y-values
        * XT    X-values and tag values
        *************************************************************************/
        private static bool kdtresultsdifferent(double[,] refxy,
            int ntotal,
            double[,] qx,
            double[,] qxy,
            int[] qt,
            int n,
            int nx,
            int ny)
        {
            bool result = new bool();
            int i = 0;
            int j = 0;

            result = false;
            for(i=0; i<=n-1; i++)
            {
                if( qt[i]<0 || qt[i]>=ntotal )
                {
                    result = true;
                    return result;
                }
                for(j=0; j<=nx-1; j++)
                {
                    result = result || (double)(qx[i,j])!=(double)(refxy[qt[i],j]);
                    result = result || (double)(qxy[i,j])!=(double)(refxy[qt[i],j]);
                }
                for(j=0; j<=ny-1; j++)
                {
                    result = result || (double)(qxy[i,nx+j])!=(double)(refxy[qt[i],nx+j]);
                }
            }
            return result;
        }


        /*************************************************************************
        Returns norm
        *************************************************************************/
        private static double vnorm(double[] x,
            int n,
            int normtype)
        {
            double result = 0;
            int i = 0;

            result = math.randomreal();
            if( normtype==0 )
            {
                result = 0;
                for(i=0; i<=n-1; i++)
                {
                    result = Math.Max(result, Math.Abs(x[i]));
                }
                return result;
            }
            if( normtype==1 )
            {
                result = 0;
                for(i=0; i<=n-1; i++)
                {
                    result = result+Math.Abs(x[i]);
                }
                return result;
            }
            if( normtype==2 )
            {
                result = 0;
                for(i=0; i<=n-1; i++)
                {
                    result = result+math.sqr(x[i]);
                }
                result = Math.Sqrt(result);
                return result;
            }
            return result;
        }


        /*************************************************************************
        Testing Nearest Neighbor Search on uniformly distributed hypercube

        NormType: 0, 1, 2
        D: space dimension
        N: points count
        *************************************************************************/
        private static void testkdtuniform(double[,] xy,
            int n,
            int nx,
            int ny,
            int normtype,
            ref bool kdterrors)
        {
            double errtol = 0;
            int[] tags = new int[0];
            double[] ptx = new double[0];
            double[] tmpx = new double[0];
            bool[] tmpb = new bool[0];
            nearestneighbor.kdtree treex = new nearestneighbor.kdtree();
            nearestneighbor.kdtree treexy = new nearestneighbor.kdtree();
            nearestneighbor.kdtree treext = new nearestneighbor.kdtree();
            double[,] qx = new double[0,0];
            double[,] qxy = new double[0,0];
            int[] qtags = new int[0];
            double[] qr = new double[0];
            int kx = 0;
            int kxy = 0;
            int kt = 0;
            double eps = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int task = 0;
            bool isequal = new bool();
            double r = 0;
            int q = 0;
            int qcount = 0;
            int i_ = 0;

            qcount = 10;
            
            //
            // Tol - roundoff error tolerance (for '>=' comparisons)
            //
            errtol = 100000*math.machineepsilon;
            
            //
            // fill tags
            //
            tags = new int[n];
            for(i=0; i<=n-1; i++)
            {
                tags[i] = i;
            }
            
            //
            // build trees
            //
            nearestneighbor.kdtreebuild(xy, n, nx, 0, normtype, treex);
            nearestneighbor.kdtreebuild(xy, n, nx, ny, normtype, treexy);
            nearestneighbor.kdtreebuildtagged(xy, tags, n, nx, 0, normtype, treext);
            
            //
            // allocate arrays
            //
            tmpx = new double[nx];
            tmpb = new bool[n];
            qx = new double[n, nx];
            qxy = new double[n, nx+ny];
            qtags = new int[n];
            qr = new double[n];
            ptx = new double[nx];
            
            //
            // test general K-NN queries (with self-matches):
            // * compare results from different trees (must be equal) and
            //   check that correct (value,tag) pairs are returned
            // * test results from XT tree - let R be radius of query result.
            //   then all points not in result must be not closer than R.
            //
            for(q=1; q<=qcount; q++)
            {
                
                //
                // Select K: 1..N
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    k = 1+math.randominteger(n);
                }
                else
                {
                    k = 1;
                }
                
                //
                // Select point (either one of the points, or random)
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    i = math.randominteger(n);
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        ptx[i_] = xy[i,i_];
                    }
                }
                else
                {
                    for(i=0; i<=nx-1; i++)
                    {
                        ptx[i] = 2*math.randomreal()-1;
                    }
                }
                
                //
                // Test:
                // * consistency of results from different queries
                // * points in query are IN the R-sphere (or at the boundary),
                //   and points not in query are outside of the R-sphere (or at the boundary)
                // * distances are correct and are ordered
                //
                kx = nearestneighbor.kdtreequeryknn(treex, ptx, k, true);
                kxy = nearestneighbor.kdtreequeryknn(treexy, ptx, k, true);
                kt = nearestneighbor.kdtreequeryknn(treext, ptx, k, true);
                if( (kx!=k || kxy!=k) || kt!=k )
                {
                    kdterrors = true;
                    return;
                }
                nearestneighbor.kdtreequeryresultsxi(treex, ref qx);
                nearestneighbor.kdtreequeryresultsxyi(treexy, ref qxy);
                nearestneighbor.kdtreequeryresultstagsi(treext, ref qtags);
                nearestneighbor.kdtreequeryresultsdistancesi(treext, ref qr);
                kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                nearestneighbor.kdtreequeryresultsx(treex, ref qx);
                nearestneighbor.kdtreequeryresultsxy(treexy, ref qxy);
                nearestneighbor.kdtreequeryresultstags(treext, ref qtags);
                nearestneighbor.kdtreequeryresultsdistances(treext, ref qr);
                kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                for(i=0; i<=n-1; i++)
                {
                    tmpb[i] = true;
                }
                r = 0;
                for(i=0; i<=k-1; i++)
                {
                    tmpb[qtags[i]] = false;
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = ptx[i_];
                    }
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = tmpx[i_] - qx[i,i_];
                    }
                    r = Math.Max(r, vnorm(tmpx, nx, normtype));
                }
                for(i=0; i<=n-1; i++)
                {
                    if( tmpb[i] )
                    {
                        for(i_=0; i_<=nx-1;i_++)
                        {
                            tmpx[i_] = ptx[i_];
                        }
                        for(i_=0; i_<=nx-1;i_++)
                        {
                            tmpx[i_] = tmpx[i_] - xy[i,i_];
                        }
                        kdterrors = kdterrors || (double)(vnorm(tmpx, nx, normtype))<(double)(r*(1-errtol));
                    }
                }
                for(i=0; i<=k-2; i++)
                {
                    kdterrors = kdterrors || (double)(qr[i])>(double)(qr[i+1]);
                }
                for(i=0; i<=k-1; i++)
                {
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = ptx[i_];
                    }
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = tmpx[i_] - xy[qtags[i],i_];
                    }
                    kdterrors = kdterrors || (double)(Math.Abs(vnorm(tmpx, nx, normtype)-qr[i]))>(double)(errtol);
                }
                
                //
                // Test reallocation properties: buffered functions must automatically
                // resize array which is too small, but leave unchanged array which is
                // too large.
                //
                if( n>=2 )
                {
                    
                    //
                    // First step: array is too small, two elements are required
                    //
                    k = 2;
                    kx = nearestneighbor.kdtreequeryknn(treex, ptx, k, true);
                    kxy = nearestneighbor.kdtreequeryknn(treexy, ptx, k, true);
                    kt = nearestneighbor.kdtreequeryknn(treext, ptx, k, true);
                    if( (kx!=k || kxy!=k) || kt!=k )
                    {
                        kdterrors = true;
                        return;
                    }
                    qx = new double[1, 1];
                    qxy = new double[1, 1];
                    qtags = new int[1];
                    qr = new double[1];
                    nearestneighbor.kdtreequeryresultsx(treex, ref qx);
                    nearestneighbor.kdtreequeryresultsxy(treexy, ref qxy);
                    nearestneighbor.kdtreequeryresultstags(treext, ref qtags);
                    nearestneighbor.kdtreequeryresultsdistances(treext, ref qr);
                    kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                    
                    //
                    // Second step: array is one row larger than needed, so only first
                    // row is overwritten. Test it.
                    //
                    k = 1;
                    kx = nearestneighbor.kdtreequeryknn(treex, ptx, k, true);
                    kxy = nearestneighbor.kdtreequeryknn(treexy, ptx, k, true);
                    kt = nearestneighbor.kdtreequeryknn(treext, ptx, k, true);
                    if( (kx!=k || kxy!=k) || kt!=k )
                    {
                        kdterrors = true;
                        return;
                    }
                    for(i=0; i<=nx-1; i++)
                    {
                        qx[1,i] = Double.NaN;
                    }
                    for(i=0; i<=nx+ny-1; i++)
                    {
                        qxy[1,i] = Double.NaN;
                    }
                    qtags[1] = 999;
                    qr[1] = Double.NaN;
                    nearestneighbor.kdtreequeryresultsx(treex, ref qx);
                    nearestneighbor.kdtreequeryresultsxy(treexy, ref qxy);
                    nearestneighbor.kdtreequeryresultstags(treext, ref qtags);
                    nearestneighbor.kdtreequeryresultsdistances(treext, ref qr);
                    kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                    for(i=0; i<=nx-1; i++)
                    {
                        kdterrors = kdterrors || !Double.IsNaN(qx[1,i]);
                    }
                    for(i=0; i<=nx+ny-1; i++)
                    {
                        kdterrors = kdterrors || !Double.IsNaN(qxy[1,i]);
                    }
                    kdterrors = kdterrors || !(qtags[1]==999);
                    kdterrors = kdterrors || !Double.IsNaN(qr[1]);
                }
                
                //
                // Test reallocation properties: 'interactive' functions must allocate
                // new array on each call.
                //
                if( n>=2 )
                {
                    
                    //
                    // On input array is either too small or too large
                    //
                    for(k=1; k<=2; k++)
                    {
                        alglib.ap.assert(k==1 || k==2, "KNN: internal error (unexpected K)!");
                        kx = nearestneighbor.kdtreequeryknn(treex, ptx, k, true);
                        kxy = nearestneighbor.kdtreequeryknn(treexy, ptx, k, true);
                        kt = nearestneighbor.kdtreequeryknn(treext, ptx, k, true);
                        if( (kx!=k || kxy!=k) || kt!=k )
                        {
                            kdterrors = true;
                            return;
                        }
                        qx = new double[3-k, 3-k];
                        qxy = new double[3-k, 3-k];
                        qtags = new int[3-k];
                        qr = new double[3-k];
                        nearestneighbor.kdtreequeryresultsxi(treex, ref qx);
                        nearestneighbor.kdtreequeryresultsxyi(treexy, ref qxy);
                        nearestneighbor.kdtreequeryresultstagsi(treext, ref qtags);
                        nearestneighbor.kdtreequeryresultsdistancesi(treext, ref qr);
                        kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                        kdterrors = (kdterrors || alglib.ap.rows(qx)!=k) || alglib.ap.cols(qx)!=nx;
                        kdterrors = (kdterrors || alglib.ap.rows(qxy)!=k) || alglib.ap.cols(qxy)!=nx+ny;
                        kdterrors = kdterrors || alglib.ap.len(qtags)!=k;
                        kdterrors = kdterrors || alglib.ap.len(qr)!=k;
                    }
                }
            }
            
            //
            // test general approximate K-NN queries (with self-matches):
            // * compare results from different trees (must be equal) and
            //   check that correct (value,tag) pairs are returned
            // * test results from XT tree - let R be radius of query result.
            //   then all points not in result must be not closer than R/(1+Eps).
            //
            for(q=1; q<=qcount; q++)
            {
                
                //
                // Select K: 1..N
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    k = 1+math.randominteger(n);
                }
                else
                {
                    k = 1;
                }
                
                //
                // Select Eps
                //
                eps = 0.5+math.randomreal();
                
                //
                // Select point (either one of the points, or random)
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    i = math.randominteger(n);
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        ptx[i_] = xy[i,i_];
                    }
                }
                else
                {
                    for(i=0; i<=nx-1; i++)
                    {
                        ptx[i] = 2*math.randomreal()-1;
                    }
                }
                
                //
                // Test:
                // * consistency of results from different queries
                // * points in query are IN the R-sphere (or at the boundary),
                //   and points not in query are outside of the R-sphere (or at the boundary)
                // * distances are correct and are ordered
                //
                kx = nearestneighbor.kdtreequeryaknn(treex, ptx, k, true, eps);
                kxy = nearestneighbor.kdtreequeryaknn(treexy, ptx, k, true, eps);
                kt = nearestneighbor.kdtreequeryaknn(treext, ptx, k, true, eps);
                if( (kx!=k || kxy!=k) || kt!=k )
                {
                    kdterrors = true;
                    return;
                }
                nearestneighbor.kdtreequeryresultsxi(treex, ref qx);
                nearestneighbor.kdtreequeryresultsxyi(treexy, ref qxy);
                nearestneighbor.kdtreequeryresultstagsi(treext, ref qtags);
                nearestneighbor.kdtreequeryresultsdistancesi(treext, ref qr);
                kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                nearestneighbor.kdtreequeryresultsx(treex, ref qx);
                nearestneighbor.kdtreequeryresultsxy(treexy, ref qxy);
                nearestneighbor.kdtreequeryresultstags(treext, ref qtags);
                nearestneighbor.kdtreequeryresultsdistances(treext, ref qr);
                kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, k, nx, ny);
                for(i=0; i<=n-1; i++)
                {
                    tmpb[i] = true;
                }
                r = 0;
                for(i=0; i<=k-1; i++)
                {
                    tmpb[qtags[i]] = false;
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = ptx[i_];
                    }
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = tmpx[i_] - qx[i,i_];
                    }
                    r = Math.Max(r, vnorm(tmpx, nx, normtype));
                }
                for(i=0; i<=n-1; i++)
                {
                    if( tmpb[i] )
                    {
                        for(i_=0; i_<=nx-1;i_++)
                        {
                            tmpx[i_] = ptx[i_];
                        }
                        for(i_=0; i_<=nx-1;i_++)
                        {
                            tmpx[i_] = tmpx[i_] - xy[i,i_];
                        }
                        kdterrors = kdterrors || (double)(vnorm(tmpx, nx, normtype))<(double)(r*(1-errtol)/(1+eps));
                    }
                }
                for(i=0; i<=k-2; i++)
                {
                    kdterrors = kdterrors || (double)(qr[i])>(double)(qr[i+1]);
                }
                for(i=0; i<=k-1; i++)
                {
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = ptx[i_];
                    }
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = tmpx[i_] - xy[qtags[i],i_];
                    }
                    kdterrors = kdterrors || (double)(Math.Abs(vnorm(tmpx, nx, normtype)-qr[i]))>(double)(errtol);
                }
            }
            
            //
            // test general R-NN queries  (with self-matches):
            // * compare results from different trees (must be equal) and
            //   check that correct (value,tag) pairs are returned
            // * test results from XT tree - let R be radius of query result.
            //   then all points not in result must be not closer than R.
            //
            for(q=1; q<=qcount; q++)
            {
                
                //
                // Select R
                //
                if( (double)(math.randomreal())>(double)(0.3) )
                {
                    r = Math.Max(math.randomreal(), math.machineepsilon);
                }
                else
                {
                    r = math.machineepsilon;
                }
                
                //
                // Select point (either one of the points, or random)
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    i = math.randominteger(n);
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        ptx[i_] = xy[i,i_];
                    }
                }
                else
                {
                    for(i=0; i<=nx-1; i++)
                    {
                        ptx[i] = 2*math.randomreal()-1;
                    }
                }
                
                //
                // Test:
                // * consistency of results from different queries
                // * points in query are IN the R-sphere (or at the boundary),
                //   and points not in query are outside of the R-sphere (or at the boundary)
                // * distances are correct and are ordered
                //
                kx = nearestneighbor.kdtreequeryrnn(treex, ptx, r, true);
                kxy = nearestneighbor.kdtreequeryrnn(treexy, ptx, r, true);
                kt = nearestneighbor.kdtreequeryrnn(treext, ptx, r, true);
                if( kxy!=kx || kt!=kx )
                {
                    kdterrors = true;
                    return;
                }
                nearestneighbor.kdtreequeryresultsxi(treex, ref qx);
                nearestneighbor.kdtreequeryresultsxyi(treexy, ref qxy);
                nearestneighbor.kdtreequeryresultstagsi(treext, ref qtags);
                nearestneighbor.kdtreequeryresultsdistancesi(treext, ref qr);
                kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, kx, nx, ny);
                nearestneighbor.kdtreequeryresultsx(treex, ref qx);
                nearestneighbor.kdtreequeryresultsxy(treexy, ref qxy);
                nearestneighbor.kdtreequeryresultstags(treext, ref qtags);
                nearestneighbor.kdtreequeryresultsdistances(treext, ref qr);
                kdterrors = kdterrors || kdtresultsdifferent(xy, n, qx, qxy, qtags, kx, nx, ny);
                for(i=0; i<=n-1; i++)
                {
                    tmpb[i] = true;
                }
                for(i=0; i<=kx-1; i++)
                {
                    tmpb[qtags[i]] = false;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = ptx[i_];
                    }
                    for(i_=0; i_<=nx-1;i_++)
                    {
                        tmpx[i_] = tmpx[i_] - xy[i,i_];
                    }
                    if( tmpb[i] )
                    {
                        kdterrors = kdterrors || (double)(vnorm(tmpx, nx, normtype))<(double)(r*(1-errtol));
                    }
                    else
                    {
                        kdterrors = kdterrors || (double)(vnorm(tmpx, nx, normtype))>(double)(r*(1+errtol));
                    }
                }
                for(i=0; i<=kx-2; i++)
                {
                    kdterrors = kdterrors || (double)(qr[i])>(double)(qr[i+1]);
                }
            }
            
            //
            // Test self-matching:
            // * self-match - nearest neighbor of each point in XY is the point itself
            // * no self-match - nearest neighbor is NOT the point itself
            //
            if( n>1 )
            {
                
                //
                // test for N=1 have non-general form, but it is not really needed
                //
                for(task=0; task<=1; task++)
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(i_=0; i_<=nx-1;i_++)
                        {
                            ptx[i_] = xy[i,i_];
                        }
                        kx = nearestneighbor.kdtreequeryknn(treex, ptx, 1, task==0);
                        nearestneighbor.kdtreequeryresultsxi(treex, ref qx);
                        if( kx!=1 )
                        {
                            kdterrors = true;
                            return;
                        }
                        isequal = true;
                        for(j=0; j<=nx-1; j++)
                        {
                            isequal = isequal && (double)(qx[0,j])==(double)(ptx[j]);
                        }
                        if( task==0 )
                        {
                            kdterrors = kdterrors || !isequal;
                        }
                        else
                        {
                            kdterrors = kdterrors || isequal;
                        }
                    }
                }
            }
        }


        /*************************************************************************
        Testing serialization of KD trees

        This function sets Err to True on errors, but leaves it unchanged on success
        *************************************************************************/
        private static void testkdtreeserialization(ref bool err)
        {
            int n = 0;
            int nx = 0;
            int ny = 0;
            int normtype = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int q = 0;
            double[,] xy = new double[0,0];
            double[] x = new double[0];
            int[] tags = new int[0];
            int[] qsizes = new int[0];
            double threshold = 0;
            nearestneighbor.kdtree tree0 = new nearestneighbor.kdtree();
            nearestneighbor.kdtree tree1 = new nearestneighbor.kdtree();
            int k0 = 0;
            int k1 = 0;
            double[,] xy0 = new double[0,0];
            double[,] xy1 = new double[0,0];
            int[] tags0 = new int[0];
            int[] tags1 = new int[0];
            int i_ = 0;

            threshold = 100*math.machineepsilon;
            
            //
            // different N, NX, NY, NormType
            //
            n = 1;
            while( n<=51 )
            {
                
                //
                // prepare array with query sizes
                //
                qsizes = new int[4];
                qsizes[0] = 1;
                qsizes[1] = Math.Min(2, n);
                qsizes[2] = Math.Min(4, n);
                qsizes[3] = n;
                
                //
                // different NX/NY/NormType
                //
                for(nx=1; nx<=2; nx++)
                {
                    for(ny=0; ny<=2; ny++)
                    {
                        for(normtype=0; normtype<=2; normtype++)
                        {
                            
                            //
                            // Prepare data
                            //
                            xy = new double[n, nx+ny];
                            tags = new int[n];
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=nx+ny-1; j++)
                                {
                                    xy[i,j] = math.randomreal();
                                }
                                tags[i] = math.randominteger(100);
                            }
                            
                            //
                            // Build tree, pass it through serializer
                            //
                            nearestneighbor.kdtreebuildtagged(xy, tags, n, nx, ny, normtype, tree0);
                            {
                                //
                                // This code passes data structure through serializers
                                // (serializes it to string and loads back)
                                //
                                serializer _local_serializer;
                                string _local_str;
                                
                                _local_serializer = new serializer();
                                _local_serializer.alloc_start();
                                nearestneighbor.kdtreealloc(_local_serializer, tree0);
                                _local_serializer.sstart_str();
                                nearestneighbor.kdtreeserialize(_local_serializer, tree0);
                                _local_serializer.stop();
                                _local_str = _local_serializer.get_string();
                                
                                _local_serializer = new serializer();
                                _local_serializer.ustart_str(_local_str);
                                nearestneighbor.kdtreeunserialize(_local_serializer, tree1);
                                _local_serializer.stop();
                            }
                            
                            //
                            // For each point of XY we make queries with different sizes
                            //
                            x = new double[nx];
                            for(k=0; k<=n-1; k++)
                            {
                                for(q=0; q<=alglib.ap.len(qsizes)-1; q++)
                                {
                                    for(i_=0; i_<=nx-1;i_++)
                                    {
                                        x[i_] = xy[k,i_];
                                    }
                                    k0 = nearestneighbor.kdtreequeryknn(tree0, x, qsizes[q], true);
                                    k1 = nearestneighbor.kdtreequeryknn(tree1, x, qsizes[q], true);
                                    if( k0!=k1 )
                                    {
                                        err = true;
                                        return;
                                    }
                                    nearestneighbor.kdtreequeryresultsxy(tree0, ref xy0);
                                    nearestneighbor.kdtreequeryresultsxy(tree1, ref xy1);
                                    for(i=0; i<=k0-1; i++)
                                    {
                                        for(j=0; j<=nx+ny-1; j++)
                                        {
                                            if( (double)(Math.Abs(xy0[i,j]-xy1[i,j]))>(double)(threshold) )
                                            {
                                                err = true;
                                                return;
                                            }
                                        }
                                    }
                                    nearestneighbor.kdtreequeryresultstags(tree0, ref tags0);
                                    nearestneighbor.kdtreequeryresultstags(tree1, ref tags1);
                                    for(i=0; i<=k0-1; i++)
                                    {
                                        if( tags0[i]!=tags1[i] )
                                        {
                                            err = true;
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
                //
                // Next N
                //
                n = n+25;
            }
        }


        /*************************************************************************
        This function tests different special cases:
        * Kd-tree for a zero number of points
        * Kd-tree for array with a lot of duplicates (early versions of ALGLIB
          raised stack overflow on such datasets)

        It returns True on errors, False on success.
        *************************************************************************/
        private static bool testspecialcases()
        {
            bool result = new bool();
            nearestneighbor.kdtree kdt = new nearestneighbor.kdtree();
            double[,] xy = new double[0,0];
            int[] tags = new int[0];
            double[] x = new double[0];
            int n = 0;
            int nk = 0;
            int nx = 0;
            int ny = 0;
            int normtype = 0;
            int i = 0;
            int j = 0;
            double v = 0;

            result = false;
            for(nx=1; nx<=3; nx++)
            {
                for(ny=0; ny<=3; ny++)
                {
                    for(normtype=0; normtype<=2; normtype++)
                    {
                        
                        //
                        // Build tree
                        //
                        if( (double)(math.randomreal())>(double)(0.5) )
                        {
                            nearestneighbor.kdtreebuildtagged(xy, tags, 0, nx, ny, normtype, kdt);
                        }
                        else
                        {
                            nearestneighbor.kdtreebuild(xy, 0, nx, ny, normtype, kdt);
                        }
                        
                        //
                        // Test different queries
                        //
                        x = new double[nx];
                        for(i=0; i<=nx-1; i++)
                        {
                            x[i] = math.randomreal();
                        }
                        result = result || nearestneighbor.kdtreequeryknn(kdt, x, 1, true)>0;
                        result = result || nearestneighbor.kdtreequeryrnn(kdt, x, 1.0E6, true)>0;
                        result = result || nearestneighbor.kdtreequeryaknn(kdt, x, 1, true, 2.0)>0;
                    }
                }
            }
            
            //
            // Ability to handle array with a lot of duplicates without causing
            // stack overflow.
            //
            // Two situations are handled:
            // * array where ALL N elements are duplicates
            // * array where there are NK distinct elements and N-NK duplicates
            //
            nx = 2;
            ny = 1;
            n = 100000;
            nk = 100;
            v = math.randomreal();
            xy = new double[n, nx+ny];
            x = new double[nx];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=nx+ny-1; j++)
                {
                    xy[i,j] = v;
                }
            }
            nearestneighbor.kdtreebuild(xy, n, nx, ny, 2, kdt);
            for(j=0; j<=nx-1; j++)
            {
                x[j] = v;
            }
            result = result || nearestneighbor.kdtreequeryrnn(kdt, x, 0.0001, true)!=n;
            for(i=0; i<=nk-1; i++)
            {
                for(j=0; j<=nx+ny-1; j++)
                {
                    xy[i,j] = math.randomreal();
                }
            }
            nearestneighbor.kdtreebuild(xy, n, nx, ny, 2, kdt);
            result = result || nearestneighbor.kdtreequeryrnn(kdt, x, 0.0001, true)<n-nk;
            return result;
        }


    }
    public class testablasunit
    {
        public static bool testablas(bool silent)
        {
            bool result = new bool();
            double threshold = 0;
            bool trsmerrors = new bool();
            bool syrkerrors = new bool();
            bool gemmerrors = new bool();
            bool transerrors = new bool();
            bool rank1errors = new bool();
            bool mverrors = new bool();
            bool copyerrors = new bool();
            bool waserrors = new bool();
            double[,] ra = new double[0,0];

            trsmerrors = false;
            syrkerrors = false;
            gemmerrors = false;
            transerrors = false;
            rank1errors = false;
            mverrors = false;
            copyerrors = false;
            waserrors = false;
            threshold = 10000*math.machineepsilon;
            trsmerrors = trsmerrors || testtrsm(1, 3*ablas.ablasblocksize(ra)+1);
            syrkerrors = syrkerrors || testsyrk(1, 3*ablas.ablasblocksize(ra)+1);
            gemmerrors = gemmerrors || testgemm(1, 3*ablas.ablasblocksize(ra)+1);
            transerrors = transerrors || testtrans(1, 3*ablas.ablasblocksize(ra)+1);
            rank1errors = rank1errors || testrank1(1, 3*ablas.ablasblocksize(ra)+1);
            mverrors = mverrors || testmv(1, 3*ablas.ablasblocksize(ra)+1);
            copyerrors = copyerrors || testcopy(1, 3*ablas.ablasblocksize(ra)+1);
            gemmerrors = gemmerrors || testgemm(8*ablas.ablasblocksize(ra)-1, 8*ablas.ablasblocksize(ra)+1);
            
            //
            // report
            //
            waserrors = (((((trsmerrors || syrkerrors) || gemmerrors) || transerrors) || rank1errors) || mverrors) || copyerrors;
            if( !silent )
            {
                System.Console.Write("TESTING ABLAS");
                System.Console.WriteLine();
                System.Console.Write("* TRSM:                                  ");
                if( trsmerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* SYRK:                                  ");
                if( syrkerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* GEMM:                                  ");
                if( gemmerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* TRANS:                                 ");
                if( transerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* RANK1:                                 ");
                if( rank1errors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* MV:                                    ");
                if( mverrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* COPY:                                  ");
                if( copyerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testablas(bool silent)
        {
            return testablas(silent);
        }


        /*************************************************************************
        ?Matrix????TRSM tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testtrsm(int minn,
            int maxn)
        {
            bool result = new bool();
            int n = 0;
            int m = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int optype = 0;
            int uppertype = 0;
            int unittype = 0;
            int xoffsi = 0;
            int xoffsj = 0;
            int aoffsitype = 0;
            int aoffsjtype = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            double[,] refra = new double[0,0];
            double[,] refrxl = new double[0,0];
            double[,] refrxr = new double[0,0];
            complex[,] refca = new complex[0,0];
            complex[,] refcxl = new complex[0,0];
            complex[,] refcxr = new complex[0,0];
            double[,] ra = new double[0,0];
            complex[,] ca = new complex[0,0];
            double[,] rxr1 = new double[0,0];
            double[,] rxl1 = new double[0,0];
            complex[,] cxr1 = new complex[0,0];
            complex[,] cxl1 = new complex[0,0];
            double[,] rxr2 = new double[0,0];
            double[,] rxl2 = new double[0,0];
            complex[,] cxr2 = new complex[0,0];
            complex[,] cxl2 = new complex[0,0];
            double threshold = 0;

            threshold = math.sqr(maxn)*100*math.machineepsilon;
            result = false;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N in [1,MX] such that max(M,N)=MX
                //
                m = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    m = mx;
                }
                else
                {
                    n = mx;
                }
                
                //
                // Initialize RefRA/RefCA by random matrices whose upper
                // and lower triangle submatrices are non-degenerate
                // well-conditioned matrices.
                //
                // Matrix size is 2Mx2M (four copies of same MxM matrix
                // to test different offsets)
                //
                refra = new double[2*m, 2*m];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        refra[i,j] = 0.2*math.randomreal()-0.1;
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    refra[i,i] = (2*math.randominteger(1)-1)*(2*m+math.randomreal());
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        refra[i+m,j] = refra[i,j];
                        refra[i,j+m] = refra[i,j];
                        refra[i+m,j+m] = refra[i,j];
                    }
                }
                refca = new complex[2*m, 2*m];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        refca[i,j].x = 0.2*math.randomreal()-0.1;
                        refca[i,j].y = 0.2*math.randomreal()-0.1;
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    refca[i,i].x = (2*math.randominteger(2)-1)*(2*m+math.randomreal());
                    refca[i,i].y = (2*math.randominteger(2)-1)*(2*m+math.randomreal());
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        refca[i+m,j] = refca[i,j];
                        refca[i,j+m] = refca[i,j];
                        refca[i+m,j+m] = refca[i,j];
                    }
                }
                
                //
                // Generate random XL/XR.
                //
                // XR is NxM matrix (matrix for 'Right' subroutines)
                // XL is MxN matrix (matrix for 'Left' subroutines)
                //
                refrxr = new double[n, m];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        refrxr[i,j] = 2*math.randomreal()-1;
                    }
                }
                refrxl = new double[m, n];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        refrxl[i,j] = 2*math.randomreal()-1;
                    }
                }
                refcxr = new complex[n, m];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        refcxr[i,j].x = 2*math.randomreal()-1;
                        refcxr[i,j].y = 2*math.randomreal()-1;
                    }
                }
                refcxl = new complex[m, n];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        refcxl[i,j].x = 2*math.randomreal()-1;
                        refcxl[i,j].y = 2*math.randomreal()-1;
                    }
                }
                
                //
                // test different types of operations, offsets, and so on...
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                ra = new double[2*m, 2*m];
                rxr1 = new double[n, m];
                rxr2 = new double[n, m];
                rxl1 = new double[m, n];
                rxl2 = new double[m, n];
                ca = new complex[2*m, 2*m];
                cxr1 = new complex[n, m];
                cxr2 = new complex[n, m];
                cxl1 = new complex[m, n];
                cxl2 = new complex[m, n];
                optype = math.randominteger(3);
                uppertype = math.randominteger(2);
                unittype = math.randominteger(2);
                xoffsi = math.randominteger(2);
                xoffsj = math.randominteger(2);
                aoffsitype = math.randominteger(2);
                aoffsjtype = math.randominteger(2);
                aoffsi = m*aoffsitype;
                aoffsj = m*aoffsjtype;
                
                //
                // copy A, XR, XL (fill unused parts with random garbage)
                //
                for(i=0; i<=2*m-1; i++)
                {
                    for(j=0; j<=2*m-1; j++)
                    {
                        if( ((i>=aoffsi && i<aoffsi+m) && j>=aoffsj) && j<aoffsj+m )
                        {
                            ca[i,j] = refca[i,j];
                            ra[i,j] = refra[i,j];
                        }
                        else
                        {
                            ca[i,j] = math.randomreal();
                            ra[i,j] = math.randomreal();
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        if( i>=xoffsi && j>=xoffsj )
                        {
                            cxr1[i,j] = refcxr[i,j];
                            cxr2[i,j] = refcxr[i,j];
                            rxr1[i,j] = refrxr[i,j];
                            rxr2[i,j] = refrxr[i,j];
                        }
                        else
                        {
                            cxr1[i,j] = math.randomreal();
                            cxr2[i,j] = cxr1[i,j];
                            rxr1[i,j] = math.randomreal();
                            rxr2[i,j] = rxr1[i,j];
                        }
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i>=xoffsi && j>=xoffsj )
                        {
                            cxl1[i,j] = refcxl[i,j];
                            cxl2[i,j] = refcxl[i,j];
                            rxl1[i,j] = refrxl[i,j];
                            rxl2[i,j] = refrxl[i,j];
                        }
                        else
                        {
                            cxl1[i,j] = math.randomreal();
                            cxl2[i,j] = cxl1[i,j];
                            rxl1[i,j] = math.randomreal();
                            rxl2[i,j] = rxl1[i,j];
                        }
                    }
                }
                
                //
                // Test CXR
                //
                ablas.cmatrixrighttrsm(n-xoffsi, m-xoffsj, ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, cxr1, xoffsi, xoffsj);
                refcmatrixrighttrsm(n-xoffsi, m-xoffsj, ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, ref cxr2, xoffsi, xoffsj);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        result = result || (double)(math.abscomplex(cxr1[i,j]-cxr2[i,j]))>(double)(threshold);
                    }
                }
                
                //
                // Test CXL
                //
                ablas.cmatrixlefttrsm(m-xoffsi, n-xoffsj, ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, cxl1, xoffsi, xoffsj);
                refcmatrixlefttrsm(m-xoffsi, n-xoffsj, ca, aoffsi, aoffsj, uppertype==0, unittype==0, optype, ref cxl2, xoffsi, xoffsj);
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        result = result || (double)(math.abscomplex(cxl1[i,j]-cxl2[i,j]))>(double)(threshold);
                    }
                }
                if( optype<2 )
                {
                    
                    //
                    // Test RXR
                    //
                    ablas.rmatrixrighttrsm(n-xoffsi, m-xoffsj, ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, rxr1, xoffsi, xoffsj);
                    refrmatrixrighttrsm(n-xoffsi, m-xoffsj, ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, ref rxr2, xoffsi, xoffsj);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=m-1; j++)
                        {
                            result = result || (double)(Math.Abs(rxr1[i,j]-rxr2[i,j]))>(double)(threshold);
                        }
                    }
                    
                    //
                    // Test RXL
                    //
                    ablas.rmatrixlefttrsm(m-xoffsi, n-xoffsj, ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, rxl1, xoffsi, xoffsj);
                    refrmatrixlefttrsm(m-xoffsi, n-xoffsj, ra, aoffsi, aoffsj, uppertype==0, unittype==0, optype, ref rxl2, xoffsi, xoffsj);
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            result = result || (double)(Math.Abs(rxl1[i,j]-rxl2[i,j]))>(double)(threshold);
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        SYRK tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testsyrk(int minn,
            int maxn)
        {
            bool result = new bool();
            int n = 0;
            int k = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int uppertype = 0;
            int xoffsi = 0;
            int xoffsj = 0;
            int aoffsitype = 0;
            int aoffsjtype = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            int alphatype = 0;
            int betatype = 0;
            double[,] refra = new double[0,0];
            double[,] refrc = new double[0,0];
            complex[,] refca = new complex[0,0];
            complex[,] refcc = new complex[0,0];
            double alpha = 0;
            double beta = 0;
            double[,] ra1 = new double[0,0];
            double[,] ra2 = new double[0,0];
            complex[,] ca1 = new complex[0,0];
            complex[,] ca2 = new complex[0,0];
            double[,] rc = new double[0,0];
            double[,] rct = new double[0,0];
            complex[,] cc = new complex[0,0];
            complex[,] cct = new complex[0,0];
            double threshold = 0;

            threshold = maxn*100*math.machineepsilon;
            result = false;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N in [1,MX] such that max(M,N)=MX
                //
                k = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    k = mx;
                }
                else
                {
                    n = mx;
                }
                
                //
                // Initialize RefRA/RefCA by random Hermitian matrices,
                // RefRC/RefCC by random matrices
                //
                // RA/CA size is 2Nx2N (four copies of same NxN matrix
                // to test different offsets)
                //
                refra = new double[2*n, 2*n];
                refca = new complex[2*n, 2*n];
                for(i=0; i<=n-1; i++)
                {
                    refra[i,i] = 2*math.randomreal()-1;
                    refca[i,i] = 2*math.randomreal()-1;
                    for(j=i+1; j<=n-1; j++)
                    {
                        refra[i,j] = 2*math.randomreal()-1;
                        refca[i,j].x = 2*math.randomreal()-1;
                        refca[i,j].y = 2*math.randomreal()-1;
                        refra[j,i] = refra[i,j];
                        refca[j,i] = math.conj(refca[i,j]);
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        refra[i+n,j] = refra[i,j];
                        refra[i,j+n] = refra[i,j];
                        refra[i+n,j+n] = refra[i,j];
                        refca[i+n,j] = refca[i,j];
                        refca[i,j+n] = refca[i,j];
                        refca[i+n,j+n] = refca[i,j];
                    }
                }
                refrc = new double[n, k];
                refcc = new complex[n, k];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        refrc[i,j] = 2*math.randomreal()-1;
                        refcc[i,j].x = 2*math.randomreal()-1;
                        refcc[i,j].y = 2*math.randomreal()-1;
                    }
                }
                
                //
                // test different types of operations, offsets, and so on...
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                ra1 = new double[2*n, 2*n];
                ra2 = new double[2*n, 2*n];
                ca1 = new complex[2*n, 2*n];
                ca2 = new complex[2*n, 2*n];
                rc = new double[n, k];
                rct = new double[k, n];
                cc = new complex[n, k];
                cct = new complex[k, n];
                uppertype = math.randominteger(2);
                xoffsi = math.randominteger(2);
                xoffsj = math.randominteger(2);
                aoffsitype = math.randominteger(2);
                aoffsjtype = math.randominteger(2);
                alphatype = math.randominteger(2);
                betatype = math.randominteger(2);
                aoffsi = n*aoffsitype;
                aoffsj = n*aoffsjtype;
                alpha = alphatype*(2*math.randomreal()-1);
                beta = betatype*(2*math.randomreal()-1);
                
                //
                // copy A, C (fill unused parts with random garbage)
                //
                for(i=0; i<=2*n-1; i++)
                {
                    for(j=0; j<=2*n-1; j++)
                    {
                        if( ((i>=aoffsi && i<aoffsi+n) && j>=aoffsj) && j<aoffsj+n )
                        {
                            ca1[i,j] = refca[i,j];
                            ca2[i,j] = refca[i,j];
                            ra1[i,j] = refra[i,j];
                            ra2[i,j] = refra[i,j];
                        }
                        else
                        {
                            ca1[i,j] = math.randomreal();
                            ca2[i,j] = ca1[i,j];
                            ra1[i,j] = math.randomreal();
                            ra2[i,j] = ra1[i,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=k-1; j++)
                    {
                        if( i>=xoffsi && j>=xoffsj )
                        {
                            rc[i,j] = refrc[i,j];
                            rct[j,i] = refrc[i,j];
                            cc[i,j] = refcc[i,j];
                            cct[j,i] = refcc[i,j];
                        }
                        else
                        {
                            rc[i,j] = math.randomreal();
                            rct[j,i] = rc[i,j];
                            cc[i,j] = math.randomreal();
                            cct[j,i] = cct[j,i];
                        }
                    }
                }
                
                //
                // Test complex
                // Only one of transform types is selected and tested
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    ablas.cmatrixherk(n-xoffsi, k-xoffsj, alpha, cc, xoffsi, xoffsj, 0, beta, ca1, aoffsi, aoffsj, uppertype==0);
                    refcmatrixherk(n-xoffsi, k-xoffsj, alpha, cc, xoffsi, xoffsj, 0, beta, ref ca2, aoffsi, aoffsj, uppertype==0);
                }
                else
                {
                    ablas.cmatrixherk(n-xoffsi, k-xoffsj, alpha, cct, xoffsj, xoffsi, 2, beta, ca1, aoffsi, aoffsj, uppertype==0);
                    refcmatrixherk(n-xoffsi, k-xoffsj, alpha, cct, xoffsj, xoffsi, 2, beta, ref ca2, aoffsi, aoffsj, uppertype==0);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        result = result || (double)(math.abscomplex(ca1[i,j]-ca2[i,j]))>(double)(threshold);
                    }
                }
                
                //
                // Test old version of HERK (named SYRK)
                // Only one of transform types is selected and tested
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    ablas.cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, cc, xoffsi, xoffsj, 0, beta, ca1, aoffsi, aoffsj, uppertype==0);
                    refcmatrixherk(n-xoffsi, k-xoffsj, alpha, cc, xoffsi, xoffsj, 0, beta, ref ca2, aoffsi, aoffsj, uppertype==0);
                }
                else
                {
                    ablas.cmatrixsyrk(n-xoffsi, k-xoffsj, alpha, cct, xoffsj, xoffsi, 2, beta, ca1, aoffsi, aoffsj, uppertype==0);
                    refcmatrixherk(n-xoffsi, k-xoffsj, alpha, cct, xoffsj, xoffsi, 2, beta, ref ca2, aoffsi, aoffsj, uppertype==0);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        result = result || (double)(math.abscomplex(ca1[i,j]-ca2[i,j]))>(double)(threshold);
                    }
                }
                
                //
                // Test real
                // Only one of transform types is selected and tested
                //
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    ablas.rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, rc, xoffsi, xoffsj, 0, beta, ra1, aoffsi, aoffsj, uppertype==0);
                    refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, rc, xoffsi, xoffsj, 0, beta, ref ra2, aoffsi, aoffsj, uppertype==0);
                }
                else
                {
                    ablas.rmatrixsyrk(n-xoffsi, k-xoffsj, alpha, rct, xoffsj, xoffsi, 1, beta, ra1, aoffsi, aoffsj, uppertype==0);
                    refrmatrixsyrk(n-xoffsi, k-xoffsj, alpha, rct, xoffsj, xoffsi, 1, beta, ref ra2, aoffsi, aoffsj, uppertype==0);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        result = result || (double)(Math.Abs(ra1[i,j]-ra2[i,j]))>(double)(threshold);
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        GEMM tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testgemm(int minn,
            int maxn)
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            int k = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            int aoptype = 0;
            int aoptyper = 0;
            int boffsi = 0;
            int boffsj = 0;
            int boptype = 0;
            int boptyper = 0;
            int coffsi = 0;
            int coffsj = 0;
            double[,] refra = new double[0,0];
            double[,] refrb = new double[0,0];
            double[,] refrc = new double[0,0];
            complex[,] refca = new complex[0,0];
            complex[,] refcb = new complex[0,0];
            complex[,] refcc = new complex[0,0];
            double alphar = 0;
            double betar = 0;
            complex alphac = 0;
            complex betac = 0;
            double[,] rc1 = new double[0,0];
            double[,] rc2 = new double[0,0];
            complex[,] cc1 = new complex[0,0];
            complex[,] cc2 = new complex[0,0];
            double threshold = 0;

            threshold = maxn*100*math.machineepsilon;
            result = false;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N/K in [1,MX] such that max(M,N,K)=MX
                //
                m = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                k = 1+math.randominteger(mx);
                i = math.randominteger(3);
                if( i==0 )
                {
                    m = mx;
                }
                if( i==1 )
                {
                    n = mx;
                }
                if( i==2 )
                {
                    k = mx;
                }
                
                //
                // Initialize A/B/C by random matrices with size (MaxN+1)*(MaxN+1)
                //
                refra = new double[maxn+1, maxn+1];
                refrb = new double[maxn+1, maxn+1];
                refrc = new double[maxn+1, maxn+1];
                refca = new complex[maxn+1, maxn+1];
                refcb = new complex[maxn+1, maxn+1];
                refcc = new complex[maxn+1, maxn+1];
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        refra[i,j] = 2*math.randomreal()-1;
                        refrb[i,j] = 2*math.randomreal()-1;
                        refrc[i,j] = 2*math.randomreal()-1;
                        refca[i,j].x = 2*math.randomreal()-1;
                        refca[i,j].y = 2*math.randomreal()-1;
                        refcb[i,j].x = 2*math.randomreal()-1;
                        refcb[i,j].y = 2*math.randomreal()-1;
                        refcc[i,j].x = 2*math.randomreal()-1;
                        refcc[i,j].y = 2*math.randomreal()-1;
                    }
                }
                
                //
                // test different types of operations, offsets, and so on...
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                rc1 = new double[maxn+1, maxn+1];
                rc2 = new double[maxn+1, maxn+1];
                cc1 = new complex[maxn+1, maxn+1];
                cc2 = new complex[maxn+1, maxn+1];
                aoffsi = math.randominteger(2);
                aoffsj = math.randominteger(2);
                aoptype = math.randominteger(3);
                aoptyper = math.randominteger(2);
                boffsi = math.randominteger(2);
                boffsj = math.randominteger(2);
                boptype = math.randominteger(3);
                boptyper = math.randominteger(2);
                coffsi = math.randominteger(2);
                coffsj = math.randominteger(2);
                alphar = math.randominteger(2)*(2*math.randomreal()-1);
                betar = math.randominteger(2)*(2*math.randomreal()-1);
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    alphac.x = 2*math.randomreal()-1;
                    alphac.y = 2*math.randomreal()-1;
                }
                else
                {
                    alphac = 0;
                }
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    betac.x = 2*math.randomreal()-1;
                    betac.y = 2*math.randomreal()-1;
                }
                else
                {
                    betac = 0;
                }
                
                //
                // copy C
                //
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        rc1[i,j] = refrc[i,j];
                        rc2[i,j] = refrc[i,j];
                        cc1[i,j] = refcc[i,j];
                        cc2[i,j] = refcc[i,j];
                    }
                }
                
                //
                // Test complex
                //
                ablas.cmatrixgemm(m, n, k, alphac, refca, aoffsi, aoffsj, aoptype, refcb, boffsi, boffsj, boptype, betac, cc1, coffsi, coffsj);
                refcmatrixgemm(m, n, k, alphac, refca, aoffsi, aoffsj, aoptype, refcb, boffsi, boffsj, boptype, betac, ref cc2, coffsi, coffsj);
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        result = result || (double)(math.abscomplex(cc1[i,j]-cc2[i,j]))>(double)(threshold);
                    }
                }
                
                //
                // Test real
                //
                ablas.rmatrixgemm(m, n, k, alphar, refra, aoffsi, aoffsj, aoptyper, refrb, boffsi, boffsj, boptyper, betar, rc1, coffsi, coffsj);
                refrmatrixgemm(m, n, k, alphar, refra, aoffsi, aoffsj, aoptyper, refrb, boffsi, boffsj, boptyper, betar, ref rc2, coffsi, coffsj);
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        result = result || (double)(Math.Abs(rc1[i,j]-rc2[i,j]))>(double)(threshold);
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        transpose tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testtrans(int minn,
            int maxn)
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            int boffsi = 0;
            int boffsj = 0;
            double v1 = 0;
            double v2 = 0;
            double threshold = 0;
            double[,] refra = new double[0,0];
            double[,] refrb = new double[0,0];
            complex[,] refca = new complex[0,0];
            complex[,] refcb = new complex[0,0];

            result = false;
            threshold = 1000*math.machineepsilon;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N in [1,MX] such that max(M,N)=MX
                // Generate random V1 and V2 which are used to fill
                // RefRB/RefCB with control values.
                //
                m = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                if( math.randominteger(2)==0 )
                {
                    m = mx;
                }
                else
                {
                    n = mx;
                }
                v1 = math.randomreal();
                v2 = math.randomreal();
                
                //
                // Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
                // Fill B with control values
                //
                refra = new double[maxn+1, maxn+1];
                refrb = new double[maxn+1, maxn+1];
                refca = new complex[maxn+1, maxn+1];
                refcb = new complex[maxn+1, maxn+1];
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        refra[i,j] = 2*math.randomreal()-1;
                        refca[i,j].x = 2*math.randomreal()-1;
                        refca[i,j].y = 2*math.randomreal()-1;
                        refrb[i,j] = i*v1+j*v2;
                        refcb[i,j] = i*v1+j*v2;
                    }
                }
                
                //
                // test different offsets (zero or one)
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                aoffsi = math.randominteger(2);
                aoffsj = math.randominteger(2);
                boffsi = math.randominteger(2);
                boffsj = math.randominteger(2);
                ablas.rmatrixtranspose(m, n, refra, aoffsi, aoffsj, refrb, boffsi, boffsj);
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        if( ((i<boffsi || i>=boffsi+n) || j<boffsj) || j>=boffsj+m )
                        {
                            result = result || (double)(Math.Abs(refrb[i,j]-(v1*i+v2*j)))>(double)(threshold);
                        }
                        else
                        {
                            result = result || (double)(Math.Abs(refrb[i,j]-refra[aoffsi+j-boffsj,aoffsj+i-boffsi]))>(double)(threshold);
                        }
                    }
                }
                ablas.cmatrixtranspose(m, n, refca, aoffsi, aoffsj, ref refcb, boffsi, boffsj);
                for(i=0; i<=maxn; i++)
                {
                    for(j=0; j<=maxn; j++)
                    {
                        if( ((i<boffsi || i>=boffsi+n) || j<boffsj) || j>=boffsj+m )
                        {
                            result = result || (double)(math.abscomplex(refcb[i,j]-(v1*i+v2*j)))>(double)(threshold);
                        }
                        else
                        {
                            result = result || (double)(math.abscomplex(refcb[i,j]-refca[aoffsi+j-boffsj,aoffsj+i-boffsi]))>(double)(threshold);
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        rank-1tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testrank1(int minn,
            int maxn)
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            int uoffs = 0;
            int voffs = 0;
            double threshold = 0;
            double[,] refra = new double[0,0];
            double[,] refrb = new double[0,0];
            complex[,] refca = new complex[0,0];
            complex[,] refcb = new complex[0,0];
            double[] ru = new double[0];
            double[] rv = new double[0];
            complex[] cu = new complex[0];
            complex[] cv = new complex[0];

            result = false;
            threshold = 1000*math.machineepsilon;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N in [1,MX] such that max(M,N)=MX
                //
                m = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                if( math.randominteger(2)==0 )
                {
                    m = mx;
                }
                else
                {
                    n = mx;
                }
                
                //
                // Initialize A by random matrix with size (MaxN+1)*(MaxN+1)
                // Fill B with control values
                //
                refra = new double[maxn+maxn, maxn+maxn];
                refrb = new double[maxn+maxn, maxn+maxn];
                refca = new complex[maxn+maxn, maxn+maxn];
                refcb = new complex[maxn+maxn, maxn+maxn];
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        refra[i,j] = 2*math.randomreal()-1;
                        refca[i,j].x = 2*math.randomreal()-1;
                        refca[i,j].y = 2*math.randomreal()-1;
                        refrb[i,j] = refra[i,j];
                        refcb[i,j] = refca[i,j];
                    }
                }
                ru = new double[2*m];
                cu = new complex[2*m];
                for(i=0; i<=2*m-1; i++)
                {
                    ru[i] = 2*math.randomreal()-1;
                    cu[i].x = 2*math.randomreal()-1;
                    cu[i].y = 2*math.randomreal()-1;
                }
                rv = new double[2*n];
                cv = new complex[2*n];
                for(i=0; i<=2*n-1; i++)
                {
                    rv[i] = 2*math.randomreal()-1;
                    cv[i].x = 2*math.randomreal()-1;
                    cv[i].y = 2*math.randomreal()-1;
                }
                
                //
                // test different offsets (zero or one)
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                aoffsi = math.randominteger(maxn);
                aoffsj = math.randominteger(maxn);
                uoffs = math.randominteger(m);
                voffs = math.randominteger(n);
                ablas.cmatrixrank1(m, n, ref refca, aoffsi, aoffsj, ref cu, uoffs, ref cv, voffs);
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        if( ((i<aoffsi || i>=aoffsi+m) || j<aoffsj) || j>=aoffsj+n )
                        {
                            result = result || (double)(math.abscomplex(refca[i,j]-refcb[i,j]))>(double)(threshold);
                        }
                        else
                        {
                            result = result || (double)(math.abscomplex(refca[i,j]-(refcb[i,j]+cu[i-aoffsi+uoffs]*cv[j-aoffsj+voffs])))>(double)(threshold);
                        }
                    }
                }
                ablas.rmatrixrank1(m, n, ref refra, aoffsi, aoffsj, ref ru, uoffs, ref rv, voffs);
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        if( ((i<aoffsi || i>=aoffsi+m) || j<aoffsj) || j>=aoffsj+n )
                        {
                            result = result || (double)(Math.Abs(refra[i,j]-refrb[i,j]))>(double)(threshold);
                        }
                        else
                        {
                            result = result || (double)(Math.Abs(refra[i,j]-(refrb[i,j]+ru[i-aoffsi+uoffs]*rv[j-aoffsj+voffs])))>(double)(threshold);
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        MV tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testmv(int minn,
            int maxn)
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            int xoffs = 0;
            int yoffs = 0;
            int opca = 0;
            int opra = 0;
            double threshold = 0;
            double rv1 = 0;
            double rv2 = 0;
            complex cv1 = 0;
            complex cv2 = 0;
            double[,] refra = new double[0,0];
            complex[,] refca = new complex[0,0];
            double[] rx = new double[0];
            double[] ry = new double[0];
            complex[] cx = new complex[0];
            complex[] cy = new complex[0];
            int i_ = 0;
            int i1_ = 0;

            result = false;
            threshold = 1000*math.machineepsilon;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N in [1,MX] such that max(M,N)=MX
                //
                m = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                if( math.randominteger(2)==0 )
                {
                    m = mx;
                }
                else
                {
                    n = mx;
                }
                
                //
                // Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
                // Initialize X by random vector with size (MaxN+MaxN)
                // Fill Y by control values
                //
                refra = new double[maxn+maxn, maxn+maxn];
                refca = new complex[maxn+maxn, maxn+maxn];
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        refra[i,j] = 2*math.randomreal()-1;
                        refca[i,j].x = 2*math.randomreal()-1;
                        refca[i,j].y = 2*math.randomreal()-1;
                    }
                }
                rx = new double[2*maxn];
                cx = new complex[2*maxn];
                ry = new double[2*maxn];
                cy = new complex[2*maxn];
                for(i=0; i<=2*maxn-1; i++)
                {
                    rx[i] = 2*math.randomreal()-1;
                    cx[i].x = 2*math.randomreal()-1;
                    cx[i].y = 2*math.randomreal()-1;
                    ry[i] = i;
                    cy[i] = i;
                }
                
                //
                // test different offsets (zero or one)
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                aoffsi = math.randominteger(maxn);
                aoffsj = math.randominteger(maxn);
                xoffs = math.randominteger(maxn);
                yoffs = math.randominteger(maxn);
                opca = math.randominteger(3);
                opra = math.randominteger(2);
                ablas.cmatrixmv(m, n, refca, aoffsi, aoffsj, opca, cx, xoffs, ref cy, yoffs);
                for(i=0; i<=2*maxn-1; i++)
                {
                    if( i<yoffs || i>=yoffs+m )
                    {
                        result = result || cy[i]!=i;
                    }
                    else
                    {
                        cv1 = cy[i];
                        cv2 = 0.0;
                        if( opca==0 )
                        {
                            i1_ = (xoffs)-(aoffsj);
                            cv2 = 0.0;
                            for(i_=aoffsj; i_<=aoffsj+n-1;i_++)
                            {
                                cv2 += refca[aoffsi+i-yoffs,i_]*cx[i_+i1_];
                            }
                        }
                        if( opca==1 )
                        {
                            i1_ = (xoffs)-(aoffsi);
                            cv2 = 0.0;
                            for(i_=aoffsi; i_<=aoffsi+n-1;i_++)
                            {
                                cv2 += refca[i_,aoffsj+i-yoffs]*cx[i_+i1_];
                            }
                        }
                        if( opca==2 )
                        {
                            i1_ = (xoffs)-(aoffsi);
                            cv2 = 0.0;
                            for(i_=aoffsi; i_<=aoffsi+n-1;i_++)
                            {
                                cv2 += math.conj(refca[i_,aoffsj+i-yoffs])*cx[i_+i1_];
                            }
                        }
                        result = result || (double)(math.abscomplex(cv1-cv2))>(double)(threshold);
                    }
                }
                ablas.rmatrixmv(m, n, refra, aoffsi, aoffsj, opra, rx, xoffs, ref ry, yoffs);
                for(i=0; i<=2*maxn-1; i++)
                {
                    if( i<yoffs || i>=yoffs+m )
                    {
                        result = result || (double)(ry[i])!=(double)(i);
                    }
                    else
                    {
                        rv1 = ry[i];
                        rv2 = 0;
                        if( opra==0 )
                        {
                            i1_ = (xoffs)-(aoffsj);
                            rv2 = 0.0;
                            for(i_=aoffsj; i_<=aoffsj+n-1;i_++)
                            {
                                rv2 += refra[aoffsi+i-yoffs,i_]*rx[i_+i1_];
                            }
                        }
                        if( opra==1 )
                        {
                            i1_ = (xoffs)-(aoffsi);
                            rv2 = 0.0;
                            for(i_=aoffsi; i_<=aoffsi+n-1;i_++)
                            {
                                rv2 += refra[i_,aoffsj+i-yoffs]*rx[i_+i1_];
                            }
                        }
                        result = result || (double)(Math.Abs(rv1-rv2))>(double)(threshold);
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        COPY tests

        Returns False for passed test, True - for failed
        *************************************************************************/
        private static bool testcopy(int minn,
            int maxn)
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            int mx = 0;
            int i = 0;
            int j = 0;
            int aoffsi = 0;
            int aoffsj = 0;
            int boffsi = 0;
            int boffsj = 0;
            double threshold = 0;
            double[,] ra = new double[0,0];
            double[,] rb = new double[0,0];
            complex[,] ca = new complex[0,0];
            complex[,] cb = new complex[0,0];

            result = false;
            threshold = 1000*math.machineepsilon;
            for(mx=minn; mx<=maxn; mx++)
            {
                
                //
                // Select random M/N in [1,MX] such that max(M,N)=MX
                //
                m = 1+math.randominteger(mx);
                n = 1+math.randominteger(mx);
                if( math.randominteger(2)==0 )
                {
                    m = mx;
                }
                else
                {
                    n = mx;
                }
                
                //
                // Initialize A by random matrix with size (MaxN+MaxN)*(MaxN+MaxN)
                // Initialize X by random vector with size (MaxN+MaxN)
                // Fill Y by control values
                //
                ra = new double[maxn+maxn, maxn+maxn];
                ca = new complex[maxn+maxn, maxn+maxn];
                rb = new double[maxn+maxn, maxn+maxn];
                cb = new complex[maxn+maxn, maxn+maxn];
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        ra[i,j] = 2*math.randomreal()-1;
                        ca[i,j].x = 2*math.randomreal()-1;
                        ca[i,j].y = 2*math.randomreal()-1;
                        rb[i,j] = 1+2*i+3*j;
                        cb[i,j] = 1+2*i+3*j;
                    }
                }
                
                //
                // test different offsets (zero or one)
                //
                // to avoid unnecessary slowdown we don't test ALL possible
                // combinations of operation types. We just generate one random
                // set of parameters and test it.
                //
                aoffsi = math.randominteger(maxn);
                aoffsj = math.randominteger(maxn);
                boffsi = math.randominteger(maxn);
                boffsj = math.randominteger(maxn);
                ablas.cmatrixcopy(m, n, ca, aoffsi, aoffsj, ref cb, boffsi, boffsj);
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        if( ((i<boffsi || i>=boffsi+m) || j<boffsj) || j>=boffsj+n )
                        {
                            result = result || cb[i,j]!=1+2*i+3*j;
                        }
                        else
                        {
                            result = result || (double)(math.abscomplex(ca[aoffsi+i-boffsi,aoffsj+j-boffsj]-cb[i,j]))>(double)(threshold);
                        }
                    }
                }
                ablas.rmatrixcopy(m, n, ra, aoffsi, aoffsj, ref rb, boffsi, boffsj);
                for(i=0; i<=2*maxn-1; i++)
                {
                    for(j=0; j<=2*maxn-1; j++)
                    {
                        if( ((i<boffsi || i>=boffsi+m) || j<boffsj) || j>=boffsj+n )
                        {
                            result = result || (double)(rb[i,j])!=(double)(1+2*i+3*j);
                        }
                        else
                        {
                            result = result || (double)(Math.Abs(ra[aoffsi+i-boffsi,aoffsj+j-boffsj]-rb[i,j]))>(double)(threshold);
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Reference implementation

          -- ALGLIB routine --
             15.12.2009
             Bochkanov Sergey
        *************************************************************************/
        private static void refcmatrixrighttrsm(int m,
            int n,
            complex[,] a,
            int i1,
            int j1,
            bool isupper,
            bool isunit,
            int optype,
            ref complex[,] x,
            int i2,
            int j2)
        {
            complex[,] a1 = new complex[0,0];
            complex[,] a2 = new complex[0,0];
            complex[] tx = new complex[0];
            int i = 0;
            int j = 0;
            complex vc = 0;
            bool rupper = new bool();
            int i_ = 0;
            int i1_ = 0;

            if( n*m==0 )
            {
                return;
            }
            a1 = new complex[n, n];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a1[i,j] = 0;
                }
            }
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=i; j<=n-1; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=i; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            rupper = isupper;
            if( isunit )
            {
                for(i=0; i<=n-1; i++)
                {
                    a1[i,i] = 1;
                }
            }
            a2 = new complex[n, n];
            if( optype==0 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a2[i,j] = a1[i,j];
                    }
                }
            }
            if( optype==1 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a2[i,j] = a1[j,i];
                    }
                }
                rupper = !rupper;
            }
            if( optype==2 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a2[i,j] = math.conj(a1[j,i]);
                    }
                }
                rupper = !rupper;
            }
            internalcmatrixtrinverse(ref a2, n, rupper, false);
            tx = new complex[n];
            for(i=0; i<=m-1; i++)
            {
                i1_ = (j2) - (0);
                for(i_=0; i_<=n-1;i_++)
                {
                    tx[i_] = x[i2+i,i_+i1_];
                }
                for(j=0; j<=n-1; j++)
                {
                    vc = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        vc += tx[i_]*a2[i_,j];
                    }
                    x[i2+i,j2+j] = vc;
                }
            }
        }


        /*************************************************************************
        Reference implementation

          -- ALGLIB routine --
             15.12.2009
             Bochkanov Sergey
        *************************************************************************/
        private static void refcmatrixlefttrsm(int m,
            int n,
            complex[,] a,
            int i1,
            int j1,
            bool isupper,
            bool isunit,
            int optype,
            ref complex[,] x,
            int i2,
            int j2)
        {
            complex[,] a1 = new complex[0,0];
            complex[,] a2 = new complex[0,0];
            complex[] tx = new complex[0];
            int i = 0;
            int j = 0;
            complex vc = 0;
            bool rupper = new bool();
            int i_ = 0;
            int i1_ = 0;

            if( n*m==0 )
            {
                return;
            }
            a1 = new complex[m, m];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    a1[i,j] = 0;
                }
            }
            if( isupper )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=i; j<=m-1; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            else
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=i; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            rupper = isupper;
            if( isunit )
            {
                for(i=0; i<=m-1; i++)
                {
                    a1[i,i] = 1;
                }
            }
            a2 = new complex[m, m];
            if( optype==0 )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        a2[i,j] = a1[i,j];
                    }
                }
            }
            if( optype==1 )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        a2[i,j] = a1[j,i];
                    }
                }
                rupper = !rupper;
            }
            if( optype==2 )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        a2[i,j] = math.conj(a1[j,i]);
                    }
                }
                rupper = !rupper;
            }
            internalcmatrixtrinverse(ref a2, m, rupper, false);
            tx = new complex[m];
            for(j=0; j<=n-1; j++)
            {
                i1_ = (i2) - (0);
                for(i_=0; i_<=m-1;i_++)
                {
                    tx[i_] = x[i_+i1_,j2+j];
                }
                for(i=0; i<=m-1; i++)
                {
                    vc = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        vc += a2[i,i_]*tx[i_];
                    }
                    x[i2+i,j2+j] = vc;
                }
            }
        }


        /*************************************************************************
        Reference implementation

          -- ALGLIB routine --
             15.12.2009
             Bochkanov Sergey
        *************************************************************************/
        private static void refrmatrixrighttrsm(int m,
            int n,
            double[,] a,
            int i1,
            int j1,
            bool isupper,
            bool isunit,
            int optype,
            ref double[,] x,
            int i2,
            int j2)
        {
            double[,] a1 = new double[0,0];
            double[,] a2 = new double[0,0];
            double[] tx = new double[0];
            int i = 0;
            int j = 0;
            double vr = 0;
            bool rupper = new bool();
            int i_ = 0;
            int i1_ = 0;

            if( n*m==0 )
            {
                return;
            }
            a1 = new double[n, n];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a1[i,j] = 0;
                }
            }
            if( isupper )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=i; j<=n-1; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            else
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=i; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            rupper = isupper;
            if( isunit )
            {
                for(i=0; i<=n-1; i++)
                {
                    a1[i,i] = 1;
                }
            }
            a2 = new double[n, n];
            if( optype==0 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a2[i,j] = a1[i,j];
                    }
                }
            }
            if( optype==1 )
            {
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a2[i,j] = a1[j,i];
                    }
                }
                rupper = !rupper;
            }
            internalrmatrixtrinverse(ref a2, n, rupper, false);
            tx = new double[n];
            for(i=0; i<=m-1; i++)
            {
                i1_ = (j2) - (0);
                for(i_=0; i_<=n-1;i_++)
                {
                    tx[i_] = x[i2+i,i_+i1_];
                }
                for(j=0; j<=n-1; j++)
                {
                    vr = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        vr += tx[i_]*a2[i_,j];
                    }
                    x[i2+i,j2+j] = vr;
                }
            }
        }


        /*************************************************************************
        Reference implementation

          -- ALGLIB routine --
             15.12.2009
             Bochkanov Sergey
        *************************************************************************/
        private static void refrmatrixlefttrsm(int m,
            int n,
            double[,] a,
            int i1,
            int j1,
            bool isupper,
            bool isunit,
            int optype,
            ref double[,] x,
            int i2,
            int j2)
        {
            double[,] a1 = new double[0,0];
            double[,] a2 = new double[0,0];
            double[] tx = new double[0];
            int i = 0;
            int j = 0;
            double vr = 0;
            bool rupper = new bool();
            int i_ = 0;
            int i1_ = 0;

            if( n*m==0 )
            {
                return;
            }
            a1 = new double[m, m];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    a1[i,j] = 0;
                }
            }
            if( isupper )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=i; j<=m-1; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            else
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=i; j++)
                    {
                        a1[i,j] = a[i1+i,j1+j];
                    }
                }
            }
            rupper = isupper;
            if( isunit )
            {
                for(i=0; i<=m-1; i++)
                {
                    a1[i,i] = 1;
                }
            }
            a2 = new double[m, m];
            if( optype==0 )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        a2[i,j] = a1[i,j];
                    }
                }
            }
            if( optype==1 )
            {
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        a2[i,j] = a1[j,i];
                    }
                }
                rupper = !rupper;
            }
            internalrmatrixtrinverse(ref a2, m, rupper, false);
            tx = new double[m];
            for(j=0; j<=n-1; j++)
            {
                i1_ = (i2) - (0);
                for(i_=0; i_<=m-1;i_++)
                {
                    tx[i_] = x[i_+i1_,j2+j];
                }
                for(i=0; i<=m-1; i++)
                {
                    vr = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        vr += a2[i,i_]*tx[i_];
                    }
                    x[i2+i,j2+j] = vr;
                }
            }
        }


        /*************************************************************************
        Internal subroutine.
        Triangular matrix inversion

          -- LAPACK routine (version 3.0) --
             Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
             Courant Institute, Argonne National Lab, and Rice University
             February 29, 1992
        *************************************************************************/
        private static bool internalcmatrixtrinverse(ref complex[,] a,
            int n,
            bool isupper,
            bool isunittriangular)
        {
            bool result = new bool();
            bool nounit = new bool();
            int i = 0;
            int j = 0;
            complex v = 0;
            complex ajj = 0;
            complex[] t = new complex[0];
            int i_ = 0;

            result = true;
            t = new complex[n-1+1];
            
            //
            // Test the input parameters.
            //
            nounit = !isunittriangular;
            if( isupper )
            {
                
                //
                // Compute inverse of upper triangular matrix.
                //
                for(j=0; j<=n-1; j++)
                {
                    if( nounit )
                    {
                        if( a[j,j]==0 )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    
                    //
                    // Compute elements 1:j-1 of j-th column.
                    //
                    if( j>0 )
                    {
                        for(i_=0; i_<=j-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=0; i<=j-1; i++)
                        {
                            if( i+1<j )
                            {
                                v = 0.0;
                                for(i_=i+1; i_<=j-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=0; i_<=j-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            else
            {
                
                //
                // Compute inverse of lower triangular matrix.
                //
                for(j=n-1; j>=0; j--)
                {
                    if( nounit )
                    {
                        if( a[j,j]==0 )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    if( j+1<n )
                    {
                        
                        //
                        // Compute elements j+1:n of j-th column.
                        //
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=j+1; i<=n-1; i++)
                        {
                            if( i>j+1 )
                            {
                                v = 0.0;
                                for(i_=j+1; i_<=i-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Internal subroutine.
        Triangular matrix inversion

          -- LAPACK routine (version 3.0) --
             Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
             Courant Institute, Argonne National Lab, and Rice University
             February 29, 1992
        *************************************************************************/
        private static bool internalrmatrixtrinverse(ref double[,] a,
            int n,
            bool isupper,
            bool isunittriangular)
        {
            bool result = new bool();
            bool nounit = new bool();
            int i = 0;
            int j = 0;
            double v = 0;
            double ajj = 0;
            double[] t = new double[0];
            int i_ = 0;

            result = true;
            t = new double[n-1+1];
            
            //
            // Test the input parameters.
            //
            nounit = !isunittriangular;
            if( isupper )
            {
                
                //
                // Compute inverse of upper triangular matrix.
                //
                for(j=0; j<=n-1; j++)
                {
                    if( nounit )
                    {
                        if( (double)(a[j,j])==(double)(0) )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    
                    //
                    // Compute elements 1:j-1 of j-th column.
                    //
                    if( j>0 )
                    {
                        for(i_=0; i_<=j-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=0; i<=j-1; i++)
                        {
                            if( i<j-1 )
                            {
                                v = 0.0;
                                for(i_=i+1; i_<=j-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=0; i_<=j-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            else
            {
                
                //
                // Compute inverse of lower triangular matrix.
                //
                for(j=n-1; j>=0; j--)
                {
                    if( nounit )
                    {
                        if( (double)(a[j,j])==(double)(0) )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    if( j<n-1 )
                    {
                        
                        //
                        // Compute elements j+1:n of j-th column.
                        //
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=j+1; i<=n-1; i++)
                        {
                            if( i>j+1 )
                            {
                                v = 0.0;
                                for(i_=j+1; i_<=i-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Reference SYRK subroutine.

          -- ALGLIB routine --
             16.12.2009
             Bochkanov Sergey
        *************************************************************************/
        private static void refcmatrixherk(int n,
            int k,
            double alpha,
            complex[,] a,
            int ia,
            int ja,
            int optypea,
            double beta,
            ref complex[,] c,
            int ic,
            int jc,
            bool isupper)
        {
            complex[,] ae = new complex[0,0];
            int i = 0;
            int j = 0;
            complex vc = 0;
            int i_ = 0;

            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (isupper && j>=i) || (!isupper && j<=i) )
                    {
                        if( (double)(beta)==(double)(0) )
                        {
                            c[i+ic,j+jc] = 0;
                        }
                        else
                        {
                            c[i+ic,j+jc] = c[i+ic,j+jc]*beta;
                        }
                    }
                }
            }
            if( (double)(alpha)==(double)(0) )
            {
                return;
            }
            if( n*k>0 )
            {
                ae = new complex[n, k];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    if( optypea==0 )
                    {
                        ae[i,j] = a[ia+i,ja+j];
                    }
                    if( optypea==2 )
                    {
                        ae[i,j] = math.conj(a[ia+j,ja+i]);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    vc = 0;
                    if( k>0 )
                    {
                        vc = 0.0;
                        for(i_=0; i_<=k-1;i_++)
                        {
                            vc += ae[i,i_]*math.conj(ae[j,i_]);
                        }
                    }
                    vc = alpha*vc;
                    if( isupper && j>=i )
                    {
                        c[ic+i,jc+j] = vc+c[ic+i,jc+j];
                    }
                    if( !isupper && j<=i )
                    {
                        c[ic+i,jc+j] = vc+c[ic+i,jc+j];
                    }
                }
            }
        }


        /*************************************************************************
        Reference SYRK subroutine.

          -- ALGLIB routine --
             16.12.2009
             Bochkanov Sergey
        *************************************************************************/
        private static void refrmatrixsyrk(int n,
            int k,
            double alpha,
            double[,] a,
            int ia,
            int ja,
            int optypea,
            double beta,
            ref double[,] c,
            int ic,
            int jc,
            bool isupper)
        {
            double[,] ae = new double[0,0];
            int i = 0;
            int j = 0;
            double vr = 0;
            int i_ = 0;

            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (isupper && j>=i) || (!isupper && j<=i) )
                    {
                        if( (double)(beta)==(double)(0) )
                        {
                            c[i+ic,j+jc] = 0;
                        }
                        else
                        {
                            c[i+ic,j+jc] = c[i+ic,j+jc]*beta;
                        }
                    }
                }
            }
            if( (double)(alpha)==(double)(0) )
            {
                return;
            }
            if( n*k>0 )
            {
                ae = new double[n, k];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    if( optypea==0 )
                    {
                        ae[i,j] = a[ia+i,ja+j];
                    }
                    if( optypea==1 )
                    {
                        ae[i,j] = a[ia+j,ja+i];
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    vr = 0;
                    if( k>0 )
                    {
                        vr = 0.0;
                        for(i_=0; i_<=k-1;i_++)
                        {
                            vr += ae[i,i_]*ae[j,i_];
                        }
                    }
                    vr = alpha*vr;
                    if( isupper && j>=i )
                    {
                        c[ic+i,jc+j] = vr+c[ic+i,jc+j];
                    }
                    if( !isupper && j<=i )
                    {
                        c[ic+i,jc+j] = vr+c[ic+i,jc+j];
                    }
                }
            }
        }


        /*************************************************************************
        Reference GEMM,
        ALGLIB subroutine
        *************************************************************************/
        private static void refcmatrixgemm(int m,
            int n,
            int k,
            complex alpha,
            complex[,] a,
            int ia,
            int ja,
            int optypea,
            complex[,] b,
            int ib,
            int jb,
            int optypeb,
            complex beta,
            ref complex[,] c,
            int ic,
            int jc)
        {
            complex[,] ae = new complex[0,0];
            complex[,] be = new complex[0,0];
            int i = 0;
            int j = 0;
            complex vc = 0;
            int i_ = 0;

            ae = new complex[m, k];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    if( optypea==0 )
                    {
                        ae[i,j] = a[ia+i,ja+j];
                    }
                    if( optypea==1 )
                    {
                        ae[i,j] = a[ia+j,ja+i];
                    }
                    if( optypea==2 )
                    {
                        ae[i,j] = math.conj(a[ia+j,ja+i]);
                    }
                }
            }
            be = new complex[k, n];
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( optypeb==0 )
                    {
                        be[i,j] = b[ib+i,jb+j];
                    }
                    if( optypeb==1 )
                    {
                        be[i,j] = b[ib+j,jb+i];
                    }
                    if( optypeb==2 )
                    {
                        be[i,j] = math.conj(b[ib+j,jb+i]);
                    }
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    vc = 0.0;
                    for(i_=0; i_<=k-1;i_++)
                    {
                        vc += ae[i,i_]*be[i_,j];
                    }
                    vc = alpha*vc;
                    if( beta!=0 )
                    {
                        vc = vc+beta*c[ic+i,jc+j];
                    }
                    c[ic+i,jc+j] = vc;
                }
            }
        }


        /*************************************************************************
        Reference GEMM,
        ALGLIB subroutine
        *************************************************************************/
        private static void refrmatrixgemm(int m,
            int n,
            int k,
            double alpha,
            double[,] a,
            int ia,
            int ja,
            int optypea,
            double[,] b,
            int ib,
            int jb,
            int optypeb,
            double beta,
            ref double[,] c,
            int ic,
            int jc)
        {
            double[,] ae = new double[0,0];
            double[,] be = new double[0,0];
            int i = 0;
            int j = 0;
            double vc = 0;
            int i_ = 0;

            ae = new double[m, k];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    if( optypea==0 )
                    {
                        ae[i,j] = a[ia+i,ja+j];
                    }
                    if( optypea==1 )
                    {
                        ae[i,j] = a[ia+j,ja+i];
                    }
                }
            }
            be = new double[k, n];
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( optypeb==0 )
                    {
                        be[i,j] = b[ib+i,jb+j];
                    }
                    if( optypeb==1 )
                    {
                        be[i,j] = b[ib+j,jb+i];
                    }
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    vc = 0.0;
                    for(i_=0; i_<=k-1;i_++)
                    {
                        vc += ae[i,i_]*be[i_,j];
                    }
                    vc = alpha*vc;
                    if( (double)(beta)!=(double)(0) )
                    {
                        vc = vc+beta*c[ic+i,jc+j];
                    }
                    c[ic+i,jc+j] = vc;
                }
            }
        }


    }
    public class testbasestatunit
    {
        public static bool testbasestat(bool silent)
        {
            bool result = new bool();
            bool waserrors = new bool();
            bool s1errors = new bool();
            bool covcorrerrors = new bool();
            bool rankerrors = new bool();
            double threshold = 0;
            int i = 0;
            int j = 0;
            int n = 0;
            int kx = 0;
            int ky = 0;
            int ctype = 0;
            int cidxx = 0;
            int cidxy = 0;
            double[] x = new double[0];
            double[] y = new double[0];
            double[,] mx = new double[0,0];
            double[,] my = new double[0,0];
            double[,] cc = new double[0,0];
            double[,] cp = new double[0,0];
            double[,] cs = new double[0,0];
            double mean = 0;
            double variance = 0;
            double skewness = 0;
            double kurtosis = 0;
            double adev = 0;
            double median = 0;
            double pv = 0;
            double v = 0;
            double tmean = 0;
            double tvariance = 0;
            double tskewness = 0;
            double tkurtosis = 0;
            int i_ = 0;

            
            //
            // Primary settings
            //
            waserrors = false;
            s1errors = false;
            covcorrerrors = false;
            rankerrors = false;
            threshold = 1000*math.machineepsilon;
            
            //
            // Ranking
            //
            testranking(ref rankerrors);
            
            //
            // * prepare X and Y - two test samples
            // * test 1-sample coefficients
            // * test for SampleMean, SampleVariance,
            //   SampleSkewness, SampleKurtosis.
            //
            n = 10;
            x = new double[n];
            for(i=0; i<=n-1; i++)
            {
                x[i] = math.sqr(i);
            }
            basestat.samplemoments(x, n, ref mean, ref variance, ref skewness, ref kurtosis);
            s1errors = s1errors || (double)(Math.Abs(mean-28.5))>(double)(0.001);
            s1errors = s1errors || (double)(Math.Abs(variance-801.1667))>(double)(0.001);
            s1errors = s1errors || (double)(Math.Abs(skewness-0.5751))>(double)(0.001);
            s1errors = s1errors || (double)(Math.Abs(kurtosis+1.2666))>(double)(0.001);
            tmean = basestat.samplemean(x, n);
            tvariance = basestat.samplevariance(x, n);
            tskewness = basestat.sampleskewness(x, n);
            tkurtosis = basestat.samplekurtosis(x, n);
            s1errors = s1errors || (double)(mean-tmean)!=(double)(0);
            s1errors = s1errors || (double)(variance-tvariance)!=(double)(0);
            s1errors = s1errors || (double)(skewness-tskewness)!=(double)(0);
            s1errors = s1errors || (double)(kurtosis-tkurtosis)!=(double)(0);
            basestat.sampleadev(x, n, ref adev);
            s1errors = s1errors || (double)(Math.Abs(adev-23.2000))>(double)(0.001);
            basestat.samplemedian(x, n, ref median);
            s1errors = s1errors || (double)(Math.Abs(median-0.5*(16+25)))>(double)(0.001);
            for(i=0; i<=n-1; i++)
            {
                basestat.samplepercentile(x, n, (double)i/(double)(n-1), ref pv);
                s1errors = s1errors || (double)(Math.Abs(pv-x[i]))>(double)(0.001);
            }
            basestat.samplepercentile(x, n, 0.5, ref pv);
            s1errors = s1errors || (double)(Math.Abs(pv-0.5*(16+25)))>(double)(0.001);
            
            //
            // test covariance/correlation:
            // * 2-sample coefficients
            //
            // We generate random matrices MX and MY
            //
            n = 10;
            x = new double[n];
            y = new double[n];
            for(i=0; i<=n-1; i++)
            {
                x[i] = math.sqr(i);
                y[i] = i;
            }
            covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.pearsoncorr2(x, y, n)-0.9627))>(double)(0.0001);
            covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.spearmancorr2(x, y, n)-1.0000))>(double)(0.0001);
            covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.cov2(x, y, n)-82.5000))>(double)(0.0001);
            for(i=0; i<=n-1; i++)
            {
                x[i] = math.sqr(i-0.5*n);
                y[i] = i;
            }
            covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.pearsoncorr2(x, y, n)+0.3676))>(double)(0.0001);
            covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.spearmancorr2(x, y, n)+0.2761))>(double)(0.0001);
            covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.cov2(x, y, n)+9.1667))>(double)(0.0001);
            
            //
            // test covariance/correlation:
            // * matrix covariance/correlation
            // * matrix cross-covariance/cross-correlation
            //
            // We generate random matrices MX and MY which contain KX (KY)
            // columns, all except one are random, one of them is constant.
            // We test that function (a) do not crash on constant column,
            // and (b) return variances/correlations that are exactly zero
            // for this column.
            //
            // CType control variable controls type of constant: 0 - no constant
            // column, 1 - zero column, 2 - nonzero column with value whose
            // binary representation contains many non-zero bits. Using such
            // type of constant column we are able to ensure than even in the
            // presense of roundoff error functions correctly detect constant
            // columns.
            //
            for(n=0; n<=10; n++)
            {
                if( n>0 )
                {
                    x = new double[n];
                    y = new double[n];
                }
                for(ctype=0; ctype<=2; ctype++)
                {
                    for(kx=1; kx<=10; kx++)
                    {
                        for(ky=1; ky<=10; ky++)
                        {
                            
                            //
                            // Fill matrices, add constant column (when CType=1 or =2)
                            //
                            cidxx = -1;
                            cidxy = -1;
                            if( n>0 )
                            {
                                mx = new double[n, kx];
                                my = new double[n, ky];
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=0; j<=kx-1; j++)
                                    {
                                        mx[i,j] = 2*math.randomreal()-1;
                                    }
                                    for(j=0; j<=ky-1; j++)
                                    {
                                        my[i,j] = 2*math.randomreal()-1;
                                    }
                                }
                                if( ctype==1 )
                                {
                                    cidxx = math.randominteger(kx);
                                    cidxy = math.randominteger(ky);
                                    for(i=0; i<=n-1; i++)
                                    {
                                        mx[i,cidxx] = 0.0;
                                        my[i,cidxy] = 0.0;
                                    }
                                }
                                if( ctype==2 )
                                {
                                    cidxx = math.randominteger(kx);
                                    cidxy = math.randominteger(ky);
                                    v = Math.Sqrt((double)(math.randominteger(kx)+1)/(double)kx);
                                    for(i=0; i<=n-1; i++)
                                    {
                                        mx[i,cidxx] = v;
                                        my[i,cidxy] = v;
                                    }
                                }
                            }
                            
                            //
                            // test covariance/correlation matrix using
                            // 2-sample functions as reference point.
                            //
                            // We also test that coefficients for constant variables
                            // are exactly zero.
                            //
                            basestat.covm(mx, n, kx, ref cc);
                            basestat.pearsoncorrm(mx, n, kx, ref cp);
                            basestat.spearmancorrm(mx, n, kx, ref cs);
                            for(i=0; i<=kx-1; i++)
                            {
                                for(j=0; j<=kx-1; j++)
                                {
                                    if( n>0 )
                                    {
                                        for(i_=0; i_<=n-1;i_++)
                                        {
                                            x[i_] = mx[i_,i];
                                        }
                                        for(i_=0; i_<=n-1;i_++)
                                        {
                                            y[i_] = mx[i_,j];
                                        }
                                    }
                                    covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.cov2(x, y, n)-cc[i,j]))>(double)(threshold);
                                    covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.pearsoncorr2(x, y, n)-cp[i,j]))>(double)(threshold);
                                    covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.spearmancorr2(x, y, n)-cs[i,j]))>(double)(threshold);
                                }
                            }
                            if( ctype!=0 && n>0 )
                            {
                                for(i=0; i<=kx-1; i++)
                                {
                                    covcorrerrors = covcorrerrors || (double)(cc[i,cidxx])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cc[cidxx,i])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cp[i,cidxx])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cp[cidxx,i])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cs[i,cidxx])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cs[cidxx,i])!=(double)(0);
                                }
                            }
                            
                            //
                            // test cross-covariance/cross-correlation matrix using
                            // 2-sample functions as reference point.
                            //
                            // We also test that coefficients for constant variables
                            // are exactly zero.
                            //
                            basestat.covm2(mx, my, n, kx, ky, ref cc);
                            basestat.pearsoncorrm2(mx, my, n, kx, ky, ref cp);
                            basestat.spearmancorrm2(mx, my, n, kx, ky, ref cs);
                            for(i=0; i<=kx-1; i++)
                            {
                                for(j=0; j<=ky-1; j++)
                                {
                                    if( n>0 )
                                    {
                                        for(i_=0; i_<=n-1;i_++)
                                        {
                                            x[i_] = mx[i_,i];
                                        }
                                        for(i_=0; i_<=n-1;i_++)
                                        {
                                            y[i_] = my[i_,j];
                                        }
                                    }
                                    covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.cov2(x, y, n)-cc[i,j]))>(double)(threshold);
                                    covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.pearsoncorr2(x, y, n)-cp[i,j]))>(double)(threshold);
                                    covcorrerrors = covcorrerrors || (double)(Math.Abs(basestat.spearmancorr2(x, y, n)-cs[i,j]))>(double)(threshold);
                                }
                            }
                            if( ctype!=0 && n>0 )
                            {
                                for(i=0; i<=kx-1; i++)
                                {
                                    covcorrerrors = covcorrerrors || (double)(cc[i,cidxy])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cp[i,cidxy])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cs[i,cidxy])!=(double)(0);
                                }
                                for(j=0; j<=ky-1; j++)
                                {
                                    covcorrerrors = covcorrerrors || (double)(cc[cidxx,j])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cp[cidxx,j])!=(double)(0);
                                    covcorrerrors = covcorrerrors || (double)(cs[cidxx,j])!=(double)(0);
                                }
                            }
                        }
                    }
                }
            }
            
            //
            // Final report
            //
            waserrors = (s1errors || covcorrerrors) || rankerrors;
            if( !silent )
            {
                System.Console.Write("DESC.STAT TEST");
                System.Console.WriteLine();
                System.Console.Write("TOTAL RESULTS:                           ");
                if( !waserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* 1-SAMPLE FUNCTIONALITY:                ");
                if( !s1errors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* CORRELATION/COVARIATION:               ");
                if( !covcorrerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* RANKING:                               ");
                if( !rankerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST SUMMARY: FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST SUMMARY: PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testbasestat(bool silent)
        {
            return testbasestat(silent);
        }


        /*************************************************************************
        This function tests ranking functionality. In case  of  failure  it  sets
        Err parameter to True; this parameter is left unchanged otherwise.
        *************************************************************************/
        private static void testranking(ref bool err)
        {
            int testk = 0;
            int npoints = 0;
            int nfeatures = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double[,] xy0 = new double[0,0];
            double[,] xy1 = new double[0,0];
            double[,] xy2 = new double[0,0];
            double v = 0;

            
            //
            // Test 1 - large array, unique ranks, each row is obtained as follows:
            // * we generate X[i=0..N-1] = I
            // * we add random noise: X[i] := X[i] + 0.2*randomreal()-0.1
            // * we perform random permutation
            //
            // Such dataset has following properties:
            // * all data are unique within their rows
            // * rank(X[i]) = round(X[i])
            //
            // We perform several tests with different NPoints/NFeatures.
            //
            for(testk=0; testk<=1; testk++)
            {
                
                //
                // Select problem size
                //
                if( testk==0 )
                {
                    npoints = 200;
                    nfeatures = 1000;
                }
                else
                {
                    npoints = 1000;
                    nfeatures = 200;
                }
                
                //
                // Generate XY0, XY1, XY2
                //
                xy0 = new double[npoints, nfeatures];
                xy1 = new double[npoints, nfeatures];
                xy2 = new double[npoints, nfeatures];
                for(i=0; i<=npoints-1; i++)
                {
                    for(j=0; j<=nfeatures-1; j++)
                    {
                        xy0[i,j] = j+0.2*math.randomreal()-0.1;
                    }
                    for(j=0; j<=nfeatures-2; j++)
                    {
                        k = math.randominteger(nfeatures-j);
                        if( k!=0 )
                        {
                            v = xy0[i,j];
                            xy0[i,j] = xy0[i,j+k];
                            xy0[i,j+k] = v;
                        }
                    }
                    for(j=0; j<=nfeatures-1; j++)
                    {
                        xy1[i,j] = xy0[i,j];
                        xy2[i,j] = xy0[i,j];
                    }
                }
                
                //
                // Test uncentered ranks
                //
                basestat.rankdata(xy0, npoints, nfeatures);
                for(i=0; i<=npoints-1; i++)
                {
                    for(j=0; j<=nfeatures-1; j++)
                    {
                        if( (double)(xy0[i,j])!=(double)((int)Math.Round(xy2[i,j])) )
                        {
                            err = true;
                        }
                    }
                }
                
                //
                // Test centered ranks:
                // they must be equal to uncentered ranks minus (NFeatures-1)/2
                //
                basestat.rankdatacentered(xy1, npoints, nfeatures);
                for(i=0; i<=npoints-1; i++)
                {
                    for(j=0; j<=nfeatures-1; j++)
                    {
                        if( (double)(xy1[i,j])!=(double)((int)Math.Round(xy2[i,j])-(double)(nfeatures-1)/(double)2) )
                        {
                            err = true;
                        }
                    }
                }
            }
            
            //
            // Test correct handling of tied ranks
            //
            npoints = 3;
            nfeatures = 4;
            xy0 = new double[npoints, nfeatures];
            xy1 = new double[npoints, nfeatures];
            xy0[0,0] = 2.25;
            xy0[0,1] = 3.75;
            xy0[0,2] = 3.25;
            xy0[0,3] = 2.25;
            xy0[1,0] = 2;
            xy0[1,1] = 2;
            xy0[1,2] = 2;
            xy0[1,3] = 7;
            xy0[2,0] = 9;
            xy0[2,1] = 9;
            xy0[2,2] = 9;
            xy0[2,3] = 9;
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=nfeatures-1; j++)
                {
                    xy1[i,j] = xy0[i,j];
                }
            }
            basestat.rankdata(xy0, npoints, nfeatures);
            if( (double)(Math.Abs(xy0[0,0]-0.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[0,1]-3.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[0,2]-2.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[0,3]-0.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[1,0]-1.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[1,1]-1.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[1,2]-1.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[1,3]-3.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[2,0]-1.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[2,1]-1.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[2,2]-1.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy0[2,3]-1.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            basestat.rankdatacentered(xy1, npoints, nfeatures);
            if( (double)(Math.Abs(xy1[0,0]+1.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[0,1]-1.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[0,2]-0.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[0,3]+1.0))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[1,0]+0.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[1,1]+0.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[1,2]+0.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(Math.Abs(xy1[1,3]-1.5))>(double)(10*math.machineepsilon) )
            {
                err = true;
            }
            if( (double)(xy1[2,0])!=(double)(0) )
            {
                err = true;
            }
            if( (double)(xy1[2,1])!=(double)(0) )
            {
                err = true;
            }
            if( (double)(xy1[2,2])!=(double)(0) )
            {
                err = true;
            }
            if( (double)(xy1[2,3])!=(double)(0) )
            {
                err = true;
            }
        }


    }
    public class testbdssunit
    {
        /*************************************************************************
        Testing BDSS operations
        *************************************************************************/
        public static bool testbdss(bool silent)
        {
            bool result = new bool();
            int n = 0;
            int i = 0;
            int j = 0;
            int pass = 0;
            int passcount = 0;
            int maxn = 0;
            int maxnq = 0;
            double[] a = new double[0];
            double[] a0 = new double[0];
            double[] at = new double[0];
            double[,] p = new double[0,0];
            double[] thresholds = new double[0];
            int ni = 0;
            int[] c = new int[0];
            int[] p1 = new int[0];
            int[] p2 = new int[0];
            int[] ties = new int[0];
            int[] pt1 = new int[0];
            int[] pt2 = new int[0];
            int tiecount = 0;
            int c1 = 0;
            int c0 = 0;
            int nc = 0;
            double[] tmp = new double[0];
            double[] sortrbuf = new double[0];
            double[] sortrbuf2 = new double[0];
            int[] sortibuf = new int[0];
            double pal = 0;
            double pbl = 0;
            double par = 0;
            double pbr = 0;
            double cve = 0;
            double cvr = 0;
            int info = 0;
            double threshold = 0;
            int[] tiebuf = new int[0];
            int[] cntbuf = new int[0];
            double rms = 0;
            double cvrms = 0;
            bool waserrors = new bool();
            bool tieserrors = new bool();
            bool split2errors = new bool();
            bool optimalsplitkerrors = new bool();
            bool splitkerrors = new bool();

            waserrors = false;
            tieserrors = false;
            split2errors = false;
            splitkerrors = false;
            optimalsplitkerrors = false;
            maxn = 100;
            maxnq = 49;
            passcount = 10;
            
            //
            // Test ties
            //
            for(n=1; n<=maxn; n++)
            {
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // untied data, test DSTie
                    //
                    unset1di(ref p1);
                    unset1di(ref p2);
                    unset1di(ref pt1);
                    unset1di(ref pt2);
                    a = new double[n-1+1];
                    a0 = new double[n-1+1];
                    at = new double[n-1+1];
                    tmp = new double[n-1+1];
                    a[0] = 2*math.randomreal()-1;
                    tmp[0] = math.randomreal();
                    for(i=1; i<=n-1; i++)
                    {
                        
                        //
                        // A is randomly permuted
                        //
                        a[i] = a[i-1]+0.1*math.randomreal()+0.1;
                        tmp[i] = math.randomreal();
                    }
                    tsort.tagsortfastr(ref tmp, ref a, ref sortrbuf, ref sortrbuf2, n);
                    for(i=0; i<=n-1; i++)
                    {
                        a0[i] = a[i];
                        at[i] = a[i];
                    }
                    bdss.dstie(ref a0, n, ref ties, ref tiecount, ref p1, ref p2);
                    tsort.tagsort(ref at, n, ref pt1, ref pt2);
                    for(i=0; i<=n-1; i++)
                    {
                        tieserrors = tieserrors || p1[i]!=pt1[i];
                        tieserrors = tieserrors || p2[i]!=pt2[i];
                    }
                    tieserrors = tieserrors || tiecount!=n;
                    if( tiecount==n )
                    {
                        for(i=0; i<=n; i++)
                        {
                            tieserrors = tieserrors || ties[i]!=i;
                        }
                    }
                    
                    //
                    // tied data, test DSTie
                    //
                    unset1di(ref p1);
                    unset1di(ref p2);
                    unset1di(ref pt1);
                    unset1di(ref pt2);
                    a = new double[n-1+1];
                    a0 = new double[n-1+1];
                    at = new double[n-1+1];
                    c1 = 0;
                    c0 = 0;
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = math.randominteger(2);
                        if( (double)(a[i])==(double)(0) )
                        {
                            c0 = c0+1;
                        }
                        else
                        {
                            c1 = c1+1;
                        }
                        a0[i] = a[i];
                        at[i] = a[i];
                    }
                    bdss.dstie(ref a0, n, ref ties, ref tiecount, ref p1, ref p2);
                    tsort.tagsort(ref at, n, ref pt1, ref pt2);
                    for(i=0; i<=n-1; i++)
                    {
                        tieserrors = tieserrors || p1[i]!=pt1[i];
                        tieserrors = tieserrors || p2[i]!=pt2[i];
                    }
                    if( c0==0 || c1==0 )
                    {
                        tieserrors = tieserrors || tiecount!=1;
                        if( tiecount==1 )
                        {
                            tieserrors = tieserrors || ties[0]!=0;
                            tieserrors = tieserrors || ties[1]!=n;
                        }
                    }
                    else
                    {
                        tieserrors = tieserrors || tiecount!=2;
                        if( tiecount==2 )
                        {
                            tieserrors = tieserrors || ties[0]!=0;
                            tieserrors = tieserrors || ties[1]!=c0;
                            tieserrors = tieserrors || ties[2]!=n;
                        }
                    }
                }
            }
            
            //
            // split-2
            //
            
            //
            // General tests for different N's
            //
            for(n=1; n<=maxn; n++)
            {
                a = new double[n-1+1];
                c = new int[n-1+1];
                
                //
                // one-tie test
                //
                if( n%2==0 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = n;
                        c[i] = i%2;
                    }
                    bdss.dsoptimalsplit2(a, c, n, ref info, ref threshold, ref pal, ref pbl, ref par, ref pbr, ref cve);
                    if( info!=-3 )
                    {
                        split2errors = true;
                        continue;
                    }
                }
                
                //
                // two-tie test
                //
                
                //
                // test #1
                //
                if( n>1 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = i/((n+1)/2);
                        c[i] = i/((n+1)/2);
                    }
                    bdss.dsoptimalsplit2(a, c, n, ref info, ref threshold, ref pal, ref pbl, ref par, ref pbr, ref cve);
                    if( info!=1 )
                    {
                        split2errors = true;
                        continue;
                    }
                    split2errors = split2errors || (double)(Math.Abs(threshold-0.5))>(double)(100*math.machineepsilon);
                    split2errors = split2errors || (double)(Math.Abs(pal-1))>(double)(100*math.machineepsilon);
                    split2errors = split2errors || (double)(Math.Abs(pbl-0))>(double)(100*math.machineepsilon);
                    split2errors = split2errors || (double)(Math.Abs(par-0))>(double)(100*math.machineepsilon);
                    split2errors = split2errors || (double)(Math.Abs(pbr-1))>(double)(100*math.machineepsilon);
                }
            }
            
            //
            // Special "CREDIT"-test (transparency coefficient)
            //
            n = 110;
            a = new double[n-1+1];
            c = new int[n-1+1];
            a[0] = 0.000;
            c[0] = 0;
            a[1] = 0.000;
            c[1] = 0;
            a[2] = 0.000;
            c[2] = 0;
            a[3] = 0.000;
            c[3] = 0;
            a[4] = 0.000;
            c[4] = 0;
            a[5] = 0.000;
            c[5] = 0;
            a[6] = 0.000;
            c[6] = 0;
            a[7] = 0.000;
            c[7] = 1;
            a[8] = 0.000;
            c[8] = 0;
            a[9] = 0.000;
            c[9] = 1;
            a[10] = 0.000;
            c[10] = 0;
            a[11] = 0.000;
            c[11] = 0;
            a[12] = 0.000;
            c[12] = 0;
            a[13] = 0.000;
            c[13] = 0;
            a[14] = 0.000;
            c[14] = 0;
            a[15] = 0.000;
            c[15] = 0;
            a[16] = 0.000;
            c[16] = 0;
            a[17] = 0.000;
            c[17] = 0;
            a[18] = 0.000;
            c[18] = 0;
            a[19] = 0.000;
            c[19] = 0;
            a[20] = 0.000;
            c[20] = 0;
            a[21] = 0.000;
            c[21] = 0;
            a[22] = 0.000;
            c[22] = 1;
            a[23] = 0.000;
            c[23] = 0;
            a[24] = 0.000;
            c[24] = 0;
            a[25] = 0.000;
            c[25] = 0;
            a[26] = 0.000;
            c[26] = 0;
            a[27] = 0.000;
            c[27] = 1;
            a[28] = 0.000;
            c[28] = 0;
            a[29] = 0.000;
            c[29] = 1;
            a[30] = 0.000;
            c[30] = 0;
            a[31] = 0.000;
            c[31] = 1;
            a[32] = 0.000;
            c[32] = 0;
            a[33] = 0.000;
            c[33] = 1;
            a[34] = 0.000;
            c[34] = 0;
            a[35] = 0.030;
            c[35] = 0;
            a[36] = 0.030;
            c[36] = 0;
            a[37] = 0.050;
            c[37] = 0;
            a[38] = 0.070;
            c[38] = 1;
            a[39] = 0.110;
            c[39] = 0;
            a[40] = 0.110;
            c[40] = 1;
            a[41] = 0.120;
            c[41] = 0;
            a[42] = 0.130;
            c[42] = 0;
            a[43] = 0.140;
            c[43] = 0;
            a[44] = 0.140;
            c[44] = 0;
            a[45] = 0.140;
            c[45] = 0;
            a[46] = 0.150;
            c[46] = 0;
            a[47] = 0.150;
            c[47] = 0;
            a[48] = 0.170;
            c[48] = 0;
            a[49] = 0.190;
            c[49] = 1;
            a[50] = 0.200;
            c[50] = 0;
            a[51] = 0.200;
            c[51] = 0;
            a[52] = 0.250;
            c[52] = 0;
            a[53] = 0.250;
            c[53] = 0;
            a[54] = 0.260;
            c[54] = 0;
            a[55] = 0.270;
            c[55] = 0;
            a[56] = 0.280;
            c[56] = 0;
            a[57] = 0.310;
            c[57] = 0;
            a[58] = 0.310;
            c[58] = 0;
            a[59] = 0.330;
            c[59] = 0;
            a[60] = 0.330;
            c[60] = 0;
            a[61] = 0.340;
            c[61] = 0;
            a[62] = 0.340;
            c[62] = 0;
            a[63] = 0.370;
            c[63] = 0;
            a[64] = 0.380;
            c[64] = 1;
            a[65] = 0.380;
            c[65] = 0;
            a[66] = 0.410;
            c[66] = 0;
            a[67] = 0.460;
            c[67] = 0;
            a[68] = 0.520;
            c[68] = 0;
            a[69] = 0.530;
            c[69] = 0;
            a[70] = 0.540;
            c[70] = 0;
            a[71] = 0.560;
            c[71] = 0;
            a[72] = 0.560;
            c[72] = 0;
            a[73] = 0.570;
            c[73] = 0;
            a[74] = 0.600;
            c[74] = 0;
            a[75] = 0.600;
            c[75] = 0;
            a[76] = 0.620;
            c[76] = 0;
            a[77] = 0.650;
            c[77] = 0;
            a[78] = 0.660;
            c[78] = 0;
            a[79] = 0.680;
            c[79] = 0;
            a[80] = 0.700;
            c[80] = 0;
            a[81] = 0.750;
            c[81] = 0;
            a[82] = 0.770;
            c[82] = 0;
            a[83] = 0.770;
            c[83] = 0;
            a[84] = 0.770;
            c[84] = 0;
            a[85] = 0.790;
            c[85] = 0;
            a[86] = 0.810;
            c[86] = 0;
            a[87] = 0.840;
            c[87] = 0;
            a[88] = 0.860;
            c[88] = 0;
            a[89] = 0.870;
            c[89] = 0;
            a[90] = 0.890;
            c[90] = 0;
            a[91] = 0.900;
            c[91] = 1;
            a[92] = 0.900;
            c[92] = 0;
            a[93] = 0.910;
            c[93] = 0;
            a[94] = 0.940;
            c[94] = 0;
            a[95] = 0.950;
            c[95] = 0;
            a[96] = 0.952;
            c[96] = 0;
            a[97] = 0.970;
            c[97] = 0;
            a[98] = 0.970;
            c[98] = 0;
            a[99] = 0.980;
            c[99] = 0;
            a[100] = 1.000;
            c[100] = 0;
            a[101] = 1.000;
            c[101] = 0;
            a[102] = 1.000;
            c[102] = 0;
            a[103] = 1.000;
            c[103] = 0;
            a[104] = 1.000;
            c[104] = 0;
            a[105] = 1.020;
            c[105] = 0;
            a[106] = 1.090;
            c[106] = 0;
            a[107] = 1.130;
            c[107] = 0;
            a[108] = 1.840;
            c[108] = 0;
            a[109] = 2.470;
            c[109] = 0;
            bdss.dsoptimalsplit2(a, c, n, ref info, ref threshold, ref pal, ref pbl, ref par, ref pbr, ref cve);
            if( info!=1 )
            {
                split2errors = true;
            }
            else
            {
                split2errors = split2errors || (double)(Math.Abs(threshold-0.195))>(double)(100*math.machineepsilon);
                split2errors = split2errors || (double)(Math.Abs(pal-0.80))>(double)(0.02);
                split2errors = split2errors || (double)(Math.Abs(pbl-0.20))>(double)(0.02);
                split2errors = split2errors || (double)(Math.Abs(par-0.97))>(double)(0.02);
                split2errors = split2errors || (double)(Math.Abs(pbr-0.03))>(double)(0.02);
            }
            
            //
            // split-2 fast
            //
            
            //
            // General tests for different N's
            //
            for(n=1; n<=maxn; n++)
            {
                a = new double[n-1+1];
                c = new int[n-1+1];
                tiebuf = new int[n+1];
                cntbuf = new int[3+1];
                
                //
                // one-tie test
                //
                if( n%2==0 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = n;
                        c[i] = i%2;
                    }
                    bdss.dsoptimalsplit2fast(ref a, ref c, ref tiebuf, ref cntbuf, ref sortrbuf, ref sortibuf, n, 2, 0.00, ref info, ref threshold, ref rms, ref cvrms);
                    if( info!=-3 )
                    {
                        split2errors = true;
                        continue;
                    }
                }
                
                //
                // two-tie test
                //
                
                //
                // test #1
                //
                if( n>1 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = i/((n+1)/2);
                        c[i] = i/((n+1)/2);
                    }
                    bdss.dsoptimalsplit2fast(ref a, ref c, ref tiebuf, ref cntbuf, ref sortrbuf, ref sortibuf, n, 2, 0.00, ref info, ref threshold, ref rms, ref cvrms);
                    if( info!=1 )
                    {
                        split2errors = true;
                        continue;
                    }
                    split2errors = split2errors || (double)(Math.Abs(threshold-0.5))>(double)(100*math.machineepsilon);
                    split2errors = split2errors || (double)(Math.Abs(rms-0))>(double)(100*math.machineepsilon);
                    if( n==2 )
                    {
                        split2errors = split2errors || (double)(Math.Abs(cvrms-0.5))>(double)(100*math.machineepsilon);
                    }
                    else
                    {
                        if( n==3 )
                        {
                            split2errors = split2errors || (double)(Math.Abs(cvrms-Math.Sqrt((2*0+2*0+2*0.25)/6)))>(double)(100*math.machineepsilon);
                        }
                        else
                        {
                            split2errors = split2errors || (double)(Math.Abs(cvrms))>(double)(100*math.machineepsilon);
                        }
                    }
                }
            }
            
            //
            // special tests
            //
            n = 10;
            a = new double[n-1+1];
            c = new int[n-1+1];
            tiebuf = new int[n+1];
            cntbuf = new int[2*3-1+1];
            for(i=0; i<=n-1; i++)
            {
                a[i] = i;
                if( i<=n-3 )
                {
                    c[i] = 0;
                }
                else
                {
                    c[i] = i-(n-3);
                }
            }
            bdss.dsoptimalsplit2fast(ref a, ref c, ref tiebuf, ref cntbuf, ref sortrbuf, ref sortibuf, n, 3, 0.00, ref info, ref threshold, ref rms, ref cvrms);
            if( info!=1 )
            {
                split2errors = true;
            }
            else
            {
                split2errors = split2errors || (double)(Math.Abs(threshold-(n-2.5)))>(double)(100*math.machineepsilon);
                split2errors = split2errors || (double)(Math.Abs(rms-Math.Sqrt((0.25+0.25+0.25+0.25)/(3*n))))>(double)(100*math.machineepsilon);
                split2errors = split2errors || (double)(Math.Abs(cvrms-Math.Sqrt((double)(1+1+1+1)/(double)(3*n))))>(double)(100*math.machineepsilon);
            }
            
            //
            // Optimal split-K
            //
            
            //
            // General tests for different N's
            //
            for(n=1; n<=maxnq; n++)
            {
                a = new double[n-1+1];
                c = new int[n-1+1];
                
                //
                // one-tie test
                //
                if( n%2==0 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = n;
                        c[i] = i%2;
                    }
                    bdss.dsoptimalsplitk(a, c, n, 2, 2+math.randominteger(5), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=-3 )
                    {
                        optimalsplitkerrors = true;
                        continue;
                    }
                }
                
                //
                // two-tie test
                //
                
                //
                // test #1
                //
                if( n>1 )
                {
                    c0 = 0;
                    c1 = 0;
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = i/((n+1)/2);
                        c[i] = i/((n+1)/2);
                        if( c[i]==0 )
                        {
                            c0 = c0+1;
                        }
                        if( c[i]==1 )
                        {
                            c1 = c1+1;
                        }
                    }
                    bdss.dsoptimalsplitk(a, c, n, 2, 2+math.randominteger(5), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=1 )
                    {
                        optimalsplitkerrors = true;
                        continue;
                    }
                    optimalsplitkerrors = optimalsplitkerrors || ni!=2;
                    optimalsplitkerrors = optimalsplitkerrors || (double)(Math.Abs(thresholds[0]-0.5))>(double)(100*math.machineepsilon);
                    optimalsplitkerrors = optimalsplitkerrors || (double)(Math.Abs(cve-(-(c0*Math.Log((double)c0/(double)(c0+1)))-c1*Math.Log((double)c1/(double)(c1+1)))))>(double)(100*math.machineepsilon);
                }
                
                //
                // test #2
                //
                if( n>2 )
                {
                    c0 = 1+math.randominteger(n-1);
                    c1 = n-c0;
                    for(i=0; i<=n-1; i++)
                    {
                        if( i<c0 )
                        {
                            a[i] = 0;
                            c[i] = 0;
                        }
                        else
                        {
                            a[i] = 1;
                            c[i] = 1;
                        }
                    }
                    bdss.dsoptimalsplitk(a, c, n, 2, 2+math.randominteger(5), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=1 )
                    {
                        optimalsplitkerrors = true;
                        continue;
                    }
                    optimalsplitkerrors = optimalsplitkerrors || ni!=2;
                    optimalsplitkerrors = optimalsplitkerrors || (double)(Math.Abs(thresholds[0]-0.5))>(double)(100*math.machineepsilon);
                    optimalsplitkerrors = optimalsplitkerrors || (double)(Math.Abs(cve-(-(c0*Math.Log((double)c0/(double)(c0+1)))-c1*Math.Log((double)c1/(double)(c1+1)))))>(double)(100*math.machineepsilon);
                }
                
                //
                // multi-tie test
                //
                if( n>=16 )
                {
                    
                    //
                    // Multi-tie test.
                    //
                    // First NC-1 ties have C0 entries, remaining NC-th tie
                    // have C1 entries.
                    //
                    nc = (int)Math.Round(Math.Sqrt(n));
                    c0 = n/nc;
                    c1 = n-c0*(nc-1);
                    for(i=0; i<=nc-2; i++)
                    {
                        for(j=c0*i; j<=c0*(i+1)-1; j++)
                        {
                            a[j] = j;
                            c[j] = i;
                        }
                    }
                    for(j=c0*(nc-1); j<=n-1; j++)
                    {
                        a[j] = j;
                        c[j] = nc-1;
                    }
                    bdss.dsoptimalsplitk(a, c, n, nc, nc+math.randominteger(nc), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=1 )
                    {
                        optimalsplitkerrors = true;
                        continue;
                    }
                    optimalsplitkerrors = optimalsplitkerrors || ni!=nc;
                    if( ni==nc )
                    {
                        for(i=0; i<=nc-2; i++)
                        {
                            optimalsplitkerrors = optimalsplitkerrors || (double)(Math.Abs(thresholds[i]-(c0*(i+1)-1+0.5)))>(double)(100*math.machineepsilon);
                        }
                        cvr = -((nc-1)*c0*Math.Log((double)c0/(double)(c0+nc-1))+c1*Math.Log((double)c1/(double)(c1+nc-1)));
                        optimalsplitkerrors = optimalsplitkerrors || (double)(Math.Abs(cve-cvr))>(double)(100*math.machineepsilon);
                    }
                }
            }
            
            //
            // Non-optimal split-K
            //
            
            //
            // General tests for different N's
            //
            for(n=1; n<=maxnq; n++)
            {
                a = new double[n-1+1];
                c = new int[n-1+1];
                
                //
                // one-tie test
                //
                if( n%2==0 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = 99;
                        c[i] = i%2;
                    }
                    bdss.dssplitk(a, c, n, 2, 2+math.randominteger(5), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=-3 )
                    {
                        splitkerrors = true;
                        continue;
                    }
                }
                
                //
                // two-tie test
                //
                
                //
                // test #1
                //
                if( n>1 )
                {
                    c0 = 0;
                    c1 = 0;
                    for(i=0; i<=n-1; i++)
                    {
                        a[i] = i/((n+1)/2);
                        c[i] = i/((n+1)/2);
                        if( c[i]==0 )
                        {
                            c0 = c0+1;
                        }
                        if( c[i]==1 )
                        {
                            c1 = c1+1;
                        }
                    }
                    bdss.dssplitk(a, c, n, 2, 2+math.randominteger(5), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=1 )
                    {
                        splitkerrors = true;
                        continue;
                    }
                    splitkerrors = splitkerrors || ni!=2;
                    if( ni==2 )
                    {
                        splitkerrors = splitkerrors || (double)(Math.Abs(thresholds[0]-0.5))>(double)(100*math.machineepsilon);
                        splitkerrors = splitkerrors || (double)(Math.Abs(cve-(-(c0*Math.Log((double)c0/(double)(c0+1)))-c1*Math.Log((double)c1/(double)(c1+1)))))>(double)(100*math.machineepsilon);
                    }
                }
                
                //
                // test #2
                //
                if( n>2 )
                {
                    c0 = 1+math.randominteger(n-1);
                    c1 = n-c0;
                    for(i=0; i<=n-1; i++)
                    {
                        if( i<c0 )
                        {
                            a[i] = 0;
                            c[i] = 0;
                        }
                        else
                        {
                            a[i] = 1;
                            c[i] = 1;
                        }
                    }
                    bdss.dssplitk(a, c, n, 2, 2+math.randominteger(5), ref info, ref thresholds, ref ni, ref cve);
                    if( info!=1 )
                    {
                        splitkerrors = true;
                        continue;
                    }
                    splitkerrors = splitkerrors || ni!=2;
                    if( ni==2 )
                    {
                        splitkerrors = splitkerrors || (double)(Math.Abs(thresholds[0]-0.5))>(double)(100*math.machineepsilon);
                        splitkerrors = splitkerrors || (double)(Math.Abs(cve-(-(c0*Math.Log((double)c0/(double)(c0+1)))-c1*Math.Log((double)c1/(double)(c1+1)))))>(double)(100*math.machineepsilon);
                    }
                }
                
                //
                // multi-tie test
                //
                for(c0=4; c0<=n; c0++)
                {
                    if( (n%c0==0 && n/c0<=c0) && n/c0>1 )
                    {
                        nc = n/c0;
                        for(i=0; i<=nc-1; i++)
                        {
                            for(j=c0*i; j<=c0*(i+1)-1; j++)
                            {
                                a[j] = j;
                                c[j] = i;
                            }
                        }
                        bdss.dssplitk(a, c, n, nc, nc+math.randominteger(nc), ref info, ref thresholds, ref ni, ref cve);
                        if( info!=1 )
                        {
                            splitkerrors = true;
                            continue;
                        }
                        splitkerrors = splitkerrors || ni!=nc;
                        if( ni==nc )
                        {
                            for(i=0; i<=nc-2; i++)
                            {
                                splitkerrors = splitkerrors || (double)(Math.Abs(thresholds[i]-(c0*(i+1)-1+0.5)))>(double)(100*math.machineepsilon);
                            }
                            cvr = -(nc*c0*Math.Log((double)c0/(double)(c0+nc-1)));
                            splitkerrors = splitkerrors || (double)(Math.Abs(cve-cvr))>(double)(100*math.machineepsilon);
                        }
                    }
                }
            }
            
            //
            // report
            //
            waserrors = ((tieserrors || split2errors) || optimalsplitkerrors) || splitkerrors;
            if( !silent )
            {
                System.Console.Write("TESTING BASIC DATASET SUBROUTINES");
                System.Console.WriteLine();
                System.Console.Write("TIES:                               ");
                if( !tieserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("SPLIT-2:                            ");
                if( !split2errors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("OPTIMAL SPLIT-K:                    ");
                if( !optimalsplitkerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("SPLIT-K:                            ");
                if( !splitkerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testbdss(bool silent)
        {
            return testbdss(silent);
        }


        /*************************************************************************
        Unsets 1D array.
        *************************************************************************/
        private static void unset1di(ref int[] a)
        {
            a = new int[0+1];
            a[0] = math.randominteger(3)-1;
        }


    }
    public class testblasunit
    {
        public static bool testblas(bool silent)
        {
            bool result = new bool();
            int pass = 0;
            int passcount = 0;
            int n = 0;
            int i = 0;
            int i1 = 0;
            int i2 = 0;
            int j = 0;
            int j1 = 0;
            int j2 = 0;
            int l = 0;
            int k = 0;
            int r = 0;
            int i3 = 0;
            int j3 = 0;
            int col1 = 0;
            int col2 = 0;
            int row1 = 0;
            int row2 = 0;
            double[] x1 = new double[0];
            double[] x2 = new double[0];
            double[,] a = new double[0,0];
            double[,] b = new double[0,0];
            double[,] c1 = new double[0,0];
            double[,] c2 = new double[0,0];
            double err = 0;
            double e1 = 0;
            double e2 = 0;
            double e3 = 0;
            double v = 0;
            double scl1 = 0;
            double scl2 = 0;
            double scl3 = 0;
            bool was1 = new bool();
            bool was2 = new bool();
            bool trans1 = new bool();
            bool trans2 = new bool();
            double threshold = 0;
            bool n2errors = new bool();
            bool hsnerrors = new bool();
            bool amaxerrors = new bool();
            bool mverrors = new bool();
            bool iterrors = new bool();
            bool cterrors = new bool();
            bool mmerrors = new bool();
            bool waserrors = new bool();
            int i_ = 0;

            n2errors = false;
            amaxerrors = false;
            hsnerrors = false;
            mverrors = false;
            iterrors = false;
            cterrors = false;
            mmerrors = false;
            waserrors = false;
            threshold = 10000*math.machineepsilon;
            
            //
            // Test Norm2
            //
            passcount = 1000;
            e1 = 0;
            e2 = 0;
            e3 = 0;
            scl2 = 0.5*math.maxrealnumber;
            scl3 = 2*math.minrealnumber;
            for(pass=1; pass<=passcount; pass++)
            {
                n = 1+math.randominteger(1000);
                i1 = math.randominteger(10);
                i2 = n+i1-1;
                x1 = new double[i2+1];
                x2 = new double[i2+1];
                for(i=i1; i<=i2; i++)
                {
                    x1[i] = 2*math.randomreal()-1;
                }
                v = 0;
                for(i=i1; i<=i2; i++)
                {
                    v = v+math.sqr(x1[i]);
                }
                v = Math.Sqrt(v);
                e1 = Math.Max(e1, Math.Abs(v-blas.vectornorm2(x1, i1, i2)));
                for(i=i1; i<=i2; i++)
                {
                    x2[i] = scl2*x1[i];
                }
                e2 = Math.Max(e2, Math.Abs(v*scl2-blas.vectornorm2(x2, i1, i2)));
                for(i=i1; i<=i2; i++)
                {
                    x2[i] = scl3*x1[i];
                }
                e3 = Math.Max(e3, Math.Abs(v*scl3-blas.vectornorm2(x2, i1, i2)));
            }
            e2 = e2/scl2;
            e3 = e3/scl3;
            n2errors = ((double)(e1)>=(double)(threshold) || (double)(e2)>=(double)(threshold)) || (double)(e3)>=(double)(threshold);
            
            //
            // Testing VectorAbsMax, Column/Row AbsMax
            //
            x1 = new double[5+1];
            x1[1] = 2.0;
            x1[2] = 0.2;
            x1[3] = -1.3;
            x1[4] = 0.7;
            x1[5] = -3.0;
            amaxerrors = (blas.vectoridxabsmax(x1, 1, 5)!=5 || blas.vectoridxabsmax(x1, 1, 4)!=1) || blas.vectoridxabsmax(x1, 2, 4)!=3;
            n = 30;
            x1 = new double[n+1];
            a = new double[n+1, n+1];
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    a[i,j] = 2*math.randomreal()-1;
                }
            }
            was1 = false;
            was2 = false;
            for(pass=1; pass<=1000; pass++)
            {
                j = 1+math.randominteger(n);
                i1 = 1+math.randominteger(n);
                i2 = i1+math.randominteger(n+1-i1);
                for(i_=i1; i_<=i2;i_++)
                {
                    x1[i_] = a[i_,j];
                }
                if( blas.vectoridxabsmax(x1, i1, i2)!=blas.columnidxabsmax(a, i1, i2, j) )
                {
                    was1 = true;
                }
                i = 1+math.randominteger(n);
                j1 = 1+math.randominteger(n);
                j2 = j1+math.randominteger(n+1-j1);
                for(i_=j1; i_<=j2;i_++)
                {
                    x1[i_] = a[i,i_];
                }
                if( blas.vectoridxabsmax(x1, j1, j2)!=blas.rowidxabsmax(a, j1, j2, i) )
                {
                    was2 = true;
                }
            }
            amaxerrors = (amaxerrors || was1) || was2;
            
            //
            // Testing upper Hessenberg 1-norm
            //
            a = new double[3+1, 3+1];
            x1 = new double[3+1];
            a[1,1] = 2;
            a[1,2] = 3;
            a[1,3] = 1;
            a[2,1] = 4;
            a[2,2] = -5;
            a[2,3] = 8;
            a[3,1] = 99;
            a[3,2] = 3;
            a[3,3] = 1;
            hsnerrors = (double)(Math.Abs(blas.upperhessenberg1norm(a, 1, 3, 1, 3, ref x1)-11))>(double)(threshold);
            
            //
            // Testing MatrixVectorMultiply
            //
            a = new double[3+1, 5+1];
            x1 = new double[3+1];
            x2 = new double[2+1];
            a[2,3] = 2;
            a[2,4] = -1;
            a[2,5] = -1;
            a[3,3] = 1;
            a[3,4] = -2;
            a[3,5] = 2;
            x1[1] = 1;
            x1[2] = 2;
            x1[3] = 1;
            x2[1] = -1;
            x2[2] = -1;
            blas.matrixvectormultiply(a, 2, 3, 3, 5, false, x1, 1, 3, 1.0, ref x2, 1, 2, 1.0);
            blas.matrixvectormultiply(a, 2, 3, 3, 5, true, x2, 1, 2, 1.0, ref x1, 1, 3, 1.0);
            e1 = Math.Abs(x1[1]+5)+Math.Abs(x1[2]-8)+Math.Abs(x1[3]+1)+Math.Abs(x2[1]+2)+Math.Abs(x2[2]+2);
            x1[1] = 1;
            x1[2] = 2;
            x1[3] = 1;
            x2[1] = -1;
            x2[2] = -1;
            blas.matrixvectormultiply(a, 2, 3, 3, 5, false, x1, 1, 3, 1.0, ref x2, 1, 2, 0.0);
            blas.matrixvectormultiply(a, 2, 3, 3, 5, true, x2, 1, 2, 1.0, ref x1, 1, 3, 0.0);
            e2 = Math.Abs(x1[1]+3)+Math.Abs(x1[2]-3)+Math.Abs(x1[3]+1)+Math.Abs(x2[1]+1)+Math.Abs(x2[2]+1);
            mverrors = (double)(e1+e2)>=(double)(threshold);
            
            //
            // testing inplace transpose
            //
            n = 10;
            a = new double[n+1, n+1];
            b = new double[n+1, n+1];
            x1 = new double[n-1+1];
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    a[i,j] = math.randomreal();
                }
            }
            passcount = 10000;
            was1 = false;
            for(pass=1; pass<=passcount; pass++)
            {
                i1 = 1+math.randominteger(n);
                i2 = i1+math.randominteger(n-i1+1);
                j1 = 1+math.randominteger(n-(i2-i1));
                j2 = j1+(i2-i1);
                blas.copymatrix(a, i1, i2, j1, j2, ref b, i1, i2, j1, j2);
                blas.inplacetranspose(ref b, i1, i2, j1, j2, ref x1);
                for(i=i1; i<=i2; i++)
                {
                    for(j=j1; j<=j2; j++)
                    {
                        if( (double)(a[i,j])!=(double)(b[i1+(j-j1),j1+(i-i1)]) )
                        {
                            was1 = true;
                        }
                    }
                }
            }
            iterrors = was1;
            
            //
            // testing copy and transpose
            //
            n = 10;
            a = new double[n+1, n+1];
            b = new double[n+1, n+1];
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    a[i,j] = math.randomreal();
                }
            }
            passcount = 10000;
            was1 = false;
            for(pass=1; pass<=passcount; pass++)
            {
                i1 = 1+math.randominteger(n);
                i2 = i1+math.randominteger(n-i1+1);
                j1 = 1+math.randominteger(n);
                j2 = j1+math.randominteger(n-j1+1);
                blas.copyandtranspose(a, i1, i2, j1, j2, ref b, j1, j2, i1, i2);
                for(i=i1; i<=i2; i++)
                {
                    for(j=j1; j<=j2; j++)
                    {
                        if( (double)(a[i,j])!=(double)(b[j,i]) )
                        {
                            was1 = true;
                        }
                    }
                }
            }
            cterrors = was1;
            
            //
            // Testing MatrixMatrixMultiply
            //
            n = 10;
            a = new double[2*n+1, 2*n+1];
            b = new double[2*n+1, 2*n+1];
            c1 = new double[2*n+1, 2*n+1];
            c2 = new double[2*n+1, 2*n+1];
            x1 = new double[n+1];
            x2 = new double[n+1];
            for(i=1; i<=2*n; i++)
            {
                for(j=1; j<=2*n; j++)
                {
                    a[i,j] = math.randomreal();
                    b[i,j] = math.randomreal();
                }
            }
            passcount = 1000;
            was1 = false;
            for(pass=1; pass<=passcount; pass++)
            {
                for(i=1; i<=2*n; i++)
                {
                    for(j=1; j<=2*n; j++)
                    {
                        c1[i,j] = 2.1*i+3.1*j;
                        c2[i,j] = c1[i,j];
                    }
                }
                l = 1+math.randominteger(n);
                k = 1+math.randominteger(n);
                r = 1+math.randominteger(n);
                i1 = 1+math.randominteger(n);
                j1 = 1+math.randominteger(n);
                i2 = 1+math.randominteger(n);
                j2 = 1+math.randominteger(n);
                i3 = 1+math.randominteger(n);
                j3 = 1+math.randominteger(n);
                trans1 = (double)(math.randomreal())>(double)(0.5);
                trans2 = (double)(math.randomreal())>(double)(0.5);
                if( trans1 )
                {
                    col1 = l;
                    row1 = k;
                }
                else
                {
                    col1 = k;
                    row1 = l;
                }
                if( trans2 )
                {
                    col2 = k;
                    row2 = r;
                }
                else
                {
                    col2 = r;
                    row2 = k;
                }
                scl1 = math.randomreal();
                scl2 = math.randomreal();
                blas.matrixmatrixmultiply(a, i1, i1+row1-1, j1, j1+col1-1, trans1, b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, ref c1, i3, i3+l-1, j3, j3+r-1, scl2, ref x1);
                naivematrixmatrixmultiply(a, i1, i1+row1-1, j1, j1+col1-1, trans1, b, i2, i2+row2-1, j2, j2+col2-1, trans2, scl1, ref c2, i3, i3+l-1, j3, j3+r-1, scl2);
                err = 0;
                for(i=1; i<=l; i++)
                {
                    for(j=1; j<=r; j++)
                    {
                        err = Math.Max(err, Math.Abs(c1[i3+i-1,j3+j-1]-c2[i3+i-1,j3+j-1]));
                    }
                }
                if( (double)(err)>(double)(threshold) )
                {
                    was1 = true;
                    break;
                }
            }
            mmerrors = was1;
            
            //
            // report
            //
            waserrors = (((((n2errors || amaxerrors) || hsnerrors) || mverrors) || iterrors) || cterrors) || mmerrors;
            if( !silent )
            {
                System.Console.Write("TESTING BLAS");
                System.Console.WriteLine();
                System.Console.Write("VectorNorm2:                             ");
                if( n2errors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("AbsMax (vector/row/column):              ");
                if( amaxerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("UpperHessenberg1Norm:                    ");
                if( hsnerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("MatrixVectorMultiply:                    ");
                if( mverrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("InplaceTranspose:                        ");
                if( iterrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("CopyAndTranspose:                        ");
                if( cterrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("MatrixMatrixMultiply:                    ");
                if( mmerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testblas(bool silent)
        {
            return testblas(silent);
        }


        private static void naivematrixmatrixmultiply(double[,] a,
            int ai1,
            int ai2,
            int aj1,
            int aj2,
            bool transa,
            double[,] b,
            int bi1,
            int bi2,
            int bj1,
            int bj2,
            bool transb,
            double alpha,
            ref double[,] c,
            int ci1,
            int ci2,
            int cj1,
            int cj2,
            double beta)
        {
            int arows = 0;
            int acols = 0;
            int brows = 0;
            int bcols = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            int r = 0;
            double v = 0;
            double[] x1 = new double[0];
            double[] x2 = new double[0];
            int i_ = 0;
            int i1_ = 0;

            
            //
            // Setup
            //
            if( !transa )
            {
                arows = ai2-ai1+1;
                acols = aj2-aj1+1;
            }
            else
            {
                arows = aj2-aj1+1;
                acols = ai2-ai1+1;
            }
            if( !transb )
            {
                brows = bi2-bi1+1;
                bcols = bj2-bj1+1;
            }
            else
            {
                brows = bj2-bj1+1;
                bcols = bi2-bi1+1;
            }
            alglib.ap.assert(acols==brows, "NaiveMatrixMatrixMultiply: incorrect matrix sizes!");
            if( ((arows<=0 || acols<=0) || brows<=0) || bcols<=0 )
            {
                return;
            }
            l = arows;
            r = bcols;
            k = acols;
            x1 = new double[k+1];
            x2 = new double[k+1];
            for(i=1; i<=l; i++)
            {
                for(j=1; j<=r; j++)
                {
                    if( !transa )
                    {
                        if( !transb )
                        {
                            i1_ = (aj1)-(bi1);
                            v = 0.0;
                            for(i_=bi1; i_<=bi2;i_++)
                            {
                                v += b[i_,bj1+j-1]*a[ai1+i-1,i_+i1_];
                            }
                        }
                        else
                        {
                            i1_ = (aj1)-(bj1);
                            v = 0.0;
                            for(i_=bj1; i_<=bj2;i_++)
                            {
                                v += b[bi1+j-1,i_]*a[ai1+i-1,i_+i1_];
                            }
                        }
                    }
                    else
                    {
                        if( !transb )
                        {
                            i1_ = (ai1)-(bi1);
                            v = 0.0;
                            for(i_=bi1; i_<=bi2;i_++)
                            {
                                v += b[i_,bj1+j-1]*a[i_+i1_,aj1+i-1];
                            }
                        }
                        else
                        {
                            i1_ = (ai1)-(bj1);
                            v = 0.0;
                            for(i_=bj1; i_<=bj2;i_++)
                            {
                                v += b[bi1+j-1,i_]*a[i_+i1_,aj1+i-1];
                            }
                        }
                    }
                    if( (double)(beta)==(double)(0) )
                    {
                        c[ci1+i-1,cj1+j-1] = alpha*v;
                    }
                    else
                    {
                        c[ci1+i-1,cj1+j-1] = beta*c[ci1+i-1,cj1+j-1]+alpha*v;
                    }
                }
            }
        }


    }
    public class testclusteringunit
    {
        /*************************************************************************
        Testing clustering
        *************************************************************************/
        public static bool testclustering(bool silent)
        {
            bool result = new bool();
            bool waserrors = new bool();
            bool basicahcerrors = new bool();
            bool ahcerrors = new bool();
            bool kmeansconverrors = new bool();
            bool kmeanssimpleerrors = new bool();
            bool kmeansothererrors = new bool();
            bool kmeansrestartserrors = new bool();
            int passcount = 0;
            int nf = 0;
            int nc = 0;

            
            //
            // AHC tests
            //
            basicahcerrors = basicahctests();
            ahcerrors = advancedahctests();
            
            //
            // k-means tests
            //
            passcount = 10;
            kmeansconverrors = false;
            kmeansothererrors = false;
            kmeanssimpleerrors = false;
            kmeansrestartserrors = false;
            kmeansspecialtests(ref kmeansothererrors);
            kmeansinfinitelooptest(ref kmeansothererrors);
            kmeansrestartstest(ref kmeansconverrors, ref kmeansrestartserrors);
            for(nf=1; nf<=5; nf++)
            {
                for(nc=1; nc<=5; nc++)
                {
                    kmeanssimpletest1(nf, nc, passcount, ref kmeansconverrors, ref kmeansothererrors, ref kmeanssimpleerrors);
                }
            }
            
            //
            // Results
            //
            waserrors = false;
            waserrors = waserrors || (basicahcerrors || ahcerrors);
            waserrors = waserrors || (((kmeansconverrors || kmeansothererrors) || kmeanssimpleerrors) || kmeansrestartserrors);
            if( !silent )
            {
                System.Console.Write("TESTING CLUSTERING");
                System.Console.WriteLine();
                System.Console.Write("AHC:                                ");
                System.Console.WriteLine();
                System.Console.Write("* BASIC TESTS                       ");
                if( !basicahcerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* GENERAL TESTS                     ");
                if( !ahcerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("K-MEANS:                            ");
                System.Console.WriteLine();
                System.Console.Write("* CONVERGENCE                       ");
                if( !kmeansconverrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* SIMPLE TASKS                      ");
                if( !kmeanssimpleerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* OTHER PROPERTIES                  ");
                if( !kmeansothererrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* RESTARTS PROPERTIES               ");
                if( !kmeansrestartserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testclustering(bool silent)
        {
            return testclustering(silent);
        }


        /*************************************************************************
        Basic agglomerative hierarchical clustering tests:
        returns True on failure, False on success.

        Basic tests study algorithm behavior on simple,  hand-made  datasets  with
        small number of points (1..10).
        *************************************************************************/
        private static bool basicahctests()
        {
            bool result = new bool();
            clustering.clusterizerstate s = new clustering.clusterizerstate();
            clustering.ahcreport rep = new clustering.ahcreport();
            double[,] xy = new double[0,0];
            double[,] d = new double[0,0];
            double[,] c = new double[0,0];
            bool berr = new bool();
            int ahcalgo = 0;
            int i = 0;
            int j = 0;
            int npoints = 0;
            int k = 0;
            int[] cidx = new int[0];
            int[] cz = new int[0];
            int[] cidx2 = new int[0];
            int[] cz2 = new int[0];

            result = true;
            
            //
            // Test on empty problem
            //
            clustering.clusterizercreate(s);
            clustering.clusterizerrunahc(s, rep);
            if( rep.npoints!=0 )
            {
                return result;
            }
            
            //
            // Test on problem with one point
            //
            xy = new double[1, 2];
            xy[0,0] = math.randomreal();
            xy[0,1] = math.randomreal();
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 1, 2, 0);
            clustering.clusterizerrunahc(s, rep);
            if( rep.npoints!=1 )
            {
                return result;
            }
            
            //
            // Test on problem with two points
            //
            xy = new double[2, 2];
            xy[0,0] = math.randomreal();
            xy[0,1] = math.randomreal();
            xy[1,0] = math.randomreal();
            xy[1,1] = math.randomreal();
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 2, 2, 0);
            clustering.clusterizerrunahc(s, rep);
            if( (rep.npoints!=2 || alglib.ap.rows(rep.z)!=1) || alglib.ap.cols(rep.z)!=2 )
            {
                return result;
            }
            if( rep.z[0,0]!=0 || rep.z[0,1]!=1 )
            {
                return result;
            }
            
            //
            // Test on specially designed problem which should have
            // following dendrogram:
            //
            //   ------
            //   |    |
            // ----  ----
            // |  |  |  |
            // 0  1  2  3
            //
            // ...with first merge performed on 0 and 1, second merge
            // performed on 2 and 3. Complete linkage is used.
            //
            // Additionally we test ClusterizerSeparatedByDist() on this
            // problem for different distances. Test is performed by
            // comparing function result with ClusterizerGetKClusters()
            // for known K.
            //
            xy = new double[4, 1];
            xy[0,0] = 0.0;
            xy[1,0] = 1.0;
            xy[2,0] = 3.0;
            xy[3,0] = 4.1;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 4, 1, 0);
            clustering.clusterizersetahcalgo(s, 0);
            clustering.clusterizerrunahc(s, rep);
            if( (((rep.npoints!=4 || alglib.ap.rows(rep.z)!=3) || alglib.ap.cols(rep.z)!=2) || alglib.ap.rows(rep.pz)!=3) || alglib.ap.cols(rep.pz)!=2 )
            {
                return result;
            }
            berr = false;
            berr = (berr || rep.z[0,0]!=0) || rep.z[0,1]!=1;
            berr = (berr || rep.z[1,0]!=2) || rep.z[1,1]!=3;
            berr = (berr || rep.z[2,0]!=4) || rep.z[2,1]!=5;
            berr = (((berr || rep.p[0]!=0) || rep.p[1]!=1) || rep.p[2]!=2) || rep.p[3]!=3;
            berr = (berr || rep.pz[0,0]!=0) || rep.pz[0,1]!=1;
            berr = (berr || rep.pz[1,0]!=2) || rep.pz[1,1]!=3;
            berr = (berr || rep.pz[2,0]!=4) || rep.pz[2,1]!=5;
            berr = (((berr || rep.pm[0,0]!=0) || rep.pm[0,1]!=0) || rep.pm[0,2]!=1) || rep.pm[0,3]!=1;
            berr = (((berr || rep.pm[1,0]!=2) || rep.pm[1,1]!=2) || rep.pm[1,2]!=3) || rep.pm[1,3]!=3;
            berr = (((berr || rep.pm[2,0]!=0) || rep.pm[2,1]!=1) || rep.pm[2,2]!=2) || rep.pm[2,3]!=3;
            if( berr )
            {
                return result;
            }
            clustering.clusterizerseparatedbydist(rep, 0.5, ref k, ref cidx, ref cz);
            clustering.clusterizergetkclusters(rep, 4, ref cidx2, ref cz2);
            if( k!=4 )
            {
                return result;
            }
            if( ((cidx[0]!=cidx2[0] || cidx[1]!=cidx2[1]) || cidx[2]!=cidx2[2]) || cidx[3]!=cidx2[3] )
            {
                return result;
            }
            if( ((cz[0]!=cz2[0] || cz[1]!=cz2[1]) || cz[2]!=cz2[2]) || cz[3]!=cz2[3] )
            {
                return result;
            }
            clustering.clusterizerseparatedbydist(rep, 1.05, ref k, ref cidx, ref cz);
            clustering.clusterizergetkclusters(rep, 3, ref cidx2, ref cz2);
            if( k!=3 )
            {
                return result;
            }
            if( ((cidx[0]!=cidx2[0] || cidx[1]!=cidx2[1]) || cidx[2]!=cidx2[2]) || cidx[3]!=cidx2[3] )
            {
                return result;
            }
            if( (cz[0]!=cz2[0] || cz[1]!=cz2[1]) || cz[2]!=cz2[2] )
            {
                return result;
            }
            clustering.clusterizerseparatedbydist(rep, 1.15, ref k, ref cidx, ref cz);
            clustering.clusterizergetkclusters(rep, 2, ref cidx2, ref cz2);
            if( k!=2 )
            {
                return result;
            }
            if( ((cidx[0]!=cidx2[0] || cidx[1]!=cidx2[1]) || cidx[2]!=cidx2[2]) || cidx[3]!=cidx2[3] )
            {
                return result;
            }
            if( cz[0]!=cz2[0] || cz[1]!=cz2[1] )
            {
                return result;
            }
            
            //
            // Test on specially designed problem with Pearson distance
            // which should have following dendrogram:
            //
            //   ------
            //   |    |
            // ----  ----
            // |  |  |  |
            // 0  1  2  3
            //
            // This problem is used to test ClusterizerSeparatedByDist().
            // The test is performed by comparing function result with
            // ClusterizerGetKClusters() for known K.
            //
            // NOTE:
            // * corr(a0,a1) = 0.866
            // * corr(a2,a3) = 0.990
            // * corr(a0/a1, a2/a3)<=0.5
            //
            xy = new double[4, 3];
            xy[0,0] = 0.3;
            xy[0,1] = 0.5;
            xy[0,2] = 0.3;
            xy[1,0] = 0.3;
            xy[1,1] = 0.5;
            xy[1,2] = 0.4;
            xy[2,0] = 0.1;
            xy[2,1] = 0.5;
            xy[2,2] = 0.9;
            xy[3,0] = 0.1;
            xy[3,1] = 0.4;
            xy[3,2] = 0.9;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 4, 3, 10);
            clustering.clusterizersetahcalgo(s, 1);
            clustering.clusterizerrunahc(s, rep);
            clustering.clusterizerseparatedbycorr(rep, 0.999, ref k, ref cidx, ref cz);
            clustering.clusterizergetkclusters(rep, 4, ref cidx2, ref cz2);
            if( k!=4 )
            {
                return result;
            }
            if( ((cidx[0]!=cidx2[0] || cidx[1]!=cidx2[1]) || cidx[2]!=cidx2[2]) || cidx[3]!=cidx2[3] )
            {
                return result;
            }
            if( ((cz[0]!=cz2[0] || cz[1]!=cz2[1]) || cz[2]!=cz2[2]) || cz[3]!=cz2[3] )
            {
                return result;
            }
            clustering.clusterizerseparatedbycorr(rep, 0.900, ref k, ref cidx, ref cz);
            clustering.clusterizergetkclusters(rep, 3, ref cidx2, ref cz2);
            if( k!=3 )
            {
                return result;
            }
            if( ((cidx[0]!=cidx2[0] || cidx[1]!=cidx2[1]) || cidx[2]!=cidx2[2]) || cidx[3]!=cidx2[3] )
            {
                return result;
            }
            if( (cz[0]!=cz2[0] || cz[1]!=cz2[1]) || cz[2]!=cz2[2] )
            {
                return result;
            }
            clustering.clusterizerseparatedbycorr(rep, 0.600, ref k, ref cidx, ref cz);
            clustering.clusterizergetkclusters(rep, 2, ref cidx2, ref cz2);
            if( k!=2 )
            {
                return result;
            }
            if( ((cidx[0]!=cidx2[0] || cidx[1]!=cidx2[1]) || cidx[2]!=cidx2[2]) || cidx[3]!=cidx2[3] )
            {
                return result;
            }
            if( cz[0]!=cz2[0] || cz[1]!=cz2[1] )
            {
                return result;
            }
            
            //
            // Single linkage vs. complete linkage
            //
            xy = new double[6, 1];
            xy[0,0] = 0.0;
            xy[1,0] = 1.0;
            xy[2,0] = 2.1;
            xy[3,0] = 3.3;
            xy[4,0] = 6.0;
            xy[5,0] = 4.6;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 6, 1, 0);
            clustering.clusterizersetahcalgo(s, 0);
            clustering.clusterizerrunahc(s, rep);
            if( rep.npoints!=6 || alglib.ap.len(rep.p)!=6 )
            {
                return result;
            }
            if( ((alglib.ap.rows(rep.z)!=5 || alglib.ap.cols(rep.z)!=2) || alglib.ap.rows(rep.pz)!=5) || alglib.ap.cols(rep.pz)!=2 )
            {
                return result;
            }
            berr = false;
            berr = berr || rep.p[0]!=2;
            berr = berr || rep.p[1]!=3;
            berr = berr || rep.p[2]!=4;
            berr = berr || rep.p[3]!=5;
            berr = berr || rep.p[4]!=0;
            berr = berr || rep.p[5]!=1;
            berr = (berr || rep.z[0,0]!=0) || rep.z[0,1]!=1;
            berr = (berr || rep.z[1,0]!=2) || rep.z[1,1]!=3;
            berr = (berr || rep.z[2,0]!=4) || rep.z[2,1]!=5;
            berr = (berr || rep.z[3,0]!=6) || rep.z[3,1]!=7;
            berr = (berr || rep.z[4,0]!=8) || rep.z[4,1]!=9;
            berr = (berr || rep.pz[0,0]!=2) || rep.pz[0,1]!=3;
            berr = (berr || rep.pz[1,0]!=4) || rep.pz[1,1]!=5;
            berr = (berr || rep.pz[2,0]!=0) || rep.pz[2,1]!=1;
            berr = (berr || rep.pz[3,0]!=6) || rep.pz[3,1]!=7;
            berr = (berr || rep.pz[4,0]!=8) || rep.pz[4,1]!=9;
            if( berr )
            {
                return result;
            }
            clustering.clusterizersetahcalgo(s, 1);
            clustering.clusterizerrunahc(s, rep);
            if( (rep.npoints!=6 || alglib.ap.rows(rep.z)!=5) || alglib.ap.cols(rep.z)!=2 )
            {
                return result;
            }
            berr = false;
            berr = (berr || rep.z[0,0]!=0) || rep.z[0,1]!=1;
            berr = (berr || rep.z[1,0]!=2) || rep.z[1,1]!=6;
            berr = (berr || rep.z[2,0]!=3) || rep.z[2,1]!=7;
            berr = (berr || rep.z[3,0]!=5) || rep.z[3,1]!=8;
            berr = (berr || rep.z[4,0]!=4) || rep.z[4,1]!=9;
            if( berr )
            {
                return result;
            }
            
            //
            // Test which differentiates complete linkage and average linkage from
            // single linkage:
            // * we have cluster C0={(-0.5), (0)},
            //   cluster C1={(19.0), (20.0), (21.0), (22.0), (23.0)},
            //   and point P between them - (10.0)
            // * we try three different strategies - single linkage, complete
            //   linkage, average linkage.
            // * any strategy will merge C0 first, then merge points of C1,
            //   and then merge P with C0 or C1 (depending on linkage type)
            // * we test that:
            //   a) C0 is merged first
            //   b) after 5 merges (including merge of C0), P is merged with C0 or C1
            //   c) P is merged with C1 when we have single linkage, with C0 otherwise
            //
            xy = new double[8, 1];
            xy[0,0] = -0.5;
            xy[1,0] = 0.0;
            xy[2,0] = 10.0;
            xy[3,0] = 19.0;
            xy[4,0] = 20.0;
            xy[5,0] = 21.0;
            xy[6,0] = 22.0;
            xy[7,0] = 23.0;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 8, 1, 0);
            for(ahcalgo=0; ahcalgo<=2; ahcalgo++)
            {
                clustering.clusterizersetahcalgo(s, ahcalgo);
                clustering.clusterizerrunahc(s, rep);
                if( (rep.npoints!=8 || alglib.ap.rows(rep.z)!=7) || alglib.ap.cols(rep.z)!=2 )
                {
                    return result;
                }
                if( rep.z[0,0]!=0 || rep.z[0,1]!=1 )
                {
                    return result;
                }
                if( rep.z[5,0]!=2 && rep.z[5,1]!=2 )
                {
                    return result;
                }
                if( rep.z[5,0]!=2 && rep.z[5,1]!=2 )
                {
                    return result;
                }
                if( (ahcalgo==0 || ahcalgo==2) && (rep.z[5,0]!=8 && rep.z[5,1]!=8) )
                {
                    return result;
                }
                if( ahcalgo==1 && (rep.z[5,0]==8 || rep.z[5,1]==8) )
                {
                    return result;
                }
            }
            
            //
            // Test which differentiates single linkage and average linkage from
            // complete linkage:
            // * we have cluster C0={(-2.5), (-2.0)},
            //   cluster C1={(19.0), (20.0), (21.0), (22.0), (23.0)},
            //   and point P between them - (10.0)
            // * we try three different strategies - single linkage, complete
            //   linkage, average linkage.
            // * any strategy will merge C0 first, then merge points of C1,
            //   and then merge P with C0 or C1 (depending on linkage type)
            // * we test that:
            //   a) C0 is merged first
            //   b) after 5 merges (including merge of C0), P is merged with C0 or C1
            //   c) P is merged with C0 when we have complete linkage, with C1 otherwise
            //
            xy = new double[8, 1];
            xy[0,0] = -2.5;
            xy[1,0] = -2.0;
            xy[2,0] = 10.0;
            xy[3,0] = 19.0;
            xy[4,0] = 20.0;
            xy[5,0] = 21.0;
            xy[6,0] = 22.0;
            xy[7,0] = 23.0;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 8, 1, 0);
            for(ahcalgo=0; ahcalgo<=2; ahcalgo++)
            {
                clustering.clusterizersetahcalgo(s, ahcalgo);
                clustering.clusterizerrunahc(s, rep);
                if( (rep.npoints!=8 || alglib.ap.rows(rep.z)!=7) || alglib.ap.cols(rep.z)!=2 )
                {
                    return result;
                }
                if( rep.z[0,0]!=0 || rep.z[0,1]!=1 )
                {
                    return result;
                }
                if( rep.z[5,0]!=2 && rep.z[5,1]!=2 )
                {
                    return result;
                }
                if( rep.z[5,0]!=2 && rep.z[5,1]!=2 )
                {
                    return result;
                }
                if( ahcalgo==0 && (rep.z[5,0]!=8 && rep.z[5,1]!=8) )
                {
                    return result;
                }
                if( (ahcalgo==1 || ahcalgo==2) && (rep.z[5,0]==8 || rep.z[5,1]==8) )
                {
                    return result;
                }
            }
            
            //
            // Test which differentiates weighred average linkage from unweighted average linkage:
            // * we have cluster C0={(0.0), (1.5), (2.5)},
            //   cluster C1={(7.5), (7.99)},
            //   and point P between them - (4.5)
            // * we try two different strategies - weighted average linkage and unweighted average linkage
            // * any strategy will merge C1 first, then merge points of C0,
            //   and then merge P with C0 or C1 (depending on linkage type)
            // * we test that:
            //   a) C1 is merged first, C0 is merged after that
            //   b) after first 3 merges P is merged with C0 or C1
            //   c) P is merged with C1 when we have weighted average linkage, with C0 otherwise
            //
            xy = new double[6, 1];
            xy[0,0] = 0.0;
            xy[1,0] = 1.5;
            xy[2,0] = 2.5;
            xy[3,0] = 4.5;
            xy[4,0] = 7.5;
            xy[5,0] = 7.99;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 6, 1, 0);
            for(ahcalgo=2; ahcalgo<=3; ahcalgo++)
            {
                clustering.clusterizersetahcalgo(s, ahcalgo);
                clustering.clusterizerrunahc(s, rep);
                if( (rep.npoints!=6 || alglib.ap.rows(rep.z)!=5) || alglib.ap.cols(rep.z)!=2 )
                {
                    return result;
                }
                if( rep.z[0,0]!=4 || rep.z[0,1]!=5 )
                {
                    return result;
                }
                if( rep.z[1,0]!=1 || rep.z[1,1]!=2 )
                {
                    return result;
                }
                if( rep.z[2,0]!=0 || rep.z[2,1]!=7 )
                {
                    return result;
                }
                if( rep.z[3,0]!=3 )
                {
                    return result;
                }
                if( ahcalgo==2 && rep.z[3,1]!=8 )
                {
                    return result;
                }
                if( ahcalgo==3 && rep.z[3,1]!=6 )
                {
                    return result;
                }
            }
            
            //
            // Test which checks correctness of Ward's method on very basic problem
            //
            xy = new double[4, 1];
            xy[0,0] = 0.0;
            xy[1,0] = 1.0;
            xy[2,0] = 3.1;
            xy[3,0] = 4.0;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, alglib.ap.rows(xy), alglib.ap.cols(xy), 2);
            clustering.clusterizergetdistances(xy, alglib.ap.rows(xy), alglib.ap.cols(xy), 2, ref d);
            clustering.clusterizersetahcalgo(s, 4);
            clustering.clusterizerrunahc(s, rep);
            if( errorsinmerges(d, xy, alglib.ap.rows(xy), alglib.ap.cols(xy), rep, 4) )
            {
                return result;
            }
            
            //
            // One more Ward's test
            //
            xy = new double[8, 2];
            xy[0,0] = 0.4700566262;
            xy[0,1] = 0.4565938448;
            xy[1,0] = 0.2394499506;
            xy[1,1] = 0.1750209592;
            xy[2,0] = 0.6518417019;
            xy[2,1] = 0.6151370746;
            xy[3,0] = 0.9863942841;
            xy[3,1] = 0.7855012189;
            xy[4,0] = 0.1517812919;
            xy[4,1] = 0.2600174758;
            xy[5,0] = 0.7840203638;
            xy[5,1] = 0.9023597604;
            xy[6,0] = 0.2604194835;
            xy[6,1] = 0.9792704661;
            xy[7,0] = 0.6353096042;
            xy[7,1] = 0.8252606906;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, alglib.ap.rows(xy), alglib.ap.cols(xy), 2);
            clustering.clusterizergetdistances(xy, alglib.ap.rows(xy), alglib.ap.cols(xy), 2, ref d);
            clustering.clusterizersetahcalgo(s, 4);
            clustering.clusterizerrunahc(s, rep);
            if( rep.z[0,0]!=1 || rep.z[0,1]!=4 )
            {
                return result;
            }
            if( rep.z[1,0]!=5 || rep.z[1,1]!=7 )
            {
                return result;
            }
            if( rep.z[2,0]!=0 || rep.z[2,1]!=2 )
            {
                return result;
            }
            if( rep.z[3,0]!=3 || rep.z[3,1]!=9 )
            {
                return result;
            }
            if( rep.z[4,0]!=10 || rep.z[4,1]!=11 )
            {
                return result;
            }
            if( rep.z[5,0]!=6 || rep.z[5,1]!=12 )
            {
                return result;
            }
            if( rep.z[6,0]!=8 || rep.z[6,1]!=13 )
            {
                return result;
            }
            if( errorsinmerges(d, xy, alglib.ap.rows(xy), alglib.ap.cols(xy), rep, 4) )
            {
                return result;
            }
            
            //
            // Ability to solve problems with zero distance matrix
            //
            npoints = 20;
            d = new double[npoints, npoints];
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=npoints-1; j++)
                {
                    d[i,j] = 0.0;
                }
            }
            for(ahcalgo=0; ahcalgo<=4; ahcalgo++)
            {
                clustering.clusterizercreate(s);
                clustering.clusterizersetdistances(s, d, npoints, true);
                clustering.clusterizersetahcalgo(s, ahcalgo);
                clustering.clusterizerrunahc(s, rep);
                if( (rep.npoints!=npoints || alglib.ap.rows(rep.z)!=npoints-1) || alglib.ap.cols(rep.z)!=2 )
                {
                    return result;
                }
            }
            
            //
            // Test GetKClusters()
            //
            xy = new double[8, 1];
            xy[0,0] = -2.5;
            xy[1,0] = -2.0;
            xy[2,0] = 10.0;
            xy[3,0] = 19.0;
            xy[4,0] = 20.0;
            xy[5,0] = 21.0;
            xy[6,0] = 22.0;
            xy[7,0] = 23.0;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, 8, 1, 0);
            clustering.clusterizersetahcalgo(s, 0);
            clustering.clusterizerrunahc(s, rep);
            clustering.clusterizergetkclusters(rep, 3, ref cidx, ref cz);
            if( ((((((cidx[0]!=1 || cidx[1]!=1) || cidx[2]!=0) || cidx[3]!=2) || cidx[4]!=2) || cidx[5]!=2) || cidx[6]!=2) || cidx[7]!=2 )
            {
                return result;
            }
            if( (cz[0]!=2 || cz[1]!=8) || cz[2]!=12 )
            {
                return result;
            }
            
            //
            // Test is done
            //
            result = false;
            return result;
        }


        /*************************************************************************
        Advanced  agglomerative  hierarchical  clustering  tests : returns True on
        failure, False on success.

        Advanced testing subroutine perform several automatically generated tests.
        *************************************************************************/
        private static bool advancedahctests()
        {
            bool result = new bool();
            clustering.clusterizerstate s = new clustering.clusterizerstate();
            clustering.ahcreport rep = new clustering.ahcreport();
            double[,] xy = new double[0,0];
            double[,] dm = new double[0,0];
            double[,] dm2 = new double[0,0];
            int[] idx = new int[0];
            int[] disttypes = new int[0];
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            int d = 0;
            int n = 0;
            int npoints = 0;
            int ahcalgo = 0;
            int disttype = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            int t = 0;
            int euclidean = 0;
            int i_ = 0;

            result = false;
            euclidean = 2;
            
            //
            // Test on D-dimensional problem:
            // * D = 2...5
            // * D clusters, each has N points;
            //   centers are located at x=(0 ... 1 ... 0);
            //   cluster radii are approximately 0.1
            // * single/complete/unweighted_average/weighted_average linkage/Ward's method are tested
            // * Euclidean distance is used, either:
            //   a) one given by distance matrix (ClusterizerSetDistances)
            //   b) one calculated from dataset (ClusterizerSetPoints)
            // * we have N*D points, and N*D-1 merges in total
            // * points are randomly rearranged after generation
            //
            // For all kinds of linkage we perform following test:
            // * for each point we remember index of its cluster
            //   (one which is determined during dataset generation)
            // * we clusterize points with ALGLIB capabilities
            // * we scan Rep.Z and perform first D*(N-1) merges
            // * for each merge we check that it merges points
            //   from same cluster;
            //
            // Additonally, we call ErrorsInMerges(). See function comments 
            // for more information about specific tests performed. This function
            // allows us to check that clusters are built exactly as specified by
            // definition of the clustering algorithm.
            //
            for(d=2; d<=5; d++)
            {
                for(ahcalgo=0; ahcalgo<=4; ahcalgo++)
                {
                    n = (int)Math.Round(Math.Pow(3, math.randominteger(3)));
                    npoints = d*n;
                    
                    //
                    // 1. generate dataset.
                    // 2. fill Idx (array of cluster indexes):
                    //    * first N*D elements store cluster indexes
                    //    * next D*(N-1) elements are filled during merges
                    // 3. build distance matrix DM
                    //
                    xy = new double[n*d, d];
                    idx = new int[n*d+d*(n-1)];
                    for(i=0; i<=n*d-1; i++)
                    {
                        for(j=0; j<=d-1; j++)
                        {
                            xy[i,j] = 0.2*math.randomreal()-0.1;
                        }
                        xy[i,i%d] = xy[i,i%d]+1.0;
                        idx[i] = i%d;
                    }
                    for(i=0; i<=n*d-1; i++)
                    {
                        k = math.randominteger(n*d);
                        if( k!=i )
                        {
                            for(j=0; j<=d-1; j++)
                            {
                                v = xy[i,j];
                                xy[i,j] = xy[k,j];
                                xy[k,j] = v;
                            }
                            t = idx[k];
                            idx[k] = idx[i];
                            idx[i] = t;
                        }
                    }
                    dm = new double[npoints, npoints];
                    x0 = new double[d];
                    x1 = new double[d];
                    for(i=0; i<=npoints-1; i++)
                    {
                        for(j=0; j<=npoints-1; j++)
                        {
                            for(i_=0; i_<=d-1;i_++)
                            {
                                x0[i_] = xy[i,i_];
                            }
                            for(i_=0; i_<=d-1;i_++)
                            {
                                x1[i_] = xy[j,i_];
                            }
                            dm[i,j] = distfunc(x0, x1, d, euclidean);
                        }
                    }
                    
                    //
                    // Clusterize with SetPoints()
                    //
                    clustering.clusterizercreate(s);
                    clustering.clusterizersetpoints(s, xy, n*d, d, euclidean);
                    clustering.clusterizersetahcalgo(s, ahcalgo);
                    clustering.clusterizerrunahc(s, rep);
                    
                    //
                    // Tests:
                    // * replay first D*(N-1) merges; these merges should take place
                    //   within clusters, intercluster merges will be performed at the
                    //   last stages of the processing.
                    // * test with ErrorsInMerges()
                    //
                    if( rep.npoints!=npoints )
                    {
                        result = true;
                        return result;
                    }
                    for(i=0; i<=d*(n-1)-1; i++)
                    {
                        
                        //
                        // Check correctness of I-th row of Z
                        //
                        if( (rep.z[i,0]<0 || rep.z[i,0]>=rep.z[i,1]) || rep.z[i,1]>=d*n+i )
                        {
                            result = true;
                            return result;
                        }
                        
                        //
                        // Check that merge is performed within cluster
                        //
                        if( idx[rep.z[i,0]]!=idx[rep.z[i,1]] )
                        {
                            result = true;
                            return result;
                        }
                        
                        //
                        // Write new entry of Idx.
                        // Both points from the same cluster, so result of the merge
                        // belongs to the same cluster
                        //
                        idx[n*d+i] = idx[rep.z[i,1]];
                    }
                    if( ((ahcalgo==0 || ahcalgo==1) || ahcalgo==2) || ahcalgo==4 )
                    {
                        if( errorsinmerges(dm, xy, d*n, d, rep, ahcalgo) )
                        {
                            result = true;
                            return result;
                        }
                    }
                    
                    //
                    // Clusterize one more time, now with distance matrix
                    //
                    clustering.clusterizercreate(s);
                    clustering.clusterizersetdistances(s, dm, n*d, (double)(math.randomreal())>(double)(0.5));
                    clustering.clusterizersetahcalgo(s, ahcalgo);
                    clustering.clusterizerrunahc(s, rep);
                    
                    //
                    // Tests:
                    // * replay first D*(N-1) merges; these merges should take place
                    //   within clusters, intercluster merges will be performed at the
                    //   last stages of the processing.
                    // * test with ErrorsInMerges()
                    //
                    if( rep.npoints!=npoints )
                    {
                        result = true;
                        return result;
                    }
                    for(i=0; i<=d*(n-1)-1; i++)
                    {
                        
                        //
                        // Check correctness of I-th row of Z
                        //
                        if( (rep.z[i,0]<0 || rep.z[i,0]>=rep.z[i,1]) || rep.z[i,1]>=d*n+i )
                        {
                            result = true;
                            return result;
                        }
                        
                        //
                        // Check that merge is performed within cluster
                        //
                        if( idx[rep.z[i,0]]!=idx[rep.z[i,1]] )
                        {
                            result = true;
                            return result;
                        }
                        
                        //
                        // Write new entry of Idx.
                        // Both points from the same cluster, so result of the merge
                        // belongs to the same cluster
                        //
                        idx[n*d+i] = idx[rep.z[i,1]];
                    }
                    if( ((ahcalgo==0 || ahcalgo==1) || ahcalgo==2) || ahcalgo==4 )
                    {
                        if( errorsinmerges(dm, xy, d*n, d, rep, ahcalgo) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
            }
            
            //
            // Test on random D-dimensional problem:
            // * D = 2...5
            // * N=1..16 random points from unit hypercube
            // * single/complete/unweighted_average linkage/Ward's method are tested
            // * different distance functions are tested
            // * we call ErrorsInMerges() and we check distance matrix
            //   calculated by unit test against one returned by GetDistances()
            //
            disttypes = new int[9];
            disttypes[0] = 0;
            disttypes[1] = 1;
            disttypes[2] = 2;
            disttypes[3] = 10;
            disttypes[4] = 11;
            disttypes[5] = 12;
            disttypes[6] = 13;
            disttypes[7] = 20;
            disttypes[8] = 21;
            for(disttype=0; disttype<=alglib.ap.len(disttypes)-1; disttype++)
            {
                for(ahcalgo=0; ahcalgo<=4; ahcalgo++)
                {
                    if( ahcalgo==3 )
                    {
                        continue;
                    }
                    if( ahcalgo==4 && disttype!=2 )
                    {
                        continue;
                    }
                    npoints = (int)Math.Round(Math.Pow(2, math.randominteger(5)));
                    d = 2+math.randominteger(4);
                    
                    //
                    // Generate dataset and distance matrix
                    //
                    xy = new double[npoints, d];
                    for(i=0; i<=npoints-1; i++)
                    {
                        for(j=0; j<=d-1; j++)
                        {
                            xy[i,j] = math.randomreal();
                        }
                    }
                    dm = new double[npoints, npoints];
                    x0 = new double[d];
                    x1 = new double[d];
                    for(i=0; i<=npoints-1; i++)
                    {
                        for(j=0; j<=npoints-1; j++)
                        {
                            for(i_=0; i_<=d-1;i_++)
                            {
                                x0[i_] = xy[i,i_];
                            }
                            for(i_=0; i_<=d-1;i_++)
                            {
                                x1[i_] = xy[j,i_];
                            }
                            dm[i,j] = distfunc(x0, x1, d, disttypes[disttype]);
                        }
                    }
                    
                    //
                    // Clusterize
                    //
                    clustering.clusterizercreate(s);
                    clustering.clusterizersetpoints(s, xy, npoints, d, disttypes[disttype]);
                    clustering.clusterizersetahcalgo(s, ahcalgo);
                    clustering.clusterizerrunahc(s, rep);
                    
                    //
                    // Test with ErrorsInMerges()
                    //
                    if( errorsinmerges(dm, xy, npoints, d, rep, ahcalgo) )
                    {
                        result = true;
                        return result;
                    }
                    
                    //
                    // Test distance matrix
                    //
                    clustering.clusterizergetdistances(xy, npoints, d, disttypes[disttype], ref dm2);
                    for(i=0; i<=npoints-1; i++)
                    {
                        for(j=0; j<=npoints-1; j++)
                        {
                            if( !math.isfinite(dm2[i,j]) || (double)(Math.Abs(dm[i,j]-dm2[i,j]))>(double)(1.0E5*math.machineepsilon) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Simple test 1: ellipsoid in NF-dimensional space.
        compare k-means centers with random centers
        *************************************************************************/
        private static void kmeanssimpletest1(int nvars,
            int nc,
            int passcount,
            ref bool converrors,
            ref bool othererrors,
            ref bool simpleerrors)
        {
            int npoints = 0;
            int majoraxis = 0;
            double[,] xy = new double[0,0];
            double[] tmp = new double[0];
            double v = 0;
            int i = 0;
            int j = 0;
            int pass = 0;
            int restarts = 0;
            double ekmeans = 0;
            double erandom = 0;
            double dclosest = 0;
            int cclosest = 0;
            clustering.clusterizerstate s = new clustering.clusterizerstate();
            clustering.kmeansreport rep = new clustering.kmeansreport();
            int i_ = 0;

            npoints = nc*100;
            restarts = 5;
            passcount = 10;
            tmp = new double[nvars-1+1];
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // Fill
                //
                xy = new double[npoints-1+1, nvars-1+1];
                majoraxis = math.randominteger(nvars);
                for(i=0; i<=npoints-1; i++)
                {
                    rsphere(ref xy, nvars, i);
                    xy[i,majoraxis] = nc*xy[i,majoraxis];
                }
                
                //
                // Test
                //
                clustering.clusterizercreate(s);
                clustering.clusterizersetpoints(s, xy, npoints, nvars, 2);
                clustering.clusterizersetkmeanslimits(s, restarts, 0);
                clustering.clusterizerrunkmeans(s, nc, rep);
                if( rep.terminationtype<=0 )
                {
                    converrors = true;
                    return;
                }
                
                //
                // Test that XYC is correct mapping to cluster centers
                //
                for(i=0; i<=npoints-1; i++)
                {
                    cclosest = -1;
                    dclosest = math.maxrealnumber;
                    for(j=0; j<=nc-1; j++)
                    {
                        for(i_=0; i_<=nvars-1;i_++)
                        {
                            tmp[i_] = xy[i,i_];
                        }
                        for(i_=0; i_<=nvars-1;i_++)
                        {
                            tmp[i_] = tmp[i_] - rep.c[j,i_];
                        }
                        v = 0.0;
                        for(i_=0; i_<=nvars-1;i_++)
                        {
                            v += tmp[i_]*tmp[i_];
                        }
                        if( (double)(v)<(double)(dclosest) )
                        {
                            cclosest = j;
                            dclosest = v;
                        }
                    }
                    if( cclosest!=rep.cidx[i] )
                    {
                        othererrors = true;
                        return;
                    }
                }
                
                //
                // Use first NC rows of XY as random centers
                // (XY is totally random, so it is as good as any other choice).
                //
                // Compare potential functions.
                //
                ekmeans = 0;
                for(i=0; i<=npoints-1; i++)
                {
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = xy[i,i_];
                    }
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = tmp[i_] - rep.c[rep.cidx[i],i_];
                    }
                    v = 0.0;
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        v += tmp[i_]*tmp[i_];
                    }
                    ekmeans = ekmeans+v;
                }
                erandom = 0;
                for(i=0; i<=npoints-1; i++)
                {
                    dclosest = math.maxrealnumber;
                    v = 0;
                    for(j=0; j<=nc-1; j++)
                    {
                        for(i_=0; i_<=nvars-1;i_++)
                        {
                            tmp[i_] = xy[i,i_];
                        }
                        for(i_=0; i_<=nvars-1;i_++)
                        {
                            tmp[i_] = tmp[i_] - xy[j,i_];
                        }
                        v = 0.0;
                        for(i_=0; i_<=nvars-1;i_++)
                        {
                            v += tmp[i_]*tmp[i_];
                        }
                        if( (double)(v)<(double)(dclosest) )
                        {
                            dclosest = v;
                        }
                    }
                    erandom = erandom+v;
                }
                if( (double)(erandom)<(double)(ekmeans) )
                {
                    simpleerrors = true;
                    return;
                }
            }
        }


        /*************************************************************************
        This test perform several checks for special properties

        On failure sets error flag, on success leaves it unchanged.
        *************************************************************************/
        private static void kmeansspecialtests(ref bool othererrors)
        {
            int npoints = 0;
            int nfeatures = 0;
            int nclusters = 0;
            int initalgo = 0;
            double[,] xy = new double[0,0];
            double[,] c = new double[0,0];
            int idx0 = 0;
            int idx1 = 0;
            int idx2 = 0;
            int i = 0;
            int j = 0;
            int pass = 0;
            int passcount = 0;
            int separation = 0;
            int[] xyc = new int[0];
            int[] xycref = new int[0];
            double[] xydist2 = new double[0];
            double[] xydist2ref = new double[0];
            double[] energies = new double[0];
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            clustering.clusterizerstate s = new clustering.clusterizerstate();
            clustering.kmeansreport rep = new clustering.kmeansreport();
            alglib.smp.shared_pool bufferpool = new alglib.smp.shared_pool();
            apserv.apbuffers bufferseed = new apserv.apbuffers();
            int[] pointslist = new int[0];
            int[] featureslist = new int[0];
            int[] clusterslist = new int[0];

            hqrnd.hqrndrandomize(rs);
            
            //
            // Compare different initialization algorithms:
            // * dataset is K balls, chosen at random gaussian points, with
            //   radius equal to 2^(-Separation).
            // * we generate random sample, run k-means initialization algorithm
            //   and calculate mean energy for each initialization algorithm.
            //   In order to suppress Lloyd's iteration we use KmeansDbgNoIts
            //   debug flag.
            // * then, we compare mean energies; kmeans++ must be best one,
            //   random initialization must be worst one.
            //
            energies = new double[4];
            passcount = 1000;
            npoints = 100;
            nfeatures = 3;
            nclusters = 6;
            xy = new double[npoints, nfeatures];
            c = new double[nclusters, nfeatures];
            clustering.clusterizercreate(s);
            s.kmeansdbgnoits = true;
            for(separation=2; separation<=5; separation++)
            {
                
                //
                // Try different init algorithms
                //
                for(initalgo=1; initalgo<=3; initalgo++)
                {
                    energies[initalgo] = 0.0;
                    clustering.clusterizersetkmeansinit(s, initalgo);
                    for(pass=1; pass<=passcount; pass++)
                    {
                        
                        //
                        // Generate centers of balls
                        //
                        for(i=0; i<=nclusters-1; i++)
                        {
                            for(j=0; j<=nfeatures-1; j++)
                            {
                                c[i,j] = hqrnd.hqrndnormal(rs);
                            }
                        }
                        
                        //
                        // Generate points
                        //
                        for(i=0; i<=npoints-1; i++)
                        {
                            for(j=0; j<=nfeatures-1; j++)
                            {
                                xy[i,j] = hqrnd.hqrndnormal(rs)*Math.Pow(2, -separation)+c[i%nclusters,j];
                            }
                        }
                        
                        //
                        // Run clusterization
                        //
                        clustering.clusterizersetpoints(s, xy, npoints, nfeatures, 2);
                        clustering.clusterizerrunkmeans(s, nclusters, rep);
                        apserv.seterrorflag(ref othererrors, rep.terminationtype<=0);
                        energies[initalgo] = energies[initalgo]+rep.energy/passcount;
                    }
                }
                
                //
                // Compare
                //
                apserv.seterrorflag(ref othererrors, !((double)(energies[2])<(double)(energies[1])));
                apserv.seterrorflag(ref othererrors, !((double)(energies[3])<(double)(energies[1])));
            }
            
            //
            // Test distance calculation algorithm
            //
            pointslist = new int[6];
            pointslist[0] = 1;
            pointslist[1] = 10;
            pointslist[2] = 32;
            pointslist[3] = 100;
            pointslist[4] = 512;
            pointslist[5] = 8000;
            featureslist = new int[5];
            featureslist[0] = 1;
            featureslist[1] = 5;
            featureslist[2] = 32;
            featureslist[3] = 50;
            featureslist[4] = 96;
            clusterslist = new int[5];
            clusterslist[0] = 1;
            clusterslist[1] = 5;
            clusterslist[2] = 32;
            clusterslist[3] = 50;
            clusterslist[4] = 96;
            alglib.smp.ae_shared_pool_set_seed(bufferpool, bufferseed);
            for(idx0=0; idx0<=alglib.ap.len(pointslist)-1; idx0++)
            {
                for(idx1=0; idx1<=alglib.ap.len(featureslist)-1; idx1++)
                {
                    for(idx2=0; idx2<=alglib.ap.len(clusterslist)-1; idx2++)
                    {
                        npoints = pointslist[idx0];
                        nfeatures = featureslist[idx1];
                        nclusters = clusterslist[idx2];
                        xy = new double[npoints, nfeatures];
                        for(i=0; i<=npoints-1; i++)
                        {
                            for(j=0; j<=nfeatures-1; j++)
                            {
                                xy[i,j] = hqrnd.hqrndnormal(rs);
                            }
                        }
                        c = new double[nclusters, nfeatures];
                        for(i=0; i<=nclusters-1; i++)
                        {
                            for(j=0; j<=nfeatures-1; j++)
                            {
                                c[i,j] = hqrnd.hqrndnormal(rs);
                            }
                        }
                        xyc = new int[npoints];
                        xycref = new int[npoints];
                        xydist2 = new double[npoints];
                        xydist2ref = new double[npoints];
                        
                        //
                        // Test
                        //
                        clustering.kmeansupdatedistances(xy, 0, npoints, nfeatures, c, 0, nclusters, xyc, xydist2, bufferpool);
                        kmeansreferenceupdatedistances(xy, npoints, nfeatures, c, nclusters, xycref, xydist2ref);
                        for(i=0; i<=npoints-1; i++)
                        {
                            apserv.seterrorflag(ref othererrors, xyc[i]!=xycref[i]);
                            apserv.seterrorflag(ref othererrors, (double)(Math.Abs(xydist2[i]-xydist2ref[i]))>(double)(1.0E-6));
                        }
                    }
                }
            }
            
            //
            // Test degenerate dataset (less than NClusters distinct points)
            //
            for(nclusters=2; nclusters<=10; nclusters++)
            {
                for(initalgo=0; initalgo<=3; initalgo++)
                {
                    for(pass=1; pass<=10; pass++)
                    {
                        
                        //
                        // Initialize points. Two algorithms are used:
                        // * initialization by small integers (no rounding problems)
                        // * initialization by "long" fraction
                        //
                        npoints = 100;
                        nfeatures = 10;
                        xy = new double[npoints, nfeatures];
                        if( (double)(hqrnd.hqrndnormal(rs))>(double)(0) )
                        {
                            for(i=0; i<=nclusters-2; i++)
                            {
                                for(j=0; j<=nfeatures-1; j++)
                                {
                                    xy[i,j] = Math.Sin(hqrnd.hqrndnormal(rs));
                                }
                            }
                        }
                        else
                        {
                            for(i=0; i<=nclusters-2; i++)
                            {
                                for(j=0; j<=nfeatures-1; j++)
                                {
                                    xy[i,j] = hqrnd.hqrnduniformi(rs, 50);
                                }
                            }
                        }
                        for(i=nclusters-1; i<=npoints-1; i++)
                        {
                            idx0 = hqrnd.hqrnduniformi(rs, nclusters-1);
                            for(j=0; j<=nfeatures-1; j++)
                            {
                                xy[i,j] = xy[idx0,j];
                            }
                        }
                        
                        //
                        // Clusterize with unlimited number of iterations.
                        // Correct error code must be returned.
                        //
                        clustering.clusterizercreate(s);
                        clustering.clusterizersetpoints(s, xy, npoints, nfeatures, 2);
                        clustering.clusterizersetkmeanslimits(s, 1, 0);
                        clustering.clusterizersetkmeansinit(s, initalgo);
                        clustering.clusterizerrunkmeans(s, nclusters, rep);
                        apserv.seterrorflag(ref othererrors, rep.terminationtype!=-3);
                    }
                }
            }
        }


        /*************************************************************************
        This test checks algorithm ability to handle degenerate problems without
        causing infinite loop.
        *************************************************************************/
        private static void kmeansinfinitelooptest(ref bool othererrors)
        {
            int npoints = 0;
            int nfeatures = 0;
            int nclusters = 0;
            int restarts = 0;
            double[,] xy = new double[0,0];
            int i = 0;
            int j = 0;
            clustering.clusterizerstate s = new clustering.clusterizerstate();
            clustering.kmeansreport rep = new clustering.kmeansreport();

            
            //
            // Problem 1: all points are same.
            //
            // For NClusters=1 we must get correct solution, for NClusters>1 we must get failure.
            //
            npoints = 100;
            nfeatures = 1;
            restarts = 5;
            xy = new double[npoints, nfeatures];
            for(j=0; j<=nfeatures-1; j++)
            {
                xy[0,j] = math.randomreal();
            }
            for(i=1; i<=npoints-1; i++)
            {
                for(j=0; j<=nfeatures-1; j++)
                {
                    xy[i,j] = xy[0,j];
                }
            }
            nclusters = 1;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, npoints, nfeatures, 2);
            clustering.clusterizersetkmeanslimits(s, restarts, 0);
            clustering.clusterizerrunkmeans(s, nclusters, rep);
            othererrors = othererrors || rep.terminationtype<=0;
            for(i=0; i<=nfeatures-1; i++)
            {
                othererrors = othererrors || (double)(Math.Abs(rep.c[0,i]-xy[0,i]))>(double)(1000*math.machineepsilon);
            }
            for(i=0; i<=npoints-1; i++)
            {
                othererrors = othererrors || rep.cidx[i]!=0;
            }
            nclusters = 5;
            clustering.clusterizerrunkmeans(s, nclusters, rep);
            othererrors = othererrors || rep.terminationtype>0;
            
            //
            // Problem 2: degenerate dataset (report by Andreas).
            //
            npoints = 57;
            nfeatures = 1;
            restarts = 1;
            nclusters = 4;
            xy = new double[npoints, nfeatures];
            xy[0,0] = 12.244689632138986;
            xy[1,0] = 12.244689632138982;
            xy[2,0] = 12.244689632138986;
            xy[3,0] = 12.244689632138982;
            xy[4,0] = 12.244689632138986;
            xy[5,0] = 12.244689632138986;
            xy[6,0] = 12.244689632138986;
            xy[7,0] = 12.244689632138986;
            xy[8,0] = 12.244689632138986;
            xy[9,0] = 12.244689632138986;
            xy[10,0] = 12.244689632138989;
            xy[11,0] = 12.244689632138984;
            xy[12,0] = 12.244689632138986;
            xy[13,0] = 12.244689632138986;
            xy[14,0] = 12.244689632138989;
            xy[15,0] = 12.244689632138986;
            xy[16,0] = 12.244689632138986;
            xy[17,0] = 12.244689632138986;
            xy[18,0] = 12.244689632138986;
            xy[19,0] = 12.244689632138989;
            xy[20,0] = 12.244689632138972;
            xy[21,0] = 12.244689632138986;
            xy[22,0] = 12.244689632138986;
            xy[23,0] = 12.244689632138986;
            xy[24,0] = 12.244689632138984;
            xy[25,0] = 12.244689632138982;
            xy[26,0] = 12.244689632138986;
            xy[27,0] = 12.244689632138986;
            xy[28,0] = 12.244689632138986;
            xy[29,0] = 12.244689632138986;
            xy[30,0] = 12.244689632138986;
            xy[31,0] = 12.244689632138986;
            xy[32,0] = 12.244689632138986;
            xy[33,0] = 12.244689632138986;
            xy[34,0] = 12.244689632138986;
            xy[35,0] = 12.244689632138982;
            xy[36,0] = 12.244689632138989;
            xy[37,0] = 12.244689632138986;
            xy[38,0] = 12.244689632138986;
            xy[39,0] = 12.244689632138986;
            xy[40,0] = 12.244689632138986;
            xy[41,0] = 12.244689632138986;
            xy[42,0] = 12.244689632138986;
            xy[43,0] = 12.244689632138986;
            xy[44,0] = 12.244689632138986;
            xy[45,0] = 12.244689632138986;
            xy[46,0] = 12.244689632138986;
            xy[47,0] = 12.244689632138986;
            xy[48,0] = 12.244689632138986;
            xy[49,0] = 12.244689632138986;
            xy[50,0] = 12.244689632138984;
            xy[51,0] = 12.244689632138986;
            xy[52,0] = 12.244689632138986;
            xy[53,0] = 12.244689632138986;
            xy[54,0] = 12.244689632138986;
            xy[55,0] = 12.244689632138986;
            xy[56,0] = 12.244689632138986;
            clustering.clusterizercreate(s);
            clustering.clusterizersetpoints(s, xy, npoints, nfeatures, 2);
            clustering.clusterizersetkmeanslimits(s, restarts, 0);
            clustering.clusterizerrunkmeans(s, nclusters, rep);
            othererrors = othererrors || rep.terminationtype<=0;
        }


        /*************************************************************************
        This non-deterministic test checks that Restarts>1 significantly  improves
        quality of results.

        Subroutine generates random task 3 unit balls in 2D, each with 20  points,
        separated by 5 units wide gaps, and solves it  with  Restarts=1  and  with
        Restarts=5. Potential functions are compared,  outcome  of  the  trial  is
        either 0 or 1 (depending on what is better).

        Sequence of 1000 such tasks is  solved.  If  Restarts>1  actually  improve
        quality of solution, sum of outcome will be non-binomial.  If  it  doesn't
        matter, it will be binomially distributed.

        P.S. This test was added after report from Gianluca  Borello  who  noticed
        error in the handling of multiple restarts.
        *************************************************************************/
        private static void kmeansrestartstest(ref bool converrors,
            ref bool restartserrors)
        {
            int npoints = 0;
            int nvars = 0;
            int nclusters = 0;
            int clustersize = 0;
            int restarts = 0;
            int passcount = 0;
            double sigmathreshold = 0;
            double p = 0;
            double s = 0;
            double[,] xy = new double[0,0];
            double[] tmp = new double[0];
            int i = 0;
            int j = 0;
            int pass = 0;
            double ea = 0;
            double eb = 0;
            double v = 0;
            clustering.clusterizerstate state = new clustering.clusterizerstate();
            clustering.kmeansreport rep1 = new clustering.kmeansreport();
            clustering.kmeansreport rep2 = new clustering.kmeansreport();
            int i_ = 0;

            restarts = 5;
            passcount = 1000;
            clustersize = 20;
            nclusters = 3;
            nvars = 2;
            npoints = nclusters*clustersize;
            sigmathreshold = 5;
            xy = new double[npoints, nvars];
            tmp = new double[nvars];
            p = 0;
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // Fill
                //
                for(i=0; i<=npoints-1; i++)
                {
                    rsphere(ref xy, nvars, i);
                    for(j=0; j<=nvars-1; j++)
                    {
                        xy[i,j] = xy[i,j]+(double)i/(double)clustersize*5;
                    }
                }
                clustering.clusterizercreate(state);
                clustering.clusterizersetpoints(state, xy, npoints, nvars, 2);
                
                //
                // Test: Restarts=1
                //
                clustering.clusterizersetkmeanslimits(state, 1, 0);
                clustering.clusterizerrunkmeans(state, nclusters, rep1);
                if( rep1.terminationtype<=0 )
                {
                    converrors = true;
                    return;
                }
                ea = 0;
                for(i=0; i<=npoints-1; i++)
                {
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = xy[i,i_];
                    }
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = tmp[i_] - rep1.c[rep1.cidx[i],i_];
                    }
                    v = 0.0;
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        v += tmp[i_]*tmp[i_];
                    }
                    ea = ea+v;
                }
                
                //
                // Test: Restarts>1
                //
                clustering.clusterizersetkmeanslimits(state, restarts, 0);
                clustering.clusterizerrunkmeans(state, nclusters, rep2);
                if( rep2.terminationtype<=0 )
                {
                    converrors = true;
                    return;
                }
                eb = 0;
                for(i=0; i<=npoints-1; i++)
                {
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = xy[i,i_];
                    }
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = tmp[i_] - rep2.c[rep2.cidx[i],i_];
                    }
                    v = 0.0;
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        v += tmp[i_]*tmp[i_];
                    }
                    eb = eb+v;
                }
                
                //
                // Calculate statistic.
                //
                if( (double)(ea)<(double)(eb) )
                {
                    p = p+1;
                }
                if( (double)(ea)==(double)(eb) )
                {
                    p = p+0.5;
                }
            }
            
            //
            // If Restarts doesn't influence quality of centers found, P must be
            // binomially distributed random value with mean 0.5*PassCount and
            // standard deviation Sqrt(PassCount/4).
            //
            // If Restarts do influence quality of solution, P must be significantly
            // lower than 0.5*PassCount.
            //
            s = (p-0.5*passcount)/Math.Sqrt((double)passcount/(double)4);
            restartserrors = restartserrors || (double)(s)>(double)(-sigmathreshold);
        }


        /*************************************************************************
        Random normal number
        *************************************************************************/
        private static double rnormal()
        {
            double result = 0;
            double u = 0;
            double v = 0;
            double s = 0;
            double x1 = 0;
            double x2 = 0;

            while( true )
            {
                u = 2*math.randomreal()-1;
                v = 2*math.randomreal()-1;
                s = math.sqr(u)+math.sqr(v);
                if( (double)(s)>(double)(0) && (double)(s)<(double)(1) )
                {
                    s = Math.Sqrt(-(2*Math.Log(s)/s));
                    x1 = u*s;
                    x2 = v*s;
                    break;
                }
            }
            result = x1;
            return result;
        }


        /*************************************************************************
        Random point from sphere
        *************************************************************************/
        private static void rsphere(ref double[,] xy,
            int n,
            int i)
        {
            int j = 0;
            double v = 0;
            int i_ = 0;

            for(j=0; j<=n-1; j++)
            {
                xy[i,j] = rnormal();
            }
            v = 0.0;
            for(i_=0; i_<=n-1;i_++)
            {
                v += xy[i,i_]*xy[i,i_];
            }
            v = math.randomreal()/Math.Sqrt(v);
            for(i_=0; i_<=n-1;i_++)
            {
                xy[i,i_] = v*xy[i,i_];
            }
        }


        /*************************************************************************
        Distance function: distance between X0 and X1

        X0, X1 - array[D], points
        DistType - distance type
        *************************************************************************/
        private static double distfunc(double[] x0,
            double[] x1,
            int d,
            int disttype)
        {
            double result = 0;
            int i = 0;
            double s0 = 0;
            double s1 = 0;

            alglib.ap.assert((((((((disttype==0 || disttype==1) || disttype==2) || disttype==10) || disttype==11) || disttype==12) || disttype==13) || disttype==20) || disttype==21);
            if( disttype==0 )
            {
                result = 0.0;
                for(i=0; i<=d-1; i++)
                {
                    result = Math.Max(result, Math.Abs(x0[i]-x1[i]));
                }
                return result;
            }
            if( disttype==1 )
            {
                result = 0.0;
                for(i=0; i<=d-1; i++)
                {
                    result = result+Math.Abs(x0[i]-x1[i]);
                }
                return result;
            }
            if( disttype==2 )
            {
                result = 0.0;
                for(i=0; i<=d-1; i++)
                {
                    result = result+math.sqr(x0[i]-x1[i]);
                }
                result = Math.Sqrt(result);
                return result;
            }
            if( disttype==10 )
            {
                result = Math.Max(1-basestat.pearsoncorr2(x0, x1, d), 0.0);
                return result;
            }
            if( disttype==11 )
            {
                result = Math.Max(1-Math.Abs(basestat.pearsoncorr2(x0, x1, d)), 0.0);
                return result;
            }
            if( disttype==12 || disttype==13 )
            {
                s0 = 0.0;
                s1 = 0.0;
                for(i=0; i<=d-1; i++)
                {
                    s0 = s0+math.sqr(x0[i])/d;
                    s1 = s1+math.sqr(x1[i])/d;
                }
                s0 = Math.Sqrt(s0);
                s1 = Math.Sqrt(s1);
                result = 0;
                for(i=0; i<=d-1; i++)
                {
                    result = result+x0[i]/s0*(x1[i]/s1)/d;
                }
                if( disttype==12 )
                {
                    result = Math.Max(1-result, 0.0);
                }
                else
                {
                    result = Math.Max(1-Math.Abs(result), 0.0);
                }
                return result;
            }
            if( disttype==20 )
            {
                result = Math.Max(1-basestat.spearmancorr2(x0, x1, d), 0.0);
                return result;
            }
            if( disttype==21 )
            {
                result = Math.Max(1-Math.Abs(basestat.spearmancorr2(x0, x1, d)), 0.0);
                return result;
            }
            result = 0;
            return result;
        }


        /*************************************************************************
        This function replays merges and checks that:
        * Rep.NPoints, Rep.Z, Rep.PZ and Rep.PM are consistent and correct
        * Rep.MergeDist is consistent with distance between clusters being merged
        * clusters with minimal distance are merged at each step
        * GetKClusters() correctly unpacks clusters for each K

        NOTE: this algorithm correctly handle ties, i.e. situations where several
              pairs  of  clusters  have  same intercluster distance, and we can't
              unambiguously choose clusters to merge.

        INPUT PARAMETERS
            D           -   distance matrix, array[NPoints,NPoints], full matrix
                            is given (including both triangles and zeros on the
                            main diagonal)
            XY          -   dataset matrix, array[NPoints,NF]
            NPoints     -   dataset size
            NF          -   number of features
            Rep         -   clusterizer report
            AHCAlgo     -   AHC algorithm:
                            * 0 - complete linkage
                            * 1 - single linkage
                            * 2 - unweighted average linkage

        This function returns True on failure, False on success.
        *************************************************************************/
        private static bool errorsinmerges(double[,] d,
            double[,] xy,
            int npoints,
            int nf,
            clustering.ahcreport rep,
            int ahcalgo)
        {
            bool result = new bool();
            double[,] dm = new double[0,0];
            int[,] cm = new int[0,0];
            int[] clustersizes = new int[0];
            int[] clusterheights = new int[0];
            bool[] b = new bool[0];
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            bool bflag = new bool();
            int i = 0;
            int j = 0;
            int k = 0;
            int i0 = 0;
            int i1 = 0;
            int c0 = 0;
            int c1 = 0;
            int s0 = 0;
            int s1 = 0;
            double v = 0;
            int t = 0;
            int mergeidx = 0;
            int[] kidx = new int[0];
            int[] kidxz = new int[0];
            int currentelement = 0;

            alglib.ap.assert(ahcalgo!=3, "integrity error");
            result = false;
            x0 = new double[nf];
            x1 = new double[nf];
            
            //
            // Basic checks:
            // * positive completion code
            // * sizes of arrays
            // * Rep.P is correct permutation
            // * Rep.Z contains correct cluster indexes
            // * Rep.PZ is consistent with Rep.P/Rep.Z
            // * Rep.PM contains consistent indexes
            // * GetKClusters() for K=NPoints
            //
            bflag = false;
            bflag = bflag || rep.terminationtype<=0;
            if( bflag )
            {
                result = true;
                return result;
            }
            bflag = bflag || rep.npoints!=npoints;
            bflag = (bflag || alglib.ap.rows(rep.z)!=npoints-1) || (npoints>1 && alglib.ap.cols(rep.z)!=2);
            bflag = (bflag || alglib.ap.rows(rep.pz)!=npoints-1) || (npoints>1 && alglib.ap.cols(rep.pz)!=2);
            bflag = (bflag || alglib.ap.rows(rep.pm)!=npoints-1) || (npoints>1 && alglib.ap.cols(rep.pm)!=6);
            bflag = bflag || alglib.ap.len(rep.mergedist)!=npoints-1;
            bflag = bflag || alglib.ap.len(rep.p)!=npoints;
            if( bflag )
            {
                result = true;
                return result;
            }
            b = new bool[npoints];
            for(i=0; i<=npoints-1; i++)
            {
                b[i] = false;
            }
            for(i=0; i<=npoints-1; i++)
            {
                if( (rep.p[i]<0 || rep.p[i]>=npoints) || b[rep.p[i]] )
                {
                    result = true;
                    return result;
                }
                b[rep.p[i]] = true;
            }
            for(i=0; i<=npoints-2; i++)
            {
                if( (rep.z[i,0]<0 || rep.z[i,0]>=rep.z[i,1]) || rep.z[i,1]>=npoints+i )
                {
                    result = true;
                    return result;
                }
                if( (rep.pz[i,0]<0 || rep.pz[i,0]>=rep.pz[i,1]) || rep.pz[i,1]>=npoints+i )
                {
                    result = true;
                    return result;
                }
            }
            for(i=0; i<=npoints-2; i++)
            {
                c0 = rep.z[i,0];
                c1 = rep.z[i,1];
                s0 = rep.pz[i,0];
                s1 = rep.pz[i,1];
                if( c0<npoints )
                {
                    c0 = rep.p[c0];
                }
                if( c1<npoints )
                {
                    c1 = rep.p[c1];
                }
                if( c0!=s0 || c1!=s1 )
                {
                    result = true;
                    return result;
                }
            }
            clustering.clusterizergetkclusters(rep, npoints, ref kidx, ref kidxz);
            if( alglib.ap.len(kidx)!=npoints || alglib.ap.len(kidxz)!=npoints )
            {
                result = true;
                return result;
            }
            for(i=0; i<=npoints-1; i++)
            {
                if( kidxz[i]!=i || kidx[i]!=i )
                {
                    result = true;
                    return result;
                }
            }
            
            //
            // Test description:
            // * we generate (2*NPoints-1)x(2*NPoints-1) matrix of distances DM and
            //   (2*NPoints-1)xNPoints matrix of clusters CM (I-th row contains indexes
            //   of elements which belong to I-th cluster, negative indexes denote
            //   empty cells). Leading N*N square of DM is just a distance matrix,
            //   other elements are filled by some large number M (used to mark empty
            //   elements).
            // * we replay all merges
            // * every time we merge clusters I and J into K, we:
            //   * check that distance between I and J is equal to the smallest
            //     element of DM (note: we account for rounding errors when we
            //     decide on that)
            //   * check that distance is consistent with Rep.MergeDist
            //   * then, we enumerate all elements in clusters being merged,
            //     and check that after permutation their indexes fall into range
            //     prescribed by Rep.PM
            //   * fill K-th column/row of D by distances to cluster K
            //   * merge I-th and J-th rows of CM and store result into K-th row
            //   * clear DM and CM: fill I-th and J-th column/row of DM by large
            //     number M, fill I-th and J-th row of CM by -1.
            //
            // NOTE: DM is initialized by distance metric specific to AHC algorithm
            //       being used. CLINK, SLINK and average linkage use user-provided
            //       distance measure, say Euclidean one, without any modifications.
            //       Ward's method uses (and reports) squared and scaled Euclidean
            //       distances.
            //
            dm = new double[2*npoints-1, 2*npoints-1];
            cm = new int[2*npoints-1, npoints];
            clustersizes = new int[2*npoints-1];
            for(i=0; i<=2*npoints-2; i++)
            {
                for(j=0; j<=2*npoints-2; j++)
                {
                    if( i<npoints && j<npoints )
                    {
                        dm[i,j] = d[i,j];
                        if( ahcalgo==4 )
                        {
                            dm[i,j] = 0.5*math.sqr(dm[i,j]);
                        }
                    }
                    else
                    {
                        dm[i,j] = math.maxrealnumber;
                    }
                }
            }
            for(i=0; i<=2*npoints-2; i++)
            {
                for(j=0; j<=npoints-1; j++)
                {
                    cm[i,j] = -1;
                }
            }
            for(i=0; i<=npoints-1; i++)
            {
                cm[i,0] = i;
                clustersizes[i] = 1;
            }
            for(i=npoints; i<=2*npoints-2; i++)
            {
                clustersizes[i] = 0;
            }
            clusterheights = new int[2*npoints-1];
            for(i=0; i<=npoints-1; i++)
            {
                clusterheights[i] = 0;
            }
            for(mergeidx=0; mergeidx<=npoints-2; mergeidx++)
            {
                
                //
                // Check that clusters with minimum distance are merged,
                // and that MergeDist is consistent with results.
                //
                // NOTE: we do not check for specific cluster indexes,
                //       because it is possible to have a tie. We just
                //       check that distance between clusters is a true
                //       minimum over all possible clusters.
                //
                v = math.maxrealnumber;
                for(i=0; i<=2*npoints-2; i++)
                {
                    for(j=0; j<=2*npoints-2; j++)
                    {
                        if( i!=j )
                        {
                            v = Math.Min(v, dm[i,j]);
                        }
                    }
                }
                c0 = rep.z[mergeidx,0];
                c1 = rep.z[mergeidx,1];
                if( (double)(dm[c0,c1])>(double)(v+10000*math.machineepsilon) )
                {
                    result = true;
                    return result;
                }
                if( (double)(rep.mergedist[mergeidx])>(double)(v+10000*math.machineepsilon) )
                {
                    result = true;
                    return result;
                }
                
                //
                // Check that indexes of elements fall into range prescribed by Rep.PM,
                // and Rep.PM correctly described merge operation
                //
                s0 = clustersizes[c0];
                s1 = clustersizes[c1];
                for(j=0; j<=clustersizes[c0]-1; j++)
                {
                    if( rep.p[cm[c0,j]]<rep.pm[mergeidx,0] || rep.p[cm[c0,j]]>rep.pm[mergeidx,1] )
                    {
                        
                        //
                        // Element falls outside of range described by PM
                        //
                        result = true;
                        return result;
                    }
                }
                for(j=0; j<=clustersizes[c1]-1; j++)
                {
                    if( rep.p[cm[c1,j]]<rep.pm[mergeidx,2] || rep.p[cm[c1,j]]>rep.pm[mergeidx,3] )
                    {
                        
                        //
                        // Element falls outside of range described by PM
                        //
                        result = true;
                        return result;
                    }
                }
                if( (rep.pm[mergeidx,1]-rep.pm[mergeidx,0]!=s0-1 || rep.pm[mergeidx,3]-rep.pm[mergeidx,2]!=s1-1) || rep.pm[mergeidx,2]!=rep.pm[mergeidx,1]+1 )
                {
                    
                    //
                    // Cluster size (as given by PM) is inconsistent with its actual size.
                    //
                    result = true;
                    return result;
                }
                if( rep.pm[mergeidx,4]!=clusterheights[rep.z[mergeidx,0]] || rep.pm[mergeidx,5]!=clusterheights[rep.z[mergeidx,1]] )
                {
                    
                    //
                    // Heights of subdendrograms as returned by PM are inconsistent with heights
                    // calculated by us.
                    //
                    result = true;
                    return result;
                }
                
                //
                // Update cluster heights
                //
                clusterheights[mergeidx+npoints] = Math.Max(clusterheights[rep.z[mergeidx,0]], clusterheights[rep.z[mergeidx,1]])+1;
                
                //
                // Update CM
                //
                t = 0;
                for(j=0; j<=clustersizes[rep.z[mergeidx,0]]-1; j++)
                {
                    cm[npoints+mergeidx,t] = cm[rep.z[mergeidx,0],j];
                    t = t+1;
                }
                for(j=0; j<=clustersizes[rep.z[mergeidx,1]]-1; j++)
                {
                    cm[npoints+mergeidx,t] = cm[rep.z[mergeidx,1],j];
                    t = t+1;
                }
                clustersizes[npoints+mergeidx] = t;
                clustersizes[rep.z[mergeidx,0]] = 0;
                clustersizes[rep.z[mergeidx,1]] = 0;
                
                //
                // Update distance matrix D
                //
                for(i=0; i<=2*npoints-2; i++)
                {
                    
                    //
                    // "Remove" columns/rows corresponding to clusters being merged
                    //
                    dm[i,rep.z[mergeidx,0]] = math.maxrealnumber;
                    dm[i,rep.z[mergeidx,1]] = math.maxrealnumber;
                    dm[rep.z[mergeidx,0],i] = math.maxrealnumber;
                    dm[rep.z[mergeidx,1],i] = math.maxrealnumber;
                }
                for(i=0; i<=npoints+mergeidx-1; i++)
                {
                    if( clustersizes[i]>0 )
                    {
                        
                        //
                        // Calculate column/row corresponding to new cluster
                        //
                        if( ahcalgo==0 )
                        {
                            
                            //
                            // Calculate distance between clusters I and NPoints+MergeIdx for CLINK
                            //
                            v = 0.0;
                            for(i0=0; i0<=clustersizes[i]-1; i0++)
                            {
                                for(i1=0; i1<=clustersizes[npoints+mergeidx]-1; i1++)
                                {
                                    v = Math.Max(v, d[cm[i,i0],cm[npoints+mergeidx,i1]]);
                                }
                            }
                        }
                        if( ahcalgo==1 )
                        {
                            
                            //
                            // Calculate distance between clusters I and NPoints+MergeIdx for SLINK
                            //
                            v = math.maxrealnumber;
                            for(i0=0; i0<=clustersizes[i]-1; i0++)
                            {
                                for(i1=0; i1<=clustersizes[npoints+mergeidx]-1; i1++)
                                {
                                    v = Math.Min(v, d[cm[i,i0],cm[npoints+mergeidx,i1]]);
                                }
                            }
                        }
                        if( ahcalgo==2 )
                        {
                            
                            //
                            // Calculate distance between clusters I and NPoints+MergeIdx for unweighted average
                            //
                            v = 0.0;
                            t = 0;
                            for(i0=0; i0<=clustersizes[i]-1; i0++)
                            {
                                for(i1=0; i1<=clustersizes[npoints+mergeidx]-1; i1++)
                                {
                                    v = v+d[cm[i,i0],cm[npoints+mergeidx,i1]];
                                    t = t+1;
                                }
                            }
                            v = v/t;
                        }
                        if( ahcalgo==3 )
                        {
                            alglib.ap.assert(false);
                        }
                        if( ahcalgo==4 )
                        {
                            
                            //
                            // Calculate distance between clusters I and NPoints+MergeIdx for Ward's method:
                            // * X0 = center of mass for cluster I
                            // * X1 = center of mass for cluster NPoints+MergeIdx
                            // * S0 = size of cluster I
                            // * S1 = size of cluster NPoints+MergeIdx
                            // * distance between clusters is S0*S1/(S0+S1)*|X0-X1|^2
                            //
                            //
                            for(j=0; j<=nf-1; j++)
                            {
                                x0[j] = 0.0;
                                x1[j] = 0.0;
                            }
                            for(i0=0; i0<=clustersizes[i]-1; i0++)
                            {
                                for(j=0; j<=nf-1; j++)
                                {
                                    x0[j] = x0[j]+xy[cm[i,i0],j]/clustersizes[i];
                                }
                            }
                            for(i1=0; i1<=clustersizes[npoints+mergeidx]-1; i1++)
                            {
                                for(j=0; j<=nf-1; j++)
                                {
                                    x1[j] = x1[j]+xy[cm[npoints+mergeidx,i1],j]/clustersizes[npoints+mergeidx];
                                }
                            }
                            v = 0.0;
                            for(j=0; j<=nf-1; j++)
                            {
                                v = v+math.sqr(x0[j]-x1[j]);
                            }
                            v = v*clustersizes[i]*clustersizes[npoints+mergeidx]/(clustersizes[i]+clustersizes[npoints+mergeidx]);
                        }
                        dm[i,npoints+mergeidx] = v;
                        dm[npoints+mergeidx,i] = v;
                    }
                }
                
                //
                // Check that GetKClusters() correctly unpacks clusters for K=NPoints-(MergeIdx+1):
                // * check lengths of arays
                // * check consistency of CIdx/CZ parameters
                // * scan clusters (CZ parameter), for each cluster scan CM matrix which stores
                //   cluster elements (according to our replay of merges), for each element of
                //   the current cluster check that CIdx array correctly reflects its status.
                //
                k = npoints-(mergeidx+1);
                clustering.clusterizergetkclusters(rep, k, ref kidx, ref kidxz);
                if( alglib.ap.len(kidx)!=npoints || alglib.ap.len(kidxz)!=k )
                {
                    result = true;
                    return result;
                }
                for(i=0; i<=k-2; i++)
                {
                    if( (kidxz[i]<0 || kidxz[i]>=kidxz[i+1]) || kidxz[i+1]>2*npoints-2 )
                    {
                        
                        //
                        // CZ is inconsistent
                        //
                        result = true;
                        return result;
                    }
                }
                for(i=0; i<=npoints-1; i++)
                {
                    if( kidx[i]<0 || kidx[i]>=k )
                    {
                        
                        //
                        // CIdx is inconsistent
                        //
                        result = true;
                        return result;
                    }
                }
                for(i=0; i<=k-1; i++)
                {
                    for(j=0; j<=clustersizes[kidxz[i]]-1; j++)
                    {
                        currentelement = cm[kidxz[i],j];
                        if( kidx[currentelement]!=i )
                        {
                            
                            //
                            // We've found element which belongs to I-th cluster (according to CM
                            // matrix, which reflects current status of agglomerative clustering),
                            // but this element does not belongs to I-th cluster according to
                            // results of ClusterizerGetKClusters()
                            //
                            result = true;
                            return result;
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        This procedure is a reference version of KMeansUpdateDistances().

        INPUT PARAMETERS:
            XY          -   dataset, array [0..NPoints-1,0..NVars-1].
            NPoints     -   dataset size, NPoints>=K
            NVars       -   number of variables, NVars>=1
            CT          -   matrix of centers, centers are stored in rows
            K           -   number of centers, K>=1
            XYC         -   preallocated output buffer
            XYDist2     -   preallocated output buffer

        OUTPUT PARAMETERS:
            XYC         -   new assignment of points to centers
            XYDist2     -   squared distances

          -- ALGLIB --
             Copyright 21.01.2015 by Bochkanov Sergey
        *************************************************************************/
        private static void kmeansreferenceupdatedistances(double[,] xy,
            int npoints,
            int nvars,
            double[,] ct,
            int k,
            int[] xyc,
            double[] xydist2)
        {
            int i = 0;
            int j = 0;
            int cclosest = 0;
            double dclosest = 0;
            double v = 0;
            double[] tmp = new double[0];
            int i_ = 0;

            tmp = new double[nvars];
            for(i=0; i<=npoints-1; i++)
            {
                cclosest = -1;
                dclosest = math.maxrealnumber;
                for(j=0; j<=k-1; j++)
                {
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = xy[i,i_];
                    }
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        tmp[i_] = tmp[i_] - ct[j,i_];
                    }
                    v = 0.0;
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        v += tmp[i_]*tmp[i_];
                    }
                    if( (double)(v)<(double)(dclosest) )
                    {
                        cclosest = j;
                        dclosest = v;
                    }
                }
                alglib.ap.assert(cclosest>=0, "KMeansUpdateDistances: internal error");
                xyc[i] = cclosest;
                xydist2[i] = dclosest;
            }
        }


    }
    public class testdforestunit
    {
        public static bool testdforest(bool silent)
        {
            bool result = new bool();
            int ncmax = 0;
            int nvmax = 0;
            int passcount = 0;
            int nvars = 0;
            int nclasses = 0;
            bool waserrors = new bool();
            bool basicerrors = new bool();
            bool procerrors = new bool();

            
            //
            // Primary settings
            //
            nvmax = 4;
            ncmax = 3;
            passcount = 10;
            basicerrors = false;
            procerrors = false;
            waserrors = false;
            
            //
            // Tests
            //
            testprocessing(ref procerrors);
            for(nvars=1; nvars<=nvmax; nvars++)
            {
                for(nclasses=1; nclasses<=ncmax; nclasses++)
                {
                    basictest1(nvars, nclasses, passcount, ref basicerrors);
                }
            }
            basictest2(ref basicerrors);
            basictest3(ref basicerrors);
            basictest4(ref basicerrors);
            basictest5(ref basicerrors);
            
            //
            // Final report
            //
            waserrors = basicerrors || procerrors;
            if( !silent )
            {
                System.Console.Write("RANDOM FOREST TEST");
                System.Console.WriteLine();
                System.Console.Write("TOTAL RESULTS:                           ");
                if( !waserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* PROCESSING FUNCTIONS:                  ");
                if( !procerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* BASIC TESTS:                           ");
                if( !basicerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST SUMMARY: FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST SUMMARY: PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testdforest(bool silent)
        {
            return testdforest(silent);
        }


        /*************************************************************************
        Processing functions test
        *************************************************************************/
        private static void testprocessing(ref bool err)
        {
            int nvars = 0;
            int nclasses = 0;
            int nsample = 0;
            int ntrees = 0;
            int nfeatures = 0;
            int flags = 0;
            dforest.decisionforest df1 = new dforest.decisionforest();
            dforest.decisionforest df2 = new dforest.decisionforest();
            int npoints = 0;
            double[,] xy = new double[0,0];
            int pass = 0;
            int passcount = 0;
            int i = 0;
            int j = 0;
            bool allsame = new bool();
            int info = 0;
            dforest.dfreport rep = new dforest.dfreport();
            double[] x1 = new double[0];
            double[] x2 = new double[0];
            double[] y1 = new double[0];
            double[] y2 = new double[0];
            double v = 0;

            passcount = 100;
            
            //
            // Main cycle
            //
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // initialize parameters
                //
                nvars = 1+math.randominteger(5);
                nclasses = 1+math.randominteger(3);
                ntrees = 1+math.randominteger(4);
                nfeatures = 1+math.randominteger(nvars);
                flags = 0;
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    flags = flags+2;
                }
                
                //
                // Initialize arrays and data
                //
                npoints = 10+math.randominteger(50);
                nsample = Math.Max(10, math.randominteger(npoints));
                x1 = new double[nvars-1+1];
                x2 = new double[nvars-1+1];
                y1 = new double[nclasses-1+1];
                y2 = new double[nclasses-1+1];
                xy = new double[npoints-1+1, nvars+1];
                for(i=0; i<=npoints-1; i++)
                {
                    for(j=0; j<=nvars-1; j++)
                    {
                        if( j%2==0 )
                        {
                            xy[i,j] = 2*math.randomreal()-1;
                        }
                        else
                        {
                            xy[i,j] = math.randominteger(2);
                        }
                    }
                    if( nclasses==1 )
                    {
                        xy[i,nvars] = 2*math.randomreal()-1;
                    }
                    else
                    {
                        xy[i,nvars] = math.randominteger(nclasses);
                    }
                }
                
                //
                // create forest
                //
                dforest.dfbuildinternal(xy, npoints, nvars, nclasses, ntrees, nsample, nfeatures, flags, ref info, df1, rep);
                if( info<=0 )
                {
                    err = true;
                    return;
                }
                
                //
                // Same inputs leads to same outputs
                //
                for(i=0; i<=nvars-1; i++)
                {
                    x1[i] = 2*math.randomreal()-1;
                    x2[i] = x1[i];
                }
                for(i=0; i<=nclasses-1; i++)
                {
                    y1[i] = 2*math.randomreal()-1;
                    y2[i] = 2*math.randomreal()-1;
                }
                dforest.dfprocess(df1, x1, ref y1);
                dforest.dfprocess(df1, x2, ref y2);
                allsame = true;
                for(i=0; i<=nclasses-1; i++)
                {
                    allsame = allsame && (double)(y1[i])==(double)(y2[i]);
                }
                err = err || !allsame;
                
                //
                // Same inputs on original forest leads to same outputs
                // on copy created using DFCopy
                //
                unsetdf(df2);
                dforest.dfcopy(df1, df2);
                for(i=0; i<=nvars-1; i++)
                {
                    x1[i] = 2*math.randomreal()-1;
                    x2[i] = x1[i];
                }
                for(i=0; i<=nclasses-1; i++)
                {
                    y1[i] = 2*math.randomreal()-1;
                    y2[i] = 2*math.randomreal()-1;
                }
                dforest.dfprocess(df1, x1, ref y1);
                dforest.dfprocess(df2, x2, ref y2);
                allsame = true;
                for(i=0; i<=nclasses-1; i++)
                {
                    allsame = allsame && (double)(y1[i])==(double)(y2[i]);
                }
                err = err || !allsame;
                
                //
                // Same inputs on original forest leads to same outputs
                // on copy created using DFSerialize
                //
                unsetdf(df2);
                {
                    //
                    // This code passes data structure through serializers
                    // (serializes it to string and loads back)
                    //
                    serializer _local_serializer;
                    string _local_str;
                    
                    _local_serializer = new serializer();
                    _local_serializer.alloc_start();
                    dforest.dfalloc(_local_serializer, df1);
                    _local_serializer.sstart_str();
                    dforest.dfserialize(_local_serializer, df1);
                    _local_serializer.stop();
                    _local_str = _local_serializer.get_string();
                    
                    _local_serializer = new serializer();
                    _local_serializer.ustart_str(_local_str);
                    dforest.dfunserialize(_local_serializer, df2);
                    _local_serializer.stop();
                }
                for(i=0; i<=nvars-1; i++)
                {
                    x1[i] = 2*math.randomreal()-1;
                    x2[i] = x1[i];
                }
                for(i=0; i<=nclasses-1; i++)
                {
                    y1[i] = 2*math.randomreal()-1;
                    y2[i] = 2*math.randomreal()-1;
                }
                dforest.dfprocess(df1, x1, ref y1);
                dforest.dfprocess(df2, x2, ref y2);
                allsame = true;
                for(i=0; i<=nclasses-1; i++)
                {
                    allsame = allsame && (double)(y1[i])==(double)(y2[i]);
                }
                err = err || !allsame;
                
                //
                // Normalization properties
                //
                if( nclasses>1 )
                {
                    for(i=0; i<=nvars-1; i++)
                    {
                        x1[i] = 2*math.randomreal()-1;
                    }
                    dforest.dfprocess(df1, x1, ref y1);
                    v = 0;
                    for(i=0; i<=nclasses-1; i++)
                    {
                        v = v+y1[i];
                        err = err || (double)(y1[i])<(double)(0);
                    }
                    err = err || (double)(Math.Abs(v-1))>(double)(1000*math.machineepsilon);
                }
            }
        }


        /*************************************************************************
        Basic test:  one-tree forest built using full sample must remember all the
        training cases
        *************************************************************************/
        private static void basictest1(int nvars,
            int nclasses,
            int passcount,
            ref bool err)
        {
            int pass = 0;
            double[,] xy = new double[0,0];
            int npoints = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double s = 0;
            int info = 0;
            dforest.decisionforest df = new dforest.decisionforest();
            double[] x = new double[0];
            double[] y = new double[0];
            dforest.dfreport rep = new dforest.dfreport();
            bool hassame = new bool();
            int i_ = 0;

            if( nclasses==1 )
            {
                
                //
                // only classification tasks
                //
                return;
            }
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // select number of points
                //
                if( pass<=3 && passcount>3 )
                {
                    npoints = pass;
                }
                else
                {
                    npoints = 100+math.randominteger(100);
                }
                
                //
                // Prepare task
                //
                xy = new double[npoints-1+1, nvars+1];
                x = new double[nvars-1+1];
                y = new double[nclasses-1+1];
                for(i=0; i<=npoints-1; i++)
                {
                    for(j=0; j<=nvars-1; j++)
                    {
                        xy[i,j] = 2*math.randomreal()-1;
                    }
                    xy[i,nvars] = math.randominteger(nclasses);
                }
                
                //
                // Test
                //
                dforest.dfbuildinternal(xy, npoints, nvars, nclasses, 1, npoints, 1, 1, ref info, df, rep);
                if( info<=0 )
                {
                    err = true;
                    return;
                }
                for(i=0; i<=npoints-1; i++)
                {
                    for(i_=0; i_<=nvars-1;i_++)
                    {
                        x[i_] = xy[i,i_];
                    }
                    dforest.dfprocess(df, x, ref y);
                    s = 0;
                    for(j=0; j<=nclasses-1; j++)
                    {
                        if( (double)(y[j])<(double)(0) )
                        {
                            err = true;
                            return;
                        }
                        s = s+y[j];
                    }
                    if( (double)(Math.Abs(s-1))>(double)(1000*math.machineepsilon) )
                    {
                        err = true;
                        return;
                    }
                    if( (double)(Math.Abs(y[(int)Math.Round(xy[i,nvars])]-1))>(double)(1000*math.machineepsilon) )
                    {
                        
                        //
                        // not an error if there exists such K,J that XY[K,J]=XY[I,J]
                        // (may be we just can't distinguish two tied values).
                        //
                        // definitely error otherwise.
                        //
                        hassame = false;
                        for(k=0; k<=npoints-1; k++)
                        {
                            if( k!=i )
                            {
                                for(j=0; j<=nvars-1; j++)
                                {
                                    if( (double)(xy[k,j])==(double)(xy[i,j]) )
                                    {
                                        hassame = true;
                                    }
                                }
                            }
                        }
                        if( !hassame )
                        {
                            err = true;
                            return;
                        }
                    }
                }
            }
        }


        /*************************************************************************
        Basic test:  tests generalization ability on a simple noisy classification
        task:
        * 0<x<1 - P(class=0)=1
        * 1<x<2 - P(class=0)=2-x
        * 2<x<3 - P(class=0)=0
        *************************************************************************/
        private static void basictest2(ref bool err)
        {
            int pass = 0;
            int passcount = 0;
            double[,] xy = new double[0,0];
            int npoints = 0;
            int ntrees = 0;
            int i = 0;
            int j = 0;
            double s = 0;
            int info = 0;
            dforest.decisionforest df = new dforest.decisionforest();
            double[] x = new double[0];
            double[] y = new double[0];
            dforest.dfreport rep = new dforest.dfreport();

            passcount = 1;
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // select npoints and ntrees
                //
                npoints = 3000;
                ntrees = 50;
                
                //
                // Prepare task
                //
                xy = new double[npoints-1+1, 1+1];
                x = new double[0+1];
                y = new double[1+1];
                for(i=0; i<=npoints-1; i++)
                {
                    xy[i,0] = 3*math.randomreal();
                    if( (double)(xy[i,0])<=(double)(1) )
                    {
                        xy[i,1] = 0;
                    }
                    else
                    {
                        if( (double)(xy[i,0])<=(double)(2) )
                        {
                            if( (double)(math.randomreal())<(double)(xy[i,0]-1) )
                            {
                                xy[i,1] = 1;
                            }
                            else
                            {
                                xy[i,1] = 0;
                            }
                        }
                        else
                        {
                            xy[i,1] = 1;
                        }
                    }
                }
                
                //
                // Test
                //
                dforest.dfbuildinternal(xy, npoints, 1, 2, ntrees, (int)Math.Round(0.05*npoints), 1, 0, ref info, df, rep);
                if( info<=0 )
                {
                    err = true;
                    return;
                }
                x[0] = 0.0;
                while( (double)(x[0])<=(double)(3.0) )
                {
                    dforest.dfprocess(df, x, ref y);
                    
                    //
                    // Test for basic properties
                    //
                    s = 0;
                    for(j=0; j<=1; j++)
                    {
                        if( (double)(y[j])<(double)(0) )
                        {
                            err = true;
                            return;
                        }
                        s = s+y[j];
                    }
                    if( (double)(Math.Abs(s-1))>(double)(1000*math.machineepsilon) )
                    {
                        err = true;
                        return;
                    }
                    
                    //
                    // test for good correlation with results
                    //
                    if( (double)(x[0])<(double)(1) )
                    {
                        err = err || (double)(y[0])<(double)(0.8);
                    }
                    if( (double)(x[0])>=(double)(1) && (double)(x[0])<=(double)(2) )
                    {
                        err = err || (double)(Math.Abs(y[1]-(x[0]-1)))>(double)(0.5);
                    }
                    if( (double)(x[0])>(double)(2) )
                    {
                        err = err || (double)(y[1])<(double)(0.8);
                    }
                    x[0] = x[0]+0.01;
                }
            }
        }


        /*************************************************************************
        Basic test:  tests  generalization ability on a simple classification task
        (no noise):
        * |x|<1, |y|<1
        * x^2+y^2<=0.25 - P(class=0)=1
        * x^2+y^2>0.25  - P(class=0)=0
        *************************************************************************/
        private static void basictest3(ref bool err)
        {
            int pass = 0;
            int passcount = 0;
            double[,] xy = new double[0,0];
            int npoints = 0;
            int ntrees = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double s = 0;
            int info = 0;
            dforest.decisionforest df = new dforest.decisionforest();
            double[] x = new double[0];
            double[] y = new double[0];
            dforest.dfreport rep = new dforest.dfreport();
            int testgridsize = 0;
            double r = 0;

            passcount = 1;
            testgridsize = 50;
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // select npoints and ntrees
                //
                npoints = 2000;
                ntrees = 100;
                
                //
                // Prepare task
                //
                xy = new double[npoints-1+1, 2+1];
                x = new double[1+1];
                y = new double[1+1];
                for(i=0; i<=npoints-1; i++)
                {
                    xy[i,0] = 2*math.randomreal()-1;
                    xy[i,1] = 2*math.randomreal()-1;
                    if( (double)(math.sqr(xy[i,0])+math.sqr(xy[i,1]))<=(double)(0.25) )
                    {
                        xy[i,2] = 0;
                    }
                    else
                    {
                        xy[i,2] = 1;
                    }
                }
                
                //
                // Test
                //
                dforest.dfbuildinternal(xy, npoints, 2, 2, ntrees, (int)Math.Round(0.1*npoints), 1, 0, ref info, df, rep);
                if( info<=0 )
                {
                    err = true;
                    return;
                }
                for(i=-(testgridsize/2); i<=testgridsize/2; i++)
                {
                    for(j=-(testgridsize/2); j<=testgridsize/2; j++)
                    {
                        x[0] = (double)i/(double)(testgridsize/2);
                        x[1] = (double)j/(double)(testgridsize/2);
                        dforest.dfprocess(df, x, ref y);
                        
                        //
                        // Test for basic properties
                        //
                        s = 0;
                        for(k=0; k<=1; k++)
                        {
                            if( (double)(y[k])<(double)(0) )
                            {
                                err = true;
                                return;
                            }
                            s = s+y[k];
                        }
                        if( (double)(Math.Abs(s-1))>(double)(1000*math.machineepsilon) )
                        {
                            err = true;
                            return;
                        }
                        
                        //
                        // test for good correlation with results
                        //
                        r = Math.Sqrt(math.sqr(x[0])+math.sqr(x[1]));
                        if( (double)(r)<(double)(0.5*0.5) )
                        {
                            err = err || (double)(y[0])<(double)(0.6);
                        }
                        if( (double)(r)>(double)(0.5*1.5) )
                        {
                            err = err || (double)(y[1])<(double)(0.6);
                        }
                    }
                }
            }
        }


        /*************************************************************************
        Basic test: simple regression task without noise:
        * |x|<1, |y|<1
        * F(x,y) = x^2+y
        *************************************************************************/
        private static void basictest4(ref bool err)
        {
            int pass = 0;
            int passcount = 0;
            double[,] xy = new double[0,0];
            int npoints = 0;
            int ntrees = 0;
            int ns = 0;
            int strongc = 0;
            int i = 0;
            int j = 0;
            int info = 0;
            dforest.decisionforest df = new dforest.decisionforest();
            dforest.decisionforest df2 = new dforest.decisionforest();
            double[] x = new double[0];
            double[] y = new double[0];
            dforest.dfreport rep = new dforest.dfreport();
            dforest.dfreport rep2 = new dforest.dfreport();
            int testgridsize = 0;
            double maxerr = 0;
            double maxerr2 = 0;
            double avgerr = 0;
            double avgerr2 = 0;
            int cnt = 0;
            double ey = 0;

            passcount = 1;
            testgridsize = 50;
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // select npoints and ntrees
                //
                npoints = 5000;
                ntrees = 100;
                ns = (int)Math.Round(0.1*npoints);
                strongc = 1;
                
                //
                // Prepare task
                //
                xy = new double[npoints-1+1, 2+1];
                x = new double[1+1];
                y = new double[0+1];
                for(i=0; i<=npoints-1; i++)
                {
                    xy[i,0] = 2*math.randomreal()-1;
                    xy[i,1] = 2*math.randomreal()-1;
                    xy[i,2] = math.sqr(xy[i,0])+xy[i,1];
                }
                
                //
                // Test
                //
                dforest.dfbuildinternal(xy, npoints, 2, 1, ntrees, ns, 1, 0, ref info, df, rep);
                if( info<=0 )
                {
                    err = true;
                    return;
                }
                dforest.dfbuildinternal(xy, npoints, 2, 1, ntrees, ns, 1, strongc, ref info, df2, rep2);
                if( info<=0 )
                {
                    err = true;
                    return;
                }
                maxerr = 0;
                maxerr2 = 0;
                avgerr = 0;
                avgerr2 = 0;
                cnt = 0;
                for(i=(int)Math.Round(-(0.7*testgridsize/2)); i<=(int)Math.Round(0.7*testgridsize/2); i++)
                {
                    for(j=(int)Math.Round(-(0.7*testgridsize/2)); j<=(int)Math.Round(0.7*testgridsize/2); j++)
                    {
                        x[0] = (double)i/(double)(testgridsize/2);
                        x[1] = (double)j/(double)(testgridsize/2);
                        ey = math.sqr(x[0])+x[1];
                        dforest.dfprocess(df, x, ref y);
                        maxerr = Math.Max(maxerr, Math.Abs(y[0]-ey));
                        avgerr = avgerr+Math.Abs(y[0]-ey);
                        dforest.dfprocess(df2, x, ref y);
                        maxerr2 = Math.Max(maxerr2, Math.Abs(y[0]-ey));
                        avgerr2 = avgerr2+Math.Abs(y[0]-ey);
                        cnt = cnt+1;
                    }
                }
                avgerr = avgerr/cnt;
                avgerr2 = avgerr2/cnt;
                err = err || (double)(maxerr)>(double)(0.2);
                err = err || (double)(maxerr2)>(double)(0.2);
                err = err || (double)(avgerr)>(double)(0.1);
                err = err || (double)(avgerr2)>(double)(0.1);
            }
        }


        /*************************************************************************
        Basic test: extended variable selection leads to better results.

        Next task CAN be solved without EVS but it is very unlikely. With EVS
        it can be easily and exactly solved.

        Task matrix:
            1 0 0 0 ... 0   0
            0 1 0 0 ... 0   1
            0 0 1 0 ... 0   2
            0 0 0 1 ... 0   3
            0 0 0 0 ... 1   N-1
        *************************************************************************/
        private static void basictest5(ref bool err)
        {
            double[,] xy = new double[0,0];
            int nvars = 0;
            int npoints = 0;
            int nfeatures = 0;
            int nsample = 0;
            int ntrees = 0;
            int evs = 0;
            int i = 0;
            int j = 0;
            bool eflag = new bool();
            int info = 0;
            dforest.decisionforest df = new dforest.decisionforest();
            double[] x = new double[0];
            double[] y = new double[0];
            dforest.dfreport rep = new dforest.dfreport();
            int i_ = 0;

            
            //
            // select npoints and ntrees
            //
            npoints = 50;
            nvars = npoints;
            ntrees = 1;
            nsample = npoints;
            evs = 2;
            nfeatures = 1;
            
            //
            // Prepare task
            //
            xy = new double[npoints-1+1, nvars+1];
            x = new double[nvars-1+1];
            y = new double[0+1];
            for(i=0; i<=npoints-1; i++)
            {
                for(j=0; j<=nvars-1; j++)
                {
                    xy[i,j] = 0;
                }
                xy[i,i] = 1;
                xy[i,nvars] = i;
            }
            
            //
            // Without EVS
            //
            dforest.dfbuildinternal(xy, npoints, nvars, 1, ntrees, nsample, nfeatures, 0, ref info, df, rep);
            if( info<=0 )
            {
                err = true;
                return;
            }
            eflag = false;
            for(i=0; i<=npoints-1; i++)
            {
                for(i_=0; i_<=nvars-1;i_++)
                {
                    x[i_] = xy[i,i_];
                }
                dforest.dfprocess(df, x, ref y);
                if( (double)(Math.Abs(y[0]-xy[i,nvars]))>(double)(1000*math.machineepsilon) )
                {
                    eflag = true;
                }
            }
            if( !eflag )
            {
                err = true;
                return;
            }
            
            //
            // With EVS
            //
            dforest.dfbuildinternal(xy, npoints, nvars, 1, ntrees, nsample, nfeatures, evs, ref info, df, rep);
            if( info<=0 )
            {
                err = true;
                return;
            }
            eflag = false;
            for(i=0; i<=npoints-1; i++)
            {
                for(i_=0; i_<=nvars-1;i_++)
                {
                    x[i_] = xy[i,i_];
                }
                dforest.dfprocess(df, x, ref y);
                if( (double)(Math.Abs(y[0]-xy[i,nvars]))>(double)(1000*math.machineepsilon) )
                {
                    eflag = true;
                }
            }
            if( eflag )
            {
                err = true;
                return;
            }
        }


        /*************************************************************************
        Unsets DF
        *************************************************************************/
        private static void unsetdf(dforest.decisionforest df)
        {
            double[,] xy = new double[0,0];
            int info = 0;
            dforest.dfreport rep = new dforest.dfreport();

            xy = new double[0+1, 1+1];
            xy[0,0] = 0;
            xy[0,1] = 0;
            dforest.dfbuildinternal(xy, 1, 1, 1, 1, 1, 1, 0, ref info, df, rep);
        }


    }
    public class testgammafuncunit
    {
        public static bool testgammafunc(bool silent)
        {
            bool result = new bool();
            double threshold = 0;
            double v = 0;
            double s = 0;
            bool waserrors = new bool();
            bool gammaerrors = new bool();
            bool lngammaerrors = new bool();

            gammaerrors = false;
            lngammaerrors = false;
            waserrors = false;
            threshold = 100*math.machineepsilon;
            
            //
            //
            //
            gammaerrors = gammaerrors || (double)(Math.Abs(gammafunc.gammafunction(0.5)-Math.Sqrt(Math.PI)))>(double)(threshold);
            gammaerrors = gammaerrors || (double)(Math.Abs(gammafunc.gammafunction(1.5)-0.5*Math.Sqrt(Math.PI)))>(double)(threshold);
            v = gammafunc.lngamma(0.5, ref s);
            lngammaerrors = (lngammaerrors || (double)(Math.Abs(v-Math.Log(Math.Sqrt(Math.PI))))>(double)(threshold)) || (double)(s)!=(double)(1);
            v = gammafunc.lngamma(1.5, ref s);
            lngammaerrors = (lngammaerrors || (double)(Math.Abs(v-Math.Log(0.5*Math.Sqrt(Math.PI))))>(double)(threshold)) || (double)(s)!=(double)(1);
            
            //
            // report
            //
            waserrors = gammaerrors || lngammaerrors;
            if( !silent )
            {
                System.Console.Write("TESTING GAMMA FUNCTION");
                System.Console.WriteLine();
                System.Console.Write("GAMMA:                                   ");
                if( gammaerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("LN GAMMA:                                ");
                if( lngammaerrors )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            
            //
            // end
            //
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testgammafunc(bool silent)
        {
            return testgammafunc(silent);
        }


    }
    public class testhblasunit
    {
        public static bool testhblas(bool silent)
        {
            bool result = new bool();
            complex[,] a = new complex[0,0];
            complex[,] ua = new complex[0,0];
            complex[,] la = new complex[0,0];
            complex[] x = new complex[0];
            complex[] y1 = new complex[0];
            complex[] y2 = new complex[0];
            complex[] y3 = new complex[0];
            int n = 0;
            int maxn = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int i2 = 0;
            bool waserrors = new bool();
            double mverr = 0;
            double threshold = 0;
            complex alpha = 0;
            complex v = 0;
            int i_ = 0;
            int i1_ = 0;

            mverr = 0;
            waserrors = false;
            maxn = 10;
            threshold = 1000*math.machineepsilon;
            
            //
            // Test MV
            //
            for(n=2; n<=maxn; n++)
            {
                a = new complex[n+1, n+1];
                ua = new complex[n+1, n+1];
                la = new complex[n+1, n+1];
                x = new complex[n+1];
                y1 = new complex[n+1];
                y2 = new complex[n+1];
                y3 = new complex[n+1];
                
                //
                // fill A, UA, LA
                //
                for(i=1; i<=n; i++)
                {
                    a[i,i].x = 2*math.randomreal()-1;
                    a[i,i].y = 0;
                    for(j=i+1; j<=n; j++)
                    {
                        a[i,j].x = 2*math.randomreal()-1;
                        a[i,j].y = 2*math.randomreal()-1;
                        a[j,i] = math.conj(a[i,j]);
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        ua[i,j] = 0;
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=i; j<=n; j++)
                    {
                        ua[i,j] = a[i,j];
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        la[i,j] = 0;
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=i; j++)
                    {
                        la[i,j] = a[i,j];
                    }
                }
                
                //
                // test on different I1, I2
                //
                for(i1=1; i1<=n; i1++)
                {
                    for(i2=i1; i2<=n; i2++)
                    {
                        
                        //
                        // Fill X, choose Alpha
                        //
                        for(i=1; i<=i2-i1+1; i++)
                        {
                            x[i].x = 2*math.randomreal()-1;
                            x[i].y = 2*math.randomreal()-1;
                        }
                        alpha.x = 2*math.randomreal()-1;
                        alpha.y = 2*math.randomreal()-1;
                        
                        //
                        // calculate A*x, UA*x, LA*x
                        //
                        for(i=i1; i<=i2; i++)
                        {
                            i1_ = (1)-(i1);
                            v = 0.0;
                            for(i_=i1; i_<=i2;i_++)
                            {
                                v += a[i,i_]*x[i_+i1_];
                            }
                            y1[i-i1+1] = alpha*v;
                        }
                        hblas.hermitianmatrixvectormultiply(ua, true, i1, i2, x, alpha, ref y2);
                        hblas.hermitianmatrixvectormultiply(la, false, i1, i2, x, alpha, ref y3);
                        
                        //
                        // Calculate error
                        //
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            y2[i_] = y2[i_] - y1[i_];
                        }
                        v = 0.0;
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            v += y2[i_]*math.conj(y2[i_]);
                        }
                        mverr = Math.Max(mverr, Math.Sqrt(math.abscomplex(v)));
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            y3[i_] = y3[i_] - y1[i_];
                        }
                        v = 0.0;
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            v += y3[i_]*math.conj(y3[i_]);
                        }
                        mverr = Math.Max(mverr, Math.Sqrt(math.abscomplex(v)));
                    }
                }
            }
            
            //
            // report
            //
            waserrors = (double)(mverr)>(double)(threshold);
            if( !silent )
            {
                System.Console.Write("TESTING HERMITIAN BLAS");
                System.Console.WriteLine();
                System.Console.Write("MV error:                                ");
                System.Console.Write("{0,5:E3}",mverr);
                System.Console.WriteLine();
                System.Console.Write("Threshold:                               ");
                System.Console.Write("{0,5:E3}",threshold);
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testhblas(bool silent)
        {
            return testhblas(silent);
        }


    }
    public class testreflectionsunit
    {
        public static bool testreflections(bool silent)
        {
            bool result = new bool();
            int i = 0;
            int j = 0;
            int n = 0;
            int m = 0;
            int maxmn = 0;
            double[] x = new double[0];
            double[] v = new double[0];
            double[] work = new double[0];
            double[,] h = new double[0,0];
            double[,] a = new double[0,0];
            double[,] b = new double[0,0];
            double[,] c = new double[0,0];
            double tmp = 0;
            double beta = 0;
            double tau = 0;
            double err = 0;
            double mer = 0;
            double mel = 0;
            double meg = 0;
            int pass = 0;
            int passcount = 0;
            double threshold = 0;
            int tasktype = 0;
            double xscale = 0;
            int i_ = 0;

            passcount = 10;
            threshold = 100*math.machineepsilon;
            mer = 0;
            mel = 0;
            meg = 0;
            for(pass=1; pass<=passcount; pass++)
            {
                for(n=1; n<=10; n++)
                {
                    for(m=1; m<=10; m++)
                    {
                        
                        //
                        // Task
                        //
                        n = 1+math.randominteger(10);
                        m = 1+math.randominteger(10);
                        maxmn = Math.Max(m, n);
                        
                        //
                        // Initialize
                        //
                        x = new double[maxmn+1];
                        v = new double[maxmn+1];
                        work = new double[maxmn+1];
                        h = new double[maxmn+1, maxmn+1];
                        a = new double[maxmn+1, maxmn+1];
                        b = new double[maxmn+1, maxmn+1];
                        c = new double[maxmn+1, maxmn+1];
                        
                        //
                        // GenerateReflection, three tasks are possible:
                        // * random X
                        // * zero X
                        // * non-zero X[1], all other are zeros
                        // * random X, near underflow scale
                        // * random X, near overflow scale
                        //
                        for(tasktype=0; tasktype<=4; tasktype++)
                        {
                            xscale = 1;
                            if( tasktype==0 )
                            {
                                for(i=1; i<=n; i++)
                                {
                                    x[i] = 2*math.randomreal()-1;
                                }
                            }
                            if( tasktype==1 )
                            {
                                for(i=1; i<=n; i++)
                                {
                                    x[i] = 0;
                                }
                            }
                            if( tasktype==2 )
                            {
                                x[1] = 2*math.randomreal()-1;
                                for(i=2; i<=n; i++)
                                {
                                    x[i] = 0;
                                }
                            }
                            if( tasktype==3 )
                            {
                                for(i=1; i<=n; i++)
                                {
                                    x[i] = (math.randominteger(21)-10)*math.minrealnumber;
                                }
                                xscale = 10*math.minrealnumber;
                            }
                            if( tasktype==4 )
                            {
                                for(i=1; i<=n; i++)
                                {
                                    x[i] = (2*math.randomreal()-1)*math.maxrealnumber;
                                }
                                xscale = math.maxrealnumber;
                            }
                            for(i_=1; i_<=n;i_++)
                            {
                                v[i_] = x[i_];
                            }
                            reflections.generatereflection(ref v, n, ref tau);
                            beta = v[1];
                            v[1] = 1;
                            for(i=1; i<=n; i++)
                            {
                                for(j=1; j<=n; j++)
                                {
                                    if( i==j )
                                    {
                                        h[i,j] = 1-tau*v[i]*v[j];
                                    }
                                    else
                                    {
                                        h[i,j] = -(tau*v[i]*v[j]);
                                    }
                                }
                            }
                            err = 0;
                            for(i=1; i<=n; i++)
                            {
                                tmp = 0.0;
                                for(i_=1; i_<=n;i_++)
                                {
                                    tmp += h[i,i_]*x[i_];
                                }
                                if( i==1 )
                                {
                                    err = Math.Max(err, Math.Abs(tmp-beta));
                                }
                                else
                                {
                                    err = Math.Max(err, Math.Abs(tmp));
                                }
                            }
                            meg = Math.Max(meg, err/xscale);
                        }
                        
                        //
                        // ApplyReflectionFromTheLeft
                        //
                        for(i=1; i<=m; i++)
                        {
                            x[i] = 2*math.randomreal()-1;
                            v[i] = x[i];
                        }
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                a[i,j] = 2*math.randomreal()-1;
                                b[i,j] = a[i,j];
                            }
                        }
                        reflections.generatereflection(ref v, m, ref tau);
                        beta = v[1];
                        v[1] = 1;
                        reflections.applyreflectionfromtheleft(ref b, tau, v, 1, m, 1, n, ref work);
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=m; j++)
                            {
                                if( i==j )
                                {
                                    h[i,j] = 1-tau*v[i]*v[j];
                                }
                                else
                                {
                                    h[i,j] = -(tau*v[i]*v[j]);
                                }
                            }
                        }
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                tmp = 0.0;
                                for(i_=1; i_<=m;i_++)
                                {
                                    tmp += h[i,i_]*a[i_,j];
                                }
                                c[i,j] = tmp;
                            }
                        }
                        err = 0;
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                err = Math.Max(err, Math.Abs(b[i,j]-c[i,j]));
                            }
                        }
                        mel = Math.Max(mel, err);
                        
                        //
                        // ApplyReflectionFromTheRight
                        //
                        for(i=1; i<=n; i++)
                        {
                            x[i] = 2*math.randomreal()-1;
                            v[i] = x[i];
                        }
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                a[i,j] = 2*math.randomreal()-1;
                                b[i,j] = a[i,j];
                            }
                        }
                        reflections.generatereflection(ref v, n, ref tau);
                        beta = v[1];
                        v[1] = 1;
                        reflections.applyreflectionfromtheright(ref b, tau, v, 1, m, 1, n, ref work);
                        for(i=1; i<=n; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                if( i==j )
                                {
                                    h[i,j] = 1-tau*v[i]*v[j];
                                }
                                else
                                {
                                    h[i,j] = -(tau*v[i]*v[j]);
                                }
                            }
                        }
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                tmp = 0.0;
                                for(i_=1; i_<=n;i_++)
                                {
                                    tmp += a[i,i_]*h[i_,j];
                                }
                                c[i,j] = tmp;
                            }
                        }
                        err = 0;
                        for(i=1; i<=m; i++)
                        {
                            for(j=1; j<=n; j++)
                            {
                                err = Math.Max(err, Math.Abs(b[i,j]-c[i,j]));
                            }
                        }
                        mer = Math.Max(mer, err);
                    }
                }
            }
            
            //
            // Overflow crash test
            //
            x = new double[10+1];
            v = new double[10+1];
            for(i=1; i<=10; i++)
            {
                v[i] = math.maxrealnumber*0.01*(2*math.randomreal()-1);
            }
            reflections.generatereflection(ref v, 10, ref tau);
            result = ((double)(meg)<=(double)(threshold) && (double)(mel)<=(double)(threshold)) && (double)(mer)<=(double)(threshold);
            if( !silent )
            {
                System.Console.Write("TESTING REFLECTIONS");
                System.Console.WriteLine();
                System.Console.Write("Pass count is ");
                System.Console.Write("{0,0:d}",passcount);
                System.Console.WriteLine();
                System.Console.Write("Generate     absolute error is       ");
                System.Console.Write("{0,5:E3}",meg);
                System.Console.WriteLine();
                System.Console.Write("Apply(Left)  absolute error is       ");
                System.Console.Write("{0,5:E3}",mel);
                System.Console.WriteLine();
                System.Console.Write("Apply(Right) absolute error is       ");
                System.Console.Write("{0,5:E3}",mer);
                System.Console.WriteLine();
                System.Console.Write("Overflow crash test passed");
                System.Console.WriteLine();
                if( result )
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
            }
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testreflections(bool silent)
        {
            return testreflections(silent);
        }


    }
    public class testcreflectionsunit
    {
        public static bool testcreflections(bool silent)
        {
            bool result = new bool();
            int i = 0;
            int j = 0;
            int n = 0;
            int m = 0;
            int maxmn = 0;
            complex[] x = new complex[0];
            complex[] v = new complex[0];
            complex[] work = new complex[0];
            complex[,] h = new complex[0,0];
            complex[,] a = new complex[0,0];
            complex[,] b = new complex[0,0];
            complex[,] c = new complex[0,0];
            complex tmp = 0;
            complex beta = 0;
            complex tau = 0;
            double err = 0;
            double mer = 0;
            double mel = 0;
            double meg = 0;
            int pass = 0;
            int passcount = 0;
            bool waserrors = new bool();
            double threshold = 0;
            int i_ = 0;

            threshold = 1000*math.machineepsilon;
            passcount = 1000;
            mer = 0;
            mel = 0;
            meg = 0;
            for(pass=1; pass<=passcount; pass++)
            {
                
                //
                // Task
                //
                n = 1+math.randominteger(10);
                m = 1+math.randominteger(10);
                maxmn = Math.Max(m, n);
                
                //
                // Initialize
                //
                x = new complex[maxmn+1];
                v = new complex[maxmn+1];
                work = new complex[maxmn+1];
                h = new complex[maxmn+1, maxmn+1];
                a = new complex[maxmn+1, maxmn+1];
                b = new complex[maxmn+1, maxmn+1];
                c = new complex[maxmn+1, maxmn+1];
                
                //
                // GenerateReflection
                //
                for(i=1; i<=n; i++)
                {
                    x[i].x = 2*math.randomreal()-1;
                    x[i].y = 2*math.randomreal()-1;
                    v[i] = x[i];
                }
                creflections.complexgeneratereflection(ref v, n, ref tau);
                beta = v[1];
                v[1] = 1;
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        if( i==j )
                        {
                            h[i,j] = 1-tau*v[i]*math.conj(v[j]);
                        }
                        else
                        {
                            h[i,j] = -(tau*v[i]*math.conj(v[j]));
                        }
                    }
                }
                err = 0;
                for(i=1; i<=n; i++)
                {
                    tmp = 0.0;
                    for(i_=1; i_<=n;i_++)
                    {
                        tmp += math.conj(h[i_,i])*x[i_];
                    }
                    if( i==1 )
                    {
                        err = Math.Max(err, math.abscomplex(tmp-beta));
                    }
                    else
                    {
                        err = Math.Max(err, math.abscomplex(tmp));
                    }
                }
                err = Math.Max(err, Math.Abs(beta.y));
                meg = Math.Max(meg, err);
                
                //
                // ApplyReflectionFromTheLeft
                //
                for(i=1; i<=m; i++)
                {
                    x[i].x = 2*math.randomreal()-1;
                    x[i].y = 2*math.randomreal()-1;
                    v[i] = x[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a[i,j].x = 2*math.randomreal()-1;
                        a[i,j].y = 2*math.randomreal()-1;
                        b[i,j] = a[i,j];
                    }
                }
                creflections.complexgeneratereflection(ref v, m, ref tau);
                beta = v[1];
                v[1] = 1;
                creflections.complexapplyreflectionfromtheleft(ref b, tau, v, 1, m, 1, n, ref work);
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=m; j++)
                    {
                        if( i==j )
                        {
                            h[i,j] = 1-tau*v[i]*math.conj(v[j]);
                        }
                        else
                        {
                            h[i,j] = -(tau*v[i]*math.conj(v[j]));
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = 0.0;
                        for(i_=1; i_<=m;i_++)
                        {
                            tmp += h[i,i_]*a[i_,j];
                        }
                        c[i,j] = tmp;
                    }
                }
                err = 0;
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = Math.Max(err, math.abscomplex(b[i,j]-c[i,j]));
                    }
                }
                mel = Math.Max(mel, err);
                
                //
                // ApplyReflectionFromTheRight
                //
                for(i=1; i<=n; i++)
                {
                    x[i] = 2*math.randomreal()-1;
                    v[i] = x[i];
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        a[i,j] = 2*math.randomreal()-1;
                        b[i,j] = a[i,j];
                    }
                }
                creflections.complexgeneratereflection(ref v, n, ref tau);
                beta = v[1];
                v[1] = 1;
                creflections.complexapplyreflectionfromtheright(ref b, tau, ref v, 1, m, 1, n, ref work);
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        if( i==j )
                        {
                            h[i,j] = 1-tau*v[i]*math.conj(v[j]);
                        }
                        else
                        {
                            h[i,j] = -(tau*v[i]*math.conj(v[j]));
                        }
                    }
                }
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        tmp = 0.0;
                        for(i_=1; i_<=n;i_++)
                        {
                            tmp += a[i,i_]*h[i_,j];
                        }
                        c[i,j] = tmp;
                    }
                }
                err = 0;
                for(i=1; i<=m; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        err = Math.Max(err, math.abscomplex(b[i,j]-c[i,j]));
                    }
                }
                mer = Math.Max(mer, err);
            }
            
            //
            // Overflow crash test
            //
            x = new complex[10+1];
            v = new complex[10+1];
            for(i=1; i<=10; i++)
            {
                v[i] = math.maxrealnumber*0.01*(2*math.randomreal()-1);
            }
            creflections.complexgeneratereflection(ref v, 10, ref tau);
            
            //
            // report
            //
            waserrors = ((double)(meg)>(double)(threshold) || (double)(mel)>(double)(threshold)) || (double)(mer)>(double)(threshold);
            if( !silent )
            {
                System.Console.Write("TESTING COMPLEX REFLECTIONS");
                System.Console.WriteLine();
                System.Console.Write("Generate error:                          ");
                System.Console.Write("{0,5:E3}",meg);
                System.Console.WriteLine();
                System.Console.Write("Apply(L) error:                          ");
                System.Console.Write("{0,5:E3}",mel);
                System.Console.WriteLine();
                System.Console.Write("Apply(R) error:                          ");
                System.Console.Write("{0,5:E3}",mer);
                System.Console.WriteLine();
                System.Console.Write("Threshold:                               ");
                System.Console.Write("{0,5:E3}",threshold);
                System.Console.WriteLine();
                System.Console.Write("Overflow crash test:                     PASSED");
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testcreflections(bool silent)
        {
            return testcreflections(silent);
        }


    }
    public class testsblasunit
    {
        public static bool testsblas(bool silent)
        {
            bool result = new bool();
            double[,] a = new double[0,0];
            double[,] ua = new double[0,0];
            double[,] la = new double[0,0];
            double[] x = new double[0];
            double[] y1 = new double[0];
            double[] y2 = new double[0];
            double[] y3 = new double[0];
            int n = 0;
            int maxn = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int i2 = 0;
            bool waserrors = new bool();
            double mverr = 0;
            double threshold = 0;
            double alpha = 0;
            double v = 0;
            int i_ = 0;
            int i1_ = 0;

            mverr = 0;
            waserrors = false;
            maxn = 10;
            threshold = 1000*math.machineepsilon;
            
            //
            // Test MV
            //
            for(n=2; n<=maxn; n++)
            {
                a = new double[n+1, n+1];
                ua = new double[n+1, n+1];
                la = new double[n+1, n+1];
                x = new double[n+1];
                y1 = new double[n+1];
                y2 = new double[n+1];
                y3 = new double[n+1];
                
                //
                // fill A, UA, LA
                //
                for(i=1; i<=n; i++)
                {
                    a[i,i] = 2*math.randomreal()-1;
                    for(j=i+1; j<=n; j++)
                    {
                        a[i,j] = 2*math.randomreal()-1;
                        a[j,i] = a[i,j];
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        ua[i,j] = 0;
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=i; j<=n; j++)
                    {
                        ua[i,j] = a[i,j];
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=n; j++)
                    {
                        la[i,j] = 0;
                    }
                }
                for(i=1; i<=n; i++)
                {
                    for(j=1; j<=i; j++)
                    {
                        la[i,j] = a[i,j];
                    }
                }
                
                //
                // test on different I1, I2
                //
                for(i1=1; i1<=n; i1++)
                {
                    for(i2=i1; i2<=n; i2++)
                    {
                        
                        //
                        // Fill X, choose Alpha
                        //
                        for(i=1; i<=i2-i1+1; i++)
                        {
                            x[i] = 2*math.randomreal()-1;
                        }
                        alpha = 2*math.randomreal()-1;
                        
                        //
                        // calculate A*x, UA*x, LA*x
                        //
                        for(i=i1; i<=i2; i++)
                        {
                            i1_ = (1)-(i1);
                            v = 0.0;
                            for(i_=i1; i_<=i2;i_++)
                            {
                                v += a[i,i_]*x[i_+i1_];
                            }
                            y1[i-i1+1] = alpha*v;
                        }
                        sblas.symmetricmatrixvectormultiply(ua, true, i1, i2, x, alpha, ref y2);
                        sblas.symmetricmatrixvectormultiply(la, false, i1, i2, x, alpha, ref y3);
                        
                        //
                        // Calculate error
                        //
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            y2[i_] = y2[i_] - y1[i_];
                        }
                        v = 0.0;
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            v += y2[i_]*y2[i_];
                        }
                        mverr = Math.Max(mverr, Math.Sqrt(v));
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            y3[i_] = y3[i_] - y1[i_];
                        }
                        v = 0.0;
                        for(i_=1; i_<=i2-i1+1;i_++)
                        {
                            v += y3[i_]*y3[i_];
                        }
                        mverr = Math.Max(mverr, Math.Sqrt(v));
                    }
                }
            }
            
            //
            // report
            //
            waserrors = (double)(mverr)>(double)(threshold);
            if( !silent )
            {
                System.Console.Write("TESTING SYMMETRIC BLAS");
                System.Console.WriteLine();
                System.Console.Write("MV error:                                ");
                System.Console.Write("{0,5:E3}",mverr);
                System.Console.WriteLine();
                System.Console.Write("Threshold:                               ");
                System.Console.Write("{0,5:E3}",threshold);
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testsblas(bool silent)
        {
            return testsblas(silent);
        }


    }
    public class testortfacunit
    {
        /*************************************************************************
        Main unittest subroutine
        *************************************************************************/
        public static bool testortfac(bool silent)
        {
            bool result = new bool();
            int maxmn = 0;
            double threshold = 0;
            int passcount = 0;
            int mx = 0;
            double[,] ra = new double[0,0];
            complex[,] ca = new complex[0,0];
            int m = 0;
            int n = 0;
            int pass = 0;
            int i = 0;
            int j = 0;
            bool rqrerrors = new bool();
            bool rlqerrors = new bool();
            bool cqrerrors = new bool();
            bool clqerrors = new bool();
            bool rbderrors = new bool();
            bool rhesserrors = new bool();
            bool rtderrors = new bool();
            bool ctderrors = new bool();
            bool waserrors = new bool();

            waserrors = false;
            rqrerrors = false;
            rlqerrors = false;
            cqrerrors = false;
            clqerrors = false;
            rbderrors = false;
            rhesserrors = false;
            rtderrors = false;
            ctderrors = false;
            maxmn = 3*ablas.ablasblocksize(ra)+1;
            passcount = 1;
            threshold = 5*1000*math.machineepsilon;
            
            //
            // Different problems
            //
            for(mx=1; mx<=maxmn; mx++)
            {
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // Rectangular factorizations: QR, LQ, bidiagonal
                    // Matrix types: zero, dense, sparse
                    //
                    n = 1+math.randominteger(mx);
                    m = 1+math.randominteger(mx);
                    if( (double)(math.randomreal())>(double)(0.5) )
                    {
                        n = mx;
                    }
                    else
                    {
                        m = mx;
                    }
                    ra = new double[m, n];
                    ca = new complex[m, n];
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ra[i,j] = 0;
                            ca[i,j] = 0;
                        }
                    }
                    testrqrproblem(ra, m, n, threshold, ref rqrerrors);
                    testrlqproblem(ra, m, n, threshold, ref rlqerrors);
                    testcqrproblem(ca, m, n, threshold, ref cqrerrors);
                    testclqproblem(ca, m, n, threshold, ref clqerrors);
                    testrbdproblem(ra, m, n, threshold, ref rbderrors);
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ra[i,j] = 2*math.randomreal()-1;
                            ca[i,j].x = 2*math.randomreal()-1;
                            ca[i,j].y = 2*math.randomreal()-1;
                        }
                    }
                    testrqrproblem(ra, m, n, threshold, ref rqrerrors);
                    testrlqproblem(ra, m, n, threshold, ref rlqerrors);
                    testcqrproblem(ca, m, n, threshold, ref cqrerrors);
                    testclqproblem(ca, m, n, threshold, ref clqerrors);
                    testrbdproblem(ra, m, n, threshold, ref rbderrors);
                    rmatrixfillsparsea(ref ra, m, n, 0.95);
                    cmatrixfillsparsea(ref ca, m, n, 0.95);
                    testrqrproblem(ra, m, n, threshold, ref rqrerrors);
                    testrlqproblem(ra, m, n, threshold, ref rlqerrors);
                    testcqrproblem(ca, m, n, threshold, ref cqrerrors);
                    testclqproblem(ca, m, n, threshold, ref clqerrors);
                    testrbdproblem(ra, m, n, threshold, ref rbderrors);
                    
                    //
                    // Square factorizations: Hessenberg, tridiagonal
                    // Matrix types: zero, dense, sparse
                    //
                    ra = new double[mx, mx];
                    ca = new complex[mx, mx];
                    for(i=0; i<=mx-1; i++)
                    {
                        for(j=0; j<=mx-1; j++)
                        {
                            ra[i,j] = 0;
                            ca[i,j] = 0;
                        }
                    }
                    testrhessproblem(ra, mx, threshold, ref rhesserrors);
                    for(i=0; i<=mx-1; i++)
                    {
                        for(j=0; j<=mx-1; j++)
                        {
                            ra[i,j] = 2*math.randomreal()-1;
                            ca[i,j].x = 2*math.randomreal()-1;
                            ca[i,j].y = 2*math.randomreal()-1;
                        }
                    }
                    testrhessproblem(ra, mx, threshold, ref rhesserrors);
                    rmatrixfillsparsea(ref ra, mx, mx, 0.95);
                    cmatrixfillsparsea(ref ca, mx, mx, 0.95);
                    testrhessproblem(ra, mx, threshold, ref rhesserrors);
                    
                    //
                    // Symetric factorizations: tridiagonal
                    // Matrix types: zero, dense, sparse
                    //
                    ra = new double[mx, mx];
                    ca = new complex[mx, mx];
                    for(i=0; i<=mx-1; i++)
                    {
                        for(j=0; j<=mx-1; j++)
                        {
                            ra[i,j] = 0;
                            ca[i,j] = 0;
                        }
                    }
                    testrtdproblem(ra, mx, threshold, ref rtderrors);
                    testctdproblem(ca, mx, threshold, ref ctderrors);
                    for(i=0; i<=mx-1; i++)
                    {
                        for(j=i; j<=mx-1; j++)
                        {
                            ra[i,j] = 2*math.randomreal()-1;
                            ca[i,j].x = 2*math.randomreal()-1;
                            ca[i,j].y = 2*math.randomreal()-1;
                            ra[j,i] = ra[i,j];
                            ca[j,i] = math.conj(ca[i,j]);
                        }
                    }
                    for(i=0; i<=mx-1; i++)
                    {
                        ca[i,i] = 2*math.randomreal()-1;
                    }
                    testrtdproblem(ra, mx, threshold, ref rtderrors);
                    testctdproblem(ca, mx, threshold, ref ctderrors);
                    rmatrixfillsparsea(ref ra, mx, mx, 0.95);
                    cmatrixfillsparsea(ref ca, mx, mx, 0.95);
                    for(i=0; i<=mx-1; i++)
                    {
                        for(j=i; j<=mx-1; j++)
                        {
                            ra[j,i] = ra[i,j];
                            ca[j,i] = math.conj(ca[i,j]);
                        }
                    }
                    for(i=0; i<=mx-1; i++)
                    {
                        ca[i,i] = 2*math.randomreal()-1;
                    }
                    testrtdproblem(ra, mx, threshold, ref rtderrors);
                    testctdproblem(ca, mx, threshold, ref ctderrors);
                }
            }
            
            //
            // report
            //
            waserrors = ((((((rqrerrors || rlqerrors) || cqrerrors) || clqerrors) || rbderrors) || rhesserrors) || rtderrors) || ctderrors;
            if( !silent )
            {
                System.Console.Write("TESTING ORTFAC UNIT");
                System.Console.WriteLine();
                System.Console.Write("RQR ERRORS:                              ");
                if( !rqrerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("RLQ ERRORS:                              ");
                if( !rlqerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("CQR ERRORS:                              ");
                if( !cqrerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("CLQ ERRORS:                              ");
                if( !clqerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("RBD ERRORS:                              ");
                if( !rbderrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("RHESS ERRORS:                            ");
                if( !rhesserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("RTD ERRORS:                              ");
                if( !rtderrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("CTD ERRORS:                              ");
                if( !ctderrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testortfac(bool silent)
        {
            return testortfac(silent);
        }


        /*************************************************************************
        Diff
        *************************************************************************/
        private static double rmatrixdiff(double[,] a,
            double[,] b,
            int m,
            int n)
        {
            double result = 0;
            int i = 0;
            int j = 0;

            result = 0;
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    result = Math.Max(result, Math.Abs(b[i,j]-a[i,j]));
                }
            }
            return result;
        }


        /*************************************************************************
        Copy
        *************************************************************************/
        private static void rmatrixmakeacopy(double[,] a,
            int m,
            int n,
            ref double[,] b)
        {
            int i = 0;
            int j = 0;

            b = new double[0,0];

            b = new double[m-1+1, n-1+1];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    b[i,j] = a[i,j];
                }
            }
        }


        /*************************************************************************
        Copy
        *************************************************************************/
        private static void cmatrixmakeacopy(complex[,] a,
            int m,
            int n,
            ref complex[,] b)
        {
            int i = 0;
            int j = 0;

            b = new complex[0,0];

            b = new complex[m-1+1, n-1+1];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    b[i,j] = a[i,j];
                }
            }
        }


        /*************************************************************************
        Sparse fill
        *************************************************************************/
        private static void rmatrixfillsparsea(ref double[,] a,
            int m,
            int n,
            double sparcity)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(math.randomreal())>=(double)(sparcity) )
                    {
                        a[i,j] = 2*math.randomreal()-1;
                    }
                    else
                    {
                        a[i,j] = 0;
                    }
                }
            }
        }


        /*************************************************************************
        Sparse fill
        *************************************************************************/
        private static void cmatrixfillsparsea(ref complex[,] a,
            int m,
            int n,
            double sparcity)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(math.randomreal())>=(double)(sparcity) )
                    {
                        a[i,j].x = 2*math.randomreal()-1;
                        a[i,j].y = 2*math.randomreal()-1;
                    }
                    else
                    {
                        a[i,j] = 0;
                    }
                }
            }
        }


        /*************************************************************************
        Matrix multiplication
        *************************************************************************/
        private static void internalmatrixmatrixmultiply(double[,] a,
            int ai1,
            int ai2,
            int aj1,
            int aj2,
            bool transa,
            double[,] b,
            int bi1,
            int bi2,
            int bj1,
            int bj2,
            bool transb,
            ref double[,] c,
            int ci1,
            int ci2,
            int cj1,
            int cj2)
        {
            int arows = 0;
            int acols = 0;
            int brows = 0;
            int bcols = 0;
            int crows = 0;
            int ccols = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int l = 0;
            int r = 0;
            double v = 0;
            double[] work = new double[0];
            double beta = 0;
            double alpha = 0;
            int i_ = 0;
            int i1_ = 0;

            
            //
            // Pre-setup
            //
            k = Math.Max(ai2-ai1+1, aj2-aj1+1);
            k = Math.Max(k, bi2-bi1+1);
            k = Math.Max(k, bj2-bj1+1);
            work = new double[k+1];
            beta = 0;
            alpha = 1;
            
            //
            // Setup
            //
            if( !transa )
            {
                arows = ai2-ai1+1;
                acols = aj2-aj1+1;
            }
            else
            {
                arows = aj2-aj1+1;
                acols = ai2-ai1+1;
            }
            if( !transb )
            {
                brows = bi2-bi1+1;
                bcols = bj2-bj1+1;
            }
            else
            {
                brows = bj2-bj1+1;
                bcols = bi2-bi1+1;
            }
            alglib.ap.assert(acols==brows, "MatrixMatrixMultiply: incorrect matrix sizes!");
            if( ((arows<=0 || acols<=0) || brows<=0) || bcols<=0 )
            {
                return;
            }
            crows = arows;
            ccols = bcols;
            
            //
            // Test WORK
            //
            i = Math.Max(arows, acols);
            i = Math.Max(brows, i);
            i = Math.Max(i, bcols);
            work[1] = 0;
            work[i] = 0;
            
            //
            // Prepare C
            //
            if( (double)(beta)==(double)(0) )
            {
                for(i=ci1; i<=ci2; i++)
                {
                    for(j=cj1; j<=cj2; j++)
                    {
                        c[i,j] = 0;
                    }
                }
            }
            else
            {
                for(i=ci1; i<=ci2; i++)
                {
                    for(i_=cj1; i_<=cj2;i_++)
                    {
                        c[i,i_] = beta*c[i,i_];
                    }
                }
            }
            
            //
            // A*B
            //
            if( !transa && !transb )
            {
                for(l=ai1; l<=ai2; l++)
                {
                    for(r=bi1; r<=bi2; r++)
                    {
                        v = alpha*a[l,aj1+r-bi1];
                        k = ci1+l-ai1;
                        i1_ = (bj1) - (cj1);
                        for(i_=cj1; i_<=cj2;i_++)
                        {
                            c[k,i_] = c[k,i_] + v*b[r,i_+i1_];
                        }
                    }
                }
                return;
            }
            
            //
            // A*B'
            //
            if( !transa && transb )
            {
                if( arows*acols<brows*bcols )
                {
                    for(r=bi1; r<=bi2; r++)
                    {
                        for(l=ai1; l<=ai2; l++)
                        {
                            i1_ = (bj1)-(aj1);
                            v = 0.0;
                            for(i_=aj1; i_<=aj2;i_++)
                            {
                                v += a[l,i_]*b[r,i_+i1_];
                            }
                            c[ci1+l-ai1,cj1+r-bi1] = c[ci1+l-ai1,cj1+r-bi1]+alpha*v;
                        }
                    }
                    return;
                }
                else
                {
                    for(l=ai1; l<=ai2; l++)
                    {
                        for(r=bi1; r<=bi2; r++)
                        {
                            i1_ = (bj1)-(aj1);
                            v = 0.0;
                            for(i_=aj1; i_<=aj2;i_++)
                            {
                                v += a[l,i_]*b[r,i_+i1_];
                            }
                            c[ci1+l-ai1,cj1+r-bi1] = c[ci1+l-ai1,cj1+r-bi1]+alpha*v;
                        }
                    }
                    return;
                }
            }
            
            //
            // A'*B
            //
            if( transa && !transb )
            {
                for(l=aj1; l<=aj2; l++)
                {
                    for(r=bi1; r<=bi2; r++)
                    {
                        v = alpha*a[ai1+r-bi1,l];
                        k = ci1+l-aj1;
                        i1_ = (bj1) - (cj1);
                        for(i_=cj1; i_<=cj2;i_++)
                        {
                            c[k,i_] = c[k,i_] + v*b[r,i_+i1_];
                        }
                    }
                }
                return;
            }
            
            //
            // A'*B'
            //
            if( transa && transb )
            {
                if( arows*acols<brows*bcols )
                {
                    for(r=bi1; r<=bi2; r++)
                    {
                        for(i=1; i<=crows; i++)
                        {
                            work[i] = 0.0;
                        }
                        for(l=ai1; l<=ai2; l++)
                        {
                            v = alpha*b[r,bj1+l-ai1];
                            k = cj1+r-bi1;
                            i1_ = (aj1) - (1);
                            for(i_=1; i_<=crows;i_++)
                            {
                                work[i_] = work[i_] + v*a[l,i_+i1_];
                            }
                        }
                        i1_ = (1) - (ci1);
                        for(i_=ci1; i_<=ci2;i_++)
                        {
                            c[i_,k] = c[i_,k] + work[i_+i1_];
                        }
                    }
                    return;
                }
                else
                {
                    for(l=aj1; l<=aj2; l++)
                    {
                        k = ai2-ai1+1;
                        i1_ = (ai1) - (1);
                        for(i_=1; i_<=k;i_++)
                        {
                            work[i_] = a[i_+i1_,l];
                        }
                        for(r=bi1; r<=bi2; r++)
                        {
                            i1_ = (bj1)-(1);
                            v = 0.0;
                            for(i_=1; i_<=k;i_++)
                            {
                                v += work[i_]*b[r,i_+i1_];
                            }
                            c[ci1+l-aj1,cj1+r-bi1] = c[ci1+l-aj1,cj1+r-bi1]+alpha*v;
                        }
                    }
                    return;
                }
            }
        }


        /*************************************************************************
        Problem testing
        *************************************************************************/
        private static void testrqrproblem(double[,] a,
            int m,
            int n,
            double threshold,
            ref bool qrerrors)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            double[,] b = new double[0,0];
            double[] taub = new double[0];
            double[,] q = new double[0,0];
            double[,] r = new double[0,0];
            double[,] q2 = new double[0,0];
            double v = 0;
            int i_ = 0;

            
            //
            // Test decompose-and-unpack error
            //
            rmatrixmakeacopy(a, m, n, ref b);
            ortfac.rmatrixqr(ref b, m, n, ref taub);
            ortfac.rmatrixqrunpackq(b, m, n, taub, m, ref q);
            ortfac.rmatrixqrunpackr(b, m, n, ref r);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        v += q[i,i_]*r[i_,j];
                    }
                    qrerrors = qrerrors || (double)(Math.Abs(v-a[i,j]))>(double)(threshold);
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=Math.Min(i, n-1)-1; j++)
                {
                    qrerrors = qrerrors || (double)(r[i,j])!=(double)(0);
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        v += q[i,i_]*q[j,i_];
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    qrerrors = qrerrors || (double)(Math.Abs(v))>=(double)(threshold);
                }
            }
            
            //
            // Test for other errors
            //
            k = 1+math.randominteger(m);
            ortfac.rmatrixqrunpackq(b, m, n, taub, k, ref q2);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    qrerrors = qrerrors || (double)(Math.Abs(q2[i,j]-q[i,j]))>(double)(10*math.machineepsilon);
                }
            }
        }


        /*************************************************************************
        Problem testing
        *************************************************************************/
        private static void testcqrproblem(complex[,] a,
            int m,
            int n,
            double threshold,
            ref bool qrerrors)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            complex[,] b = new complex[0,0];
            complex[] taub = new complex[0];
            complex[,] q = new complex[0,0];
            complex[,] r = new complex[0,0];
            complex[,] q2 = new complex[0,0];
            complex v = 0;
            int i_ = 0;

            
            //
            // Test decompose-and-unpack error
            //
            cmatrixmakeacopy(a, m, n, ref b);
            ortfac.cmatrixqr(ref b, m, n, ref taub);
            ortfac.cmatrixqrunpackq(b, m, n, taub, m, ref q);
            ortfac.cmatrixqrunpackr(b, m, n, ref r);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        v += q[i,i_]*r[i_,j];
                    }
                    qrerrors = qrerrors || (double)(math.abscomplex(v-a[i,j]))>(double)(threshold);
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=Math.Min(i, n-1)-1; j++)
                {
                    qrerrors = qrerrors || r[i,j]!=0;
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        v += q[i,i_]*math.conj(q[j,i_]);
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    qrerrors = qrerrors || (double)(math.abscomplex(v))>=(double)(threshold);
                }
            }
            
            //
            // Test for other errors
            //
            k = 1+math.randominteger(m);
            ortfac.cmatrixqrunpackq(b, m, n, taub, k, ref q2);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    qrerrors = qrerrors || (double)(math.abscomplex(q2[i,j]-q[i,j]))>(double)(10*math.machineepsilon);
                }
            }
        }


        /*************************************************************************
        Problem testing
        *************************************************************************/
        private static void testrlqproblem(double[,] a,
            int m,
            int n,
            double threshold,
            ref bool lqerrors)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            double[,] b = new double[0,0];
            double[] taub = new double[0];
            double[,] q = new double[0,0];
            double[,] l = new double[0,0];
            double[,] q2 = new double[0,0];
            double v = 0;
            int i_ = 0;

            
            //
            // Test decompose-and-unpack error
            //
            rmatrixmakeacopy(a, m, n, ref b);
            ortfac.rmatrixlq(ref b, m, n, ref taub);
            ortfac.rmatrixlqunpackq(b, m, n, taub, n, ref q);
            ortfac.rmatrixlqunpackl(b, m, n, ref l);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += l[i,i_]*q[i_,j];
                    }
                    lqerrors = lqerrors || (double)(Math.Abs(v-a[i,j]))>=(double)(threshold);
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=Math.Min(i, n-1)+1; j<=n-1; j++)
                {
                    lqerrors = lqerrors || (double)(l[i,j])!=(double)(0);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i,i_]*q[j,i_];
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    lqerrors = lqerrors || (double)(Math.Abs(v))>=(double)(threshold);
                }
            }
            
            //
            // Test for other errors
            //
            k = 1+math.randominteger(n);
            ortfac.rmatrixlqunpackq(b, m, n, taub, k, ref q2);
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    lqerrors = lqerrors || (double)(Math.Abs(q2[i,j]-q[i,j]))>(double)(10*math.machineepsilon);
                }
            }
        }


        /*************************************************************************
        Problem testing
        *************************************************************************/
        private static void testclqproblem(complex[,] a,
            int m,
            int n,
            double threshold,
            ref bool lqerrors)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            complex[,] b = new complex[0,0];
            complex[] taub = new complex[0];
            complex[,] q = new complex[0,0];
            complex[,] l = new complex[0,0];
            complex[,] q2 = new complex[0,0];
            complex v = 0;
            int i_ = 0;

            
            //
            // Test decompose-and-unpack error
            //
            cmatrixmakeacopy(a, m, n, ref b);
            ortfac.cmatrixlq(ref b, m, n, ref taub);
            ortfac.cmatrixlqunpackq(b, m, n, taub, n, ref q);
            ortfac.cmatrixlqunpackl(b, m, n, ref l);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += l[i,i_]*q[i_,j];
                    }
                    lqerrors = lqerrors || (double)(math.abscomplex(v-a[i,j]))>=(double)(threshold);
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=Math.Min(i, n-1)+1; j<=n-1; j++)
                {
                    lqerrors = lqerrors || l[i,j]!=0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i,i_]*math.conj(q[j,i_]);
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    lqerrors = lqerrors || (double)(math.abscomplex(v))>=(double)(threshold);
                }
            }
            
            //
            // Test for other errors
            //
            k = 1+math.randominteger(n);
            ortfac.cmatrixlqunpackq(b, m, n, taub, k, ref q2);
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    lqerrors = lqerrors || (double)(math.abscomplex(q2[i,j]-q[i,j]))>(double)(10*math.machineepsilon);
                }
            }
        }


        /*************************************************************************
        Problem testing
        *************************************************************************/
        private static void testrbdproblem(double[,] a,
            int m,
            int n,
            double threshold,
            ref bool bderrors)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            double[,] t = new double[0,0];
            double[,] pt = new double[0,0];
            double[,] q = new double[0,0];
            double[,] r = new double[0,0];
            double[,] bd = new double[0,0];
            double[,] x = new double[0,0];
            double[,] r1 = new double[0,0];
            double[,] r2 = new double[0,0];
            double[] taup = new double[0];
            double[] tauq = new double[0];
            double[] d = new double[0];
            double[] e = new double[0];
            bool up = new bool();
            double v = 0;
            int mtsize = 0;
            int i_ = 0;

            
            //
            // Bidiagonal decomposition error
            //
            rmatrixmakeacopy(a, m, n, ref t);
            ortfac.rmatrixbd(ref t, m, n, ref tauq, ref taup);
            ortfac.rmatrixbdunpackq(t, m, n, tauq, m, ref q);
            ortfac.rmatrixbdunpackpt(t, m, n, taup, n, ref pt);
            ortfac.rmatrixbdunpackdiagonals(t, m, n, ref up, ref d, ref e);
            bd = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    bd[i,j] = 0;
                }
            }
            for(i=0; i<=Math.Min(m, n)-1; i++)
            {
                bd[i,i] = d[i];
            }
            if( up )
            {
                for(i=0; i<=Math.Min(m, n)-2; i++)
                {
                    bd[i,i+1] = e[i];
                }
            }
            else
            {
                for(i=0; i<=Math.Min(m, n)-2; i++)
                {
                    bd[i+1,i] = e[i];
                }
            }
            r = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        v += q[i,i_]*bd[i_,j];
                    }
                    r[i,j] = v;
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += r[i,i_]*pt[i_,j];
                    }
                    bderrors = bderrors || (double)(Math.Abs(v-a[i,j]))>(double)(threshold);
                }
            }
            
            //
            // Orthogonality test for Q/PT
            //
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        v += q[i_,i]*q[i_,j];
                    }
                    if( i==j )
                    {
                        bderrors = bderrors || (double)(Math.Abs(v-1))>(double)(threshold);
                    }
                    else
                    {
                        bderrors = bderrors || (double)(Math.Abs(v))>(double)(threshold);
                    }
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += pt[i,i_]*pt[j,i_];
                    }
                    if( i==j )
                    {
                        bderrors = bderrors || (double)(Math.Abs(v-1))>(double)(threshold);
                    }
                    else
                    {
                        bderrors = bderrors || (double)(Math.Abs(v))>(double)(threshold);
                    }
                }
            }
            
            //
            // Partial unpacking test
            //
            k = 1+math.randominteger(m);
            ortfac.rmatrixbdunpackq(t, m, n, tauq, k, ref r);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=k-1; j++)
                {
                    bderrors = bderrors || (double)(Math.Abs(r[i,j]-q[i,j]))>(double)(10*math.machineepsilon);
                }
            }
            k = 1+math.randominteger(n);
            ortfac.rmatrixbdunpackpt(t, m, n, taup, k, ref r);
            for(i=0; i<=k-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    bderrors = bderrors || (double)(r[i,j]-pt[i,j])!=(double)(0);
                }
            }
            
            //
            // Multiplication test
            //
            x = new double[Math.Max(m, n)-1+1, Math.Max(m, n)-1+1];
            r = new double[Math.Max(m, n)-1+1, Math.Max(m, n)-1+1];
            r1 = new double[Math.Max(m, n)-1+1, Math.Max(m, n)-1+1];
            r2 = new double[Math.Max(m, n)-1+1, Math.Max(m, n)-1+1];
            for(i=0; i<=Math.Max(m, n)-1; i++)
            {
                for(j=0; j<=Math.Max(m, n)-1; j++)
                {
                    x[i,j] = 2*math.randomreal()-1;
                }
            }
            mtsize = 1+math.randominteger(Math.Max(m, n));
            rmatrixmakeacopy(x, mtsize, m, ref r);
            internalmatrixmatrixmultiply(r, 0, mtsize-1, 0, m-1, false, q, 0, m-1, 0, m-1, false, ref r1, 0, mtsize-1, 0, m-1);
            rmatrixmakeacopy(x, mtsize, m, ref r2);
            ortfac.rmatrixbdmultiplybyq(t, m, n, tauq, ref r2, mtsize, m, true, false);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, mtsize, m))>(double)(threshold);
            rmatrixmakeacopy(x, mtsize, m, ref r);
            internalmatrixmatrixmultiply(r, 0, mtsize-1, 0, m-1, false, q, 0, m-1, 0, m-1, true, ref r1, 0, mtsize-1, 0, m-1);
            rmatrixmakeacopy(x, mtsize, m, ref r2);
            ortfac.rmatrixbdmultiplybyq(t, m, n, tauq, ref r2, mtsize, m, true, true);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, mtsize, m))>(double)(threshold);
            rmatrixmakeacopy(x, m, mtsize, ref r);
            internalmatrixmatrixmultiply(q, 0, m-1, 0, m-1, false, r, 0, m-1, 0, mtsize-1, false, ref r1, 0, m-1, 0, mtsize-1);
            rmatrixmakeacopy(x, m, mtsize, ref r2);
            ortfac.rmatrixbdmultiplybyq(t, m, n, tauq, ref r2, m, mtsize, false, false);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, m, mtsize))>(double)(threshold);
            rmatrixmakeacopy(x, m, mtsize, ref r);
            internalmatrixmatrixmultiply(q, 0, m-1, 0, m-1, true, r, 0, m-1, 0, mtsize-1, false, ref r1, 0, m-1, 0, mtsize-1);
            rmatrixmakeacopy(x, m, mtsize, ref r2);
            ortfac.rmatrixbdmultiplybyq(t, m, n, tauq, ref r2, m, mtsize, false, true);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, m, mtsize))>(double)(threshold);
            rmatrixmakeacopy(x, mtsize, n, ref r);
            internalmatrixmatrixmultiply(r, 0, mtsize-1, 0, n-1, false, pt, 0, n-1, 0, n-1, true, ref r1, 0, mtsize-1, 0, n-1);
            rmatrixmakeacopy(x, mtsize, n, ref r2);
            ortfac.rmatrixbdmultiplybyp(t, m, n, taup, ref r2, mtsize, n, true, false);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, mtsize, n))>(double)(threshold);
            rmatrixmakeacopy(x, mtsize, n, ref r);
            internalmatrixmatrixmultiply(r, 0, mtsize-1, 0, n-1, false, pt, 0, n-1, 0, n-1, false, ref r1, 0, mtsize-1, 0, n-1);
            rmatrixmakeacopy(x, mtsize, n, ref r2);
            ortfac.rmatrixbdmultiplybyp(t, m, n, taup, ref r2, mtsize, n, true, true);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, mtsize, n))>(double)(threshold);
            rmatrixmakeacopy(x, n, mtsize, ref r);
            internalmatrixmatrixmultiply(pt, 0, n-1, 0, n-1, true, r, 0, n-1, 0, mtsize-1, false, ref r1, 0, n-1, 0, mtsize-1);
            rmatrixmakeacopy(x, n, mtsize, ref r2);
            ortfac.rmatrixbdmultiplybyp(t, m, n, taup, ref r2, n, mtsize, false, false);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, n, mtsize))>(double)(threshold);
            rmatrixmakeacopy(x, n, mtsize, ref r);
            internalmatrixmatrixmultiply(pt, 0, n-1, 0, n-1, false, r, 0, n-1, 0, mtsize-1, false, ref r1, 0, n-1, 0, mtsize-1);
            rmatrixmakeacopy(x, n, mtsize, ref r2);
            ortfac.rmatrixbdmultiplybyp(t, m, n, taup, ref r2, n, mtsize, false, true);
            bderrors = bderrors || (double)(rmatrixdiff(r1, r2, n, mtsize))>(double)(threshold);
        }


        /*************************************************************************
        Problem testing
        *************************************************************************/
        private static void testrhessproblem(double[,] a,
            int n,
            double threshold,
            ref bool hesserrors)
        {
            double[,] b = new double[0,0];
            double[,] h = new double[0,0];
            double[,] q = new double[0,0];
            double[,] t1 = new double[0,0];
            double[,] t2 = new double[0,0];
            double[] tau = new double[0];
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            rmatrixmakeacopy(a, n, n, ref b);
            
            //
            // Decomposition
            //
            ortfac.rmatrixhessenberg(ref b, n, ref tau);
            ortfac.rmatrixhessenbergunpackq(b, n, tau, ref q);
            ortfac.rmatrixhessenbergunpackh(b, n, ref h);
            
            //
            // Matrix properties
            //
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i_,i]*q[i_,j];
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    hesserrors = hesserrors || (double)(Math.Abs(v))>(double)(threshold);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i-2; j++)
                {
                    hesserrors = hesserrors || (double)(h[i,j])!=(double)(0);
                }
            }
            
            //
            // Decomposition error
            //
            t1 = new double[n, n];
            t2 = new double[n, n];
            internalmatrixmatrixmultiply(q, 0, n-1, 0, n-1, false, h, 0, n-1, 0, n-1, false, ref t1, 0, n-1, 0, n-1);
            internalmatrixmatrixmultiply(t1, 0, n-1, 0, n-1, false, q, 0, n-1, 0, n-1, true, ref t2, 0, n-1, 0, n-1);
            hesserrors = hesserrors || (double)(rmatrixdiff(t2, a, n, n))>(double)(threshold);
        }


        /*************************************************************************
        Tridiagonal tester
        *************************************************************************/
        private static void testrtdproblem(double[,] a,
            int n,
            double threshold,
            ref bool tderrors)
        {
            int i = 0;
            int j = 0;
            double[,] ua = new double[0,0];
            double[,] la = new double[0,0];
            double[,] t = new double[0,0];
            double[,] q = new double[0,0];
            double[,] t2 = new double[0,0];
            double[,] t3 = new double[0,0];
            double[] tau = new double[0];
            double[] d = new double[0];
            double[] e = new double[0];
            double v = 0;
            int i_ = 0;

            ua = new double[n-1+1, n-1+1];
            la = new double[n-1+1, n-1+1];
            t = new double[n-1+1, n-1+1];
            q = new double[n-1+1, n-1+1];
            t2 = new double[n-1+1, n-1+1];
            t3 = new double[n-1+1, n-1+1];
            
            //
            // fill
            //
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ua[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=i; j<=n-1; j++)
                {
                    ua[i,j] = a[i,j];
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    la[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    la[i,j] = a[i,j];
                }
            }
            
            //
            // Test 2tridiagonal: upper
            //
            ortfac.smatrixtd(ref ua, n, true, ref tau, ref d, ref e);
            ortfac.smatrixtdunpackq(ua, n, true, tau, ref q);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    t[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                t[i,i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                t[i,i+1] = e[i];
                t[i+1,i] = e[i];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i_,i]*a[i_,j];
                    }
                    t2[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += t2[i,i_]*q[i_,j];
                    }
                    t3[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    tderrors = tderrors || (double)(Math.Abs(t3[i,j]-t[i,j]))>(double)(threshold);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i,i_]*q[j,i_];
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    tderrors = tderrors || (double)(Math.Abs(v))>(double)(threshold);
                }
            }
            
            //
            // Test 2tridiagonal: lower
            //
            ortfac.smatrixtd(ref la, n, false, ref tau, ref d, ref e);
            ortfac.smatrixtdunpackq(la, n, false, tau, ref q);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    t[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                t[i,i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                t[i,i+1] = e[i];
                t[i+1,i] = e[i];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i_,i]*a[i_,j];
                    }
                    t2[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += t2[i,i_]*q[i_,j];
                    }
                    t3[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    tderrors = tderrors || (double)(Math.Abs(t3[i,j]-t[i,j]))>(double)(threshold);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i,i_]*q[j,i_];
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    tderrors = tderrors || (double)(Math.Abs(v))>(double)(threshold);
                }
            }
        }


        /*************************************************************************
        Hermitian problem tester
        *************************************************************************/
        private static void testctdproblem(complex[,] a,
            int n,
            double threshold,
            ref bool tderrors)
        {
            int i = 0;
            int j = 0;
            complex[,] ua = new complex[0,0];
            complex[,] la = new complex[0,0];
            complex[,] t = new complex[0,0];
            complex[,] q = new complex[0,0];
            complex[,] t2 = new complex[0,0];
            complex[,] t3 = new complex[0,0];
            complex[] tau = new complex[0];
            double[] d = new double[0];
            double[] e = new double[0];
            complex v = 0;
            int i_ = 0;

            ua = new complex[n-1+1, n-1+1];
            la = new complex[n-1+1, n-1+1];
            t = new complex[n-1+1, n-1+1];
            q = new complex[n-1+1, n-1+1];
            t2 = new complex[n-1+1, n-1+1];
            t3 = new complex[n-1+1, n-1+1];
            
            //
            // fill
            //
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ua[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=i; j<=n-1; j++)
                {
                    ua[i,j] = a[i,j];
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    la[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=i; j++)
                {
                    la[i,j] = a[i,j];
                }
            }
            
            //
            // Test 2tridiagonal: upper
            //
            ortfac.hmatrixtd(ref ua, n, true, ref tau, ref d, ref e);
            ortfac.hmatrixtdunpackq(ua, n, true, tau, ref q);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    t[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                t[i,i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                t[i,i+1] = e[i];
                t[i+1,i] = e[i];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += math.conj(q[i_,i])*a[i_,j];
                    }
                    t2[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += t2[i,i_]*q[i_,j];
                    }
                    t3[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    tderrors = tderrors || (double)(math.abscomplex(t3[i,j]-t[i,j]))>(double)(threshold);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i,i_]*math.conj(q[j,i_]);
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    tderrors = tderrors || (double)(math.abscomplex(v))>(double)(threshold);
                }
            }
            
            //
            // Test 2tridiagonal: lower
            //
            ortfac.hmatrixtd(ref la, n, false, ref tau, ref d, ref e);
            ortfac.hmatrixtdunpackq(la, n, false, tau, ref q);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    t[i,j] = 0;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                t[i,i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                t[i,i+1] = e[i];
                t[i+1,i] = e[i];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += math.conj(q[i_,i])*a[i_,j];
                    }
                    t2[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += t2[i,i_]*q[i_,j];
                    }
                    t3[i,j] = v;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    tderrors = tderrors || (double)(math.abscomplex(t3[i,j]-t[i,j]))>(double)(threshold);
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += q[i,i_]*math.conj(q[j,i_]);
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    tderrors = tderrors || (double)(math.abscomplex(v))>(double)(threshold);
                }
            }
        }


    }
    public class testbdsvdunit
    {
        /*************************************************************************
        Testing bidiagonal SVD decomposition subroutine
        *************************************************************************/
        public static bool testbdsvd(bool silent)
        {
            bool result = new bool();
            double[] d = new double[0];
            double[] e = new double[0];
            double[,] mempty = new double[0,0];
            int n = 0;
            int maxn = 0;
            int i = 0;
            int pass = 0;
            bool waserrors = new bool();
            bool wsorted = new bool();
            bool wfailed = new bool();
            double materr = 0;
            double orterr = 0;
            double threshold = 0;
            double failr = 0;
            int failcount = 0;
            int succcount = 0;

            failcount = 0;
            succcount = 0;
            materr = 0;
            orterr = 0;
            wsorted = true;
            wfailed = false;
            waserrors = false;
            maxn = 15;
            threshold = 5*100*math.machineepsilon;
            d = new double[maxn-1+1];
            e = new double[maxn-2+1];
            
            //
            // special case: zero divide matrix
            // unfixed LAPACK routine should fail on this problem
            //
            n = 7;
            d[0] = -6.96462904751731892700e-01;
            d[1] = 0.00000000000000000000e+00;
            d[2] = -5.73827770385971991400e-01;
            d[3] = -6.62562624399371191700e-01;
            d[4] = 5.82737148001782223600e-01;
            d[5] = 3.84825263580925003300e-01;
            d[6] = 9.84087420830525472200e-01;
            e[0] = -7.30307931760612871800e-02;
            e[1] = -2.30079042939542843800e-01;
            e[2] = -6.87824621739351216300e-01;
            e[3] = -1.77306437707837570600e-02;
            e[4] = 1.78285126526551632000e-15;
            e[5] = -4.89434737751289969400e-02;
            bdsvd.rmatrixbdsvd(ref d, e, n, true, false, ref mempty, 0, ref mempty, 0, ref mempty, 0);
            
            //
            // zero matrix, several cases
            //
            for(i=0; i<=maxn-1; i++)
            {
                d[i] = 0;
            }
            for(i=0; i<=maxn-2; i++)
            {
                e[i] = 0;
            }
            for(n=1; n<=maxn; n++)
            {
                testbdsvdproblem(d, e, n, ref materr, ref orterr, ref wsorted, ref wfailed, ref failcount, ref succcount);
            }
            
            //
            // Dense matrix
            //
            for(n=1; n<=maxn; n++)
            {
                for(pass=1; pass<=10; pass++)
                {
                    for(i=0; i<=maxn-1; i++)
                    {
                        d[i] = 2*math.randomreal()-1;
                    }
                    for(i=0; i<=maxn-2; i++)
                    {
                        e[i] = 2*math.randomreal()-1;
                    }
                    testbdsvdproblem(d, e, n, ref materr, ref orterr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                }
            }
            
            //
            // Sparse matrices, very sparse matrices, incredible sparse matrices
            //
            for(n=1; n<=maxn; n++)
            {
                for(pass=1; pass<=10; pass++)
                {
                    fillsparsede(ref d, ref e, n, 0.5);
                    testbdsvdproblem(d, e, n, ref materr, ref orterr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    fillsparsede(ref d, ref e, n, 0.8);
                    testbdsvdproblem(d, e, n, ref materr, ref orterr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    fillsparsede(ref d, ref e, n, 0.9);
                    testbdsvdproblem(d, e, n, ref materr, ref orterr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    fillsparsede(ref d, ref e, n, 0.95);
                    testbdsvdproblem(d, e, n, ref materr, ref orterr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                }
            }
            
            //
            // report
            //
            failr = (double)failcount/(double)(succcount+failcount);
            waserrors = ((wfailed || (double)(materr)>(double)(threshold)) || (double)(orterr)>(double)(threshold)) || !wsorted;
            if( !silent )
            {
                System.Console.Write("TESTING BIDIAGONAL SVD DECOMPOSITION");
                System.Console.WriteLine();
                System.Console.Write("SVD decomposition error:                 ");
                System.Console.Write("{0,5:E3}",materr);
                System.Console.WriteLine();
                System.Console.Write("SVD orthogonality error:                 ");
                System.Console.Write("{0,5:E3}",orterr);
                System.Console.WriteLine();
                System.Console.Write("Singular values order:                   ");
                if( wsorted )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("Always converged:                        ");
                if( !wfailed )
                {
                    System.Console.Write("YES");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("NO");
                    System.Console.WriteLine();
                    System.Console.Write("Fail ratio:                              ");
                    System.Console.Write("{0,5:F3}",failr);
                    System.Console.WriteLine();
                }
                System.Console.Write("Threshold:                               ");
                System.Console.Write("{0,5:E3}",threshold);
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testbdsvd(bool silent)
        {
            return testbdsvd(silent);
        }


        private static void fillidentity(ref double[,] a,
            int n)
        {
            int i = 0;
            int j = 0;

            a = new double[n-1+1, n-1+1];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( i==j )
                    {
                        a[i,j] = 1;
                    }
                    else
                    {
                        a[i,j] = 0;
                    }
                }
            }
        }


        private static void fillsparsede(ref double[] d,
            ref double[] e,
            int n,
            double sparcity)
        {
            int i = 0;

            d = new double[n-1+1];
            e = new double[Math.Max(0, n-2)+1];
            for(i=0; i<=n-1; i++)
            {
                if( (double)(math.randomreal())>=(double)(sparcity) )
                {
                    d[i] = 2*math.randomreal()-1;
                }
                else
                {
                    d[i] = 0;
                }
            }
            for(i=0; i<=n-2; i++)
            {
                if( (double)(math.randomreal())>=(double)(sparcity) )
                {
                    e[i] = 2*math.randomreal()-1;
                }
                else
                {
                    e[i] = 0;
                }
            }
        }


        private static void getbdsvderror(double[] d,
            double[] e,
            int n,
            bool isupper,
            double[,] u,
            double[,] c,
            double[] w,
            double[,] vt,
            ref double materr,
            ref double orterr,
            ref bool wsorted)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            double locerr = 0;
            double sm = 0;
            int i_ = 0;

            
            //
            // decomposition error
            //
            locerr = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    sm = 0;
                    for(k=0; k<=n-1; k++)
                    {
                        sm = sm+w[k]*u[i,k]*vt[k,j];
                    }
                    if( isupper )
                    {
                        if( i==j )
                        {
                            locerr = Math.Max(locerr, Math.Abs(d[i]-sm));
                        }
                        else
                        {
                            if( i==j-1 )
                            {
                                locerr = Math.Max(locerr, Math.Abs(e[i]-sm));
                            }
                            else
                            {
                                locerr = Math.Max(locerr, Math.Abs(sm));
                            }
                        }
                    }
                    else
                    {
                        if( i==j )
                        {
                            locerr = Math.Max(locerr, Math.Abs(d[i]-sm));
                        }
                        else
                        {
                            if( i-1==j )
                            {
                                locerr = Math.Max(locerr, Math.Abs(e[j]-sm));
                            }
                            else
                            {
                                locerr = Math.Max(locerr, Math.Abs(sm));
                            }
                        }
                    }
                }
            }
            materr = Math.Max(materr, locerr);
            
            //
            // check for C = U'
            // we consider it as decomposition error
            //
            locerr = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    locerr = Math.Max(locerr, Math.Abs(u[i,j]-c[j,i]));
                }
            }
            materr = Math.Max(materr, locerr);
            
            //
            // orthogonality error
            //
            locerr = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=i; j<=n-1; j++)
                {
                    sm = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sm += u[i_,i]*u[i_,j];
                    }
                    if( i!=j )
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm));
                    }
                    else
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm-1));
                    }
                    sm = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sm += vt[i,i_]*vt[j,i_];
                    }
                    if( i!=j )
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm));
                    }
                    else
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm-1));
                    }
                }
            }
            orterr = Math.Max(orterr, locerr);
            
            //
            // values order error
            //
            for(i=1; i<=n-1; i++)
            {
                if( (double)(w[i])>(double)(w[i-1]) )
                {
                    wsorted = false;
                }
            }
        }


        private static void checksvdmultiplication(double[] d,
            double[] e,
            int n,
            bool isupper,
            double[,] u,
            double[,] c,
            double[] w,
            double[,] vt,
            ref double err)
        {
            int i = 0;
            int j = 0;
            double[] wt = new double[0];
            double[,] u2 = new double[0,0];
            double[,] c2 = new double[0,0];
            double[,] vt2 = new double[0,0];
            double[,] u1 = new double[0,0];
            double[,] c1 = new double[0,0];
            double[,] vt1 = new double[0,0];
            int nru = 0;
            int ncc = 0;
            int ncvt = 0;
            int pass = 0;
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            double v = 0;
            int i_ = 0;

            hqrnd.hqrndrandomize(rs);
            wt = new double[n];
            
            //
            // Perform nonsquare SVD
            //
            for(pass=1; pass<=20; pass++)
            {
                
                //
                // Problem size
                //
                nru = hqrnd.hqrnduniformi(rs, 2*n);
                ncc = hqrnd.hqrnduniformi(rs, 2*n);
                ncvt = hqrnd.hqrnduniformi(rs, 2*n);
                
                //
                // Reference matrices (copy 1) and working matrices (copy 2)
                //
                for(i=0; i<=n-1; i++)
                {
                    wt[i] = d[i];
                }
                if( nru>0 )
                {
                    
                    //
                    // init U1/U2
                    //
                    u1 = new double[nru, n];
                    u2 = new double[nru, n];
                    for(i=0; i<=alglib.ap.rows(u1)-1; i++)
                    {
                        for(j=0; j<=alglib.ap.cols(u1)-1; j++)
                        {
                            u1[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                            u2[i,j] = u1[i,j];
                        }
                    }
                }
                else
                {
                    
                    //
                    // Set U1/U2 to 1x1 matrices; working with 1x1 matrices allows
                    // to test correctness of code which passes them to MKL.
                    //
                    u1 = new double[1, 1];
                    u2 = new double[1, 1];
                }
                if( ncc>0 )
                {
                    c1 = new double[n, ncc];
                    c2 = new double[n, ncc];
                    for(i=0; i<=alglib.ap.rows(c1)-1; i++)
                    {
                        for(j=0; j<=alglib.ap.cols(c1)-1; j++)
                        {
                            c1[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                            c2[i,j] = c1[i,j];
                        }
                    }
                }
                else
                {
                    
                    //
                    // Set C1/C1 to 1x1 matrices; working with 1x1 matrices allows
                    // to test correctness of code which passes them to MKL.
                    //
                    c1 = new double[1, 1];
                    c2 = new double[1, 1];
                }
                if( ncvt>0 )
                {
                    vt1 = new double[n, ncvt];
                    vt2 = new double[n, ncvt];
                    for(i=0; i<=alglib.ap.rows(vt1)-1; i++)
                    {
                        for(j=0; j<=alglib.ap.cols(vt1)-1; j++)
                        {
                            vt1[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                            vt2[i,j] = vt1[i,j];
                        }
                    }
                }
                else
                {
                    
                    //
                    // Set VT1/VT1 to 1x1 matrices; working with 1x1 matrices allows
                    // to test correctness of code which passes them to MKL.
                    //
                    vt1 = new double[1, 1];
                    vt2 = new double[1, 1];
                }
                
                //
                // SVD with non-square U/C/VT
                //
                if( !bdsvd.rmatrixbdsvd(ref wt, e, n, isupper, (double)(hqrnd.hqrnduniformr(rs))>(double)(0), ref u2, nru, ref c2, ncc, ref vt2, ncvt) )
                {
                    err = 1.0;
                    return;
                }
                for(i=0; i<=nru-1; i++)
                {
                    for(j=0; j<=alglib.ap.cols(u2)-1; j++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=n-1;i_++)
                        {
                            v += u1[i,i_]*u[i_,j];
                        }
                        err = Math.Max(err, Math.Abs(v-u2[i,j]));
                    }
                }
                for(i=0; i<=alglib.ap.rows(c2)-1; i++)
                {
                    for(j=0; j<=ncc-1; j++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=n-1;i_++)
                        {
                            v += c[i,i_]*c1[i_,j];
                        }
                        err = Math.Max(err, Math.Abs(v-c2[i,j]));
                    }
                }
                for(i=0; i<=alglib.ap.rows(vt2)-1; i++)
                {
                    for(j=0; j<=ncvt-1; j++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=n-1;i_++)
                        {
                            v += vt[i,i_]*vt1[i_,j];
                        }
                        err = Math.Max(err, Math.Abs(v-vt2[i,j]));
                    }
                }
            }
        }


        private static void testbdsvdproblem(double[] d,
            double[] e,
            int n,
            ref double materr,
            ref double orterr,
            ref bool wsorted,
            ref bool wfailed,
            ref int failcount,
            ref int succcount)
        {
            double[,] u = new double[0,0];
            double[,] vt = new double[0,0];
            double[,] c = new double[0,0];
            double[] w = new double[0];
            int i = 0;
            double mx = 0;

            mx = 0;
            for(i=0; i<=n-1; i++)
            {
                if( (double)(Math.Abs(d[i]))>(double)(mx) )
                {
                    mx = Math.Abs(d[i]);
                }
            }
            for(i=0; i<=n-2; i++)
            {
                if( (double)(Math.Abs(e[i]))>(double)(mx) )
                {
                    mx = Math.Abs(e[i]);
                }
            }
            if( (double)(mx)==(double)(0) )
            {
                mx = 1;
            }
            
            //
            // Upper BDSVD tests
            //
            w = new double[n-1+1];
            fillidentity(ref u, n);
            fillidentity(ref vt, n);
            fillidentity(ref c, n);
            for(i=0; i<=n-1; i++)
            {
                w[i] = d[i];
            }
            if( !bdsvd.rmatrixbdsvd(ref w, e, n, true, false, ref u, n, ref c, n, ref vt, n) )
            {
                failcount = failcount+1;
                wfailed = true;
                return;
            }
            getbdsvderror(d, e, n, true, u, c, w, vt, ref materr, ref orterr, ref wsorted);
            checksvdmultiplication(d, e, n, true, u, c, w, vt, ref materr);
            fillidentity(ref u, n);
            fillidentity(ref vt, n);
            fillidentity(ref c, n);
            for(i=0; i<=n-1; i++)
            {
                w[i] = d[i];
            }
            if( !bdsvd.rmatrixbdsvd(ref w, e, n, true, true, ref u, n, ref c, n, ref vt, n) )
            {
                failcount = failcount+1;
                wfailed = true;
                return;
            }
            getbdsvderror(d, e, n, true, u, c, w, vt, ref materr, ref orterr, ref wsorted);
            checksvdmultiplication(d, e, n, true, u, c, w, vt, ref materr);
            
            //
            // Lower BDSVD tests
            //
            w = new double[n-1+1];
            fillidentity(ref u, n);
            fillidentity(ref vt, n);
            fillidentity(ref c, n);
            for(i=0; i<=n-1; i++)
            {
                w[i] = d[i];
            }
            if( !bdsvd.rmatrixbdsvd(ref w, e, n, false, false, ref u, n, ref c, n, ref vt, n) )
            {
                failcount = failcount+1;
                wfailed = true;
                return;
            }
            getbdsvderror(d, e, n, false, u, c, w, vt, ref materr, ref orterr, ref wsorted);
            checksvdmultiplication(d, e, n, false, u, c, w, vt, ref materr);
            fillidentity(ref u, n);
            fillidentity(ref vt, n);
            fillidentity(ref c, n);
            for(i=0; i<=n-1; i++)
            {
                w[i] = d[i];
            }
            if( !bdsvd.rmatrixbdsvd(ref w, e, n, false, true, ref u, n, ref c, n, ref vt, n) )
            {
                failcount = failcount+1;
                wfailed = true;
                return;
            }
            getbdsvderror(d, e, n, false, u, c, w, vt, ref materr, ref orterr, ref wsorted);
            checksvdmultiplication(d, e, n, false, u, c, w, vt, ref materr);
            
            //
            // update counter
            //
            succcount = succcount+1;
        }


    }
    public class testsvdunit
    {
        /*************************************************************************
        Testing SVD decomposition subroutine
        *************************************************************************/
        public static bool testsvd(bool silent)
        {
            bool result = new bool();
            double[,] a = new double[0,0];
            int m = 0;
            int n = 0;
            int maxmn = 0;
            int i = 0;
            int j = 0;
            int gpass = 0;
            int pass = 0;
            bool waserrors = new bool();
            bool wsorted = new bool();
            bool wfailed = new bool();
            double materr = 0;
            double orterr = 0;
            double othererr = 0;
            double threshold = 0;
            double failr = 0;
            int failcount = 0;
            int succcount = 0;

            failcount = 0;
            succcount = 0;
            materr = 0;
            orterr = 0;
            othererr = 0;
            wsorted = true;
            wfailed = false;
            waserrors = false;
            maxmn = 30;
            threshold = 5*100*math.machineepsilon;
            a = new double[maxmn-1+1, maxmn-1+1];
            
            //
            // TODO: div by zero fail, convergence fail
            //
            for(gpass=1; gpass<=1; gpass++)
            {
                
                //
                // zero matrix, several cases
                //
                for(i=0; i<=maxmn-1; i++)
                {
                    for(j=0; j<=maxmn-1; j++)
                    {
                        a[i,j] = 0;
                    }
                }
                for(i=1; i<=Math.Min(5, maxmn); i++)
                {
                    for(j=1; j<=Math.Min(5, maxmn); j++)
                    {
                        testsvdproblem(a, i, j, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    }
                }
                
                //
                // Long dense matrix
                //
                for(i=0; i<=maxmn-1; i++)
                {
                    for(j=0; j<=Math.Min(5, maxmn)-1; j++)
                    {
                        a[i,j] = 2*math.randomreal()-1;
                    }
                }
                for(i=1; i<=maxmn; i++)
                {
                    for(j=1; j<=Math.Min(5, maxmn); j++)
                    {
                        testsvdproblem(a, i, j, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    }
                }
                for(i=0; i<=Math.Min(5, maxmn)-1; i++)
                {
                    for(j=0; j<=maxmn-1; j++)
                    {
                        a[i,j] = 2*math.randomreal()-1;
                    }
                }
                for(i=1; i<=Math.Min(5, maxmn); i++)
                {
                    for(j=1; j<=maxmn; j++)
                    {
                        testsvdproblem(a, i, j, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    }
                }
                
                //
                // Dense matrices
                //
                for(m=1; m<=Math.Min(10, maxmn); m++)
                {
                    for(n=1; n<=Math.Min(10, maxmn); n++)
                    {
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                a[i,j] = 2*math.randomreal()-1;
                            }
                        }
                        testsvdproblem(a, m, n, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                    }
                }
                
                //
                // Sparse matrices, very sparse matrices, incredible sparse matrices
                //
                for(m=1; m<=10; m++)
                {
                    for(n=1; n<=10; n++)
                    {
                        for(pass=1; pass<=2; pass++)
                        {
                            fillsparsea(ref a, m, n, 0.8);
                            testsvdproblem(a, m, n, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                            fillsparsea(ref a, m, n, 0.9);
                            testsvdproblem(a, m, n, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                            fillsparsea(ref a, m, n, 0.95);
                            testsvdproblem(a, m, n, ref materr, ref orterr, ref othererr, ref wsorted, ref wfailed, ref failcount, ref succcount);
                        }
                    }
                }
            }
            
            //
            // report
            //
            failr = (double)failcount/(double)(succcount+failcount);
            waserrors = (((wfailed || (double)(materr)>(double)(threshold)) || (double)(orterr)>(double)(threshold)) || (double)(othererr)>(double)(threshold)) || !wsorted;
            if( !silent )
            {
                System.Console.Write("TESTING SVD DECOMPOSITION");
                System.Console.WriteLine();
                System.Console.Write("SVD decomposition error:                 ");
                System.Console.Write("{0,5:E3}",materr);
                System.Console.WriteLine();
                System.Console.Write("SVD orthogonality error:                 ");
                System.Console.Write("{0,5:E3}",orterr);
                System.Console.WriteLine();
                System.Console.Write("SVD with different parameters error:     ");
                System.Console.Write("{0,5:E3}",othererr);
                System.Console.WriteLine();
                System.Console.Write("Singular values order:                   ");
                if( wsorted )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("Always converged:                        ");
                if( !wfailed )
                {
                    System.Console.Write("YES");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("NO");
                    System.Console.WriteLine();
                    System.Console.Write("Fail ratio:                              ");
                    System.Console.Write("{0,5:F3}",failr);
                    System.Console.WriteLine();
                }
                System.Console.Write("Threshold:                               ");
                System.Console.Write("{0,5:E3}",threshold);
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testsvd(bool silent)
        {
            return testsvd(silent);
        }


        private static void fillsparsea(ref double[,] a,
            int m,
            int n,
            double sparcity)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(math.randomreal())>=(double)(sparcity) )
                    {
                        a[i,j] = 2*math.randomreal()-1;
                    }
                    else
                    {
                        a[i,j] = 0;
                    }
                }
            }
        }


        private static void getsvderror(double[,] a,
            int m,
            int n,
            double[,] u,
            double[] w,
            double[,] vt,
            ref double materr,
            ref double orterr,
            ref bool wsorted)
        {
            int i = 0;
            int j = 0;
            int k = 0;
            int minmn = 0;
            double locerr = 0;
            double sm = 0;
            int i_ = 0;

            minmn = Math.Min(m, n);
            
            //
            // decomposition error
            //
            locerr = 0;
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    sm = 0;
                    for(k=0; k<=minmn-1; k++)
                    {
                        sm = sm+w[k]*u[i,k]*vt[k,j];
                    }
                    locerr = Math.Max(locerr, Math.Abs(a[i,j]-sm));
                }
            }
            materr = Math.Max(materr, locerr);
            
            //
            // orthogonality error
            //
            locerr = 0;
            for(i=0; i<=minmn-1; i++)
            {
                for(j=i; j<=minmn-1; j++)
                {
                    sm = 0.0;
                    for(i_=0; i_<=m-1;i_++)
                    {
                        sm += u[i_,i]*u[i_,j];
                    }
                    if( i!=j )
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm));
                    }
                    else
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm-1));
                    }
                    sm = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        sm += vt[i,i_]*vt[j,i_];
                    }
                    if( i!=j )
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm));
                    }
                    else
                    {
                        locerr = Math.Max(locerr, Math.Abs(sm-1));
                    }
                }
            }
            orterr = Math.Max(orterr, locerr);
            
            //
            // values order error
            //
            for(i=1; i<=minmn-1; i++)
            {
                if( (double)(w[i])>(double)(w[i-1]) )
                {
                    wsorted = false;
                }
            }
        }


        private static void testsvdproblem(double[,] a,
            int m,
            int n,
            ref double materr,
            ref double orterr,
            ref double othererr,
            ref bool wsorted,
            ref bool wfailed,
            ref int failcount,
            ref int succcount)
        {
            double[,] u = new double[0,0];
            double[,] vt = new double[0,0];
            double[,] u2 = new double[0,0];
            double[,] vt2 = new double[0,0];
            double[] w = new double[0];
            double[] w2 = new double[0];
            int i = 0;
            int j = 0;
            int ujob = 0;
            int vtjob = 0;
            int memjob = 0;
            int ucheck = 0;
            int vtcheck = 0;

            
            //
            // Main SVD test
            //
            if( !svd.rmatrixsvd(a, m, n, 2, 2, 2, ref w, ref u, ref vt) )
            {
                failcount = failcount+1;
                wfailed = true;
                return;
            }
            getsvderror(a, m, n, u, w, vt, ref materr, ref orterr, ref wsorted);
            
            //
            // Additional SVD tests
            //
            for(ujob=0; ujob<=2; ujob++)
            {
                for(vtjob=0; vtjob<=2; vtjob++)
                {
                    for(memjob=0; memjob<=2; memjob++)
                    {
                        if( !svd.rmatrixsvd(a, m, n, ujob, vtjob, memjob, ref w2, ref u2, ref vt2) )
                        {
                            failcount = failcount+1;
                            wfailed = true;
                            return;
                        }
                        ucheck = 0;
                        if( ujob==1 )
                        {
                            ucheck = Math.Min(m, n);
                        }
                        if( ujob==2 )
                        {
                            ucheck = m;
                        }
                        vtcheck = 0;
                        if( vtjob==1 )
                        {
                            vtcheck = Math.Min(m, n);
                        }
                        if( vtjob==2 )
                        {
                            vtcheck = n;
                        }
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=ucheck-1; j++)
                            {
                                othererr = Math.Max(othererr, Math.Abs(u[i,j]-u2[i,j]));
                            }
                        }
                        for(i=0; i<=vtcheck-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                othererr = Math.Max(othererr, Math.Abs(vt[i,j]-vt2[i,j]));
                            }
                        }
                        for(i=0; i<=Math.Min(m, n)-1; i++)
                        {
                            othererr = Math.Max(othererr, Math.Abs(w[i]-w2[i]));
                        }
                    }
                }
            }
            
            //
            // update counter
            //
            succcount = succcount+1;
        }


    }
    public class testlinregunit
    {
        public static bool testlinreg(bool silent)
        {
            bool result = new bool();
            double sigmathreshold = 0;
            int maxn = 0;
            int maxm = 0;
            int passcount = 0;
            int estpasscount = 0;
            double threshold = 0;
            int n = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int tmpi = 0;
            int pass = 0;
            int epass = 0;
            int m = 0;
            int tasktype = 0;
            int modeltype = 0;
            int m1 = 0;
            int m2 = 0;
            int n1 = 0;
            int n2 = 0;
            int info = 0;
            int info2 = 0;
            double[,] xy = new double[0,0];
            double[,] xy2 = new double[0,0];
            double[] s = new double[0];
            double[] s2 = new double[0];
            double[] w2 = new double[0];
            double[] x = new double[0];
            double[] ta = new double[0];
            double[] tb = new double[0];
            double[] tc = new double[0];
            double[] xy0 = new double[0];
            double[] tmpweights = new double[0];
            linreg.linearmodel w = new linreg.linearmodel();
            linreg.linearmodel wt = new linreg.linearmodel();
            linreg.linearmodel wt2 = new linreg.linearmodel();
            double[] x1 = new double[0];
            double[] x2 = new double[0];
            double y1 = 0;
            double y2 = 0;
            bool allsame = new bool();
            double ea = 0;
            double eb = 0;
            double varatested = 0;
            double varbtested = 0;
            double a = 0;
            double b = 0;
            double vara = 0;
            double varb = 0;
            double a2 = 0;
            double b2 = 0;
            double covab = 0;
            double corrab = 0;
            double p = 0;
            int qcnt = 0;
            double[] qtbl = new double[0];
            double[] qvals = new double[0];
            double[] qsigma = new double[0];
            linreg.lrreport ar = new linreg.lrreport();
            linreg.lrreport ar2 = new linreg.lrreport();
            double f = 0;
            double fp = 0;
            double fm = 0;
            double v = 0;
            double vv = 0;
            double cvrmserror = 0;
            double cvavgerror = 0;
            double cvavgrelerror = 0;
            double rmserror = 0;
            double avgerror = 0;
            double avgrelerror = 0;
            bool nondefect = new bool();
            double sinshift = 0;
            double tasklevel = 0;
            double noiselevel = 0;
            double hstep = 0;
            double sigma = 0;
            double mean = 0;
            double means = 0;
            double stddev = 0;
            double stddevs = 0;
            bool slcerrors = new bool();
            bool slerrors = new bool();
            bool grcoverrors = new bool();
            bool gropterrors = new bool();
            bool gresterrors = new bool();
            bool grothererrors = new bool();
            bool grconverrors = new bool();
            bool waserrors = new bool();
            int i_ = 0;

            
            //
            // Primary settings
            //
            maxn = 40;
            maxm = 5;
            passcount = 3;
            estpasscount = 1000;
            sigmathreshold = 7;
            threshold = 1000000*math.machineepsilon;
            slerrors = false;
            slcerrors = false;
            grcoverrors = false;
            gropterrors = false;
            gresterrors = false;
            grothererrors = false;
            grconverrors = false;
            waserrors = false;
            
            //
            // Quantiles table setup
            //
            qcnt = 5;
            qtbl = new double[qcnt-1+1];
            qvals = new double[qcnt-1+1];
            qsigma = new double[qcnt-1+1];
            qtbl[0] = 0.5;
            qtbl[1] = 0.25;
            qtbl[2] = 0.10;
            qtbl[3] = 0.05;
            qtbl[4] = 0.025;
            for(i=0; i<=qcnt-1; i++)
            {
                qsigma[i] = Math.Sqrt(qtbl[i]*(1-qtbl[i])/estpasscount);
            }
            
            //
            // Other setup
            //
            ta = new double[estpasscount-1+1];
            tb = new double[estpasscount-1+1];
            
            //
            // Test straight line regression
            //
            for(n=2; n<=maxn; n++)
            {
                
                //
                // Fail/pass test
                //
                generaterandomtask(-1, 1, false, -1, 1, 1, 2, n, ref xy, ref s);
                linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                slcerrors = slcerrors || info!=1;
                generaterandomtask(1, 1, false, -1, 1, 1, 2, n, ref xy, ref s);
                linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                slcerrors = slcerrors || info!=-3;
                generaterandomtask(-1, 1, false, -1, 1, -1, -1, n, ref xy, ref s);
                linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                slcerrors = slcerrors || info!=-2;
                generaterandomtask(-1, 1, false, -1, 1, 2, 1, 2, ref xy, ref s);
                linreg.lrlines(xy, s, 1, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                slcerrors = slcerrors || info!=-1;
                
                //
                // Multipass tests
                //
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // Test S variant against non-S variant
                    //
                    ea = 2*math.randomreal()-1;
                    eb = 2*math.randomreal()-1;
                    generatetask(ea, eb, -(5*math.randomreal()), 5*math.randomreal(), (double)(math.randomreal())>(double)(0.5), 1, 1, n, ref xy, ref s);
                    linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                    linreg.lrline(xy, n, ref info2, ref a2, ref b2);
                    if( info!=1 || info2!=1 )
                    {
                        slcerrors = true;
                    }
                    else
                    {
                        slerrors = (slerrors || (double)(Math.Abs(a-a2))>(double)(threshold)) || (double)(Math.Abs(b-b2))>(double)(threshold);
                    }
                    
                    //
                    // Test for A/B
                    //
                    // Generate task with exact, non-perturbed y[i],
                    // then make non-zero s[i]
                    //
                    ea = 2*math.randomreal()-1;
                    eb = 2*math.randomreal()-1;
                    generatetask(ea, eb, -(5*math.randomreal()), 5*math.randomreal(), n>4, 0.0, 0.0, n, ref xy, ref s);
                    for(i=0; i<=n-1; i++)
                    {
                        s[i] = 1+math.randomreal();
                    }
                    linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                    if( info!=1 )
                    {
                        slcerrors = true;
                    }
                    else
                    {
                        slerrors = (slerrors || (double)(Math.Abs(a-ea))>(double)(0.001)) || (double)(Math.Abs(b-eb))>(double)(0.001);
                    }
                    
                    //
                    // Test for VarA, VarB, P (P is being tested only for N>2)
                    //
                    for(i=0; i<=qcnt-1; i++)
                    {
                        qvals[i] = 0;
                    }
                    ea = 2*math.randomreal()-1;
                    eb = 2*math.randomreal()-1;
                    generatetask(ea, eb, -(5*math.randomreal()), 5*math.randomreal(), n>4, 1.0, 2.0, n, ref xy, ref s);
                    linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                    if( info!=1 )
                    {
                        slcerrors = true;
                        continue;
                    }
                    varatested = vara;
                    varbtested = varb;
                    for(epass=0; epass<=estpasscount-1; epass++)
                    {
                        
                        //
                        // Generate
                        //
                        filltaskwithy(ea, eb, n, ref xy, ref s);
                        linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                        if( info!=1 )
                        {
                            slcerrors = true;
                            continue;
                        }
                        
                        //
                        // A, B, P
                        // (P is being tested for uniformity, additional p-tests are below)
                        //
                        ta[epass] = a;
                        tb[epass] = b;
                        for(i=0; i<=qcnt-1; i++)
                        {
                            if( (double)(p)<=(double)(qtbl[i]) )
                            {
                                qvals[i] = qvals[i]+(double)1/(double)estpasscount;
                            }
                        }
                    }
                    calculatemv(ta, estpasscount, ref mean, ref means, ref stddev, ref stddevs);
                    slerrors = slerrors || (double)(Math.Abs(mean-ea)/means)>=(double)(sigmathreshold);
                    slerrors = slerrors || (double)(Math.Abs(stddev-Math.Sqrt(varatested))/stddevs)>=(double)(sigmathreshold);
                    calculatemv(tb, estpasscount, ref mean, ref means, ref stddev, ref stddevs);
                    slerrors = slerrors || (double)(Math.Abs(mean-eb)/means)>=(double)(sigmathreshold);
                    slerrors = slerrors || (double)(Math.Abs(stddev-Math.Sqrt(varbtested))/stddevs)>=(double)(sigmathreshold);
                    if( n>2 )
                    {
                        for(i=0; i<=qcnt-1; i++)
                        {
                            if( (double)(Math.Abs(qtbl[i]-qvals[i])/qsigma[i])>(double)(sigmathreshold) )
                            {
                                slerrors = true;
                            }
                        }
                    }
                    
                    //
                    // Additional tests for P: correlation with fit quality
                    //
                    if( n>2 )
                    {
                        generatetask(ea, eb, -(5*math.randomreal()), 5*math.randomreal(), false, 0.0, 0.0, n, ref xy, ref s);
                        for(i=0; i<=n-1; i++)
                        {
                            s[i] = 1+math.randomreal();
                        }
                        linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                        if( info!=1 )
                        {
                            slcerrors = true;
                            continue;
                        }
                        slerrors = slerrors || (double)(p)<(double)(0.999);
                        generatetask(0, 0, -(5*math.randomreal()), 5*math.randomreal(), false, 1.0, 1.0, n, ref xy, ref s);
                        for(i=0; i<=n-1; i++)
                        {
                            if( i%2==0 )
                            {
                                xy[i,1] = 5.0;
                            }
                            else
                            {
                                xy[i,1] = -5.0;
                            }
                        }
                        if( n%2!=0 )
                        {
                            xy[n-1,1] = 0;
                        }
                        linreg.lrlines(xy, s, n, ref info, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                        if( info!=1 )
                        {
                            slcerrors = true;
                            continue;
                        }
                        slerrors = slerrors || (double)(p)>(double)(0.001);
                    }
                }
            }
            
            //
            // General regression tests:
            //
            
            //
            // Simple linear tests (small sample, optimum point, covariance)
            //
            for(n=3; n<=maxn; n++)
            {
                s = new double[n-1+1];
                
                //
                // Linear tests:
                // a. random points, sigmas
                // b. no sigmas
                //
                xy = new double[n-1+1, 1+1];
                for(i=0; i<=n-1; i++)
                {
                    xy[i,0] = 2*math.randomreal()-1;
                    xy[i,1] = 2*math.randomreal()-1;
                    s[i] = 1+math.randomreal();
                }
                linreg.lrbuilds(xy, s, n, 1, ref info, wt, ar);
                if( info!=1 )
                {
                    grconverrors = true;
                    continue;
                }
                linreg.lrunpack(wt, ref tmpweights, ref tmpi);
                linreg.lrlines(xy, s, n, ref info2, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
                gropterrors = gropterrors || (double)(Math.Abs(a-tmpweights[1]))>(double)(threshold);
                gropterrors = gropterrors || (double)(Math.Abs(b-tmpweights[0]))>(double)(threshold);
                grcoverrors = grcoverrors || (double)(Math.Abs(vara-ar.c[1,1]))>(double)(threshold);
                grcoverrors = grcoverrors || (double)(Math.Abs(varb-ar.c[0,0]))>(double)(threshold);
                grcoverrors = grcoverrors || (double)(Math.Abs(covab-ar.c[1,0]))>(double)(threshold);
                grcoverrors = grcoverrors || (double)(Math.Abs(covab-ar.c[0,1]))>(double)(threshold);
                linreg.lrbuild(xy, n, 1, ref info, wt, ar);
                if( info!=1 )
                {
                    grconverrors = true;
                    continue;
                }
                linreg.lrunpack(wt, ref tmpweights, ref tmpi);
                linreg.lrline(xy, n, ref info2, ref a, ref b);
                gropterrors = gropterrors || (double)(Math.Abs(a-tmpweights[1]))>(double)(threshold);
                gropterrors = gropterrors || (double)(Math.Abs(b-tmpweights[0]))>(double)(threshold);
            }
            
            //
            // S covariance versus S-less covariance.
            // Slightly skewed task, large sample size.
            // Will S-less subroutine estimate covariance matrix good enough?
            //
            n = 1000+math.randominteger(3000);
            sigma = 0.1+math.randomreal()*1.9;
            xy = new double[n-1+1, 1+1];
            s = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                xy[i,0] = 1.5*math.randomreal()-0.5;
                xy[i,1] = 1.2*xy[i,0]-0.3+generatenormal(0, sigma);
                s[i] = sigma;
            }
            linreg.lrbuild(xy, n, 1, ref info, wt, ar);
            linreg.lrlines(xy, s, n, ref info2, ref a, ref b, ref vara, ref varb, ref covab, ref corrab, ref p);
            if( info!=1 || info2!=1 )
            {
                grconverrors = true;
            }
            else
            {
                grcoverrors = grcoverrors || (double)(Math.Abs(Math.Log(ar.c[0,0]/varb)))>(double)(Math.Log(1.2));
                grcoverrors = grcoverrors || (double)(Math.Abs(Math.Log(ar.c[1,1]/vara)))>(double)(Math.Log(1.2));
                grcoverrors = grcoverrors || (double)(Math.Abs(Math.Log(ar.c[0,1]/covab)))>(double)(Math.Log(1.2));
                grcoverrors = grcoverrors || (double)(Math.Abs(Math.Log(ar.c[1,0]/covab)))>(double)(Math.Log(1.2));
            }
            
            //
            // General tests:
            // * basis functions - up to cubic
            // * task types:
            // * data set is noisy sine half-period with random shift
            // * tests:
            //   unpacking/packing
            //   optimality
            //   error estimates
            // * tasks:
            //   0 = noised sine
            //   1 = degenerate task with 1-of-n encoded categorical variables
            //   2 = random task with large variation (for 1-type models)
            //   3 = random task with small variation (for 1-type models)
            //
            //   Additional tasks TODO
            //   specially designed task with defective vectors which leads to
            //   the failure of the fast CV formula.
            //
            //
            m1 = 0;
            m2 = -1;
            n1 = 0;
            n2 = -1;
            for(modeltype=0; modeltype<=1; modeltype++)
            {
                for(tasktype=0; tasktype<=3; tasktype++)
                {
                    if( tasktype==0 )
                    {
                        m1 = 1;
                        m2 = 3;
                    }
                    if( tasktype==1 )
                    {
                        m1 = 9;
                        m2 = 9;
                    }
                    if( tasktype==2 || tasktype==3 )
                    {
                        m1 = 9;
                        m2 = 9;
                    }
                    for(m=m1; m<=m2; m++)
                    {
                        if( tasktype==0 )
                        {
                            n1 = m+3;
                            n2 = m+20;
                        }
                        if( tasktype==1 )
                        {
                            n1 = 70+math.randominteger(70);
                            n2 = n1;
                        }
                        if( tasktype==2 || tasktype==3 )
                        {
                            n1 = 100;
                            n2 = n1;
                        }
                        for(n=n1; n<=n2; n++)
                        {
                            xy = new double[n-1+1, m+1];
                            xy0 = new double[n-1+1];
                            s = new double[n-1+1];
                            hstep = 0.001;
                            noiselevel = 0.2;
                            
                            //
                            // Prepare task
                            //
                            if( tasktype==0 )
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    xy[i,0] = 2*math.randomreal()-1;
                                }
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=1; j<=m-1; j++)
                                    {
                                        xy[i,j] = xy[i,0]*xy[i,j-1];
                                    }
                                }
                                sinshift = math.randomreal()*Math.PI;
                                for(i=0; i<=n-1; i++)
                                {
                                    xy0[i] = Math.Sin(sinshift+Math.PI*0.5*(xy[i,0]+1));
                                    xy[i,m] = xy0[i]+noiselevel*generatenormal(0, 1);
                                }
                            }
                            if( tasktype==1 )
                            {
                                alglib.ap.assert(m==9);
                                ta = new double[8+1];
                                ta[0] = 1;
                                ta[1] = 2;
                                ta[2] = 3;
                                ta[3] = 0.25;
                                ta[4] = 0.5;
                                ta[5] = 0.75;
                                ta[6] = 0.06;
                                ta[7] = 0.12;
                                ta[8] = 0.18;
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=0; j<=m-1; j++)
                                    {
                                        xy[i,j] = 0;
                                    }
                                    xy[i,0+i%3] = 1;
                                    xy[i,3+i/3%3] = 1;
                                    xy[i,6+i/9%3] = 1;
                                    v = 0.0;
                                    for(i_=0; i_<=8;i_++)
                                    {
                                        v += xy[i,i_]*ta[i_];
                                    }
                                    xy0[i] = v;
                                    xy[i,m] = v+noiselevel*generatenormal(0, 1);
                                }
                            }
                            if( tasktype==2 || tasktype==3 )
                            {
                                alglib.ap.assert(m==9);
                                ta = new double[8+1];
                                ta[0] = 1;
                                ta[1] = -2;
                                ta[2] = 3;
                                ta[3] = 0.25;
                                ta[4] = -0.5;
                                ta[5] = 0.75;
                                ta[6] = -0.06;
                                ta[7] = 0.12;
                                ta[8] = -0.18;
                                for(i=0; i<=n-1; i++)
                                {
                                    for(j=0; j<=m-1; j++)
                                    {
                                        if( tasktype==2 )
                                        {
                                            xy[i,j] = 1+generatenormal(0, 3);
                                        }
                                        else
                                        {
                                            xy[i,j] = 1+generatenormal(0, 0.05);
                                        }
                                    }
                                    v = 0.0;
                                    for(i_=0; i_<=8;i_++)
                                    {
                                        v += xy[i,i_]*ta[i_];
                                    }
                                    xy0[i] = v;
                                    xy[i,m] = v+noiselevel*generatenormal(0, 1);
                                }
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                s[i] = 1+math.randomreal();
                            }
                            
                            //
                            // Solve (using S-variant, non-S-variant is not tested)
                            //
                            if( modeltype==0 )
                            {
                                linreg.lrbuilds(xy, s, n, m, ref info, wt, ar);
                            }
                            else
                            {
                                linreg.lrbuildzs(xy, s, n, m, ref info, wt, ar);
                            }
                            if( info!=1 )
                            {
                                grconverrors = true;
                                continue;
                            }
                            linreg.lrunpack(wt, ref tmpweights, ref tmpi);
                            
                            //
                            // LRProcess test
                            //
                            x = new double[m-1+1];
                            v = tmpweights[m];
                            for(i=0; i<=m-1; i++)
                            {
                                x[i] = 2*math.randomreal()-1;
                                v = v+tmpweights[i]*x[i];
                            }
                            grothererrors = grothererrors || (double)(Math.Abs(v-linreg.lrprocess(wt, x))/Math.Max(Math.Abs(v), 1))>(double)(threshold);
                            
                            //
                            // LRPack test
                            //
                            linreg.lrpack(tmpweights, m, wt2);
                            x = new double[m-1+1];
                            for(i=0; i<=m-1; i++)
                            {
                                x[i] = 2*math.randomreal()-1;
                            }
                            v = linreg.lrprocess(wt, x);
                            grothererrors = grothererrors || (double)(Math.Abs(v-linreg.lrprocess(wt2, x))/Math.Abs(v))>(double)(threshold);
                            
                            //
                            // Optimality test
                            //
                            for(k=0; k<=m; k++)
                            {
                                if( modeltype==1 && k==m )
                                {
                                    
                                    //
                                    // 0-type models (with non-zero constant term)
                                    // are tested for optimality of all coefficients.
                                    //
                                    // 1-type models (with zero constant term)
                                    // are tested for optimality of non-constant terms only.
                                    //
                                    continue;
                                }
                                f = 0;
                                fp = 0;
                                fm = 0;
                                for(i=0; i<=n-1; i++)
                                {
                                    v = tmpweights[m];
                                    for(j=0; j<=m-1; j++)
                                    {
                                        v = v+xy[i,j]*tmpweights[j];
                                    }
                                    f = f+math.sqr((v-xy[i,m])/s[i]);
                                    if( k<m )
                                    {
                                        vv = xy[i,k];
                                    }
                                    else
                                    {
                                        vv = 1;
                                    }
                                    fp = fp+math.sqr((v+vv*hstep-xy[i,m])/s[i]);
                                    fm = fm+math.sqr((v-vv*hstep-xy[i,m])/s[i]);
                                }
                                gropterrors = (gropterrors || (double)(f)>(double)(fp)) || (double)(f)>(double)(fm);
                            }
                            
                            //
                            // Covariance matrix test:
                            // generate random vector, project coefficients on it,
                            // compare variance of projection with estimate provided
                            // by cov.matrix
                            //
                            ta = new double[estpasscount-1+1];
                            tb = new double[m+1];
                            tc = new double[m+1];
                            xy2 = new double[n-1+1, m+1];
                            for(i=0; i<=m; i++)
                            {
                                tb[i] = generatenormal(0, 1);
                            }
                            for(epass=0; epass<=estpasscount-1; epass++)
                            {
                                for(i=0; i<=n-1; i++)
                                {
                                    for(i_=0; i_<=m-1;i_++)
                                    {
                                        xy2[i,i_] = xy[i,i_];
                                    }
                                    xy2[i,m] = xy0[i]+s[i]*generatenormal(0, 1);
                                }
                                if( modeltype==0 )
                                {
                                    linreg.lrbuilds(xy2, s, n, m, ref info, wt, ar2);
                                }
                                else
                                {
                                    linreg.lrbuildzs(xy2, s, n, m, ref info, wt, ar2);
                                }
                                if( info!=1 )
                                {
                                    ta[epass] = 0;
                                    grconverrors = true;
                                    continue;
                                }
                                linreg.lrunpack(wt, ref w2, ref tmpi);
                                v = 0.0;
                                for(i_=0; i_<=m;i_++)
                                {
                                    v += tb[i_]*w2[i_];
                                }
                                ta[epass] = v;
                            }
                            calculatemv(ta, estpasscount, ref mean, ref means, ref stddev, ref stddevs);
                            for(i=0; i<=m; i++)
                            {
                                v = 0.0;
                                for(i_=0; i_<=m;i_++)
                                {
                                    v += tb[i_]*ar.c[i_,i];
                                }
                                tc[i] = v;
                            }
                            v = 0.0;
                            for(i_=0; i_<=m;i_++)
                            {
                                v += tc[i_]*tb[i_];
                            }
                            grcoverrors = grcoverrors || (double)(Math.Abs((Math.Sqrt(v)-stddev)/stddevs))>=(double)(sigmathreshold);
                            
                            //
                            // Test for the fast CV error:
                            // calculate CV error by definition (leaving out N
                            // points and recalculating solution).
                            //
                            // Test for the training set error
                            //
                            cvrmserror = 0;
                            cvavgerror = 0;
                            cvavgrelerror = 0;
                            rmserror = 0;
                            avgerror = 0;
                            avgrelerror = 0;
                            xy2 = new double[n-2+1, m+1];
                            s2 = new double[n-2+1];
                            for(i=0; i<=n-2; i++)
                            {
                                for(i_=0; i_<=m;i_++)
                                {
                                    xy2[i,i_] = xy[i+1,i_];
                                }
                                s2[i] = s[i+1];
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                
                                //
                                // Trn
                                //
                                v = 0.0;
                                for(i_=0; i_<=m-1;i_++)
                                {
                                    v += xy[i,i_]*tmpweights[i_];
                                }
                                v = v+tmpweights[m];
                                rmserror = rmserror+math.sqr(v-xy[i,m]);
                                avgerror = avgerror+Math.Abs(v-xy[i,m]);
                                avgrelerror = avgrelerror+Math.Abs((v-xy[i,m])/xy[i,m]);
                                
                                //
                                // CV: non-defect vectors only
                                //
                                nondefect = true;
                                for(k=0; k<=ar.ncvdefects-1; k++)
                                {
                                    if( ar.cvdefects[k]==i )
                                    {
                                        nondefect = false;
                                    }
                                }
                                if( nondefect )
                                {
                                    if( modeltype==0 )
                                    {
                                        linreg.lrbuilds(xy2, s2, n-1, m, ref info2, wt, ar2);
                                    }
                                    else
                                    {
                                        linreg.lrbuildzs(xy2, s2, n-1, m, ref info2, wt, ar2);
                                    }
                                    if( info2!=1 )
                                    {
                                        grconverrors = true;
                                        continue;
                                    }
                                    linreg.lrunpack(wt, ref w2, ref tmpi);
                                    v = 0.0;
                                    for(i_=0; i_<=m-1;i_++)
                                    {
                                        v += xy[i,i_]*w2[i_];
                                    }
                                    v = v+w2[m];
                                    cvrmserror = cvrmserror+math.sqr(v-xy[i,m]);
                                    cvavgerror = cvavgerror+Math.Abs(v-xy[i,m]);
                                    cvavgrelerror = cvavgrelerror+Math.Abs((v-xy[i,m])/xy[i,m]);
                                }
                                
                                //
                                // Next set
                                //
                                if( i!=n-1 )
                                {
                                    for(i_=0; i_<=m;i_++)
                                    {
                                        xy2[i,i_] = xy[i,i_];
                                    }
                                    s2[i] = s[i];
                                }
                            }
                            cvrmserror = Math.Sqrt(cvrmserror/(n-ar.ncvdefects));
                            cvavgerror = cvavgerror/(n-ar.ncvdefects);
                            cvavgrelerror = cvavgrelerror/(n-ar.ncvdefects);
                            rmserror = Math.Sqrt(rmserror/n);
                            avgerror = avgerror/n;
                            avgrelerror = avgrelerror/n;
                            gresterrors = gresterrors || (double)(Math.Abs(Math.Log(ar.cvrmserror/cvrmserror)))>(double)(Math.Log(1+1.0E-5));
                            gresterrors = gresterrors || (double)(Math.Abs(Math.Log(ar.cvavgerror/cvavgerror)))>(double)(Math.Log(1+1.0E-5));
                            gresterrors = gresterrors || (double)(Math.Abs(Math.Log(ar.cvavgrelerror/cvavgrelerror)))>(double)(Math.Log(1+1.0E-5));
                            gresterrors = gresterrors || (double)(Math.Abs(Math.Log(ar.rmserror/rmserror)))>(double)(Math.Log(1+1.0E-5));
                            gresterrors = gresterrors || (double)(Math.Abs(Math.Log(ar.avgerror/avgerror)))>(double)(Math.Log(1+1.0E-5));
                            gresterrors = gresterrors || (double)(Math.Abs(Math.Log(ar.avgrelerror/avgrelerror)))>(double)(Math.Log(1+1.0E-5));
                        }
                    }
                }
            }
            
            //
            // Additional subroutines
            //
            for(pass=1; pass<=50; pass++)
            {
                n = 2;
                do
                {
                    noiselevel = math.randomreal()+0.1;
                    tasklevel = 2*math.randomreal()-1;
                }
                while( (double)(Math.Abs(noiselevel-tasklevel))<=(double)(0.05) );
                xy = new double[3*n-1+1, 1+1];
                for(i=0; i<=n-1; i++)
                {
                    xy[3*i+0,0] = i;
                    xy[3*i+1,0] = i;
                    xy[3*i+2,0] = i;
                    xy[3*i+0,1] = tasklevel-noiselevel;
                    xy[3*i+1,1] = tasklevel;
                    xy[3*i+2,1] = tasklevel+noiselevel;
                }
                linreg.lrbuild(xy, 3*n, 1, ref info, wt, ar);
                if( info==1 )
                {
                    linreg.lrunpack(wt, ref tmpweights, ref tmpi);
                    v = linreg.lrrmserror(wt, xy, 3*n);
                    grothererrors = grothererrors || (double)(Math.Abs(v-noiselevel*Math.Sqrt((double)2/(double)3)))>(double)(threshold);
                    v = linreg.lravgerror(wt, xy, 3*n);
                    grothererrors = grothererrors || (double)(Math.Abs(v-noiselevel*((double)2/(double)3)))>(double)(threshold);
                    v = linreg.lravgrelerror(wt, xy, 3*n);
                    vv = (Math.Abs(noiselevel/(tasklevel-noiselevel))+Math.Abs(noiselevel/(tasklevel+noiselevel)))/3;
                    grothererrors = grothererrors || (double)(Math.Abs(v-vv))>(double)(threshold*vv);
                }
                else
                {
                    grothererrors = true;
                }
                for(i=0; i<=n-1; i++)
                {
                    xy[3*i+0,0] = i;
                    xy[3*i+1,0] = i;
                    xy[3*i+2,0] = i;
                    xy[3*i+0,1] = -noiselevel;
                    xy[3*i+1,1] = 0;
                    xy[3*i+2,1] = noiselevel;
                }
                linreg.lrbuild(xy, 3*n, 1, ref info, wt, ar);
                if( info==1 )
                {
                    linreg.lrunpack(wt, ref tmpweights, ref tmpi);
                    v = linreg.lravgrelerror(wt, xy, 3*n);
                    grothererrors = grothererrors || (double)(Math.Abs(v-1))>(double)(threshold);
                }
                else
                {
                    grothererrors = true;
                }
            }
            for(pass=1; pass<=10; pass++)
            {
                m = 1+math.randominteger(5);
                n = 10+math.randominteger(10);
                xy = new double[n-1+1, m+1];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m; j++)
                    {
                        xy[i,j] = 2*math.randomreal()-1;
                    }
                }
                linreg.lrbuild(xy, n, m, ref info, w, ar);
                if( info<0 )
                {
                    grothererrors = true;
                    break;
                }
                x1 = new double[m-1+1];
                x2 = new double[m-1+1];
                
                //
                // Same inputs on original leads to same outputs
                // on copy created using LRCopy
                //
                unsetlr(wt);
                linreg.lrcopy(w, wt);
                for(i=0; i<=m-1; i++)
                {
                    x1[i] = 2*math.randomreal()-1;
                    x2[i] = x1[i];
                }
                y1 = linreg.lrprocess(w, x1);
                y2 = linreg.lrprocess(wt, x2);
                allsame = (double)(y1)==(double)(y2);
                grothererrors = grothererrors || !allsame;
            }
            
            //
            // TODO: Degenerate tests (when design matrix and right part are zero)
            //
            
            //
            // Final report
            //
            waserrors = (((((slerrors || slcerrors) || gropterrors) || grcoverrors) || gresterrors) || grothererrors) || grconverrors;
            if( !silent )
            {
                System.Console.Write("REGRESSION TEST");
                System.Console.WriteLine();
                System.Console.Write("STRAIGHT LINE REGRESSION:                ");
                if( !slerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("STRAIGHT LINE REGRESSION CONVERGENCE:    ");
                if( !slcerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("GENERAL LINEAR REGRESSION:               ");
                if( !((((gropterrors || grcoverrors) || gresterrors) || grothererrors) || grconverrors) )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* OPTIMALITY:                            ");
                if( !gropterrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* COV. MATRIX:                           ");
                if( !grcoverrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* ERROR ESTIMATES:                       ");
                if( !gresterrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* CONVERGENCE:                           ");
                if( !grconverrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* OTHER SUBROUTINES:                     ");
                if( !grothererrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST SUMMARY: FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST SUMMARY: PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testlinreg(bool silent)
        {
            return testlinreg(silent);
        }


        /*************************************************************************
        Task generation. Meaningless task, just random numbers.
        *************************************************************************/
        private static void generaterandomtask(double xl,
            double xr,
            bool randomx,
            double ymin,
            double ymax,
            double smin,
            double smax,
            int n,
            ref double[,] xy,
            ref double[] s)
        {
            int i = 0;

            xy = new double[n-1+1, 1+1];
            s = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                if( randomx )
                {
                    xy[i,0] = xl+(xr-xl)*math.randomreal();
                }
                else
                {
                    xy[i,0] = xl+(xr-xl)*i/(n-1);
                }
                xy[i,1] = ymin+(ymax-ymin)*math.randomreal();
                s[i] = smin+(smax-smin)*math.randomreal();
            }
        }


        /*************************************************************************
        Task generation.
        *************************************************************************/
        private static void generatetask(double a,
            double b,
            double xl,
            double xr,
            bool randomx,
            double smin,
            double smax,
            int n,
            ref double[,] xy,
            ref double[] s)
        {
            int i = 0;

            xy = new double[n-1+1, 1+1];
            s = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                if( randomx )
                {
                    xy[i,0] = xl+(xr-xl)*math.randomreal();
                }
                else
                {
                    xy[i,0] = xl+(xr-xl)*i/(n-1);
                }
                s[i] = smin+(smax-smin)*math.randomreal();
                xy[i,1] = a+b*xy[i,0]+generatenormal(0, s[i]);
            }
        }


        /*************************************************************************
        Task generation.
        y[i] are filled based on A, B, X[I], S[I]
        *************************************************************************/
        private static void filltaskwithy(double a,
            double b,
            int n,
            ref double[,] xy,
            ref double[] s)
        {
            int i = 0;

            for(i=0; i<=n-1; i++)
            {
                xy[i,1] = a+b*xy[i,0]+generatenormal(0, s[i]);
            }
        }


        /*************************************************************************
        Normal random numbers
        *************************************************************************/
        private static double generatenormal(double mean,
            double sigma)
        {
            double result = 0;
            double u = 0;
            double v = 0;
            double sum = 0;

            result = mean;
            while( true )
            {
                u = (2*math.randominteger(2)-1)*math.randomreal();
                v = (2*math.randominteger(2)-1)*math.randomreal();
                sum = u*u+v*v;
                if( (double)(sum)<(double)(1) && (double)(sum)>(double)(0) )
                {
                    sum = Math.Sqrt(-(2*Math.Log(sum)/sum));
                    result = sigma*u*sum+mean;
                    return result;
                }
            }
            return result;
        }


        /*************************************************************************
        Moments estimates and their errors
        *************************************************************************/
        private static void calculatemv(double[] x,
            int n,
            ref double mean,
            ref double means,
            ref double stddev,
            ref double stddevs)
        {
            int i = 0;
            double v1 = 0;
            double v2 = 0;
            double variance = 0;

            mean = 0;
            means = 0;
            stddev = 0;
            stddevs = 0;

            mean = 0;
            means = 1;
            stddev = 0;
            stddevs = 1;
            variance = 0;
            if( n<=1 )
            {
                return;
            }
            
            //
            // Mean
            //
            for(i=0; i<=n-1; i++)
            {
                mean = mean+x[i];
            }
            mean = mean/n;
            
            //
            // Variance (using corrected two-pass algorithm)
            //
            if( n!=1 )
            {
                v1 = 0;
                for(i=0; i<=n-1; i++)
                {
                    v1 = v1+math.sqr(x[i]-mean);
                }
                v2 = 0;
                for(i=0; i<=n-1; i++)
                {
                    v2 = v2+(x[i]-mean);
                }
                v2 = math.sqr(v2)/n;
                variance = (v1-v2)/(n-1);
                if( (double)(variance)<(double)(0) )
                {
                    variance = 0;
                }
                stddev = Math.Sqrt(variance);
            }
            
            //
            // Errors
            //
            means = stddev/Math.Sqrt(n);
            stddevs = stddev*Math.Sqrt(2)/Math.Sqrt(n-1);
        }


        /*************************************************************************
        Unsets LR
        *************************************************************************/
        private static void unsetlr(linreg.linearmodel lr)
        {
            double[,] xy = new double[0,0];
            int info = 0;
            linreg.lrreport rep = new linreg.lrreport();
            int i = 0;

            xy = new double[5+1, 1+1];
            for(i=0; i<=5; i++)
            {
                xy[i,0] = 0;
                xy[i,1] = 0;
            }
            linreg.lrbuild(xy, 6, 1, ref info, lr, rep);
            alglib.ap.assert(info>0);
        }


    }
    public class testfiltersunit
    {
        public static bool testfilters(bool silent)
        {
            bool result = new bool();
            bool waserrors = new bool();
            bool smaerrors = new bool();
            bool emaerrors = new bool();
            bool lrmaerrors = new bool();

            smaerrors = testsma(true);
            emaerrors = testema(true);
            lrmaerrors = testlrma(true);
            
            //
            // Final report
            //
            waserrors = (smaerrors || emaerrors) || lrmaerrors;
            if( !silent )
            {
                System.Console.Write("FILTERS TEST");
                System.Console.WriteLine();
                System.Console.Write("* SMA:                                   ");
                if( !smaerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* EMA:                                   ");
                if( !emaerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* LRMA:                                  ");
                if( !lrmaerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST SUMMARY: FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST SUMMARY: PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testfilters(bool silent)
        {
            return testfilters(silent);
        }


        /*************************************************************************
        This function tests SMA(k) filter. It returns True on error.

        Additional IsSilent parameter controls detailed error reporting.
        *************************************************************************/
        public static bool testsma(bool issilent)
        {
            bool result = new bool();
            double[] x = new double[0];
            bool precomputederrors = new bool();
            bool zerohandlingerrors = new bool();
            double threshold = 0;

            threshold = 1000*math.machineepsilon;
            if( !issilent )
            {
                System.Console.Write("SMA(K) TEST");
                System.Console.WriteLine();
            }
            
            //
            // Test several pre-computed problems.
            //
            // NOTE: tests below rely on the fact that floating point
            //       additions and subtractions are exact when dealing
            //       with integer values.
            //
            precomputederrors = false;
            x = new double[1];
            x[0] = 7;
            filters.filtersma(ref x, 1, 1);
            precomputederrors = precomputederrors || (double)(x[0])!=(double)(7);
            x = new double[3];
            x[0] = 7;
            x[1] = 8;
            x[2] = 9;
            filters.filtersma(ref x, 3, 1);
            precomputederrors = ((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(8)) || (double)(x[2])!=(double)(9);
            filters.filtersma(ref x, 3, 2);
            precomputederrors = ((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(7.5)) || (double)(x[2])!=(double)(8.5);
            x = new double[3];
            x[0] = 7;
            x[1] = 8;
            x[2] = 9;
            filters.filtersma(ref x, 3, 4);
            precomputederrors = ((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(7.5)) || (double)(x[2])!=(double)(8);
            
            //
            // Test zero-handling:
            // a) when we have non-zero sequence (N1 elements) followed by zero sequence
            //    (N2 elements), then first N1+K-1 elements of the processed sequence are
            //    non-zero, but elements since (N1+K)th must be exactly zero.
            // b) similar property holds for zero sequence followed by non-zero one
            //
            // Naive implementation of SMA does not have such property.
            //
            // NOTE: it is important to initialize X with non-integer elements with long
            // binary mantissas, because this test tries to test behaviour in the presence
            // of roundoff errors, and it will be useless when used with integer inputs.
            //
            zerohandlingerrors = false;
            x = new double[10];
            x[0] = Math.Sqrt(2);
            x[1] = Math.Sqrt(3);
            x[2] = Math.Sqrt(5);
            x[3] = Math.Sqrt(6);
            x[4] = Math.Sqrt(7);
            x[5] = 0;
            x[6] = 0;
            x[7] = 0;
            x[8] = 0;
            x[9] = 0;
            filters.filtersma(ref x, 10, 3);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[0]-Math.Sqrt(2)))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[1]-(Math.Sqrt(2)+Math.Sqrt(3))/2))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[2]-(Math.Sqrt(2)+Math.Sqrt(3)+Math.Sqrt(5))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[3]-(Math.Sqrt(3)+Math.Sqrt(5)+Math.Sqrt(6))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[4]-(Math.Sqrt(5)+Math.Sqrt(6)+Math.Sqrt(7))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[5]-(Math.Sqrt(6)+Math.Sqrt(7))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[6]-Math.Sqrt(7)/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(x[7])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(x[8])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(x[9])!=(double)(0);
            x[0] = 0;
            x[1] = 0;
            x[2] = 0;
            x[3] = 0;
            x[4] = 0;
            x[5] = Math.Sqrt(2);
            x[6] = Math.Sqrt(3);
            x[7] = Math.Sqrt(5);
            x[8] = Math.Sqrt(6);
            x[9] = Math.Sqrt(7);
            filters.filtersma(ref x, 10, 3);
            zerohandlingerrors = zerohandlingerrors || (double)(x[0])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(x[1])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(x[2])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(x[3])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(x[4])!=(double)(0);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[5]-Math.Sqrt(2)/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[6]-(Math.Sqrt(2)+Math.Sqrt(3))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[7]-(Math.Sqrt(2)+Math.Sqrt(3)+Math.Sqrt(5))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[8]-(Math.Sqrt(3)+Math.Sqrt(5)+Math.Sqrt(6))/3))>(double)(threshold);
            zerohandlingerrors = zerohandlingerrors || (double)(Math.Abs(x[9]-(Math.Sqrt(5)+Math.Sqrt(6)+Math.Sqrt(7))/3))>(double)(threshold);
            
            //
            // Final result
            //
            result = precomputederrors || zerohandlingerrors;
            return result;
        }


        /*************************************************************************
        This function tests EMA(alpha) filter. It returns True on error.

        Additional IsSilent parameter controls detailed error reporting.
        *************************************************************************/
        public static bool testema(bool issilent)
        {
            bool result = new bool();
            double[] x = new double[0];
            bool precomputederrors = new bool();
            double threshold = 0;

            threshold = 1000*math.machineepsilon;
            if( !issilent )
            {
                System.Console.Write("EMA(alpha) TEST");
                System.Console.WriteLine();
            }
            
            //
            // Test several pre-computed problems.
            //
            // NOTE: tests below rely on the fact that floating point
            //       additions and subtractions are exact when dealing
            //       with integer values.
            //
            precomputederrors = false;
            x = new double[1];
            x[0] = 7;
            filters.filterema(ref x, 1, 1.0);
            precomputederrors = precomputederrors || (double)(x[0])!=(double)(7);
            filters.filterema(ref x, 1, 0.5);
            precomputederrors = precomputederrors || (double)(x[0])!=(double)(7);
            x = new double[3];
            x[0] = 7;
            x[1] = 8;
            x[2] = 9;
            filters.filterema(ref x, 3, 1.0);
            precomputederrors = ((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(8)) || (double)(x[2])!=(double)(9);
            filters.filterema(ref x, 3, 0.5);
            precomputederrors = ((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(7.5)) || (double)(x[2])!=(double)(8.25);
            
            //
            // Final result
            //
            result = precomputederrors;
            return result;
        }


        /*************************************************************************
        This function tests LRMA(k) filter. It returns True on error.

        Additional IsSilent parameter controls detailed error reporting.
        *************************************************************************/
        public static bool testlrma(bool issilent)
        {
            bool result = new bool();
            double[] x = new double[0];
            bool precomputederrors = new bool();
            double threshold = 0;

            threshold = 1000*math.machineepsilon;
            if( !issilent )
            {
                System.Console.Write("LRMA(K) TEST");
                System.Console.WriteLine();
            }
            precomputederrors = false;
            
            //
            // First, check that filter does not changes points for K=1 or K=2
            //
            x = new double[1];
            x[0] = 7;
            filters.filterlrma(ref x, 1, 1);
            precomputederrors = precomputederrors || (double)(x[0])!=(double)(7);
            x = new double[6];
            x[0] = 7;
            x[1] = 8;
            x[2] = 9;
            x[3] = 10;
            x[4] = 11;
            x[5] = 12;
            filters.filterlrma(ref x, 6, 1);
            precomputederrors = (((((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(8)) || (double)(x[2])!=(double)(9)) || (double)(x[3])!=(double)(10)) || (double)(x[4])!=(double)(11)) || (double)(x[5])!=(double)(12);
            filters.filterlrma(ref x, 6, 2);
            precomputederrors = (((((precomputederrors || (double)(x[0])!=(double)(7)) || (double)(x[1])!=(double)(8)) || (double)(x[2])!=(double)(9)) || (double)(x[3])!=(double)(10)) || (double)(x[4])!=(double)(11)) || (double)(x[5])!=(double)(12);
            
            //
            // Check several precomputed problems
            //
            x = new double[6];
            x[0] = 7;
            x[1] = 8;
            x[2] = 9;
            x[3] = 10;
            x[4] = 11;
            x[5] = 12;
            filters.filterlrma(ref x, 6, 3);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[0]-7))>(double)(threshold);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[1]-8))>(double)(threshold);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[2]-9))>(double)(threshold);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[3]-10))>(double)(threshold);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[4]-11))>(double)(threshold);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[5]-12))>(double)(threshold);
            x = new double[6];
            x[0] = 7;
            x[1] = 8;
            x[2] = 8;
            x[3] = 9;
            x[4] = 12;
            x[5] = 12;
            filters.filterlrma(ref x, 6, 3);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[0]-7.0000000000))>(double)(1.0E-5);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[1]-8.0000000000))>(double)(1.0E-5);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[2]-8.1666666667))>(double)(1.0E-5);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[3]-8.8333333333))>(double)(1.0E-5);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[4]-11.6666666667))>(double)(1.0E-5);
            precomputederrors = precomputederrors || (double)(Math.Abs(x[5]-12.5000000000))>(double)(1.0E-5);
            
            //
            // Final result
            //
            result = precomputederrors;
            return result;
        }


    }
    public class testevdunit
    {
        /*************************************************************************
        Testing symmetric EVD subroutine
        *************************************************************************/
        public static bool testevd(bool silent)
        {
            bool result = new bool();
            double[,] ra = new double[0,0];
            int n = 0;
            int j = 0;
            int failc = 0;
            int runs = 0;
            double failthreshold = 0;
            double threshold = 0;
            double bithreshold = 0;
            bool waserrors = new bool();
            bool nserrors = new bool();
            bool serrors = new bool();
            bool herrors = new bool();
            bool tderrors = new bool();
            bool sbierrors = new bool();
            bool hbierrors = new bool();
            bool tdbierrors = new bool();
            bool wfailed = new bool();

            failthreshold = 0.005;
            threshold = 1.0E-8;
            bithreshold = 1.0E-6;
            nserrors = false;
            serrors = false;
            herrors = false;
            tderrors = false;
            sbierrors = false;
            hbierrors = false;
            tdbierrors = false;
            failc = 0;
            runs = 0;
            
            //
            // Test problems
            //
            for(n=1; n<=ablas.ablasblocksize(ra); n++)
            {
                testevdset(n, threshold, bithreshold, ref failc, ref runs, ref nserrors, ref serrors, ref herrors, ref tderrors, ref sbierrors, ref hbierrors, ref tdbierrors);
            }
            for(j=2; j<=3; j++)
            {
                for(n=j*ablas.ablasblocksize(ra)-1; n<=j*ablas.ablasblocksize(ra)+1; n++)
                {
                    testevdset(n, threshold, bithreshold, ref failc, ref runs, ref nserrors, ref serrors, ref herrors, ref tderrors, ref sbierrors, ref hbierrors, ref tdbierrors);
                }
            }
            
            //
            // report
            //
            wfailed = (double)((double)failc/(double)runs)>(double)(failthreshold);
            waserrors = ((((((nserrors || serrors) || herrors) || tderrors) || sbierrors) || hbierrors) || tdbierrors) || wfailed;
            if( !silent )
            {
                System.Console.Write("TESTING EVD UNIT");
                System.Console.WriteLine();
                System.Console.Write("NS ERRORS:                               ");
                if( !nserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("S ERRORS:                                ");
                if( !serrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("H ERRORS:                                ");
                if( !herrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("TD ERRORS:                               ");
                if( !tderrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("SBI ERRORS:                              ");
                if( !sbierrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("HBI ERRORS:                              ");
                if( !hbierrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("TDBI ERRORS:                             ");
                if( !tdbierrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("FAILURE THRESHOLD:                       ");
                if( !wfailed )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testevd(bool silent)
        {
            return testevd(silent);
        }


        /*************************************************************************
        Sparse fill
        *************************************************************************/
        private static void rmatrixfillsparsea(ref double[,] a,
            int m,
            int n,
            double sparcity)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(math.randomreal())>=(double)(sparcity) )
                    {
                        a[i,j] = 2*math.randomreal()-1;
                    }
                    else
                    {
                        a[i,j] = 0;
                    }
                }
            }
        }


        /*************************************************************************
        Sparse fill
        *************************************************************************/
        private static void cmatrixfillsparsea(ref complex[,] a,
            int m,
            int n,
            double sparcity)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(math.randomreal())>=(double)(sparcity) )
                    {
                        a[i,j].x = 2*math.randomreal()-1;
                        a[i,j].y = 2*math.randomreal()-1;
                    }
                    else
                    {
                        a[i,j] = 0;
                    }
                }
            }
        }


        /*************************************************************************
        Copies A to AL (lower half) and AU (upper half), filling unused parts by
        random garbage.
        *************************************************************************/
        private static void rmatrixsymmetricsplit(double[,] a,
            int n,
            ref double[,] al,
            ref double[,] au)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=n-1; i++)
            {
                for(j=i+1; j<=n-1; j++)
                {
                    al[i,j] = 2*math.randomreal()-1;
                    al[j,i] = a[i,j];
                    au[i,j] = a[i,j];
                    au[j,i] = 2*math.randomreal()-1;
                }
                al[i,i] = a[i,i];
                au[i,i] = a[i,i];
            }
        }


        /*************************************************************************
        Copies A to AL (lower half) and AU (upper half), filling unused parts by
        random garbage.
        *************************************************************************/
        private static void cmatrixhermitiansplit(complex[,] a,
            int n,
            ref complex[,] al,
            ref complex[,] au)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=n-1; i++)
            {
                for(j=i+1; j<=n-1; j++)
                {
                    al[i,j] = 2*math.randomreal()-1;
                    al[j,i] = math.conj(a[i,j]);
                    au[i,j] = a[i,j];
                    au[j,i] = 2*math.randomreal()-1;
                }
                al[i,i] = a[i,i];
                au[i,i] = a[i,i];
            }
        }


        /*************************************************************************
        Unsets 2D array.
        *************************************************************************/
        private static void unset2d(ref double[,] a)
        {
            a = new double[0,0];

            if( alglib.ap.rows(a)*alglib.ap.cols(a)>0 )
            {
                a = new double[1, 1];
            }
        }


        /*************************************************************************
        Unsets 2D array.
        *************************************************************************/
        private static void cunset2d(ref complex[,] a)
        {
            a = new complex[0+1, 0+1];
            a[0,0] = 2*math.randomreal()-1;
        }


        /*************************************************************************
        Unsets 1D array.
        *************************************************************************/
        private static void unset1d(ref double[] a)
        {
            a = new double[0];

            if( alglib.ap.len(a)>0 )
            {
                a = new double[1];
            }
        }


        /*************************************************************************
        Tests Z*Lambda*Z' against tridiag(D,E).
        Returns relative error.
        *************************************************************************/
        private static double tdtestproduct(double[] d,
            double[] e,
            int n,
            double[,] z,
            double[] lambdav)
        {
            double result = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            double mx = 0;

            result = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    //
                    // Calculate V = A[i,j], A = Z*Lambda*Z'
                    //
                    v = 0;
                    for(k=0; k<=n-1; k++)
                    {
                        v = v+z[i,k]*lambdav[k]*z[j,k];
                    }
                    
                    //
                    // Compare
                    //
                    if( Math.Abs(i-j)==0 )
                    {
                        result = Math.Max(result, Math.Abs(v-d[i]));
                    }
                    if( Math.Abs(i-j)==1 )
                    {
                        result = Math.Max(result, Math.Abs(v-e[Math.Min(i, j)]));
                    }
                    if( Math.Abs(i-j)>1 )
                    {
                        result = Math.Max(result, Math.Abs(v));
                    }
                }
            }
            mx = 0;
            for(i=0; i<=n-1; i++)
            {
                mx = Math.Max(mx, Math.Abs(d[i]));
            }
            for(i=0; i<=n-2; i++)
            {
                mx = Math.Max(mx, Math.Abs(e[i]));
            }
            if( (double)(mx)==(double)(0) )
            {
                mx = 1;
            }
            result = result/mx;
            return result;
        }


        /*************************************************************************
        Tests Z*Lambda*Z' against A
        Returns relative error.
        *************************************************************************/
        private static double testproduct(double[,] a,
            int n,
            double[,] z,
            double[] lambdav)
        {
            double result = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            double mx = 0;

            result = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    //
                    // Calculate V = A[i,j], A = Z*Lambda*Z'
                    //
                    v = 0;
                    for(k=0; k<=n-1; k++)
                    {
                        v = v+z[i,k]*lambdav[k]*z[j,k];
                    }
                    
                    //
                    // Compare
                    //
                    result = Math.Max(result, Math.Abs(v-a[i,j]));
                }
            }
            mx = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    mx = Math.Max(mx, Math.Abs(a[i,j]));
                }
            }
            if( (double)(mx)==(double)(0) )
            {
                mx = 1;
            }
            result = result/mx;
            return result;
        }


        /*************************************************************************
        Tests Z*Z' against diag(1...1)
        Returns absolute error.
        *************************************************************************/
        private static double testort(double[,] z,
            int n)
        {
            double result = 0;
            int i = 0;
            int j = 0;
            double v = 0;
            int i_ = 0;

            result = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,i]*z[i_,j];
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    result = Math.Max(result, Math.Abs(v));
                }
            }
            return result;
        }


        /*************************************************************************
        Tests Z*Lambda*Z' against A
        Returns relative error.
        *************************************************************************/
        private static double testcproduct(complex[,] a,
            int n,
            complex[,] z,
            double[] lambdav)
        {
            double result = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            complex v = 0;
            double mx = 0;

            result = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    
                    //
                    // Calculate V = A[i,j], A = Z*Lambda*Z'
                    //
                    v = 0;
                    for(k=0; k<=n-1; k++)
                    {
                        v = v+z[i,k]*lambdav[k]*math.conj(z[j,k]);
                    }
                    
                    //
                    // Compare
                    //
                    result = Math.Max(result, math.abscomplex(v-a[i,j]));
                }
            }
            mx = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    mx = Math.Max(mx, math.abscomplex(a[i,j]));
                }
            }
            if( (double)(mx)==(double)(0) )
            {
                mx = 1;
            }
            result = result/mx;
            return result;
        }


        /*************************************************************************
        Tests Z*Z' against diag(1...1)
        Returns absolute error.
        *************************************************************************/
        private static double testcort(complex[,] z,
            int n)
        {
            double result = 0;
            int i = 0;
            int j = 0;
            complex v = 0;
            int i_ = 0;

            result = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,i]*math.conj(z[i_,j]);
                    }
                    if( i==j )
                    {
                        v = v-1;
                    }
                    result = Math.Max(result, math.abscomplex(v));
                }
            }
            return result;
        }


        /*************************************************************************
        Tests SEVD problem
        *************************************************************************/
        private static void testsevdproblem(double[,] a,
            double[,] al,
            double[,] au,
            int n,
            double threshold,
            ref bool serrors,
            ref int failc,
            ref int runs)
        {
            double[] lambdav = new double[0];
            double[] lambdaref = new double[0];
            double[,] z = new double[0,0];
            int i = 0;

            
            //
            // Test simple EVD: values and full vectors, lower A
            //
            unset1d(ref lambdaref);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevd(al, n, 1, false, ref lambdaref, ref z) )
            {
                failc = failc+1;
                return;
            }
            serrors = serrors || (double)(testproduct(a, n, z, lambdaref))>(double)(threshold);
            serrors = serrors || (double)(testort(z, n))>(double)(threshold);
            for(i=0; i<=n-2; i++)
            {
                if( (double)(lambdaref[i+1])<(double)(lambdaref[i]) )
                {
                    serrors = true;
                    return;
                }
            }
            
            //
            // Test simple EVD: values and full vectors, upper A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevd(au, n, 1, true, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            serrors = serrors || (double)(testproduct(a, n, z, lambdav))>(double)(threshold);
            serrors = serrors || (double)(testort(z, n))>(double)(threshold);
            for(i=0; i<=n-2; i++)
            {
                if( (double)(lambdav[i+1])<(double)(lambdav[i]) )
                {
                    serrors = true;
                    return;
                }
            }
            
            //
            // Test simple EVD: values only, lower A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevd(al, n, 0, false, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            for(i=0; i<=n-1; i++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[i]-lambdaref[i]))>(double)(threshold);
            }
            
            //
            // Test simple EVD: values only, upper A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevd(au, n, 0, true, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            for(i=0; i<=n-1; i++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[i]-lambdaref[i]))>(double)(threshold);
            }
        }


        /*************************************************************************
        Tests SEVD problem
        *************************************************************************/
        private static void testhevdproblem(complex[,] a,
            complex[,] al,
            complex[,] au,
            int n,
            double threshold,
            ref bool herrors,
            ref int failc,
            ref int runs)
        {
            double[] lambdav = new double[0];
            double[] lambdaref = new double[0];
            complex[,] z = new complex[0,0];
            int i = 0;

            
            //
            // Test simple EVD: values and full vectors, lower A
            //
            unset1d(ref lambdaref);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevd(al, n, 1, false, ref lambdaref, ref z) )
            {
                failc = failc+1;
                return;
            }
            herrors = herrors || (double)(testcproduct(a, n, z, lambdaref))>(double)(threshold);
            herrors = herrors || (double)(testcort(z, n))>(double)(threshold);
            for(i=0; i<=n-2; i++)
            {
                if( (double)(lambdaref[i+1])<(double)(lambdaref[i]) )
                {
                    herrors = true;
                    return;
                }
            }
            
            //
            // Test simple EVD: values and full vectors, upper A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevd(au, n, 1, true, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            herrors = herrors || (double)(testcproduct(a, n, z, lambdav))>(double)(threshold);
            herrors = herrors || (double)(testcort(z, n))>(double)(threshold);
            for(i=0; i<=n-2; i++)
            {
                if( (double)(lambdav[i+1])<(double)(lambdav[i]) )
                {
                    herrors = true;
                    return;
                }
            }
            
            //
            // Test simple EVD: values only, lower A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevd(al, n, 0, false, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            for(i=0; i<=n-1; i++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[i]-lambdaref[i]))>(double)(threshold);
            }
            
            //
            // Test simple EVD: values only, upper A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevd(au, n, 0, true, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            for(i=0; i<=n-1; i++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[i]-lambdaref[i]))>(double)(threshold);
            }
        }


        /*************************************************************************
        Tests EVD problem

        DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                        are solving sparse task with  lots  of  zero  eigenvalues.
                        In such cases some tests related to the  eigenvectors  are
                        not performed.
        *************************************************************************/
        private static void testsevdbiproblem(double[,] afull,
            double[,] al,
            double[,] au,
            int n,
            bool distvals,
            double threshold,
            ref bool serrors,
            ref int failc,
            ref int runs)
        {
            double[] lambdav = new double[0];
            double[] lambdaref = new double[0];
            double[,] z = new double[0,0];
            double[,] zref = new double[0,0];
            double[,] a1 = new double[0,0];
            double[,] a2 = new double[0,0];
            double[,] ar = new double[0,0];
            int i = 0;
            int j = 0;
            int k = 0;
            int m = 0;
            int i1 = 0;
            int i2 = 0;
            double v = 0;
            double a = 0;
            double b = 0;
            int i_ = 0;

            lambdaref = new double[n-1+1];
            zref = new double[n-1+1, n-1+1];
            a1 = new double[n-1+1, n-1+1];
            a2 = new double[n-1+1, n-1+1];
            
            //
            // Reference EVD
            //
            runs = runs+1;
            if( !evd.smatrixevd(afull, n, 1, true, ref lambdaref, ref zref) )
            {
                failc = failc+1;
                return;
            }
            
            //
            // Select random interval boundaries.
            // If there are non-distinct eigenvalues at the boundaries,
            // we move indexes further until values splits. It is done to
            // avoid situations where we can't get definite answer.
            //
            i1 = math.randominteger(n);
            i2 = i1+math.randominteger(n-i1);
            while( i1>0 )
            {
                if( (double)(Math.Abs(lambdaref[i1-1]-lambdaref[i1]))>(double)(10*threshold) )
                {
                    break;
                }
                i1 = i1-1;
            }
            while( i2<n-1 )
            {
                if( (double)(Math.Abs(lambdaref[i2+1]-lambdaref[i2]))>(double)(10*threshold) )
                {
                    break;
                }
                i2 = i2+1;
            }
            
            //
            // Select A, B
            //
            if( i1>0 )
            {
                a = 0.5*(lambdaref[i1]+lambdaref[i1-1]);
            }
            else
            {
                a = lambdaref[0]-1;
            }
            if( i2<n-1 )
            {
                b = 0.5*(lambdaref[i2]+lambdaref[i2+1]);
            }
            else
            {
                b = lambdaref[n-1]+1;
            }
            
            //
            // Test interval, no vectors, lower A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdr(al, n, 0, false, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test interval, no vectors, upper A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdr(au, n, 0, true, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test indexes, no vectors, lower A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdi(al, n, 0, false, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test indexes, no vectors, upper A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdi(au, n, 0, true, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test interval, vectors, lower A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdr(al, n, 1, false, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*zref[i_,i1+j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            z[i_,j] = -1*z[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test interval, vectors, upper A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdr(au, n, 1, true, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*zref[i_,i1+j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            z[i_,j] = -1*z[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test indexes, vectors, lower A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdi(al, n, 1, false, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*zref[i_,i1+j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            z[i_,j] = -1*z[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test indexes, vectors, upper A
            //
            unset1d(ref lambdav);
            unset2d(ref z);
            runs = runs+1;
            if( !evd.smatrixevdi(au, n, 1, true, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*zref[i_,i1+j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            z[i_,j] = -1*z[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
        }


        /*************************************************************************
        Tests EVD problem

        DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                        are solving sparse task with  lots  of  zero  eigenvalues.
                        In such cases some tests related to the  eigenvectors  are
                        not performed.
        *************************************************************************/
        private static void testhevdbiproblem(complex[,] afull,
            complex[,] al,
            complex[,] au,
            int n,
            bool distvals,
            double threshold,
            ref bool herrors,
            ref int failc,
            ref int runs)
        {
            double[] lambdav = new double[0];
            double[] lambdaref = new double[0];
            complex[,] z = new complex[0,0];
            complex[,] zref = new complex[0,0];
            complex[,] a1 = new complex[0,0];
            complex[,] a2 = new complex[0,0];
            complex[,] ar = new complex[0,0];
            int i = 0;
            int j = 0;
            int k = 0;
            int m = 0;
            int i1 = 0;
            int i2 = 0;
            complex v = 0;
            double a = 0;
            double b = 0;
            int i_ = 0;

            lambdaref = new double[n-1+1];
            zref = new complex[n-1+1, n-1+1];
            a1 = new complex[n-1+1, n-1+1];
            a2 = new complex[n-1+1, n-1+1];
            
            //
            // Reference EVD
            //
            runs = runs+1;
            if( !evd.hmatrixevd(afull, n, 1, true, ref lambdaref, ref zref) )
            {
                failc = failc+1;
                return;
            }
            
            //
            // Select random interval boundaries.
            // If there are non-distinct eigenvalues at the boundaries,
            // we move indexes further until values splits. It is done to
            // avoid situations where we can't get definite answer.
            //
            i1 = math.randominteger(n);
            i2 = i1+math.randominteger(n-i1);
            while( i1>0 )
            {
                if( (double)(Math.Abs(lambdaref[i1-1]-lambdaref[i1]))>(double)(10*threshold) )
                {
                    break;
                }
                i1 = i1-1;
            }
            while( i2<n-1 )
            {
                if( (double)(Math.Abs(lambdaref[i2+1]-lambdaref[i2]))>(double)(10*threshold) )
                {
                    break;
                }
                i2 = i2+1;
            }
            
            //
            // Select A, B
            //
            if( i1>0 )
            {
                a = 0.5*(lambdaref[i1]+lambdaref[i1-1]);
            }
            else
            {
                a = lambdaref[0]-1;
            }
            if( i2<n-1 )
            {
                b = 0.5*(lambdaref[i2]+lambdaref[i2+1]);
            }
            else
            {
                b = lambdaref[n-1]+1;
            }
            
            //
            // Test interval, no vectors, lower A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdr(al, n, 0, false, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test interval, no vectors, upper A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdr(au, n, 0, true, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test indexes, no vectors, lower A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdi(al, n, 0, false, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test indexes, no vectors, upper A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdi(au, n, 0, true, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test interval, vectors, lower A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdr(al, n, 1, false, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*math.conj(zref[i_,i1+j]);
                    }
                    v = math.conj(v/math.abscomplex(v));
                    for(i_=0; i_<=n-1;i_++)
                    {
                        z[i_,j] = v*z[i_,j];
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        herrors = herrors || (double)(math.abscomplex(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test interval, vectors, upper A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdr(au, n, 1, true, a, b, ref m, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*math.conj(zref[i_,i1+j]);
                    }
                    v = math.conj(v/math.abscomplex(v));
                    for(i_=0; i_<=n-1;i_++)
                    {
                        z[i_,j] = v*z[i_,j];
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        herrors = herrors || (double)(math.abscomplex(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test indexes, vectors, lower A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdi(al, n, 1, false, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*math.conj(zref[i_,i1+j]);
                    }
                    v = math.conj(v/math.abscomplex(v));
                    for(i_=0; i_<=n-1;i_++)
                    {
                        z[i_,j] = v*z[i_,j];
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        herrors = herrors || (double)(math.abscomplex(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test indexes, vectors, upper A
            //
            unset1d(ref lambdav);
            cunset2d(ref z);
            runs = runs+1;
            if( !evd.hmatrixevdi(au, n, 1, true, i1, i2, ref lambdav, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                herrors = herrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                
                //
                // Distinct eigenvalues, test vectors
                //
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*math.conj(zref[i_,i1+j]);
                    }
                    v = math.conj(v/math.abscomplex(v));
                    for(i_=0; i_<=n-1;i_++)
                    {
                        z[i_,j] = v*z[i_,j];
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        herrors = herrors || (double)(math.abscomplex(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
        }


        /*************************************************************************
        Tests EVD problem
        *************************************************************************/
        private static void testtdevdproblem(double[] d,
            double[] e,
            int n,
            double threshold,
            ref bool tderrors)
        {
            double[] lambdav = new double[0];
            double[] ee = new double[0];
            double[] lambda2 = new double[0];
            double[,] z = new double[0,0];
            double[,] zref = new double[0,0];
            double[,] a1 = new double[0,0];
            double[,] a2 = new double[0,0];
            bool wsucc = new bool();
            int i = 0;
            int j = 0;
            double v = 0;
            double worstseparation = 0;
            double requiredseparation = 0;
            double specialthreshold = 0;
            int i_ = 0;

            lambdav = new double[n-1+1];
            lambda2 = new double[n-1+1];
            zref = new double[n-1+1, n-1+1];
            a1 = new double[n-1+1, n-1+1];
            a2 = new double[n-1+1, n-1+1];
            if( n>1 )
            {
                ee = new double[n-2+1];
            }
            
            //
            // Test simple EVD: values and full vectors
            //
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                ee[i] = e[i];
            }
            unset2d(ref z);
            wsucc = evd.smatrixtdevd(ref lambdav, ee, n, 2, ref z);
            if( !wsucc )
            {
                apserv.seterrorflag(ref tderrors, true);
                return;
            }
            apserv.seterrorflag(ref tderrors, (double)(tdtestproduct(d, e, n, z, lambdav))>(double)(threshold));
            apserv.seterrorflag(ref tderrors, (double)(testort(z, n))>(double)(threshold));
            for(i=0; i<=n-2; i++)
            {
                if( (double)(lambdav[i+1])<(double)(lambdav[i]) )
                {
                    apserv.seterrorflag(ref tderrors, true);
                    return;
                }
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    zref[i,j] = z[i,j];
                }
            }
            
            //
            // Test values only variant
            //
            for(i=0; i<=n-1; i++)
            {
                lambda2[i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                ee[i] = e[i];
            }
            unset2d(ref z);
            wsucc = evd.smatrixtdevd(ref lambda2, ee, n, 0, ref z);
            if( !wsucc )
            {
                apserv.seterrorflag(ref tderrors, true);
                return;
            }
            for(i=0; i<=n-1; i++)
            {
                apserv.seterrorflag(ref tderrors, (double)(Math.Abs(lambda2[i]-lambdav[i]))>(double)(threshold));
            }
            
            //
            // Test multiplication variant
            //
            for(i=0; i<=n-1; i++)
            {
                lambda2[i] = d[i];
            }
            for(i=0; i<=n-2; i++)
            {
                ee[i] = e[i];
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a1[i,j] = 2*math.randomreal()-1;
                    a2[i,j] = a1[i,j];
                }
            }
            wsucc = evd.smatrixtdevd(ref lambda2, ee, n, 1, ref a1);
            if( !wsucc )
            {
                apserv.seterrorflag(ref tderrors, true);
                return;
            }
            for(i=0; i<=n-1; i++)
            {
                apserv.seterrorflag(ref tderrors, (double)(Math.Abs(lambda2[i]-lambdav[i]))>(double)(threshold));
            }
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += a2[i,i_]*zref[i_,j];
                    }
                    
                    //
                    // next line is a bit complicated because
                    // depending on algorithm used we can get either
                    // z or -z as eigenvector. so we compare result
                    // with both A*ZRef and -A*ZRef
                    //
                    apserv.seterrorflag(ref tderrors, (double)(Math.Abs(v-a1[i,j]))>(double)(threshold) && (double)(Math.Abs(v+a1[i,j]))>(double)(threshold));
                }
            }
            
            //
            // Test first row variant.
            //
            // NOTE: this test is special because ZNeeded=3 is ALGLIB-specific feature
            //       which is NOT supported by Intel MKL. Thus, MKL-capable version of
            //       ALGLIB will use different algorithms for ZNeeded=3 and for ZNeeded<3.
            //
            //       In most cases it is OK, but when problem happened to be degenerate
            //       (two close eigenvalues), Z computed by ALGLIB may be different from
            //       Z computed by MKL (up to arbitrary rotation), which will lead to
            //       failure of the test, because ZNeeded=2 is used as reference value
            //       for ZNeeded=3.
            //
            //       That's why this test is performed only for well-separated matrices,
            //       and with custom threshold.
            //
            requiredseparation = 1.0E-6;
            specialthreshold = 1.0E-6;
            worstseparation = math.maxrealnumber;
            for(i=0; i<=n-2; i++)
            {
                worstseparation = Math.Min(worstseparation, Math.Abs(lambdav[i+1]-lambdav[i]));
            }
            if( (double)(worstseparation)>(double)(requiredseparation) )
            {
                for(i=0; i<=n-1; i++)
                {
                    lambda2[i] = d[i];
                }
                for(i=0; i<=n-2; i++)
                {
                    ee[i] = e[i];
                }
                unset2d(ref z);
                wsucc = evd.smatrixtdevd(ref lambda2, ee, n, 3, ref z);
                if( !wsucc )
                {
                    apserv.seterrorflag(ref tderrors, true);
                    return;
                }
                for(i=0; i<=n-1; i++)
                {
                    apserv.seterrorflag(ref tderrors, (double)(Math.Abs(lambda2[i]-lambdav[i]))>(double)(threshold));
                    
                    //
                    // next line is a bit complicated because
                    // depending on algorithm used we can get either
                    // z or -z as eigenvector. so we compare result
                    // with both z and -z
                    //
                    apserv.seterrorflag(ref tderrors, (double)(Math.Abs(z[0,i]-zref[0,i]))>(double)(specialthreshold) && (double)(Math.Abs(z[0,i]+zref[0,i]))>(double)(specialthreshold));
                }
            }
        }


        /*************************************************************************
        Tests EVD problem

        DistVals    -   is True, when eigenvalues are distinct. Is False, when we
                        are solving sparse task with  lots  of  zero  eigenvalues.
                        In such cases some tests related to the  eigenvectors  are
                        not performed.
        *************************************************************************/
        private static void testtdevdbiproblem(double[] d,
            double[] e,
            int n,
            bool distvals,
            double threshold,
            ref bool serrors,
            ref int failc,
            ref int runs)
        {
            double[] lambdav = new double[0];
            double[] lambdaref = new double[0];
            double[,] z = new double[0,0];
            double[,] zref = new double[0,0];
            double[,] a1 = new double[0,0];
            double[,] a2 = new double[0,0];
            double[,] ar = new double[0,0];
            int i = 0;
            int j = 0;
            int k = 0;
            int m = 0;
            int i1 = 0;
            int i2 = 0;
            double v = 0;
            double a = 0;
            double b = 0;
            int i_ = 0;

            lambdaref = new double[n-1+1];
            zref = new double[n-1+1, n-1+1];
            a1 = new double[n-1+1, n-1+1];
            a2 = new double[n-1+1, n-1+1];
            
            //
            // Reference EVD
            //
            lambdaref = new double[n];
            for(i_=0; i_<=n-1;i_++)
            {
                lambdaref[i_] = d[i_];
            }
            runs = runs+1;
            if( !evd.smatrixtdevd(ref lambdaref, e, n, 2, ref zref) )
            {
                failc = failc+1;
                return;
            }
            
            //
            // Select random interval boundaries.
            // If there are non-distinct eigenvalues at the boundaries,
            // we move indexes further until values splits. It is done to
            // avoid situations where we can't get definite answer.
            //
            i1 = math.randominteger(n);
            i2 = i1+math.randominteger(n-i1);
            while( i1>0 )
            {
                if( (double)(Math.Abs(lambdaref[i1-1]-lambdaref[i1]))>(double)(10*threshold) )
                {
                    break;
                }
                i1 = i1-1;
            }
            while( i2<n-1 )
            {
                if( (double)(Math.Abs(lambdaref[i2+1]-lambdaref[i2]))>(double)(10*threshold) )
                {
                    break;
                }
                i2 = i2+1;
            }
            
            //
            // Test different combinations
            //
            
            //
            // Select A, B
            //
            if( i1>0 )
            {
                a = 0.5*(lambdaref[i1]+lambdaref[i1-1]);
            }
            else
            {
                a = lambdaref[0]-1;
            }
            if( i2<n-1 )
            {
                b = 0.5*(lambdaref[i2]+lambdaref[i2+1]);
            }
            else
            {
                b = lambdaref[n-1]+1;
            }
            
            //
            // Test interval, no vectors
            //
            lambdav = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            runs = runs+1;
            if( !evd.smatrixtdevdr(ref lambdav, e, n, 0, a, b, ref m, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test indexes, no vectors
            //
            lambdav = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            runs = runs+1;
            if( !evd.smatrixtdevdi(ref lambdav, e, n, 0, i1, i2, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            
            //
            // Test interval, transform vectors
            //
            lambdav = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            a1 = new double[n-1+1, n-1+1];
            a2 = new double[n-1+1, n-1+1];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a1[i,j] = 2*math.randomreal()-1;
                    a2[i,j] = a1[i,j];
                }
            }
            runs = runs+1;
            if( !evd.smatrixtdevdr(ref lambdav, e, n, 1, a, b, ref m, ref a1) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                ar = new double[n-1+1, m-1+1];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=n-1;i_++)
                        {
                            v += a2[i,i_]*zref[i_,i1+j];
                        }
                        ar[i,j] = v;
                    }
                }
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += a1[i_,j]*ar[i_,j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            ar[i_,j] = -1*ar[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(a1[i,j]-ar[i,j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test indexes, transform vectors
            //
            lambdav = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            a1 = new double[n-1+1, n-1+1];
            a2 = new double[n-1+1, n-1+1];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a1[i,j] = 2*math.randomreal()-1;
                    a2[i,j] = a1[i,j];
                }
            }
            runs = runs+1;
            if( !evd.smatrixtdevdi(ref lambdav, e, n, 1, i1, i2, ref a1) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                ar = new double[n-1+1, m-1+1];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=n-1;i_++)
                        {
                            v += a2[i,i_]*zref[i_,i1+j];
                        }
                        ar[i,j] = v;
                    }
                }
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += a1[i_,j]*ar[i_,j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            ar[i_,j] = -1*ar[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(a1[i,j]-ar[i,j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test interval, do not transform vectors
            //
            lambdav = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            z = new double[0+1, 0+1];
            runs = runs+1;
            if( !evd.smatrixtdevdr(ref lambdav, e, n, 2, a, b, ref m, ref z) )
            {
                failc = failc+1;
                return;
            }
            if( m!=i2-i1+1 )
            {
                failc = failc+1;
                return;
            }
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*zref[i_,i1+j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            z[i_,j] = -1*z[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
            
            //
            // Test indexes, do not transform vectors
            //
            lambdav = new double[n-1+1];
            for(i=0; i<=n-1; i++)
            {
                lambdav[i] = d[i];
            }
            z = new double[0+1, 0+1];
            runs = runs+1;
            if( !evd.smatrixtdevdi(ref lambdav, e, n, 2, i1, i2, ref z) )
            {
                failc = failc+1;
                return;
            }
            m = i2-i1+1;
            for(k=0; k<=m-1; k++)
            {
                serrors = serrors || (double)(Math.Abs(lambdav[k]-lambdaref[i1+k]))>(double)(threshold);
            }
            if( distvals )
            {
                for(j=0; j<=m-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        v += z[i_,j]*zref[i_,i1+j];
                    }
                    if( (double)(v)<(double)(0) )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            z[i_,j] = -1*z[i_,j];
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=m-1; j++)
                    {
                        serrors = serrors || (double)(Math.Abs(z[i,j]-zref[i,i1+j]))>(double)(threshold);
                    }
                }
            }
        }


        /*************************************************************************
        Non-symmetric problem
        *************************************************************************/
        private static void testnsevdproblem(double[,] a,
            int n,
            double threshold,
            ref bool nserrors)
        {
            double mx = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int vjob = 0;
            bool needl = new bool();
            bool needr = new bool();
            double[] wr0 = new double[0];
            double[] wi0 = new double[0];
            double[] wr1 = new double[0];
            double[] wi1 = new double[0];
            double[] wr0s = new double[0];
            double[] wi0s = new double[0];
            double[] wr1s = new double[0];
            double[] wi1s = new double[0];
            double[,] vl = new double[0,0];
            double[,] vr = new double[0,0];
            double[] vec1r = new double[0];
            double[] vec1i = new double[0];
            double[] vec2r = new double[0];
            double[] vec2i = new double[0];
            double[] vec3r = new double[0];
            double[] vec3i = new double[0];
            double curwr = 0;
            double curwi = 0;
            double vt = 0;
            double tmp = 0;
            double vnorm = 0;
            int i_ = 0;

            vec1r = new double[n-1+1];
            vec2r = new double[n-1+1];
            vec3r = new double[n-1+1];
            vec1i = new double[n-1+1];
            vec2i = new double[n-1+1];
            vec3i = new double[n-1+1];
            wr0s = new double[n-1+1];
            wr1s = new double[n-1+1];
            wi0s = new double[n-1+1];
            wi1s = new double[n-1+1];
            mx = 0;
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(Math.Abs(a[i,j]))>(double)(mx) )
                    {
                        mx = Math.Abs(a[i,j]);
                    }
                }
            }
            if( (double)(mx)==(double)(0) )
            {
                mx = 1;
            }
            
            //
            // Load values-only
            //
            if( !evd.rmatrixevd(a, n, 0, ref wr0, ref wi0, ref vl, ref vr) )
            {
                apserv.seterrorflag(ref nserrors, true);
                return;
            }
            
            //
            // Test different jobs
            //
            for(vjob=1; vjob<=3; vjob++)
            {
                needr = vjob==1 || vjob==3;
                needl = vjob==2 || vjob==3;
                if( !evd.rmatrixevd(a, n, vjob, ref wr1, ref wi1, ref vl, ref vr) )
                {
                    apserv.seterrorflag(ref nserrors, true);
                    return;
                }
                
                //
                // Test values:
                // 1. sort by real part
                // 2. test
                //
                for(i_=0; i_<=n-1;i_++)
                {
                    wr0s[i_] = wr0[i_];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    wi0s[i_] = wi0[i_];
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-2-i; j++)
                    {
                        if( (double)(wr0s[j])>(double)(wr0s[j+1]) )
                        {
                            tmp = wr0s[j];
                            wr0s[j] = wr0s[j+1];
                            wr0s[j+1] = tmp;
                            tmp = wi0s[j];
                            wi0s[j] = wi0s[j+1];
                            wi0s[j+1] = tmp;
                        }
                    }
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    wr1s[i_] = wr1[i_];
                }
                for(i_=0; i_<=n-1;i_++)
                {
                    wi1s[i_] = wi1[i_];
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-2-i; j++)
                    {
                        if( (double)(wr1s[j])>(double)(wr1s[j+1]) )
                        {
                            tmp = wr1s[j];
                            wr1s[j] = wr1s[j+1];
                            wr1s[j+1] = tmp;
                            tmp = wi1s[j];
                            wi1s[j] = wi1s[j+1];
                            wi1s[j+1] = tmp;
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    apserv.seterrorflag(ref nserrors, (double)(Math.Abs(wr0s[i]-wr1s[i]))>(double)(threshold));
                    apserv.seterrorflag(ref nserrors, (double)(Math.Abs(wi0s[i]-wi1s[i]))>(double)(threshold));
                }
                
                //
                // Test right vectors
                //
                if( needr )
                {
                    k = 0;
                    while( k<=n-1 )
                    {
                        curwr = 0;
                        curwi = 0;
                        if( (double)(wi1[k])==(double)(0) )
                        {
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1r[i_] = vr[i_,k];
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                vec1i[i] = 0;
                            }
                            curwr = wr1[k];
                            curwi = 0;
                        }
                        if( (double)(wi1[k])>(double)(0) )
                        {
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1r[i_] = vr[i_,k];
                            }
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1i[i_] = vr[i_,k+1];
                            }
                            curwr = wr1[k];
                            curwi = wi1[k];
                        }
                        if( (double)(wi1[k])<(double)(0) )
                        {
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1r[i_] = vr[i_,k-1];
                            }
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1i[i_] = -vr[i_,k];
                            }
                            curwr = wr1[k];
                            curwi = wi1[k];
                        }
                        vnorm = 0.0;
                        for(i=0; i<=n-1; i++)
                        {
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += a[i,i_]*vec1r[i_];
                            }
                            vec2r[i] = vt;
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += a[i,i_]*vec1i[i_];
                            }
                            vec2i[i] = vt;
                            vnorm = vnorm+math.sqr(vec1r[i])+math.sqr(vec1i[i]);
                        }
                        vnorm = Math.Sqrt(vnorm);
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3r[i_] = curwr*vec1r[i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3r[i_] = vec3r[i_] - curwi*vec1i[i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3i[i_] = curwi*vec1r[i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3i[i_] = vec3i[i_] + curwr*vec1i[i_];
                        }
                        apserv.seterrorflag(ref nserrors, (double)(vnorm)<(double)(1.0E-3) || !math.isfinite(vnorm));
                        for(i=0; i<=n-1; i++)
                        {
                            apserv.seterrorflag(ref nserrors, (double)(Math.Abs(vec2r[i]-vec3r[i]))>(double)(threshold));
                            apserv.seterrorflag(ref nserrors, (double)(Math.Abs(vec2i[i]-vec3i[i]))>(double)(threshold));
                        }
                        k = k+1;
                    }
                }
                
                //
                // Test left vectors
                //
                curwr = 0;
                curwi = 0;
                if( needl )
                {
                    k = 0;
                    while( k<=n-1 )
                    {
                        if( (double)(wi1[k])==(double)(0) )
                        {
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1r[i_] = vl[i_,k];
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                vec1i[i] = 0;
                            }
                            curwr = wr1[k];
                            curwi = 0;
                        }
                        if( (double)(wi1[k])>(double)(0) )
                        {
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1r[i_] = vl[i_,k];
                            }
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1i[i_] = vl[i_,k+1];
                            }
                            curwr = wr1[k];
                            curwi = wi1[k];
                        }
                        if( (double)(wi1[k])<(double)(0) )
                        {
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1r[i_] = vl[i_,k-1];
                            }
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vec1i[i_] = -vl[i_,k];
                            }
                            curwr = wr1[k];
                            curwi = wi1[k];
                        }
                        vnorm = 0.0;
                        for(j=0; j<=n-1; j++)
                        {
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += vec1r[i_]*a[i_,j];
                            }
                            vec2r[j] = vt;
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += vec1i[i_]*a[i_,j];
                            }
                            vec2i[j] = -vt;
                            vnorm = vnorm+math.sqr(vec1r[j])+math.sqr(vec1i[j]);
                        }
                        vnorm = Math.Sqrt(vnorm);
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3r[i_] = curwr*vec1r[i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3r[i_] = vec3r[i_] + curwi*vec1i[i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3i[i_] = curwi*vec1r[i_];
                        }
                        for(i_=0; i_<=n-1;i_++)
                        {
                            vec3i[i_] = vec3i[i_] - curwr*vec1i[i_];
                        }
                        apserv.seterrorflag(ref nserrors, (double)(vnorm)<(double)(1.0E-3) || !math.isfinite(vnorm));
                        for(i=0; i<=n-1; i++)
                        {
                            apserv.seterrorflag(ref nserrors, (double)(Math.Abs(vec2r[i]-vec3r[i]))>(double)(threshold));
                            apserv.seterrorflag(ref nserrors, (double)(Math.Abs(vec2i[i]-vec3i[i]))>(double)(threshold));
                        }
                        k = k+1;
                    }
                }
            }
        }


        /*************************************************************************
        Testing EVD subroutines for one N

        NOTES:
        * BIThreshold is a threshold for bisection-and-inverse-iteration subroutines.
          special threshold is needed because these subroutines may have much more
          larger error than QR-based algorithms.
        *************************************************************************/
        private static void testevdset(int n,
            double threshold,
            double bithreshold,
            ref int failc,
            ref int runs,
            ref bool nserrors,
            ref bool serrors,
            ref bool herrors,
            ref bool tderrors,
            ref bool sbierrors,
            ref bool hbierrors,
            ref bool tdbierrors)
        {
            double[,] ra = new double[0,0];
            double[,] ral = new double[0,0];
            double[,] rau = new double[0,0];
            complex[,] ca = new complex[0,0];
            complex[,] cal = new complex[0,0];
            complex[,] cau = new complex[0,0];
            double[] d = new double[0];
            double[] e = new double[0];
            int i = 0;
            int j = 0;
            int mkind = 0;

            
            //
            // Test symmetric problems
            //
            ra = new double[n, n];
            ral = new double[n, n];
            rau = new double[n, n];
            ca = new complex[n, n];
            cal = new complex[n, n];
            cau = new complex[n, n];
            
            //
            // Zero matrices
            //
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra[i,j] = 0;
                    ca[i,j] = 0;
                }
            }
            rmatrixsymmetricsplit(ra, n, ref ral, ref rau);
            cmatrixhermitiansplit(ca, n, ref cal, ref cau);
            testsevdproblem(ra, ral, rau, n, threshold, ref serrors, ref failc, ref runs);
            testhevdproblem(ca, cal, cau, n, threshold, ref herrors, ref failc, ref runs);
            testsevdbiproblem(ra, ral, rau, n, false, bithreshold, ref sbierrors, ref failc, ref runs);
            testhevdbiproblem(ca, cal, cau, n, false, bithreshold, ref hbierrors, ref failc, ref runs);
            
            //
            // Random matrix
            //
            for(i=0; i<=n-1; i++)
            {
                for(j=i+1; j<=n-1; j++)
                {
                    ra[i,j] = 2*math.randomreal()-1;
                    ca[i,j].x = 2*math.randomreal()-1;
                    ca[i,j].y = 2*math.randomreal()-1;
                    ra[j,i] = ra[i,j];
                    ca[j,i] = math.conj(ca[i,j]);
                }
                ra[i,i] = 2*math.randomreal()-1;
                ca[i,i] = 2*math.randomreal()-1;
            }
            rmatrixsymmetricsplit(ra, n, ref ral, ref rau);
            cmatrixhermitiansplit(ca, n, ref cal, ref cau);
            testsevdproblem(ra, ral, rau, n, threshold, ref serrors, ref failc, ref runs);
            testhevdproblem(ca, cal, cau, n, threshold, ref herrors, ref failc, ref runs);
            
            //
            // Random diagonally dominant matrix with distinct eigenvalues
            //
            for(i=0; i<=n-1; i++)
            {
                for(j=i+1; j<=n-1; j++)
                {
                    ra[i,j] = 0.1*(2*math.randomreal()-1)/n;
                    ca[i,j].x = 0.1*(2*math.randomreal()-1)/n;
                    ca[i,j].y = 0.1*(2*math.randomreal()-1)/n;
                    ra[j,i] = ra[i,j];
                    ca[j,i] = math.conj(ca[i,j]);
                }
                ra[i,i] = 0.1*(2*math.randomreal()-1)+i;
                ca[i,i] = 0.1*(2*math.randomreal()-1)+i;
            }
            rmatrixsymmetricsplit(ra, n, ref ral, ref rau);
            cmatrixhermitiansplit(ca, n, ref cal, ref cau);
            testsevdproblem(ra, ral, rau, n, threshold, ref serrors, ref failc, ref runs);
            testhevdproblem(ca, cal, cau, n, threshold, ref herrors, ref failc, ref runs);
            testsevdbiproblem(ra, ral, rau, n, true, bithreshold, ref sbierrors, ref failc, ref runs);
            testhevdbiproblem(ca, cal, cau, n, true, bithreshold, ref hbierrors, ref failc, ref runs);
            
            //
            // Sparse matrices
            //
            rmatrixfillsparsea(ref ra, n, n, 0.995);
            cmatrixfillsparsea(ref ca, n, n, 0.995);
            for(i=0; i<=n-1; i++)
            {
                for(j=i+1; j<=n-1; j++)
                {
                    ra[j,i] = ra[i,j];
                    ca[j,i] = math.conj(ca[i,j]);
                }
                ca[i,i].y = 0;
            }
            rmatrixsymmetricsplit(ra, n, ref ral, ref rau);
            cmatrixhermitiansplit(ca, n, ref cal, ref cau);
            testsevdproblem(ra, ral, rau, n, threshold, ref serrors, ref failc, ref runs);
            testhevdproblem(ca, cal, cau, n, threshold, ref herrors, ref failc, ref runs);
            testsevdbiproblem(ra, ral, rau, n, false, bithreshold, ref sbierrors, ref failc, ref runs);
            testhevdbiproblem(ca, cal, cau, n, false, bithreshold, ref hbierrors, ref failc, ref runs);
            
            //
            // testing tridiagonal problems
            //
            for(mkind=0; mkind<=7; mkind++)
            {
                d = new double[n];
                if( n>1 )
                {
                    e = new double[n-1];
                }
                if( mkind==0 )
                {
                    
                    //
                    // Zero matrix
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 0;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 0;
                    }
                }
                if( mkind==1 )
                {
                    
                    //
                    // Diagonal matrix
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 2*math.randomreal()-1;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 0;
                    }
                }
                if( mkind==2 )
                {
                    
                    //
                    // Off-diagonal matrix
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 0;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 2*math.randomreal()-1;
                    }
                }
                if( mkind==3 )
                {
                    
                    //
                    // Dense matrix with blocks
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 2*math.randomreal()-1;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 2*math.randomreal()-1;
                    }
                    j = 1;
                    i = 2;
                    while( j<=n-2 )
                    {
                        e[j] = 0;
                        j = j+i;
                        i = i+1;
                    }
                }
                if( mkind==4 )
                {
                    
                    //
                    // dense matrix
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 2*math.randomreal()-1;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 2*math.randomreal()-1;
                    }
                }
                if( mkind==5 )
                {
                    
                    //
                    // Diagonal matrix with distinct eigenvalues
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 0.1*(2*math.randomreal()-1)+i;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 0;
                    }
                }
                if( mkind==6 )
                {
                    
                    //
                    // Off-diagonal matrix with distinct eigenvalues
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 0;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 0.1*(2*math.randomreal()-1)+i+1;
                    }
                }
                if( mkind==7 )
                {
                    
                    //
                    // dense matrix with distinct eigenvalues
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 0.1*(2*math.randomreal()-1)+i+1;
                    }
                    for(i=0; i<=n-2; i++)
                    {
                        e[i] = 0.1*(2*math.randomreal()-1);
                    }
                }
                testtdevdproblem(d, e, n, threshold, ref tderrors);
                testtdevdbiproblem(d, e, n, (mkind==5 || mkind==6) || mkind==7, bithreshold, ref tdbierrors, ref failc, ref runs);
            }
            
            //
            // Test non-symmetric problems
            //
            
            //
            // Test non-symmetric problems: zero, random, sparse matrices.
            //
            ra = new double[n, n];
            ca = new complex[n, n];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra[i,j] = 0;
                    ca[i,j] = 0;
                }
            }
            testnsevdproblem(ra, n, threshold, ref nserrors);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    ra[i,j] = 2*math.randomreal()-1;
                    ca[i,j].x = 2*math.randomreal()-1;
                    ca[i,j].y = 2*math.randomreal()-1;
                }
            }
            testnsevdproblem(ra, n, threshold, ref nserrors);
            rmatrixfillsparsea(ref ra, n, n, 0.995);
            cmatrixfillsparsea(ref ca, n, n, 0.995);
            testnsevdproblem(ra, n, threshold, ref nserrors);
        }


    }
    public class testmatgenunit
    {
        public const int maxsvditerations = 60;


        public static bool testmatgen(bool silent)
        {
            bool result = new bool();
            double[,] a = new double[0,0];
            double[,] b = new double[0,0];
            double[,] u = new double[0,0];
            double[,] v = new double[0,0];
            complex[,] ca = new complex[0,0];
            complex[,] cb = new complex[0,0];
            double[,] r1 = new double[0,0];
            double[,] r2 = new double[0,0];
            complex[,] c1 = new complex[0,0];
            complex[,] c2 = new complex[0,0];
            double[] w = new double[0];
            int n = 0;
            int maxn = 0;
            int i = 0;
            int j = 0;
            int pass = 0;
            int passcount = 0;
            bool waserrors = new bool();
            double cond = 0;
            double threshold = 0;
            double vt = 0;
            complex ct = 0;
            double minw = 0;
            double maxw = 0;
            bool serr = new bool();
            bool herr = new bool();
            bool spderr = new bool();
            bool hpderr = new bool();
            bool rerr = new bool();
            bool cerr = new bool();
            bool eulerr = new bool();
            int i_ = 0;

            rerr = false;
            cerr = false;
            serr = false;
            herr = false;
            spderr = false;
            hpderr = false;
            eulerr = false;
            waserrors = false;
            maxn = 20;
            passcount = 15;
            threshold = 1000*math.machineepsilon;
            
            //
            // Testing orthogonal
            //
            for(n=1; n<=maxn; n++)
            {
                for(pass=1; pass<=passcount; pass++)
                {
                    r1 = new double[n-1+1, 2*n-1+1];
                    r2 = new double[2*n-1+1, n-1+1];
                    c1 = new complex[n-1+1, 2*n-1+1];
                    c2 = new complex[2*n-1+1, n-1+1];
                    
                    //
                    // Random orthogonal, real
                    //
                    unset2d(ref a);
                    unset2d(ref b);
                    matgen.rmatrixrndorthogonal(n, ref a);
                    matgen.rmatrixrndorthogonal(n, ref b);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            
                            //
                            // orthogonality test
                            //
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += a[i,i_]*a[j,i_];
                            }
                            if( i==j )
                            {
                                rerr = rerr || (double)(Math.Abs(vt-1))>(double)(threshold);
                            }
                            else
                            {
                                rerr = rerr || (double)(Math.Abs(vt))>(double)(threshold);
                            }
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += b[i,i_]*b[j,i_];
                            }
                            if( i==j )
                            {
                                rerr = rerr || (double)(Math.Abs(vt-1))>(double)(threshold);
                            }
                            else
                            {
                                rerr = rerr || (double)(Math.Abs(vt))>(double)(threshold);
                            }
                            
                            //
                            // test for difference in A and B
                            //
                            if( n>=2 )
                            {
                                rerr = rerr || (double)(a[i,j])==(double)(b[i,j]);
                            }
                        }
                    }
                    
                    //
                    // Random orthogonal, complex
                    //
                    unset2dc(ref ca);
                    unset2dc(ref cb);
                    matgen.cmatrixrndorthogonal(n, ref ca);
                    matgen.cmatrixrndorthogonal(n, ref cb);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            
                            //
                            // orthogonality test
                            //
                            ct = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                ct += ca[i,i_]*math.conj(ca[j,i_]);
                            }
                            if( i==j )
                            {
                                cerr = cerr || (double)(math.abscomplex(ct-1))>(double)(threshold);
                            }
                            else
                            {
                                cerr = cerr || (double)(math.abscomplex(ct))>(double)(threshold);
                            }
                            ct = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                ct += cb[i,i_]*math.conj(cb[j,i_]);
                            }
                            if( i==j )
                            {
                                cerr = cerr || (double)(math.abscomplex(ct-1))>(double)(threshold);
                            }
                            else
                            {
                                cerr = cerr || (double)(math.abscomplex(ct))>(double)(threshold);
                            }
                            
                            //
                            // test for difference in A and B
                            //
                            if( n>=2 )
                            {
                                cerr = cerr || ca[i,j]==cb[i,j];
                            }
                        }
                    }
                    
                    //
                    // From the right real tests:
                    // 1. E*Q is orthogonal
                    // 2. Q1<>Q2 (routine result is changing)
                    // 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
                    //
                    unset2d(ref a);
                    unset2d(ref b);
                    a = new double[n-1+1, n-1+1];
                    b = new double[n-1+1, n-1+1];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a[i,j] = 0;
                            b[i,j] = 0;
                        }
                        a[i,i] = 1;
                        b[i,i] = 1;
                    }
                    matgen.rmatrixrndorthogonalfromtheright(ref a, n, n);
                    matgen.rmatrixrndorthogonalfromtheright(ref b, n, n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            
                            //
                            // orthogonality test
                            //
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += a[i,i_]*a[j,i_];
                            }
                            if( i==j )
                            {
                                rerr = rerr || (double)(Math.Abs(vt-1))>(double)(threshold);
                            }
                            else
                            {
                                rerr = rerr || (double)(Math.Abs(vt))>(double)(threshold);
                            }
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += b[i,i_]*b[j,i_];
                            }
                            if( i==j )
                            {
                                rerr = rerr || (double)(Math.Abs(vt-1))>(double)(threshold);
                            }
                            else
                            {
                                rerr = rerr || (double)(Math.Abs(vt))>(double)(threshold);
                            }
                            
                            //
                            // test for difference in A and B
                            //
                            if( n>=2 )
                            {
                                rerr = rerr || (double)(a[i,j])==(double)(b[i,j]);
                            }
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            r2[i,j] = 2*math.randomreal()-1;
                            r2[i+n,j] = r2[i,j];
                        }
                    }
                    matgen.rmatrixrndorthogonalfromtheright(ref r2, 2*n, n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            rerr = rerr || (double)(Math.Abs(r2[i+n,j]-r2[i,j]))>(double)(threshold);
                        }
                    }
                    
                    //
                    // From the left real tests:
                    // 1. Q*E is orthogonal
                    // 2. Q1<>Q2 (routine result is changing)
                    // 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
                    //
                    unset2d(ref a);
                    unset2d(ref b);
                    a = new double[n-1+1, n-1+1];
                    b = new double[n-1+1, n-1+1];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a[i,j] = 0;
                            b[i,j] = 0;
                        }
                        a[i,i] = 1;
                        b[i,i] = 1;
                    }
                    matgen.rmatrixrndorthogonalfromtheleft(ref a, n, n);
                    matgen.rmatrixrndorthogonalfromtheleft(ref b, n, n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            
                            //
                            // orthogonality test
                            //
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += a[i,i_]*a[j,i_];
                            }
                            if( i==j )
                            {
                                rerr = rerr || (double)(Math.Abs(vt-1))>(double)(threshold);
                            }
                            else
                            {
                                rerr = rerr || (double)(Math.Abs(vt))>(double)(threshold);
                            }
                            vt = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                vt += b[i,i_]*b[j,i_];
                            }
                            if( i==j )
                            {
                                rerr = rerr || (double)(Math.Abs(vt-1))>(double)(threshold);
                            }
                            else
                            {
                                rerr = rerr || (double)(Math.Abs(vt))>(double)(threshold);
                            }
                            
                            //
                            // test for difference in A and B
                            //
                            if( n>=2 )
                            {
                                rerr = rerr || (double)(a[i,j])==(double)(b[i,j]);
                            }
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            r1[i,j] = 2*math.randomreal()-1;
                            r1[i,j+n] = r1[i,j];
                        }
                    }
                    matgen.rmatrixrndorthogonalfromtheleft(ref r1, n, 2*n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            rerr = rerr || (double)(Math.Abs(r1[i,j]-r1[i,j+n]))>(double)(threshold);
                        }
                    }
                    
                    //
                    // From the right complex tests:
                    // 1. E*Q is orthogonal
                    // 2. Q1<>Q2 (routine result is changing)
                    // 3. (E E)'*Q = (Q' Q')' (correct handling of non-square matrices)
                    //
                    unset2dc(ref ca);
                    unset2dc(ref cb);
                    ca = new complex[n-1+1, n-1+1];
                    cb = new complex[n-1+1, n-1+1];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ca[i,j] = 0;
                            cb[i,j] = 0;
                        }
                        ca[i,i] = 1;
                        cb[i,i] = 1;
                    }
                    matgen.cmatrixrndorthogonalfromtheright(ref ca, n, n);
                    matgen.cmatrixrndorthogonalfromtheright(ref cb, n, n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            
                            //
                            // orthogonality test
                            //
                            ct = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                ct += ca[i,i_]*math.conj(ca[j,i_]);
                            }
                            if( i==j )
                            {
                                cerr = cerr || (double)(math.abscomplex(ct-1))>(double)(threshold);
                            }
                            else
                            {
                                cerr = cerr || (double)(math.abscomplex(ct))>(double)(threshold);
                            }
                            ct = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                ct += cb[i,i_]*math.conj(cb[j,i_]);
                            }
                            if( i==j )
                            {
                                cerr = cerr || (double)(math.abscomplex(ct-1))>(double)(threshold);
                            }
                            else
                            {
                                cerr = cerr || (double)(math.abscomplex(ct))>(double)(threshold);
                            }
                            
                            //
                            // test for difference in A and B
                            //
                            cerr = cerr || ca[i,j]==cb[i,j];
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            c2[i,j] = 2*math.randomreal()-1;
                            c2[i+n,j] = c2[i,j];
                        }
                    }
                    matgen.cmatrixrndorthogonalfromtheright(ref c2, 2*n, n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            cerr = cerr || (double)(math.abscomplex(c2[i+n,j]-c2[i,j]))>(double)(threshold);
                        }
                    }
                    
                    //
                    // From the left complex tests:
                    // 1. Q*E is orthogonal
                    // 2. Q1<>Q2 (routine result is changing)
                    // 3. Q*(E E) = (Q Q) (correct handling of non-square matrices)
                    //
                    unset2dc(ref ca);
                    unset2dc(ref cb);
                    ca = new complex[n-1+1, n-1+1];
                    cb = new complex[n-1+1, n-1+1];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ca[i,j] = 0;
                            cb[i,j] = 0;
                        }
                        ca[i,i] = 1;
                        cb[i,i] = 1;
                    }
                    matgen.cmatrixrndorthogonalfromtheleft(ref ca, n, n);
                    matgen.cmatrixrndorthogonalfromtheleft(ref cb, n, n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            
                            //
                            // orthogonality test
                            //
                            ct = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                ct += ca[i,i_]*math.conj(ca[j,i_]);
                            }
                            if( i==j )
                            {
                                cerr = cerr || (double)(math.abscomplex(ct-1))>(double)(threshold);
                            }
                            else
                            {
                                cerr = cerr || (double)(math.abscomplex(ct))>(double)(threshold);
                            }
                            ct = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                ct += cb[i,i_]*math.conj(cb[j,i_]);
                            }
                            if( i==j )
                            {
                                cerr = cerr || (double)(math.abscomplex(ct-1))>(double)(threshold);
                            }
                            else
                            {
                                cerr = cerr || (double)(math.abscomplex(ct))>(double)(threshold);
                            }
                            
                            //
                            // test for difference in A and B
                            //
                            cerr = cerr || ca[i,j]==cb[i,j];
                        }
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            c1[i,j] = 2*math.randomreal()-1;
                            c1[i,j+n] = c1[i,j];
                        }
                    }
                    matgen.cmatrixrndorthogonalfromtheleft(ref c1, n, 2*n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            cerr = cerr || (double)(math.abscomplex(c1[i,j]-c1[i,j+n]))>(double)(threshold);
                        }
                    }
                }
            }
            
            //
            // Testing GCond
            //
            for(n=2; n<=maxn; n++)
            {
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // real test
                    //
                    unset2d(ref a);
                    cond = Math.Exp(Math.Log(1000)*math.randomreal());
                    matgen.rmatrixrndcond(n, cond, ref a);
                    b = new double[n+1, n+1];
                    for(i=1; i<=n; i++)
                    {
                        for(j=1; j<=n; j++)
                        {
                            b[i,j] = a[i-1,j-1];
                        }
                    }
                    if( obsoletesvddecomposition(ref b, n, n, ref w, ref v) )
                    {
                        maxw = w[1];
                        minw = w[1];
                        for(i=2; i<=n; i++)
                        {
                            if( (double)(w[i])>(double)(maxw) )
                            {
                                maxw = w[i];
                            }
                            if( (double)(w[i])<(double)(minw) )
                            {
                                minw = w[i];
                            }
                        }
                        vt = maxw/minw/cond;
                        if( (double)(Math.Abs(Math.Log(vt)))>(double)(Math.Log(1+threshold)) )
                        {
                            rerr = true;
                        }
                    }
                }
            }
            
            //
            // Symmetric/SPD
            // N = 2 .. 30
            //
            for(n=2; n<=maxn; n++)
            {
                
                //
                // SPD matrices
                //
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // Generate A
                    //
                    unset2d(ref a);
                    cond = Math.Exp(Math.Log(1000)*math.randomreal());
                    matgen.spdmatrixrndcond(n, cond, ref a);
                    
                    //
                    // test condition number
                    //
                    spderr = spderr || (double)(svdcond(a, n)/cond-1)>(double)(threshold);
                    
                    //
                    // test SPD
                    //
                    spderr = spderr || !isspd(a, n, true);
                    
                    //
                    // test that A is symmetic
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            spderr = spderr || (double)(Math.Abs(a[i,j]-a[j,i]))>(double)(threshold);
                        }
                    }
                    
                    //
                    // test for difference between A and B (subsequent matrix)
                    //
                    unset2d(ref b);
                    matgen.spdmatrixrndcond(n, cond, ref b);
                    if( n>=2 )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                spderr = spderr || (double)(a[i,j])==(double)(b[i,j]);
                            }
                        }
                    }
                }
                
                //
                // HPD matrices
                //
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // Generate A
                    //
                    unset2dc(ref ca);
                    cond = Math.Exp(Math.Log(1000)*math.randomreal());
                    matgen.hpdmatrixrndcond(n, cond, ref ca);
                    
                    //
                    // test HPD
                    //
                    hpderr = hpderr || !ishpd(ca, n);
                    
                    //
                    // test that A is Hermitian
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            hpderr = hpderr || (double)(math.abscomplex(ca[i,j]-math.conj(ca[j,i])))>(double)(threshold);
                        }
                    }
                    
                    //
                    // test for difference between A and B (subsequent matrix)
                    //
                    unset2dc(ref cb);
                    matgen.hpdmatrixrndcond(n, cond, ref cb);
                    if( n>=2 )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                hpderr = hpderr || ca[i,j]==cb[i,j];
                            }
                        }
                    }
                }
                
                //
                // Symmetric matrices
                //
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // test condition number
                    //
                    unset2d(ref a);
                    cond = Math.Exp(Math.Log(1000)*math.randomreal());
                    matgen.smatrixrndcond(n, cond, ref a);
                    serr = serr || (double)(svdcond(a, n)/cond-1)>(double)(threshold);
                    
                    //
                    // test for difference between A and B
                    //
                    unset2d(ref b);
                    matgen.smatrixrndcond(n, cond, ref b);
                    if( n>=2 )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                serr = serr || (double)(a[i,j])==(double)(b[i,j]);
                            }
                        }
                    }
                }
                
                //
                // Hermitian matrices
                //
                for(pass=1; pass<=passcount; pass++)
                {
                    
                    //
                    // Generate A
                    //
                    unset2dc(ref ca);
                    cond = Math.Exp(Math.Log(1000)*math.randomreal());
                    matgen.hmatrixrndcond(n, cond, ref ca);
                    
                    //
                    // test that A is Hermitian
                    //
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            herr = herr || (double)(math.abscomplex(ca[i,j]-math.conj(ca[j,i])))>(double)(threshold);
                        }
                    }
                    
                    //
                    // test for difference between A and B (subsequent matrix)
                    //
                    unset2dc(ref cb);
                    matgen.hmatrixrndcond(n, cond, ref cb);
                    if( n>=2 )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                herr = herr || ca[i,j]==cb[i,j];
                            }
                        }
                    }
                }
            }
            
            //
            // Test for symmetric matrices
            //
            eulerr = testeult();
            
            //
            // report
            //
            waserrors = (((((rerr || cerr) || serr) || spderr) || herr) || hpderr) || eulerr;
            if( !silent )
            {
                System.Console.Write("TESTING MATRIX GENERATOR");
                System.Console.WriteLine();
                System.Console.Write("REAL TEST:                               ");
                if( !rerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("COMPLEX TEST:                            ");
                if( !cerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("SYMMETRIC TEST:                          ");
                if( !serr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("HERMITIAN TEST:                          ");
                if( !herr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("SPD TEST:                                ");
                if( !spderr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("HPD TEST:                                ");
                if( !hpderr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("TEST FOR SYMMETRIC MATRICES:             ");
                if( !eulerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testmatgen(bool silent)
        {
            return testmatgen(silent);
        }


        /*************************************************************************
        Unsets 2D array.
        *************************************************************************/
        private static void unset2d(ref double[,] a)
        {
            a = new double[0+1, 0+1];
            a[0,0] = 2*math.randomreal()-1;
        }


        /*************************************************************************
        Unsets 2D array.
        *************************************************************************/
        private static void unset2dc(ref complex[,] a)
        {
            a = new complex[0+1, 0+1];
            a[0,0] = 2*math.randomreal()-1;
        }


        /*************************************************************************
        Test whether matrix is SPD
        *************************************************************************/
        private static bool isspd(double[,] a,
            int n,
            bool isupper)
        {
            bool result = new bool();
            int i = 0;
            int j = 0;
            double ajj = 0;
            double v = 0;
            int i_ = 0;

            a = (double[,])a.Clone();

            
            //
            //     Test the input parameters.
            //
            alglib.ap.assert(n>=0, "Error in SMatrixCholesky: incorrect function arguments");
            
            //
            //     Quick return if possible
            //
            result = true;
            if( n<=0 )
            {
                return result;
            }
            if( isupper )
            {
                
                //
                // Compute the Cholesky factorization A = U'*U.
                //
                for(j=0; j<=n-1; j++)
                {
                    
                    //
                    // Compute U(J,J) and test for non-positive-definiteness.
                    //
                    v = 0.0;
                    for(i_=0; i_<=j-1;i_++)
                    {
                        v += a[i_,j]*a[i_,j];
                    }
                    ajj = a[j,j]-v;
                    if( (double)(ajj)<=(double)(0) )
                    {
                        result = false;
                        return result;
                    }
                    ajj = Math.Sqrt(ajj);
                    a[j,j] = ajj;
                    
                    //
                    // Compute elements J+1:N of row J.
                    //
                    if( j<n-1 )
                    {
                        for(i=j+1; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=j-1;i_++)
                            {
                                v += a[i_,i]*a[i_,j];
                            }
                            a[j,i] = a[j,i]-v;
                        }
                        v = 1/ajj;
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            a[j,i_] = v*a[j,i_];
                        }
                    }
                }
            }
            else
            {
                
                //
                // Compute the Cholesky factorization A = L*L'.
                //
                for(j=0; j<=n-1; j++)
                {
                    
                    //
                    // Compute L(J,J) and test for non-positive-definiteness.
                    //
                    v = 0.0;
                    for(i_=0; i_<=j-1;i_++)
                    {
                        v += a[j,i_]*a[j,i_];
                    }
                    ajj = a[j,j]-v;
                    if( (double)(ajj)<=(double)(0) )
                    {
                        result = false;
                        return result;
                    }
                    ajj = Math.Sqrt(ajj);
                    a[j,j] = ajj;
                    
                    //
                    // Compute elements J+1:N of column J.
                    //
                    if( j<n-1 )
                    {
                        for(i=j+1; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=j-1;i_++)
                            {
                                v += a[i,i_]*a[j,i_];
                            }
                            a[i,j] = a[i,j]-v;
                        }
                        v = 1/ajj;
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            a[i_,j] = v*a[i_,j];
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Tests whether A is HPD
        *************************************************************************/
        private static bool ishpd(complex[,] a,
            int n)
        {
            bool result = new bool();
            int j = 0;
            double ajj = 0;
            complex v = 0;
            double r = 0;
            complex[] t = new complex[0];
            complex[] t2 = new complex[0];
            complex[] t3 = new complex[0];
            int i = 0;
            complex[,] a1 = new complex[0,0];
            int i_ = 0;

            a = (complex[,])a.Clone();

            t = new complex[n-1+1];
            t2 = new complex[n-1+1];
            t3 = new complex[n-1+1];
            result = true;
            
            //
            // Compute the Cholesky factorization A = U'*U.
            //
            for(j=0; j<=n-1; j++)
            {
                
                //
                // Compute U(J,J) and test for non-positive-definiteness.
                //
                v = 0.0;
                for(i_=0; i_<=j-1;i_++)
                {
                    v += math.conj(a[i_,j])*a[i_,j];
                }
                ajj = (a[j,j]-v).x;
                if( (double)(ajj)<=(double)(0) )
                {
                    a[j,j] = ajj;
                    result = false;
                    return result;
                }
                ajj = Math.Sqrt(ajj);
                a[j,j] = ajj;
                
                //
                // Compute elements J+1:N-1 of row J.
                //
                if( j<n-1 )
                {
                    for(i_=0; i_<=j-1;i_++)
                    {
                        t2[i_] = math.conj(a[i_,j]);
                    }
                    for(i_=j+1; i_<=n-1;i_++)
                    {
                        t3[i_] = a[j,i_];
                    }
                    for(i=j+1; i<=n-1; i++)
                    {
                        v = 0.0;
                        for(i_=0; i_<=j-1;i_++)
                        {
                            v += a[i_,i]*t2[i_];
                        }
                        t3[i] = t3[i]-v;
                    }
                    for(i_=j+1; i_<=n-1;i_++)
                    {
                        a[j,i_] = t3[i_];
                    }
                    r = 1/ajj;
                    for(i_=j+1; i_<=n-1;i_++)
                    {
                        a[j,i_] = r*a[j,i_];
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        The function check, that upper triangle from symmetric matrix is equal to
        lower triangle.
        *************************************************************************/
        private static bool testeult()
        {
            bool result = new bool();
            double[,] a = new double[0,0];
            complex[,] b = new complex[0,0];
            double c = 0;
            double range = 0;
            double eps = 0;
            int n = 0;
            int i = 0;
            int j = 0;

            eps = 2*math.machineepsilon;
            range = 100*(2*math.randomreal()-1);
            for(n=1; n<=15; n++)
            {
                c = 900*math.randomreal()+100;
                
                //
                // Generate symmetric matrix and check it
                //
                matgen.smatrixrndcond(n, c, ref a);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(Math.Abs(a[i,j]-a[j,i]))>(double)(eps) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
                matgen.spdmatrixrndcond(n, c, ref a);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(Math.Abs(a[i,j]-a[j,i]))>(double)(eps) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
                matgen.hmatrixrndcond(n, c, ref b);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(Math.Abs(b[i,j].x-b[j,i].x))>(double)(eps) || (double)(Math.Abs(b[i,j].y+b[j,i].y))>(double)(eps) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
                matgen.hpdmatrixrndcond(n, c, ref b);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(Math.Abs(b[i,j].x-b[j,i].x))>(double)(eps) || (double)(Math.Abs(b[i,j].y+b[j,i].y))>(double)(eps) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
                
                //
                // Prepare symmetric matrix with real values
                //
                for(i=0; i<=n-1; i++)
                {
                    for(j=i; j<=n-1; j++)
                    {
                        a[i,j] = range*(2*math.randomreal()-1);
                    }
                }
                for(i=0; i<=n-2; i++)
                {
                    for(j=i+1; j<=n-1; j++)
                    {
                        a[j,i] = a[i,j];
                    }
                }
                matgen.smatrixrndmultiply(ref a, n);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(Math.Abs(a[i,j]-a[j,i]))>(double)(eps) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
                
                //
                // Prepare symmetric matrix with complex values
                //
                for(i=0; i<=n-1; i++)
                {
                    for(j=i; j<=n-1; j++)
                    {
                        b[i,j].x = range*(2*math.randomreal()-1);
                        if( i!=j )
                        {
                            b[i,j].y = range*(2*math.randomreal()-1);
                        }
                        else
                        {
                            b[i,j].y = 0;
                        }
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=i+1; j<=n-1; j++)
                    {
                        b[i,j].x = b[j,i].x;
                        b[i,j].y = -b[j,i].y;
                    }
                }
                matgen.hmatrixrndmultiply(ref b, n);
                for(i=0; i<=n-1; i++)
                {
                    b[i,i].y = 0;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(Math.Abs(b[i,j].x-b[j,i].x))>(double)(eps) || (double)(Math.Abs(b[i,j].y+b[j,i].y))>(double)(eps) )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        SVD condition number
        *************************************************************************/
        private static double svdcond(double[,] a,
            int n)
        {
            double result = 0;
            double[,] a1 = new double[0,0];
            double[,] v = new double[0,0];
            double[] w = new double[0];
            int i = 0;
            int j = 0;
            double minw = 0;
            double maxw = 0;

            a1 = new double[n+1, n+1];
            for(i=1; i<=n; i++)
            {
                for(j=1; j<=n; j++)
                {
                    a1[i,j] = a[i-1,j-1];
                }
            }
            if( !obsoletesvddecomposition(ref a1, n, n, ref w, ref v) )
            {
                result = 0;
                return result;
            }
            minw = w[1];
            maxw = w[1];
            for(i=2; i<=n; i++)
            {
                if( (double)(w[i])<(double)(minw) )
                {
                    minw = w[i];
                }
                if( (double)(w[i])>(double)(maxw) )
                {
                    maxw = w[i];
                }
            }
            result = maxw/minw;
            return result;
        }


        private static bool obsoletesvddecomposition(ref double[,] a,
            int m,
            int n,
            ref double[] w,
            ref double[,] v)
        {
            bool result = new bool();
            int nm = 0;
            int minmn = 0;
            int l = 0;
            int k = 0;
            int j = 0;
            int jj = 0;
            int its = 0;
            int i = 0;
            double z = 0;
            double y = 0;
            double x = 0;
            double vscale = 0;
            double s = 0;
            double h = 0;
            double g = 0;
            double f = 0;
            double c = 0;
            double anorm = 0;
            double[] rv1 = new double[0];
            bool flag = new bool();

            w = new double[0];
            v = new double[0,0];

            rv1 = new double[n+1];
            w = new double[n+1];
            v = new double[n+1, n+1];
            result = true;
            if( m<n )
            {
                minmn = m;
            }
            else
            {
                minmn = n;
            }
            g = 0.0;
            vscale = 0.0;
            anorm = 0.0;
            l = n;
            for(i=1; i<=n; i++)
            {
                l = i+1;
                rv1[i] = vscale*g;
                g = 0;
                s = 0;
                vscale = 0;
                if( i<=m )
                {
                    for(k=i; k<=m; k++)
                    {
                        vscale = vscale+Math.Abs(a[k,i]);
                    }
                    if( (double)(vscale)!=(double)(0.0) )
                    {
                        for(k=i; k<=m; k++)
                        {
                            a[k,i] = a[k,i]/vscale;
                            s = s+a[k,i]*a[k,i];
                        }
                        f = a[i,i];
                        g = -extsign(Math.Sqrt(s), f);
                        h = f*g-s;
                        a[i,i] = f-g;
                        if( i!=n )
                        {
                            for(j=l; j<=n; j++)
                            {
                                s = 0.0;
                                for(k=i; k<=m; k++)
                                {
                                    s = s+a[k,i]*a[k,j];
                                }
                                f = s/h;
                                for(k=i; k<=m; k++)
                                {
                                    a[k,j] = a[k,j]+f*a[k,i];
                                }
                            }
                        }
                        for(k=i; k<=m; k++)
                        {
                            a[k,i] = vscale*a[k,i];
                        }
                    }
                }
                w[i] = vscale*g;
                g = 0.0;
                s = 0.0;
                vscale = 0.0;
                if( i<=m && i!=n )
                {
                    for(k=l; k<=n; k++)
                    {
                        vscale = vscale+Math.Abs(a[i,k]);
                    }
                    if( (double)(vscale)!=(double)(0.0) )
                    {
                        for(k=l; k<=n; k++)
                        {
                            a[i,k] = a[i,k]/vscale;
                            s = s+a[i,k]*a[i,k];
                        }
                        f = a[i,l];
                        g = -extsign(Math.Sqrt(s), f);
                        h = f*g-s;
                        a[i,l] = f-g;
                        for(k=l; k<=n; k++)
                        {
                            rv1[k] = a[i,k]/h;
                        }
                        if( i!=m )
                        {
                            for(j=l; j<=m; j++)
                            {
                                s = 0.0;
                                for(k=l; k<=n; k++)
                                {
                                    s = s+a[j,k]*a[i,k];
                                }
                                for(k=l; k<=n; k++)
                                {
                                    a[j,k] = a[j,k]+s*rv1[k];
                                }
                            }
                        }
                        for(k=l; k<=n; k++)
                        {
                            a[i,k] = vscale*a[i,k];
                        }
                    }
                }
                anorm = mymax(anorm, Math.Abs(w[i])+Math.Abs(rv1[i]));
            }
            for(i=n; i>=1; i--)
            {
                if( i<n )
                {
                    if( (double)(g)!=(double)(0.0) )
                    {
                        for(j=l; j<=n; j++)
                        {
                            v[j,i] = a[i,j]/a[i,l]/g;
                        }
                        for(j=l; j<=n; j++)
                        {
                            s = 0.0;
                            for(k=l; k<=n; k++)
                            {
                                s = s+a[i,k]*v[k,j];
                            }
                            for(k=l; k<=n; k++)
                            {
                                v[k,j] = v[k,j]+s*v[k,i];
                            }
                        }
                    }
                    for(j=l; j<=n; j++)
                    {
                        v[i,j] = 0.0;
                        v[j,i] = 0.0;
                    }
                }
                v[i,i] = 1.0;
                g = rv1[i];
                l = i;
            }
            for(i=minmn; i>=1; i--)
            {
                l = i+1;
                g = w[i];
                if( i<n )
                {
                    for(j=l; j<=n; j++)
                    {
                        a[i,j] = 0.0;
                    }
                }
                if( (double)(g)!=(double)(0.0) )
                {
                    g = 1.0/g;
                    if( i!=n )
                    {
                        for(j=l; j<=n; j++)
                        {
                            s = 0.0;
                            for(k=l; k<=m; k++)
                            {
                                s = s+a[k,i]*a[k,j];
                            }
                            f = s/a[i,i]*g;
                            for(k=i; k<=m; k++)
                            {
                                a[k,j] = a[k,j]+f*a[k,i];
                            }
                        }
                    }
                    for(j=i; j<=m; j++)
                    {
                        a[j,i] = a[j,i]*g;
                    }
                }
                else
                {
                    for(j=i; j<=m; j++)
                    {
                        a[j,i] = 0.0;
                    }
                }
                a[i,i] = a[i,i]+1.0;
            }
            nm = 0;
            for(k=n; k>=1; k--)
            {
                for(its=1; its<=maxsvditerations; its++)
                {
                    flag = true;
                    for(l=k; l>=1; l--)
                    {
                        nm = l-1;
                        if( (double)(Math.Abs(rv1[l])+anorm)==(double)(anorm) )
                        {
                            flag = false;
                            break;
                        }
                        if( (double)(Math.Abs(w[nm])+anorm)==(double)(anorm) )
                        {
                            break;
                        }
                    }
                    if( flag )
                    {
                        c = 0.0;
                        s = 1.0;
                        for(i=l; i<=k; i++)
                        {
                            f = s*rv1[i];
                            if( (double)(Math.Abs(f)+anorm)!=(double)(anorm) )
                            {
                                g = w[i];
                                h = pythag(f, g);
                                w[i] = h;
                                h = 1.0/h;
                                c = g*h;
                                s = -(f*h);
                                for(j=1; j<=m; j++)
                                {
                                    y = a[j,nm];
                                    z = a[j,i];
                                    a[j,nm] = y*c+z*s;
                                    a[j,i] = -(y*s)+z*c;
                                }
                            }
                        }
                    }
                    z = w[k];
                    if( l==k )
                    {
                        if( (double)(z)<(double)(0.0) )
                        {
                            w[k] = -z;
                            for(j=1; j<=n; j++)
                            {
                                v[j,k] = -v[j,k];
                            }
                        }
                        break;
                    }
                    if( its==maxsvditerations )
                    {
                        result = false;
                        return result;
                    }
                    x = w[l];
                    nm = k-1;
                    y = w[nm];
                    g = rv1[nm];
                    h = rv1[k];
                    f = ((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
                    g = pythag(f, 1);
                    f = ((x-z)*(x+z)+h*(y/(f+extsign(g, f))-h))/x;
                    c = 1.0;
                    s = 1.0;
                    for(j=l; j<=nm; j++)
                    {
                        i = j+1;
                        g = rv1[i];
                        y = w[i];
                        h = s*g;
                        g = c*g;
                        z = pythag(f, h);
                        rv1[j] = z;
                        c = f/z;
                        s = h/z;
                        f = x*c+g*s;
                        g = -(x*s)+g*c;
                        h = y*s;
                        y = y*c;
                        for(jj=1; jj<=n; jj++)
                        {
                            x = v[jj,j];
                            z = v[jj,i];
                            v[jj,j] = x*c+z*s;
                            v[jj,i] = -(x*s)+z*c;
                        }
                        z = pythag(f, h);
                        w[j] = z;
                        if( (double)(z)!=(double)(0.0) )
                        {
                            z = 1.0/z;
                            c = f*z;
                            s = h*z;
                        }
                        f = c*g+s*y;
                        x = -(s*g)+c*y;
                        for(jj=1; jj<=m; jj++)
                        {
                            y = a[jj,j];
                            z = a[jj,i];
                            a[jj,j] = y*c+z*s;
                            a[jj,i] = -(y*s)+z*c;
                        }
                    }
                    rv1[l] = 0.0;
                    rv1[k] = f;
                    w[k] = x;
                }
            }
            return result;
        }


        private static double extsign(double a,
            double b)
        {
            double result = 0;

            if( (double)(b)>=(double)(0) )
            {
                result = Math.Abs(a);
            }
            else
            {
                result = -Math.Abs(a);
            }
            return result;
        }


        private static double mymax(double a,
            double b)
        {
            double result = 0;

            if( (double)(a)>(double)(b) )
            {
                result = a;
            }
            else
            {
                result = b;
            }
            return result;
        }


        private static double pythag(double a,
            double b)
        {
            double result = 0;

            if( (double)(Math.Abs(a))<(double)(Math.Abs(b)) )
            {
                result = Math.Abs(b)*Math.Sqrt(1+math.sqr(a/b));
            }
            else
            {
                result = Math.Abs(a)*Math.Sqrt(1+math.sqr(b/a));
            }
            return result;
        }


    }
    public class testsparseunit
    {
        public class sparsegenerator : apobject
        {
            public int n;
            public int m;
            public int matkind;
            public int triangle;
            public double[,] bufa;
            public hqrnd.hqrndstate rs;
            public rcommstate rcs;
            public sparsegenerator()
            {
                init();
            }
            public override void init()
            {
                bufa = new double[0,0];
                rs = new hqrnd.hqrndstate();
                rcs = new rcommstate();
            }
            public override alglib.apobject make_copy()
            {
                sparsegenerator _result = new sparsegenerator();
                _result.n = n;
                _result.m = m;
                _result.matkind = matkind;
                _result.triangle = triangle;
                _result.bufa = (double[,])bufa.Clone();
                _result.rs = (hqrnd.hqrndstate)rs.make_copy();
                _result.rcs = (rcommstate)rcs.make_copy();
                return _result;
            }
        };




        public static bool testsparse(bool silent)
        {
            bool result = new bool();
            bool waserrors = new bool();
            bool basicerrors = new bool();
            bool linearerrors = new bool();
            bool basicrnderrors = new bool();
            bool level2unsymmetricerrors = new bool();
            bool level2symmetricerrors = new bool();
            bool level2triangularerrors = new bool();
            bool level3unsymmetricerrors = new bool();
            bool level3symmetricerrors = new bool();
            bool linearserrors = new bool();
            bool linearmmerrors = new bool();
            bool linearsmmerrors = new bool();
            bool getrowerrors = new bool();
            bool copyerrors = new bool();
            bool basiccopyerrors = new bool();
            bool enumerateerrors = new bool();
            bool rewriteexistingerr = new bool();
            bool skserrors = new bool();

            getrowerrors = false;
            skserrors = skstest();
            basicerrors = basicfunctest() || testgcmatrixtype();
            basicrnderrors = basicfuncrandomtest();
            linearerrors = linearfunctionstest();
            level2unsymmetricerrors = testlevel2unsymmetric();
            level2symmetricerrors = testlevel2symmetric();
            level2triangularerrors = testlevel2triangular();
            level3unsymmetricerrors = testlevel3unsymmetric();
            level3symmetricerrors = testlevel3symmetric();
            linearserrors = linearfunctionsstest();
            linearmmerrors = linearfunctionsmmtest();
            linearsmmerrors = linearfunctionssmmtest();
            copyerrors = copyfunctest(true) || testconvertsm();
            basiccopyerrors = basiccopyfunctest(true);
            enumerateerrors = enumeratetest();
            rewriteexistingerr = rewriteexistingtest();
            testgetrow(ref getrowerrors);
            
            //
            // report
            //
            waserrors = (((((((((((((((skserrors || getrowerrors) || basicerrors) || linearerrors) || basicrnderrors) || level2unsymmetricerrors) || level2symmetricerrors) || level2triangularerrors) || level3unsymmetricerrors) || level3symmetricerrors) || linearserrors) || linearmmerrors) || linearsmmerrors) || copyerrors) || basiccopyerrors) || enumerateerrors) || rewriteexistingerr;
            if( !silent )
            {
                System.Console.Write("TESTING SPARSE");
                System.Console.WriteLine();
                System.Console.Write("STORAGE FORMATS:");
                System.Console.WriteLine();
                System.Console.Write("* SKS:                                   ");
                if( !skserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("OPERATIONS:");
                System.Console.WriteLine();
                System.Console.Write("* GETROW:                                ");
                if( !getrowerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("BLAS:");
                System.Console.WriteLine();
                System.Console.Write("* LEVEL 2 GENERAL:                       ");
                if( !level2unsymmetricerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* LEVEL 2 SYMMETRIC:                     ");
                if( !level2symmetricerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* LEVEL 2 TRIANGULAR:                    ");
                if( !level2triangularerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* LEVEL 3 GENERAL:                       ");
                if( !level3unsymmetricerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("* LEVEL 3 SYMMETRIC:                     ");
                if( !level3symmetricerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("BASIC TEST:                              ");
                if( !basicerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("COPY TEST:                               ");
                if( !copyerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("BASIC_COPY TEST:                         ");
                if( !basiccopyerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("BASIC_RND TEST:                          ");
                if( !basicrnderrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("LINEAR TEST:                             ");
                if( !linearerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("LINEAR TEST FOR SYMMETRIC MATRICES:      ");
                if( !linearserrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("LINEAR MxM TEST:                         ");
                if( !linearmmerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("LINEAR MxM TEST FOR SYMMETRIC MATRICES:  ");
                if( !linearsmmerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("ENUMERATE TEST:                          ");
                if( !enumerateerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("REWRITE EXISTING TEST:                   ");
                if( !rewriteexistingerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testsparse(bool silent)
        {
            return testsparse(silent);
        }


        /*************************************************************************
        Function for testing basic SKS functional.
        Returns True on errors, False on success.

          -- ALGLIB PROJECT --
             Copyright 16.01.1014 by Bochkanov Sergey
        *************************************************************************/
        public static bool skstest()
        {
            bool result = new bool();
            sparse.sparsematrix s0 = new sparse.sparsematrix();
            sparse.sparsematrix s1 = new sparse.sparsematrix();
            sparse.sparsematrix s2 = new sparse.sparsematrix();
            sparse.sparsematrix s3 = new sparse.sparsematrix();
            sparse.sparsematrix s4 = new sparse.sparsematrix();
            sparse.sparsematrix s5 = new sparse.sparsematrix();
            sparse.sparsematrix s6 = new sparse.sparsematrix();
            int n = 0;
            int nz = 0;
            double pnz = 0;
            int i = 0;
            int j = 0;
            int t0 = 0;
            int t1 = 0;
            double[,] a = new double[0,0];
            bool[,] wasenumerated = new bool[0,0];
            int[] d = new int[0];
            int[] u = new int[0];
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            double v0 = 0;
            double v1 = 0;
            int uppercnt = 0;
            int lowercnt = 0;

            result = false;
            hqrnd.hqrndrandomize(rs);
            for(n=1; n<=20; n++)
            {
                nz = n*n-n;
                while( true )
                {
                    
                    //
                    // Generate N*N matrix where probability of non-diagonal element
                    // being non-zero is PNZ. We also generate D and U - subdiagonal
                    // and superdiagonal profile sizes.
                    //
                    if( n>1 )
                    {
                        pnz = (double)nz/(double)(n*n-n);
                    }
                    else
                    {
                        pnz = 1.0;
                    }
                    d = new int[n];
                    u = new int[n];
                    for(i=0; i<=n-1; i++)
                    {
                        d[i] = 0;
                        u[i] = 0;
                    }
                    a = new double[n, n];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( i==j || (double)(hqrnd.hqrnduniformr(rs))<=(double)(pnz) )
                            {
                                a[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                                if( j<i )
                                {
                                    d[i] = Math.Max(d[i], i-j);
                                }
                                else
                                {
                                    u[j] = Math.Max(u[j], j-i);
                                }
                            }
                            else
                            {
                                a[i,j] = 0.0;
                            }
                        }
                    }
                    uppercnt = 0;
                    lowercnt = 0;
                    for(i=0; i<=n-1; i++)
                    {
                        uppercnt = uppercnt+u[i];
                        lowercnt = lowercnt+d[i];
                    }
                    
                    //
                    // Create matrix in SKS storage format, fill with RewriteExisting() calls.
                    // Convert to several different formats, check their contents with SparseGet().
                    //
                    sparse.sparsecreatesks(n, n, d, u, s0);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (double)(a[i,j])!=(double)(0) )
                            {
                                apserv.seterrorflag(ref result, !sparse.sparserewriteexisting(s0, i, j, a[i,j]));
                            }
                        }
                    }
                    sparse.sparsecopy(s0, s1);
                    sparse.sparseconverttocrs(s1);
                    sparse.sparsecopytocrs(s0, s2);
                    sparse.sparsecopytocrsbuf(s0, s3);
                    sparse.sparsecopytohash(s0, s4);
                    sparse.sparsecopytohashbuf(s0, s5);
                    sparse.sparsecopy(s0, s6);
                    sparse.sparseconverttohash(s6);
                    apserv.seterrorflag(ref result, sparse.sparsegetnrows(s0)!=n);
                    apserv.seterrorflag(ref result, sparse.sparsegetncols(s0)!=n);
                    apserv.seterrorflag(ref result, sparse.sparsegetmatrixtype(s0)!=2);
                    apserv.seterrorflag(ref result, !sparse.sparseissks(s0));
                    apserv.seterrorflag(ref result, sparse.sparseiscrs(s0));
                    apserv.seterrorflag(ref result, sparse.sparseishash(s0));
                    apserv.seterrorflag(ref result, sparse.sparseissks(s1));
                    apserv.seterrorflag(ref result, !sparse.sparseiscrs(s1));
                    apserv.seterrorflag(ref result, sparse.sparseishash(s1));
                    for(i=0; i<=n-1; i++)
                    {
                        v1 = a[i,i];
                        v0 = sparse.sparsegetdiagonal(s0, i);
                        apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v1 = a[i,j];
                            v0 = sparse.sparseget(s0, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s1, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s2, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s3, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s4, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s5, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s6, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                        }
                    }
                    
                    //
                    // Check enumeration capabilities:
                    // * each element returned by SparseEnumerate() is returned only once
                    // * each non-zero element of A was enumerated
                    //
                    wasenumerated = new bool[n, n];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            wasenumerated[i,j] = false;
                        }
                    }
                    t0 = 0;
                    t1 = 0;
                    while( sparse.sparseenumerate(s0, ref t0, ref t1, ref i, ref j, ref v0) )
                    {
                        apserv.seterrorflag(ref result, wasenumerated[i,j]);
                        wasenumerated[i,j] = true;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (double)(a[i,j])!=(double)(0) )
                            {
                                apserv.seterrorflag(ref result, !wasenumerated[i,j]);
                            }
                        }
                    }
                    
                    //
                    // Check UpperCnt()/LowerCnt()
                    //
                    apserv.seterrorflag(ref result, sparse.sparsegetuppercount(s0)!=uppercnt);
                    apserv.seterrorflag(ref result, sparse.sparsegetlowercount(s0)!=lowercnt);
                    
                    //
                    // Check in-place transposition
                    //
                    sparse.sparsecopy(s0, s1);
                    sparse.sparsetransposesks(s1);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v0 = sparse.sparseget(s0, i, j);
                            v1 = sparse.sparseget(s1, j, i);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                        }
                    }
                    
                    //
                    // One more check - matrix is initially created in some other format
                    // (CRS or Hash) and converted to SKS later.
                    //
                    sparse.sparsecreate(n, n, 0, s0);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (double)(a[i,j])!=(double)(0) )
                            {
                                sparse.sparseset(s0, i, j, a[i,j]);
                            }
                        }
                    }
                    sparse.sparsecopy(s0, s1);
                    sparse.sparseconverttosks(s1);
                    sparse.sparsecopytosks(s0, s2);
                    sparse.sparsecopytosksbuf(s0, s3);
                    apserv.seterrorflag(ref result, !sparse.sparseissks(s1));
                    apserv.seterrorflag(ref result, sparse.sparseiscrs(s1));
                    apserv.seterrorflag(ref result, sparse.sparseishash(s1));
                    apserv.seterrorflag(ref result, !sparse.sparseissks(s2));
                    apserv.seterrorflag(ref result, sparse.sparseiscrs(s2));
                    apserv.seterrorflag(ref result, sparse.sparseishash(s2));
                    apserv.seterrorflag(ref result, !sparse.sparseissks(s3));
                    apserv.seterrorflag(ref result, sparse.sparseiscrs(s3));
                    apserv.seterrorflag(ref result, sparse.sparseishash(s3));
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            v1 = a[i,j];
                            v0 = sparse.sparseget(s1, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s2, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                            v0 = sparse.sparseget(s3, i, j);
                            apserv.seterrorflag(ref result, (double)(v0)!=(double)(v1));
                        }
                    }
                    
                    //
                    // Increase problem sparcity and try one more time. 
                    // Stop after testing NZ=0.
                    //
                    if( nz==0 )
                    {
                        break;
                    }
                    nz = nz/2;
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing basic functional

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool basicfunctest()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            int n = 0;
            int m = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            int uppercnt = 0;
            int lowercnt = 0;
            double[,] a = new double[0,0];

            n = 10;
            m = 10;
            result = false;
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=n-1; j++)
                {
                    sparse.sparsecreate(i, j, 1, s);
                    a = new double[i, j];
                    
                    //
                    // Checking for Matrix with hash table type
                    //
                    uppercnt = 0;
                    lowercnt = 0;
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            if( j1>i1 )
                            {
                                apserv.inc(ref uppercnt);
                            }
                            if( j1<i1 )
                            {
                                apserv.inc(ref lowercnt);
                            }
                            a[i1,j1] = i1+j1+(double)((i+j)*(m+n))/(double)2;
                            a[i1,j1] = a[i1,j1]+1;
                            sparse.sparseset(s, i1, j1, i1+j1+(double)((i+j)*(m+n))/(double)2);
                            sparse.sparseadd(s, i1, j1, 1);
                            if( (double)(a[i1,j1])!=(double)(sparse.sparseget(s, i1, j1)) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                    for(i1=0; i1<=Math.Min(i, j)-1; i1++)
                    {
                        if( (double)(a[i1,i1])!=(double)(sparse.sparsegetdiagonal(s, i1)) )
                        {
                            result = true;
                            return result;
                        }
                    }
                    apserv.seterrorflag(ref result, sparse.sparsegetuppercount(s)!=uppercnt);
                    apserv.seterrorflag(ref result, sparse.sparsegetlowercount(s)!=lowercnt);
                    
                    //
                    // Checking for Matrix with CRS type
                    //
                    sparse.sparseconverttocrs(s);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            if( (double)(a[i1,j1])!=(double)(sparse.sparseget(s, i1, j1)) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                    for(i1=0; i1<=Math.Min(i, j)-1; i1++)
                    {
                        if( (double)(a[i1,i1])!=(double)(sparse.sparsegetdiagonal(s, i1)) )
                        {
                            result = true;
                            return result;
                        }
                    }
                    apserv.seterrorflag(ref result, sparse.sparsegetuppercount(s)!=uppercnt);
                    apserv.seterrorflag(ref result, sparse.sparsegetlowercount(s)!=lowercnt);
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing Level 2 unsymmetric linear algebra functions.
        Additionally it tests SparseGet() for several matrix formats.
        Returns True on failure.

          -- ALGLIB PROJECT --
             Copyright 20.01.2014 by Bochkanov Sergey
        *************************************************************************/
        public static bool testlevel2unsymmetric()
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            double[] y0 = new double[0];
            double[] y1 = new double[0];
            int i = 0;
            int j = 0;
            double[,] a = new double[0,0];
            sparse.sparsematrix s0 = new sparse.sparsematrix();
            sparse.sparsematrix sa = new sparse.sparsematrix();
            double eps = 0;
            double v = 0;
            sparsegenerator g = new sparsegenerator();
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            int i_ = 0;

            eps = 10000*math.machineepsilon;
            result = false;
            hqrnd.hqrndrandomize(rs);
            
            //
            // Test linear algebra functions
            //
            for(m=1; m<=20; m++)
            {
                for(n=1; n<=20; n++)
                {
                    initgenerator(m, n, 0, 0, g);
                    while( generatenext(g, ref a, sa) )
                    {
                        
                        //
                        // Convert SA to desired storage format:
                        // * to CRS if M<>N
                        // * with 50% probability to CRS or SKS, if M=N
                        //
                        if( m!=n || (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                        {
                            sparse.sparsecopytocrs(sa, s0);
                        }
                        else
                        {
                            sparse.sparsecopytosks(sa, s0);
                        }
                        
                        //
                        // Test SparseGet() for SA and S0 against matrix returned in A
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(sa, i, j)-a[i,j]))>(double)(eps));
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(s0, i, j)-a[i,j]))>(double)(eps));
                            }
                        }
                        
                        //
                        // Test SparseMV
                        //
                        x0 = new double[n];
                        x1 = new double[n];
                        for(j=0; j<=n-1; j++)
                        {
                            x0[j] = hqrnd.hqrnduniformr(rs)-0.5;
                            x1[j] = x0[j];
                        }
                        sparse.sparsemv(s0, x0, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.len(y0)<m);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=m-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += a[i,i_]*x1[i_];
                            }
                            apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i]))>(double)(eps));
                        }
                        
                        //
                        // Test SparseMTV
                        //
                        x0 = new double[m];
                        x1 = new double[m];
                        for(j=0; j<=m-1; j++)
                        {
                            x0[j] = hqrnd.hqrnduniformr(rs)-0.5;
                            x1[j] = x0[j];
                        }
                        sparse.sparsemtv(s0, x0, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.len(y0)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(j=0; j<=n-1; j++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=m-1;i_++)
                            {
                                v += a[i_,j]*x1[i_];
                            }
                            apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[j]))>(double)(eps));
                        }
                        
                        //
                        // Test SparseMV2
                        //
                        if( m==n )
                        {
                            x0 = new double[n];
                            x1 = new double[n];
                            for(j=0; j<=n-1; j++)
                            {
                                x0[j] = hqrnd.hqrnduniformr(rs)-0.5;
                                x1[j] = x0[j];
                            }
                            sparse.sparsemv2(s0, x0, ref y0, ref y1);
                            apserv.seterrorflag(ref result, alglib.ap.len(y0)<n);
                            apserv.seterrorflag(ref result, alglib.ap.len(y1)<n);
                            if( result )
                            {
                                return result;
                            }
                            for(j=0; j<=n-1; j++)
                            {
                                v = 0.0;
                                for(i_=0; i_<=n-1;i_++)
                                {
                                    v += a[j,i_]*x1[i_];
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[j]))>(double)(eps));
                                v = 0.0;
                                for(i_=0; i_<=n-1;i_++)
                                {
                                    v += a[i_,j]*x1[i_];
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(v-y1[j]))>(double)(eps));
                            }
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing Level 3 unsymmetric linear algebra functions.
        Additionally it tests SparseGet() for several matrix formats.
        Returns True on failure.

          -- ALGLIB PROJECT --
             Copyright 20.01.2014 by Bochkanov Sergey
        *************************************************************************/
        public static bool testlevel3unsymmetric()
        {
            bool result = new bool();
            int m = 0;
            int n = 0;
            int k = 0;
            double[,] x0 = new double[0,0];
            double[,] x1 = new double[0,0];
            double[,] y0 = new double[0,0];
            double[,] y1 = new double[0,0];
            int i = 0;
            int j = 0;
            double[,] a = new double[0,0];
            sparse.sparsematrix s0 = new sparse.sparsematrix();
            sparse.sparsematrix sa = new sparse.sparsematrix();
            double eps = 0;
            double v = 0;
            sparsegenerator g = new sparsegenerator();
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            int i_ = 0;

            eps = 10000*math.machineepsilon;
            result = false;
            hqrnd.hqrndrandomize(rs);
            
            //
            // Test linear algebra functions
            //
            for(m=1; m<=20; m++)
            {
                for(n=1; n<=20; n++)
                {
                    initgenerator(m, n, 0, 0, g);
                    while( generatenext(g, ref a, sa) )
                    {
                        
                        //
                        // Choose matrix width K
                        //
                        k = 1+hqrnd.hqrnduniformi(rs, 20);
                        
                        //
                        // Convert SA to desired storage format:
                        // * to CRS if M<>N
                        // * with 50% probability to CRS or SKS, if M=N
                        //
                        if( m!=n || (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                        {
                            sparse.sparsecopytocrs(sa, s0);
                        }
                        else
                        {
                            sparse.sparsecopytosks(sa, s0);
                        }
                        
                        //
                        // Test SparseGet() for SA and S0 against matrix returned in A
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                apserv.seterrorflag(ref result, (double)(sparse.sparseget(sa, i, j))!=(double)(a[i,j]));
                                apserv.seterrorflag(ref result, (double)(sparse.sparseget(s0, i, j))!=(double)(a[i,j]));
                            }
                        }
                        
                        //
                        // Test SparseMV
                        //
                        x0 = new double[n, k];
                        x1 = new double[n, k];
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=k-1; j++)
                            {
                                x0[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                                x1[i,j] = x0[i,j];
                            }
                        }
                        sparse.sparsemm(s0, x0, k, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.rows(y0)<m);
                        apserv.seterrorflag(ref result, alglib.ap.cols(y0)<k);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=k-1; j++)
                            {
                                v = 0.0;
                                for(i_=0; i_<=n-1;i_++)
                                {
                                    v += a[i,i_]*x1[i_,j];
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i,j]))>(double)(eps));
                            }
                        }
                        
                        //
                        // Test SparseMTM
                        //
                        x0 = new double[m, k];
                        x1 = new double[m, k];
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=k-1; j++)
                            {
                                x0[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                                x1[i,j] = x0[i,j];
                            }
                        }
                        sparse.sparsemtm(s0, x0, k, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.rows(y0)<n);
                        apserv.seterrorflag(ref result, alglib.ap.cols(y0)<k);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=k-1; j++)
                            {
                                v = 0.0;
                                for(i_=0; i_<=m-1;i_++)
                                {
                                    v += a[i_,i]*x1[i_,j];
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i,j]))>(double)(eps));
                            }
                        }
                        
                        //
                        // Test SparseMM2
                        //
                        if( m==n )
                        {
                            x0 = new double[n, k];
                            x1 = new double[n, k];
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=k-1; j++)
                                {
                                    x0[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                                    x1[i,j] = x0[i,j];
                                }
                            }
                            sparse.sparsemm2(s0, x0, k, ref y0, ref y1);
                            apserv.seterrorflag(ref result, alglib.ap.rows(y0)<n);
                            apserv.seterrorflag(ref result, alglib.ap.cols(y0)<k);
                            apserv.seterrorflag(ref result, alglib.ap.rows(y1)<n);
                            apserv.seterrorflag(ref result, alglib.ap.cols(y1)<k);
                            if( result )
                            {
                                return result;
                            }
                            for(i=0; i<=n-1; i++)
                            {
                                for(j=0; j<=k-1; j++)
                                {
                                    v = 0.0;
                                    for(i_=0; i_<=n-1;i_++)
                                    {
                                        v += a[i,i_]*x1[i_,j];
                                    }
                                    apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i,j]))>(double)(eps));
                                    v = 0.0;
                                    for(i_=0; i_<=n-1;i_++)
                                    {
                                        v += a[i_,i]*x1[i_,j];
                                    }
                                    apserv.seterrorflag(ref result, (double)(Math.Abs(v-y1[i,j]))>(double)(eps));
                                }
                            }
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing Level 2 symmetric linear algebra functions.
        Additionally it tests SparseGet() for several matrix formats.
        Returns True on failure.

          -- ALGLIB PROJECT --
             Copyright 20.01.2014 by Bochkanov Sergey
        *************************************************************************/
        public static bool testlevel2symmetric()
        {
            bool result = new bool();
            int n = 0;
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            double[] y0 = new double[0];
            double[] y1 = new double[0];
            int i = 0;
            int j = 0;
            double[,] a = new double[0,0];
            sparse.sparsematrix s0 = new sparse.sparsematrix();
            sparse.sparsematrix s1 = new sparse.sparsematrix();
            sparse.sparsematrix sa = new sparse.sparsematrix();
            double eps = 0;
            double v = 0;
            double va = 0;
            double vb = 0;
            sparsegenerator g = new sparsegenerator();
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            bool isupper = new bool();
            int triangletype = 0;
            int i_ = 0;

            eps = 10000*math.machineepsilon;
            result = false;
            hqrnd.hqrndrandomize(rs);
            
            //
            // Test linear algebra functions
            //
            for(n=1; n<=20; n++)
            {
                for(triangletype=-1; triangletype<=1; triangletype++)
                {
                    isupper = (double)(hqrnd.hqrnduniformr(rs))>(double)(0.5);
                    if( triangletype<0 )
                    {
                        isupper = false;
                    }
                    if( triangletype>0 )
                    {
                        isupper = true;
                    }
                    initgenerator(n, n, 0, triangletype, g);
                    while( generatenext(g, ref a, sa) )
                    {
                        
                        //
                        // Convert SA to desired storage format:
                        // * S0 stores unmodified copy
                        // * S1 stores copy with unmodified triangle corresponding
                        //   to IsUpper and another triangle being spoiled by random
                        //   trash
                        //
                        sparse.sparsecopytohash(sa, s1);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j<i && isupper) || (j>i && !isupper) )
                                {
                                    sparse.sparseset(s1, i, j, hqrnd.hqrnduniformr(rs));
                                }
                            }
                        }
                        if( (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                        {
                            sparse.sparsecopytocrs(sa, s0);
                            sparse.sparseconverttocrs(s1);
                        }
                        else
                        {
                            sparse.sparsecopytosks(sa, s0);
                            sparse.sparseconverttosks(s1);
                        }
                        
                        //
                        // Test SparseGet() for SA and S0 against matrix returned in A
                        //
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(sa, i, j)-a[i,j]))>(double)(eps));
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(s0, i, j)-a[i,j]))>(double)(eps));
                                apserv.seterrorflag(ref result, (j<i && triangletype==1) && (double)(sparse.sparseget(s0, i, j))!=(double)(0));
                                apserv.seterrorflag(ref result, (j>i && triangletype==-1) && (double)(sparse.sparseget(s0, i, j))!=(double)(0));
                            }
                        }
                        
                        //
                        // Before we proceed with testing, update empty triangle of A
                        // with its copy from another part of the matrix.
                        //
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j<i && isupper) || (j>i && !isupper) )
                                {
                                    a[i,j] = a[j,i];
                                }
                            }
                        }
                        
                        //
                        // Test SparseSMV
                        //
                        x0 = new double[n];
                        x1 = new double[n];
                        for(j=0; j<=n-1; j++)
                        {
                            x0[j] = hqrnd.hqrnduniformr(rs)-0.5;
                            x1[j] = x0[j];
                        }
                        sparse.sparsesmv(s0, isupper, x0, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.len(y0)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += a[i,i_]*x1[i_];
                            }
                            apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i]))>(double)(eps));
                        }
                        sparse.sparsesmv(s1, isupper, x0, ref y1);
                        apserv.seterrorflag(ref result, alglib.ap.len(y1)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += a[i,i_]*x1[i_];
                            }
                            apserv.seterrorflag(ref result, (double)(Math.Abs(v-y1[i]))>(double)(eps));
                        }
                        
                        //
                        // Test SparseVSMV
                        //
                        x0 = new double[n];
                        x1 = new double[n];
                        for(j=0; j<=n-1; j++)
                        {
                            x0[j] = hqrnd.hqrnduniformr(rs)-0.5;
                            x1[j] = x0[j];
                        }
                        vb = 0.0;
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                vb = vb+x1[i]*a[i,j]*x1[j];
                            }
                        }
                        va = sparse.sparsevsmv(s0, isupper, x0);
                        apserv.seterrorflag(ref result, (double)(Math.Abs(va-vb))>(double)(eps));
                        va = sparse.sparsevsmv(s1, isupper, x0);
                        apserv.seterrorflag(ref result, (double)(Math.Abs(va-vb))>(double)(eps));
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing Level 2 symmetric linear algebra functions.
        Additionally it tests SparseGet() for several matrix formats.
        Returns True on failure.

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool testlevel3symmetric()
        {
            bool result = new bool();
            int n = 0;
            int k = 0;
            double[,] x0 = new double[0,0];
            double[,] x1 = new double[0,0];
            double[,] y0 = new double[0,0];
            double[,] y1 = new double[0,0];
            int i = 0;
            int j = 0;
            double[,] a = new double[0,0];
            sparse.sparsematrix s0 = new sparse.sparsematrix();
            sparse.sparsematrix s1 = new sparse.sparsematrix();
            sparse.sparsematrix sa = new sparse.sparsematrix();
            double eps = 0;
            double v = 0;
            sparsegenerator g = new sparsegenerator();
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            bool isupper = new bool();
            int triangletype = 0;
            int i_ = 0;

            eps = 10000*math.machineepsilon;
            result = false;
            hqrnd.hqrndrandomize(rs);
            
            //
            // Test linear algebra functions
            //
            for(n=1; n<=20; n++)
            {
                for(triangletype=-1; triangletype<=1; triangletype++)
                {
                    isupper = (double)(hqrnd.hqrnduniformr(rs))>(double)(0.5);
                    if( triangletype<0 )
                    {
                        isupper = false;
                    }
                    if( triangletype>0 )
                    {
                        isupper = true;
                    }
                    initgenerator(n, n, 0, triangletype, g);
                    while( generatenext(g, ref a, sa) )
                    {
                        
                        //
                        // Choose matrix width K
                        //
                        k = 1+hqrnd.hqrnduniformi(rs, 20);
                        
                        //
                        // Convert SA to desired storage format:
                        // * S0 stores unmodified copy
                        // * S1 stores copy with unmodified triangle corresponding
                        //   to IsUpper and another triangle being spoiled by random
                        //   trash
                        //
                        sparse.sparsecopytohash(sa, s1);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j<i && isupper) || (j>i && !isupper) )
                                {
                                    sparse.sparseset(s1, i, j, hqrnd.hqrnduniformr(rs));
                                }
                            }
                        }
                        if( (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                        {
                            sparse.sparsecopytocrs(sa, s0);
                            sparse.sparseconverttocrs(s1);
                        }
                        else
                        {
                            sparse.sparsecopytosks(sa, s0);
                            sparse.sparseconverttosks(s1);
                        }
                        
                        //
                        // Test SparseGet() for SA and S0 against matrix returned in A
                        //
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(sa, i, j)-a[i,j]))>(double)(eps));
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(s0, i, j)-a[i,j]))>(double)(eps));
                                apserv.seterrorflag(ref result, (j<i && triangletype==1) && (double)(sparse.sparseget(s0, i, j))!=(double)(0));
                                apserv.seterrorflag(ref result, (j>i && triangletype==-1) && (double)(sparse.sparseget(s0, i, j))!=(double)(0));
                            }
                        }
                        
                        //
                        // Before we proceed with testing, update empty triangle of A
                        // with its copy from another part of the matrix.
                        //
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j<i && isupper) || (j>i && !isupper) )
                                {
                                    a[i,j] = a[j,i];
                                }
                            }
                        }
                        
                        //
                        // Test SparseSMM
                        //
                        x0 = new double[n, k];
                        x1 = new double[n, k];
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=k-1; j++)
                            {
                                x0[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                                x1[i,j] = x0[i,j];
                            }
                        }
                        sparse.sparsesmm(s0, isupper, x0, k, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.rows(y0)<n);
                        apserv.seterrorflag(ref result, alglib.ap.cols(y0)<k);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=k-1; j++)
                            {
                                v = 0.0;
                                for(i_=0; i_<=n-1;i_++)
                                {
                                    v += a[i,i_]*x1[i_,j];
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i,j]))>(double)(eps));
                            }
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing Level 2 triangular linear algebra functions.
        Returns True on failure.

          -- ALGLIB PROJECT --
             Copyright 20.01.2014 by Bochkanov Sergey
        *************************************************************************/
        public static bool testlevel2triangular()
        {
            bool result = new bool();
            int n = 0;
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            double[] y0 = new double[0];
            double[] y1 = new double[0];
            double[] ey = new double[0];
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            double[,] a = new double[0,0];
            double[,] ea = new double[0,0];
            sparse.sparsematrix s0 = new sparse.sparsematrix();
            sparse.sparsematrix s1 = new sparse.sparsematrix();
            sparse.sparsematrix sa = new sparse.sparsematrix();
            double eps = 0;
            double v = 0;
            sparsegenerator g = new sparsegenerator();
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            bool isupper = new bool();
            bool isunit = new bool();
            int optype = 0;
            int triangletype = 0;
            int i_ = 0;

            eps = 10000*math.machineepsilon;
            result = false;
            hqrnd.hqrndrandomize(rs);
            
            //
            // Test sparseTRMV
            //
            for(n=1; n<=20; n++)
            {
                for(triangletype=-1; triangletype<=1; triangletype++)
                {
                    isupper = (double)(hqrnd.hqrnduniformr(rs))>(double)(0.5);
                    if( triangletype<0 )
                    {
                        isupper = false;
                    }
                    if( triangletype>0 )
                    {
                        isupper = true;
                    }
                    initgenerator(n, n, 0, triangletype, g);
                    while( generatenext(g, ref a, sa) )
                    {
                        
                        //
                        // Settings (IsUpper was already set, handle the rest)
                        //
                        isunit = (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5);
                        optype = hqrnd.hqrnduniformi(rs, 2);
                        
                        //
                        // Convert SA to desired storage format:
                        // * S0 stores unmodified copy
                        // * S1 stores copy with unmodified triangle corresponding
                        //   to IsUpper and another triangle being spoiled by random
                        //   trash
                        //
                        sparse.sparsecopytohash(sa, s1);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j<i && isupper) || (j>i && !isupper) )
                                {
                                    sparse.sparseset(s1, i, j, hqrnd.hqrnduniformr(rs));
                                }
                            }
                        }
                        if( (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                        {
                            sparse.sparsecopytocrs(sa, s0);
                            sparse.sparseconverttocrs(s1);
                        }
                        else
                        {
                            sparse.sparsecopytosks(sa, s0);
                            sparse.sparseconverttosks(s1);
                        }
                        
                        //
                        // Generate "effective A"
                        //
                        ea = new double[n, n];
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                ea[i,j] = 0;
                            }
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j>=i && isupper) || (j<=i && !isupper) )
                                {
                                    i1 = i;
                                    j1 = j;
                                    if( optype==1 )
                                    {
                                        apserv.swapi(ref i1, ref j1);
                                    }
                                    ea[i1,j1] = a[i,j];
                                    if( isunit && i1==j1 )
                                    {
                                        ea[i1,j1] = 1.0;
                                    }
                                }
                            }
                        }
                        
                        //
                        // Test SparseTRMV
                        //
                        x0 = new double[n];
                        x1 = new double[n];
                        for(j=0; j<=n-1; j++)
                        {
                            x0[j] = hqrnd.hqrnduniformr(rs)-0.5;
                            x1[j] = x0[j];
                        }
                        sparse.sparsetrmv(s0, isupper, isunit, optype, x0, ref y0);
                        apserv.seterrorflag(ref result, alglib.ap.len(y0)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += ea[i,i_]*x1[i_];
                            }
                            apserv.seterrorflag(ref result, (double)(Math.Abs(v-y0[i]))>(double)(eps));
                        }
                        sparse.sparsetrmv(s0, isupper, isunit, optype, x0, ref y1);
                        apserv.seterrorflag(ref result, alglib.ap.len(y1)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += ea[i,i_]*x1[i_];
                            }
                            apserv.seterrorflag(ref result, (double)(Math.Abs(v-y1[i]))>(double)(eps));
                        }
                    }
                }
            }
            
            //
            // Test sparseTRSV
            //
            for(n=1; n<=20; n++)
            {
                for(triangletype=-1; triangletype<=1; triangletype++)
                {
                    isupper = (double)(hqrnd.hqrnduniformr(rs))>(double)(0.5);
                    if( triangletype==-1 )
                    {
                        isupper = false;
                    }
                    if( triangletype==1 )
                    {
                        isupper = true;
                    }
                    initgenerator(n, n, 1, triangletype, g);
                    while( generatenext(g, ref a, sa) )
                    {
                        
                        //
                        // Settings (IsUpper was already set, handle the rest)
                        //
                        isunit = (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5);
                        optype = hqrnd.hqrnduniformi(rs, 2);
                        
                        //
                        // Convert SA to desired storage format:
                        // * S0 stores unmodified copy
                        // * S1 stores copy with unmodified triangle corresponding
                        //   to IsUpper and another triangle being spoiled by random
                        //   trash
                        //
                        sparse.sparsecopytohash(sa, s1);
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j<i && isupper) || (j>i && !isupper) )
                                {
                                    sparse.sparseset(s1, i, j, hqrnd.hqrnduniformr(rs));
                                }
                            }
                        }
                        if( (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                        {
                            sparse.sparsecopytocrs(sa, s0);
                            sparse.sparseconverttocrs(s1);
                        }
                        else
                        {
                            sparse.sparsecopytosks(sa, s0);
                            sparse.sparseconverttosks(s1);
                        }
                        
                        //
                        // Generate "effective A" and EY = inv(EA)*x0
                        //
                        ea = new double[n, n];
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                ea[i,j] = 0;
                            }
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (j>=i && isupper) || (j<=i && !isupper) )
                                {
                                    i1 = i;
                                    j1 = j;
                                    if( optype==1 )
                                    {
                                        apserv.swapi(ref i1, ref j1);
                                    }
                                    ea[i1,j1] = a[i,j];
                                    if( isunit && i1==j1 )
                                    {
                                        ea[i1,j1] = 1.0;
                                    }
                                }
                            }
                        }
                        ey = new double[n];
                        for(i=0; i<=n-1; i++)
                        {
                            ey[i] = hqrnd.hqrnduniformr(rs)-0.5;
                        }
                        x0 = new double[n];
                        x1 = new double[n];
                        for(i=0; i<=n-1; i++)
                        {
                            v = 0.0;
                            for(i_=0; i_<=n-1;i_++)
                            {
                                v += ea[i,i_]*ey[i_];
                            }
                            x0[i] = v;
                            x1[i] = v;
                        }
                        
                        //
                        // Test SparseTRSV
                        //
                        sparse.sparsetrsv(s0, isupper, isunit, optype, x0);
                        apserv.seterrorflag(ref result, alglib.ap.len(x0)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            apserv.seterrorflag(ref result, (double)(Math.Abs(ey[i]-x0[i]))>(double)(eps));
                        }
                        sparse.sparsetrsv(s1, isupper, isunit, optype, x1);
                        apserv.seterrorflag(ref result, alglib.ap.len(x1)<n);
                        if( result )
                        {
                            return result;
                        }
                        for(i=0; i<=n-1; i++)
                        {
                            apserv.seterrorflag(ref result, (double)(Math.Abs(ey[i]-x1[i]))>(double)(eps));
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Function for testing basic functional

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool basicfuncrandomtest()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            int n = 0;
            int m = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            double[,] a = new double[0,0];
            int mfigure = 0;
            int temp = 0;

            n = 20;
            m = 20;
            mfigure = 10;
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=n-1; j++)
                {
                    sparse.sparsecreate(i, j, 0, s);
                    a = new double[i, j];
                    
                    //
                    // Checking for Matrix with hash table type
                    //
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            temp = 2*math.randominteger(mfigure)-mfigure;
                            a[i1,j1] = temp;
                            if( math.randominteger(2)==0 )
                            {
                                sparse.sparseset(s, i1, j1, temp);
                                sparse.sparseset(s, i1, j1, temp);
                            }
                            else
                            {
                                sparse.sparseadd(s, i1, j1, temp);
                                sparse.sparseadd(s, i1, j1, 0);
                            }
                            if( (double)(a[i1,j1])!=(double)(sparse.sparseget(s, i1, j1)) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                    
                    //
                    // Nulling all elements
                    //
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            if( math.randominteger(2)==0 )
                            {
                                sparse.sparseset(s, i1, j1, 0);
                            }
                            else
                            {
                                sparse.sparseadd(s, i1, j1, -(1*sparse.sparseget(s, i1, j1)));
                            }
                        }
                    }
                    
                    //
                    // Again initialization of the matrix and check new values
                    //
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            temp = 2*math.randominteger(mfigure)-mfigure;
                            a[i1,j1] = temp;
                            if( math.randominteger(2)==0 )
                            {
                                sparse.sparseset(s, i1, j1, temp);
                            }
                            else
                            {
                                sparse.sparseadd(s, i1, j1, temp);
                            }
                            if( (double)(a[i1,j1])!=(double)(sparse.sparseget(s, i1, j1)) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                    
                    //
                    // Checking for Matrix with CRS type
                    //
                    sparse.sparseconverttocrs(s);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            if( (double)(a[i1,j1])!=(double)(sparse.sparseget(s, i1, j1)) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Function for testing multyplication matrix with vector

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool linearfunctionstest()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            int n = 0;
            int m = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            double lb = 0;
            double rb = 0;
            double[,] a = new double[0,0];
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            double[] ty = new double[0];
            double[] tyt = new double[0];
            double[] y = new double[0];
            double[] yt = new double[0];
            double[] y0 = new double[0];
            double[] yt0 = new double[0];
            double eps = 0;

            
            //
            // Accuracy
            //
            eps = 1000*math.machineepsilon;
            
            //
            // Size of the matrix (m*n)
            //
            n = 10;
            m = 10;
            
            //
            // Left and right borders, limiting matrix values
            //
            lb = -10;
            rb = 10;
            
            //
            // Test linear algebra functions for:
            // a) sparse matrix converted to CRS from Hash-Table
            // b) sparse matrix initially created as CRS
            //
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=n-1; j++)
                {
                    
                    //
                    // Prepare test problem
                    //
                    createrandom(i, j, -1, -1, -1, -1, ref a, s);
                    
                    //
                    // Initialize temporaries
                    //
                    ty = new double[i];
                    tyt = new double[j];
                    for(i1=0; i1<=i-1; i1++)
                    {
                        ty[i1] = 0;
                    }
                    for(i1=0; i1<=j-1; i1++)
                    {
                        tyt[i1] = 0;
                    }
                    x0 = new double[j];
                    x1 = new double[i];
                    for(i1=0; i1<=j-1; i1++)
                    {
                        x0[i1] = (rb-lb)*math.randomreal()+lb;
                    }
                    for(i1=0; i1<=i-1; i1++)
                    {
                        x1[i1] = (rb-lb)*math.randomreal()+lb;
                    }
                    
                    //
                    // Consider two cases: square matrix, and non-square matrix
                    //
                    if( i!=j )
                    {
                        
                        //
                        // Searching true result
                        //
                        for(i1=0; i1<=i-1; i1++)
                        {
                            for(j1=0; j1<=j-1; j1++)
                            {
                                ty[i1] = ty[i1]+a[i1,j1]*x0[j1];
                                tyt[j1] = tyt[j1]+a[i1,j1]*x1[i1];
                            }
                        }
                        
                        //
                        // Multiplication
                        //
                        sparse.sparsemv(s, x0, ref y);
                        sparse.sparsemtv(s, x1, ref yt);
                        
                        //
                        // Check for MV-result
                        //
                        for(i1=0; i1<=i-1; i1++)
                        {
                            if( (double)(Math.Abs(y[i1]-ty[i1]))>=(double)(eps) )
                            {
                                result = true;
                                return result;
                            }
                        }
                        
                        //
                        // Check for MTV-result
                        //
                        for(i1=0; i1<=j-1; i1++)
                        {
                            if( (double)(Math.Abs(yt[i1]-tyt[i1]))>=(double)(eps) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                    else
                    {
                        
                        //
                        // Searching true result
                        //
                        for(i1=0; i1<=i-1; i1++)
                        {
                            for(j1=0; j1<=j-1; j1++)
                            {
                                ty[i1] = ty[i1]+a[i1,j1]*x0[j1];
                                tyt[j1] = tyt[j1]+a[i1,j1]*x0[i1];
                            }
                        }
                        sparse.sparsemv(s, x0, ref y);
                        sparse.sparsemtv(s, x0, ref yt);
                        sparse.sparsemv2(s, x0, ref y0, ref yt0);
                        
                        //
                        // Check for MV2-result
                        //
                        for(i1=0; i1<=i-1; i1++)
                        {
                            if( (double)(Math.Abs(y0[i1]-ty[i1]))>=(double)(eps) || (double)(Math.Abs(yt0[i1]-tyt[i1]))>=(double)(eps) )
                            {
                                result = true;
                                return result;
                            }
                        }
                        
                        //
                        // Check for MV- and MTV-result by help MV2
                        //
                        for(i1=0; i1<=i-1; i1++)
                        {
                            if( (double)(Math.Abs(y0[i1]-y[i1]))>(double)(eps) || (double)(Math.Abs(yt0[i1]-yt[i1]))>(double)(eps) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Function for testing multyplication for simmetric matrix with vector

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool linearfunctionsstest()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            int m = 0;
            int i = 0;
            int i1 = 0;
            int j1 = 0;
            double lb = 0;
            double rb = 0;
            double[,] a = new double[0,0];
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            double[] ty = new double[0];
            double[] tyt = new double[0];
            double[] y = new double[0];
            double[] yt = new double[0];
            double eps = 0;

            
            //
            //Accuracy
            //
            eps = 1000*math.machineepsilon;
            
            //
            // Size of the matrix (m*m)
            //
            m = 10;
            
            //
            // Left and right borders, limiting matrix values
            //
            lb = -10;
            rb = 10;
            
            //
            // Test linear algebra functions for:
            // a) sparse matrix converted to CRS from Hash-Table
            // b) sparse matrix initially created as CRS
            //
            for(i=1; i<=m-1; i++)
            {
                
                //
                // Prepare test problem
                //
                createrandom(i, i, -1, -1, -1, -1, ref a, s);
                
                //
                // Initialize temporaries
                //
                ty = new double[i];
                tyt = new double[i];
                x0 = new double[i];
                x1 = new double[i];
                for(i1=0; i1<=i-1; i1++)
                {
                    ty[i1] = 0;
                    tyt[i1] = 0;
                    x0[i1] = (rb-lb)*math.randomreal()+lb;
                    x1[i1] = (rb-lb)*math.randomreal()+lb;
                }
                
                //
                // Searching true result for upper and lower triangles
                // of the matrix
                //
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=i1; j1<=i-1; j1++)
                    {
                        ty[i1] = ty[i1]+a[i1,j1]*x0[j1];
                        if( i1!=j1 )
                        {
                            ty[j1] = ty[j1]+a[i1,j1]*x0[i1];
                        }
                    }
                }
                for(i1=0; i1<=i-1; i1++)
                {
                    for(j1=0; j1<=i1; j1++)
                    {
                        tyt[i1] = tyt[i1]+a[i1,j1]*x1[j1];
                        if( i1!=j1 )
                        {
                            tyt[j1] = tyt[j1]+a[i1,j1]*x1[i1];
                        }
                    }
                }
                
                //
                // Multiplication
                //
                sparse.sparsesmv(s, true, x0, ref y);
                sparse.sparsesmv(s, false, x1, ref yt);
                
                //
                // Check for SMV-result
                //
                for(i1=0; i1<=i-1; i1++)
                {
                    if( (double)(Math.Abs(y[i1]-ty[i1]))>=(double)(eps) || (double)(Math.Abs(yt[i1]-tyt[i1]))>=(double)(eps) )
                    {
                        result = true;
                        return result;
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Function for testing multyplication sparse matrix with nerrow dense matrix

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool linearfunctionsmmtest()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            int n = 0;
            int m = 0;
            int kmax = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            int i1 = 0;
            int j1 = 0;
            int k1 = 0;
            double lb = 0;
            double rb = 0;
            double[,] a = new double[0,0];
            double[,] x0 = new double[0,0];
            double[,] x1 = new double[0,0];
            double[,] ty = new double[0,0];
            double[,] tyt = new double[0,0];
            double[,] y = new double[0,0];
            double[,] yt = new double[0,0];
            double[,] y0 = new double[0,0];
            double[,] yt0 = new double[0,0];
            double eps = 0;

            
            //
            // Accuracy
            //
            eps = 1000*math.machineepsilon;
            
            //
            // Size of the matrix (m*n)
            //
            n = 32;
            m = 32;
            kmax = 32;
            
            //
            // Left and right borders, limiting matrix values
            //
            lb = -10;
            rb = 10;
            
            //
            // Test linear algebra functions for:
            // a) sparse matrix converted to CRS from Hash-Table
            // b) sparse matrix initially created as CRS
            //
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=n-1; j++)
                {
                    
                    //
                    // Prepare test problem
                    //
                    createrandom(i, j, -1, -1, -1, -1, ref a, s);
                    x0 = new double[j, kmax];
                    x1 = new double[i, kmax];
                    for(i1=0; i1<=j-1; i1++)
                    {
                        for(j1=0; j1<=kmax-1; j1++)
                        {
                            x0[i1,j1] = (rb-lb)*math.randomreal()+lb;
                        }
                    }
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=kmax-1; j1++)
                        {
                            x1[i1,j1] = (rb-lb)*math.randomreal()+lb;
                        }
                    }
                    ty = new double[i, kmax];
                    tyt = new double[j, kmax];
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=kmax-1; j1++)
                        {
                            ty[i1,j1] = 0;
                        }
                    }
                    for(i1=0; i1<=j-1; i1++)
                    {
                        for(j1=0; j1<=kmax-1; j1++)
                        {
                            tyt[i1,j1] = 0;
                        }
                    }
                    if( i!=j )
                    {
                        for(i1=0; i1<=i-1; i1++)
                        {
                            for(k1=0; k1<=kmax-1; k1++)
                            {
                                for(j1=0; j1<=j-1; j1++)
                                {
                                    ty[i1,k1] = ty[i1,k1]+a[i1,j1]*x0[j1,k1];
                                    tyt[j1,k1] = tyt[j1,k1]+a[i1,j1]*x1[i1,k1];
                                }
                            }
                        }
                    }
                    else
                    {
                        for(i1=0; i1<=i-1; i1++)
                        {
                            for(k1=0; k1<=kmax-1; k1++)
                            {
                                for(j1=0; j1<=j-1; j1++)
                                {
                                    ty[i1,k1] = ty[i1,k1]+a[i1,j1]*x0[j1,k1];
                                    tyt[j1,k1] = tyt[j1,k1]+a[i1,j1]*x0[i1,k1];
                                }
                            }
                        }
                    }
                    for(k=1; k<=kmax; k++)
                    {
                        
                        //
                        // Consider two cases: square matrix, and non-square matrix
                        //
                        if( i!=j )
                        {
                            
                            //
                            // Multiplication
                            //
                            sparse.sparsemm(s, x0, k, ref y);
                            sparse.sparsemtm(s, x1, k, ref yt);
                            
                            //
                            // Check for MM-result
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=k-1; j1++)
                                {
                                    if( (double)(Math.Abs(y[i1,j1]-ty[i1,j1]))>=(double)(eps) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                            
                            //
                            // Check for MTM-result
                            //
                            for(i1=0; i1<=j-1; i1++)
                            {
                                for(j1=0; j1<=k-1; j1++)
                                {
                                    if( (double)(Math.Abs(yt[i1,j1]-tyt[i1,j1]))>=(double)(eps) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                        }
                        else
                        {
                            sparse.sparsemm(s, x0, k, ref y);
                            sparse.sparsemtm(s, x0, k, ref yt);
                            sparse.sparsemm2(s, x0, k, ref y0, ref yt0);
                            
                            //
                            // Check for MM2-result
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=k-1; j1++)
                                {
                                    if( (double)(Math.Abs(y0[i1,j1]-ty[i1,j1]))>=(double)(eps) || (double)(Math.Abs(yt0[i1,j1]-tyt[i1,j1]))>=(double)(eps) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                            
                            //
                            // Check for MV- and MTM-result by help MV2
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=k-1; j1++)
                                {
                                    if( (double)(Math.Abs(y0[i1,j1]-y[i1,j1]))>(double)(eps) || (double)(Math.Abs(yt0[i1,j1]-yt[i1,j1]))>(double)(eps) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Function for testing multyplication for simmetric sparse matrix with narrow
        dense matrix

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool linearfunctionssmmtest()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            int m = 0;
            int k = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            int k1 = 0;
            double lb = 0;
            double rb = 0;
            double[,] a = new double[0,0];
            double[,] x0 = new double[0,0];
            double[,] x1 = new double[0,0];
            double[,] ty = new double[0,0];
            double[,] tyt = new double[0,0];
            double[,] y = new double[0,0];
            double[,] yt = new double[0,0];
            double eps = 0;

            
            //
            // Accuracy
            //
            eps = 1000*math.machineepsilon;
            
            //
            // Size of the matrix (m*m)
            //
            m = 32;
            k = 32;
            
            //
            // Left and right borders, limiting matrix values
            //
            lb = -10;
            rb = 10;
            
            //
            // Test linear algebra functions for:
            // a) sparse matrix converted to CRS from Hash-Table
            // b) sparse matrix initially created as CRS
            //
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=k-1; j++)
                {
                    
                    //
                    // Prepare test problem
                    //
                    createrandom(i, i, -1, -1, -1, -1, ref a, s);
                    
                    //
                    // Initialize temporaries
                    //
                    ty = new double[i, j];
                    tyt = new double[i, j];
                    x0 = new double[i, j];
                    x1 = new double[i, j];
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            ty[i1,j1] = 0;
                            tyt[i1,j1] = 0;
                            x0[i1,j1] = (rb-lb)*math.randomreal()+lb;
                            x1[i1,j1] = (rb-lb)*math.randomreal()+lb;
                        }
                    }
                    
                    //
                    // Searching true result for upper and lower triangles
                    // of the matrix
                    //
                    for(k1=0; k1<=j-1; k1++)
                    {
                        for(i1=0; i1<=i-1; i1++)
                        {
                            for(j1=i1; j1<=i-1; j1++)
                            {
                                ty[i1,k1] = ty[i1,k1]+a[i1,j1]*x0[j1,k1];
                                if( i1!=j1 )
                                {
                                    ty[j1,k1] = ty[j1,k1]+a[i1,j1]*x0[i1,k1];
                                }
                            }
                        }
                    }
                    for(k1=0; k1<=j-1; k1++)
                    {
                        for(i1=0; i1<=i-1; i1++)
                        {
                            for(j1=0; j1<=i1; j1++)
                            {
                                tyt[i1,k1] = tyt[i1,k1]+a[i1,j1]*x1[j1,k1];
                                if( i1!=j1 )
                                {
                                    tyt[j1,k1] = tyt[j1,k1]+a[i1,j1]*x1[i1,k1];
                                }
                            }
                        }
                    }
                    
                    //
                    // Multiplication
                    //
                    sparse.sparsesmm(s, true, x0, j, ref y);
                    sparse.sparsesmm(s, false, x1, j, ref yt);
                    
                    //
                    // Check for SMM-result
                    //
                    for(k1=0; k1<=j-1; k1++)
                    {
                        for(i1=0; i1<=i-1; i1++)
                        {
                            if( (double)(Math.Abs(y[i1,k1]-ty[i1,k1]))>=(double)(eps) || (double)(Math.Abs(yt[i1,k1]-tyt[i1,k1]))>=(double)(eps) )
                            {
                                result = true;
                                return result;
                            }
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Function for basic test SparseCopy

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool basiccopyfunctest(bool silent)
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            sparse.sparsematrix ss = new sparse.sparsematrix();
            sparse.sparsematrix sss = new sparse.sparsematrix();
            int n = 0;
            int m = 0;
            int[] ner = new int[0];
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            double[,] a = new double[0,0];
            double a0 = 0;
            double a1 = 0;

            n = 30;
            m = 30;
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=n-1; j++)
                {
                    sparse.sparsecreate(i, j, 1, s);
                    a = new double[i, j];
                    ner = new int[i];
                    for(i1=0; i1<=i-1; i1++)
                    {
                        if( i1<=j-3 )
                        {
                            ner[i1] = 2;
                        }
                        else
                        {
                            if( j-3<i1 && i1<=j-2 )
                            {
                                ner[i1] = 1;
                            }
                            else
                            {
                                ner[i1] = 0;
                            }
                        }
                    }
                    sparse.sparsecreatecrs(i, j, ner, sss);
                    
                    //
                    // Checking for Matrix with hash table type
                    //
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            if( j1>i1 && j1<=i1+2 )
                            {
                                a[i1,j1] = i1+j1+1;
                                sparse.sparseset(s, i1, j1, a[i1,j1]);
                                sparse.sparseadd(s, i1, j1, 0);
                                sparse.sparseset(sss, i1, j1, a[i1,j1]);
                            }
                            else
                            {
                                a[i1,j1] = 0;
                                sparse.sparseset(s, i1, j1, a[i1,j1]);
                                sparse.sparseadd(s, i1, j1, 0);
                            }
                            
                            //
                            // Check for SparseCreate
                            //
                            sparse.sparsecopy(s, ss);
                            a0 = sparse.sparseget(s, i1, j1);
                            a1 = sparse.sparseget(ss, i1, j1);
                            if( (double)(a0)!=(double)(a1) )
                            {
                                if( !silent )
                                {
                                    System.Console.Write("BasicCopyFuncTest::Report::SparseGet");
                                    System.Console.WriteLine();
                                    System.Console.Write("S::[");
                                    System.Console.Write("{0,0:d}",i1);
                                    System.Console.Write(",");
                                    System.Console.Write("{0,0:d}",j1);
                                    System.Console.Write("]=");
                                    System.Console.Write("{0,0:F5}",a0);
                                    System.Console.WriteLine();
                                    System.Console.Write("SS::[");
                                    System.Console.Write("{0,0:d}",i1);
                                    System.Console.Write(",");
                                    System.Console.Write("{0,0:d}",j1);
                                    System.Console.Write("]=");
                                    System.Console.Write("{0,0:F5}",a1);
                                    System.Console.WriteLine();
                                    System.Console.Write("          TEST FAILED.");
                                    System.Console.WriteLine();
                                }
                                result = true;
                                return result;
                            }
                        }
                    }
                    
                    //
                    // Check for SparseCreateCRS
                    //
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            sparse.sparsecopy(sss, ss);
                            a0 = sparse.sparseget(sss, i1, j1);
                            a1 = sparse.sparseget(ss, i1, j1);
                            if( (double)(a0)!=(double)(a1) )
                            {
                                if( !silent )
                                {
                                    System.Console.Write("BasicCopyFuncTest::Report::SparseGet");
                                    System.Console.WriteLine();
                                    System.Console.Write("S::[");
                                    System.Console.Write("{0,0:d}",i1);
                                    System.Console.Write(",");
                                    System.Console.Write("{0,0:d}",j1);
                                    System.Console.Write("]=");
                                    System.Console.Write("{0,0:F5}",a0);
                                    System.Console.WriteLine();
                                    System.Console.Write("SS::[");
                                    System.Console.Write("{0,0:d}",i1);
                                    System.Console.Write(",");
                                    System.Console.Write("{0,0:d}",j1);
                                    System.Console.Write("]=");
                                    System.Console.Write("{0,0:F5}",a1);
                                    System.Console.WriteLine();
                                    System.Console.Write("          TEST FAILED.");
                                    System.Console.WriteLine();
                                }
                                result = true;
                                return result;
                            }
                        }
                    }
                    
                    //
                    // Check for Matrix with CRS type
                    //
                    sparse.sparseconverttocrs(s);
                    sparse.sparsecopy(s, ss);
                    for(i1=0; i1<=i-1; i1++)
                    {
                        for(j1=0; j1<=j-1; j1++)
                        {
                            a0 = sparse.sparseget(s, i1, j1);
                            a1 = sparse.sparseget(ss, i1, j1);
                            if( (double)(a0)!=(double)(a1) )
                            {
                                if( !silent )
                                {
                                    System.Console.Write("BasicCopyFuncTest::Report::SparseGet");
                                    System.Console.WriteLine();
                                    System.Console.Write("S::[");
                                    System.Console.Write("{0,0:d}",i1);
                                    System.Console.Write(",");
                                    System.Console.Write("{0,0:d}",j1);
                                    System.Console.Write("]=");
                                    System.Console.Write("{0,0:F5}",a0);
                                    System.Console.WriteLine();
                                    System.Console.Write("SS::[");
                                    System.Console.Write("{0,0:d}",i1);
                                    System.Console.Write(",");
                                    System.Console.Write("{0,0:d}",j1);
                                    System.Console.Write("]=");
                                    System.Console.Write("{0,0:F5}",a1);
                                    System.Console.WriteLine();
                                    System.Console.Write("          TEST FAILED.");
                                    System.Console.WriteLine();
                                }
                                result = true;
                                return result;
                            }
                        }
                    }
                }
            }
            if( !silent )
            {
                System.Console.Write("          TEST IS PASSED.");
                System.Console.WriteLine();
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Function for testing SparseCopy

          -- ALGLIB PROJECT --
             Copyright 14.10.2011 by Bochkanov Sergey
        *************************************************************************/
        public static bool copyfunctest(bool silent)
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            sparse.sparsematrix ss = new sparse.sparsematrix();
            int n = 0;
            int m = 0;
            int mtype = 0;
            int i = 0;
            int j = 0;
            int i1 = 0;
            int j1 = 0;
            double lb = 0;
            double rb = 0;
            double[,] a = new double[0,0];
            double[] x0 = new double[0];
            double[] x1 = new double[0];
            double[] ty = new double[0];
            double[] tyt = new double[0];
            double[] y = new double[0];
            double[] yt = new double[0];
            double[] y0 = new double[0];
            double[] yt0 = new double[0];
            double[] cpy = new double[0];
            double[] cpyt = new double[0];
            double[] cpy0 = new double[0];
            double[] cpyt0 = new double[0];
            double eps = 0;
            double a0 = 0;
            double a1 = 0;

            
            //
            // Accuracy
            //
            eps = 1000*math.machineepsilon;
            
            //
            // Size of the matrix (m*n)
            //
            n = 30;
            m = 30;
            
            //
            // Left and right borders, limiting matrix values
            //
            lb = -10;
            rb = 10;
            
            //
            // Test linear algebra functions for:
            // a) sparse matrix converted to CRS from Hash-Table
            // b) sparse matrix initially created as CRS
            //
            for(i=1; i<=m-1; i++)
            {
                for(j=1; j<=n-1; j++)
                {
                    for(mtype=0; mtype<=1; mtype++)
                    {
                        
                        //
                        // Prepare test problem
                        //
                        createrandom(i, j, -1, mtype, -1, -1, ref a, s);
                        sparse.sparsecopy(s, ss);
                        
                        //
                        // Initialize temporaries
                        //
                        ty = new double[i];
                        tyt = new double[j];
                        for(i1=0; i1<=i-1; i1++)
                        {
                            ty[i1] = 0;
                        }
                        for(i1=0; i1<=j-1; i1++)
                        {
                            tyt[i1] = 0;
                        }
                        x0 = new double[j];
                        x1 = new double[i];
                        for(i1=0; i1<=j-1; i1++)
                        {
                            x0[i1] = (rb-lb)*math.randomreal()+lb;
                        }
                        for(i1=0; i1<=i-1; i1++)
                        {
                            x1[i1] = (rb-lb)*math.randomreal()+lb;
                        }
                        
                        //
                        // Consider two cases: square matrix, and non-square matrix
                        //
                        if( i!=j )
                        {
                            
                            //
                            // Searching true result
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=j-1; j1++)
                                {
                                    ty[i1] = ty[i1]+a[i1,j1]*x0[j1];
                                    tyt[j1] = tyt[j1]+a[i1,j1]*x1[i1];
                                }
                            }
                            
                            //
                            // Multiplication
                            //
                            sparse.sparsemv(s, x0, ref y);
                            sparse.sparsemtv(s, x1, ref yt);
                            sparse.sparsemv(ss, x0, ref cpy);
                            sparse.sparsemtv(ss, x1, ref cpyt);
                            
                            //
                            // Check for MV-result
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                if( ((double)(Math.Abs(y[i1]-ty[i1]))>=(double)(eps) || (double)(Math.Abs(cpy[i1]-ty[i1]))>=(double)(eps)) || (double)(cpy[i1]-y[i1])!=(double)(0) )
                                {
                                    if( !silent )
                                    {
                                        System.Console.Write("CopyFuncTest::Report::RES_MV");
                                        System.Console.WriteLine();
                                        System.Console.Write("Y[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",y[i1]);
                                        System.Console.Write("; tY[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",ty[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("cpY[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpy[i1]);
                                        System.Console.Write(";");
                                        System.Console.WriteLine();
                                        System.Console.Write("          TEST FAILED.");
                                        System.Console.WriteLine();
                                    }
                                    result = true;
                                    return result;
                                }
                            }
                            
                            //
                            // Check for MTV-result
                            //
                            for(i1=0; i1<=j-1; i1++)
                            {
                                if( ((double)(Math.Abs(yt[i1]-tyt[i1]))>=(double)(eps) || (double)(Math.Abs(cpyt[i1]-tyt[i1]))>=(double)(eps)) || (double)(cpyt[i1]-yt[i1])!=(double)(0) )
                                {
                                    if( !silent )
                                    {
                                        System.Console.Write("CopyFuncTest::Report::RES_MTV");
                                        System.Console.WriteLine();
                                        System.Console.Write("Yt[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",yt[i1]);
                                        System.Console.Write("; tYt[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",tyt[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("cpYt[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpyt[i1]);
                                        System.Console.Write(";");
                                        System.Console.WriteLine();
                                        System.Console.Write("          TEST FAILED.");
                                        System.Console.WriteLine();
                                    }
                                    result = true;
                                    return result;
                                }
                            }
                            sparse.sparsecopy(s, ss);
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=j-1; j1++)
                                {
                                    a0 = sparse.sparseget(s, i1, j1);
                                    a1 = sparse.sparseget(ss, i1, j1);
                                    if( (double)(a0)!=(double)(a1) )
                                    {
                                        if( !silent )
                                        {
                                            System.Console.Write("CopyFuncTest::Report::SparseGet");
                                            System.Console.WriteLine();
                                            System.Console.Write("S::[");
                                            System.Console.Write("{0,0:d}",i1);
                                            System.Console.Write(",");
                                            System.Console.Write("{0,0:d}",j1);
                                            System.Console.Write("]=");
                                            System.Console.Write("{0,0:F5}",a0);
                                            System.Console.WriteLine();
                                            System.Console.Write("SS::[");
                                            System.Console.Write("{0,0:d}",i1);
                                            System.Console.Write(",");
                                            System.Console.Write("{0,0:d}",j1);
                                            System.Console.Write("]=");
                                            System.Console.Write("{0,0:F5}",a1);
                                            System.Console.WriteLine();
                                            System.Console.Write("          TEST FAILED.");
                                            System.Console.WriteLine();
                                        }
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                        }
                        else
                        {
                            
                            //
                            // Searching true result
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=j-1; j1++)
                                {
                                    ty[i1] = ty[i1]+a[i1,j1]*x0[j1];
                                    tyt[j1] = tyt[j1]+a[i1,j1]*x0[i1];
                                }
                            }
                            
                            //
                            // Multiplication
                            //
                            sparse.sparsemv(s, x0, ref y);
                            sparse.sparsemtv(s, x0, ref yt);
                            sparse.sparsemv2(s, x0, ref y0, ref yt0);
                            sparse.sparsemv(ss, x0, ref cpy);
                            sparse.sparsemtv(ss, x0, ref cpyt);
                            sparse.sparsemv2(ss, x0, ref cpy0, ref cpyt0);
                            
                            //
                            // Check for MV2-result
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                if( (((((double)(Math.Abs(y0[i1]-ty[i1]))>=(double)(eps) || (double)(Math.Abs(yt0[i1]-tyt[i1]))>=(double)(eps)) || (double)(Math.Abs(cpy0[i1]-ty[i1]))>=(double)(eps)) || (double)(Math.Abs(cpyt0[i1]-tyt[i1]))>=(double)(eps)) || (double)(cpy0[i1]-y0[i1])!=(double)(0)) || (double)(cpyt0[i1]-yt0[i1])!=(double)(0) )
                                {
                                    if( !silent )
                                    {
                                        System.Console.Write("CopyFuncTest::Report::RES_MV2");
                                        System.Console.WriteLine();
                                        System.Console.Write("Y0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",y0[i1]);
                                        System.Console.Write("; tY[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",ty[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("Yt0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",yt0[i1]);
                                        System.Console.Write("; tYt[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",tyt[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("cpY0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpy0[i1]);
                                        System.Console.Write(";");
                                        System.Console.WriteLine();
                                        System.Console.Write("cpYt0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpyt0[i1]);
                                        System.Console.Write(";");
                                        System.Console.WriteLine();
                                        System.Console.Write("          TEST FAILED.");
                                        System.Console.WriteLine();
                                    }
                                    result = true;
                                    return result;
                                }
                            }
                            
                            //
                            // Check for MV- and MTV-result by help MV2
                            //
                            for(i1=0; i1<=i-1; i1++)
                            {
                                if( (((double)(Math.Abs(y0[i1]-y[i1]))>(double)(eps) || (double)(Math.Abs(yt0[i1]-yt[i1]))>(double)(eps)) || (double)(Math.Abs(cpy0[i1]-cpy[i1]))>(double)(eps)) || (double)(Math.Abs(cpyt0[i1]-cpyt[i1]))>(double)(eps) )
                                {
                                    if( !silent )
                                    {
                                        System.Console.Write("CopyFuncTest::Report::RES_MV_MVT");
                                        System.Console.WriteLine();
                                        System.Console.Write("Y0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",y0[i1]);
                                        System.Console.Write("; Y[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",y[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("Yt0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",yt0[i1]);
                                        System.Console.Write("; Yt[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",yt[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("cpY0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpy0[i1]);
                                        System.Console.Write("; cpY[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpy[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("cpYt0[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpyt0[i1]);
                                        System.Console.Write("; cpYt[");
                                        System.Console.Write("{0,0:d}",i1);
                                        System.Console.Write("]=");
                                        System.Console.Write("{0,0:F5}",cpyt[i1]);
                                        System.Console.WriteLine();
                                        System.Console.Write("          TEST FAILED.");
                                        System.Console.WriteLine();
                                    }
                                    result = true;
                                    return result;
                                }
                            }
                            sparse.sparsecopy(s, ss);
                            for(i1=0; i1<=i-1; i1++)
                            {
                                for(j1=0; j1<=j-1; j1++)
                                {
                                    a0 = sparse.sparseget(s, i1, j1);
                                    a1 = sparse.sparseget(ss, i1, j1);
                                    if( (double)(a0)!=(double)(a1) )
                                    {
                                        if( !silent )
                                        {
                                            System.Console.Write("CopyFuncTest::Report::SparseGet");
                                            System.Console.WriteLine();
                                            System.Console.Write("S::[");
                                            System.Console.Write("{0,0:d}",i1);
                                            System.Console.Write(",");
                                            System.Console.Write("{0,0:d}",j1);
                                            System.Console.Write("]=");
                                            System.Console.Write("{0,0:F5}",a0);
                                            System.Console.WriteLine();
                                            System.Console.Write("SS::[");
                                            System.Console.Write("{0,0:d}",i1);
                                            System.Console.Write(",");
                                            System.Console.Write("{0,0:d}",j1);
                                            System.Console.Write("]=");
                                            System.Console.Write("{0,0:F5}",a1);
                                            System.Console.WriteLine();
                                            System.Console.Write("          TEST FAILED.");
                                            System.Console.WriteLine();
                                        }
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if( !silent )
            {
                System.Console.Write("          TEST IS PASSED.");
                System.Console.WriteLine();
            }
            result = false;
            return result;
        }


        /*************************************************************************
        This function initializes sparse matrix generator, which is used to generate
        a set of matrices with sequentially increasing sparsity.

        PARAMETERS:
            M, N        -   matrix size. If M=0, then matrix is square N*N.
                            N and M must be small enough to store N*M dense matrix.
            MatKind     -   matrix properties:
                            * 0     -   general sparse (no structure)
                            * 1     -   general sparse, but diagonal is always present and non-zero
                            * 2     -   diagonally dominant, SPD
            Triangle    -   triangle being returned:
                            * +1    -   upper triangle
                            * -1    -   lower triangle
                            *  0    -   full matrix is returned
                            
        OUTPUT PARAMETERS:
            G           -   generator
            A           -   matrix A in dense format
            SA          -   matrix A in sparse format (hash-table storage)
        *************************************************************************/
        private static void initgenerator(int m,
            int n,
            int matkind,
            int triangle,
            sparsegenerator g)
        {
            g.n = n;
            g.m = m;
            g.matkind = matkind;
            g.triangle = triangle;
            hqrnd.hqrndrandomize(g.rs);
            g.rcs.ia = new int[5+1];
            g.rcs.ra = new double[1+1];
            g.rcs.stage = -1;
        }


        private static bool generatenext(sparsegenerator g,
            ref double[,] da,
            sparse.sparsematrix sa)
        {
            bool result = new bool();
            int n = 0;
            int m = 0;
            int nz = 0;
            int nzd = 0;
            double pnz = 0;
            int i = 0;
            int j = 0;
            double v = 0;

            da = new double[0,0];

            
            //
            // Reverse communication preparations
            // I know it looks ugly, but it works the same way
            // anywhere from C++ to Python.
            //
            // This code initializes locals by:
            // * random values determined during code
            //   generation - on first subroutine call
            // * values from previous call - on subsequent calls
            //
            if( g.rcs.stage>=0 )
            {
                n = g.rcs.ia[0];
                m = g.rcs.ia[1];
                nz = g.rcs.ia[2];
                nzd = g.rcs.ia[3];
                i = g.rcs.ia[4];
                j = g.rcs.ia[5];
                pnz = g.rcs.ra[0];
                v = g.rcs.ra[1];
            }
            else
            {
                n = -983;
                m = -989;
                nz = -834;
                nzd = 900;
                i = -287;
                j = 364;
                pnz = 214;
                v = -338;
            }
            if( g.rcs.stage==0 )
            {
                goto lbl_0;
            }
            if( g.rcs.stage==1 )
            {
                goto lbl_1;
            }
            
            //
            // Routine body
            //
            n = g.n;
            if( g.m==0 )
            {
                m = n;
            }
            else
            {
                m = g.m;
            }
            alglib.ap.assert(m>0 && n>0, "GenerateNext: incorrect N/M");
            
            //
            // Generate general sparse matrix
            //
            if( g.matkind!=0 )
            {
                goto lbl_2;
            }
            nz = n*m;
        lbl_4:
            if( false )
            {
                goto lbl_5;
            }
            
            //
            // Generate dense N*N matrix where probability of element
            // being non-zero is PNZ.
            //
            pnz = (double)nz/(double)(n*m);
            g.bufa = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (double)(hqrnd.hqrnduniformr(g.rs))<=(double)(pnz) )
                    {
                        g.bufa[i,j] = hqrnd.hqrnduniformr(g.rs)-0.5;
                    }
                    else
                    {
                        g.bufa[i,j] = 0.0;
                    }
                }
            }
            
            //
            // Output matrix and RComm
            //
            da = new double[m, n];
            sparse.sparsecreate(m, n, (int)Math.Round(pnz*m*n), sa);
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i && g.triangle<=0) || (j>=i && g.triangle>=0) )
                    {
                        da[i,j] = g.bufa[i,j];
                        sparse.sparseset(sa, i, j, g.bufa[i,j]);
                    }
                    else
                    {
                        da[i,j] = 0.0;
                    }
                }
            }
            g.rcs.stage = 0;
            goto lbl_rcomm;
        lbl_0:
            
            //
            // Increase problem sparcity and try one more time. 
            // Stop after testing NZ=0.
            //
            if( nz==0 )
            {
                goto lbl_5;
            }
            nz = nz/2;
            goto lbl_4;
        lbl_5:
            result = false;
            return result;
        lbl_2:
            
            //
            // Generate general sparse matrix with non-zero diagonal
            //
            if( g.matkind!=1 )
            {
                goto lbl_6;
            }
            alglib.ap.assert(n==m, "GenerateNext: non-square matrix for MatKind=1");
            nz = n*n-n;
        lbl_8:
            if( false )
            {
                goto lbl_9;
            }
            
            //
            // Generate dense N*N matrix where probability of non-diagonal element
            // being non-zero is PNZ.
            //
            if( n>1 )
            {
                pnz = (double)nz/(double)(n*n-n);
            }
            else
            {
                pnz = 1;
            }
            g.bufa = new double[n, n];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( i==j )
                    {
                        do
                        {
                            g.bufa[i,i] = hqrnd.hqrnduniformr(g.rs)-0.5;
                        }
                        while( (double)(g.bufa[i,i])==(double)(0) );
                        g.bufa[i,i] = g.bufa[i,i]+1.5*Math.Sign(g.bufa[i,i]);
                        continue;
                    }
                    if( (double)(hqrnd.hqrnduniformr(g.rs))<=(double)(pnz) )
                    {
                        g.bufa[i,j] = hqrnd.hqrnduniformr(g.rs)-0.5;
                    }
                    else
                    {
                        g.bufa[i,j] = 0.0;
                    }
                }
            }
            
            //
            // Output matrix and RComm
            //
            da = new double[n, n];
            sparse.sparsecreate(n, n, (int)Math.Round(pnz*(n*n-n)+n), sa);
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (j<=i && g.triangle<=0) || (j>=i && g.triangle>=0) )
                    {
                        da[i,j] = g.bufa[i,j];
                        sparse.sparseset(sa, i, j, g.bufa[i,j]);
                    }
                    else
                    {
                        da[i,j] = 0.0;
                    }
                }
            }
            g.rcs.stage = 1;
            goto lbl_rcomm;
        lbl_1:
            
            //
            // Increase problem sparcity and try one more time. 
            // Stop after testing NZ=0.
            //
            if( nz==0 )
            {
                goto lbl_9;
            }
            nz = nz/2;
            goto lbl_8;
        lbl_9:
            result = false;
            return result;
        lbl_6:
            alglib.ap.assert(false);
            result = false;
            return result;
            
            //
            // Saving state
            //
        lbl_rcomm:
            result = true;
            g.rcs.ia[0] = n;
            g.rcs.ia[1] = m;
            g.rcs.ia[2] = nz;
            g.rcs.ia[3] = nzd;
            g.rcs.ia[4] = i;
            g.rcs.ia[5] = j;
            g.rcs.ra[0] = pnz;
            g.rcs.ra[1] = v;
            return result;
        }


        /*************************************************************************
        This function creates random sparse matrix with some prescribed pattern.

        INPUT PARAMETERS:
            M       -   number of rows
            N       -   number of columns
            PKind   -   sparsity pattern:
                        *-1 = pattern is chosen at random as well as P0/P1
                        * 0 = matrix with up to P0 non-zero elements at random locations
                              (however, actual number of non-zero elements can be
                              less than P0, and in fact can be zero)
                        * 1 = band matrix with P0 non-zero elements below diagonal
                              and P1 non-zero element above diagonal
                        * 2 = matrix with random number of contiguous non-zero 
                              elements in the each row
            CKind   -   creation type:
                        *-1 = CKind is chosen at random
                        * 0 = matrix is created in Hash-Table format and converted
                              to CRS representation
                        * 1 = matrix is created in CRS format

        OUTPUT PARAMETERS:
            DA      -   dense representation of A, array[M,N]
            SA      -   sparse representation of A, in CRS format

          -- ALGLIB PROJECT --
             Copyright 31.10.2011 by Bochkanov Sergey
        *************************************************************************/
        private static void createrandom(int m,
            int n,
            int pkind,
            int ckind,
            int p0,
            int p1,
            ref double[,] da,
            sparse.sparsematrix sa)
        {
            int maxpkind = 0;
            int maxckind = 0;
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            int[] c0 = new int[0];
            int[] c1 = new int[0];
            int[] rowsizes = new int[0];

            da = new double[0,0];

            maxpkind = 2;
            maxckind = 1;
            alglib.ap.assert(m>=1, "CreateRandom: incorrect parameters");
            alglib.ap.assert(n>=1, "CreateRandom: incorrect parameters");
            alglib.ap.assert(pkind>=-1 && pkind<=maxpkind, "CreateRandom: incorrect parameters");
            alglib.ap.assert(ckind>=-1 && ckind<=maxckind, "CreateRandom: incorrect parameters");
            if( pkind==-1 )
            {
                pkind = math.randominteger(maxpkind+1);
                if( pkind==0 )
                {
                    p0 = math.randominteger(m*n);
                }
                if( pkind==1 )
                {
                    p0 = math.randominteger(Math.Min(m, n));
                    p1 = math.randominteger(Math.Min(m, n));
                }
            }
            if( ckind==-1 )
            {
                ckind = math.randominteger(maxckind+1);
            }
            if( pkind==0 )
            {
                
                //
                // Matrix with elements at random locations
                //
                da = new double[m, n];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        da[i,j] = 0;
                    }
                }
                if( ckind==0 )
                {
                    
                    //
                    // Create matrix in Hash format, convert to CRS
                    //
                    sparse.sparsecreate(m, n, 1, sa);
                    for(k=0; k<=p0-1; k++)
                    {
                        i = math.randominteger(m);
                        j = math.randominteger(n);
                        v = (double)(math.randominteger(17)-8)/(double)8;
                        if( (double)(math.randomreal())>(double)(0.5) )
                        {
                            da[i,j] = v;
                            sparse.sparseset(sa, i, j, v);
                        }
                        else
                        {
                            da[i,j] = da[i,j]+v;
                            sparse.sparseadd(sa, i, j, v);
                        }
                    }
                    sparse.sparseconverttocrs(sa);
                    return;
                }
                if( ckind==1 )
                {
                    
                    //
                    // Create matrix in CRS format
                    //
                    for(k=0; k<=p0-1; k++)
                    {
                        i = math.randominteger(m);
                        j = math.randominteger(n);
                        v = (double)(math.randominteger(17)-8)/(double)8;
                        da[i,j] = v;
                    }
                    rowsizes = new int[m];
                    for(i=0; i<=m-1; i++)
                    {
                        rowsizes[i] = 0;
                        for(j=0; j<=n-1; j++)
                        {
                            if( (double)(da[i,j])!=(double)(0) )
                            {
                                rowsizes[i] = rowsizes[i]+1;
                            }
                        }
                    }
                    sparse.sparsecreatecrs(m, n, rowsizes, sa);
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (double)(da[i,j])!=(double)(0) )
                            {
                                sparse.sparseset(sa, i, j, da[i,j]);
                            }
                        }
                    }
                    return;
                }
                alglib.ap.assert(false, "CreateRandom: internal error");
            }
            if( pkind==1 )
            {
                
                //
                // Band matrix
                //
                da = new double[m, n];
                rowsizes = new int[m];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        da[i,j] = 0;
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=Math.Max(i-p0, 0); j<=Math.Min(i+p1, n-1); j++)
                    {
                        do
                        {
                            da[i,j] = (double)(math.randominteger(17)-8)/(double)8;
                        }
                        while( (double)(da[i,j])==(double)(0) );
                    }
                    rowsizes[i] = Math.Max(Math.Min(i+p1, n-1)-Math.Max(i-p0, 0)+1, 0);
                }
                if( ckind==0 )
                {
                    sparse.sparsecreate(m, n, 1, sa);
                }
                if( ckind==1 )
                {
                    sparse.sparsecreatecrs(m, n, rowsizes, sa);
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(da[i,j])!=(double)(0) )
                        {
                            sparse.sparseset(sa, i, j, da[i,j]);
                        }
                    }
                }
                sparse.sparseconverttocrs(sa);
                return;
            }
            if( pkind==2 )
            {
                
                //
                // Matrix with one contiguous sequence of non-zero elements per row
                //
                da = new double[m, n];
                rowsizes = new int[m];
                c0 = new int[m];
                c1 = new int[m];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        da[i,j] = 0;
                    }
                }
                for(i=0; i<=m-1; i++)
                {
                    c0[i] = math.randominteger(n);
                    c1[i] = c0[i]+math.randominteger(n-c0[i]+1);
                    rowsizes[i] = c1[i]-c0[i];
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=c0[i]; j<=c1[i]-1; j++)
                    {
                        do
                        {
                            da[i,j] = (double)(math.randominteger(17)-8)/(double)8;
                        }
                        while( (double)(da[i,j])==(double)(0) );
                    }
                }
                if( ckind==0 )
                {
                    sparse.sparsecreate(m, n, 1, sa);
                }
                if( ckind==1 )
                {
                    sparse.sparsecreatecrs(m, n, rowsizes, sa);
                }
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (double)(da[i,j])!=(double)(0) )
                        {
                            sparse.sparseset(sa, i, j, da[i,j]);
                        }
                    }
                }
                sparse.sparseconverttocrs(sa);
                return;
            }
        }


        /*************************************************************************
        This function does test for SparseEnumerate function.

          -- ALGLIB PROJECT --
             Copyright 14.03.2012 by Bochkanov Sergey
        *************************************************************************/
        private static bool enumeratetest()
        {
            bool result = new bool();
            sparse.sparsematrix spa = new sparse.sparsematrix();
            double[,] a = new double[0,0];
            bool[,] ta = new bool[0,0];
            int m = 0;
            int n = 0;
            double r = 0;
            double v = 0;
            int ne = 0;
            int t0 = 0;
            int t1 = 0;
            int counter = 0;
            int c = 0;
            int hashcrs = 0;
            int i = 0;
            int j = 0;

            r = 10.5;
            for(m=1; m<=30; m++)
            {
                for(n=1; n<=30; n++)
                {
                    ne = 0;
                    
                    //
                    // Create matrix with non-zero elements inside the region:
                    // 0<=I<S.M and 0<=J<S.N
                    //
                    a = new double[m, n];
                    ta = new bool[m, n];
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            a[i,j] = 0;
                            ta[i,j] = false;
                        }
                    }
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            c = math.randominteger(2);
                            if( c==0 )
                            {
                                a[i,j] = 0;
                            }
                            else
                            {
                                a[i,j] = r*(2*math.randomreal()-1);
                                
                                //
                                // Number of non-zero elements
                                //
                                ne = ne+1;
                            }
                        }
                    }
                    for(hashcrs=0; hashcrs<=1; hashcrs++)
                    {
                        sparse.sparsecreate(m, n, m*n, spa);
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                sparse.sparseset(spa, i, j, a[i,j]);
                            }
                        }
                        if( hashcrs==1 )
                        {
                            sparse.sparseconverttocrs(spa);
                        }
                        t0 = 0;
                        t1 = 0;
                        counter = 0;
                        while( sparse.sparseenumerate(spa, ref t0, ref t1, ref i, ref j, ref v) )
                        {
                            ta[i,j] = true;
                            counter = counter+1;
                            if( (double)(v)!=(double)(a[i,j]) )
                            {
                                result = true;
                                return result;
                            }
                        }
                        
                        //
                        // Check that all non-zero elements was enumerated
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( ta[i,j] && (double)(a[i,j])==(double)(0) )
                                {
                                    result = true;
                                    return result;
                                }
                            }
                        }
                        if( ne!=counter )
                        {
                            result = true;
                            return result;
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        This function does test for SparseRewriteExisting function.

          -- ALGLIB PROJECT --
             Copyright 14.03.2012 by Bochkanov Sergey
        *************************************************************************/
        private static bool rewriteexistingtest()
        {
            bool result = new bool();
            sparse.sparsematrix spa = new sparse.sparsematrix();
            double spaval = 0;
            double[,] a = new double[0,0];
            bool[,] ta = new bool[0,0];
            int m = 0;
            int n = 0;
            int c = 0;
            int ne = 0;
            int nr = 0;
            double r = 0;
            double v = 0;
            int hashcrs = 0;
            int i = 0;
            int j = 0;

            r = 20.0;
            for(m=1; m<=30; m++)
            {
                for(n=1; n<=30; n++)
                {
                    a = new double[m, n];
                    ta = new bool[m, n];
                    for(hashcrs=0; hashcrs<=1; hashcrs++)
                    {
                        v = r*(2*math.randomreal()-1);
                        
                        //
                        // Creating and filling of the matrix
                        //
                        ne = 0;
                        sparse.sparsecreate(m, n, m*n, spa);
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                c = math.randominteger(2);
                                if( c==0 )
                                {
                                    a[i,j] = 0;
                                }
                                if( c==1 )
                                {
                                    do
                                    {
                                        a[i,j] = r*(2*math.randomreal()-1);
                                    }
                                    while( (double)(a[i,j])==(double)(0) );
                                    sparse.sparseset(spa, i, j, a[i,j]);
                                    ne = ne+1;
                                }
                                ta[i,j] = false;
                            }
                        }
                        if( hashcrs==1 )
                        {
                            sparse.sparseconverttocrs(spa);
                        }
                        
                        //
                        // Rewrite some elements
                        //
                        nr = 0;
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                c = math.randominteger(2);
                                if( c==1 )
                                {
                                    ta[i,j] = sparse.sparserewriteexisting(spa, i, j, v);
                                    if( ta[i,j] )
                                    {
                                        a[i,j] = v;
                                        nr = nr+1;
                                    }
                                }
                            }
                        }
                        
                        //
                        // Now we have to be sure, that all changes had made correctly
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( ta[i,j] )
                                {
                                    spaval = sparse.sparseget(spa, i, j);
                                    nr = nr-1;
                                    if( (double)(spaval)!=(double)(v) || (double)(spaval)!=(double)(a[i,j]) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                        }
                        if( nr!=0 )
                        {
                            result = true;
                            return result;
                        }
                        
                        //
                        // Rewrite all elements
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                ta[i,j] = sparse.sparserewriteexisting(spa, i, j, v);
                                if( ta[i,j] )
                                {
                                    a[i,j] = v;
                                }
                            }
                        }
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( ta[i,j] )
                                {
                                    ne = ne-1;
                                }
                            }
                        }
                        if( ne!=0 )
                        {
                            result = true;
                            return result;
                        }
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                spaval = sparse.sparseget(spa, i, j);
                                if( ta[i,j] )
                                {
                                    if( (double)(spaval)!=(double)(v) || (double)(spaval)!=(double)(a[i,j]) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                                else
                                {
                                    if( (double)(spaval)!=(double)(0) || (double)(spaval)!=(double)(a[i,j]) )
                                    {
                                        result = true;
                                        return result;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Test  for  SparseGetRow/GetCompressedRow  function.   It  creates  random
        dense and sparse matrices;  then  get every  row from  sparse matrix  and
        compares it with every row in dense matrix.

        On failure sets error flag, on success leaves it unchanged.

          -- ALGLIB PROJECT --
             Copyright 23.07.2012 by Bochkanov Sergey
        *************************************************************************/
        private static void testgetrow(ref bool err)
        {
            sparse.sparsematrix s = new sparse.sparsematrix();
            double[,] a = new double[0,0];
            int m = 0;
            int n = 0;
            int msize = 0;
            int nsize = 0;
            int nz = 0;
            double[] vals = new double[0];
            double[] mrow = new double[0];
            int[] colidx = new int[0];
            bool[] wasreturned = new bool[0];
            int mtype = 0;
            int i = 0;
            int j = 0;

            msize = 15;
            nsize = 15;
            for(mtype=1; mtype<=2; mtype++)
            {
                for(m=1; m<=msize; m++)
                {
                    for(n=1; n<=nsize; n++)
                    {
                        
                        //
                        // Skip nonrectangular SKS matrices - not supported
                        //
                        if( mtype==2 && m!=n )
                        {
                            continue;
                        }
                        
                        //
                        // Create "reference" and sparse matrices
                        //
                        a = new double[m, n];
                        sparse.sparsecreate(m, n, 1, s);
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( math.randominteger(5)==3 )
                                {
                                    a[i,j] = 2*math.randomreal()-1;
                                    sparse.sparseset(s, i, j, a[i,j]);
                                }
                                else
                                {
                                    a[i,j] = 0;
                                }
                            }
                        }
                        
                        //
                        // Choose matrix type to test
                        //
                        if( mtype==1 )
                        {
                            sparse.sparseconverttocrs(s);
                        }
                        else
                        {
                            sparse.sparseconverttosks(s);
                        }
                        
                        //
                        // Test SparseGetRow()
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            sparse.sparsegetrow(s, i, ref mrow);
                            for(j=0; j<=n-1; j++)
                            {
                                if( (double)(mrow[j])!=(double)(a[i,j]) || (double)(mrow[j])!=(double)(sparse.sparseget(s, i, j)) )
                                {
                                    apserv.seterrorflag(ref err, true);
                                    return;
                                }
                            }
                        }
                        
                        //
                        // Test SparseGetCompressedRow()
                        //
                        wasreturned = new bool[n];
                        for(i=0; i<=m-1; i++)
                        {
                            sparse.sparsegetcompressedrow(s, i, ref colidx, ref vals, ref nz);
                            if( nz<0 || nz>n )
                            {
                                apserv.seterrorflag(ref err, true);
                                return;
                            }
                            for(j=0; j<=n-1; j++)
                            {
                                wasreturned[j] = false;
                            }
                            for(j=0; j<=nz-1; j++)
                            {
                                if( colidx[j]<0 || colidx[j]>n )
                                {
                                    apserv.seterrorflag(ref err, true);
                                    return;
                                }
                                apserv.seterrorflag(ref err, j>0 && colidx[j]<=colidx[j-1]);
                                apserv.seterrorflag(ref err, (double)(vals[j])!=(double)(a[i,colidx[j]]) || (double)(vals[j])!=(double)(sparse.sparseget(s, i, colidx[j])));
                                wasreturned[colidx[j]] = true;
                            }
                            for(j=0; j<=n-1; j++)
                            {
                                apserv.seterrorflag(ref err, (double)(a[i,j])!=(double)(0) && !wasreturned[j]);
                            }
                        }
                    }
                }
            }
        }


        /*************************************************************************
        Test for SparseConvert functions(isn't tested ConvertToCRS function). The
        function  create random  dense and sparse  matrices  in CRS  format. Then
        convert  sparse matrix  to some  format  by CONVERT_TO/COPY_TO  functions,
        then it does  some modification in matrices and compares that marices are
        identical.

        NOTE:
            Result of the function assigned to variable CopyErrors in unit test.

          -- ALGLIB PROJECT --
             Copyright 23.07.2012 by Bochkanov Sergey
        *************************************************************************/
        private static bool testconvertsm()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            sparse.sparsematrix cs = new sparse.sparsematrix();
            double[,] a = new double[0,0];
            int m = 0;
            int n = 0;
            int msize = 0;
            int nsize = 0;
            int[] ner = new int[0];
            double tmp = 0;
            int i = 0;
            int j = 0;
            int vartf = 0;

            msize = 15;
            nsize = 15;
            for(m=1; m<=msize; m++)
            {
                for(n=1; n<=nsize; n++)
                {
                    for(vartf=0; vartf<=2; vartf++)
                    {
                        a = new double[m, n];
                        ner = new int[m];
                        for(i=0; i<=m-1; i++)
                        {
                            ner[i] = 0;
                            for(j=0; j<=n-1; j++)
                            {
                                if( math.randominteger(5)==3 )
                                {
                                    ner[i] = ner[i]+1;
                                    a[i,j] = 2*math.randomreal()-1;
                                }
                                else
                                {
                                    a[i,j] = 0;
                                }
                            }
                        }
                        
                        //
                        // Create sparse matrix
                        //
                        sparse.sparsecreatecrs(m, n, ner, s);
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (double)(a[i,j])!=(double)(0) )
                                {
                                    a[i,j] = 2*math.randomreal()-1;
                                    sparse.sparseset(s, i, j, a[i,j]);
                                }
                            }
                        }
                        
                        //
                        // Set matrix type(we have to be sure that all formats
                        // converted correctly)
                        //
                        i = math.randominteger(2);
                        if( i==0 )
                        {
                            sparse.sparseconverttohash(s);
                        }
                        if( i==1 )
                        {
                            sparse.sparseconverttocrs(s);
                        }
                        
                        //
                        // Start test
                        //
                        if( vartf==0 )
                        {
                            sparse.sparseconverttohash(s);
                            sparse.sparsecopy(s, cs);
                        }
                        if( vartf==1 )
                        {
                            sparse.sparsecopytohash(s, cs);
                        }
                        if( vartf==2 )
                        {
                            sparse.sparsecopytocrs(s, cs);
                        }
                        
                        //
                        // Change some elements in row
                        //
                        if( vartf!=2 )
                        {
                            for(i=0; i<=m-1; i++)
                            {
                                tmp = 2*math.randomreal()-1;
                                j = math.randominteger(n);
                                a[i,j] = tmp;
                                sparse.sparseset(cs, i, j, tmp);
                                tmp = 2*math.randomreal()-1;
                                j = math.randominteger(n);
                                a[i,j] = a[i,j]+tmp;
                                sparse.sparseadd(cs, i, j, tmp);
                            }
                        }
                        
                        //
                        // Check that A is identical to S
                        //
                        for(i=0; i<=m-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                if( (double)(a[i,j])!=(double)(sparse.sparseget(cs, i, j)) )
                                {
                                    result = true;
                                    return result;
                                }
                            }
                        }
                    }
                }
            }
            result = false;
            return result;
        }


        /*************************************************************************
        Test for  check/get  type functions.  The function  create sparse matrix,
        converts it to desired type then check this type.

        NOTE:
            Result of the function assigned to variable BasicErrors in unit test.

          -- ALGLIB PROJECT --
             Copyright 23.07.2012 by Bochkanov Sergey
        *************************************************************************/
        private static bool testgcmatrixtype()
        {
            bool result = new bool();
            sparse.sparsematrix s = new sparse.sparsematrix();
            sparse.sparsematrix cs = new sparse.sparsematrix();
            int m = 0;
            int n = 0;
            int msize = 0;
            int nsize = 0;

            msize = 5;
            nsize = 5;
            for(m=1; m<=msize; m++)
            {
                for(n=1; n<=nsize; n++)
                {
                    sparse.sparsecreate(m, n, 1, s);
                    sparse.sparseconverttocrs(s);
                    if( (sparse.sparseishash(s) || !sparse.sparseiscrs(s)) || sparse.sparsegetmatrixtype(s)!=1 )
                    {
                        result = true;
                        return result;
                    }
                    sparse.sparseconverttohash(s);
                    if( (!sparse.sparseishash(s) || sparse.sparseiscrs(s)) || sparse.sparsegetmatrixtype(s)!=0 )
                    {
                        result = true;
                        return result;
                    }
                    sparse.sparsecopytocrs(s, cs);
                    if( (sparse.sparseishash(cs) || !sparse.sparseiscrs(cs)) || sparse.sparsegetmatrixtype(cs)!=1 )
                    {
                        result = true;
                        return result;
                    }
                    sparse.sparsecopytohash(cs, s);
                    if( (!sparse.sparseishash(s) || sparse.sparseiscrs(s)) || sparse.sparsegetmatrixtype(s)!=0 )
                    {
                        result = true;
                        return result;
                    }
                }
            }
            result = false;
            return result;
        }


    }
    public class testtrfacunit
    {
        public static bool testtrfac(bool silent)
        {
            bool result = new bool();
            double[,] ra = new double[0,0];
            double[,] ral = new double[0,0];
            double[,] rau = new double[0,0];
            complex[,] ca = new complex[0,0];
            complex[,] cal = new complex[0,0];
            complex[,] cau = new complex[0,0];
            int m = 0;
            int n = 0;
            int mx = 0;
            int maxmn = 0;
            int largemn = 0;
            int i = 0;
            int j = 0;
            complex vc = 0;
            double vr = 0;
            bool waserrors = new bool();
            bool dspderr = new bool();
            bool sspderr = new bool();
            bool hpderr = new bool();
            bool rerr = new bool();
            bool cerr = new bool();
            bool properr = new bool();
            bool dspdupderr = new bool();
            double threshold = 0;
            int i_ = 0;

            rerr = false;
            dspderr = false;
            sspderr = false;
            cerr = false;
            hpderr = false;
            properr = false;
            dspdupderr = false;
            waserrors = false;
            maxmn = 4*ablas.ablasblocksize(ra)+1;
            largemn = 256;
            threshold = 1000*math.machineepsilon*maxmn;
            
            //
            // Sparse Cholesky
            //
            sspderr = sparserealcholeskytest();
            
            //
            // Cholesky updates
            //
            testdensecholeskyupdates(ref dspdupderr);
            
            //
            // test LU:
            // * first, test on small-scale matrices
            // * then, perform several large-scale tests
            //
            for(mx=1; mx<=maxmn; mx++)
            {
                
                //
                // Initialize N/M, both are <=MX,
                // at least one of them is exactly equal to MX
                //
                n = 1+math.randominteger(mx);
                m = 1+math.randominteger(mx);
                if( (double)(math.randomreal())>(double)(0.5) )
                {
                    n = mx;
                }
                else
                {
                    m = mx;
                }
                
                //
                // First, test on zero matrix
                //
                ra = new double[m, n];
                ca = new complex[m, n];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ra[i,j] = 0;
                        ca[i,j] = 0;
                    }
                }
                testcluproblem(ca, m, n, threshold, ref cerr, ref properr);
                testrluproblem(ra, m, n, threshold, ref rerr, ref properr);
                
                //
                // Second, random matrix with moderate condition number
                //
                ra = new double[m, n];
                ca = new complex[m, n];
                for(i=0; i<=m-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ra[i,j] = 0;
                        ca[i,j] = 0;
                    }
                }
                for(i=0; i<=Math.Min(m, n)-1; i++)
                {
                    ra[i,i] = 1+10*math.randomreal();
                    ca[i,i] = 1+10*math.randomreal();
                }
                matgen.cmatrixrndorthogonalfromtheleft(ref ca, m, n);
                matgen.cmatrixrndorthogonalfromtheright(ref ca, m, n);
                matgen.rmatrixrndorthogonalfromtheleft(ref ra, m, n);
                matgen.rmatrixrndorthogonalfromtheright(ref ra, m, n);
                testcluproblem(ca, m, n, threshold, ref cerr, ref properr);
                testrluproblem(ra, m, n, threshold, ref rerr, ref properr);
            }
            for(m=largemn-1; m<=largemn+1; m++)
            {
                for(n=largemn-1; n<=largemn+1; n++)
                {
                    
                    //
                    // Random matrix with moderate condition number
                    //
                    ra = new double[m, n];
                    ca = new complex[m, n];
                    for(i=0; i<=m-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            ra[i,j] = 0;
                            ca[i,j] = 0;
                        }
                    }
                    for(i=0; i<=Math.Min(m, n)-1; i++)
                    {
                        ra[i,i] = 1+10*math.randomreal();
                        ca[i,i] = 1+10*math.randomreal();
                    }
                    matgen.cmatrixrndorthogonalfromtheleft(ref ca, m, n);
                    matgen.cmatrixrndorthogonalfromtheright(ref ca, m, n);
                    matgen.rmatrixrndorthogonalfromtheleft(ref ra, m, n);
                    matgen.rmatrixrndorthogonalfromtheright(ref ra, m, n);
                    testcluproblem(ca, m, n, threshold, ref cerr, ref properr);
                    testrluproblem(ra, m, n, threshold, ref rerr, ref properr);
                }
            }
            
            //
            // Test Cholesky
            //
            for(n=1; n<=maxmn; n++)
            {
                
                //
                // Load CA (HPD matrix with low condition number),
                //      CAL and CAU - its lower and upper triangles
                //
                matgen.hpdmatrixrndcond(n, 1+50*math.randomreal(), ref ca);
                cal = new complex[n, n];
                cau = new complex[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        cal[i,j] = i;
                        cau[i,j] = j;
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(i_=0; i_<=i;i_++)
                    {
                        cal[i,i_] = ca[i,i_];
                    }
                    for(i_=i; i_<=n-1;i_++)
                    {
                        cau[i,i_] = ca[i,i_];
                    }
                }
                
                //
                // Test HPDMatrixCholesky:
                // 1. it must leave upper (lower) part unchanged
                // 2. max(A-L*L^H) must be small
                //
                if( trfac.hpdmatrixcholesky(ref cal, n, false) )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( j>i )
                            {
                                hpderr = hpderr || cal[i,j]!=i;
                            }
                            else
                            {
                                vc = 0.0;
                                for(i_=0; i_<=j;i_++)
                                {
                                    vc += cal[i,i_]*math.conj(cal[j,i_]);
                                }
                                hpderr = hpderr || (double)(math.abscomplex(ca[i,j]-vc))>(double)(threshold);
                            }
                        }
                    }
                }
                else
                {
                    hpderr = true;
                }
                if( trfac.hpdmatrixcholesky(ref cau, n, true) )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( j<i )
                            {
                                hpderr = hpderr || cau[i,j]!=j;
                            }
                            else
                            {
                                vc = 0.0;
                                for(i_=0; i_<=i;i_++)
                                {
                                    vc += math.conj(cau[i_,i])*cau[i_,j];
                                }
                                hpderr = hpderr || (double)(math.abscomplex(ca[i,j]-vc))>(double)(threshold);
                            }
                        }
                    }
                }
                else
                {
                    hpderr = true;
                }
                
                //
                // Load RA (SPD matrix with low condition number),
                //      RAL and RAU - its lower and upper triangles
                //
                // Test SPDMatrixCholesky:
                // 1. it must leave upper (lower) part unchanged
                // 2. max(A-L*L^H) must be small
                //
                // After testing SPDMatrixCholesky() we compare results
                // returned by SparseCholeskyX() against ones returned
                // by SPDMatrixCholesky().
                //
                matgen.spdmatrixrndcond(n, 1+50*math.randomreal(), ref ra);
                ral = new double[n, n];
                rau = new double[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ral[i,j] = i;
                        rau[i,j] = j;
                    }
                }
                for(i=0; i<=n-1; i++)
                {
                    for(i_=0; i_<=i;i_++)
                    {
                        ral[i,i_] = ra[i,i_];
                    }
                    for(i_=i; i_<=n-1;i_++)
                    {
                        rau[i,i_] = ra[i,i_];
                    }
                }
                if( trfac.spdmatrixcholesky(ref ral, n, false) )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( j>i )
                            {
                                dspderr = dspderr || (double)(ral[i,j])!=(double)(i);
                            }
                            else
                            {
                                vr = 0.0;
                                for(i_=0; i_<=j;i_++)
                                {
                                    vr += ral[i,i_]*ral[j,i_];
                                }
                                dspderr = dspderr || (double)(Math.Abs(ra[i,j]-vr))>(double)(threshold);
                            }
                        }
                    }
                }
                else
                {
                    dspderr = true;
                }
                if( trfac.spdmatrixcholesky(ref rau, n, true) )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( j<i )
                            {
                                dspderr = dspderr || (double)(rau[i,j])!=(double)(j);
                            }
                            else
                            {
                                vr = 0.0;
                                for(i_=0; i_<=i;i_++)
                                {
                                    vr += rau[i_,i]*rau[i_,j];
                                }
                                dspderr = dspderr || (double)(Math.Abs(ra[i,j]-vr))>(double)(threshold);
                            }
                        }
                    }
                }
                else
                {
                    dspderr = true;
                }
                
                //
                // Check algorithms on negative definite matrices -
                // correct error code must be returned.
                //
                ra = new double[n, n];
                ca = new complex[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        ra[i,j] = 0.0;
                        ca[i,j] = 0.0;
                    }
                    ra[i,i] = 1.0;
                    ca[i,i] = 1.0;
                }
                ra[n/2,n/2] = -1.0;
                ca[n/2,n/2] = -1.0;
                apserv.seterrorflag(ref dspderr, trfac.spdmatrixcholesky(ref ra, n, (double)(math.randomreal())>(double)(0.5)));
                apserv.seterrorflag(ref hpderr, trfac.hpdmatrixcholesky(ref ca, n, (double)(math.randomreal())>(double)(0.5)));
            }
            
            //
            // report
            //
            waserrors = (((((rerr || dspderr) || sspderr) || cerr) || hpderr) || properr) || dspdupderr;
            if( !silent )
            {
                System.Console.Write("TESTING TRIANGULAR FACTORIZATIONS");
                System.Console.WriteLine();
                System.Console.Write("* REAL:                                  ");
                if( rerr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* SPD (dense)                            ");
                if( dspderr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* SPD (sparse)                           ");
                if( sspderr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* COMPLEX:                               ");
                if( cerr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* HPD:                                   ");
                if( hpderr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("* OTHER PROPERTIES:                      ");
                if( properr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                System.Console.Write("TESTING UPDATED FACTORIZATIONS");
                System.Console.WriteLine();
                System.Console.Write("* SPD (dense)                            ");
                if( dspdupderr )
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testtrfac(bool silent)
        {
            return testtrfac(silent);
        }


        /*************************************************************************
        Function for testing sparse real Cholesky.
        Returns True on errors, False on success.

          -- ALGLIB PROJECT --
             Copyright 16.01.1014 by Bochkanov Sergey
        *************************************************************************/
        public static bool sparserealcholeskytest()
        {
            bool result = new bool();
            int n = 0;
            int nz = 0;
            double pnz = 0;
            double[,] a = new double[0,0];
            double[,] a1 = new double[0,0];
            int i = 0;
            int j = 0;
            int k = 0;
            double v = 0;
            int t0 = 0;
            int t1 = 0;
            bool isupper = new bool();
            double offscale = 0;
            double tol = 0;
            sparse.sparsematrix sa = new sparse.sparsematrix();
            sparse.sparsematrix sa1 = new sparse.sparsematrix();
            sparse.sparsematrix sc = new sparse.sparsematrix();
            sparse.sparsebuffers sbuf = new sparse.sparsebuffers();
            int[] p0 = new int[0];
            int[] p1 = new int[0];
            bool[] b1 = new bool[0];
            int cfmt = 0;
            int cord = 0;
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();
            int maxfmt = 0;
            int maxord = 0;
            int minord = 0;

            result = false;
            hqrnd.hqrndrandomize(rs);
            
            //
            // Settings
            //
            maxfmt = 2;
            maxord = 0;
            minord = -2;
            offscale = 1.0E-3;
            tol = 1.0E-8;
            
            //
            // SparseCholeskyX test: performed for matrices
            // of all sizes in 1..20 and all sparcity percentages.
            //
            for(n=1; n<=20; n++)
            {
                nz = n*n-n;
                while( true )
                {
                    
                    //
                    // Generate symmetric N*N matrix where probability of non-diagonal element
                    // being non-zero is PNZ. Off-diagonal elements are set to very
                    // small values, so positive definiteness is guaranteed.
                    //
                    if( n>1 )
                    {
                        pnz = (double)nz/(double)(n*n-n);
                    }
                    else
                    {
                        pnz = 1.0;
                    }
                    a = new double[n, n];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=i; j++)
                        {
                            if( i==j )
                            {
                                a[i,i] = 1+hqrnd.hqrnduniformr(rs);
                                continue;
                            }
                            if( (double)(hqrnd.hqrnduniformr(rs))<=(double)(pnz) )
                            {
                                a[i,j] = offscale*(hqrnd.hqrnduniformr(rs)-0.5);
                                a[j,i] = a[i,j];
                            }
                            else
                            {
                                a[i,j] = 0.0;
                                a[j,i] = 0.0;
                            }
                        }
                    }
                    
                    //
                    // Problem statement
                    //
                    isupper = (double)(math.randomreal())>(double)(0.5);
                    cfmt = math.randominteger(maxfmt+1);
                    cord = math.randominteger(maxord+1-minord)+minord;
                    
                    //
                    // Create matrix is hash-based storage format, convert it to random storage format.
                    //
                    sparse.sparsecreate(n, n, 0, sa);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (j<=i && !isupper) || (j>=i && isupper) )
                            {
                                sparse.sparseset(sa, i, j, a[i,j]);
                            }
                        }
                    }
                    sparse.sparseconvertto(sa, hqrnd.hqrnduniformi(rs, maxfmt+1));
                    
                    //
                    // Perform sparse Cholesky and make several tests:
                    // * correctness of P0 and P1 (they are correct permutations and one is inverse of another)
                    // * format of SC matches CFmt
                    // * SC has correct size (exactly N*N)
                    // * check that correct triangle is returned
                    //
                    if( !trfac.sparsecholeskyx(sa, n, isupper, ref p0, ref p1, cord, math.randominteger(3), cfmt, sbuf, sc) )
                    {
                        apserv.seterrorflag(ref result, true);
                        return result;
                    }
                    apserv.seterrorflag(ref result, alglib.ap.len(p0)<n);
                    apserv.seterrorflag(ref result, alglib.ap.len(p1)<n);
                    if( result )
                    {
                        return result;
                    }
                    b1 = new bool[n];
                    for(i=0; i<=n-1; i++)
                    {
                        b1[i] = false;
                    }
                    for(i=0; i<=n-1; i++)
                    {
                        apserv.seterrorflag(ref result, p0[i]<0);
                        apserv.seterrorflag(ref result, p1[i]<0);
                        apserv.seterrorflag(ref result, p0[i]>=n);
                        apserv.seterrorflag(ref result, p1[i]>=n);
                        if( result )
                        {
                            return result;
                        }
                        apserv.seterrorflag(ref result, b1[p0[i]]);
                        b1[p0[i]] = true;
                        apserv.seterrorflag(ref result, p1[p0[i]]!=i);
                    }
                    apserv.seterrorflag(ref result, sparse.sparsegetmatrixtype(sc)!=cfmt);
                    apserv.seterrorflag(ref result, sparse.sparsegetncols(sc)!=n);
                    apserv.seterrorflag(ref result, sparse.sparsegetnrows(sc)!=n);
                    t0 = 0;
                    t1 = 0;
                    while( sparse.sparseenumerate(sc, ref t0, ref t1, ref i, ref j, ref v) )
                    {
                        apserv.seterrorflag(ref result, j<i && isupper);
                        apserv.seterrorflag(ref result, j>i && !isupper);
                    }
                    
                    //
                    // Now, test correctness of Cholesky decomposition itself.
                    // We calculate U'*U (or L*L') and check at against permutation
                    // of A given by P0.
                    //
                    // NOTE: we expect that only one triangle of SC is filled,
                    //       and another one is exactly zero.
                    //
                    if( isupper )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                v = 0.0;
                                for(k=0; k<=n-1; k++)
                                {
                                    v = v+sparse.sparseget(sc, k, j)*sparse.sparseget(sc, k, i);
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(a[p0[i],p0[j]]-v))>(double)(tol));
                            }
                        }
                    }
                    else
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                v = 0.0;
                                for(k=0; k<=n-1; k++)
                                {
                                    v = v+sparse.sparseget(sc, j, k)*sparse.sparseget(sc, i, k);
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(a[p0[i],p0[j]]-v))>(double)(tol));
                            }
                        }
                    }
                    
                    //
                    // Increase problem sparcity and try one more time. 
                    // Stop after testing NZ=0.
                    //
                    if( nz==0 )
                    {
                        break;
                    }
                    nz = nz/2;
                }
            }
            
            //
            // SparseCholeskySkyline test: performed for matrices
            // of all sizes in 1..20 and all sparcity percentages.
            //
            for(n=1; n<=20; n++)
            {
                nz = n*n-n;
                while( true )
                {
                    
                    //
                    // Choose IsUpper - main triangle to work with.
                    //
                    // Generate A - symmetric N*N matrix where probability of non-diagonal
                    // element being non-zero is PNZ. Off-diagonal elements are set to
                    // very small values, so positive definiteness is guaranteed. Full matrix
                    // is generated.
                    //
                    // Additionally, we create A1 - same as A, but one of the triangles is
                    // asymmetrically spoiled. If IsUpper is True, we spoil lower one, or vice versa.
                    //
                    isupper = (double)(math.randomreal())>(double)(0.5);
                    if( n>1 )
                    {
                        pnz = (double)nz/(double)(n*n-n);
                    }
                    else
                    {
                        pnz = 1.0;
                    }
                    a = new double[n, n];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=i; j++)
                        {
                            if( i==j )
                            {
                                a[i,i] = 1+hqrnd.hqrnduniformr(rs);
                                continue;
                            }
                            if( (double)(hqrnd.hqrnduniformr(rs))<=(double)(pnz) )
                            {
                                a[i,j] = offscale*(hqrnd.hqrnduniformr(rs)-0.5);
                                a[j,i] = a[i,j];
                            }
                            else
                            {
                                a[i,j] = 0.0;
                                a[j,i] = 0.0;
                            }
                        }
                    }
                    a1 = new double[n, n];
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (j<=i && !isupper) || (j>=i && isupper) )
                            {
                                
                                //
                                // Copy one triangle
                                //
                                a1[i,j] = a[i,j];
                            }
                            else
                            {
                                
                                //
                                // Form another sparse pattern in different triangle.
                                //
                                if( (double)(hqrnd.hqrnduniformr(rs))<=(double)(pnz) )
                                {
                                    a1[i,j] = offscale*(hqrnd.hqrnduniformr(rs)-0.5);
                                }
                                else
                                {
                                    a1[i,j] = 0.0;
                                }
                            }
                        }
                    }
                    
                    //
                    // Create copies of A and A1 in hash-based storage format.
                    // Only one triangle of A is copied, but A1 is copied fully.
                    // Convert them to SKS
                    //
                    sparse.sparsecreate(n, n, 0, sa);
                    sparse.sparsecreate(n, n, 0, sa1);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (j<=i && !isupper) || (j>=i && isupper) )
                            {
                                sparse.sparseset(sa, i, j, a[i,j]);
                            }
                            sparse.sparseset(sa1, i, j, a1[i,j]);
                        }
                    }
                    sparse.sparseconverttosks(sa);
                    sparse.sparseconverttosks(sa1);
                    
                    //
                    // Call SparseCholeskySkyline() for SA and make several tests:
                    // * check that it is still SKS
                    // * check that it has correct size (exactly N*N)
                    // * check that correct triangle is returned (and another one is unchanged - zero)
                    // * check that it is correct Cholesky decomposition.
                    //   We calculate U'*U (or L*L') and check at against A. We expect
                    //   that only one triangle of SA is filled, and another one is
                    //   exactly zero.
                    //
                    if( !trfac.sparsecholeskyskyline(sa, n, isupper) )
                    {
                        apserv.seterrorflag(ref result, true);
                        return result;
                    }
                    apserv.seterrorflag(ref result, !sparse.sparseissks(sa));
                    apserv.seterrorflag(ref result, sparse.sparsegetncols(sa)!=n);
                    apserv.seterrorflag(ref result, sparse.sparsegetnrows(sa)!=n);
                    t0 = 0;
                    t1 = 0;
                    while( sparse.sparseenumerate(sa, ref t0, ref t1, ref i, ref j, ref v) )
                    {
                        apserv.seterrorflag(ref result, j<i && isupper);
                        apserv.seterrorflag(ref result, j>i && !isupper);
                    }
                    if( isupper )
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                v = 0.0;
                                for(k=0; k<=n-1; k++)
                                {
                                    v = v+sparse.sparseget(sa, k, j)*sparse.sparseget(sa, k, i);
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(a[i,j]-v))>(double)(tol));
                            }
                        }
                    }
                    else
                    {
                        for(i=0; i<=n-1; i++)
                        {
                            for(j=0; j<=n-1; j++)
                            {
                                v = 0.0;
                                for(k=0; k<=n-1; k++)
                                {
                                    v = v+sparse.sparseget(sa, j, k)*sparse.sparseget(sa, i, k);
                                }
                                apserv.seterrorflag(ref result, (double)(Math.Abs(a[i,j]-v))>(double)(tol));
                            }
                        }
                    }
                    
                    //
                    // Call SparseCholeskySkyline() for SA1 and make several tests:
                    // * check that it is still SKS
                    // * check that it has correct size (exactly N*N)
                    // * check that factorized triangle matches contents of SA,
                    //   and another triangle was unchanged (matches contents of A1).
                    //
                    if( !trfac.sparsecholeskyskyline(sa1, n, isupper) )
                    {
                        apserv.seterrorflag(ref result, true);
                        return result;
                    }
                    apserv.seterrorflag(ref result, !sparse.sparseissks(sa1));
                    apserv.seterrorflag(ref result, sparse.sparsegetncols(sa1)!=n);
                    apserv.seterrorflag(ref result, sparse.sparsegetnrows(sa1)!=n);
                    for(i=0; i<=n-1; i++)
                    {
                        for(j=0; j<=n-1; j++)
                        {
                            if( (j<=i && !isupper) || (j>=i && isupper) )
                            {
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(sa1, i, j)-sparse.sparseget(sa, i, j)))>(double)(10*math.machineepsilon));
                            }
                            else
                            {
                                apserv.seterrorflag(ref result, (double)(Math.Abs(sparse.sparseget(sa1, i, j)-a1[i,j]))>(double)(10*math.machineepsilon));
                            }
                        }
                    }
                    
                    //
                    // Increase problem sparcity and try one more time. 
                    // Stop after testing NZ=0.
                    //
                    if( nz==0 )
                    {
                        break;
                    }
                    nz = nz/2;
                }
            }
            return result;
        }


        private static void testcluproblem(complex[,] a,
            int m,
            int n,
            double threshold,
            ref bool err,
            ref bool properr)
        {
            complex[,] ca = new complex[0,0];
            complex[,] cl = new complex[0,0];
            complex[,] cu = new complex[0,0];
            complex[,] ca2 = new complex[0,0];
            complex[] ct = new complex[0];
            int i = 0;
            int j = 0;
            int minmn = 0;
            complex v = 0;
            int[] p = new int[0];
            int i_ = 0;

            minmn = Math.Min(m, n);
            
            //
            // PLU test
            //
            ca = new complex[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    ca[i,i_] = a[i,i_];
                }
            }
            trfac.cmatrixplu(ref ca, m, n, ref p);
            for(i=0; i<=minmn-1; i++)
            {
                if( p[i]<i || p[i]>=m )
                {
                    properr = true;
                    return;
                }
            }
            cl = new complex[m, minmn];
            for(j=0; j<=minmn-1; j++)
            {
                for(i=0; i<=j-1; i++)
                {
                    cl[i,j] = 0.0;
                }
                cl[j,j] = 1.0;
                for(i=j+1; i<=m-1; i++)
                {
                    cl[i,j] = ca[i,j];
                }
            }
            cu = new complex[minmn, n];
            for(i=0; i<=minmn-1; i++)
            {
                for(j=0; j<=i-1; j++)
                {
                    cu[i,j] = 0.0;
                }
                for(j=i; j<=n-1; j++)
                {
                    cu[i,j] = ca[i,j];
                }
            }
            ca2 = new complex[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=minmn-1;i_++)
                    {
                        v += cl[i,i_]*cu[i_,j];
                    }
                    ca2[i,j] = v;
                }
            }
            ct = new complex[n];
            for(i=minmn-1; i>=0; i--)
            {
                if( i!=p[i] )
                {
                    for(i_=0; i_<=n-1;i_++)
                    {
                        ct[i_] = ca2[i,i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        ca2[i,i_] = ca2[p[i],i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        ca2[p[i],i_] = ct[i_];
                    }
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    err = err || (double)(math.abscomplex(a[i,j]-ca2[i,j]))>(double)(threshold);
                }
            }
            
            //
            // LUP test
            //
            ca = new complex[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    ca[i,i_] = a[i,i_];
                }
            }
            trfac.cmatrixlup(ref ca, m, n, ref p);
            for(i=0; i<=minmn-1; i++)
            {
                if( p[i]<i || p[i]>=n )
                {
                    properr = true;
                    return;
                }
            }
            cl = new complex[m, minmn];
            for(j=0; j<=minmn-1; j++)
            {
                for(i=0; i<=j-1; i++)
                {
                    cl[i,j] = 0.0;
                }
                for(i=j; i<=m-1; i++)
                {
                    cl[i,j] = ca[i,j];
                }
            }
            cu = new complex[minmn, n];
            for(i=0; i<=minmn-1; i++)
            {
                for(j=0; j<=i-1; j++)
                {
                    cu[i,j] = 0.0;
                }
                cu[i,i] = 1.0;
                for(j=i+1; j<=n-1; j++)
                {
                    cu[i,j] = ca[i,j];
                }
            }
            ca2 = new complex[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=minmn-1;i_++)
                    {
                        v += cl[i,i_]*cu[i_,j];
                    }
                    ca2[i,j] = v;
                }
            }
            ct = new complex[m];
            for(i=minmn-1; i>=0; i--)
            {
                if( i!=p[i] )
                {
                    for(i_=0; i_<=m-1;i_++)
                    {
                        ct[i_] = ca2[i_,i];
                    }
                    for(i_=0; i_<=m-1;i_++)
                    {
                        ca2[i_,i] = ca2[i_,p[i]];
                    }
                    for(i_=0; i_<=m-1;i_++)
                    {
                        ca2[i_,p[i]] = ct[i_];
                    }
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    err = err || (double)(math.abscomplex(a[i,j]-ca2[i,j]))>(double)(threshold);
                }
            }
        }


        private static void testrluproblem(double[,] a,
            int m,
            int n,
            double threshold,
            ref bool err,
            ref bool properr)
        {
            double[,] ca = new double[0,0];
            double[,] cl = new double[0,0];
            double[,] cu = new double[0,0];
            double[,] ca2 = new double[0,0];
            double[] ct = new double[0];
            int i = 0;
            int j = 0;
            int minmn = 0;
            double v = 0;
            int[] p = new int[0];
            int i_ = 0;

            minmn = Math.Min(m, n);
            
            //
            // PLU test
            //
            ca = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    ca[i,i_] = a[i,i_];
                }
            }
            trfac.rmatrixplu(ref ca, m, n, ref p);
            for(i=0; i<=minmn-1; i++)
            {
                if( p[i]<i || p[i]>=m )
                {
                    properr = true;
                    return;
                }
            }
            cl = new double[m, minmn];
            for(j=0; j<=minmn-1; j++)
            {
                for(i=0; i<=j-1; i++)
                {
                    cl[i,j] = 0.0;
                }
                cl[j,j] = 1.0;
                for(i=j+1; i<=m-1; i++)
                {
                    cl[i,j] = ca[i,j];
                }
            }
            cu = new double[minmn, n];
            for(i=0; i<=minmn-1; i++)
            {
                for(j=0; j<=i-1; j++)
                {
                    cu[i,j] = 0.0;
                }
                for(j=i; j<=n-1; j++)
                {
                    cu[i,j] = ca[i,j];
                }
            }
            ca2 = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=minmn-1;i_++)
                    {
                        v += cl[i,i_]*cu[i_,j];
                    }
                    ca2[i,j] = v;
                }
            }
            ct = new double[n];
            for(i=minmn-1; i>=0; i--)
            {
                if( i!=p[i] )
                {
                    for(i_=0; i_<=n-1;i_++)
                    {
                        ct[i_] = ca2[i,i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        ca2[i,i_] = ca2[p[i],i_];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        ca2[p[i],i_] = ct[i_];
                    }
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    err = err || (double)(Math.Abs(a[i,j]-ca2[i,j]))>(double)(threshold);
                }
            }
            
            //
            // LUP test
            //
            ca = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(i_=0; i_<=n-1;i_++)
                {
                    ca[i,i_] = a[i,i_];
                }
            }
            trfac.rmatrixlup(ref ca, m, n, ref p);
            for(i=0; i<=minmn-1; i++)
            {
                if( p[i]<i || p[i]>=n )
                {
                    properr = true;
                    return;
                }
            }
            cl = new double[m, minmn];
            for(j=0; j<=minmn-1; j++)
            {
                for(i=0; i<=j-1; i++)
                {
                    cl[i,j] = 0.0;
                }
                for(i=j; i<=m-1; i++)
                {
                    cl[i,j] = ca[i,j];
                }
            }
            cu = new double[minmn, n];
            for(i=0; i<=minmn-1; i++)
            {
                for(j=0; j<=i-1; j++)
                {
                    cu[i,j] = 0.0;
                }
                cu[i,i] = 1.0;
                for(j=i+1; j<=n-1; j++)
                {
                    cu[i,j] = ca[i,j];
                }
            }
            ca2 = new double[m, n];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    v = 0.0;
                    for(i_=0; i_<=minmn-1;i_++)
                    {
                        v += cl[i,i_]*cu[i_,j];
                    }
                    ca2[i,j] = v;
                }
            }
            ct = new double[m];
            for(i=minmn-1; i>=0; i--)
            {
                if( i!=p[i] )
                {
                    for(i_=0; i_<=m-1;i_++)
                    {
                        ct[i_] = ca2[i_,i];
                    }
                    for(i_=0; i_<=m-1;i_++)
                    {
                        ca2[i_,i] = ca2[i_,p[i]];
                    }
                    for(i_=0; i_<=m-1;i_++)
                    {
                        ca2[i_,p[i]] = ct[i_];
                    }
                }
            }
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    err = err || (double)(Math.Abs(a[i,j]-ca2[i,j]))>(double)(threshold);
                }
            }
        }


        /*************************************************************************
        Function for testing dense Cholesky updates
        Sets error flag to True on errors, does not change it on success.

          -- ALGLIB PROJECT --
             Copyright 16.01.1014 by Bochkanov Sergey
        *************************************************************************/
        private static void testdensecholeskyupdates(ref bool spdupderrorflag)
        {
            int n = 0;
            double pfix = 0;
            double[,] a0 = new double[0,0];
            double[,] a1 = new double[0,0];
            double[] u = new double[0];
            bool[] fix = new bool[0];
            int i = 0;
            int j = 0;
            bool isupper = new bool();
            double tol = 0;
            double[] bufr = new double[0];
            hqrnd.hqrndstate rs = new hqrnd.hqrndstate();

            hqrnd.hqrndrandomize(rs);
            
            //
            // Settings
            //
            tol = 1.0E-8;
            
            //
            // Test rank-1 updates
            //
            // For each matrix size in 1..30 select sparse update vector with probability of element
            // being non-zero equal to 1/2.
            //
            for(n=1; n<=30; n++)
            {
                
                //
                // Generate two matrices A0=A1, fill one triangle with SPD matrix,
                // another one with trash. Prepare vector U.
                //
                isupper = (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5);
                matgen.spdmatrixrndcond(n, 1.0E4, ref a0);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i && isupper) || (j>i && !isupper) )
                        {
                            a0[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                        }
                    }
                }
                a1 = new double[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a1[i,j] = a0[i,j];
                    }
                }
                u = new double[n];
                for(i=0; i<=n-1; i++)
                {
                    if( (double)(hqrnd.hqrnduniformr(rs))<=(double)(0.5) )
                    {
                        u[i] = hqrnd.hqrnduniformr(rs)-0.5;
                    }
                    else
                    {
                        u[i] = 0;
                    }
                }
                
                //
                // Factorize and compare:
                // * A0 is factorized as follows: first with full Cholesky, then
                //   we call SPDMatrixCholeskyUpdateAdd1
                // * A1 is transformed explicitly before factorization with full Cholesky
                //
                // We randomly test either SPDMatrixCholeskyUpdateFix() or its
                // buffered version, SPDMatrixCholeskyUpdateFixBuf()
                //
                apserv.seterrorflag(ref spdupderrorflag, !trfac.spdmatrixcholesky(ref a0, n, isupper));
                if( spdupderrorflag )
                {
                    return;
                }
                if( (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                {
                    trfac.spdmatrixcholeskyupdateadd1(a0, n, isupper, u);
                }
                else
                {
                    trfac.spdmatrixcholeskyupdateadd1buf(a0, n, isupper, u, ref bufr);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i && isupper) || (j<=i && !isupper) )
                        {
                            a1[i,j] = a1[i,j]+u[i]*u[j];
                        }
                    }
                }
                apserv.seterrorflag(ref spdupderrorflag, !trfac.spdmatrixcholesky(ref a1, n, isupper));
                if( spdupderrorflag )
                {
                    return;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        apserv.seterrorflag(ref spdupderrorflag, (double)(Math.Abs(a0[i,j]-a1[i,j]))>(double)(tol));
                    }
                }
            }
            
            //
            // Test variable fixing functions.
            //
            // For each matrix size in 1..30 select PFix - probability of each variable being fixed,
            // and perform test.
            //
            for(n=1; n<=30; n++)
            {
                
                //
                // Generate two matrices A0=A1, fill one triangle with SPD matrix,
                // another one with trash. Prepare vector Fix.
                //
                pfix = (double)hqrnd.hqrnduniformi(rs, n+1)/(double)n;
                isupper = (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5);
                matgen.spdmatrixrndcond(n, 1.0E4, ref a0);
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j<i && isupper) || (j>i && !isupper) )
                        {
                            a0[i,j] = hqrnd.hqrnduniformr(rs)-0.5;
                        }
                    }
                }
                a1 = new double[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        a1[i,j] = a0[i,j];
                    }
                }
                fix = new bool[n];
                for(i=0; i<=n-1; i++)
                {
                    fix[i] = (double)(hqrnd.hqrnduniformr(rs))<=(double)(pfix);
                }
                
                //
                // Factorize and compare:
                // * A0 is factorized as follows: first with full Cholesky, then
                //   variables are fixed with SPDMatrixCholeskyUpdateFix
                // * A1 is fixed explicitly before factorization with full Cholesky
                //
                // We randomly test either SPDMatrixCholeskyUpdateFix() or its
                // buffered version, SPDMatrixCholeskyUpdateFixBuf()
                //
                apserv.seterrorflag(ref spdupderrorflag, !trfac.spdmatrixcholesky(ref a0, n, isupper));
                if( spdupderrorflag )
                {
                    return;
                }
                if( (double)(hqrnd.hqrnduniformr(rs))<(double)(0.5) )
                {
                    trfac.spdmatrixcholeskyupdatefixbuf(a0, n, isupper, fix, ref bufr);
                }
                else
                {
                    trfac.spdmatrixcholeskyupdatefix(a0, n, isupper, fix);
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( (j>=i && isupper) || (j<=i && !isupper) )
                        {
                            if( fix[i] || fix[j] )
                            {
                                if( i==j )
                                {
                                    a1[i,j] = 1;
                                }
                                else
                                {
                                    a1[i,j] = 0;
                                }
                            }
                        }
                    }
                }
                apserv.seterrorflag(ref spdupderrorflag, !trfac.spdmatrixcholesky(ref a1, n, isupper));
                if( spdupderrorflag )
                {
                    return;
                }
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        apserv.seterrorflag(ref spdupderrorflag, (double)(Math.Abs(a0[i,j]-a1[i,j]))>(double)(tol));
                    }
                }
            }
        }


    }
    public class testtrlinsolveunit
    {
        /*************************************************************************
        Main unittest subroutine
        *************************************************************************/
        public static bool testtrlinsolve(bool silent)
        {
            bool result = new bool();
            int maxmn = 0;
            int passcount = 0;
            double threshold = 0;
            double[,] aeffective = new double[0,0];
            double[,] aparam = new double[0,0];
            double[] xe = new double[0];
            double[] b = new double[0];
            int n = 0;
            int pass = 0;
            int i = 0;
            int j = 0;
            int cnts = 0;
            int cntu = 0;
            int cntt = 0;
            int cntm = 0;
            bool waserrors = new bool();
            bool isupper = new bool();
            bool istrans = new bool();
            bool isunit = new bool();
            double v = 0;
            double s = 0;
            int i_ = 0;

            waserrors = false;
            maxmn = 15;
            passcount = 15;
            threshold = 1000*math.machineepsilon;
            
            //
            // Different problems
            //
            for(n=1; n<=maxmn; n++)
            {
                aeffective = new double[n-1+1, n-1+1];
                aparam = new double[n-1+1, n-1+1];
                xe = new double[n-1+1];
                b = new double[n-1+1];
                for(pass=1; pass<=passcount; pass++)
                {
                    for(cnts=0; cnts<=1; cnts++)
                    {
                        for(cntu=0; cntu<=1; cntu++)
                        {
                            for(cntt=0; cntt<=1; cntt++)
                            {
                                for(cntm=0; cntm<=2; cntm++)
                                {
                                    isupper = cnts==0;
                                    isunit = cntu==0;
                                    istrans = cntt==0;
                                    
                                    //
                                    // Skip meaningless combinations of parameters:
                                    // (matrix is singular) AND (matrix is unit diagonal)
                                    //
                                    if( cntm==2 && isunit )
                                    {
                                        continue;
                                    }
                                    
                                    //
                                    // Clear matrices
                                    //
                                    for(i=0; i<=n-1; i++)
                                    {
                                        for(j=0; j<=n-1; j++)
                                        {
                                            aeffective[i,j] = 0;
                                            aparam[i,j] = 0;
                                        }
                                    }
                                    
                                    //
                                    // Prepare matrices
                                    //
                                    if( isupper )
                                    {
                                        for(i=0; i<=n-1; i++)
                                        {
                                            for(j=i; j<=n-1; j++)
                                            {
                                                aeffective[i,j] = 0.9*(2*math.randomreal()-1);
                                                aparam[i,j] = aeffective[i,j];
                                            }
                                            aeffective[i,i] = (2*math.randominteger(2)-1)*(0.8+math.randomreal());
                                            aparam[i,i] = aeffective[i,i];
                                        }
                                    }
                                    else
                                    {
                                        for(i=0; i<=n-1; i++)
                                        {
                                            for(j=0; j<=i; j++)
                                            {
                                                aeffective[i,j] = 0.9*(2*math.randomreal()-1);
                                                aparam[i,j] = aeffective[i,j];
                                            }
                                            aeffective[i,i] = (2*math.randominteger(2)-1)*(0.8+math.randomreal());
                                            aparam[i,i] = aeffective[i,i];
                                        }
                                    }
                                    if( isunit )
                                    {
                                        for(i=0; i<=n-1; i++)
                                        {
                                            aeffective[i,i] = 1;
                                            aparam[i,i] = 0;
                                        }
                                    }
                                    if( istrans )
                                    {
                                        if( isupper )
                                        {
                                            for(i=0; i<=n-1; i++)
                                            {
                                                for(j=i+1; j<=n-1; j++)
                                                {
                                                    aeffective[j,i] = aeffective[i,j];
                                                    aeffective[i,j] = 0;
                                                }
                                            }
                                        }
                                        else
                                        {
                                            for(i=0; i<=n-1; i++)
                                            {
                                                for(j=i+1; j<=n-1; j++)
                                                {
                                                    aeffective[i,j] = aeffective[j,i];
                                                    aeffective[j,i] = 0;
                                                }
                                            }
                                        }
                                    }
                                    
                                    //
                                    // Prepare task, solve, compare
                                    //
                                    for(i=0; i<=n-1; i++)
                                    {
                                        xe[i] = 2*math.randomreal()-1;
                                    }
                                    for(i=0; i<=n-1; i++)
                                    {
                                        v = 0.0;
                                        for(i_=0; i_<=n-1;i_++)
                                        {
                                            v += aeffective[i,i_]*xe[i_];
                                        }
                                        b[i] = v;
                                    }
                                    trlinsolve.rmatrixtrsafesolve(aparam, n, ref b, ref s, isupper, istrans, isunit);
                                    for(i_=0; i_<=n-1;i_++)
                                    {
                                        xe[i_] = s*xe[i_];
                                    }
                                    for(i_=0; i_<=n-1;i_++)
                                    {
                                        xe[i_] = xe[i_] - b[i_];
                                    }
                                    v = 0.0;
                                    for(i_=0; i_<=n-1;i_++)
                                    {
                                        v += xe[i_]*xe[i_];
                                    }
                                    v = Math.Sqrt(v);
                                    waserrors = waserrors || (double)(v)>(double)(threshold);
                                }
                            }
                        }
                    }
                }
            }
            
            //
            // report
            //
            if( !silent )
            {
                System.Console.Write("TESTING RMatrixTRSafeSolve");
                System.Console.WriteLine();
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testtrlinsolve(bool silent)
        {
            return testtrlinsolve(silent);
        }


    }
    public class testsafesolveunit
    {
        /*************************************************************************
        Main unittest subroutine
        *************************************************************************/
        public static bool testsafesolve(bool silent)
        {
            bool result = new bool();
            int maxmn = 0;
            double threshold = 0;
            bool rerrors = new bool();
            bool cerrors = new bool();
            bool waserrors = new bool();
            bool isupper = new bool();
            int trans = 0;
            bool isunit = new bool();
            double scalea = 0;
            double growth = 0;
            int i = 0;
            int j = 0;
            int n = 0;
            int j1 = 0;
            int j2 = 0;
            complex cv = 0;
            complex[,] ca = new complex[0,0];
            complex[,] cea = new complex[0,0];
            complex[,] ctmpa = new complex[0,0];
            complex[] cxs = new complex[0];
            complex[] cxe = new complex[0];
            double rv = 0;
            double[,] ra = new double[0,0];
            double[,] rea = new double[0,0];
            double[,] rtmpa = new double[0,0];
            double[] rxs = new double[0];
            double[] rxe = new double[0];
            int i_ = 0;

            maxmn = 30;
            threshold = 100000*math.machineepsilon;
            rerrors = false;
            cerrors = false;
            waserrors = false;
            
            //
            // Different problems: general tests
            //
            for(n=1; n<=maxmn; n++)
            {
                
                //
                // test complex solver with well-conditioned matrix:
                // 1. generate A: fill off-diagonal elements with small values,
                //    diagonal elements are filled with larger values
                // 2. generate 'effective' A
                // 3. prepare task (exact X is stored in CXE, right part - in CXS),
                //    solve and compare CXS and CXE
                //
                isupper = (double)(math.randomreal())>(double)(0.5);
                trans = math.randominteger(3);
                isunit = (double)(math.randomreal())>(double)(0.5);
                scalea = math.randomreal()+0.5;
                ca = new complex[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            ca[i,j].x = (2*math.randominteger(2)-1)*(5+math.randomreal());
                            ca[i,j].y = (2*math.randominteger(2)-1)*(5+math.randomreal());
                        }
                        else
                        {
                            ca[i,j].x = 0.2*math.randomreal()-0.1;
                            ca[i,j].y = 0.2*math.randomreal()-0.1;
                        }
                    }
                }
                cmatrixmakeacopy(ca, n, n, ref ctmpa);
                for(i=0; i<=n-1; i++)
                {
                    if( isupper )
                    {
                        j1 = 0;
                        j2 = i-1;
                    }
                    else
                    {
                        j1 = i+1;
                        j2 = n-1;
                    }
                    for(j=j1; j<=j2; j++)
                    {
                        ctmpa[i,j] = 0;
                    }
                    if( isunit )
                    {
                        ctmpa[i,i] = 1;
                    }
                }
                cea = new complex[n, n];
                for(i=0; i<=n-1; i++)
                {
                    if( trans==0 )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            cea[i,i_] = scalea*ctmpa[i,i_];
                        }
                    }
                    if( trans==1 )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            cea[i_,i] = scalea*ctmpa[i,i_];
                        }
                    }
                    if( trans==2 )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            cea[i_,i] = scalea*math.conj(ctmpa[i,i_]);
                        }
                    }
                }
                cxe = new complex[n];
                for(i=0; i<=n-1; i++)
                {
                    cxe[i].x = 2*math.randomreal()-1;
                    cxe[i].y = 2*math.randomreal()-1;
                }
                cxs = new complex[n];
                for(i=0; i<=n-1; i++)
                {
                    cv = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        cv += cea[i,i_]*cxe[i_];
                    }
                    cxs[i] = cv;
                }
                if( safesolve.cmatrixscaledtrsafesolve(ca, scalea, n, ref cxs, isupper, trans, isunit, Math.Sqrt(math.maxrealnumber)) )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        cerrors = cerrors || (double)(math.abscomplex(cxs[i]-cxe[i]))>(double)(threshold);
                    }
                }
                else
                {
                    cerrors = true;
                }
                
                //
                // same with real
                //
                isupper = (double)(math.randomreal())>(double)(0.5);
                trans = math.randominteger(2);
                isunit = (double)(math.randomreal())>(double)(0.5);
                scalea = math.randomreal()+0.5;
                ra = new double[n, n];
                for(i=0; i<=n-1; i++)
                {
                    for(j=0; j<=n-1; j++)
                    {
                        if( i==j )
                        {
                            ra[i,j] = (2*math.randominteger(2)-1)*(5+math.randomreal());
                        }
                        else
                        {
                            ra[i,j] = 0.2*math.randomreal()-0.1;
                        }
                    }
                }
                rmatrixmakeacopy(ra, n, n, ref rtmpa);
                for(i=0; i<=n-1; i++)
                {
                    if( isupper )
                    {
                        j1 = 0;
                        j2 = i-1;
                    }
                    else
                    {
                        j1 = i+1;
                        j2 = n-1;
                    }
                    for(j=j1; j<=j2; j++)
                    {
                        rtmpa[i,j] = 0;
                    }
                    if( isunit )
                    {
                        rtmpa[i,i] = 1;
                    }
                }
                rea = new double[n, n];
                for(i=0; i<=n-1; i++)
                {
                    if( trans==0 )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            rea[i,i_] = scalea*rtmpa[i,i_];
                        }
                    }
                    if( trans==1 )
                    {
                        for(i_=0; i_<=n-1;i_++)
                        {
                            rea[i_,i] = scalea*rtmpa[i,i_];
                        }
                    }
                }
                rxe = new double[n];
                for(i=0; i<=n-1; i++)
                {
                    rxe[i] = 2*math.randomreal()-1;
                }
                rxs = new double[n];
                for(i=0; i<=n-1; i++)
                {
                    rv = 0.0;
                    for(i_=0; i_<=n-1;i_++)
                    {
                        rv += rea[i,i_]*rxe[i_];
                    }
                    rxs[i] = rv;
                }
                if( safesolve.rmatrixscaledtrsafesolve(ra, scalea, n, ref rxs, isupper, trans, isunit, Math.Sqrt(math.maxrealnumber)) )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        rerrors = rerrors || (double)(Math.Abs(rxs[i]-rxe[i]))>(double)(threshold);
                    }
                }
                else
                {
                    rerrors = true;
                }
            }
            
            //
            // Special test with diagonal ill-conditioned matrix:
            // * ability to solve it when resulting growth is less than threshold
            // * ability to stop solve when resulting growth is greater than threshold
            //
            // A = diag(1, 1/growth)
            // b = (1, 0.5)
            //
            n = 2;
            growth = 10;
            ca = new complex[n, n];
            ca[0,0] = 1;
            ca[0,1] = 0;
            ca[1,0] = 0;
            ca[1,1] = 1/growth;
            cxs = new complex[n];
            cxs[0] = 1.0;
            cxs[1] = 0.5;
            cerrors = cerrors || !safesolve.cmatrixscaledtrsafesolve(ca, 1.0, n, ref cxs, (double)(math.randomreal())>(double)(0.5), math.randominteger(3), false, 1.05*Math.Max(math.abscomplex(cxs[1])*growth, 1.0));
            cerrors = cerrors || !safesolve.cmatrixscaledtrsafesolve(ca, 1.0, n, ref cxs, (double)(math.randomreal())>(double)(0.5), math.randominteger(3), false, 0.95*Math.Max(math.abscomplex(cxs[1])*growth, 1.0));
            ra = new double[n, n];
            ra[0,0] = 1;
            ra[0,1] = 0;
            ra[1,0] = 0;
            ra[1,1] = 1/growth;
            rxs = new double[n];
            rxs[0] = 1.0;
            rxs[1] = 0.5;
            rerrors = rerrors || !safesolve.rmatrixscaledtrsafesolve(ra, 1.0, n, ref rxs, (double)(math.randomreal())>(double)(0.5), math.randominteger(2), false, 1.05*Math.Max(Math.Abs(rxs[1])*growth, 1.0));
            rerrors = rerrors || !safesolve.rmatrixscaledtrsafesolve(ra, 1.0, n, ref rxs, (double)(math.randomreal())>(double)(0.5), math.randominteger(2), false, 0.95*Math.Max(Math.Abs(rxs[1])*growth, 1.0));
            
            //
            // Special test with diagonal degenerate matrix:
            // * ability to solve it when resulting growth is less than threshold
            // * ability to stop solve when resulting growth is greater than threshold
            //
            // A = diag(1, 0)
            // b = (1, 0.5)
            //
            n = 2;
            ca = new complex[n, n];
            ca[0,0] = 1;
            ca[0,1] = 0;
            ca[1,0] = 0;
            ca[1,1] = 0;
            cxs = new complex[n];
            cxs[0] = 1.0;
            cxs[1] = 0.5;
            cerrors = cerrors || safesolve.cmatrixscaledtrsafesolve(ca, 1.0, n, ref cxs, (double)(math.randomreal())>(double)(0.5), math.randominteger(3), false, Math.Sqrt(math.maxrealnumber));
            ra = new double[n, n];
            ra[0,0] = 1;
            ra[0,1] = 0;
            ra[1,0] = 0;
            ra[1,1] = 0;
            rxs = new double[n];
            rxs[0] = 1.0;
            rxs[1] = 0.5;
            rerrors = rerrors || safesolve.rmatrixscaledtrsafesolve(ra, 1.0, n, ref rxs, (double)(math.randomreal())>(double)(0.5), math.randominteger(2), false, Math.Sqrt(math.maxrealnumber));
            
            //
            // report
            //
            waserrors = rerrors || cerrors;
            if( !silent )
            {
                System.Console.Write("TESTING SAFE TR SOLVER");
                System.Console.WriteLine();
                System.Console.Write("REAL:                                    ");
                if( !rerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("COMPLEX:                                 ");
                if( !cerrors )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testsafesolve(bool silent)
        {
            return testsafesolve(silent);
        }


        /*************************************************************************
        Copy
        *************************************************************************/
        private static void rmatrixmakeacopy(double[,] a,
            int m,
            int n,
            ref double[,] b)
        {
            int i = 0;
            int j = 0;

            b = new double[0,0];

            b = new double[m-1+1, n-1+1];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    b[i,j] = a[i,j];
                }
            }
        }


        /*************************************************************************
        Copy
        *************************************************************************/
        private static void cmatrixmakeacopy(complex[,] a,
            int m,
            int n,
            ref complex[,] b)
        {
            int i = 0;
            int j = 0;

            b = new complex[0,0];

            b = new complex[m-1+1, n-1+1];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    b[i,j] = a[i,j];
                }
            }
        }


    }
    public class testrcondunit
    {
        public const double threshold50 = 0.25;
        public const double threshold90 = 0.10;


        public static bool testrcond(bool silent)
        {
            bool result = new bool();
            int maxn = 0;
            int passcount = 0;
            bool waserrors = new bool();
            bool rtrerr = new bool();
            bool ctrerr = new bool();
            bool rerr = new bool();
            bool cerr = new bool();
            bool spderr = new bool();
            bool hpderr = new bool();

            maxn = 10;
            passcount = 100;
            
            //
            // report
            //
            rtrerr = !testrmatrixtrrcond(maxn, passcount);
            ctrerr = !testcmatrixtrrcond(maxn, passcount);
            rerr = !testrmatrixrcond(maxn, passcount);
            cerr = !testcmatrixrcond(maxn, passcount);
            spderr = !testspdmatrixrcond(maxn, passcount);
            hpderr = !testhpdmatrixrcond(maxn, passcount);
            waserrors = ((((rtrerr || ctrerr) || rerr) || cerr) || spderr) || hpderr;
            if( !silent )
            {
                System.Console.Write("TESTING RCOND");
                System.Console.WriteLine();
                System.Console.Write("REAL TRIANGULAR:                         ");
                if( !rtrerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("COMPLEX TRIANGULAR:                      ");
                if( !ctrerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("REAL:                                    ");
                if( !rerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("SPD:                                     ");
                if( !spderr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("HPD:                                     ");
                if( !hpderr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                System.Console.Write("COMPLEX:                                 ");
                if( !cerr )
                {
                    System.Console.Write("OK");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("FAILED");
                    System.Console.WriteLine();
                }
                if( waserrors )
                {
                    System.Console.Write("TEST FAILED");
                    System.Console.WriteLine();
                }
                else
                {
                    System.Console.Write("TEST PASSED");
                    System.Console.WriteLine();
                }
                System.Console.WriteLine();
                System.Console.WriteLine();
            }
            result = !waserrors;
            return result;
        }


        /*************************************************************************
        Single-threaded stub. HPC ALGLIB replaces it by multithreaded code.
        *************************************************************************/
        public static bool _pexec_testrcond(bool silent)
        {
            return testrcond(silent);
        }


        /*************************************************************************
        Copy
        *************************************************************************/
        private static void rmatrixmakeacopy(double[,] a,
            int m,
            int n,
            ref double[,] b)
        {
            int i = 0;
            int j = 0;

            b = new double[0,0];

            b = new double[m-1+1, n-1+1];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    b[i,j] = a[i,j];
                }
            }
        }


        /*************************************************************************
        Drops upper or lower half of the matrix - fills it by special pattern
        which may be used later to ensure that this part wasn't changed
        *************************************************************************/
        private static void rmatrixdrophalf(ref double[,] a,
            int n,
            bool droplower)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (droplower && i>j) || (!droplower && i<j) )
                    {
                        a[i,j] = 1+2*i+3*j;
                    }
                }
            }
        }


        /*************************************************************************
        Drops upper or lower half of the matrix - fills it by special pattern
        which may be used later to ensure that this part wasn't changed
        *************************************************************************/
        private static void cmatrixdrophalf(ref complex[,] a,
            int n,
            bool droplower)
        {
            int i = 0;
            int j = 0;

            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    if( (droplower && i>j) || (!droplower && i<j) )
                    {
                        a[i,j] = 1+2*i+3*j;
                    }
                }
            }
        }


        /*************************************************************************
        Generate matrix with given condition number C (2-norm)
        *************************************************************************/
        private static void rmatrixgenzero(ref double[,] a0,
            int n)
        {
            int i = 0;
            int j = 0;

            a0 = new double[n, n];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a0[i,j] = 0;
                }
            }
        }


        /*************************************************************************
        triangular inverse
        *************************************************************************/
        private static bool rmatrixinvmattr(ref double[,] a,
            int n,
            bool isupper,
            bool isunittriangular)
        {
            bool result = new bool();
            bool nounit = new bool();
            int i = 0;
            int j = 0;
            double v = 0;
            double ajj = 0;
            double[] t = new double[0];
            int i_ = 0;

            result = true;
            t = new double[n-1+1];
            
            //
            // Test the input parameters.
            //
            nounit = !isunittriangular;
            if( isupper )
            {
                
                //
                // Compute inverse of upper triangular matrix.
                //
                for(j=0; j<=n-1; j++)
                {
                    if( nounit )
                    {
                        if( (double)(a[j,j])==(double)(0) )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    
                    //
                    // Compute elements 1:j-1 of j-th column.
                    //
                    if( j>0 )
                    {
                        for(i_=0; i_<=j-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=0; i<=j-1; i++)
                        {
                            if( i<j-1 )
                            {
                                v = 0.0;
                                for(i_=i+1; i_<=j-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=0; i_<=j-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            else
            {
                
                //
                // Compute inverse of lower triangular matrix.
                //
                for(j=n-1; j>=0; j--)
                {
                    if( nounit )
                    {
                        if( (double)(a[j,j])==(double)(0) )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    if( j<n-1 )
                    {
                        
                        //
                        // Compute elements j+1:n of j-th column.
                        //
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=j+1; i<=n-1; i++)
                        {
                            if( i>j+1 )
                            {
                                v = 0.0;
                                for(i_=j+1; i_<=i-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        LU inverse
        *************************************************************************/
        private static bool rmatrixinvmatlu(ref double[,] a,
            int[] pivots,
            int n)
        {
            bool result = new bool();
            double[] work = new double[0];
            int i = 0;
            int j = 0;
            int jp = 0;
            double v = 0;
            int i_ = 0;

            result = true;
            
            //
            // Quick return if possible
            //
            if( n==0 )
            {
                return result;
            }
            work = new double[n-1+1];
            
            //
            // Form inv(U)
            //
            if( !rmatrixinvmattr(ref a, n, true, false) )
            {
                result = false;
                return result;
            }
            
            //
            // Solve the equation inv(A)*L = inv(U) for inv(A).
            //
            for(j=n-1; j>=0; j--)
            {
                
                //
                // Copy current column of L to WORK and replace with zeros.
                //
                for(i=j+1; i<=n-1; i++)
                {
                    work[i] = a[i,j];
                    a[i,j] = 0;
                }
                
                //
                // Compute current column of inv(A).
                //
                if( j<n-1 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        v = 0.0;
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            v += a[i,i_]*work[i_];
                        }
                        a[i,j] = a[i,j]-v;
                    }
                }
            }
            
            //
            // Apply column interchanges.
            //
            for(j=n-2; j>=0; j--)
            {
                jp = pivots[j];
                if( jp!=j )
                {
                    for(i_=0; i_<=n-1;i_++)
                    {
                        work[i_] = a[i_,j];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        a[i_,j] = a[i_,jp];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        a[i_,jp] = work[i_];
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Matrix inverse
        *************************************************************************/
        private static bool rmatrixinvmat(ref double[,] a,
            int n)
        {
            bool result = new bool();
            int[] pivots = new int[0];

            trfac.rmatrixlu(ref a, n, n, ref pivots);
            result = rmatrixinvmatlu(ref a, pivots, n);
            return result;
        }


        /*************************************************************************
        reference RCond
        *************************************************************************/
        private static void rmatrixrefrcond(double[,] a,
            int n,
            ref double rc1,
            ref double rcinf)
        {
            double[,] inva = new double[0,0];
            double nrm1a = 0;
            double nrminfa = 0;
            double nrm1inva = 0;
            double nrminfinva = 0;
            double v = 0;
            int k = 0;
            int i = 0;

            rc1 = 0;
            rcinf = 0;

            
            //
            // inv A
            //
            rmatrixmakeacopy(a, n, n, ref inva);
            if( !rmatrixinvmat(ref inva, n) )
            {
                rc1 = 0;
                rcinf = 0;
                return;
            }
            
            //
            // norm A
            //
            nrm1a = 0;
            nrminfa = 0;
            for(k=0; k<=n-1; k++)
            {
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+Math.Abs(a[i,k]);
                }
                nrm1a = Math.Max(nrm1a, v);
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+Math.Abs(a[k,i]);
                }
                nrminfa = Math.Max(nrminfa, v);
            }
            
            //
            // norm inv A
            //
            nrm1inva = 0;
            nrminfinva = 0;
            for(k=0; k<=n-1; k++)
            {
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+Math.Abs(inva[i,k]);
                }
                nrm1inva = Math.Max(nrm1inva, v);
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+Math.Abs(inva[k,i]);
                }
                nrminfinva = Math.Max(nrminfinva, v);
            }
            
            //
            // result
            //
            rc1 = nrm1inva*nrm1a;
            rcinf = nrminfinva*nrminfa;
        }


        /*************************************************************************
        Copy
        *************************************************************************/
        private static void cmatrixmakeacopy(complex[,] a,
            int m,
            int n,
            ref complex[,] b)
        {
            int i = 0;
            int j = 0;

            b = new complex[0,0];

            b = new complex[m-1+1, n-1+1];
            for(i=0; i<=m-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    b[i,j] = a[i,j];
                }
            }
        }


        /*************************************************************************
        Generate matrix with given condition number C (2-norm)
        *************************************************************************/
        private static void cmatrixgenzero(ref complex[,] a0,
            int n)
        {
            int i = 0;
            int j = 0;

            a0 = new complex[n, n];
            for(i=0; i<=n-1; i++)
            {
                for(j=0; j<=n-1; j++)
                {
                    a0[i,j] = 0;
                }
            }
        }


        /*************************************************************************
        triangular inverse
        *************************************************************************/
        private static bool cmatrixinvmattr(ref complex[,] a,
            int n,
            bool isupper,
            bool isunittriangular)
        {
            bool result = new bool();
            bool nounit = new bool();
            int i = 0;
            int j = 0;
            complex v = 0;
            complex ajj = 0;
            complex[] t = new complex[0];
            int i_ = 0;

            result = true;
            t = new complex[n-1+1];
            
            //
            // Test the input parameters.
            //
            nounit = !isunittriangular;
            if( isupper )
            {
                
                //
                // Compute inverse of upper triangular matrix.
                //
                for(j=0; j<=n-1; j++)
                {
                    if( nounit )
                    {
                        if( a[j,j]==0 )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    
                    //
                    // Compute elements 1:j-1 of j-th column.
                    //
                    if( j>0 )
                    {
                        for(i_=0; i_<=j-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=0; i<=j-1; i++)
                        {
                            if( i<j-1 )
                            {
                                v = 0.0;
                                for(i_=i+1; i_<=j-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=0; i_<=j-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            else
            {
                
                //
                // Compute inverse of lower triangular matrix.
                //
                for(j=n-1; j>=0; j--)
                {
                    if( nounit )
                    {
                        if( a[j,j]==0 )
                        {
                            result = false;
                            return result;
                        }
                        a[j,j] = 1/a[j,j];
                        ajj = -a[j,j];
                    }
                    else
                    {
                        ajj = -1;
                    }
                    if( j<n-1 )
                    {
                        
                        //
                        // Compute elements j+1:n of j-th column.
                        //
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            t[i_] = a[i_,j];
                        }
                        for(i=j+1; i<=n-1; i++)
                        {
                            if( i>j+1 )
                            {
                                v = 0.0;
                                for(i_=j+1; i_<=i-1;i_++)
                                {
                                    v += a[i,i_]*t[i_];
                                }
                            }
                            else
                            {
                                v = 0;
                            }
                            if( nounit )
                            {
                                a[i,j] = v+a[i,i]*t[i];
                            }
                            else
                            {
                                a[i,j] = v+t[i];
                            }
                        }
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            a[i_,j] = ajj*a[i_,j];
                        }
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        LU inverse
        *************************************************************************/
        private static bool cmatrixinvmatlu(ref complex[,] a,
            int[] pivots,
            int n)
        {
            bool result = new bool();
            complex[] work = new complex[0];
            int i = 0;
            int j = 0;
            int jp = 0;
            complex v = 0;
            int i_ = 0;

            result = true;
            
            //
            // Quick return if possible
            //
            if( n==0 )
            {
                return result;
            }
            work = new complex[n-1+1];
            
            //
            // Form inv(U)
            //
            if( !cmatrixinvmattr(ref a, n, true, false) )
            {
                result = false;
                return result;
            }
            
            //
            // Solve the equation inv(A)*L = inv(U) for inv(A).
            //
            for(j=n-1; j>=0; j--)
            {
                
                //
                // Copy current column of L to WORK and replace with zeros.
                //
                for(i=j+1; i<=n-1; i++)
                {
                    work[i] = a[i,j];
                    a[i,j] = 0;
                }
                
                //
                // Compute current column of inv(A).
                //
                if( j<n-1 )
                {
                    for(i=0; i<=n-1; i++)
                    {
                        v = 0.0;
                        for(i_=j+1; i_<=n-1;i_++)
                        {
                            v += a[i,i_]*work[i_];
                        }
                        a[i,j] = a[i,j]-v;
                    }
                }
            }
            
            //
            // Apply column interchanges.
            //
            for(j=n-2; j>=0; j--)
            {
                jp = pivots[j];
                if( jp!=j )
                {
                    for(i_=0; i_<=n-1;i_++)
                    {
                        work[i_] = a[i_,j];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        a[i_,j] = a[i_,jp];
                    }
                    for(i_=0; i_<=n-1;i_++)
                    {
                        a[i_,jp] = work[i_];
                    }
                }
            }
            return result;
        }


        /*************************************************************************
        Matrix inverse
        *************************************************************************/
        private static bool cmatrixinvmat(ref complex[,] a,
            int n)
        {
            bool result = new bool();
            int[] pivots = new int[0];

            trfac.cmatrixlu(ref a, n, n, ref pivots);
            result = cmatrixinvmatlu(ref a, pivots, n);
            return result;
        }


        /*************************************************************************
        reference RCond
        *************************************************************************/
        private static void cmatrixrefrcond(complex[,] a,
            int n,
            ref double rc1,
            ref double rcinf)
        {
            complex[,] inva = new complex[0,0];
            double nrm1a = 0;
            double nrminfa = 0;
            double nrm1inva = 0;
            double nrminfinva = 0;
            double v = 0;
            int k = 0;
            int i = 0;

            rc1 = 0;
            rcinf = 0;

            
            //
            // inv A
            //
            cmatrixmakeacopy(a, n, n, ref inva);
            if( !cmatrixinvmat(ref inva, n) )
            {
                rc1 = 0;
                rcinf = 0;
                return;
            }
            
            //
            // norm A
            //
            nrm1a = 0;
            nrminfa = 0;
            for(k=0; k<=n-1; k++)
            {
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.abscomplex(a[i,k]);
                }
                nrm1a = Math.Max(nrm1a, v);
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.abscomplex(a[k,i]);
                }
                nrminfa = Math.Max(nrminfa, v);
            }
            
            //
            // norm inv A
            //
            nrm1inva = 0;
            nrminfinva = 0;
            for(k=0; k<=n-1; k++)
            {
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.abscomplex(inva[i,k]);
                }
                nrm1inva = Math.Max(nrm1inva, v);
                v = 0;
                for(i=0; i<=n-1; i++)
                {
                    v = v+math.abscomplex(inva[k,i]);
                }
                nrminfinva = Math.Max(nrminfinva, v);
            }
            
            //
            // result
            //
            rc1 = nrm1inva*nrm1a;
            rcinf = nrminfinva*nrminfa;
        }


        /*************************************************************************
        Returns True for successful test, False - for failed test
        *************************************************************************/
        private static bool testrmatrixtrrcond(int maxn,
            int passcount)
        {
            bool result = new bool();
            double[,] a = new double[0,0];
            double[,] ea = new double[0,0];
            int[] p = new int[0];
            int n = 0;
            int i = 0;
            int j = 0;
            int j1 = 0;
            int j2 = 0;
            int pass = 0;
            bool err50 = new bool();
            bool err90 = new bool();
            bool errspec = new bool();
            bool errless = new bool();
            double erc1 = 0;
            double ercinf = 0;
            double[] q50 = new double[0];
            double[] q90 = new double[0];
            double v = 0;
            bool isupper = new bool();
            bool isunit = new bool();

            err50 = false;
            err90 = false;
            errless = false;
            errspec = false;
            q50 = new double[2];
            q90 = new double[2];
            for(n=1; n<=maxn; n++)
            {
                
                //
                // special test for zero matrix
                //
                rmatrixgenzero(ref a, n);
                errspec = errspec || (double)(rcond.rmatrixtrrcond1(a, n, (double)(math.randomreal())>(double)(0.5), false))!=(double)(0);
                errspec = errspec || (double)(rcond.rmatrixtrrcondinf(a, n, (double)(math.randomreal())>(double)(0.5), false))!=(double)(0);
                
                //
                // general test
                //
                a = new double[n, n];
                for(i=0; i<=1; i++)
                {
                    q50[i] = 0;
                    q90[i] = 0;
                }
                for(pass=1; pass<=passcount; pass++)
                {
                    isupper