/*
 * Decompiled with CFR 0.152.
 */
package fr.unice.polytech.elim.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmplitudeWithLocation {
    private double ampl = 0.0;
    private double lat = 0.0;
    private double lon = 0.0;
    private int heur = 11;
    private int numClusters = 0;
    private static double coefAmpl = 1000.0;
    private static double coefLat = 1.0E7;
    private static double coefLon = 1.0E7;
    private static double coefHeur = 0.5;

    public AmplitudeWithLocation(double ampl, double lat, double lon, int heur) {
        this.setAmpl(ampl);
        this.setLat(lat);
        this.setLon(lon);
        this.setHeur(heur);
    }

    protected static double distance(AmplitudeWithLocation vecteur, AmplitudeWithLocation centre) {
        return Math.sqrt(Math.pow(coefAmpl * (centre.getAmpl() - vecteur.getAmpl()), 2.0) + Math.pow(coefLon * (centre.getLon() - vecteur.getLon()), 2.0) + Math.pow(coefLat * (centre.getLat() - vecteur.getLat()), 2.0) + Math.pow(coefHeur * (double)(vecteur.getHeur() - centre.getHeur()), 2.0));
    }

    public static AmplitudeWithLocation creationVecteur(int minAmpl, int maxAmpl, int minLatLon, int maxLatLon) {
        Random r = new Random();
        double ampl = (double)minAmpl + (double)(maxAmpl - minAmpl) * r.nextDouble();
        double lat = (double)minLatLon + (double)(maxLatLon - minLatLon) * r.nextDouble();
        double lon = (double)minLatLon + (double)(maxLatLon - minLatLon) * r.nextDouble();
        return new AmplitudeWithLocation(ampl, lat, lon, 11);
    }

    public static List<AmplitudeWithLocation> creationVecteurs(int minAmpl, int maxAmpl, int minLatLon, int maxLatLon, int nombre) {
        ArrayList<AmplitudeWithLocation> listVecteurs = new ArrayList<AmplitudeWithLocation>(nombre);
        for (int i = 0; i < nombre; ++i) {
            listVecteurs.add(AmplitudeWithLocation.creationVecteur(minAmpl, maxAmpl, minLatLon, maxLatLon));
        }
        return listVecteurs;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("amplitude", this.ampl);
        jsonObject.put("lat", this.lat);
        jsonObject.put("lon", this.lon);
        jsonObject.put("heur", this.heur);
        return jsonObject;
    }

    public String toString() {
        return "{\"amplitude\":" + this.ampl + ",\"lat\":" + this.lat + ",\"lon\":" + this.lon + ",\"heur\":" + this.heur + "}";
    }

    public double getAmpl() {
        return this.ampl;
    }

    public void setAmpl(double ampl) {
        this.ampl = ampl;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public int getNumCluster() {
        return this.numClusters;
    }

    public void setNumCluster(int n) {
        this.numClusters = n;
    }

    public int getHeur() {
        return this.heur;
    }

    public void setHeur(int heur) {
        this.heur = heur;
    }
}

