/*
 * Decompiled with CFR 0.152.
 */
package fr.unice.polytech.elim.clustering;

import fr.unice.polytech.elim.clustering.AmplitudeWithLocation;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCluster {
    public List<AmplitudeWithLocation> listeAmplitudes;
    public AmplitudeWithLocation centre;
    public int id;

    public MyCluster(int id) {
        this.id = id;
        this.listeAmplitudes = new ArrayList<AmplitudeWithLocation>();
        this.centre = null;
    }

    public void addAmplitude(AmplitudeWithLocation ampl) {
        this.listeAmplitudes.add(ampl);
    }

    public void clear() {
        this.listeAmplitudes.clear();
    }

    public void displayCluster() {
        System.out.println("[Cluster: " + this.id + "]");
        System.out.println("[Centroid: " + this.centre + "]");
        System.out.println("[Points: \n");
        for (AmplitudeWithLocation p : this.listeAmplitudes) {
            System.out.println(p);
        }
        System.out.println("]");
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("idCluster", this.id);
        jsonObject.put("centre", (Object)this.centre.toJSON());
        JSONArray array = new JSONArray();
        for (AmplitudeWithLocation p : this.listeAmplitudes) {
            array.put((Object)p.toJSON());
        }
        jsonObject.put("points", (Object)array);
        return jsonObject;
    }

    public String toString() {
        String res = "";
        res = res + "{\"idCluster\" : " + this.id + ",";
        res = res + "\"Centre\" : " + this.centre + ",";
        res = res + "\"Points\": [";
        for (AmplitudeWithLocation p : this.listeAmplitudes) {
            res = res + p;
        }
        res = res + "]}";
        return res;
    }

    public List<AmplitudeWithLocation> getListeAmplitudes() {
        return this.listeAmplitudes;
    }

    public void setListeAmplitudes(List<AmplitudeWithLocation> listeAmplitudes) {
        this.listeAmplitudes = listeAmplitudes;
    }

    public AmplitudeWithLocation getCentre() {
        return this.centre;
    }

    public void setCentre(AmplitudeWithLocation centre) {
        this.centre = centre;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

