/*
 * Decompiled with CFR 0.152.
 */
package fr.unice.polytech.elim.clustering;

import fr.unice.polytech.elim.clustering.AmplitudeWithLocation;
import fr.unice.polytech.elim.clustering.MyCluster;
import fr.unice.polytech.elim.treatment.business.Amplitude;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyKMeans {
    private int NB_CLUSTERS = 3;
    private int NB_POINTS = 15;
    private static final int MIN_AMPL = 0;
    private static final int MAX_AMPL = 10;
    private static final int MIN_LAT_LON = 0;
    private static final int MAX_LAT_LON = 10;
    private List<AmplitudeWithLocation> listeAmplitudes = new ArrayList<AmplitudeWithLocation>();
    private List<MyCluster> listeClusters = new ArrayList<MyCluster>();

    public MyKMeans(int nbCluster) {
        this.NB_CLUSTERS = nbCluster;
    }

    public void initKMeans(List<Amplitude> liste) {
        System.out.println("initKMeans avec mes amplitude");
        this.listeAmplitudes = new ArrayList<AmplitudeWithLocation>();
        for (Amplitude amplitude : liste) {
            AmplitudeWithLocation ampl = new AmplitudeWithLocation(amplitude.getAmplitude(), amplitude.getLat(), amplitude.getLon(), amplitude.getDate().getHours());
            this.listeAmplitudes.add(ampl);
        }
        ArrayList<Integer> listeIndexCentre = new ArrayList<Integer>();
        for (int i = 0; i < this.NB_CLUSTERS; ++i) {
            int index = -1;
            while (index == -1 || listeIndexCentre.contains(index)) {
                Random rand = new Random();
                index = rand.nextInt(this.listeAmplitudes.size());
            }
            listeIndexCentre.add(index);
            MyCluster cluster = new MyCluster(i);
            AmplitudeWithLocation centroid = this.listeAmplitudes.get(index);
            cluster.setCentre(centroid);
            this.listeClusters.add(cluster);
        }
    }

    public void initKMeans() {
        System.out.println("initKMeans avec des amplitude random");
        this.listeAmplitudes = AmplitudeWithLocation.creationVecteurs(0, 10, 0, 10, this.NB_POINTS);
        for (int i = 0; i < this.NB_CLUSTERS; ++i) {
            MyCluster cluster = new MyCluster(i);
            AmplitudeWithLocation centroid = AmplitudeWithLocation.creationVecteur(0, 10, 0, 10);
            cluster.setCentre(centroid);
            this.listeClusters.add(cluster);
        }
    }

    private void displayClusters() {
        for (int i = 0; i < this.NB_CLUSTERS; ++i) {
            MyCluster c = this.listeClusters.get(i);
            c.displayCluster();
        }
    }

    public String getClustersDisplay() {
        String res = "{\"data\" : [";
        for (int i = 0; i < this.NB_CLUSTERS - 1; ++i) {
            MyCluster c = this.listeClusters.get(i);
            res = res + c.toString() + ",";
        }
        MyCluster c = this.listeClusters.get(this.NB_CLUSTERS - 1);
        res = res + c.toString() + "]}";
        return res;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.NB_CLUSTERS; ++i) {
            MyCluster c = this.listeClusters.get(i);
            array.put((Object)c.toJSON());
        }
        jsonObject.put("data", (Object)array);
        return jsonObject;
    }

    public void calculate() {
        System.out.println("calculate");
        boolean finish = false;
        int iteration = 0;
        while (!finish) {
            this.clearClusters();
            List<AmplitudeWithLocation> centrePres = this.getCentres();
            this.assignationClusters();
            this.calculeCentre();
            ++iteration;
            List<AmplitudeWithLocation> centreCourant = this.getCentres();
            double distance = 0.0;
            for (int i = 0; i < centrePres.size(); ++i) {
                distance += AmplitudeWithLocation.distance(centrePres.get(i), centreCourant.get(i));
            }
            System.out.println("#################");
            System.out.println("Iteration: " + iteration);
            System.out.println("Centre distances: " + distance);
            if (distance != 0.0) continue;
            finish = true;
        }
    }

    private void clearClusters() {
        System.out.println("clearClusters");
        for (MyCluster cluster : this.listeClusters) {
            cluster.clear();
        }
    }

    private List<AmplitudeWithLocation> getCentres() {
        System.out.println("getCentres ");
        ArrayList<AmplitudeWithLocation> centres = new ArrayList<AmplitudeWithLocation>(this.NB_CLUSTERS);
        for (MyCluster cluster : this.listeClusters) {
            AmplitudeWithLocation aux = cluster.getCentre();
            AmplitudeWithLocation ampl = new AmplitudeWithLocation(aux.getAmpl(), aux.getLat(), aux.getLon(), aux.getHeur());
            centres.add(ampl);
        }
        return centres;
    }

    private void assignationClusters() {
        double max;
        System.out.println("assignationClusters ");
        double min = max = Double.MAX_VALUE;
        int numCluster = 0;
        double distance = 0.0;
        for (AmplitudeWithLocation ampl : this.listeAmplitudes) {
            min = max;
            for (int i = 0; i < this.NB_CLUSTERS; ++i) {
                MyCluster c = this.listeClusters.get(i);
                distance = AmplitudeWithLocation.distance(ampl, c.getCentre());
                if (!(distance < min)) continue;
                min = distance;
                numCluster = i;
            }
            ampl.setNumCluster(numCluster);
            this.listeClusters.get(numCluster).addAmplitude(ampl);
        }
    }

    private void calculeCentre() {
        System.out.println("calculeCentre ");
        for (MyCluster cluster : this.listeClusters) {
            double sumAmpl = 0.0;
            double sumLat = 0.0;
            double sumLon = 0.0;
            List<AmplitudeWithLocation> list = cluster.getListeAmplitudes();
            int nbAmplitude = list.size();
            for (AmplitudeWithLocation ampl : list) {
                sumAmpl += ampl.getAmpl();
                sumLat += ampl.getLat();
                sumLon += ampl.getLon();
            }
            AmplitudeWithLocation centre = cluster.getCentre();
            if (nbAmplitude <= 0) continue;
            double newAmpl = sumAmpl / (double)nbAmplitude;
            double newLat = sumLat / (double)nbAmplitude;
            double newLon = sumLon / (double)nbAmplitude;
            centre.setAmpl(newAmpl);
            centre.setLat(newLat);
            centre.setLon(newLon);
        }
    }
}

