/*
 * Decompiled with CFR 0.152.
 */
package fr.unice.polytech.elim.treatment;

import fr.unice.polytech.elim.clustering.MyKMeans;
import fr.unice.polytech.elim.treatment.business.Amplitude;
import fr.unice.polytech.elim.treatment.utils.Day;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/treatment")
@Produces(value={"application/json"})
public class Treatment {
    public static List<Amplitude> listeAmplitude = new ArrayList<Amplitude>();
    public static HashMap<Day, ArrayList<Amplitude>> map = new HashMap();

    public Treatment() {
        System.out.println("Constructeur : chargement des donn\u00e9es !!!");
        System.out.println("Current relative path is: " + Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
        File file = new File("dataAmplitudes/data");
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int length = (int)file.length();
            byte[] bytes = new byte[length];
            fileInputStream.read(bytes);
            fileInputStream.close();
            this.addAmplitudes(new String(bytes));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @POST
    public void addAmplitudes(String body) {
        System.out.println("addAmplitudes");
        JSONObject obj = new JSONObject(body);
        JSONArray array = obj.getJSONArray("data");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject ampl = array.getJSONObject(i);
            Amplitude amplitude = new Amplitude();
            amplitude.setAmplitude(ampl.getDouble("amplitude"));
            amplitude.setLat(ampl.getDouble("lat"));
            amplitude.setLon(ampl.getDouble("lon"));
            amplitude.setAuRepos(ampl.getBoolean("auRepos"));
            amplitude.setInterieur(ampl.getBoolean("interieur"));
            Date date = new Date(ampl.getLong("date"));
            amplitude.setDate(date);
            Day jour = this.getDay(date);
            if (!map.containsKey((Object)jour)) {
                map.put(jour, new ArrayList());
            }
            map.get((Object)jour).add(amplitude);
            listeAmplitude.add(amplitude);
        }
        try {
            File file = new File("dataAmplitudes/data");
            JSONObject jsonObject = new JSONObject();
            JSONArray a = new JSONArray();
            for (Amplitude ampl : listeAmplitude) {
                a.put((Object)ampl.toJSON());
            }
            jsonObject.put("data", (Object)a);
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(jsonObject.toString().getBytes());
            fileOutputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Path(value="/clusters/{nbClusters}")
    @GET
    public Response getClusters(@PathParam(value="nbClusters") int nbClusters) {
        System.out.println("nbClusters = " + nbClusters);
        String rep = this.doKMeans(listeAmplitude, nbClusters);
        if (rep.equals("{}")) {
            this.doKMeansRandom(nbClusters);
        }
        return Response.ok((Object)rep).build();
    }

    @Path(value="/clusters/{day}/{auRepos}/{interieur}/{nbClusters}")
    @GET
    public Response getClusters(@PathParam(value="day") String day, @PathParam(value="auRepos") boolean auRepos, @PathParam(value="interieur") boolean interieur, @PathParam(value="nbClusters") int nbClusters) {
        System.out.println("day = " + day);
        System.out.println("auRepos = " + auRepos);
        System.out.println("interieur = " + interieur);
        System.out.println("nbClusters = " + nbClusters);
        try {
            Day jour = Day.valueOf(day);
            System.out.println("jour = " + (Object)((Object)jour));
            ArrayList<Object> liste = new ArrayList();
            System.out.println("map.containsKey(jour) = " + map.containsKey((Object)jour));
            if (map.containsKey((Object)jour)) {
                liste = map.get((Object)jour);
            }
            System.out.println("liste.size() = " + liste.size());
            liste = this.filterAuRepos(liste, auRepos);
            System.out.println("liste.size() apres auRepos = " + liste.size());
            liste = this.filterInterieur(liste, interieur);
            System.out.println("liste.size() apres interieur = " + liste.size());
            String rep = this.doKMeans(liste, nbClusters);
            return Response.ok((Object)rep).build();
        }
        catch (IllegalArgumentException e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("erreur", (Object)"Premier argument invalide (IllegalArgumentException");
            return Response.ok((Object)jsonObject.toString()).build();
        }
        catch (NullPointerException e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("erreur", (Object)"Premier argument invalide (NullPointerException");
            return Response.ok((Object)jsonObject.toString()).build();
        }
    }

    @Path(value="/clusters/{auRepos}/{interieur}/{nbClusters}")
    @GET
    public Response getClusters(@PathParam(value="auRepos") boolean auRepos, @PathParam(value="interieur") boolean interieur, @PathParam(value="nbClusters") int nbClusters) {
        System.out.println("auRepos = " + auRepos);
        System.out.println("interieur = " + interieur);
        System.out.println("nbClusters = " + nbClusters);
        ArrayList<Amplitude> liste = new ArrayList<Amplitude>();
        for (ArrayList<Amplitude> l : map.values()) {
            liste.addAll(l);
        }
        System.out.println("liste.size() = " + liste.size());
        liste = this.filterAuRepos(liste, auRepos);
        System.out.println("liste.size() apres repos = " + liste.size());
        liste = this.filterInterieur(liste, interieur);
        System.out.println("liste.size() apres interieur = " + liste.size());
        String rep = this.doKMeans(liste, nbClusters);
        return Response.ok((Object)rep).build();
    }

    @Path(value="/amplitudes")
    @GET
    public Response getAmplitude() {
        System.out.println("getAmplitude");
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        for (Amplitude ampl : listeAmplitude) {
            array.put((Object)ampl.toJSON());
        }
        jsonObject.put("data", (Object)array);
        return Response.ok((Object)jsonObject.toString()).build();
    }

    private String doKMeans(List<Amplitude> liste, int nbClusters) {
        MyKMeans kmeans = new MyKMeans(nbClusters);
        System.out.println("!liste.isEmpty() && (liste.size() >= nbClusters) = " + (!liste.isEmpty() && liste.size() >= nbClusters));
        System.out.println("nbClusters = " + nbClusters);
        System.out.println("liste.size() = " + liste.size());
        System.out.println("(liste.size() >= nbClusters) = " + (liste.size() >= nbClusters));
        if (!liste.isEmpty() && liste.size() >= nbClusters) {
            kmeans.initKMeans(liste);
            kmeans.calculate();
            return kmeans.toJSON().toString();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("error", (Object)("Pas assez d'amplitudes pour calculer " + nbClusters + " cluster(s)"));
        return jsonObject.toString();
    }

    private String doKMeansRandom(int nbClusters) {
        MyKMeans kmeans = new MyKMeans(nbClusters);
        kmeans.initKMeans();
        kmeans.calculate();
        return kmeans.toJSON().toString();
    }

    private Day getDay(Date date) {
        Day jour = Day.lundi;
        switch (date.getDay()) {
            case 1: {
                jour = Day.lundi;
                break;
            }
            case 2: {
                jour = Day.mardi;
                break;
            }
            case 3: {
                jour = Day.mercredi;
                break;
            }
            case 4: {
                jour = Day.jeudi;
                break;
            }
            case 5: {
                jour = Day.vendredi;
                break;
            }
            case 6: {
                jour = Day.samedi;
                break;
            }
            case 7: {
                jour = Day.dimanche;
                break;
            }
        }
        return jour;
    }

    private ArrayList<Amplitude> filterAuRepos(ArrayList<Amplitude> liste, boolean auRepos) {
        ArrayList<Amplitude> newList = new ArrayList<Amplitude>();
        for (Amplitude ampl : liste) {
            boolean auRep = ampl.isAuRepos();
            if (auRepos != auRep) continue;
            newList.add(ampl);
        }
        return newList;
    }

    private ArrayList<Amplitude> filterInterieur(ArrayList<Amplitude> liste, boolean interieur) {
        ArrayList<Amplitude> newList = new ArrayList<Amplitude>();
        for (Amplitude ampl : liste) {
            boolean inter = ampl.isInterieur();
            if (interieur != inter) continue;
            newList.add(ampl);
        }
        return newList;
    }

    private void displayMap() {
        for (Day jour : map.keySet()) {
            System.out.println("Pour " + jour.toString() + " : \n");
            System.out.println(map.get((Object)jour));
        }
    }
}

