/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.serialization;

import java.util.Hashtable;
import java.util.Vector;
import org.ksoap2.serialization.AttributeContainer;
import org.ksoap2.serialization.AttributeInfo;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.NullSoapObject;
import org.ksoap2.serialization.PropertyInfo;

public class SoapObject
extends AttributeContainer
implements KvmSerializable {
    protected String namespace;
    protected String name;
    protected Vector properties = new Vector();
    protected Vector nestedSoapObjects = new Vector();

    public SoapObject(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SoapObject)) {
            return false;
        }
        SoapObject otherSoapObject = (SoapObject)obj;
        if (!this.name.equals(otherSoapObject.name) || !this.namespace.equals(otherSoapObject.namespace)) {
            return false;
        }
        int numProperties = this.properties.size();
        if (numProperties != otherSoapObject.properties.size()) {
            return false;
        }
        int numNested = this.nestedSoapObjects.size();
        if (numNested != otherSoapObject.nestedSoapObjects.size()) {
            return false;
        }
        for (int propIndex = 0; propIndex < numProperties; ++propIndex) {
            PropertyInfo thisProp = (PropertyInfo)this.properties.elementAt(propIndex);
            Object thisPropValue = thisProp.getValue();
            if (!otherSoapObject.hasProperty(thisProp.getName())) {
                return false;
            }
            Object otherPropValue = otherSoapObject.getProperty(thisProp.getName());
            if (thisPropValue.equals(otherPropValue)) continue;
            return false;
        }
        for (int nestIndex = 0; nestIndex < numNested; ++nestIndex) {
            if (this.getNestedSoap(nestIndex).equals(otherSoapObject.getNestedSoap(nestIndex))) continue;
            return false;
        }
        return this.attributesAreEqual(otherSoapObject);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getNestedSoap(int index) {
        return (SoapObject)this.nestedSoapObjects.elementAt(index);
    }

    public Object getProperty(int index) {
        return ((PropertyInfo)this.properties.elementAt(index)).getValue();
    }

    public String getPropertyAsString(int index) {
        PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(index);
        return propertyInfo.getValue().toString();
    }

    public Object getProperty(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            return this.getProperty(index);
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public String getPropertyAsString(String name) {
        Integer index = this.propertyIndex(name);
        if (index != null) {
            return this.getProperty(index).toString();
        }
        throw new RuntimeException("illegal property: " + name);
    }

    public boolean hasProperty(String name) {
        return this.propertyIndex(name) != null;
    }

    public Object getPropertySafely(String name) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            return this.getProperty(i);
        }
        return new NullSoapObject();
    }

    public String getPropertySafelyAsString(String name) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            return this.getProperty(i).toString();
        }
        return "";
    }

    public Object safeGetProperty(String name) {
        return this.getPropertySafely(name);
    }

    public Object getPropertySafely(String name, Object defaultThing) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            return this.getProperty(i);
        }
        return defaultThing;
    }

    public String getPropertySafelyAsString(String name, Object defaultThing) {
        Integer i = this.propertyIndex(name);
        if (i != null) {
            return this.getProperty(i).toString();
        }
        return defaultThing.toString();
    }

    public Object safeGetProperty(String name, Object defaultThing) {
        return this.getPropertySafely(name, defaultThing);
    }

    private Integer propertyIndex(String name) {
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!name.equals(((PropertyInfo)this.properties.elementAt(i)).getName())) continue;
            return new Integer(i);
        }
        return null;
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public int getNestedSoapCount() {
        return this.nestedSoapObjects.size();
    }

    public void getPropertyInfo(int index, Hashtable properties, PropertyInfo propertyInfo) {
        this.getPropertyInfo(index, propertyInfo);
    }

    public void getPropertyInfo(int index, PropertyInfo propertyInfo) {
        PropertyInfo p = (PropertyInfo)this.properties.elementAt(index);
        propertyInfo.name = p.name;
        propertyInfo.namespace = p.namespace;
        propertyInfo.flags = p.flags;
        propertyInfo.type = p.type;
        propertyInfo.elementType = p.elementType;
        propertyInfo.value = p.value;
        propertyInfo.multiRef = p.multiRef;
    }

    public SoapObject newInstance() {
        SoapObject o = new SoapObject(this.namespace, this.name);
        for (int propIndex = 0; propIndex < this.properties.size(); ++propIndex) {
            PropertyInfo propertyInfo = (PropertyInfo)this.properties.elementAt(propIndex);
            o.addProperty(propertyInfo);
        }
        for (int attribIndex = 0; attribIndex < this.getAttributeCount(); ++attribIndex) {
            AttributeInfo newAI = new AttributeInfo();
            this.getAttributeInfo(attribIndex, newAI);
            AttributeInfo attributeInfo = newAI;
            o.addAttribute(attributeInfo);
        }
        return o;
    }

    public void setProperty(int index, Object value) {
        ((PropertyInfo)this.properties.elementAt(index)).setValue(value);
    }

    public SoapObject addProperty(String name, Object value) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = name;
        propertyInfo.type = value == null ? PropertyInfo.OBJECT_CLASS : value.getClass();
        propertyInfo.value = value;
        return this.addProperty(propertyInfo);
    }

    public SoapObject addPropertyIfValue(String name, Object value) {
        if (value != null) {
            return this.addProperty(name, value);
        }
        return this;
    }

    public SoapObject addProperty(PropertyInfo propertyInfo, Object value) {
        propertyInfo.setValue(value);
        this.addProperty(propertyInfo);
        return this;
    }

    public SoapObject addPropertyIfValue(PropertyInfo propertyInfo, Object value) {
        if (value != null) {
            return this.addProperty(propertyInfo, value);
        }
        return this;
    }

    public SoapObject addProperty(PropertyInfo propertyInfo) {
        this.properties.addElement(propertyInfo);
        return this;
    }

    public SoapObject addPropertyIfValue(PropertyInfo propertyInfo) {
        if (propertyInfo.value != null) {
            this.properties.addElement(propertyInfo);
            return this;
        }
        return this;
    }

    public SoapObject addSoapObject(SoapObject soapObject) {
        this.nestedSoapObjects.addElement(soapObject);
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("" + this.name + "{");
        for (int j = 0; j < this.getNestedSoapCount(); ++j) {
            buf.append("\n" + ((SoapObject)this.nestedSoapObjects.elementAt(j)).toString());
        }
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            buf.append("" + ((PropertyInfo)this.properties.elementAt(i)).getName() + "=" + this.getProperty(i) + "; ");
        }
        buf.append("}");
        return buf.toString();
    }
}

