/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import org.ksoap2.HeaderProperty;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.transport.ServiceConnection;
import org.ksoap2.transport.ServiceConnectionSE;
import org.ksoap2.transport.Transport;
import org.xmlpull.v1.XmlPullParserException;

public class HttpTransportSE
extends Transport {
    private ServiceConnection connection;

    public HttpTransportSE(String url) {
        super(null, url);
    }

    public HttpTransportSE(Proxy proxy, String url) {
        super(proxy, url);
    }

    public HttpTransportSE(String url, int timeout) {
        super(url, timeout);
    }

    public HttpTransportSE(Proxy proxy, String url, int timeout) {
        super(proxy, url, timeout);
    }

    public void call(String soapAction, SoapEnvelope envelope) throws IOException, XmlPullParserException {
        this.call(soapAction, envelope, null);
    }

    public List call(String soapAction, SoapEnvelope envelope, List headers) throws IOException, XmlPullParserException {
        InputStream is;
        List retHeaders;
        block10: {
            if (soapAction == null) {
                soapAction = "\"\"";
            }
            byte[] requestData = this.createRequestData(envelope);
            this.requestDump = this.debug ? new String(requestData) : null;
            this.responseDump = null;
            this.connection = this.getServiceConnection();
            this.connection.setRequestProperty("User-Agent", "ksoap2-android/2.6.0+");
            if (envelope.version != 120) {
                this.connection.setRequestProperty("SOAPAction", soapAction);
            }
            if (envelope.version == 120) {
                this.connection.setRequestProperty("Content-Type", "application/soap+xml;charset=utf-8");
            } else {
                this.connection.setRequestProperty("Content-Type", "text/xml;charset=utf-8");
            }
            this.connection.setRequestProperty("Connection", "close");
            this.connection.setRequestProperty("Content-Length", "" + requestData.length);
            if (headers != null) {
                for (int i = 0; i < headers.size(); ++i) {
                    HeaderProperty hp = (HeaderProperty)headers.get(i);
                    this.connection.setRequestProperty(hp.getKey(), hp.getValue());
                }
            }
            this.connection.setRequestMethod("POST");
            this.connection.connect();
            OutputStream os = this.connection.openOutputStream();
            os.write(requestData, 0, requestData.length);
            os.flush();
            os.close();
            requestData = null;
            retHeaders = null;
            try {
                this.connection.connect();
                is = this.connection.openInputStream();
                retHeaders = this.connection.getResponseProperties();
            }
            catch (IOException e) {
                is = this.connection.getErrorStream();
                if (is != null) break block10;
                this.connection.disconnect();
                throw e;
            }
        }
        if (this.debug) {
            int rd;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((rd = is.read(buf, 0, 256)) != -1) {
                bos.write(buf, 0, rd);
            }
            bos.flush();
            buf = bos.toByteArray();
            this.responseDump = new String(buf);
            is.close();
            is = new ByteArrayInputStream(buf);
        }
        this.parseResponse(envelope, is);
        return retHeaders;
    }

    public ServiceConnection getConnection() {
        return (ServiceConnectionSE)this.connection;
    }

    protected ServiceConnection getServiceConnection() throws IOException {
        return new ServiceConnectionSE(this.proxy, this.url, this.timeout);
    }

    public String getHost() {
        String retVal = null;
        try {
            retVal = new URL(this.url).getHost();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public int getPort() {
        int retVal = -1;
        try {
            retVal = new URL(this.url).getPort();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String getPath() {
        String retVal = null;
        try {
            retVal = new URL(this.url).getPath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

