/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.ksoap2.transport.HttpTransportSE;
import org.ksoap2.transport.HttpsServiceConnectionSE;
import org.ksoap2.transport.ServiceConnection;

public class HttpsTransportSE
extends HttpTransportSE {
    static final String PROTOCOL = "https";
    private HttpsServiceConnectionSE conn = null;
    private final String host;
    private final int port;
    private final String file;
    private final int timeout;

    public HttpsTransportSE(String host, int port, String file, int timeout) {
        super("https://" + host + ":" + port + file);
        this.host = host;
        this.port = port;
        this.file = file;
        this.timeout = timeout;
    }

    public ServiceConnection getConnection() {
        return this.conn;
    }

    protected ServiceConnection getServiceConnection() throws IOException {
        this.conn = new HttpsServiceConnectionSE(this.host, this.port, this.file, this.timeout);
        return this.conn;
    }

    public String getHost() {
        String retVal = null;
        try {
            retVal = new URL(this.url).getHost();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public int getPort() {
        int retVal = -1;
        try {
            retVal = new URL(this.url).getPort();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String getPath() {
        String retVal = null;
        try {
            retVal = new URL(this.url).getPath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

