/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.util.List;
import org.ksoap2.SoapEnvelope;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Transport {
    protected Proxy proxy;
    protected String url;
    protected int timeout = 20000;
    public boolean debug;
    public String requestDump;
    public String responseDump;
    private String xmlVersionTag = "";
    protected static final String CONTENT_TYPE_XML_CHARSET_UTF_8 = "text/xml;charset=utf-8";
    protected static final String CONTENT_TYPE_SOAP_XML_CHARSET_UTF_8 = "application/soap+xml;charset=utf-8";
    protected static final String USER_AGENT = "ksoap2-android/2.6.0+";

    public Transport() {
    }

    public Transport(String url) {
        this(null, url);
    }

    public Transport(String url, int timeout) {
        this.url = url;
        this.timeout = timeout;
    }

    public Transport(Proxy proxy, String url) {
        this.proxy = proxy;
        this.url = url;
    }

    public Transport(Proxy proxy, String url, int timeout) {
        this.proxy = proxy;
        this.url = url;
        this.timeout = timeout;
    }

    protected void parseResponse(SoapEnvelope envelope, InputStream is) throws XmlPullParserException, IOException {
        KXmlParser xp = new KXmlParser();
        xp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        xp.setInput(is, null);
        envelope.parse(xp);
    }

    protected byte[] createRequestData(SoapEnvelope envelope) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.xmlVersionTag.getBytes());
        KXmlSerializer xw = new KXmlSerializer();
        xw.setOutput(bos, null);
        envelope.write(xw);
        xw.flush();
        bos.write(13);
        bos.write(10);
        bos.flush();
        return bos.toByteArray();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setXmlVersionTag(String tag) {
        this.xmlVersionTag = tag;
    }

    public void reset() {
    }

    public abstract List call(String var1, SoapEnvelope var2, List var3) throws IOException, XmlPullParserException;

    public void call(String targetNamespace, SoapEnvelope envelope) throws IOException, XmlPullParserException {
        this.call(targetNamespace, envelope, null);
    }

    public abstract String getHost();

    public abstract int getPort();

    public abstract String getPath();
}

