/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Server
extends Thread {
    private ServerSocket serverSocket;
    private int port;
    private double latitude;
    private double longitude;
    private long counter;
    private double batteryConsumption;
    private static final String FILE_VALUES = "values.json";
    public static String FILE_KMEAN = "kmean.json";
    private Kmeans kmeans;

    public Server(int port, Kmeans kmeans) {
        this.port = port;
        this.kmeans = kmeans;
    }

    public static boolean checkSimilarLocation(double latitude, double longitude, double newLatitude, double newLongitude) {
        return Math.abs(latitude - newLatitude) <= 5.0E-4 && Math.abs(longitude - newLongitude) <= 5.0E-4;
    }

    public static void storeValues(String strValue) {
        System.out.println("Store");
        File file = new File(FILE_VALUES);
        if (!file.exists()) {
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                String str = "{\"yann\": []}";
                outputStream.write(str.getBytes());
                outputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            FileReader reader = new FileReader(FILE_VALUES);
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse(reader);
            JSONArray info = (JSONArray)jsonObject.get("yann");
            JSONParser parser = new JSONParser();
            JSONObject v = (JSONObject)parser.parse(strValue);
            boolean exist = false;
            for (JSONObject value : info) {
                if (!Server.checkSimilarLocation((Double)value.get("Latitude"), (Double)value.get("Longitude"), (Double)v.get("Latitude"), (Double)v.get("Longitude"))) continue;
                System.out.println("SAME location");
                double bConsumption = (Double)value.get("Battery_consumption") + (Double)v.get("Battery_consumption");
                value.put("Battery_consumption", bConsumption);
                long counterTotal = (Long)value.get("Counter") + (Long)v.get("Counter");
                value.put("Counter", counterTotal);
                exist = true;
            }
            if (!exist) {
                info.add(v);
            }
            reader.close();
            FileWriter filew = new FileWriter(file);
            filew.write(jsonObject.toJSONString());
            filew.flush();
            filew.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        Socket client = null;
        while (true) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                System.out.println("Waiting for client on port " + this.serverSocket.getLocalPort() + "...");
                client = this.serverSocket.accept();
                System.out.println("Just connected to " + client.getRemoteSocketAddress());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            while (true) {
                String response = "";
                try {
                    PrintWriter mBufferOut;
                    OutputStream outputs;
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    if (response.equals("GET_KMEAN")) {
                        this.kmeans.executeKmean();
                        System.out.println("SENDING KMEAN TO CLIENT");
                        FileInputStream in = null;
                        try {
                            in = new FileInputStream(FILE_KMEAN);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        OutputStream out = null;
                        try {
                            int count;
                            out = client.getOutputStream();
                            byte[] bytes = new byte[16384];
                            while ((count = ((InputStream)in).read(bytes)) > 0) {
                                out.write(bytes, 0, count);
                            }
                            ((InputStream)in).close();
                            out.close();
                        }
                        catch (IOException e) {
                            System.out.println("IOException kmean");
                            e.printStackTrace();
                        }
                        break;
                    }
                    if (response.equals("STOP_connection")) {
                        System.out.println("ENDDDD");
                        outputs = client.getOutputStream();
                        mBufferOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputs)), true);
                        mBufferOut.println("END");
                        outputs.close();
                        break;
                    }
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    this.latitude = Double.parseDouble(response);
                    System.out.println(this.latitude);
                    mBufferOut.println("ACK");
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    this.longitude = Double.parseDouble(response);
                    System.out.println(this.longitude);
                    mBufferOut.println("ACK");
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    this.batteryConsumption = Double.parseDouble(response);
                    System.out.println(this.batteryConsumption);
                    mBufferOut.println("ACK");
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    this.counter = Long.parseLong(response);
                    System.out.println(this.counter);
                    mBufferOut.println("ACK");
                    String value = "{\"Latitude\": " + this.latitude + ",\"Longitude\": " + this.longitude + ", \"Battery_consumption\": " + this.batteryConsumption + ", \"Counter\": " + this.counter + " }";
                    Server.storeValues(value);
                }
                catch (IOException iOException) {}
            }
            System.out.println("CLOSE");
            try {
                client.close();
                this.serverSocket.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        Kmeans kmeans = new Kmeans();
        Server t = new Server(3456, kmeans);
        t.start();
    }
}

