/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Kmeans {
    private int NUM_CLUSTERS = 3;
    private int NUM_POINTS = 15;
    private static final int MIN = 5;
    private static final int MAX = 30;
    private static final String FILE_KMEAN = "kmean.json";
    private static final String FILE_VALUES = "values.json";
    private List<Value> values = new ArrayList<Value>();
    private List<Cluster> clusters = new ArrayList<Cluster>();

    protected static double distanceCentroid(double p, double centroid) {
        return Math.abs(centroid - p);
    }

    public static void main(String[] args) {
        Kmeans kmeans = new Kmeans();
        String testbidon = "{\"Latitude\": 11.2,\"Longitude\": 20.1, \"Battery_consumption\": 90.0, \"Counter\":1 }";
    }

    public void executeKmean() {
        this.init();
        this.calculate();
        this.storeKmean();
    }

    public void sortCentroid() {
        Collections.sort(this.clusters, new Comparator<Cluster>(){

            @Override
            public int compare(Cluster c1, Cluster c2) {
                return Double.compare(c1.getCentroid(), c2.getCentroid());
            }
        });
    }

    public double calculateBatteryConsumptionPerHour(double minutePerCount, double val, long counter) {
        double result = val / ((double)counter * minutePerCount) * 60.0;
        System.out.println("BatteryConsumption : " + result + " with counter " + counter + " and value : " + val);
        return result;
    }

    public void readValues() {
        try {
            FileReader reader = new FileReader(FILE_VALUES);
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse(reader);
            JSONArray info = (JSONArray)jsonObject.get("yann");
            for (JSONObject innerObj : info) {
                double batteryConsumption = this.calculateBatteryConsumptionPerHour(15.0, (Double)innerObj.get("Battery_consumption"), (Long)innerObj.get("Counter"));
                Value v = new Value(batteryConsumption, (Double)innerObj.get("Latitude"), (Double)innerObj.get("Longitude"));
                this.values.add(v);
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        System.out.println("length " + this.values.size());
        for (Value v : this.values) {
            System.out.println(v.toString());
        }
    }

    public void storeKmean() {
        this.sortCentroid();
        System.out.println();
        try (FileWriter fw = new FileWriter(FILE_KMEAN, false);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println("{");
            out.println("\"cluster0\" : {");
            List<Value> cluster0Values = this.clusters.get(0).getValues();
            out.println("\"centroid\" : " + this.clusters.get(0).getCentroid() + ",");
            out.println("\"values\" : [{");
            if (cluster0Values.size() > 0) {
                for (int i = 0; i < cluster0Values.size() - 1; ++i) {
                    out.println("\"Latitude\" : " + cluster0Values.get(i).getLatitude() + ",");
                    out.println("\"Longitude\" : " + cluster0Values.get(i).getLongitude() + ",");
                    out.println("\"Battery_consumption\" : " + cluster0Values.get(i).getVal());
                    out.println("},\n{");
                }
                out.println("\"Latitude\" : " + cluster0Values.get(cluster0Values.size() - 1).getLatitude() + ",");
                out.println("\"Longitude\" : " + cluster0Values.get(cluster0Values.size() - 1).getLongitude() + ",");
                out.println("\"Battery_consumption\" : " + cluster0Values.get(cluster0Values.size() - 1).getVal());
            }
            out.println("}]");
            out.println("},");
            out.println("\"cluster1\" : {");
            out.println("\"centroid\" : " + this.clusters.get(1).getCentroid() + ",");
            out.println("\"values\" : [{");
            List<Value> cluster1Values = this.clusters.get(1).getValues();
            if (cluster1Values.size() > 0) {
                for (int i = 0; i < cluster1Values.size() - 1; ++i) {
                    out.println("\"Latitude\" : " + cluster1Values.get(i).getLatitude() + ",");
                    out.println("\"Longitude\" : " + cluster1Values.get(i).getLongitude() + ",");
                    out.println("\"Battery_consumption\" : " + cluster1Values.get(i).getVal());
                    out.println("},\n{");
                }
                out.println("\"Latitude\" : " + cluster1Values.get(cluster1Values.size() - 1).getLatitude() + ",");
                out.println("\"Longitude\" : " + cluster1Values.get(cluster1Values.size() - 1).getLongitude() + ",");
                out.println("\"Battery_consumption\" : " + cluster1Values.get(cluster1Values.size() - 1).getVal());
            }
            out.println("}]");
            out.println("},");
            out.println("\"cluster2\" : {");
            out.println("\"centroid\" : " + this.clusters.get(2).getCentroid() + ",");
            out.println("\"values\" : [{");
            List<Value> cluster2Values = this.clusters.get(2).getValues();
            if (cluster2Values.size() > 0) {
                for (int i = 0; i < cluster2Values.size() - 1; ++i) {
                    out.println("\"Latitude\" : " + cluster2Values.get(i).getLatitude() + ",");
                    out.println("\"Longitude\" : " + cluster2Values.get(i).getLongitude() + ",");
                    out.println("\"Battery_consumption\" : " + cluster2Values.get(i).getVal());
                    out.println("},\n{");
                }
                out.println("\"Latitude\" : " + cluster2Values.get(cluster2Values.size() - 1).getLatitude() + ",");
                out.println("\"Longitude\" : " + cluster2Values.get(cluster2Values.size() - 1).getLongitude() + ",");
                out.println("\"Battery_consumption\" : " + cluster2Values.get(cluster2Values.size() - 1).getVal());
            }
            out.println("}]");
            out.println("}");
            out.println("}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void init() {
        this.values = new ArrayList<Value>();
        this.clusters = new ArrayList<Cluster>();
        this.readValues();
        for (int i = 0; i < this.NUM_CLUSTERS; ++i) {
            Cluster cluster = new Cluster(i);
            Random r = new Random();
            double centroid = 5.0 + 25.0 * r.nextDouble();
            cluster.setCentroid(centroid);
            this.clusters.add(cluster);
        }
        System.out.println("Initial state : \n");
        this.plotClusters();
        System.out.println("All the generated Points: \n");
        for (Value p : this.values) {
            System.out.println(p);
        }
        System.out.println("\n");
    }

    private void plotClusters() {
        for (int i = 0; i < this.NUM_CLUSTERS; ++i) {
            Cluster c = this.clusters.get(i);
            c.plotCluster();
        }
    }

    public void calculate() {
        boolean finish = false;
        int iteration = 0;
        while (!finish) {
            this.clearClusters();
            List lastCentroids = this.getCentroids();
            this.assignCluster();
            this.calculateCentroids();
            ++iteration;
            List currentCentroids = this.getCentroids();
            double distance = 0.0;
            for (int i = 0; i < lastCentroids.size(); ++i) {
                distance += Kmeans.distanceCentroid((Double)lastCentroids.get(i), (Double)currentCentroids.get(i));
            }
            System.out.println("#################");
            System.out.println("Iteration: " + iteration);
            System.out.println("Centroid distances: " + distance);
            this.plotClusters();
            if (distance != 0.0) continue;
            finish = true;
        }
    }

    private void clearClusters() {
        for (Cluster cluster : this.clusters) {
            cluster.clear();
        }
    }

    private List getCentroids() {
        ArrayList<Double> centroids = new ArrayList<Double>(this.NUM_CLUSTERS);
        for (Cluster cluster : this.clusters) {
            double aux = cluster.getCentroid();
            centroids.add(aux);
        }
        return centroids;
    }

    private void assignCluster() {
        double max;
        double min = max = Double.MAX_VALUE;
        int cluster = 0;
        double distance = 0.0;
        for (Value value : this.values) {
            min = max;
            for (int i = 0; i < this.NUM_CLUSTERS; ++i) {
                Cluster c = this.clusters.get(i);
                distance = Value.distance(value, c.getCentroid());
                if (!(distance < min)) continue;
                min = distance;
                cluster = i;
            }
            value.setCluster(cluster);
            this.clusters.get(cluster).addValue(value);
        }
    }

    private void calculateCentroids() {
        for (Cluster cluster : this.clusters) {
            double sumX = 0.0;
            List<Value> list = cluster.getValues();
            int n_points = list.size();
            for (Value value : list) {
                sumX += value.getVal();
            }
            double centroid = cluster.getCentroid();
            if (n_points <= 0) continue;
            double newX = sumX / (double)n_points;
            cluster.setCentroid(newX);
        }
    }
}

