/**
 * Created by Yann on 10/01/2017.
 */


import java.util.ArrayList;
import java.util.List;

public class Cluster {

    public List<Value> values;
    public double centroid;
    public int id;

    //Creates a new Cluster
    public Cluster(int id) {
        this.id = id;
        this.values = new ArrayList<Value>();
        this.centroid = 0;
    }

    public List<Value> getValues() {
        return values;
    }

    public void addValue(Value value) {
        values.add(value);
    }

    public void setValues(List values) {
        this.values = values;
    }

    public double getCentroid() {
        return centroid;
    }

    public void setCentroid(double centroid) {
        this.centroid = centroid;
    }

    public int getId() {
        return id;
    }

    public void clear() {
        values.clear();
    }

    public void plotCluster() {
        System.out.println("[Cluster: " + id+"]");
        System.out.println("[Centroid: " + centroid + "]");
        System.out.println("[Points: \n");
        for(Value p : values) {
            System.out.println(p);
        }
        System.out.println("]");
    }

}