import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * Created by Yann on 02/02/2017.
 */
public class SendKmean extends Thread {

    public static String FILE_KMEAN = "kmean.json";
    public static int PORT = 12345;


    public void run()
    {
        ServerSocket serverSocket = null;
        byte[] bytes = new byte[16*1024];

        try {
            serverSocket = new ServerSocket(PORT);
        } catch (IOException ex) {
            System.out.println("Can't setup server on this port number. ");
        }

        Socket socket = null;
        InputStream in = null;
        OutputStream out = null;

        try {
            in = new FileInputStream(FILE_KMEAN);

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        try {
            System.out.println("Waiting for client");
            socket = serverSocket.accept();
            System.out.println("Client connected");
            out = socket.getOutputStream();
            int count;
            while ((count = in.read(bytes)) > 0) {
                out.write(bytes, 0, count);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }

        try {
            System.out.println("Closing");
            out.close();
            in.close();
            socket.close();
            serverSocket.close();
        } catch (IOException e) {
            e.printStackTrace();
        }


    }






    public static void main(String[] args) throws IOException {

        Thread t = new SendKmean();
        t.start();

        }



}
