/**
 * Created by Yann
 */

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import java.net.*;
import java.io.*;
import java.util.Iterator;

public class Server extends Thread {
    private ServerSocket serverSocket;
    public static int port = 3456;
    private double latitude;
    private double longitude;
    private long counter;
    private double batteryConsumption;
    private static final String FILE_VALUES = "values.json";
    public static String FILE_KMEAN = "kmean.json";
    private Kmeans kmeans;


    public Server(Kmeans kmeans) {
        this.kmeans = kmeans;
    }

    public static boolean checkSimilarLocation(double latitude, double longitude, double newLatitude, double newLongitude) {
        //same location if its less than 55m of difference (corresponding at 0.0005 of dif)
        return (Math.abs(latitude - newLatitude) <= 0.0005 && Math.abs(longitude - newLongitude) <= 0.0005);

    }

    public static void storeValues(String strValue) {
        System.out.println("Store");
        File file = new File(FILE_VALUES);
        /*If file does not exist*/
        if (!file.exists()) {

            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                String str = "{\"yann\": []}";
                outputStream.write(str.getBytes());
                outputStream.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        try {
            FileReader reader = new FileReader(FILE_VALUES);
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject) jsonParser.parse(reader);
            JSONArray info = (JSONArray) jsonObject.get("yann");
            JSONParser parser = new JSONParser();
            JSONObject v = (JSONObject) parser.parse(strValue);
            boolean exist = false;


            Iterator i = info.iterator();
            while (i.hasNext()) {
                JSONObject value = (JSONObject) i.next();


                if (checkSimilarLocation((double) value.get("Latitude"), (double) value.get("Longitude"), (double) v.get("Latitude"), (double) v.get("Longitude"))) {
                    //same location
                    //System.out.println("SAME location");
                    //update the battery consumption
                    double bConsumption = (double) value.get("Battery_consumption") + (double) v.get("Battery_consumption");
                    value.put("Battery_consumption", bConsumption);
                    //update the counter
                    long counterTotal = (long) value.get("Counter") + (long) v.get("Counter");
                    value.put("Counter", counterTotal);
                    exist = true;
                }
            }
            //append to json array if the location doesnt exist
            if (!exist)
                info.add(v);
            reader.close();
            FileWriter filew = new FileWriter(file);

            filew.write(jsonObject.toJSONString());
            filew.flush();
            filew.close();


        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    public void run() {
        Socket client = null;


        while (true) {

            try {

                serverSocket = new ServerSocket(port);
                System.out.println("Waiting for client on port " +
                        serverSocket.getLocalPort() + "...");
                client = serverSocket.accept();
                System.out.println("Just connected to " + client.getRemoteSocketAddress());
            } catch (IOException e) {
                e.printStackTrace();
            }

            while (true) {


                String response = "";
                try {
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();

                    if (response.equals("GET_KMEAN")) {
                        //Execute kmean
                        kmeans.executeKmean();
                        //send kmean to the client
                        System.out.println("SENDING KMEAN TO CLIENT");
                        InputStream in = null;
                        try {
                            in = new FileInputStream(FILE_KMEAN);
                        } catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        OutputStream out = null;
                        try {
                            out = client.getOutputStream();
                            int count;
                            byte[] bytes = new byte[16 * 1024];
                            while ((count = in.read(bytes)) > 0) {
                                out.write(bytes, 0, count);
                            }
                            in.close();
                            out.close();
                        } catch (IOException e) {
                            System.out.println("IOException kmean");
                            e.printStackTrace();
                        }
                        break;
                    }
                         /*END*/
                    if (response.equals("STOP_connection")) {
                        System.out.println("ENDDDD");
                        OutputStream outputs = client.getOutputStream();
                        PrintWriter mBufferOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputs)), true);
                        mBufferOut.println("END");
                        outputs.close();
                        break;
                    }
                 /*Recuperation of latitude*/

                    OutputStream outputs = client.getOutputStream();
                    PrintWriter mBufferOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    latitude = (double) Double.parseDouble(response);
                    System.out.println(latitude);
                    mBufferOut.println("ACK");

                 /*Recuperation of longitude*/
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    longitude = (double) Double.parseDouble(response);
                    System.out.println(longitude);
                    mBufferOut.println("ACK");

                  /*Recuperation of battery consumption*/
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    batteryConsumption = Double.parseDouble(response);
                    System.out.println(batteryConsumption);
                    mBufferOut.println("ACK");

                    /*Recuperation of battery consumption*/
                    response = new BufferedReader(new InputStreamReader(client.getInputStream())).readLine();
                    outputs = client.getOutputStream();
                    mBufferOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputs)), true);
                    counter = Long.parseLong(response);
                    System.out.println(counter);
                    mBufferOut.println("ACK");

                    //store this value in the JSON file
                    String value = "{\"Latitude\": " + latitude + ",\"Longitude\": " + longitude + ", \"Battery_consumption\": " + batteryConsumption + ", \"Counter\": " + counter + " }";
                    storeValues(value);

                }

                catch (IOException e) {
                   // System.out.println("IOEXEPTION value");
                   // e.printStackTrace();
                }

            }


            System.out.println("CLOSE");
            try {
               // outputs.close();
                client.close();
                serverSocket.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }


    }

    public static void main(String[] args) {
        // int port = Integer.parseInt(args[0]);

        Kmeans kmeans = new Kmeans();

        Thread t = new Server(kmeans);
        t.start();

    }
}