/*
 * Decompiled with CFR 0.152.
 */
package spark;

import java.util.HashMap;
import spark.Request;
import spark.Response;
import spark.Route;

public class CustomErrorPages {
    public static final String NOT_FOUND = "<html><body><h2>404 Not found</h2></body></html>";
    public static final String INTERNAL_ERROR = "<html><body><h2>500 Internal Error</h2></body></html>";
    private final HashMap<Integer, Object> customPages = new HashMap();

    public static boolean existsFor(int status) {
        return CustomErrorPages.getInstance().customPages.containsKey(status);
    }

    public static Object getFor(int status, Request request, Response response) {
        Object customPage;
        Object customRenderer = CustomErrorPages.getInstance().customPages.get(status);
        Object object = customPage = status == 400 ? NOT_FOUND : INTERNAL_ERROR;
        if (customRenderer instanceof String) {
            customPage = customRenderer;
        } else if (customRenderer instanceof Route) {
            try {
                customPage = ((Route)customRenderer).handle(request, response);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return customPage;
    }

    static void add(int status, String page) {
        CustomErrorPages.getInstance().customPages.put(status, page);
    }

    static void add(int status, Route route) {
        CustomErrorPages.getInstance().customPages.put(status, route);
    }

    private CustomErrorPages() {
    }

    private static CustomErrorPages getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final CustomErrorPages INSTANCE = new CustomErrorPages();

        private SingletonHolder() {
        }
    }
}

