/*
 * Decompiled with CFR 0.152.
 */
package fr.polytech.localisator.KMeans;

import fr.polytech.localisator.KMeans.Cluster;
import fr.polytech.localisator.KMeans.Point;
import fr.polytech.localisator.KMeans.Traitement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class KMeans {
    private int nbClusters;
    private int NUM_POINTS;
    private double MIN_X = 0.0;
    private double MAX_X = 0.0;
    private double MIN_Y = 0.0;
    private double MAX_Y = 0.0;
    private List<Point> points = new ArrayList<Point>();
    private List<Cluster> clusters = new ArrayList<Cluster>();
    private Traitement t;
    private String donnees;
    private String userId;

    public KMeans(String id, int nbCluster) {
        this.userId = id;
        this.t = new Traitement(this.userId);
        this.nbClusters = nbCluster;
    }

    public void lancement() throws IOException {
        this.init();
        this.calculate();
        System.out.println("Premier centroid : " + this.clusters.get(0).getCentroid());
        System.out.println("Second centroid : " + this.clusters.get(1).getCentroid());
        this.donnees = "Donn\u00e9es trait\u00e9es \n";
        for (int j = 0; j < this.nbClusters; ++j) {
            this.donnees = this.donnees + "Latitude," + String.valueOf(this.clusters.get(j).getCentroid().getX()) + ",Longitude," + String.valueOf(this.clusters.get(j).getCentroid().getY()) + "\n";
        }
        System.out.println(this.donnees);
    }

    public void init() {
        int i;
        this.NUM_POINTS = this.t.getNbPoint();
        this.MIN_X = this.t.getX_min();
        this.MAX_X = this.t.getX_max();
        this.MIN_Y = this.t.getY_min();
        this.MAX_Y = this.t.getY_max();
        System.out.println("Nombre de clusters : " + this.nbClusters);
        for (i = 0; i < this.NUM_POINTS; ++i) {
            double x = this.t.getMyList().get(i).getX();
            double y = this.t.getMyList().get(i).getY();
            this.points.add(i, new Point(x, y));
        }
        for (i = 0; i < this.nbClusters; ++i) {
            Cluster cluster = new Cluster(i);
            Point centroid = Point.createRandomPoint(this.MIN_X, this.MAX_X, this.MIN_Y, this.MAX_Y);
            centroid.setClusterNumber(i);
            cluster.setCentroid(centroid);
            this.clusters.add(cluster);
        }
        this.plotClusters();
    }

    private void plotClusters() {
        for (int i = 0; i < this.nbClusters; ++i) {
            Cluster c = this.clusters.get(i);
            c.plotCluster();
        }
    }

    public void calculate() {
        boolean finish = false;
        int iteration = 0;
        while (!finish) {
            this.clearClusters();
            List lastCentroids = this.getCentroids();
            this.assignCluster();
            this.calculateCentroids();
            ++iteration;
            List currentCentroids = this.getCentroids();
            double distance = 0.0;
            for (int i = 0; i < lastCentroids.size(); ++i) {
                distance += Point.distance((Point)lastCentroids.get(i), (Point)currentCentroids.get(i));
            }
            System.out.println("#################");
            System.out.println("Iteration: " + iteration);
            System.out.println("Centroid distances: " + distance);
            this.plotClusters();
            if (distance != 0.0) continue;
            finish = true;
        }
    }

    private void clearClusters() {
        for (Cluster cluster : this.clusters) {
            cluster.clear();
        }
    }

    private List getCentroids() {
        ArrayList<Point> centroids = new ArrayList<Point>(this.nbClusters);
        for (Cluster cluster : this.clusters) {
            Point aux = cluster.getCentroid();
            Point point = new Point(aux.getX(), aux.getY());
            centroids.add(point);
        }
        return centroids;
    }

    private void assignCluster() {
        double max;
        double min = max = Double.MAX_VALUE;
        int cluster = 0;
        double distance = 0.0;
        for (Point point : this.points) {
            min = max;
            for (int i = 0; i < this.nbClusters; ++i) {
                Cluster c = this.clusters.get(i);
                distance = Point.distance(point, c.getCentroid());
                if (!(distance < min)) continue;
                min = distance;
                cluster = i;
            }
            point.setClusterNumber(cluster);
            this.clusters.get(cluster).addPoint(point);
        }
    }

    private void calculateCentroids() {
        for (Cluster cluster : this.clusters) {
            double sumX = 0.0;
            double sumY = 0.0;
            List list = cluster.getPoints();
            int n_points = list.size();
            for (Point point : list) {
                sumX += point.getX();
                sumY += point.getY();
            }
            Point centroid = cluster.getCentroid();
            if (n_points <= 0) continue;
            double newX = sumX / (double)n_points;
            double newY = sumY / (double)n_points;
            centroid.setX(newX);
            centroid.setY(newY);
        }
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }
}

