/*
 * Decompiled with CFR 0.152.
 */
package fr.polytech.localisator.finder;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import fr.polytech.localisator.KMeans.Point;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingClusterFinder {
    Logger logger = LoggerFactory.getLogger(MatchingClusterFinder.class);
    private static final String CENTROID_LIST_FILE_NAME = "centroidList.json";
    private static final String DATA_PATH = "res";
    private static final int DISTANCE_MAX = 1000;
    List<String> userIdList;

    public MatchingClusterFinder() {
        File folder = new File("res/");
        File[] listOfFiles = folder.listFiles();
        this.userIdList = new ArrayList<String>();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (file.isFile() || !file.isDirectory()) continue;
                this.userIdList.add(file.getName());
            }
        }
        for (String userId : this.userIdList) {
            this.logger.info(userId);
        }
    }

    public List<Point> getCentroidList(String userId) {
        String centroidData = "";
        try {
            centroidData = new String(Files.readAllBytes(Paths.get("res/" + userId + "/" + CENTROID_LIST_FILE_NAME, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Gson gson = new Gson();
        List centroidList = (List)gson.fromJson(centroidData, new TypeToken<List<Point>>(){}.getType());
        return centroidList;
    }

    public List<String> findMatchCluster(String userId) {
        ArrayList<String> matchedUserId = new ArrayList<String>();
        List<Point> userCentroid = this.getCentroidList(userId);
        for (String targetId : this.userIdList) {
            if (targetId.equals(userId)) continue;
            List<Point> targetCentroid = this.getCentroidList(targetId);
            if (!this.pointIsNearby(userCentroid.get(0), targetCentroid.get(0), 1000) && !this.pointIsNearby(userCentroid.get(0), targetCentroid.get(1), 1000) || !this.pointIsNearby(userCentroid.get(1), targetCentroid.get(0), 1000) && !this.pointIsNearby(userCentroid.get(1), targetCentroid.get(1), 1000)) continue;
            this.logger.info(userId + " is a match with " + targetId);
            matchedUserId.add(targetId);
        }
        return matchedUserId;
    }

    private boolean pointIsNearby(Point point, Point point1, int distance) {
        return this.calcDistance(point.getX(), point1.getX(), point.getY(), point1.getY(), 0.0, 0.0) < (double)distance;
    }

    public double calcDistance(double lat1, double lat2, double lon1, double lon2, double el1, double el2) {
        int R = 6371;
        Double latDistance = Math.toRadians(lat2 - lat1);
        Double lonDistance = Math.toRadians(lon2 - lon1);
        Double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371.0 * c * 1000.0;
        double height = el1 - el2;
        distance = Math.pow(distance, 2.0) + Math.pow(height, 2.0);
        return Math.sqrt(distance);
    }
}

