/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver;

import java.util.HashMap;
import java.util.Map;
import spark.embeddedserver.EmbeddedServer;
import spark.embeddedserver.EmbeddedServerFactory;
import spark.embeddedserver.jetty.EmbeddedJettyFactory;
import spark.route.Routes;
import spark.staticfiles.StaticFilesConfiguration;

public class EmbeddedServers {
    private static Map<Object, EmbeddedServerFactory> factories = new HashMap<Object, EmbeddedServerFactory>();

    public static void initialize() {
        EmbeddedServers.add((Object)Identifiers.JETTY, new EmbeddedJettyFactory());
    }

    public static Identifiers defaultIdentifier() {
        return Identifiers.JETTY;
    }

    public static EmbeddedServer create(Object identifier, Routes routeMatcher, StaticFilesConfiguration staticFilesConfiguration, boolean multipleHandlers) {
        EmbeddedServerFactory factory = factories.get(identifier);
        if (factory != null) {
            return factory.create(routeMatcher, staticFilesConfiguration, multipleHandlers);
        }
        throw new RuntimeException("No embedded server matching the identifier");
    }

    public static void add(Object identifier, EmbeddedServerFactory factory) {
        factories.put(identifier, factory);
    }

    public static enum Identifiers {
        JETTY;

    }
}

