/*
 * Decompiled with CFR 0.152.
 */
package spark.http.matching;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.CustomErrorPages;
import spark.HaltException;
import spark.RequestResponseFactory;
import spark.Response;
import spark.embeddedserver.jetty.HttpRequestWrapper;
import spark.http.matching.AfterFilters;
import spark.http.matching.BeforeFilters;
import spark.http.matching.Body;
import spark.http.matching.GeneralError;
import spark.http.matching.Halt;
import spark.http.matching.RequestWrapper;
import spark.http.matching.ResponseWrapper;
import spark.http.matching.RouteContext;
import spark.http.matching.Routes;
import spark.route.HttpMethod;
import spark.serialization.SerializerChain;
import spark.staticfiles.StaticFilesConfiguration;

public class MatcherFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(MatcherFilter.class);
    private static final String ACCEPT_TYPE_REQUEST_MIME_HEADER = "Accept";
    private static final String HTTP_METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    private final StaticFilesConfiguration staticFiles;
    private spark.route.Routes routeMatcher;
    private SerializerChain serializerChain;
    private boolean externalContainer;
    private boolean hasOtherHandlers;

    public MatcherFilter(spark.route.Routes routeMatcher, StaticFilesConfiguration staticFiles, boolean externalContainer, boolean hasOtherHandlers) {
        this.routeMatcher = routeMatcher;
        this.staticFiles = staticFiles;
        this.externalContainer = externalContainer;
        this.hasOtherHandlers = hasOtherHandlers;
        this.serializerChain = new SerializerChain();
    }

    @Override
    public void init(FilterConfig config) {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        boolean consumedByStaticFile = this.staticFiles.consume(httpRequest, httpResponse);
        if (consumedByStaticFile) {
            return;
        }
        String method = this.getHttpMethodFrom(httpRequest);
        String httpMethodStr = method.toLowerCase();
        String uri = httpRequest.getRequestURI();
        String acceptType = httpRequest.getHeader(ACCEPT_TYPE_REQUEST_MIME_HEADER);
        Body body = Body.create();
        RequestWrapper requestWrapper = RequestWrapper.create();
        ResponseWrapper responseWrapper = ResponseWrapper.create();
        Response response = RequestResponseFactory.create(httpResponse);
        HttpMethod httpMethod = HttpMethod.get(httpMethodStr);
        RouteContext context = RouteContext.create().withMatcher(this.routeMatcher).withHttpRequest(httpRequest).withUri(uri).withAcceptType(acceptType).withBody(body).withRequestWrapper(requestWrapper).withResponseWrapper(responseWrapper).withResponse(response).withHttpMethod(httpMethod);
        try {
            BeforeFilters.execute(context);
            Routes.execute(context);
            AfterFilters.execute(context);
        }
        catch (HaltException halt) {
            Halt.modify(httpResponse, body, halt);
        }
        catch (Exception generalException) {
            GeneralError.modify(httpRequest, httpResponse, body, requestWrapper, responseWrapper, generalException);
        }
        if (body.notSet() && responseWrapper.isRedirected()) {
            body.set("");
        }
        if (body.notSet() && this.hasOtherHandlers && servletRequest instanceof HttpRequestWrapper) {
            ((HttpRequestWrapper)servletRequest).notConsumed(true);
            return;
        }
        if (body.notSet() && !this.externalContainer) {
            LOG.info("The requested route [{}] has not been mapped in Spark for {}: [{}]", uri, ACCEPT_TYPE_REQUEST_MIME_HEADER, acceptType);
            httpResponse.setStatus(404);
            if (CustomErrorPages.existsFor(404)) {
                requestWrapper.setDelegate(RequestResponseFactory.create(httpRequest));
                responseWrapper.setDelegate(RequestResponseFactory.create(httpResponse));
                body.set(CustomErrorPages.getFor(404, requestWrapper, responseWrapper));
            } else {
                body.set(String.format("<html><body><h2>404 Not found</h2></body></html>", new Object[0]));
            }
        }
        if (body.isSet()) {
            body.serializeTo(httpResponse, this.serializerChain, httpRequest);
        } else if (chain != null) {
            chain.doFilter(httpRequest, httpResponse);
        }
    }

    private String getHttpMethodFrom(HttpServletRequest httpRequest) {
        String method = httpRequest.getHeader(HTTP_METHOD_OVERRIDE_HEADER);
        if (method == null) {
            method = httpRequest.getMethod();
        }
        return method;
    }

    @Override
    public void destroy() {
    }
}

