/*
 * Decompiled with CFR 0.152.
 */
package KMeans;

import KMeans.Cluster;
import KMeans.Point;
import KMeans.Traitement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class KMeans {
    private int NUM_CLUSTERS = 2;
    private int NUM_POINTS;
    private double MIN_X = 0.0;
    private double MAX_X = 0.0;
    private double MIN_Y = 0.0;
    private double MAX_Y = 0.0;
    private List<Point> points = new ArrayList<Point>();
    private static List<Cluster> clusters;
    private static Traitement t;
    private static String donnees;

    public KMeans() {
        clusters = new ArrayList<Cluster>();
    }

    public static void lancement() throws IOException {
        KMeans kmeans = new KMeans();
        kmeans.init();
        kmeans.calculate();
        System.out.println("Premier centroid : " + clusters.get(0).getCentroid());
        System.out.println("Second centroid : " + clusters.get(1).getCentroid());
        donnees = "Donn\u00e9es trait\u00e9es \nLatitude," + String.valueOf(clusters.get(0).getCentroid().getX()) + ",Longitude," + String.valueOf(clusters.get(0).getCentroid().getY()) + "\n" + "Latitude," + String.valueOf(clusters.get(1).getCentroid().getX()) + ",Longitude," + String.valueOf(clusters.get(1).getCentroid().getY()) + "\n";
        System.out.println(donnees);
        kmeans.ecriture();
    }

    public void init() {
        int i;
        this.NUM_POINTS = t.data();
        this.MIN_X = Traitement.x_min;
        this.MAX_X = Traitement.x_max;
        this.MIN_Y = Traitement.y_min;
        this.MAX_Y = Traitement.y_max;
        Traitement.myList.size();
        for (i = 0; i < this.NUM_POINTS; ++i) {
            double x = Traitement.myList.get(i).getX();
            double y = Traitement.myList.get(i).getY();
            this.points.add(i, new Point(x, y));
        }
        for (i = 0; i < this.NUM_CLUSTERS; ++i) {
            Cluster cluster = new Cluster(i);
            Point centroid = Point.createRandomPoint(this.MIN_X, this.MAX_X, this.MIN_Y, this.MAX_Y);
            cluster.setCentroid(centroid);
            clusters.add(cluster);
        }
        this.plotClusters();
    }

    private void plotClusters() {
        for (int i = 0; i < this.NUM_CLUSTERS; ++i) {
            Cluster c = clusters.get(i);
            c.plotCluster();
        }
    }

    public void calculate() {
        boolean finish = false;
        int iteration = 0;
        while (!finish) {
            this.clearClusters();
            List lastCentroids = this.getCentroids();
            this.assignCluster();
            this.calculateCentroids();
            ++iteration;
            List currentCentroids = this.getCentroids();
            double distance = 0.0;
            for (int i = 0; i < lastCentroids.size(); ++i) {
                distance += Point.distance((Point)lastCentroids.get(i), (Point)currentCentroids.get(i));
            }
            System.out.println("#################");
            System.out.println("Iteration: " + iteration);
            System.out.println("Centroid distances: " + distance);
            this.plotClusters();
            if (distance != 0.0) continue;
            finish = true;
        }
    }

    private void clearClusters() {
        for (Cluster cluster : clusters) {
            cluster.clear();
        }
    }

    private List getCentroids() {
        ArrayList<Point> centroids = new ArrayList<Point>(this.NUM_CLUSTERS);
        for (Cluster cluster : clusters) {
            Point aux = cluster.getCentroid();
            Point point = new Point(aux.getX(), aux.getY());
            centroids.add(point);
        }
        return centroids;
    }

    private void assignCluster() {
        double max;
        double min = max = Double.MAX_VALUE;
        int cluster = 0;
        double distance = 0.0;
        for (Point point : this.points) {
            min = max;
            for (int i = 0; i < this.NUM_CLUSTERS; ++i) {
                Cluster c = clusters.get(i);
                distance = Point.distance(point, c.getCentroid());
                if (!(distance < min)) continue;
                min = distance;
                cluster = i;
            }
            point.setCluster(cluster);
            clusters.get(cluster).addPoint(point);
        }
    }

    private void calculateCentroids() {
        for (Cluster cluster : clusters) {
            double sumX = 0.0;
            double sumY = 0.0;
            List list = cluster.getPoints();
            int n_points = list.size();
            for (Point point : list) {
                sumX += point.getX();
                sumY += point.getY();
            }
            Point centroid = cluster.getCentroid();
            if (n_points <= 0) continue;
            double newX = sumX / (double)n_points;
            double newY = sumY / (double)n_points;
            centroid.setX(newX);
            centroid.setY(newY);
        }
    }

    private void ecriture() throws IOException {
        File ff = new File("traitement.json");
        FileWriter ffw = new FileWriter(ff);
        ffw.write(donnees);
        ffw.close();
    }
}

