﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace SalaireInterface
{
    static class Program
    {
        /// <summary>
        /// Point d'entrée principal de l'application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }
    }

    class Salarié
    {
        /*   Propriétés   */

        private int _Matricule;
        public int Matricule
        {
            get { return _Matricule; }
            set { _Matricule = value; }
        }
        private String _Prénom;
        public String Prénom
        {
            get { return _Prénom; }
            set { _Prénom = value; }
        }
        private String _Nom;
        public String Nom
        {
            get { return _Nom; }
            set { _Nom = value; }
        }
        private double _Salaire;
        public double Salaire
        {
            get { return _Salaire; }
            set { _Salaire = value; }
        }

        /*private double _TauxCS;
        public double TauxCS
        {
            get { return _TauxCS; }
            set { _TauxCS = value; }
        }*/

        static private double TauxCS = 0.34;

        /*  Constructeurs  */

        // Constructeur par défaut
        public Salarié()
        {
            this.Matricule = 0;
            this.Prénom = "inconnu";
            this.Nom = "inconnu";
            this.Salaire = 0;
        }
        // Constructeur qui initialise Matricule
        public Salarié(int matricule)
        {
            this.Matricule = matricule;
            this.Prénom = "inconnu";
            this.Nom = "inconnu";
            this.Salaire = 0;
        }
        // Constructeur qui initialise Matricule et Nom
        public Salarié(int Matricule, String Nom)
        {
            this.Matricule = Matricule;
            this.Nom = Nom;
            this.Prénom = "inconnu";
            this.Salaire = 0;
        }
        // Constructeur de recopie
        public Salarié(Salarié sal)
        {
            this.Matricule = sal.Matricule;
            this.Prénom = sal.Prénom;
            this.Nom = sal.Nom;
            this.Salaire = sal.Salaire;
            //this.TauxCS = sal.TauxCS;
        }

        // Constructeur qui initialise toutes les propriétés
        public Salarié(int Matricule, String Prénom, String Nom, double Salaire/*, double TauxCS*/)
        {
            this.Matricule = Matricule;
            this.Prénom = Prénom;
            this.Nom = Nom;
            this.Salaire = Salaire;
            //this.TauxCS = TauxCS;
        }

        /*   Méthodes   */

        // Méthode qui renvoie le salaire net d'un employé
        public double CalculerSalaireNet()
        {
            return Salaire - (Salaire * TauxCS);
        }
    }
}
