﻿using ExcelLibrary;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ChartsWindowsForms
{
    public partial class Form1 : Form
       
    {
        private ExcelSheet MyDataSheet; // excel sheet that contains the data
        private ExcelSheet MyChartSheet; // excel sheet that contains the charts
        /// <summary>
        /// path to the excel file
        /// Warning : always use an excel file .xls (not .xlsx)
        /// </summary>
        
        // change the value of the path according to directory where you stored the file
        private String path = "C:\\Users\\helen\\Documents\\BAT4\\immotique\\ChartData.xls";

        public Form1()
        {
            InitializeExcel();
            InitializeComponent();
        }

        private void InitializeExcel()
        {
            // the data sheet can be write and read
            MyDataSheet = new ExcelSheet(path, 1, false);
            // the chart sheet is read only
            MyChartSheet = new ExcelSheet(path, 2, true);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Console.WriteLine("click");
            WriteTextInExcel();
            pictureBox1.Image = MyChartSheet.GetChartImage(1);
        }
        private void WriteTextInExcel()
        {
            String val = textBox1.Text;
            if (val != "")
            {
                MyDataSheet.WriteCell(val, "B4");
                MyDataSheet.Save();
                Thread.Sleep(1000);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Console.WriteLine("load");            
            pictureBox1.Image = MyChartSheet.GetChartImage(1);
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            MyDataSheet.Close();
            MyChartSheet.Close();
        }


        //private void textBox1_TextChanged(object sender, EventArgs e)
        //{
        //    String val = textBox1.Text;
        //    if (val != "")
        //    {
        //        MySheet.WriteCell(val, "B4");
        //        MySheet.Save();
        //        Thread.Sleep(1000);
        //        pictureBox1.Image = MySheet.GetChartImage(1);
        //    }
        //}
    }
}
