﻿using System;
using System.Net;
using System.Net.Sockets;

class MyTcpListener
{
    public static void Main()
    {
        // 127.0.0.1 is localhost
        Server("127.0.0.1", 8080);
    }

    // this method takes the data sent by the client and returns the addition of the parameters
    // the data must be a GET request of the form : 
    //         GET /add?val1=x&val2=y HTTP/1.1 where x and y are doubles (e.g. 14,6)
    private static String getAddRequest(string data)
    {
        // we first check the format of the request
        if (!data.StartsWith("GET /add?"))
        {
            return "ERROR : add is expected ";
        }
        if (!data.Contains("val1=") || !data.Contains("val2="))
        {
            return "ERROR : val1= or val2= value is expected ";
        }

        // the request contains the right information so we can parse it
        // IndexOf returns the index of =. For example "hello".IndexOf('o') returns 4
        int deb = data.IndexOf('=');
        int fin1 = data.IndexOf('&');
        int deb2 = data.IndexOf('=', fin1);
        int fin2 = data.IndexOf(' ', deb2);
        // s.Substring(d,n) returns n characters of s starting from deb
        // For example, "hello".Substring(2,3) returns llo
        String sx = data.Substring(deb + 1, fin1 - deb - 1);
        String sy = data.Substring(deb2 + 1, fin2 - deb2 - 1);
        double x, y;
        // double.Tryparse(s,out x) returns true if the string sx corresponds to 
        // a double value. the value is stored in x
        if (!double.TryParse(sx, out x) || !double.TryParse(sy, out y))
        {
            return "ERROR : values are not doubles ";
        }
        // ici on a le bon format, on peut faire l'addition
        String add = sx + " + " + sy + "= " + Convert.ToString(x + y);
        return add;
    }

    public static void ReplytoGETRequest(NetworkStream stream)
    {
        // reading the client request
        Byte[] bytes = new Byte[256];
        int i = stream.Read(bytes, 0, bytes.Length);
        // Translate data bytes to a ASCII string.
        String dataIn = System.Text.Encoding.ASCII.GetString(bytes, 0, i);

        // result will contain the addition if the format of the request is correct
        // or an error message otherwise
        String result = getAddRequest(dataIn);
        String dataOut = "";

        dataOut =
            "HTTP/1.1 200 OK" + "\r\n" +
            "Connection: close" + "\r\n" +
            "\r\n" +
            "<!DOCTYPE html>" + "\r\n" +
            "<html>" + "\r\n" +
            "<head>" + "\r\n" +
            "<title>My first web service</title>" + "\r\n" +
            "</head>" + "\r\n" +
            "<body>" + "\r\n" +
            "The result is <br>" + result + "\r\n" +
            "</body>" + "\r\n" +
            "</html>" + "\r\n" +
            "\r\n";

        Console.WriteLine("Sent: {0}\n", dataOut);

        byte[] msg = System.Text.Encoding.ASCII.GetBytes(dataOut);

        // Send back HTML response.
        stream.Write(msg, 0, msg.Length);

    }

    static void Server(String server_addr, Int32 port)
    {
        TcpListener server = null;

        // Set the TcpListener on port
        IPAddress localAddr = IPAddress.Parse(server_addr);

        // TcpListener server = new TcpListener(port);
        server = new TcpListener(localAddr, port);

        // Start listening for client requests.
        server.Start(1);

        // Buffer for reading data
        Byte[] bytes = new Byte[256];

        // just one request. the stream is closed after use. this is necessary to work on any browser
        {
            Console.Write("Waiting for a connection... ");

            // Perform a blocking call to accept requests.

            TcpClient client = server.AcceptTcpClient();

            Console.WriteLine("Connected!");

            // Get a stream object for reading and writing
            NetworkStream stream = client.GetStream();

            // stream.Flush();
            ReplytoGETRequest(stream);

            // Shutdown and end connection
            Console.WriteLine("\nHit enter before quit...");
            Console.ReadLine();
            client.Close();
        }
    }
}