﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

// -- mettre un raccourci Excel pour remplacer le namespace Microsoft.Office.Interop.Excel dans le code
using Excel = Microsoft.Office.Interop.Excel; 
// --

namespace WindowsFormsApplication3
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // -- Je crée une application Excel 
            Excel.Application xlApp;
            xlApp = new Excel.Application();
            // -- 

            // -- Teste si l'application a bien était créée. Si ça n'est pas le cas et que xlApp == null, c'est très probablement que Excel n'est pas isntallé sur la machine
            if (xlApp == null)
            {
                MessageBox.Show("Excel n'est probablement pas installé correctement !");
                return;
            }

            // Ne pas oublier de recopier le fichier "Formule de calcul excel.xls" sur D: ou de remplacer le chemin
            //"d:\\Formule de calcul excel.xls" dans xlApp.Workbooks.Open par votre propre chemin.Exemple : "c:\\<mon chemin>\\Formule de calcul excel.xls"
            //(les caractères "\" doivent alors être remplacés par "\\")

            // -- J'ouvre un classeur déjà sauvegardé dans le fichier d:\\csharp.net-informations.xls, avec "=A1*2" dans la cellule B1            Excel.Workbook xlWorkBook;
           Excel.Workbook xlWorkBook;
            try
                {
                    xlWorkBook = xlApp.Workbooks.Open("d:\\Temp\\BAT\\Formule de calcul excel.xls", 0, false, 5, "", "", true, Microsoft.Office.Interop.Excel.XlPlatform.xlWindows, "\t", false, false, 0, true, 1, 0);
                }
            // -- 

            // -- Teste si le classeur a bien était créée. Si ça n'est pas le cas et que xlWorkBook == null, c'est très probablement le fichier "d:\\Formule de calcul excel.xls" n'existe pas 
            catch
             {
                        MessageBox.Show("le fichier du classeur n'existe probablement pas !");
                        return;
                }
            // -- fin de test

            //  -- J'ouvre la première feuille du classeur 
            Excel.Worksheet xlWorkSheet;
            xlWorkSheet = (Excel.Worksheet)xlWorkBook.Worksheets.get_Item(1);
            // --

            // COMMENT LIRE ET ECRIRE DANS LES CELLULES D'UNE FEUILLE

            // -- Cells[x,x] que pour écrire dans une cellule (ligne,colonne) donc B1 pour (1,2)
            xlWorkSheet.Cells[2, 1] = textBox1.Text;
            // --

            // -- get_Range("A1").Value pour lire la cellule A1. Attention de bien convertir cette valeur en une chaine de caractère pour l'afficher
            textBox2.Text = xlWorkSheet.get_Range("F2").Value.ToString();
            // --

            // --La ligne ci-dessous permet aussi d'écrire dans la cellule A1
            //xlWorkSheet.get_Range("A1").Value = "=B1";
            // --

            // 
            Excel.Range chartRange;

            Excel.ChartObjects xlCharts = (Excel.ChartObjects)xlWorkSheet.ChartObjects(Type.Missing);
            Excel.ChartObject myChart = (Excel.ChartObject)xlCharts.Add(10, 80, 300, 250);
            Excel.Chart chartPage = myChart.Chart;

            chartRange = xlWorkSheet.get_Range("A1", "F2");
            chartPage.SetSourceData(chartRange);

            // définit le type de figure à créer. Ici le style est "Stacked Column"
            chartPage.ChartType = Excel.XlChartType.xlColumnClustered;
            // --

            //exporte la figure dans le fichier image d:\\Temp\\BAT\\excel_chart_export.bmp
            chartPage.Export("d:\\Temp\\BAT\\excel_chart_export.bmp", "BMP");
            // --

            //insère l'image sauvgardée dans d:\\excel_chart_export.bmp, dans la picturebox
            if (pictureBox1.Image==null) pictureBox1.Image = new Bitmap("d:\\Temp\\BAT\\excel_chart_export.bmp");
            // --

            // LES SAUVEGARDES

            // -- sauvegarde dans le même fichier que celui qui a été ouvert. Ici on ne sauvegarde pas le fichier pour le conserver tel qu'il est fourni avec les cellules de calcul initiales.
             xlWorkBook.Save();
            // --

            // -- FERMETURE du CLASSEUR  sans le sauvegarger (paramètre false). Le classeur nous sert ici qu'à implémenter les fomules de calcul
            xlWorkBook.Close(false);
            // --

            // -- FERMETURE de l'APPLICATION EXCEL
            xlApp.Quit();
            // --
        }



        private void Form1_Load(object sender, EventArgs e) 
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {
            // -- FERMETURE de l'APPLICATION GRAPHIQUE
            Application.Exit();
            // --
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {

        }
    }
}
