package fr.unice.polytech.ocs.connectedwavews.business;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;

/**
 * Created by Benjamin Bourgeois on 26/11/2014 16:52.
 */
public class Weather {

    private String urlWeatherJSON;
    private JSONObject weatherJSONObject;

    public Weather(String urlWeatherJSON) {
        this.urlWeatherJSON = urlWeatherJSON;
        this.weatherJSONObject = getWeatherJSON(urlWeatherJSON);
    }

    public Weather() {
        this.urlWeatherJSON = "http://api.openweathermap.org/data/2.5/weather?q=Nice,fr";
        this.weatherJSONObject = getWeatherJSON(urlWeatherJSON);
    }

    public String getUrlWeatherJSON() {
        return urlWeatherJSON;
    }

    public void setUrlWeatherJSON(String urlWeatherJSON) {
        this.urlWeatherJSON = urlWeatherJSON;
        this.weatherJSONObject = getWeatherJSON(urlWeatherJSON);
    }

    public JSONObject getWeatherJSONObject() {
        return weatherJSONObject;
    }

    private JSONObject getWeatherJSON(String url) {
        try {
            InputStream is = new URL(url).openStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is,
                    Charset.forName("UTF-8")));
            String jsonText = readAll(rd);
            is.close();
            JSONObject json = new JSONObject(jsonText);
            return json;
        } catch (MalformedURLException e) {
            System.err
                    .println("The url given is not valid : " + e.getMessage());
        } catch (Exception e) {
            System.err
                    .println("An error occurred while reading the content of the url : "
                            + e.getMessage());
        }
        return null;
    }

    private String readAll(Reader rd) throws IOException {
        StringBuilder sb = new StringBuilder();
        int cp;
        while ((cp = rd.read()) != -1) {
            sb.append((char) cp);
        }
        return sb.toString();
    }

    public JSONObject getWeatherMain(int index) throws JSONException {
        JSONObject toReturn = null;
        try {
            toReturn = ((JSONArray) this.weatherJSONObject.get("weather"))
                    .getJSONObject(index);
        } catch (JSONException e) {
        }
        return toReturn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof Weather))
            return false;

        Weather that = (Weather) o;

        if (!urlWeatherJSON.equals(that.urlWeatherJSON))
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        return urlWeatherJSON.hashCode();
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder(
                "WeatherToTimelineJSONFormat{");
        sb.append("urlWeatherJSON='").append(urlWeatherJSON).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
