package fr.unice.polytech.ocs.connectedwavews.services;

import org.json.JSONObject;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;

public class WeatherAlertWSImpl implements WeatherAlertWS {

    @Override
    public int getWeather() {

        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("New request getWeather? at: " + sdf.format(cal.getTime()));

        try {
            // Defines URL
            String baseURL = "http://api.openweathermap.org/data/2.5/weather?";
            String paramsByName = baseURL + "q=Paris,fr";
            String lat = "43.610318";
            String lon = "7.136249";
            String paramsByCoord = baseURL + "lat=" + lat + "&lon=" + lon;

            // Si on veut du beau temps : Baie des Anges
            // String url = paramsByCoord;
            // Si on veut un temps pourri
            String url = paramsByName;

            // Connexion
            URL obj = null;
            obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection) obj.openConnection();
            // Response reading
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String inputLine;
            StringBuffer response = new StringBuffer();

            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();

            /** Write into test file
            String filePath = System.getProperty("user.dir") + "/../../outputs/WeatherJSONres.json";
            BufferedWriter bwr = new BufferedWriter(new FileWriter(new File(filePath)));
            bwr.write(response.toString());
            bwr.close();
             */
            String weatherResJSON = response.toString();

            // Display
            // result.setWeatherAlertResult(result.getWeatherAlertResult() + weatherResJSON);

            // Transform result into an object
            // Weather json object
            JSONObject weatherJSON = new JSONObject(weatherResJSON);
            int res = checkWeatherConditions(weatherJSON);
            return res;

        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return -1;
    }

    /**
     *
     * @param weatherJSONobj
     * @return 0 if good weather
     *          1 if orange alert
     *          2 if red alert
     */
    private int checkWeatherConditions (JSONObject weatherJSONobj) {
        String test = "";
        // Load objects and elements
        JSONObject weatherObj = (JSONObject) weatherJSONobj.getJSONArray("weather").get(0);
        String weatherDescription = weatherObj.getString("description");
        String weatherMain = weatherObj.getString("main");
        /*
        Iterator t = weatherJSONobj.keys();
        while ( t.hasNext() ) {
            System.out.println("\t\t\t KEY? " + t.next());
        }
        */
        JSONObject mainObj = (JSONObject) weatherJSONobj.get("main");
        double weatherPressure = (double) mainObj.get("pressure");
        JSONObject windObj = (JSONObject) weatherJSONobj.get("wind");
        double windSpeed = (double) windObj.get("speed");
        JSONObject cloudsObj = (JSONObject) weatherJSONobj.get("clouds");
        int cloudsAll = (int) cloudsObj.get("all");
        // Display
        /**
        test = " ===== Current weather ===== "
                + "\n\t*** weatherDescription: " + weatherDescription
                + "\n\t*** weatherMain: " + weatherMain
                + "\n\t*** weatherPressure: " + weatherPressure
                + "\n\t*** windSpeed: " + windSpeed
                + "\n\t*** cloudsAll: " + cloudsAll;
        System.out.println("\t\tAll JSON datas loaded: " + test);
         */

        int res = 0;
        // wind, speed
        if ( windSpeed > 80 )
        {
            if ( windSpeed > 100 ) {
                System.out.println("\t> windSpeed > 100");
                return 2;
            } else {
                System.out.println("\t> windSpeed > 80");
                res = 1;
            }
        }
        // clouds, all Cloudiness in %
        if ( cloudsAll > 70 ) {
            System.out.println("\t> cloudsAll > 70");
            res = 1;
        }
        // main, pressure (Atmospheric pressure (on the sea level))
        if ( weatherPressure < 1000 ) {
            if ( weatherPressure < 990 ) {
                System.out.println("\t> weatherPressure < 990");
                return 2;
            } else {
                System.out.println("\t> weatherPressure < 100");
                res = 1;
            }
        }
        // main elements
        if ( weatherMain.equals("Clouds") ) {
            System.out.println("\t> weatherMain == Clouds");
            res = 1;
        }
        return res;
    }


    @Override
    public boolean getTsunamiAlert() {
        return false;
    }

}
