package fr.unice.polytech.ocs.connectedwavews.utils;

/**
 * Tests values
 */

public class Utils {

    // GPS coordinates perimeter (+-)
    private static final double sharkPerimeter = 0.25;
    private static final double fallPerimeter = 0.08;

    // North/South
    private static final double latitude = 43.610318;
    // East/West
    private static final double longitude = 7.136249;


    // Test coordinates
    private double latitudeTest = 43.386169;
    private double longitudeTest = 7.386242;


    public Utils() {}


    // Final values getters
    public double getLatitude() {
        return latitude;
    }
    public double getLongitude() {
        return longitude;
    }
    public double getSharkPerimeter() { return sharkPerimeter; }
    public double getFallPerimeter() { return fallPerimeter; }

    // Tests values getters
    public double getLatitudeTest() {
        return latitudeTest;
    }
    public double getLongitudeTest() {
        return longitudeTest;
    }

    public static boolean checkIfInPerimeterShark (double lat, double lon) {

        if ( (lat > (latitude - sharkPerimeter))
                & (lat < (latitude + sharkPerimeter)) ) { // if true, we check the longitude interval

            if ( (lon > (longitude - sharkPerimeter))
                    & (lon < (longitude + sharkPerimeter)) ) { // if true, he's in the alert perimeter
                return true;
            }

        }
        return false;
    }

    public static boolean checkIfInPerimeterFall (double lat, double lon) {

        if ( (lat > (latitude - fallPerimeter))
                & (lat < (latitude + fallPerimeter)) ) { // if true, we check the longitude interval

            if ( (lon > (longitude - fallPerimeter))
                    & (lon < (longitude + fallPerimeter)) ) { // if true, he's in the alert perimeter
                return true;
            }

        }
        return false;
    }

}
