package fr.unice.polytech.ocs.connectedwavews.business;

import javax.ejb.Singleton;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
@XmlRootElement(name = "fall_alert")
@Singleton
public class FallAlert {

    // GPS coordinates
    private double latitude;
    private double longitude;


    public FallAlert() {}

    public FallAlert(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }


    @XmlAttribute(name="longitude")
    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    @XmlAttribute(name="latitude")
    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

}
