package fr.unice.polytech.ocs.connectedwavews.persistance;

import fr.unice.polytech.ocs.connectedwavews.business.FallAlert;
import fr.unice.polytech.ocs.connectedwavews.business.SharkAlert;
import fr.unice.polytech.ocs.connectedwavews.utils.Utils;

import javax.ejb.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton(name = "ConnectedWave-DB-Mock")
public class DAO {

    // SHARK
    private List<SharkAlert> listSharkAlert;
    // FALL
    private List<FallAlert> listFallAlert;

    public DAO() { init(); }

    private void init() {

        Utils tools = new Utils();

        listSharkAlert = new ArrayList<SharkAlert>();
        // listSharkAlert.add(new SharkAlert(tools.getLatitude(), tools.getLongitude()));


        listFallAlert = new ArrayList<FallAlert>();
        // listFallAlert.add(new FallAlert(tools.getLatitude(), tools.getLongitude()));

    }


    // SHARK
    public List<SharkAlert> getSharkAlert() {
        return this.listSharkAlert;
    }
    public void setSharkAlert(List<SharkAlert> newlist) { this.listSharkAlert = newlist; }
    public void addSharkAlert(double lat, double lon) {
        this.listSharkAlert.add(new SharkAlert(lat, lon));
    }
    public void removeSharkAlert(double lat, double lon) {
        for ( SharkAlert sa : this.listSharkAlert ) {
            if ( sa.getLatitude() == lat ) {
                if ( sa.getLongitude() == lon )
                    this.listSharkAlert.remove(sa);
            }
        }
    }

    // FALL
    public List<FallAlert> getFallAlert() {
        return this.listFallAlert;
    }
    public void setFallAlert(List<FallAlert> newlist) { this.listFallAlert = newlist; }
    public void addFallAlert(double lat, double lon) {
        this.listFallAlert.add(new FallAlert(lat, lon));
    }
    public void removeFallAlert(double lat, double lon) {
        for ( FallAlert fa : this.listFallAlert ) {
            if ( fa.getLatitude() == lat ) {
                if ( fa.getLongitude() == lon )
                    this.listSharkAlert.remove(fa);
            }
        }
    }

}
