package fr.unice.polytech.ocs.connectedwavews.services;

import fr.unice.polytech.ocs.connectedwavews.business.FallAlert;
import fr.unice.polytech.ocs.connectedwavews.business.SharkAlert;
import fr.unice.polytech.ocs.connectedwavews.persistance.DAO;
import fr.unice.polytech.ocs.connectedwavews.utils.Utils;

import javax.ejb.EJB;
import javax.ws.rs.PathParam;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class FallAlertWSImpl implements FallAlertWS {

    @EJB
    private DAO dao;

    @Override
    public String getAlert() {
        String result = new String();

        boolean alert;
        if ( dao.getFallAlert().size() > 0 ) alert = true;
        else alert = false;

        result.concat("---------- Current alert? " + alert + " ---------- [Fall Alert]");
        if ( alert ) {
            Utils tools = new Utils();
            double latitude_test = tools.getLatitudeTest();
            double longitude_test = tools.getLongitudeTest();

            boolean perimeterPresence = Utils.checkIfInPerimeterFall(latitude_test, longitude_test);
            result.concat("\nAre you in the alert perimeter? " + perimeterPresence + " ---------- [Shark Alert]");
        }

        return result;
    }

    @Override
    public boolean helpASurfer() {

        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("New request helpASurfer? at: " + sdf.format(cal.getTime()));

        boolean help = false;

        for ( FallAlert fa : dao.getFallAlert() ) {
            if ( Utils.checkIfInPerimeterFall(fa.getLatitude(), fa.getLongitude()) ) {
                help = true;
                break;
            }
        }

        return help;
    }

    @Override
    public String setAlert(double lat, double lon) {
        String result = new String();
        result.concat("---------- /!\\ NEW ALERT /!\\ ---------- [Fall Alert]");
        dao.addFallAlert(lat, lon);
        return result;
    }

    @Override
    public void setAlertWithoutCoordinates () {

        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("New Fall Alert (setAlertWithoutCoordinates) at: " + sdf.format(cal.getTime()));

        Utils tools = new Utils();
        String result = new String();
        result.concat("---------- /!\\ NEW ALERT (WithoutCoordinates) /!\\ ---------- [Shark Alert]");
        dao.addFallAlert(tools.getLatitude(), tools.getLongitude());
        // return result;
    }

    @Override
    public void removeAllAlerts() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        System.out.println("[ - ] Fall Alerts release at: " + sdf.format(cal.getTime()));
        dao.getFallAlert().clear();
    }
}
